/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.metastore;

import com.facebook.fb303.FacebookBase;
import com.facebook.fb303.fb_status;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Multimaps;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Formatter;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.regex.Pattern;
import javax.jdo.JDOException;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.lang.StringUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.common.FileUtils;
import org.apache.hadoop.hive.common.JvmPauseMonitor;
import org.apache.hadoop.hive.common.LogUtils;
import org.apache.hadoop.hive.common.classification.InterfaceAudience;
import org.apache.hadoop.hive.common.classification.InterfaceStability;
import org.apache.hadoop.hive.common.cli.CommonCliOptions;
import org.apache.hadoop.hive.common.metrics.common.Metrics;
import org.apache.hadoop.hive.common.metrics.common.MetricsFactory;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.AlterHandler;
import org.apache.hadoop.hive.metastore.Deadline;
import org.apache.hadoop.hive.metastore.HiveAlterHandler;
import org.apache.hadoop.hive.metastore.HiveMetaException;
import org.apache.hadoop.hive.metastore.HouseKeeperService;
import org.apache.hadoop.hive.metastore.IHMSHandler;
import org.apache.hadoop.hive.metastore.MetaStoreEndFunctionContext;
import org.apache.hadoop.hive.metastore.MetaStoreEndFunctionListener;
import org.apache.hadoop.hive.metastore.MetaStoreEventListener;
import org.apache.hadoop.hive.metastore.MetaStoreInit;
import org.apache.hadoop.hive.metastore.MetaStoreInitContext;
import org.apache.hadoop.hive.metastore.MetaStoreInitListener;
import org.apache.hadoop.hive.metastore.MetaStorePreEventListener;
import org.apache.hadoop.hive.metastore.MetaStoreThread;
import org.apache.hadoop.hive.metastore.MetaStoreUtils;
import org.apache.hadoop.hive.metastore.RawStore;
import org.apache.hadoop.hive.metastore.RawStoreProxy;
import org.apache.hadoop.hive.metastore.RetryingHMSHandler;
import org.apache.hadoop.hive.metastore.SessionPropertiesListener;
import org.apache.hadoop.hive.metastore.TServerSocketKeepAlive;
import org.apache.hadoop.hive.metastore.TSetIpAddressProcessor;
import org.apache.hadoop.hive.metastore.TUGIBasedProcessor;
import org.apache.hadoop.hive.metastore.TableType;
import org.apache.hadoop.hive.metastore.TransactionalValidationListener;
import org.apache.hadoop.hive.metastore.Warehouse;
import org.apache.hadoop.hive.metastore.api.AbortTxnRequest;
import org.apache.hadoop.hive.metastore.api.AddDynamicPartitions;
import org.apache.hadoop.hive.metastore.api.AddPartitionsRequest;
import org.apache.hadoop.hive.metastore.api.AddPartitionsResult;
import org.apache.hadoop.hive.metastore.api.AggrStats;
import org.apache.hadoop.hive.metastore.api.AlreadyExistsException;
import org.apache.hadoop.hive.metastore.api.CheckLockRequest;
import org.apache.hadoop.hive.metastore.api.ClearFileMetadataRequest;
import org.apache.hadoop.hive.metastore.api.ClearFileMetadataResult;
import org.apache.hadoop.hive.metastore.api.ColumnStatistics;
import org.apache.hadoop.hive.metastore.api.ColumnStatisticsDesc;
import org.apache.hadoop.hive.metastore.api.ColumnStatisticsObj;
import org.apache.hadoop.hive.metastore.api.CommitTxnRequest;
import org.apache.hadoop.hive.metastore.api.CompactionRequest;
import org.apache.hadoop.hive.metastore.api.ConfigValSecurityException;
import org.apache.hadoop.hive.metastore.api.CurrentNotificationEventId;
import org.apache.hadoop.hive.metastore.api.Database;
import org.apache.hadoop.hive.metastore.api.DropPartitionsExpr;
import org.apache.hadoop.hive.metastore.api.DropPartitionsRequest;
import org.apache.hadoop.hive.metastore.api.DropPartitionsResult;
import org.apache.hadoop.hive.metastore.api.EnvironmentContext;
import org.apache.hadoop.hive.metastore.api.FieldSchema;
import org.apache.hadoop.hive.metastore.api.FileMetadataExprType;
import org.apache.hadoop.hive.metastore.api.FireEventRequest;
import org.apache.hadoop.hive.metastore.api.FireEventRequestData;
import org.apache.hadoop.hive.metastore.api.FireEventResponse;
import org.apache.hadoop.hive.metastore.api.Function;
import org.apache.hadoop.hive.metastore.api.GetAllFunctionsResponse;
import org.apache.hadoop.hive.metastore.api.GetFileMetadataByExprRequest;
import org.apache.hadoop.hive.metastore.api.GetFileMetadataByExprResult;
import org.apache.hadoop.hive.metastore.api.GetFileMetadataRequest;
import org.apache.hadoop.hive.metastore.api.GetFileMetadataResult;
import org.apache.hadoop.hive.metastore.api.GetOpenTxnsInfoResponse;
import org.apache.hadoop.hive.metastore.api.GetOpenTxnsResponse;
import org.apache.hadoop.hive.metastore.api.GetPrincipalsInRoleRequest;
import org.apache.hadoop.hive.metastore.api.GetPrincipalsInRoleResponse;
import org.apache.hadoop.hive.metastore.api.GetRoleGrantsForPrincipalRequest;
import org.apache.hadoop.hive.metastore.api.GetRoleGrantsForPrincipalResponse;
import org.apache.hadoop.hive.metastore.api.GrantRevokePrivilegeRequest;
import org.apache.hadoop.hive.metastore.api.GrantRevokePrivilegeResponse;
import org.apache.hadoop.hive.metastore.api.GrantRevokeRoleRequest;
import org.apache.hadoop.hive.metastore.api.GrantRevokeRoleResponse;
import org.apache.hadoop.hive.metastore.api.HeartbeatRequest;
import org.apache.hadoop.hive.metastore.api.HeartbeatTxnRangeRequest;
import org.apache.hadoop.hive.metastore.api.HeartbeatTxnRangeResponse;
import org.apache.hadoop.hive.metastore.api.HiveObjectPrivilege;
import org.apache.hadoop.hive.metastore.api.HiveObjectRef;
import org.apache.hadoop.hive.metastore.api.HiveObjectType;
import org.apache.hadoop.hive.metastore.api.Index;
import org.apache.hadoop.hive.metastore.api.InvalidInputException;
import org.apache.hadoop.hive.metastore.api.InvalidObjectException;
import org.apache.hadoop.hive.metastore.api.InvalidOperationException;
import org.apache.hadoop.hive.metastore.api.InvalidPartitionException;
import org.apache.hadoop.hive.metastore.api.LockRequest;
import org.apache.hadoop.hive.metastore.api.LockResponse;
import org.apache.hadoop.hive.metastore.api.MetaException;
import org.apache.hadoop.hive.metastore.api.MetadataPpdResult;
import org.apache.hadoop.hive.metastore.api.NoSuchLockException;
import org.apache.hadoop.hive.metastore.api.NoSuchObjectException;
import org.apache.hadoop.hive.metastore.api.NoSuchTxnException;
import org.apache.hadoop.hive.metastore.api.NotificationEventRequest;
import org.apache.hadoop.hive.metastore.api.NotificationEventResponse;
import org.apache.hadoop.hive.metastore.api.OpenTxnRequest;
import org.apache.hadoop.hive.metastore.api.OpenTxnsResponse;
import org.apache.hadoop.hive.metastore.api.Partition;
import org.apache.hadoop.hive.metastore.api.PartitionEventType;
import org.apache.hadoop.hive.metastore.api.PartitionListComposingSpec;
import org.apache.hadoop.hive.metastore.api.PartitionSpec;
import org.apache.hadoop.hive.metastore.api.PartitionSpecWithSharedSD;
import org.apache.hadoop.hive.metastore.api.PartitionWithoutSD;
import org.apache.hadoop.hive.metastore.api.PartitionsByExprRequest;
import org.apache.hadoop.hive.metastore.api.PartitionsByExprResult;
import org.apache.hadoop.hive.metastore.api.PartitionsStatsRequest;
import org.apache.hadoop.hive.metastore.api.PartitionsStatsResult;
import org.apache.hadoop.hive.metastore.api.PrincipalPrivilegeSet;
import org.apache.hadoop.hive.metastore.api.PrincipalType;
import org.apache.hadoop.hive.metastore.api.PrivilegeBag;
import org.apache.hadoop.hive.metastore.api.PrivilegeGrantInfo;
import org.apache.hadoop.hive.metastore.api.PutFileMetadataRequest;
import org.apache.hadoop.hive.metastore.api.PutFileMetadataResult;
import org.apache.hadoop.hive.metastore.api.RequestPartsSpec;
import org.apache.hadoop.hive.metastore.api.Role;
import org.apache.hadoop.hive.metastore.api.RolePrincipalGrant;
import org.apache.hadoop.hive.metastore.api.SetPartitionsStatsRequest;
import org.apache.hadoop.hive.metastore.api.ShowCompactRequest;
import org.apache.hadoop.hive.metastore.api.ShowCompactResponse;
import org.apache.hadoop.hive.metastore.api.ShowLocksRequest;
import org.apache.hadoop.hive.metastore.api.ShowLocksResponse;
import org.apache.hadoop.hive.metastore.api.SkewedInfo;
import org.apache.hadoop.hive.metastore.api.StorageDescriptor;
import org.apache.hadoop.hive.metastore.api.Table;
import org.apache.hadoop.hive.metastore.api.TableMeta;
import org.apache.hadoop.hive.metastore.api.TableStatsRequest;
import org.apache.hadoop.hive.metastore.api.TableStatsResult;
import org.apache.hadoop.hive.metastore.api.ThriftHiveMetastore;
import org.apache.hadoop.hive.metastore.api.TxnAbortedException;
import org.apache.hadoop.hive.metastore.api.TxnOpenException;
import org.apache.hadoop.hive.metastore.api.Type;
import org.apache.hadoop.hive.metastore.api.UnknownDBException;
import org.apache.hadoop.hive.metastore.api.UnknownPartitionException;
import org.apache.hadoop.hive.metastore.api.UnknownTableException;
import org.apache.hadoop.hive.metastore.api.UnlockRequest;
import org.apache.hadoop.hive.metastore.events.AddIndexEvent;
import org.apache.hadoop.hive.metastore.events.AddPartitionEvent;
import org.apache.hadoop.hive.metastore.events.AlterIndexEvent;
import org.apache.hadoop.hive.metastore.events.AlterPartitionEvent;
import org.apache.hadoop.hive.metastore.events.AlterTableEvent;
import org.apache.hadoop.hive.metastore.events.ConfigChangeEvent;
import org.apache.hadoop.hive.metastore.events.CreateDatabaseEvent;
import org.apache.hadoop.hive.metastore.events.CreateTableEvent;
import org.apache.hadoop.hive.metastore.events.DropDatabaseEvent;
import org.apache.hadoop.hive.metastore.events.DropIndexEvent;
import org.apache.hadoop.hive.metastore.events.DropPartitionEvent;
import org.apache.hadoop.hive.metastore.events.DropTableEvent;
import org.apache.hadoop.hive.metastore.events.EventCleanerTask;
import org.apache.hadoop.hive.metastore.events.InsertEvent;
import org.apache.hadoop.hive.metastore.events.LoadPartitionDoneEvent;
import org.apache.hadoop.hive.metastore.events.PreAddIndexEvent;
import org.apache.hadoop.hive.metastore.events.PreAddPartitionEvent;
import org.apache.hadoop.hive.metastore.events.PreAlterIndexEvent;
import org.apache.hadoop.hive.metastore.events.PreAlterPartitionEvent;
import org.apache.hadoop.hive.metastore.events.PreAlterTableEvent;
import org.apache.hadoop.hive.metastore.events.PreAuthorizationCallEvent;
import org.apache.hadoop.hive.metastore.events.PreCreateDatabaseEvent;
import org.apache.hadoop.hive.metastore.events.PreCreateTableEvent;
import org.apache.hadoop.hive.metastore.events.PreDropDatabaseEvent;
import org.apache.hadoop.hive.metastore.events.PreDropIndexEvent;
import org.apache.hadoop.hive.metastore.events.PreDropPartitionEvent;
import org.apache.hadoop.hive.metastore.events.PreDropTableEvent;
import org.apache.hadoop.hive.metastore.events.PreEventContext;
import org.apache.hadoop.hive.metastore.events.PreLoadPartitionDoneEvent;
import org.apache.hadoop.hive.metastore.events.PreReadDatabaseEvent;
import org.apache.hadoop.hive.metastore.events.PreReadTableEvent;
import org.apache.hadoop.hive.metastore.partition.spec.PartitionSpecProxy;
import org.apache.hadoop.hive.metastore.txn.TxnHandler;
import org.apache.hadoop.hive.serde2.Deserializer;
import org.apache.hadoop.hive.serde2.SerDeException;
import org.apache.hadoop.hive.shims.HadoopShims;
import org.apache.hadoop.hive.shims.ShimLoader;
import org.apache.hadoop.hive.shims.Utils;
import org.apache.hadoop.hive.thrift.HadoopThriftAuthBridge;
import org.apache.hadoop.hive.thrift.TUGIContainingTransport;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.util.ReflectionUtils;
import org.apache.hive.common.util.HiveStringUtils;
import org.apache.thrift.TException;
import org.apache.thrift.TProcessor;
import org.apache.thrift.protocol.TBinaryProtocol;
import org.apache.thrift.protocol.TCompactProtocol;
import org.apache.thrift.protocol.TProtocol;
import org.apache.thrift.protocol.TProtocolFactory;
import org.apache.thrift.server.ServerContext;
import org.apache.thrift.server.TServer;
import org.apache.thrift.server.TServerEventHandler;
import org.apache.thrift.server.TThreadPoolServer;
import org.apache.thrift.transport.TFramedTransport;
import org.apache.thrift.transport.TServerSocket;
import org.apache.thrift.transport.TTransport;
import org.apache.thrift.transport.TTransportFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HiveMetaStore
extends ThriftHiveMetastore {
    public static final Logger LOG = LoggerFactory.getLogger(HiveMetaStore.class);
    private static boolean isMetaStoreRemote = false;
    @VisibleForTesting
    static boolean TEST_TIMEOUT_ENABLED = false;
    @VisibleForTesting
    static long TEST_TIMEOUT_VALUE = -1L;
    public static final ThreadLocal<DateFormat> PARTITION_DATE_FORMAT = new ThreadLocal<DateFormat>(){

        @Override
        protected DateFormat initialValue() {
            SimpleDateFormat val = new SimpleDateFormat("yyyy-MM-dd");
            val.setLenient(false);
            return val;
        }
    };
    public static final String ADMIN = "admin";
    public static final String PUBLIC = "public";
    private static HadoopThriftAuthBridge.Server saslServer;
    private static boolean useSasl;
    private static int nextThreadId;

    public static IHMSHandler newRetryingHMSHandler(IHMSHandler baseHandler, HiveConf hiveConf) throws MetaException {
        return HiveMetaStore.newRetryingHMSHandler(baseHandler, hiveConf, false);
    }

    public static IHMSHandler newRetryingHMSHandler(IHMSHandler baseHandler, HiveConf hiveConf, boolean local) throws MetaException {
        return RetryingHMSHandler.getProxy(hiveConf, baseHandler, local);
    }

    public static ThriftHiveMetastore.Iface newRetryingHMSHandler(String name, HiveConf conf, boolean local) throws MetaException {
        HMSHandler baseHandler = new HMSHandler(name, conf, false);
        return RetryingHMSHandler.getProxy(conf, baseHandler, local);
    }

    public static void cancelDelegationToken(String tokenStrForm) throws IOException {
        saslServer.cancelDelegationToken(tokenStrForm);
    }

    public static String getDelegationToken(String owner, String renewer) throws IOException, InterruptedException {
        return saslServer.getDelegationToken(owner, renewer);
    }

    public static boolean isMetaStoreRemote() {
        return isMetaStoreRemote;
    }

    public static long renewDelegationToken(String tokenStrForm) throws IOException {
        return saslServer.renewDelegationToken(tokenStrForm);
    }

    public static void main(String[] args) throws Throwable {
        HiveConf.setLoadMetastoreConfig(true);
        final HiveConf conf = new HiveConf(HMSHandler.class);
        HiveMetastoreCli cli = new HiveMetastoreCli(conf);
        cli.parse(args);
        final boolean isCliVerbose = cli.isVerbose();
        Properties hiveconf = cli.addHiveconfToSystemProperties();
        if (System.getProperty("log4j.configurationFile") == null) {
            try {
                LogUtils.initHiveLog4j();
            }
            catch (LogUtils.LogInitializationException e) {
                HMSHandler.LOG.warn(e.getMessage());
            }
        }
        try {
            String msg = "Starting hive metastore on port " + cli.port;
            HMSHandler.LOG.info(msg);
            if (cli.isVerbose()) {
                System.err.println(msg);
            }
            for (Map.Entry<Object, Object> item : hiveconf.entrySet()) {
                conf.set((String)item.getKey(), (String)item.getValue());
            }
            Runtime.getRuntime().addShutdownHook(new Thread(){

                @Override
                public void run() {
                    String shutdownMsg = "Shutting down hive metastore.";
                    HMSHandler.LOG.info(shutdownMsg);
                    if (isCliVerbose) {
                        System.err.println(shutdownMsg);
                    }
                    if (conf.getBoolVar(HiveConf.ConfVars.METASTORE_METRICS)) {
                        try {
                            MetricsFactory.close();
                        }
                        catch (Exception e) {
                            LOG.error("error in Metrics deinit: " + e.getClass().getName() + " " + e.getMessage(), (Throwable)e);
                        }
                    }
                }
            });
            if (conf.getBoolVar(HiveConf.ConfVars.METASTORE_METRICS)) {
                try {
                    MetricsFactory.init(conf);
                }
                catch (Exception e) {
                    LOG.error("error in Metrics init: " + e.getClass().getName() + " " + e.getMessage(), (Throwable)e);
                }
            }
            ReentrantLock startLock = new ReentrantLock();
            Condition startCondition = startLock.newCondition();
            AtomicBoolean startedServing = new AtomicBoolean();
            HiveMetaStore.startMetaStoreThreads(conf, startLock, startCondition, startedServing);
            HiveMetaStore.startMetaStore(cli.getPort(), ShimLoader.getHadoopThriftAuthBridge(), conf, startLock, startCondition, startedServing);
        }
        catch (Throwable t) {
            HMSHandler.LOG.error("Metastore Thrift Server threw an exception...", t);
            throw t;
        }
    }

    public static void startMetaStore(int port, HadoopThriftAuthBridge bridge) throws Throwable {
        HiveMetaStore.startMetaStore(port, bridge, new HiveConf(HMSHandler.class), null, null, null);
    }

    public static void startMetaStore(int port, HadoopThriftAuthBridge bridge, HiveConf conf) throws Throwable {
        HiveMetaStore.startMetaStore(port, bridge, conf, null, null, null);
    }

    public static void startMetaStore(int port, HadoopThriftAuthBridge bridge, HiveConf conf, Lock startLock, Condition startCondition, AtomicBoolean startedServing) throws Throwable {
        try {
            TProcessor processor;
            TTransportFactory transFactory;
            TProtocolFactory inputProtoFactory;
            TProtocolFactory protocolFactory;
            isMetaStoreRemote = true;
            long maxMessageSize = conf.getIntVar(HiveConf.ConfVars.METASTORESERVERMAXMESSAGESIZE);
            int minWorkerThreads = conf.getIntVar(HiveConf.ConfVars.METASTORESERVERMINTHREADS);
            int maxWorkerThreads = conf.getIntVar(HiveConf.ConfVars.METASTORESERVERMAXTHREADS);
            boolean tcpKeepAlive = conf.getBoolVar(HiveConf.ConfVars.METASTORE_TCP_KEEP_ALIVE);
            boolean useFramedTransport = conf.getBoolVar(HiveConf.ConfVars.METASTORE_USE_THRIFT_FRAMED_TRANSPORT);
            boolean useCompactProtocol = conf.getBoolVar(HiveConf.ConfVars.METASTORE_USE_THRIFT_COMPACT_PROTOCOL);
            useSasl = conf.getBoolVar(HiveConf.ConfVars.METASTORE_USE_THRIFT_SASL);
            if (useCompactProtocol) {
                protocolFactory = new TCompactProtocol.Factory();
                inputProtoFactory = new TCompactProtocol.Factory(maxMessageSize, maxMessageSize);
            } else {
                protocolFactory = new TBinaryProtocol.Factory();
                inputProtoFactory = new TBinaryProtocol.Factory(true, true, maxMessageSize, maxMessageSize);
            }
            HMSHandler baseHandler = new HMSHandler("new db based metaserver", conf, false);
            IHMSHandler handler = HiveMetaStore.newRetryingHMSHandler(baseHandler, conf);
            if (useSasl) {
                if (useFramedTransport) {
                    throw new HiveMetaException("Framed transport is not supported with SASL enabled.");
                }
                saslServer = bridge.createServer(conf.getVar(HiveConf.ConfVars.METASTORE_KERBEROS_KEYTAB_FILE), conf.getVar(HiveConf.ConfVars.METASTORE_KERBEROS_PRINCIPAL));
                saslServer.startDelegationTokenSecretManager(conf, baseHandler, HadoopThriftAuthBridge.Server.ServerMode.METASTORE);
                transFactory = saslServer.createTransportFactory(MetaStoreUtils.getMetaStoreSaslProperties(conf));
                processor = saslServer.wrapProcessor(new ThriftHiveMetastore.Processor<IHMSHandler>(handler));
                LOG.info("Starting DB backed MetaStore Server in Secure Mode");
            } else if (conf.getBoolVar(HiveConf.ConfVars.METASTORE_EXECUTE_SET_UGI)) {
                transFactory = useFramedTransport ? new ChainedTTransportFactory(new TFramedTransport.Factory(), new TUGIContainingTransport.Factory()) : new TUGIContainingTransport.Factory();
                processor = new TUGIBasedProcessor<IHMSHandler>(handler);
                LOG.info("Starting DB backed MetaStore Server with SetUGI enabled");
            } else {
                transFactory = useFramedTransport ? new TFramedTransport.Factory() : new TTransportFactory();
                processor = new TSetIpAddressProcessor<IHMSHandler>(handler);
                LOG.info("Starting DB backed MetaStore Server");
            }
            TServerSocket serverTransport = tcpKeepAlive ? new TServerSocketKeepAlive(port) : new TServerSocket(port);
            TThreadPoolServer.Args args = ((TThreadPoolServer.Args)((TThreadPoolServer.Args)((TThreadPoolServer.Args)((TThreadPoolServer.Args)new TThreadPoolServer.Args(serverTransport).processor(processor)).transportFactory(transFactory)).protocolFactory(protocolFactory)).inputProtocolFactory(inputProtoFactory)).minWorkerThreads(minWorkerThreads).maxWorkerThreads(maxWorkerThreads);
            TThreadPoolServer tServer = new TThreadPoolServer(args);
            TServerEventHandler tServerEventHandler = new TServerEventHandler(){

                @Override
                public void preServe() {
                }

                @Override
                public ServerContext createContext(TProtocol tProtocol, TProtocol tProtocol1) {
                    try {
                        Metrics metrics = MetricsFactory.getInstance();
                        if (metrics != null) {
                            metrics.incrementCounter("open_connections");
                        }
                    }
                    catch (Exception e) {
                        LOG.warn("Error Reporting Metastore open connection to Metrics system", (Throwable)e);
                    }
                    return null;
                }

                @Override
                public void deleteContext(ServerContext serverContext, TProtocol tProtocol, TProtocol tProtocol1) {
                    try {
                        Metrics metrics = MetricsFactory.getInstance();
                        if (metrics != null) {
                            metrics.decrementCounter("open_connections");
                        }
                    }
                    catch (Exception e) {
                        LOG.warn("Error Reporting Metastore close connection to Metrics system", (Throwable)e);
                    }
                }

                @Override
                public void processContext(ServerContext serverContext, TTransport tTransport, TTransport tTransport1) {
                }
            };
            tServer.setServerEventHandler(tServerEventHandler);
            HMSHandler.LOG.info("Started the new metaserver on port [" + port + "]...");
            HMSHandler.LOG.info("Options.minWorkerThreads = " + minWorkerThreads);
            HMSHandler.LOG.info("Options.maxWorkerThreads = " + maxWorkerThreads);
            HMSHandler.LOG.info("TCP keepalive = " + tcpKeepAlive);
            if (startLock != null) {
                HiveMetaStore.signalOtherThreadsToStart(tServer, startLock, startCondition, startedServing);
            }
            ((TServer)tServer).serve();
        }
        catch (Throwable x) {
            x.printStackTrace();
            HMSHandler.LOG.error(org.apache.hadoop.util.StringUtils.stringifyException((Throwable)x));
            throw x;
        }
    }

    private static void signalOtherThreadsToStart(final TServer server, final Lock startLock, final Condition startCondition, final AtomicBoolean startedServing) {
        Thread t = new Thread(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                do {
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (InterruptedException e) {
                        LOG.warn("Signalling thread was interuppted: " + e.getMessage());
                    }
                } while (!server.isServing());
                startLock.lock();
                try {
                    startedServing.set(true);
                    startCondition.signalAll();
                }
                finally {
                    startLock.unlock();
                }
            }
        };
        t.start();
    }

    private static void startMetaStoreThreads(final HiveConf conf, final Lock startLock, final Condition startCondition, final AtomicBoolean startedServing) {
        Thread t = new Thread(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                startLock.lock();
                try {
                    JvmPauseMonitor pauseMonitor = new JvmPauseMonitor(conf);
                    pauseMonitor.start();
                }
                catch (Throwable t) {
                    LOG.warn("Could not initiate the JvmPauseMonitor thread. GCs and Pauses may not be warned upon.", t);
                }
                try {
                    while (!startedServing.get()) {
                        startCondition.await();
                    }
                    HiveMetaStore.startCompactorInitiator(conf);
                    HiveMetaStore.startCompactorWorkers(conf);
                    HiveMetaStore.startCompactorCleaner(conf);
                    HiveMetaStore.startHouseKeeperService(conf);
                }
                catch (Throwable e) {
                    LOG.error("Failure when starting the compactor, compactions may not happen, " + org.apache.hadoop.util.StringUtils.stringifyException((Throwable)e));
                }
                finally {
                    startLock.unlock();
                }
            }
        };
        t.setDaemon(true);
        t.setName("Metastore threads starter thread");
        t.start();
    }

    private static void startCompactorInitiator(HiveConf conf) throws Exception {
        if (HiveConf.getBoolVar(conf, HiveConf.ConfVars.HIVE_COMPACTOR_INITIATOR_ON)) {
            MetaStoreThread initiator = HiveMetaStore.instantiateThread("org.apache.hadoop.hive.ql.txn.compactor.Initiator");
            HiveMetaStore.initializeAndStartThread(initiator, conf);
        }
    }

    private static void startCompactorWorkers(HiveConf conf) throws Exception {
        int numWorkers = HiveConf.getIntVar(conf, HiveConf.ConfVars.HIVE_COMPACTOR_WORKER_THREADS);
        for (int i = 0; i < numWorkers; ++i) {
            MetaStoreThread worker = HiveMetaStore.instantiateThread("org.apache.hadoop.hive.ql.txn.compactor.Worker");
            HiveMetaStore.initializeAndStartThread(worker, conf);
        }
    }

    private static void startCompactorCleaner(HiveConf conf) throws Exception {
        if (HiveConf.getBoolVar(conf, HiveConf.ConfVars.HIVE_COMPACTOR_INITIATOR_ON)) {
            MetaStoreThread cleaner = HiveMetaStore.instantiateThread("org.apache.hadoop.hive.ql.txn.compactor.Cleaner");
            HiveMetaStore.initializeAndStartThread(cleaner, conf);
        }
    }

    private static MetaStoreThread instantiateThread(String classname) throws Exception {
        Class<?> c = Class.forName(classname);
        Object o = c.newInstance();
        if (MetaStoreThread.class.isAssignableFrom(o.getClass())) {
            return (MetaStoreThread)o;
        }
        String s = classname + " is not an instance of MetaStoreThread.";
        LOG.error(s);
        throw new IOException(s);
    }

    private static void initializeAndStartThread(MetaStoreThread thread, HiveConf conf) throws MetaException {
        LOG.info("Starting metastore thread of type " + thread.getClass().getName());
        thread.setHiveConf(conf);
        thread.setThreadId(nextThreadId++);
        thread.init(new AtomicBoolean(), new AtomicBoolean());
        thread.start();
    }

    private static void startHouseKeeperService(HiveConf conf) throws Exception {
        if (!HiveConf.getBoolVar(conf, HiveConf.ConfVars.HIVE_COMPACTOR_INITIATOR_ON)) {
            return;
        }
        HiveMetaStore.startHouseKeeperService(conf, Class.forName("org.apache.hadoop.hive.ql.txn.AcidHouseKeeperService"));
        HiveMetaStore.startHouseKeeperService(conf, Class.forName("org.apache.hadoop.hive.ql.txn.AcidCompactionHistoryService"));
    }

    private static void startHouseKeeperService(HiveConf conf, Class c) throws Exception {
        HouseKeeperService houseKeeper = (HouseKeeperService)c.newInstance();
        try {
            houseKeeper.start(conf);
        }
        catch (Exception ex) {
            LOG.error("Failed to start {}", new Object[]{houseKeeper.getClass() + ".  The system will not handle {} ", houseKeeper.getServiceDescription(), ".  Root Cause: ", ex});
        }
    }

    static {
        nextThreadId = 1000000;
    }

    public static class HiveMetastoreCli
    extends CommonCliOptions {
        private int port;

        public HiveMetastoreCli(Configuration configuration) {
            super("hivemetastore", true);
            this.port = HiveConf.getIntVar(configuration, HiveConf.ConfVars.METASTORE_SERVER_PORT);
            OptionBuilder.hasArg();
            OptionBuilder.withArgName((String)"port");
            OptionBuilder.withDescription((String)("Hive Metastore port number, default:" + this.port));
            this.OPTIONS.addOption(OptionBuilder.create((char)'p'));
        }

        @Override
        public void parse(String[] args) {
            super.parse(args);
            args = this.commandLine.getArgs();
            if (args.length > 0) {
                System.err.println("This usage has been deprecated, consider using the new command line syntax (run with -h to see usage information)");
                this.port = new Integer(args[0]);
            }
            if (this.commandLine.hasOption('p')) {
                this.port = Integer.parseInt(this.commandLine.getOptionValue('p'));
            } else {
                String metastorePort = System.getenv("METASTORE_PORT");
                if (metastorePort != null) {
                    this.port = Integer.parseInt(metastorePort);
                }
            }
        }

        public int getPort() {
            return this.port;
        }
    }

    public static class HMSHandler
    extends FacebookBase
    implements IHMSHandler {
        public static final Logger LOG = LOG;
        private String rawStoreClassName;
        private final HiveConf hiveConf;
        private static String currentUrl;
        private Warehouse wh;
        private static final ThreadLocal<RawStore> threadLocalMS;
        private static final ThreadLocal<TxnHandler> threadLocalTxn;
        private static final ThreadLocal<Configuration> threadLocalConf;
        public static final String AUDIT_FORMAT = "ugi=%s\tip=%s\tcmd=%s\t";
        public static final Logger auditLog;
        private static final ThreadLocal<Formatter> auditFormatter;
        private static int nextSerialNum;
        private static ThreadLocal<Integer> threadLocalId;
        private static ThreadLocal<String> threadLocalIpAddress;
        private ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        private AlterHandler alterHandler;
        private List<MetaStorePreEventListener> preListeners;
        private List<MetaStoreEventListener> listeners;
        private List<MetaStoreEndFunctionListener> endFunctionListeners;
        private List<MetaStoreInitListener> initListeners;
        private Pattern partitionValidationPattern;
        private static final Map<Long, ByteBuffer> EMPTY_MAP_FM1;
        private static final Map<Long, MetadataPpdResult> EMPTY_MAP_FM2;

        public static RawStore getRawStore() {
            return threadLocalMS.get();
        }

        public static void removeRawStore() {
            threadLocalMS.remove();
        }

        private final void logAuditEvent(String cmd) {
            UserGroupInformation ugi;
            if (cmd == null) {
                return;
            }
            try {
                ugi = Utils.getUGI();
            }
            catch (Exception ex) {
                throw new RuntimeException(ex);
            }
            Formatter fmt = auditFormatter.get();
            ((StringBuilder)fmt.out()).setLength(0);
            String address = null;
            if (useSasl) {
                if (saslServer != null && saslServer.getRemoteAddress() != null) {
                    address = String.valueOf(saslServer.getRemoteAddress());
                }
            } else {
                address = HMSHandler.getIpAddress();
            }
            if (address == null) {
                address = "unknown-ip-addr";
            }
            auditLog.info(fmt.format(AUDIT_FORMAT, ugi.getUserName(), address, cmd).toString());
        }

        public static void setIpAddress(String ipAddress) {
            threadLocalIpAddress.set(ipAddress);
        }

        public static String getIpAddress() {
            return threadLocalIpAddress.get();
        }

        public static Integer get() {
            return threadLocalId.get();
        }

        public HMSHandler(String name) throws MetaException {
            this(name, new HiveConf(HMSHandler.class), true);
        }

        public HMSHandler(String name, HiveConf conf) throws MetaException {
            this(name, conf, true);
        }

        public HMSHandler(String name, HiveConf conf, boolean init) throws MetaException {
            super(name);
            if (this.classLoader == null) {
                this.classLoader = Configuration.class.getClassLoader();
            }
            this.hiveConf = conf;
            if (init) {
                this.init();
            }
        }

        public HiveConf getHiveConf() {
            return this.hiveConf;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void init() throws MetaException {
            this.rawStoreClassName = this.hiveConf.getVar(HiveConf.ConfVars.METASTORE_RAW_STORE_IMPL);
            this.initListeners = MetaStoreUtils.getMetaStoreListeners(MetaStoreInitListener.class, this.hiveConf, this.hiveConf.getVar(HiveConf.ConfVars.METASTORE_INIT_HOOKS));
            for (MetaStoreInitListener metaStoreInitListener : this.initListeners) {
                MetaStoreInitContext context = new MetaStoreInitContext();
                metaStoreInitListener.onInit(context);
            }
            String alterHandlerName = this.hiveConf.get("hive.metastore.alter.impl", HiveAlterHandler.class.getName());
            this.alterHandler = (AlterHandler)ReflectionUtils.newInstance(MetaStoreUtils.getClass(alterHandlerName), (Configuration)this.hiveConf);
            this.wh = new Warehouse(this.hiveConf);
            Class<HMSHandler> clazz = HMSHandler.class;
            synchronized (HMSHandler.class) {
                if (currentUrl == null || !currentUrl.equals(MetaStoreInit.getConnectionURL(this.hiveConf))) {
                    this.createDefaultDB();
                    this.createDefaultRoles();
                    this.addAdminUsers();
                    currentUrl = MetaStoreInit.getConnectionURL(this.hiveConf);
                }
                // ** MonitorExit[var2_3] (shouldn't be in output)
                if (this.hiveConf.getBoolVar(HiveConf.ConfVars.METASTORE_METRICS)) {
                    try {
                        MetricsFactory.init(this.hiveConf);
                    }
                    catch (Exception exception) {
                        LOG.error("error in Metrics init: " + exception.getClass().getName() + " " + exception.getMessage(), (Throwable)exception);
                    }
                }
                this.preListeners = MetaStoreUtils.getMetaStoreListeners(MetaStorePreEventListener.class, this.hiveConf, this.hiveConf.getVar(HiveConf.ConfVars.METASTORE_PRE_EVENT_LISTENERS));
                this.preListeners.add(0, new TransactionalValidationListener(this.hiveConf));
                this.listeners = MetaStoreUtils.getMetaStoreListeners(MetaStoreEventListener.class, this.hiveConf, this.hiveConf.getVar(HiveConf.ConfVars.METASTORE_EVENT_LISTENERS));
                this.listeners.add(new SessionPropertiesListener(this.hiveConf));
                this.endFunctionListeners = MetaStoreUtils.getMetaStoreListeners(MetaStoreEndFunctionListener.class, this.hiveConf, this.hiveConf.getVar(HiveConf.ConfVars.METASTORE_END_FUNCTION_LISTENERS));
                String string = this.hiveConf.getVar(HiveConf.ConfVars.METASTORE_PARTITION_NAME_WHITELIST_PATTERN);
                this.partitionValidationPattern = string != null && !string.isEmpty() ? Pattern.compile(string) : null;
                long cleanFreq = this.hiveConf.getTimeVar(HiveConf.ConfVars.METASTORE_EVENT_CLEAN_FREQ, TimeUnit.MILLISECONDS);
                if (cleanFreq > 0L) {
                    Timer cleaner = new Timer("Metastore Events Cleaner Thread", true);
                    cleaner.schedule((TimerTask)new EventCleanerTask(this), cleanFreq, cleanFreq);
                }
                return;
            }
        }

        private String addPrefix(String s) {
            return threadLocalId.get() + ": " + s;
        }

        public void setConf(Configuration conf) {
            threadLocalConf.set(conf);
            RawStore ms = threadLocalMS.get();
            if (ms != null) {
                ms.setConf(conf);
            }
        }

        public Configuration getConf() {
            Configuration conf = threadLocalConf.get();
            if (conf == null) {
                conf = new Configuration((Configuration)this.hiveConf);
                threadLocalConf.set(conf);
            }
            return conf;
        }

        public Warehouse getWh() {
            return this.wh;
        }

        @Override
        public void setMetaConf(String key, String value) throws MetaException {
            HiveConf.ConfVars confVar = HiveConf.getMetaConf(key);
            if (confVar == null) {
                throw new MetaException("Invalid configuration key " + key);
            }
            String validate = confVar.validate(value);
            if (validate != null) {
                throw new MetaException("Invalid configuration value " + value + " for key " + key + " by " + validate);
            }
            Configuration configuration = this.getConf();
            String oldValue = configuration.get(key);
            configuration.set(key, value);
            for (MetaStoreEventListener listener : this.listeners) {
                listener.onConfigChange(new ConfigChangeEvent(this, key, oldValue, value));
            }
        }

        @Override
        public String getMetaConf(String key) throws MetaException {
            HiveConf.ConfVars confVar = HiveConf.getMetaConf(key);
            if (confVar == null) {
                throw new MetaException("Invalid configuration key " + key);
            }
            return this.getConf().get(key);
        }

        @InterfaceAudience.LimitedPrivate(value={"HCATALOG"})
        @InterfaceStability.Evolving
        public RawStore getMS() throws MetaException {
            RawStore ms = threadLocalMS.get();
            if (ms == null) {
                ms = this.newRawStore();
                ms.verifySchema();
                threadLocalMS.set(ms);
                ms = threadLocalMS.get();
            }
            return ms;
        }

        private TxnHandler getTxnHandler() {
            TxnHandler txn = threadLocalTxn.get();
            if (txn == null) {
                txn = new TxnHandler(this.hiveConf);
                threadLocalTxn.set(txn);
            }
            return txn;
        }

        private RawStore newRawStore() throws MetaException {
            LOG.info(this.addPrefix("Opening raw store with implementation class:" + this.rawStoreClassName));
            Configuration conf = this.getConf();
            if (this.hiveConf.getBoolVar(HiveConf.ConfVars.METASTORE_FASTPATH)) {
                LOG.info("Fastpath, skipping raw store proxy");
                try {
                    RawStore rs = (RawStore)MetaStoreUtils.getClass(this.rawStoreClassName).newInstance();
                    rs.setConf(conf);
                    return rs;
                }
                catch (Exception e) {
                    LOG.error("Unable to instantiate raw store directly in fastpath mode", (Throwable)e);
                    throw new RuntimeException(e);
                }
            }
            return RawStoreProxy.getProxy(this.hiveConf, conf, this.rawStoreClassName, threadLocalId.get());
        }

        private void createDefaultDB_core(RawStore ms) throws MetaException, InvalidObjectException {
            try {
                ms.getDatabase("default");
            }
            catch (NoSuchObjectException e) {
                Database db = new Database("default", "Default Hive database", this.wh.getDefaultDatabasePath("default").toString(), null);
                db.setOwnerName(HiveMetaStore.PUBLIC);
                db.setOwnerType(PrincipalType.ROLE);
                ms.createDatabase(db);
            }
        }

        private void createDefaultDB() throws MetaException {
            try {
                this.createDefaultDB_core(this.getMS());
            }
            catch (JDOException e) {
                LOG.warn("Retrying creating default database after error: " + e.getMessage(), (Throwable)e);
                try {
                    this.createDefaultDB_core(this.getMS());
                }
                catch (InvalidObjectException e1) {
                    throw new MetaException(e1.getMessage());
                }
            }
            catch (InvalidObjectException e) {
                throw new MetaException(e.getMessage());
            }
        }

        private void createDefaultRoles() throws MetaException {
            try {
                this.createDefaultRoles_core();
            }
            catch (JDOException e) {
                LOG.warn("Retrying creating default roles after error: " + e.getMessage(), (Throwable)e);
                this.createDefaultRoles_core();
            }
        }

        private void createDefaultRoles_core() throws MetaException {
            RawStore ms = this.getMS();
            try {
                ms.addRole(HiveMetaStore.ADMIN, HiveMetaStore.ADMIN);
            }
            catch (InvalidObjectException e) {
                LOG.debug("admin role already exists", (Throwable)e);
            }
            catch (NoSuchObjectException e) {
                LOG.warn("Unexpected exception while adding admin roles", (Throwable)e);
            }
            LOG.info("Added admin role in metastore");
            try {
                ms.addRole(HiveMetaStore.PUBLIC, HiveMetaStore.PUBLIC);
            }
            catch (InvalidObjectException e) {
                LOG.debug("public role already exists", (Throwable)e);
            }
            catch (NoSuchObjectException e) {
                LOG.warn("Unexpected exception while adding public roles", (Throwable)e);
            }
            LOG.info("Added public role in metastore");
            PrivilegeBag privs = new PrivilegeBag();
            privs.addToPrivileges(new HiveObjectPrivilege(new HiveObjectRef(HiveObjectType.GLOBAL, null, null, null, null), HiveMetaStore.ADMIN, PrincipalType.ROLE, new PrivilegeGrantInfo("All", 0, HiveMetaStore.ADMIN, PrincipalType.ROLE, true)));
            try {
                ms.grantPrivileges(privs);
            }
            catch (InvalidObjectException e) {
                LOG.debug("Failed while granting global privs to admin", (Throwable)e);
            }
            catch (NoSuchObjectException e) {
                LOG.warn("Failed while granting global privs to admin", (Throwable)e);
            }
        }

        private void addAdminUsers() throws MetaException {
            try {
                this.addAdminUsers_core();
            }
            catch (JDOException e) {
                LOG.warn("Retrying adding admin users after error: " + e.getMessage(), (Throwable)e);
                this.addAdminUsers_core();
            }
        }

        private void addAdminUsers_core() throws MetaException {
            Role adminRole;
            String userStr = HiveConf.getVar(this.hiveConf, HiveConf.ConfVars.USERS_IN_ADMIN_ROLE, "").trim();
            if (userStr.isEmpty()) {
                LOG.info("No user is added in admin role, since config is empty");
                return;
            }
            Iterator<String> users = Splitter.on(",").trimResults().omitEmptyStrings().split(userStr).iterator();
            if (!users.hasNext()) {
                LOG.info("No user is added in admin role, since config value " + userStr + " is in incorrect format. We accept comma seprated list of users.");
                return;
            }
            RawStore ms = this.getMS();
            try {
                adminRole = ms.getRole(HiveMetaStore.ADMIN);
            }
            catch (NoSuchObjectException e) {
                LOG.error("Failed to retrieve just added admin role", (Throwable)e);
                return;
            }
            while (users.hasNext()) {
                String userName = users.next();
                try {
                    ms.grantRole(adminRole, userName, PrincipalType.USER, HiveMetaStore.ADMIN, PrincipalType.ROLE, true);
                    LOG.info("Added " + userName + " to admin role");
                }
                catch (NoSuchObjectException e) {
                    LOG.error("Failed to add " + userName + " in admin role", (Throwable)e);
                }
                catch (InvalidObjectException e) {
                    LOG.debug(userName + " already in admin role", (Throwable)e);
                }
            }
        }

        private void logInfo(String m) {
            LOG.info(threadLocalId.get().toString() + ": " + m);
            this.logAuditEvent(m);
        }

        private String startFunction(String function, String extraLogInfo) {
            this.incrementCounter(function);
            this.logInfo((HMSHandler.getIpAddress() == null ? "" : "source:" + HMSHandler.getIpAddress() + " ") + function + extraLogInfo);
            if (MetricsFactory.getInstance() != null) {
                try {
                    MetricsFactory.getInstance().startStoredScope(function);
                }
                catch (IOException e) {
                    LOG.debug("Exception when starting metrics scope" + e.getClass().getName() + " " + e.getMessage(), (Throwable)e);
                }
            }
            return function;
        }

        private String startFunction(String function) {
            return this.startFunction(function, "");
        }

        private String startTableFunction(String function, String db, String tbl) {
            return this.startFunction(function, " : db=" + db + " tbl=" + tbl);
        }

        private String startMultiTableFunction(String function, String db, List<String> tbls) {
            String tableNames = StringUtils.join(tbls, ",");
            return this.startFunction(function, " : db=" + db + " tbls=" + tableNames);
        }

        private String startPartitionFunction(String function, String db, String tbl, List<String> partVals) {
            return this.startFunction(function, " : db=" + db + " tbl=" + tbl + "[" + StringUtils.join(partVals, ",") + "]");
        }

        private String startPartitionFunction(String function, String db, String tbl, Map<String, String> partName) {
            return this.startFunction(function, " : db=" + db + " tbl=" + tbl + "partition=" + partName);
        }

        private void endFunction(String function, boolean successful, Exception e) {
            this.endFunction(function, successful, e, null);
        }

        private void endFunction(String function, boolean successful, Exception e, String inputTableName) {
            this.endFunction(function, new MetaStoreEndFunctionContext(successful, e, inputTableName));
        }

        private void endFunction(String function, MetaStoreEndFunctionContext context) {
            if (MetricsFactory.getInstance() != null) {
                try {
                    MetricsFactory.getInstance().endStoredScope(function);
                }
                catch (IOException e) {
                    LOG.debug("Exception when closing metrics scope" + e);
                }
            }
            for (MetaStoreEndFunctionListener listener : this.endFunctionListeners) {
                listener.onEndFunction(function, context);
            }
        }

        @Override
        public fb_status getStatus() {
            return fb_status.ALIVE;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void shutdown() {
            this.logInfo("Shutting down the object store...");
            RawStore ms = threadLocalMS.get();
            if (ms != null) {
                try {
                    ms.shutdown();
                }
                finally {
                    threadLocalMS.remove();
                }
            }
            this.logInfo("Metastore shutdown complete.");
        }

        @Override
        public AbstractMap<String, Long> getCounters() {
            Map counters = super.getCounters();
            if (this.endFunctionListeners != null) {
                for (MetaStoreEndFunctionListener listener : this.endFunctionListeners) {
                    listener.exportCounters((AbstractMap<String, Long>)counters);
                }
            }
            return counters;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void create_database_core(RawStore ms, Database db) throws AlreadyExistsException, InvalidObjectException, MetaException {
            if (!MetaStoreUtils.validateName(db.getName(), null)) {
                throw new InvalidObjectException(db.getName() + " is not a valid database name");
            }
            if (null == db.getLocationUri()) {
                db.setLocationUri(this.wh.getDefaultDatabasePath(db.getName()).toString());
            } else {
                db.setLocationUri(this.wh.getDnsPath(new Path(db.getLocationUri())).toString());
            }
            Path dbPath = new Path(db.getLocationUri());
            boolean success = false;
            boolean madeDir = false;
            try {
                this.firePreEvent(new PreCreateDatabaseEvent(db, this));
                if (!this.wh.isDir(dbPath)) {
                    if (!this.wh.mkdirs(dbPath, true)) {
                        throw new MetaException("Unable to create database path " + dbPath + ", failed to create database " + db.getName());
                    }
                    madeDir = true;
                }
                ms.openTransaction();
                ms.createDatabase(db);
                success = ms.commitTransaction();
            }
            finally {
                if (!success) {
                    ms.rollbackTransaction();
                    if (madeDir) {
                        this.wh.deleteDir(dbPath, true);
                    }
                }
                for (MetaStoreEventListener listener : this.listeners) {
                    listener.onCreateDatabase(new CreateDatabaseEvent(db, success, this));
                }
            }
        }

        @Override
        public void create_database(Database db) throws AlreadyExistsException, InvalidObjectException, MetaException {
            this.startFunction("create_database", ": " + db.toString());
            boolean success = false;
            Exception ex = null;
            try {
                try {
                    if (null != this.get_database_core(db.getName())) {
                        throw new AlreadyExistsException("Database " + db.getName() + " already exists");
                    }
                }
                catch (NoSuchObjectException e) {
                    // empty catch block
                }
                if (TEST_TIMEOUT_ENABLED) {
                    try {
                        Thread.sleep(TEST_TIMEOUT_VALUE);
                    }
                    catch (InterruptedException e) {
                        // empty catch block
                    }
                    Deadline.checkTimeout();
                }
                this.create_database_core(this.getMS(), db);
                success = true;
            }
            catch (Exception e) {
                ex = e;
                if (e instanceof MetaException) {
                    throw (MetaException)e;
                }
                if (e instanceof InvalidObjectException) {
                    throw (InvalidObjectException)e;
                }
                if (e instanceof AlreadyExistsException) {
                    throw (AlreadyExistsException)e;
                }
                throw HMSHandler.newMetaException(e);
            }
            finally {
                this.endFunction("create_database", success, ex);
            }
        }

        /*
         * Loose catch block
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public Database get_database(String name) throws NoSuchObjectException, MetaException {
            this.startFunction("get_database", ": " + name);
            Database db = null;
            TException ex = null;
            try {
                db = this.get_database_core(name);
                this.firePreEvent(new PreReadDatabaseEvent(db, this));
                this.endFunction("get_database", db != null, ex);
                return db;
            }
            catch (MetaException e) {
                try {
                    ex = e;
                    throw e;
                    catch (NoSuchObjectException e2) {
                        ex = e2;
                        throw e2;
                    }
                }
                catch (Throwable throwable) {
                    this.endFunction("get_database", db != null, ex);
                    throw throwable;
                }
            }
        }

        public Database get_database_core(String name) throws NoSuchObjectException, MetaException {
            Database db = null;
            try {
                db = this.getMS().getDatabase(name);
            }
            catch (MetaException e) {
                throw e;
            }
            catch (NoSuchObjectException e) {
                throw e;
            }
            catch (Exception e) {
                assert (e instanceof RuntimeException);
                throw (RuntimeException)e;
            }
            return db;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void alter_database(String dbName, Database db) throws NoSuchObjectException, TException, MetaException {
            this.startFunction("alter_database" + dbName);
            boolean success = false;
            Exception ex = null;
            try {
                this.getMS().alterDatabase(dbName, db);
                success = true;
            }
            catch (Exception e) {
                ex = e;
                this.rethrowException(e);
            }
            finally {
                this.endFunction("alter_database", success, ex);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void drop_database_core(RawStore ms, String name, boolean deleteData, boolean cascade) throws NoSuchObjectException, InvalidOperationException, MetaException, IOException, InvalidObjectException, InvalidInputException {
            boolean success = false;
            Database db = null;
            ArrayList<Path> tablePaths = new ArrayList<Path>();
            List<Path> partitionPaths = new ArrayList<Path>();
            try {
                Path path;
                ms.openTransaction();
                db = ms.getDatabase(name);
                this.firePreEvent(new PreDropDatabaseEvent(db, this));
                List<String> allTables = this.get_all_tables(db.getName());
                List<String> allFunctions = this.get_functions(db.getName(), "*");
                if (!cascade) {
                    if (!allTables.isEmpty()) {
                        throw new InvalidOperationException("Database " + db.getName() + " is not empty. One or more tables exist.");
                    }
                    if (!allFunctions.isEmpty()) {
                        throw new InvalidOperationException("Database " + db.getName() + " is not empty. One or more functions exist.");
                    }
                }
                if (!this.wh.isWritable(path = new Path(db.getLocationUri()).getParent())) {
                    throw new MetaException("Database not dropped since " + path + " is not writable by " + this.hiveConf.getUser());
                }
                Path databasePath = this.wh.getDnsPath(this.wh.getDatabasePath(db));
                for (String funcName : allFunctions) {
                    this.drop_function(name, funcName);
                }
                int tableBatchSize = HiveConf.getIntVar(this.hiveConf, HiveConf.ConfVars.METASTORE_BATCH_RETRIEVE_MAX);
                int startIndex = 0;
                while (startIndex < allTables.size()) {
                    int endIndex = Math.min(startIndex + tableBatchSize, allTables.size());
                    List<Table> tables = null;
                    try {
                        tables = ms.getTableObjectsByName(name, allTables.subList(startIndex, endIndex));
                    }
                    catch (UnknownDBException e) {
                        throw new MetaException(e.getMessage());
                    }
                    if (tables == null || tables.isEmpty()) continue;
                    for (Table table : tables) {
                        Path tablePath = null;
                        if (table.getSd().getLocation() != null && !this.isExternal(table)) {
                            tablePath = this.wh.getDnsPath(new Path(table.getSd().getLocation()));
                            if (!this.wh.isWritable(tablePath.getParent())) {
                                throw new MetaException("Database metadata not deleted since table: " + table.getTableName() + " has a parent location " + tablePath.getParent() + " which is not writable by " + this.hiveConf.getUser());
                            }
                            if (!this.isSubdirectory(databasePath, tablePath)) {
                                tablePaths.add(tablePath);
                            }
                        }
                        partitionPaths = this.dropPartitionsAndGetLocations(ms, name, table.getTableName(), tablePath, table.getPartitionKeys(), deleteData && !this.isExternal(table));
                        this.drop_table(name, table.getTableName(), false);
                    }
                    startIndex = endIndex;
                }
                if (ms.dropDatabase(name)) {
                    success = ms.commitTransaction();
                }
            }
            finally {
                if (!success) {
                    ms.rollbackTransaction();
                } else if (deleteData) {
                    this.deletePartitionData(partitionPaths);
                    for (Path tablePath : tablePaths) {
                        this.deleteTableData(tablePath);
                    }
                    try {
                        this.wh.deleteDir(new Path(db.getLocationUri()), true);
                    }
                    catch (Exception e) {
                        LOG.error("Failed to delete database directory: " + db.getLocationUri() + " " + e.getMessage());
                    }
                }
                for (MetaStoreEventListener listener : this.listeners) {
                    listener.onDropDatabase(new DropDatabaseEvent(db, success, this));
                }
            }
        }

        private boolean isSubdirectory(Path parent, Path other) {
            return other.toString().startsWith(parent.toString().endsWith("/") ? parent.toString() : parent.toString() + "/");
        }

        @Override
        public void drop_database(String dbName, boolean deleteData, boolean cascade) throws NoSuchObjectException, InvalidOperationException, MetaException {
            this.startFunction("drop_database", ": " + dbName);
            if ("default".equalsIgnoreCase(dbName)) {
                this.endFunction("drop_database", false, null);
                throw new MetaException("Can not drop default database");
            }
            boolean success = false;
            Exception ex = null;
            try {
                this.drop_database_core(this.getMS(), dbName, deleteData, cascade);
                success = true;
            }
            catch (IOException e) {
                ex = e;
                throw new MetaException(e.getMessage());
            }
            catch (Exception e) {
                ex = e;
                if (e instanceof MetaException) {
                    throw (MetaException)e;
                }
                if (e instanceof InvalidOperationException) {
                    throw (InvalidOperationException)e;
                }
                if (e instanceof NoSuchObjectException) {
                    throw (NoSuchObjectException)e;
                }
                throw HMSHandler.newMetaException(e);
            }
            finally {
                this.endFunction("drop_database", success, ex);
            }
        }

        @Override
        public List<String> get_databases(String pattern) throws MetaException {
            this.startFunction("get_databases", ": " + pattern);
            List<String> ret = null;
            Exception ex = null;
            try {
                ret = this.getMS().getDatabases(pattern);
                this.endFunction("get_databases", ret != null, ex);
            }
            catch (Exception e) {
                try {
                    ex = e;
                    if (e instanceof MetaException) {
                        throw (MetaException)e;
                    }
                    throw HMSHandler.newMetaException(e);
                }
                catch (Throwable throwable) {
                    this.endFunction("get_databases", ret != null, ex);
                    throw throwable;
                }
            }
            return ret;
        }

        @Override
        public List<String> get_all_databases() throws MetaException {
            this.startFunction("get_all_databases");
            List<String> ret = null;
            Exception ex = null;
            try {
                ret = this.getMS().getAllDatabases();
                this.endFunction("get_all_databases", ret != null, ex);
            }
            catch (Exception e) {
                try {
                    ex = e;
                    if (e instanceof MetaException) {
                        throw (MetaException)e;
                    }
                    throw HMSHandler.newMetaException(e);
                }
                catch (Throwable throwable) {
                    this.endFunction("get_all_databases", ret != null, ex);
                    throw throwable;
                }
            }
            return ret;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void create_type_core(RawStore ms, Type type) throws AlreadyExistsException, MetaException, InvalidObjectException {
            if (!MetaStoreUtils.validateName(type.getName(), null)) {
                throw new InvalidObjectException("Invalid type name");
            }
            boolean success = false;
            try {
                ms.openTransaction();
                if (this.is_type_exists(ms, type.getName())) {
                    throw new AlreadyExistsException("Type " + type.getName() + " already exists");
                }
                ms.createType(type);
                success = ms.commitTransaction();
            }
            finally {
                if (!success) {
                    ms.rollbackTransaction();
                }
            }
        }

        @Override
        public boolean create_type(Type type) throws AlreadyExistsException, MetaException, InvalidObjectException {
            this.startFunction("create_type", ": " + type.toString());
            boolean success = false;
            Exception ex = null;
            try {
                this.create_type_core(this.getMS(), type);
                success = true;
            }
            catch (Exception e) {
                ex = e;
                if (e instanceof MetaException) {
                    throw (MetaException)e;
                }
                if (e instanceof InvalidObjectException) {
                    throw (InvalidObjectException)e;
                }
                if (e instanceof AlreadyExistsException) {
                    throw (AlreadyExistsException)e;
                }
                throw HMSHandler.newMetaException(e);
            }
            finally {
                this.endFunction("create_type", success, ex);
            }
            return success;
        }

        @Override
        public Type get_type(String name) throws MetaException, NoSuchObjectException {
            this.startFunction("get_type", ": " + name);
            Type ret = null;
            Exception ex = null;
            try {
                ret = this.getMS().getType(name);
                if (null == ret) {
                    throw new NoSuchObjectException("Type \"" + name + "\" not found.");
                }
                this.endFunction("get_type", ret != null, ex);
            }
            catch (Exception e) {
                try {
                    ex = e;
                    if (e instanceof MetaException) {
                        throw (MetaException)e;
                    }
                    if (e instanceof NoSuchObjectException) {
                        throw (NoSuchObjectException)e;
                    }
                    throw HMSHandler.newMetaException(e);
                }
                catch (Throwable throwable) {
                    this.endFunction("get_type", ret != null, ex);
                    throw throwable;
                }
            }
            return ret;
        }

        private boolean is_type_exists(RawStore ms, String typeName) throws MetaException {
            return ms.getType(typeName) != null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void drop_type_core(RawStore ms, String typeName) throws NoSuchObjectException, MetaException {
            boolean success = false;
            try {
                ms.openTransaction();
                if (!this.is_type_exists(ms, typeName)) {
                    throw new NoSuchObjectException(typeName + " doesn't exist");
                }
                if (!ms.dropType(typeName)) {
                    throw new MetaException("Unable to drop type " + typeName);
                }
                success = ms.commitTransaction();
            }
            finally {
                if (!success) {
                    ms.rollbackTransaction();
                }
            }
        }

        @Override
        public boolean drop_type(String name) throws MetaException, NoSuchObjectException {
            this.startFunction("drop_type", ": " + name);
            boolean success = false;
            Exception ex = null;
            try {
                success = this.getMS().dropType(name);
            }
            catch (Exception e) {
                ex = e;
                if (e instanceof MetaException) {
                    throw (MetaException)e;
                }
                if (e instanceof NoSuchObjectException) {
                    throw (NoSuchObjectException)e;
                }
                throw HMSHandler.newMetaException(e);
            }
            finally {
                this.endFunction("drop_type", success, ex);
            }
            return success;
        }

        @Override
        public Map<String, Type> get_type_all(String name) throws MetaException {
            this.startFunction("get_type_all", ": " + name);
            this.endFunction("get_type_all", false, null);
            throw new MetaException("Not yet implemented");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void create_table_core(RawStore ms, Table tbl, EnvironmentContext envContext) throws AlreadyExistsException, MetaException, InvalidObjectException, NoSuchObjectException {
            boolean success;
            block22: {
                if (!MetaStoreUtils.validateName(tbl.getTableName(), this.hiveConf)) {
                    throw new InvalidObjectException(tbl.getTableName() + " is not a valid object name");
                }
                String validate = MetaStoreUtils.validateTblColumns(tbl.getSd().getCols());
                if (validate != null) {
                    throw new InvalidObjectException("Invalid column " + validate);
                }
                if (tbl.getPartitionKeys() != null && (validate = MetaStoreUtils.validateTblColumns(tbl.getPartitionKeys())) != null) {
                    throw new InvalidObjectException("Invalid partition column " + validate);
                }
                SkewedInfo skew = tbl.getSd().getSkewedInfo();
                if (skew != null) {
                    validate = MetaStoreUtils.validateSkewedColNames(skew.getSkewedColNames());
                    if (validate != null) {
                        throw new InvalidObjectException("Invalid skew column " + validate);
                    }
                    validate = MetaStoreUtils.validateSkewedColNamesSubsetCol(skew.getSkewedColNames(), tbl.getSd().getCols());
                    if (validate != null) {
                        throw new InvalidObjectException("Invalid skew column " + validate);
                    }
                }
                Path tblPath = null;
                success = false;
                boolean madeDir = false;
                try {
                    this.firePreEvent(new PreCreateTableEvent(tbl, this));
                    ms.openTransaction();
                    Database db = ms.getDatabase(tbl.getDbName());
                    if (db == null) {
                        throw new NoSuchObjectException("The database " + tbl.getDbName() + " does not exist");
                    }
                    if (this.is_table_exists(ms, tbl.getDbName(), tbl.getTableName())) {
                        throw new AlreadyExistsException("Table " + tbl.getTableName() + " already exists");
                    }
                    if (!TableType.VIRTUAL_VIEW.toString().equals(tbl.getTableType())) {
                        if (tbl.getSd().getLocation() == null || tbl.getSd().getLocation().isEmpty()) {
                            tblPath = this.wh.getTablePath(ms.getDatabase(tbl.getDbName()), tbl.getTableName());
                        } else {
                            if (!this.isExternal(tbl) && !MetaStoreUtils.isNonNativeTable(tbl)) {
                                LOG.warn("Location: " + tbl.getSd().getLocation() + " specified for non-external table:" + tbl.getTableName());
                            }
                            tblPath = this.wh.getDnsPath(new Path(tbl.getSd().getLocation()));
                        }
                        tbl.getSd().setLocation(tblPath.toString());
                    }
                    if (tblPath != null && !this.wh.isDir(tblPath)) {
                        if (!this.wh.mkdirs(tblPath, true)) {
                            throw new MetaException(tblPath + " is not a directory or unable to create one");
                        }
                        madeDir = true;
                    }
                    if (HiveConf.getBoolVar(this.hiveConf, HiveConf.ConfVars.HIVESTATSAUTOGATHER) && !MetaStoreUtils.isView(tbl)) {
                        MetaStoreUtils.updateTableStatsFast(db, tbl, this.wh, madeDir);
                    }
                    long time = System.currentTimeMillis() / 1000L;
                    tbl.setCreateTime((int)time);
                    if (tbl.getParameters() == null || tbl.getParameters().get("transient_lastDdlTime") == null) {
                        tbl.putToParameters("transient_lastDdlTime", Long.toString(time));
                    }
                    ms.createTable(tbl);
                    success = ms.commitTransaction();
                    if (success) break block22;
                    ms.rollbackTransaction();
                    if (!madeDir) break block22;
                }
                catch (Throwable throwable) {
                    if (!success) {
                        ms.rollbackTransaction();
                        if (madeDir) {
                            this.wh.deleteDir(tblPath, true);
                        }
                    }
                    for (MetaStoreEventListener listener : this.listeners) {
                        CreateTableEvent createTableEvent = new CreateTableEvent(tbl, success, this);
                        createTableEvent.setEnvironmentContext(envContext);
                        listener.onCreateTable(createTableEvent);
                    }
                    throw throwable;
                }
                this.wh.deleteDir(tblPath, true);
            }
            for (MetaStoreEventListener listener : this.listeners) {
                CreateTableEvent createTableEvent = new CreateTableEvent(tbl, success, this);
                createTableEvent.setEnvironmentContext(envContext);
                listener.onCreateTable(createTableEvent);
            }
        }

        @Override
        public void create_table(Table tbl) throws AlreadyExistsException, MetaException, InvalidObjectException {
            this.create_table_with_environment_context(tbl, null);
        }

        @Override
        public void create_table_with_environment_context(Table tbl, EnvironmentContext envContext) throws AlreadyExistsException, MetaException, InvalidObjectException {
            this.startFunction("create_table", ": " + tbl.toString());
            boolean success = false;
            Exception ex = null;
            try {
                this.create_table_core(this.getMS(), tbl, envContext);
                success = true;
            }
            catch (NoSuchObjectException e) {
                ex = e;
                throw new InvalidObjectException(e.getMessage());
            }
            catch (Exception e) {
                ex = e;
                if (e instanceof MetaException) {
                    throw (MetaException)e;
                }
                if (e instanceof InvalidObjectException) {
                    throw (InvalidObjectException)e;
                }
                if (e instanceof AlreadyExistsException) {
                    throw (AlreadyExistsException)e;
                }
                throw HMSHandler.newMetaException(e);
            }
            finally {
                this.endFunction("create_table", success, ex, tbl.getTableName());
            }
        }

        private boolean is_table_exists(RawStore ms, String dbname, String name) throws MetaException {
            return ms.getTable(dbname, name) != null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean drop_table_core(RawStore ms, String dbname, String name, boolean deleteData, EnvironmentContext envContext, String indexName) throws NoSuchObjectException, MetaException, IOException, InvalidObjectException, InvalidInputException {
            boolean success = false;
            boolean isExternal = false;
            Path tblPath = null;
            List<Path> partPaths = null;
            Table tbl = null;
            boolean ifPurge = false;
            try {
                ms.openTransaction();
                tbl = this.get_table_core(dbname, name);
                if (tbl == null) {
                    throw new NoSuchObjectException(name + " doesn't exist");
                }
                if (tbl.getSd() == null) {
                    throw new MetaException("Table metadata is corrupted");
                }
                ifPurge = HMSHandler.isMustPurge(envContext, tbl);
                this.firePreEvent(new PreDropTableEvent(tbl, deleteData, this));
                boolean isIndexTable = this.isIndexTable(tbl);
                if (indexName == null && isIndexTable) {
                    throw new RuntimeException("The table " + name + " is an index table. Please do drop index instead.");
                }
                if (!isIndexTable) {
                    try {
                        List<Index> indexes = ms.getIndexes(dbname, name, Short.MAX_VALUE);
                        while (indexes != null && indexes.size() > 0) {
                            for (Index idx : indexes) {
                                this.drop_index_by_name(dbname, name, idx.getIndexName(), true);
                            }
                            indexes = ms.getIndexes(dbname, name, Short.MAX_VALUE);
                        }
                    }
                    catch (TException e) {
                        throw new MetaException(e.getMessage());
                    }
                }
                isExternal = this.isExternal(tbl);
                if (tbl.getSd().getLocation() != null && !this.wh.isWritable((tblPath = new Path(tbl.getSd().getLocation())).getParent())) {
                    String target = indexName == null ? "Table" : "Index table";
                    throw new MetaException(target + " metadata not deleted since " + tblPath.getParent() + " is not writable by " + this.hiveConf.getUser());
                }
                this.checkTrashPurgeCombination(tblPath, dbname + "." + name, ifPurge);
                partPaths = this.dropPartitionsAndGetLocations(ms, dbname, name, tblPath, tbl.getPartitionKeys(), deleteData && !isExternal);
                if (!ms.dropTable(dbname, name)) {
                    String tableName = dbname + "." + name;
                    throw new MetaException(indexName == null ? "Unable to drop table " + tableName : "Unable to drop index table " + tableName + " for index " + indexName);
                }
                success = ms.commitTransaction();
                if (!success) {
                    ms.rollbackTransaction();
                } else if (deleteData && !isExternal) {
                    this.deletePartitionData(partPaths, ifPurge);
                    this.deleteTableData(tblPath, ifPurge);
                }
            }
            catch (Throwable throwable) {
                if (!success) {
                    ms.rollbackTransaction();
                } else if (deleteData && !isExternal) {
                    this.deletePartitionData(partPaths, ifPurge);
                    this.deleteTableData(tblPath, ifPurge);
                }
                for (MetaStoreEventListener listener : this.listeners) {
                    DropTableEvent dropTableEvent = new DropTableEvent(tbl, success, deleteData, this);
                    dropTableEvent.setEnvironmentContext(envContext);
                    listener.onDropTable(dropTableEvent);
                }
                throw throwable;
            }
            for (MetaStoreEventListener listener : this.listeners) {
                DropTableEvent dropTableEvent = new DropTableEvent(tbl, success, deleteData, this);
                dropTableEvent.setEnvironmentContext(envContext);
                listener.onDropTable(dropTableEvent);
            }
            return success;
        }

        private void checkTrashPurgeCombination(Path pathToData, String objectName, boolean ifPurge) throws MetaException {
            if (pathToData == null || ifPurge) {
                return;
            }
            boolean trashEnabled = false;
            try {
                trashEnabled = 0.0f < this.hiveConf.getFloat("fs.trash.interval", -1.0f);
            }
            catch (NumberFormatException ex) {
                // empty catch block
            }
            if (trashEnabled) {
                try {
                    HadoopShims.HdfsEncryptionShim shim = ShimLoader.getHadoopShims().createHdfsEncryptionShim(FileSystem.get((Configuration)this.hiveConf), this.hiveConf);
                    if (shim.isPathEncrypted(pathToData)) {
                        throw new MetaException("Unable to drop " + objectName + " because it is in an encryption zone" + " and trash is enabled.  Use PURGE option to skip trash.");
                    }
                }
                catch (IOException ex) {
                    MetaException e = new MetaException(ex.getMessage());
                    e.initCause(ex);
                    throw e;
                }
            }
        }

        private void deleteTableData(Path tablePath) {
            this.deleteTableData(tablePath, false);
        }

        private void deleteTableData(Path tablePath, boolean ifPurge) {
            if (tablePath != null) {
                try {
                    this.wh.deleteDir(tablePath, true, ifPurge);
                }
                catch (Exception e) {
                    LOG.error("Failed to delete table directory: " + tablePath + " " + e.getMessage());
                }
            }
        }

        private void deletePartitionData(List<Path> partPaths) {
            this.deletePartitionData(partPaths, false);
        }

        private void deletePartitionData(List<Path> partPaths, boolean ifPurge) {
            if (partPaths != null && !partPaths.isEmpty()) {
                for (Path partPath : partPaths) {
                    try {
                        this.wh.deleteDir(partPath, true, ifPurge);
                    }
                    catch (Exception e) {
                        LOG.error("Failed to delete partition directory: " + partPath + " " + e.getMessage());
                    }
                }
            }
        }

        private List<Path> dropPartitionsAndGetLocations(RawStore ms, String dbName, String tableName, Path tablePath, List<FieldSchema> partitionKeys, boolean checkLocation) throws MetaException, IOException, NoSuchObjectException, InvalidObjectException, InvalidInputException {
            List<Partition> partsToDelete;
            int partitionBatchSize = HiveConf.getIntVar(this.hiveConf, HiveConf.ConfVars.METASTORE_BATCH_RETRIEVE_MAX);
            Path tableDnsPath = null;
            if (tablePath != null) {
                tableDnsPath = this.wh.getDnsPath(tablePath);
            }
            ArrayList<Path> partPaths = new ArrayList<Path>();
            Table tbl = ms.getTable(dbName, tableName);
            while ((partsToDelete = ms.getPartitions(dbName, tableName, partitionBatchSize)) != null && !partsToDelete.isEmpty()) {
                ArrayList<String> partNames = new ArrayList<String>();
                for (Partition part : partsToDelete) {
                    if (checkLocation && part.getSd() != null && part.getSd().getLocation() != null) {
                        Path partPath = this.wh.getDnsPath(new Path(part.getSd().getLocation()));
                        if (tableDnsPath == null || partPath != null && !this.isSubdirectory(tableDnsPath, partPath)) {
                            if (!this.wh.isWritable(partPath.getParent())) {
                                throw new MetaException("Table metadata not deleted since the partition " + Warehouse.makePartName(partitionKeys, part.getValues()) + " has parent location " + partPath.getParent() + " which is not writable " + "by " + this.hiveConf.getUser());
                            }
                            partPaths.add(partPath);
                        }
                    }
                    partNames.add(Warehouse.makePartName(tbl.getPartitionKeys(), part.getValues()));
                }
                ms.dropPartitions(dbName, tableName, partNames);
            }
            return partPaths;
        }

        @Override
        public void drop_table(String dbname, String name, boolean deleteData) throws NoSuchObjectException, MetaException {
            this.drop_table_with_environment_context(dbname, name, deleteData, null);
        }

        @Override
        public void drop_table_with_environment_context(String dbname, String name, boolean deleteData, EnvironmentContext envContext) throws NoSuchObjectException, MetaException {
            this.startTableFunction("drop_table", dbname, name);
            boolean success = false;
            Exception ex = null;
            try {
                success = this.drop_table_core(this.getMS(), dbname, name, deleteData, envContext, null);
            }
            catch (IOException e) {
                ex = e;
                throw new MetaException(e.getMessage());
            }
            catch (Exception e) {
                ex = e;
                if (e instanceof MetaException) {
                    throw (MetaException)e;
                }
                if (e instanceof NoSuchObjectException) {
                    throw (NoSuchObjectException)e;
                }
                throw HMSHandler.newMetaException(e);
            }
            finally {
                this.endFunction("drop_table", success, ex, name);
            }
        }

        private boolean isExternal(Table table) {
            return MetaStoreUtils.isExternalTable(table);
        }

        private boolean isIndexTable(Table table) {
            return MetaStoreUtils.isIndexTable(table);
        }

        /*
         * Loose catch block
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public Table get_table(String dbname, String name) throws MetaException, NoSuchObjectException {
            Table t = null;
            this.startTableFunction("get_table", dbname, name);
            TException ex = null;
            try {
                t = this.get_table_core(dbname, name);
                this.firePreEvent(new PreReadTableEvent(t, this));
                this.endFunction("get_table", t != null, ex, name);
                return t;
            }
            catch (MetaException e) {
                try {
                    ex = e;
                    throw e;
                    catch (NoSuchObjectException e2) {
                        ex = e2;
                        throw e2;
                    }
                }
                catch (Throwable throwable) {
                    this.endFunction("get_table", t != null, ex, name);
                    throw throwable;
                }
            }
        }

        @Override
        public List<TableMeta> get_table_meta(String dbnames, String tblNames, List<String> tblTypes) throws MetaException, NoSuchObjectException {
            List<TableMeta> t = null;
            this.startTableFunction("get_table_metas", dbnames, tblNames);
            Exception ex = null;
            try {
                t = this.getMS().getTableMeta(dbnames, tblNames, tblTypes);
                this.endFunction("get_table_metas", t != null, ex);
            }
            catch (Exception e) {
                try {
                    ex = e;
                    throw HMSHandler.newMetaException(e);
                }
                catch (Throwable throwable) {
                    this.endFunction("get_table_metas", t != null, ex);
                    throw throwable;
                }
            }
            return t;
        }

        public Table get_table_core(String dbname, String name) throws MetaException, NoSuchObjectException {
            Table t;
            try {
                t = this.getMS().getTable(dbname, name);
                if (t == null) {
                    throw new NoSuchObjectException(dbname + "." + name + " table not found");
                }
            }
            catch (Exception e) {
                if (e instanceof MetaException) {
                    throw (MetaException)e;
                }
                if (e instanceof NoSuchObjectException) {
                    throw (NoSuchObjectException)e;
                }
                throw HMSHandler.newMetaException(e);
            }
            return t;
        }

        @Override
        public List<Table> get_table_objects_by_name(String dbName, List<String> tableNames) throws MetaException, InvalidOperationException, UnknownDBException {
            ArrayList<Table> tables = new ArrayList<Table>();
            this.startMultiTableFunction("get_multi_table", dbName, tableNames);
            Exception ex = null;
            int tableBatchSize = HiveConf.getIntVar(this.hiveConf, HiveConf.ConfVars.METASTORE_BATCH_RETRIEVE_MAX);
            try {
                if (dbName == null || dbName.isEmpty()) {
                    throw new UnknownDBException("DB name is null or empty");
                }
                if (tableNames == null) {
                    throw new InvalidOperationException(dbName + " cannot find null tables");
                }
                List<String> distinctTableNames = tableNames;
                if (distinctTableNames.size() > tableBatchSize) {
                    ArrayList<String> lowercaseTableNames = new ArrayList<String>();
                    for (String tableName : tableNames) {
                        lowercaseTableNames.add(HiveStringUtils.normalizeIdentifier(tableName));
                    }
                    distinctTableNames = new ArrayList<String>(new HashSet(lowercaseTableNames));
                }
                RawStore ms = this.getMS();
                int startIndex = 0;
                while (startIndex < distinctTableNames.size()) {
                    int endIndex = Math.min(startIndex + tableBatchSize, distinctTableNames.size());
                    tables.addAll(ms.getTableObjectsByName(dbName, distinctTableNames.subList(startIndex, endIndex)));
                    startIndex = endIndex;
                }
                this.endFunction("get_multi_table", tables != null, ex, StringUtils.join(tableNames, ","));
            }
            catch (Exception e) {
                try {
                    ex = e;
                    if (e instanceof MetaException) {
                        throw (MetaException)e;
                    }
                    if (e instanceof InvalidOperationException) {
                        throw (InvalidOperationException)e;
                    }
                    if (e instanceof UnknownDBException) {
                        throw (UnknownDBException)e;
                    }
                    throw HMSHandler.newMetaException(e);
                }
                catch (Throwable throwable) {
                    this.endFunction("get_multi_table", tables != null, ex, StringUtils.join(tableNames, ","));
                    throw throwable;
                }
            }
            return tables;
        }

        @Override
        public List<String> get_table_names_by_filter(String dbName, String filter, short maxTables) throws MetaException, InvalidOperationException, UnknownDBException {
            List<String> tables = null;
            this.startFunction("get_table_names_by_filter", ": db = " + dbName + ", filter = " + filter);
            Exception ex = null;
            try {
                if (dbName == null || dbName.isEmpty()) {
                    throw new UnknownDBException("DB name is null or empty");
                }
                if (filter == null) {
                    throw new InvalidOperationException(filter + " cannot apply null filter");
                }
                tables = this.getMS().listTableNamesByFilter(dbName, filter, maxTables);
                this.endFunction("get_table_names_by_filter", tables != null, ex, StringUtils.join(tables, ","));
            }
            catch (Exception e) {
                try {
                    ex = e;
                    if (e instanceof MetaException) {
                        throw (MetaException)e;
                    }
                    if (e instanceof InvalidOperationException) {
                        throw (InvalidOperationException)e;
                    }
                    if (e instanceof UnknownDBException) {
                        throw (UnknownDBException)e;
                    }
                    throw HMSHandler.newMetaException(e);
                }
                catch (Throwable throwable) {
                    this.endFunction("get_table_names_by_filter", tables != null, ex, StringUtils.join(tables, ","));
                    throw throwable;
                }
            }
            return tables;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Partition append_partition_common(RawStore ms, String dbName, String tableName, List<String> part_vals, EnvironmentContext envContext) throws InvalidObjectException, AlreadyExistsException, MetaException {
            Table tbl;
            boolean success;
            Partition part;
            block15: {
                part = new Partition();
                success = false;
                boolean madeDir = false;
                Path partLocation = null;
                tbl = null;
                try {
                    ms.openTransaction();
                    part.setDbName(dbName);
                    part.setTableName(tableName);
                    part.setValues(part_vals);
                    MetaStoreUtils.validatePartitionNameCharacters(part_vals, this.partitionValidationPattern);
                    tbl = ms.getTable(part.getDbName(), part.getTableName());
                    if (tbl == null) {
                        throw new InvalidObjectException("Unable to add partition because table or database do not exist");
                    }
                    if (tbl.getSd().getLocation() == null) {
                        throw new MetaException("Cannot append a partition to a view");
                    }
                    this.firePreEvent(new PreAddPartitionEvent(tbl, part, this));
                    part.setSd(tbl.getSd().deepCopy());
                    partLocation = new Path(tbl.getSd().getLocation(), Warehouse.makePartName(tbl.getPartitionKeys(), part_vals));
                    part.getSd().setLocation(partLocation.toString());
                    Partition old_part = null;
                    try {
                        old_part = ms.getPartition(part.getDbName(), part.getTableName(), part.getValues());
                    }
                    catch (NoSuchObjectException e) {
                        old_part = null;
                    }
                    if (old_part != null) {
                        throw new AlreadyExistsException("Partition already exists:" + part);
                    }
                    if (!this.wh.isDir(partLocation)) {
                        if (!this.wh.mkdirs(partLocation, true)) {
                            throw new MetaException(partLocation + " is not a directory or unable to create one");
                        }
                        madeDir = true;
                    }
                    long time = System.currentTimeMillis() / 1000L;
                    part.setCreateTime((int)time);
                    part.putToParameters("transient_lastDdlTime", Long.toString(time));
                    if (HiveConf.getBoolVar(this.hiveConf, HiveConf.ConfVars.HIVESTATSAUTOGATHER) && !MetaStoreUtils.isView(tbl)) {
                        MetaStoreUtils.updatePartitionStatsFast(part, this.wh, madeDir);
                    }
                    if (success = ms.addPartition(part)) {
                        success = ms.commitTransaction();
                    }
                    if (success) break block15;
                    ms.rollbackTransaction();
                    if (!madeDir) break block15;
                }
                catch (Throwable throwable) {
                    if (!success) {
                        ms.rollbackTransaction();
                        if (madeDir) {
                            this.wh.deleteDir(partLocation, true);
                        }
                    }
                    for (MetaStoreEventListener listener : this.listeners) {
                        AddPartitionEvent addPartitionEvent = new AddPartitionEvent(tbl, part, success, this);
                        addPartitionEvent.setEnvironmentContext(envContext);
                        listener.onAddPartition(addPartitionEvent);
                    }
                    throw throwable;
                }
                this.wh.deleteDir(partLocation, true);
            }
            for (MetaStoreEventListener listener : this.listeners) {
                AddPartitionEvent addPartitionEvent = new AddPartitionEvent(tbl, part, success, this);
                addPartitionEvent.setEnvironmentContext(envContext);
                listener.onAddPartition(addPartitionEvent);
            }
            return part;
        }

        private void firePreEvent(PreEventContext event) throws MetaException {
            for (MetaStorePreEventListener listener : this.preListeners) {
                try {
                    listener.onEvent(event);
                }
                catch (NoSuchObjectException e) {
                    throw new MetaException(e.getMessage());
                }
                catch (InvalidOperationException e) {
                    throw new MetaException(e.getMessage());
                }
            }
        }

        @Override
        public Partition append_partition(String dbName, String tableName, List<String> part_vals) throws InvalidObjectException, AlreadyExistsException, MetaException {
            return this.append_partition_with_environment_context(dbName, tableName, part_vals, null);
        }

        @Override
        public Partition append_partition_with_environment_context(String dbName, String tableName, List<String> part_vals, EnvironmentContext envContext) throws InvalidObjectException, AlreadyExistsException, MetaException {
            this.startPartitionFunction("append_partition", dbName, tableName, part_vals);
            if (LOG.isDebugEnabled()) {
                for (String part : part_vals) {
                    LOG.debug(part);
                }
            }
            Partition ret = null;
            Exception ex = null;
            try {
                ret = this.append_partition_common(this.getMS(), dbName, tableName, part_vals, envContext);
                this.endFunction("append_partition", ret != null, ex, tableName);
            }
            catch (Exception e) {
                try {
                    ex = e;
                    if (e instanceof MetaException) {
                        throw (MetaException)e;
                    }
                    if (e instanceof InvalidObjectException) {
                        throw (InvalidObjectException)e;
                    }
                    if (e instanceof AlreadyExistsException) {
                        throw (AlreadyExistsException)e;
                    }
                    throw HMSHandler.newMetaException(e);
                }
                catch (Throwable throwable) {
                    this.endFunction("append_partition", ret != null, ex, tableName);
                    throw throwable;
                }
            }
            return ret;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private List<Partition> add_partitions_core(RawStore ms, String dbName, String tblName, List<Partition> parts, boolean ifNotExists) throws MetaException, InvalidObjectException, AlreadyExistsException, TException {
            ArrayList<Partition> result;
            block16: {
                Table tbl;
                ArrayList<Partition> existingParts;
                block15: {
                    this.logInfo("add_partitions");
                    boolean success = false;
                    HashMap<PartValEqWrapper, Boolean> addedPartitions = new HashMap<PartValEqWrapper, Boolean>();
                    result = new ArrayList<Partition>();
                    existingParts = null;
                    tbl = null;
                    try {
                        ms.openTransaction();
                        tbl = ms.getTable(dbName, tblName);
                        if (tbl == null) {
                            throw new InvalidObjectException("Unable to add partitions because database or table " + dbName + "." + tblName + " does not exist");
                        }
                        if (!parts.isEmpty()) {
                            this.firePreEvent(new PreAddPartitionEvent(tbl, parts, this));
                        }
                        for (Partition partition : parts) {
                            if (!partition.getTableName().equals(tblName) || !partition.getDbName().equals(dbName)) {
                                throw new MetaException("Partition does not belong to target table " + dbName + "." + tblName + ": " + partition);
                            }
                            boolean shouldAdd = this.startAddPartition(ms, partition, ifNotExists);
                            if (!shouldAdd) {
                                if (existingParts == null) {
                                    existingParts = new ArrayList<Partition>();
                                }
                                existingParts.add(partition);
                                LOG.info("Not adding partition " + partition + " as it already exists");
                                continue;
                            }
                            boolean madeDir = this.createLocationForAddedPartition(tbl, partition);
                            if (addedPartitions.put(new PartValEqWrapper(partition), madeDir) != null) {
                                throw new MetaException("Duplicate partitions in the list: " + partition);
                            }
                            this.initializeAddedPartition(tbl, partition, madeDir);
                            result.add(partition);
                        }
                        success = !result.isEmpty() ? ms.addPartitions(dbName, tblName, result) : true;
                        boolean bl = success = success && ms.commitTransaction();
                        if (success) break block15;
                        ms.rollbackTransaction();
                    }
                    catch (Throwable throwable) {
                        if (!success) {
                            ms.rollbackTransaction();
                            for (Map.Entry e : addedPartitions.entrySet()) {
                                if (!((Boolean)e.getValue()).booleanValue()) continue;
                                this.wh.deleteDir(new Path(((PartValEqWrapper)e.getKey()).partition.getSd().getLocation()), true);
                            }
                            this.fireMetaStoreAddPartitionEvent(tbl, parts, null, false);
                        } else {
                            this.fireMetaStoreAddPartitionEvent(tbl, result, null, true);
                            if (existingParts != null) {
                                this.fireMetaStoreAddPartitionEvent(tbl, existingParts, null, false);
                            }
                        }
                        throw throwable;
                    }
                    for (Map.Entry entry : addedPartitions.entrySet()) {
                        if (!((Boolean)entry.getValue()).booleanValue()) continue;
                        this.wh.deleteDir(new Path(((PartValEqWrapper)entry.getKey()).partition.getSd().getLocation()), true);
                    }
                    this.fireMetaStoreAddPartitionEvent(tbl, parts, null, false);
                    break block16;
                }
                this.fireMetaStoreAddPartitionEvent(tbl, result, null, true);
                if (existingParts != null) {
                    this.fireMetaStoreAddPartitionEvent(tbl, existingParts, null, false);
                }
            }
            return result;
        }

        @Override
        public AddPartitionsResult add_partitions_req(AddPartitionsRequest request) throws InvalidObjectException, AlreadyExistsException, MetaException, TException {
            AddPartitionsResult result = new AddPartitionsResult();
            if (request.getParts().isEmpty()) {
                return result;
            }
            try {
                List<Partition> parts = this.add_partitions_core(this.getMS(), request.getDbName(), request.getTblName(), request.getParts(), request.isIfNotExists());
                if (request.isNeedResult()) {
                    result.setPartitions(parts);
                }
            }
            catch (TException te) {
                throw te;
            }
            catch (Exception e) {
                throw HMSHandler.newMetaException(e);
            }
            return result;
        }

        @Override
        public int add_partitions(List<Partition> parts) throws MetaException, InvalidObjectException, AlreadyExistsException {
            this.startFunction("add_partition");
            if (parts.size() == 0) {
                return 0;
            }
            Integer ret = null;
            Exception ex = null;
            try {
                ret = this.add_partitions_core(this.getMS(), parts.get(0).getDbName(), parts.get(0).getTableName(), parts, false).size();
                assert (ret.intValue() == parts.size());
                String tableName = parts.get(0).getTableName();
                this.endFunction("add_partition", ret != null, ex, tableName);
            }
            catch (Exception e) {
                try {
                    ex = e;
                    if (e instanceof MetaException) {
                        throw (MetaException)e;
                    }
                    if (e instanceof InvalidObjectException) {
                        throw (InvalidObjectException)e;
                    }
                    if (e instanceof AlreadyExistsException) {
                        throw (AlreadyExistsException)e;
                    }
                    throw HMSHandler.newMetaException(e);
                }
                catch (Throwable throwable) {
                    String tableName = parts.get(0).getTableName();
                    this.endFunction("add_partition", ret != null, ex, tableName);
                    throw throwable;
                }
            }
            return ret;
        }

        @Override
        public int add_partitions_pspec(List<PartitionSpec> partSpecs) throws TException {
            this.logInfo("add_partitions_pspec");
            if (partSpecs.isEmpty()) {
                return 0;
            }
            String dbName = partSpecs.get(0).getDbName();
            String tableName = partSpecs.get(0).getTableName();
            return this.add_partitions_pspec_core(this.getMS(), dbName, tableName, partSpecs, false);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private int add_partitions_pspec_core(RawStore ms, String dbName, String tblName, List<PartitionSpec> partSpecs, boolean ifNotExists) throws TException {
            int n;
            Table tbl;
            PartitionSpecProxy partitionSpecProxy;
            block10: {
                boolean success = false;
                HashMap<PartValEqWrapperLite, Boolean> addedPartitions = new HashMap<PartValEqWrapperLite, Boolean>();
                partitionSpecProxy = PartitionSpecProxy.Factory.get(partSpecs);
                PartitionSpecProxy.PartitionIterator partitionIterator = partitionSpecProxy.getPartitionIterator();
                tbl = null;
                try {
                    ms.openTransaction();
                    tbl = ms.getTable(dbName, tblName);
                    if (tbl == null) {
                        throw new InvalidObjectException("Unable to add partitions because database or table " + dbName + "." + tblName + " does not exist");
                    }
                    this.firePreEvent(new PreAddPartitionEvent(tbl, partitionSpecProxy, this));
                    int nPartitions = 0;
                    while (partitionIterator.hasNext()) {
                        Partition part = partitionIterator.getCurrent();
                        if (!part.getTableName().equals(tblName) || !part.getDbName().equals(dbName)) {
                            throw new MetaException("Partition does not belong to target table " + dbName + "." + tblName + ": " + part);
                        }
                        boolean shouldAdd = this.startAddPartition(ms, part, ifNotExists);
                        if (!shouldAdd) {
                            LOG.info("Not adding partition " + part + " as it already exists");
                            continue;
                        }
                        boolean madeDir = this.createLocationForAddedPartition(tbl, part);
                        if (addedPartitions.put(new PartValEqWrapperLite(part), madeDir) != null) {
                            throw new MetaException("Duplicate partitions in the list: " + part);
                        }
                        this.initializeAddedPartition(tbl, partitionIterator, madeDir);
                        ++nPartitions;
                        partitionIterator.next();
                    }
                    success = ms.addPartitions(dbName, tblName, partitionSpecProxy, ifNotExists) && ms.commitTransaction();
                    n = nPartitions;
                    if (success) break block10;
                    ms.rollbackTransaction();
                }
                catch (Throwable throwable) {
                    if (!success) {
                        ms.rollbackTransaction();
                        for (Map.Entry e : addedPartitions.entrySet()) {
                            if (!((Boolean)e.getValue()).booleanValue()) continue;
                            this.wh.deleteDir(new Path(((PartValEqWrapperLite)e.getKey()).location), true);
                        }
                    }
                    this.fireMetaStoreAddPartitionEvent(tbl, partitionSpecProxy, null, true);
                    throw throwable;
                }
                for (Map.Entry e : addedPartitions.entrySet()) {
                    if (!((Boolean)e.getValue()).booleanValue()) continue;
                    this.wh.deleteDir(new Path(((PartValEqWrapperLite)e.getKey()).location), true);
                }
            }
            this.fireMetaStoreAddPartitionEvent(tbl, partitionSpecProxy, null, true);
            return n;
        }

        private boolean startAddPartition(RawStore ms, Partition part, boolean ifNotExists) throws MetaException, TException {
            MetaStoreUtils.validatePartitionNameCharacters(part.getValues(), this.partitionValidationPattern);
            boolean doesExist = ms.doesPartitionExist(part.getDbName(), part.getTableName(), part.getValues());
            if (doesExist && !ifNotExists) {
                throw new AlreadyExistsException("Partition already exists: " + part);
            }
            return !doesExist;
        }

        private boolean createLocationForAddedPartition(Table tbl, Partition part) throws MetaException {
            Path partLocation = null;
            String partLocationStr = null;
            if (part.getSd() != null) {
                partLocationStr = part.getSd().getLocation();
            }
            if (partLocationStr == null || partLocationStr.isEmpty()) {
                if (tbl.getSd().getLocation() != null) {
                    partLocation = new Path(tbl.getSd().getLocation(), Warehouse.makePartName(tbl.getPartitionKeys(), part.getValues()));
                }
            } else {
                if (tbl.getSd().getLocation() == null) {
                    throw new MetaException("Cannot specify location for a view partition");
                }
                partLocation = this.wh.getDnsPath(new Path(partLocationStr));
            }
            boolean result = false;
            if (partLocation != null) {
                part.getSd().setLocation(partLocation.toString());
                if (!this.wh.isDir(partLocation)) {
                    if (!this.wh.mkdirs(partLocation, true)) {
                        throw new MetaException(partLocation + " is not a directory or unable to create one");
                    }
                    result = true;
                }
            }
            return result;
        }

        private void initializeAddedPartition(Table tbl, Partition part, boolean madeDir) throws MetaException {
            this.initializeAddedPartition(tbl, new PartitionSpecProxy.SimplePartitionWrapperIterator(part), madeDir);
        }

        private void initializeAddedPartition(Table tbl, PartitionSpecProxy.PartitionIterator part, boolean madeDir) throws MetaException {
            if (HiveConf.getBoolVar(this.hiveConf, HiveConf.ConfVars.HIVESTATSAUTOGATHER) && !MetaStoreUtils.isView(tbl)) {
                MetaStoreUtils.updatePartitionStatsFast(part, this.wh, madeDir, false);
            }
            long time = System.currentTimeMillis() / 1000L;
            part.setCreateTime((int)time);
            if (part.getParameters() == null || part.getParameters().get("transient_lastDdlTime") == null) {
                part.putToParameters("transient_lastDdlTime", Long.toString(time));
            }
            Map<String, String> tblParams = tbl.getParameters();
            String inheritProps = this.hiveConf.getVar(HiveConf.ConfVars.METASTORE_PART_INHERIT_TBL_PROPS).trim();
            Set<String> inheritKeys = new HashSet<String>(Arrays.asList(inheritProps.split(",")));
            if (inheritKeys.contains("*")) {
                inheritKeys = tblParams.keySet();
            }
            for (String key : inheritKeys) {
                String paramVal = tblParams.get(key);
                if (null == paramVal) continue;
                part.putToParameters(key, paramVal);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Partition add_partition_core(RawStore ms, Partition part, EnvironmentContext envContext) throws InvalidObjectException, AlreadyExistsException, MetaException, TException {
            boolean success = false;
            Table tbl = null;
            try {
                ms.openTransaction();
                tbl = ms.getTable(part.getDbName(), part.getTableName());
                if (tbl == null) {
                    throw new InvalidObjectException("Unable to add partition because table or database do not exist");
                }
                this.firePreEvent(new PreAddPartitionEvent(tbl, part, this));
                boolean shouldAdd = this.startAddPartition(ms, part, false);
                assert (shouldAdd);
                boolean madeDir = this.createLocationForAddedPartition(tbl, part);
                try {
                    this.initializeAddedPartition(tbl, part, madeDir);
                    success = ms.addPartition(part);
                }
                finally {
                    if (!success && madeDir) {
                        this.wh.deleteDir(new Path(part.getSd().getLocation()), true);
                    }
                }
                boolean bl = success = success && ms.commitTransaction();
                if (!success) {
                    ms.rollbackTransaction();
                }
            }
            catch (Throwable throwable) {
                if (!success) {
                    ms.rollbackTransaction();
                }
                this.fireMetaStoreAddPartitionEvent(tbl, Arrays.asList(part), envContext, success);
                throw throwable;
            }
            this.fireMetaStoreAddPartitionEvent(tbl, Arrays.asList(part), envContext, success);
            return part;
        }

        private void fireMetaStoreAddPartitionEvent(Table tbl, List<Partition> parts, EnvironmentContext envContext, boolean success) throws MetaException {
            if (tbl != null && parts != null && !parts.isEmpty()) {
                AddPartitionEvent addPartitionEvent = new AddPartitionEvent(tbl, parts, success, this);
                addPartitionEvent.setEnvironmentContext(envContext);
                for (MetaStoreEventListener listener : this.listeners) {
                    listener.onAddPartition(addPartitionEvent);
                }
            }
        }

        private void fireMetaStoreAddPartitionEvent(Table tbl, PartitionSpecProxy partitionSpec, EnvironmentContext envContext, boolean success) throws MetaException {
            if (tbl != null && partitionSpec != null) {
                AddPartitionEvent addPartitionEvent = new AddPartitionEvent(tbl, partitionSpec, success, this);
                addPartitionEvent.setEnvironmentContext(envContext);
                for (MetaStoreEventListener listener : this.listeners) {
                    listener.onAddPartition(addPartitionEvent);
                }
            }
        }

        @Override
        public Partition add_partition(Partition part) throws InvalidObjectException, AlreadyExistsException, MetaException {
            return this.add_partition_with_environment_context(part, null);
        }

        @Override
        public Partition add_partition_with_environment_context(Partition part, EnvironmentContext envContext) throws InvalidObjectException, AlreadyExistsException, MetaException {
            this.startTableFunction("add_partition", part.getDbName(), part.getTableName());
            Partition ret = null;
            Exception ex = null;
            try {
                ret = this.add_partition_core(this.getMS(), part, envContext);
                this.endFunction("add_partition", ret != null, ex, part != null ? part.getTableName() : null);
            }
            catch (Exception e) {
                try {
                    ex = e;
                    if (e instanceof MetaException) {
                        throw (MetaException)e;
                    }
                    if (e instanceof InvalidObjectException) {
                        throw (InvalidObjectException)e;
                    }
                    if (e instanceof AlreadyExistsException) {
                        throw (AlreadyExistsException)e;
                    }
                    throw HMSHandler.newMetaException(e);
                }
                catch (Throwable throwable) {
                    this.endFunction("add_partition", ret != null, ex, part != null ? part.getTableName() : null);
                    throw throwable;
                }
            }
            return ret;
        }

        @Override
        public Partition exchange_partition(Map<String, String> partitionSpecs, String sourceDbName, String sourceTableName, String destDbName, String destTableName) throws MetaException, NoSuchObjectException, InvalidObjectException, InvalidInputException, TException {
            this.exchange_partitions(partitionSpecs, sourceDbName, sourceTableName, destDbName, destTableName);
            return new Partition();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public List<Partition> exchange_partitions(Map<String, String> partitionSpecs, String sourceDbName, String sourceTableName, String destDbName, String destTableName) throws MetaException, NoSuchObjectException, InvalidObjectException, InvalidInputException, TException {
            boolean success = false;
            boolean pathCreated = false;
            RawStore ms = this.getMS();
            ms.openTransaction();
            Table destinationTable = ms.getTable(destDbName, destTableName);
            Table sourceTable = ms.getTable(sourceDbName, sourceTableName);
            List<String> partVals = MetaStoreUtils.getPvals(sourceTable.getPartitionKeys(), partitionSpecs);
            ArrayList<String> partValsPresent = new ArrayList<String>();
            ArrayList<FieldSchema> partitionKeysPresent = new ArrayList<FieldSchema>();
            int i = 0;
            for (FieldSchema fs : sourceTable.getPartitionKeys()) {
                String partVal = partVals.get(i);
                if (partVal != null && !partVal.equals("")) {
                    partValsPresent.add(partVal);
                    partitionKeysPresent.add(fs);
                }
                ++i;
            }
            List<Partition> partitionsToExchange = this.get_partitions_ps(sourceDbName, sourceTableName, partVals, (short)-1);
            boolean sameColumns = MetaStoreUtils.compareFieldColumns(sourceTable.getSd().getCols(), destinationTable.getSd().getCols());
            boolean samePartitions = MetaStoreUtils.compareFieldColumns(sourceTable.getPartitionKeys(), destinationTable.getPartitionKeys());
            if (!sameColumns || !samePartitions) {
                throw new MetaException("The tables have different schemas. Their partitions cannot be exchanged.");
            }
            Path sourcePath = new Path(sourceTable.getSd().getLocation(), Warehouse.makePartName(partitionKeysPresent, partValsPresent));
            Path destPath = new Path(destinationTable.getSd().getLocation(), Warehouse.makePartName(partitionKeysPresent, partValsPresent));
            try {
                ArrayList<Partition> destPartitions = new ArrayList<Partition>();
                for (Partition partition : partitionsToExchange) {
                    Partition destPartition = new Partition(partition);
                    destPartition.setDbName(destDbName);
                    destPartition.setTableName(destinationTable.getTableName());
                    Path destPartitionPath = new Path(destinationTable.getSd().getLocation(), Warehouse.makePartName(destinationTable.getPartitionKeys(), partition.getValues()));
                    destPartition.getSd().setLocation(destPartitionPath.toString());
                    ms.addPartition(destPartition);
                    destPartitions.add(destPartition);
                    ms.dropPartition(partition.getDbName(), sourceTable.getTableName(), partition.getValues());
                }
                Path destParentPath = destPath.getParent();
                if (!this.wh.isDir(destParentPath) && !this.wh.mkdirs(destParentPath, true)) {
                    throw new MetaException("Unable to create path " + destParentPath);
                }
                pathCreated = this.wh.renameDir(sourcePath, destPath);
                success = ms.commitTransaction();
                ArrayList<Partition> arrayList = destPartitions;
                return arrayList;
            }
            finally {
                if (!success || !pathCreated) {
                    ms.rollbackTransaction();
                    if (pathCreated) {
                        this.wh.renameDir(destPath, sourcePath);
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean drop_partition_common(RawStore ms, String db_name, String tbl_name, List<String> part_vals, boolean deleteData, EnvironmentContext envContext) throws MetaException, NoSuchObjectException, IOException, InvalidObjectException, InvalidInputException {
            Partition part;
            Table tbl;
            boolean success;
            block22: {
                boolean mustPurge;
                Path archiveParentDir;
                boolean isArchived;
                Path partPath;
                block24: {
                    block23: {
                        success = false;
                        partPath = null;
                        tbl = null;
                        part = null;
                        isArchived = false;
                        archiveParentDir = null;
                        mustPurge = false;
                        try {
                            ms.openTransaction();
                            part = ms.getPartition(db_name, tbl_name, part_vals);
                            tbl = this.get_table_core(db_name, tbl_name);
                            this.firePreEvent(new PreDropPartitionEvent(tbl, part, deleteData, this));
                            mustPurge = HMSHandler.isMustPurge(envContext, tbl);
                            if (part == null) {
                                throw new NoSuchObjectException("Partition doesn't exist. " + part_vals);
                            }
                            isArchived = MetaStoreUtils.isArchived(part);
                            if (isArchived) {
                                archiveParentDir = MetaStoreUtils.getOriginalLocation(part);
                                this.verifyIsWritablePath(archiveParentDir);
                                this.checkTrashPurgeCombination(archiveParentDir, db_name + "." + tbl_name + "." + part_vals, mustPurge);
                            }
                            if (!ms.dropPartition(db_name, tbl_name, part_vals)) {
                                throw new MetaException("Unable to drop partition");
                            }
                            success = ms.commitTransaction();
                            if (part.getSd() != null && part.getSd().getLocation() != null) {
                                partPath = new Path(part.getSd().getLocation());
                                this.verifyIsWritablePath(partPath);
                                this.checkTrashPurgeCombination(partPath, db_name + "." + tbl_name + "." + part_vals, mustPurge);
                            }
                            if (!success) {
                                ms.rollbackTransaction();
                                break block22;
                            }
                            if (!deleteData || partPath == null && archiveParentDir == null || tbl == null || this.isExternal(tbl)) break block22;
                            if (!mustPurge) break block23;
                        }
                        catch (Throwable throwable) {
                            if (!success) {
                                ms.rollbackTransaction();
                            } else if (deleteData && (partPath != null || archiveParentDir != null) && tbl != null && !this.isExternal(tbl)) {
                                if (mustPurge) {
                                    LOG.info("dropPartition() will purge " + partPath + " directly, skipping trash.");
                                } else {
                                    LOG.info("dropPartition() will move " + partPath + " to trash-directory.");
                                }
                                if (isArchived) {
                                    assert (archiveParentDir != null);
                                    this.wh.deleteDir(archiveParentDir, true, mustPurge);
                                } else {
                                    assert (partPath != null);
                                    this.wh.deleteDir(partPath, true, mustPurge);
                                    this.deleteParentRecursive(partPath.getParent(), part_vals.size() - 1, mustPurge);
                                }
                            }
                            for (MetaStoreEventListener listener : this.listeners) {
                                DropPartitionEvent dropPartitionEvent = new DropPartitionEvent(tbl, part, success, deleteData, this);
                                dropPartitionEvent.setEnvironmentContext(envContext);
                                listener.onDropPartition(dropPartitionEvent);
                            }
                            throw throwable;
                        }
                        LOG.info("dropPartition() will purge " + partPath + " directly, skipping trash.");
                        break block24;
                    }
                    LOG.info("dropPartition() will move " + partPath + " to trash-directory.");
                }
                if (isArchived) {
                    assert (archiveParentDir != null);
                    this.wh.deleteDir(archiveParentDir, true, mustPurge);
                } else {
                    assert (partPath != null);
                    this.wh.deleteDir(partPath, true, mustPurge);
                    this.deleteParentRecursive(partPath.getParent(), part_vals.size() - 1, mustPurge);
                }
            }
            for (MetaStoreEventListener listener : this.listeners) {
                DropPartitionEvent dropPartitionEvent = new DropPartitionEvent(tbl, part, success, deleteData, this);
                dropPartitionEvent.setEnvironmentContext(envContext);
                listener.onDropPartition(dropPartitionEvent);
            }
            return true;
        }

        private static boolean isMustPurge(EnvironmentContext envContext, Table tbl) {
            return envContext != null && Boolean.parseBoolean(envContext.getProperties().get("ifPurge")) || tbl.isSetParameters() && "true".equalsIgnoreCase(tbl.getParameters().get("auto.purge"));
        }

        private void deleteParentRecursive(Path parent, int depth, boolean mustPurge) throws IOException, MetaException {
            if (depth > 0 && parent != null && this.wh.isWritable(parent) && this.wh.isEmpty(parent)) {
                this.wh.deleteDir(parent, true, mustPurge);
                this.deleteParentRecursive(parent.getParent(), depth - 1, mustPurge);
            }
        }

        @Override
        public boolean drop_partition(String db_name, String tbl_name, List<String> part_vals, boolean deleteData) throws NoSuchObjectException, MetaException, TException {
            return this.drop_partition_with_environment_context(db_name, tbl_name, part_vals, deleteData, null);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public DropPartitionsResult drop_partitions_req(DropPartitionsRequest request) throws MetaException, NoSuchObjectException, TException {
            DropPartitionsResult dropPartitionsResult;
            List<Object> parts;
            Table tbl;
            boolean success;
            EnvironmentContext envContext;
            boolean deleteData;
            block35: {
                RawStore ms = this.getMS();
                String dbName = request.getDbName();
                String tblName = request.getTblName();
                boolean ifExists = request.isSetIfExists() && request.isIfExists();
                deleteData = request.isSetDeleteData() && request.isDeleteData();
                boolean ignoreProtection = request.isSetIgnoreProtection() && request.isIgnoreProtection();
                boolean needResult = !request.isSetNeedResult() || request.isNeedResult();
                ArrayList<PathAndPartValSize> dirsToDelete = new ArrayList<PathAndPartValSize>();
                ArrayList<Path> archToDelete = new ArrayList<Path>();
                envContext = request.isSetEnvironmentContext() ? request.getEnvironmentContext() : null;
                success = false;
                ms.openTransaction();
                tbl = null;
                parts = null;
                boolean mustPurge = false;
                try {
                    tbl = this.get_table_core(dbName, tblName);
                    mustPurge = HMSHandler.isMustPurge(envContext, tbl);
                    int minCount = 0;
                    RequestPartsSpec spec = request.getParts();
                    List<String> partNames = null;
                    if (spec.isSetExprs()) {
                        parts = new ArrayList(spec.getExprs().size());
                        for (DropPartitionsExpr expr : spec.getExprs()) {
                            ++minCount;
                            ArrayList<Partition> dropPartitionsResult2 = new ArrayList<Partition>();
                            boolean hasUnknown = ms.getPartitionsByExpr(dbName, tblName, expr.getExpr(), null, (short)-1, dropPartitionsResult2);
                            if (hasUnknown) {
                                throw new MetaException("Unexpected unknown partitions to drop");
                            }
                            if (!ignoreProtection && expr.isSetPartArchiveLevel()) {
                                for (Partition partition : parts) {
                                    if (!MetaStoreUtils.isArchived(partition) || MetaStoreUtils.getArchivingLevel(partition) >= expr.getPartArchiveLevel()) continue;
                                    throw new MetaException("Cannot drop a subset of partitions  in an archive, partition " + partition);
                                }
                            }
                            parts.addAll(dropPartitionsResult2);
                        }
                    } else if (spec.isSetNames()) {
                        partNames = spec.getNames();
                        minCount = partNames.size();
                        parts = ms.getPartitionsByNames(dbName, tblName, partNames);
                    } else {
                        throw new MetaException("Partition spec is not set");
                    }
                    if (parts.size() < minCount && !ifExists) {
                        throw new NoSuchObjectException("Some partitions to drop are missing");
                    }
                    ArrayList<String> colNames = null;
                    if (partNames == null) {
                        partNames = new ArrayList<String>(parts.size());
                        colNames = new ArrayList<String>(tbl.getPartitionKeys().size());
                        for (FieldSchema fieldSchema : tbl.getPartitionKeys()) {
                            colNames.add(fieldSchema.getName());
                        }
                    }
                    for (Partition partition : parts) {
                        this.firePreEvent(new PreDropPartitionEvent(tbl, partition, deleteData, this));
                        if (colNames != null) {
                            partNames.add(FileUtils.makePartName(colNames, partition.getValues()));
                        }
                        if (MetaStoreUtils.isArchived(partition)) {
                            Path archiveParentDir = MetaStoreUtils.getOriginalLocation(partition);
                            this.verifyIsWritablePath(archiveParentDir);
                            this.checkTrashPurgeCombination(archiveParentDir, dbName + "." + tblName + "." + partition.getValues(), mustPurge);
                            archToDelete.add(archiveParentDir);
                        }
                        if (partition.getSd() == null || partition.getSd().getLocation() == null) continue;
                        Path partPath = new Path(partition.getSd().getLocation());
                        this.verifyIsWritablePath(partPath);
                        this.checkTrashPurgeCombination(partPath, dbName + "." + tblName + "." + partition.getValues(), mustPurge);
                        dirsToDelete.add(new PathAndPartValSize(partPath, partition.getValues().size()));
                    }
                    ms.dropPartitions(dbName, tblName, partNames);
                    success = ms.commitTransaction();
                    DropPartitionsResult result = new DropPartitionsResult();
                    if (needResult) {
                        result.setPartitions(parts);
                    }
                    dropPartitionsResult = result;
                    if (!success) {
                        ms.rollbackTransaction();
                        break block35;
                    }
                    if (!deleteData || this.isExternal(tbl)) break block35;
                    LOG.info(mustPurge ? "dropPartition() will purge partition-directories directly, skipping trash." : "dropPartition() will move partition-directories to trash-directory.");
                }
                catch (Throwable throwable) {
                    if (!success) {
                        ms.rollbackTransaction();
                    } else if (deleteData && !this.isExternal(tbl)) {
                        LOG.info(mustPurge ? "dropPartition() will purge partition-directories directly, skipping trash." : "dropPartition() will move partition-directories to trash-directory.");
                        for (Path path : archToDelete) {
                            this.wh.deleteDir(path, true, mustPurge);
                        }
                        for (PathAndPartValSize pathAndPartValSize : dirsToDelete) {
                            this.wh.deleteDir(pathAndPartValSize.path, true, mustPurge);
                            try {
                                this.deleteParentRecursive(pathAndPartValSize.path.getParent(), pathAndPartValSize.partValSize - 1, mustPurge);
                            }
                            catch (IOException ex) {
                                LOG.warn("Error from deleteParentRecursive", (Throwable)ex);
                                throw new MetaException("Failed to delete parent: " + ex.getMessage());
                            }
                        }
                    }
                    if (parts != null) {
                        for (Partition partition : parts) {
                            for (MetaStoreEventListener listener : this.listeners) {
                                DropPartitionEvent dropPartitionEvent = new DropPartitionEvent(tbl, partition, success, deleteData, this);
                                dropPartitionEvent.setEnvironmentContext(envContext);
                                listener.onDropPartition(dropPartitionEvent);
                            }
                        }
                    }
                    throw throwable;
                }
                for (Path path : archToDelete) {
                    this.wh.deleteDir(path, true, mustPurge);
                }
                for (PathAndPartValSize pathAndPartValSize : dirsToDelete) {
                    this.wh.deleteDir(pathAndPartValSize.path, true, mustPurge);
                    try {
                        this.deleteParentRecursive(pathAndPartValSize.path.getParent(), pathAndPartValSize.partValSize - 1, mustPurge);
                    }
                    catch (IOException iOException) {
                        LOG.warn("Error from deleteParentRecursive", (Throwable)iOException);
                        throw new MetaException("Failed to delete parent: " + iOException.getMessage());
                    }
                }
            }
            if (parts != null) {
                for (Partition partition : parts) {
                    for (MetaStoreEventListener listener : this.listeners) {
                        DropPartitionEvent dropPartitionEvent = new DropPartitionEvent(tbl, partition, success, deleteData, this);
                        dropPartitionEvent.setEnvironmentContext(envContext);
                        listener.onDropPartition(dropPartitionEvent);
                    }
                }
            }
            return dropPartitionsResult;
        }

        private void verifyIsWritablePath(Path dir) throws MetaException {
            try {
                if (!this.wh.isWritable(dir.getParent())) {
                    throw new MetaException("Table partition not deleted since " + dir.getParent() + " is not writable by " + this.hiveConf.getUser());
                }
            }
            catch (IOException ex) {
                LOG.warn("Error from isWritable", (Throwable)ex);
                throw new MetaException("Table partition not deleted since " + dir.getParent() + " access cannot be checked: " + ex.getMessage());
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean drop_partition_with_environment_context(String db_name, String tbl_name, List<String> part_vals, boolean deleteData, EnvironmentContext envContext) throws NoSuchObjectException, MetaException, TException {
            this.startPartitionFunction("drop_partition", db_name, tbl_name, part_vals);
            LOG.info("Partition values:" + part_vals);
            boolean ret = false;
            Exception ex = null;
            try {
                ret = this.drop_partition_common(this.getMS(), db_name, tbl_name, part_vals, deleteData, envContext);
            }
            catch (IOException e) {
                ex = e;
                throw new MetaException(e.getMessage());
            }
            catch (Exception e) {
                ex = e;
                this.rethrowException(e);
            }
            finally {
                this.endFunction("drop_partition", ret, ex, tbl_name);
            }
            return ret;
        }

        @Override
        public Partition get_partition(String db_name, String tbl_name, List<String> part_vals) throws MetaException, NoSuchObjectException {
            this.startPartitionFunction("get_partition", db_name, tbl_name, part_vals);
            Partition ret = null;
            Exception ex = null;
            try {
                this.fireReadTablePreEvent(db_name, tbl_name);
                ret = this.getMS().getPartition(db_name, tbl_name, part_vals);
                this.endFunction("get_partition", ret != null, ex, tbl_name);
            }
            catch (Exception e) {
                try {
                    ex = e;
                    if (e instanceof MetaException) {
                        throw (MetaException)e;
                    }
                    if (e instanceof NoSuchObjectException) {
                        throw (NoSuchObjectException)e;
                    }
                    throw HMSHandler.newMetaException(e);
                }
                catch (Throwable throwable) {
                    this.endFunction("get_partition", ret != null, ex, tbl_name);
                    throw throwable;
                }
            }
            return ret;
        }

        private void fireReadTablePreEvent(String dbName, String tblName) throws MetaException, NoSuchObjectException {
            if (this.preListeners.size() > 0) {
                Table t = this.getMS().getTable(dbName, tblName);
                if (t == null) {
                    throw new NoSuchObjectException(dbName + "." + tblName + " table not found");
                }
                this.firePreEvent(new PreReadTableEvent(t, this));
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Loose catch block
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public Partition get_partition_with_auth(String db_name, String tbl_name, List<String> part_vals, String user_name, List<String> group_names) throws MetaException, NoSuchObjectException, TException {
            this.startPartitionFunction("get_partition_with_auth", db_name, tbl_name, part_vals);
            this.fireReadTablePreEvent(db_name, tbl_name);
            Partition ret = null;
            Exception ex = null;
            try {
                ret = this.getMS().getPartitionWithAuth(db_name, tbl_name, part_vals, user_name, group_names);
                this.endFunction("get_partition_with_auth", ret != null, ex, tbl_name);
                return ret;
            }
            catch (InvalidObjectException e) {
                try {
                    ex = e;
                    throw new NoSuchObjectException(e.getMessage());
                    catch (Exception e2) {
                        ex = e2;
                        this.rethrowException(e2);
                        this.endFunction("get_partition_with_auth", ret != null, ex, tbl_name);
                        return ret;
                    }
                }
                catch (Throwable throwable) {
                    this.endFunction("get_partition_with_auth", ret != null, ex, tbl_name);
                    throw throwable;
                }
            }
        }

        @Override
        public List<Partition> get_partitions(String db_name, String tbl_name, short max_parts) throws NoSuchObjectException, MetaException {
            this.startTableFunction("get_partitions", db_name, tbl_name);
            this.fireReadTablePreEvent(db_name, tbl_name);
            List<Partition> ret = null;
            Exception ex = null;
            try {
                ret = this.getMS().getPartitions(db_name, tbl_name, max_parts);
                this.endFunction("get_partitions", ret != null, ex, tbl_name);
            }
            catch (Exception e) {
                try {
                    ex = e;
                    if (e instanceof MetaException) {
                        throw (MetaException)e;
                    }
                    if (e instanceof NoSuchObjectException) {
                        throw (NoSuchObjectException)e;
                    }
                    throw HMSHandler.newMetaException(e);
                }
                catch (Throwable throwable) {
                    this.endFunction("get_partitions", ret != null, ex, tbl_name);
                    throw throwable;
                }
            }
            return ret;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Loose catch block
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public List<Partition> get_partitions_with_auth(String dbName, String tblName, short maxParts, String userName, List<String> groupNames) throws NoSuchObjectException, MetaException, TException {
            this.startTableFunction("get_partitions_with_auth", dbName, tblName);
            List<Partition> ret = null;
            Exception ex = null;
            try {
                ret = this.getMS().getPartitionsWithAuth(dbName, tblName, maxParts, userName, groupNames);
                this.endFunction("get_partitions_with_auth", ret != null, ex, tblName);
                return ret;
            }
            catch (InvalidObjectException e) {
                try {
                    ex = e;
                    throw new NoSuchObjectException(e.getMessage());
                    catch (Exception e2) {
                        ex = e2;
                        this.rethrowException(e2);
                        this.endFunction("get_partitions_with_auth", ret != null, ex, tblName);
                        return ret;
                    }
                }
                catch (Throwable throwable) {
                    this.endFunction("get_partitions_with_auth", ret != null, ex, tblName);
                    throw throwable;
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public List<PartitionSpec> get_partitions_pspec(String db_name, String tbl_name, int max_parts) throws NoSuchObjectException, MetaException {
            String dbName = db_name.toLowerCase();
            String tableName = tbl_name.toLowerCase();
            this.startTableFunction("get_partitions_pspec", dbName, tableName);
            List<PartitionSpec> partitionSpecs = null;
            try {
                Table table = this.get_table_core(dbName, tableName);
                List<Partition> partitions = this.get_partitions(dbName, tableName, (short)max_parts);
                if (HMSHandler.is_partition_spec_grouping_enabled(table)) {
                    partitionSpecs = this.get_partitionspecs_grouped_by_storage_descriptor(table, partitions);
                } else {
                    PartitionSpec pSpec = new PartitionSpec();
                    pSpec.setPartitionList(new PartitionListComposingSpec(partitions));
                    pSpec.setDbName(dbName);
                    pSpec.setTableName(tableName);
                    pSpec.setRootPath(table.getSd().getLocation());
                    partitionSpecs = Arrays.asList(pSpec);
                }
                List<PartitionSpec> list = partitionSpecs;
                this.endFunction("get_partitions_pspec", partitionSpecs != null && !partitionSpecs.isEmpty(), null, tbl_name);
                return list;
            }
            catch (Throwable throwable) {
                this.endFunction("get_partitions_pspec", partitionSpecs != null && !partitionSpecs.isEmpty(), null, tbl_name);
                throw throwable;
            }
        }

        private List<PartitionSpec> get_partitionspecs_grouped_by_storage_descriptor(Table table, List<Partition> partitions) throws NoSuchObjectException, MetaException {
            ImmutableCollection partitionsOutsideTableDir;
            assert (HMSHandler.is_partition_spec_grouping_enabled(table));
            final String tablePath = table.getSd().getLocation();
            ImmutableListMultimap<Boolean, Partition> partitionsWithinTableDirectory = Multimaps.index(partitions, new com.google.common.base.Function<Partition, Boolean>(){

                @Override
                public Boolean apply(Partition input) {
                    return input.getSd().getLocation().startsWith(tablePath);
                }
            });
            ArrayList<PartitionSpec> partSpecs = new ArrayList<PartitionSpec>();
            HashMap sdToPartList = new HashMap();
            if (partitionsWithinTableDirectory.containsKey(true)) {
                ImmutableCollection partsWithinTableDir = partitionsWithinTableDirectory.get((Object)true);
                for (Partition partition : partsWithinTableDir) {
                    PartitionWithoutSD partitionWithoutSD = new PartitionWithoutSD(partition.getValues(), partition.getCreateTime(), partition.getLastAccessTime(), partition.getSd().getLocation().substring(tablePath.length()), partition.getParameters());
                    StorageDescriptorKey sdKey = new StorageDescriptorKey(partition.getSd());
                    if (!sdToPartList.containsKey(sdKey)) {
                        sdToPartList.put(sdKey, new ArrayList());
                    }
                    ((List)sdToPartList.get(sdKey)).add(partitionWithoutSD);
                }
                for (Map.Entry entry : sdToPartList.entrySet()) {
                    partSpecs.add(this.getSharedSDPartSpec(table, (StorageDescriptorKey)entry.getKey(), (List)entry.getValue()));
                }
            }
            if (partitionsWithinTableDirectory.containsKey(false) && !(partitionsOutsideTableDir = partitionsWithinTableDirectory.get((Object)false)).isEmpty()) {
                PartitionSpec partListSpec = new PartitionSpec();
                partListSpec.setDbName(table.getDbName());
                partListSpec.setTableName(table.getTableName());
                partListSpec.setPartitionList(new PartitionListComposingSpec((List<Partition>)((Object)partitionsOutsideTableDir)));
                partSpecs.add(partListSpec);
            }
            return partSpecs;
        }

        private PartitionSpec getSharedSDPartSpec(Table table, StorageDescriptorKey sdKey, List<PartitionWithoutSD> partitions) {
            StorageDescriptor sd = new StorageDescriptor(sdKey.getSd());
            sd.setLocation(table.getSd().getLocation());
            PartitionSpecWithSharedSD sharedSDPartSpec = new PartitionSpecWithSharedSD(partitions, sd);
            PartitionSpec ret = new PartitionSpec();
            ret.setRootPath(sd.getLocation());
            ret.setSharedSDPartitionSpec(sharedSDPartSpec);
            ret.setDbName(table.getDbName());
            ret.setTableName(table.getTableName());
            return ret;
        }

        private static boolean is_partition_spec_grouping_enabled(Table table) {
            Map<String, String> parameters = table.getParameters();
            return parameters.containsKey("hive.hcatalog.partition.spec.grouping.enabled") && parameters.get("hive.hcatalog.partition.spec.grouping.enabled").equalsIgnoreCase("true");
        }

        @Override
        public List<String> get_partition_names(String db_name, String tbl_name, short max_parts) throws MetaException, NoSuchObjectException {
            this.startTableFunction("get_partition_names", db_name, tbl_name);
            this.fireReadTablePreEvent(db_name, tbl_name);
            List<String> ret = null;
            Exception ex = null;
            try {
                ret = this.getMS().listPartitionNames(db_name, tbl_name, max_parts);
                this.endFunction("get_partition_names", ret != null, ex, tbl_name);
            }
            catch (Exception e) {
                try {
                    ex = e;
                    if (e instanceof MetaException) {
                        throw (MetaException)e;
                    }
                    throw HMSHandler.newMetaException(e);
                }
                catch (Throwable throwable) {
                    this.endFunction("get_partition_names", ret != null, ex, tbl_name);
                    throw throwable;
                }
            }
            return ret;
        }

        @Override
        public void alter_partition(String db_name, String tbl_name, Partition new_part) throws InvalidOperationException, MetaException, TException {
            this.rename_partition(db_name, tbl_name, null, new_part);
        }

        @Override
        public void alter_partition_with_environment_context(String dbName, String tableName, Partition newPartition, EnvironmentContext envContext) throws InvalidOperationException, MetaException, TException {
            this.rename_partition(dbName, tableName, null, newPartition, envContext);
        }

        @Override
        public void rename_partition(String db_name, String tbl_name, List<String> part_vals, Partition new_part) throws InvalidOperationException, MetaException, TException {
            this.rename_partition(db_name, tbl_name, part_vals, new_part, null);
        }

        /*
         * Loose catch block
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private void rename_partition(String db_name, String tbl_name, List<String> part_vals, Partition new_part, EnvironmentContext envContext) throws InvalidOperationException, MetaException, TException {
            this.startTableFunction("alter_partition", db_name, tbl_name);
            if (LOG.isInfoEnabled()) {
                LOG.info("New partition values:" + new_part.getValues());
                if (part_vals != null && part_vals.size() > 0) {
                    LOG.info("Old Partition values:" + part_vals);
                }
            }
            Partition oldPart = null;
            Exception ex = null;
            try {
                this.firePreEvent(new PreAlterPartitionEvent(db_name, tbl_name, part_vals, new_part, this));
                if (part_vals != null && !part_vals.isEmpty()) {
                    MetaStoreUtils.validatePartitionNameCharacters(new_part.getValues(), this.partitionValidationPattern);
                }
                oldPart = this.alterHandler.alterPartition(this.getMS(), this.wh, db_name, tbl_name, part_vals, new_part);
                Table table = null;
                for (MetaStoreEventListener listener : this.listeners) {
                    if (table == null) {
                        table = this.getMS().getTable(db_name, tbl_name);
                    }
                    AlterPartitionEvent alterPartitionEvent = new AlterPartitionEvent(oldPart, new_part, table, true, this);
                    alterPartitionEvent.setEnvironmentContext(envContext);
                    listener.onAlterPartition(alterPartitionEvent);
                }
                this.endFunction("alter_partition", oldPart != null, ex, tbl_name);
                return;
            }
            catch (InvalidObjectException e) {
                try {
                    ex = e;
                    throw new InvalidOperationException(e.getMessage());
                    catch (AlreadyExistsException e2) {
                        ex = e2;
                        throw new InvalidOperationException(e2.getMessage());
                    }
                    catch (Exception e3) {
                        ex = e3;
                        if (e3 instanceof MetaException) {
                            throw (MetaException)e3;
                        }
                        if (e3 instanceof InvalidOperationException) {
                            throw (InvalidOperationException)e3;
                        }
                        if (!(e3 instanceof TException)) throw HMSHandler.newMetaException(e3);
                        throw (TException)e3;
                    }
                }
                catch (Throwable throwable) {
                    this.endFunction("alter_partition", oldPart != null, ex, tbl_name);
                    throw throwable;
                }
            }
        }

        /*
         * Loose catch block
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void alter_partitions(String db_name, String tbl_name, List<Partition> new_parts) throws InvalidOperationException, MetaException, TException {
            this.startTableFunction("alter_partitions", db_name, tbl_name);
            if (LOG.isInfoEnabled()) {
                for (Partition tmpPart : new_parts) {
                    LOG.info("New partition values:" + tmpPart.getValues());
                }
            }
            List<Partition> oldParts = null;
            Exception ex = null;
            try {
                for (Partition tmpPart : new_parts) {
                    this.firePreEvent(new PreAlterPartitionEvent(db_name, tbl_name, null, tmpPart, this));
                }
                oldParts = this.alterHandler.alterPartitions(this.getMS(), this.wh, db_name, tbl_name, new_parts);
                Iterator<Partition> olditr = oldParts.iterator();
                Table table = null;
                for (Partition tmpPart : new_parts) {
                    Partition oldTmpPart = null;
                    if (!olditr.hasNext()) throw new InvalidOperationException("failed to alterpartitions");
                    oldTmpPart = olditr.next();
                    for (MetaStoreEventListener listener : this.listeners) {
                        if (table == null) {
                            table = this.getMS().getTable(db_name, tbl_name);
                        }
                        AlterPartitionEvent alterPartitionEvent = new AlterPartitionEvent(oldTmpPart, tmpPart, table, true, this);
                        listener.onAlterPartition(alterPartitionEvent);
                    }
                }
                this.endFunction("alter_partition", oldParts != null, ex, tbl_name);
                return;
            }
            catch (InvalidObjectException e) {
                try {
                    ex = e;
                    throw new InvalidOperationException(e.getMessage());
                    catch (AlreadyExistsException e2) {
                        ex = e2;
                        throw new InvalidOperationException(e2.getMessage());
                    }
                    catch (Exception e3) {
                        ex = e3;
                        if (e3 instanceof MetaException) {
                            throw (MetaException)e3;
                        }
                        if (e3 instanceof InvalidOperationException) {
                            throw (InvalidOperationException)e3;
                        }
                        if (!(e3 instanceof TException)) throw HMSHandler.newMetaException(e3);
                        throw (TException)e3;
                    }
                }
                catch (Throwable throwable) {
                    this.endFunction("alter_partition", oldParts != null, ex, tbl_name);
                    throw throwable;
                }
            }
        }

        @Override
        public void alter_index(String dbname, String base_table_name, String index_name, Index newIndex) throws InvalidOperationException, MetaException {
            this.startFunction("alter_index", ": db=" + dbname + " base_tbl=" + base_table_name + " idx=" + index_name + " newidx=" + newIndex.getIndexName());
            newIndex.putToParameters("transient_lastDdlTime", Long.toString(System.currentTimeMillis() / 1000L));
            boolean success = false;
            Exception ex = null;
            Index oldIndex = null;
            try {
                oldIndex = this.get_index_by_name(dbname, base_table_name, index_name);
                this.firePreEvent(new PreAlterIndexEvent(oldIndex, newIndex, this));
                this.getMS().alterIndex(dbname, base_table_name, index_name, newIndex);
                success = true;
            }
            catch (InvalidObjectException e) {
                ex = e;
                throw new InvalidOperationException(e.getMessage());
            }
            catch (Exception e) {
                ex = e;
                if (e instanceof MetaException) {
                    throw (MetaException)e;
                }
                if (e instanceof InvalidOperationException) {
                    throw (InvalidOperationException)e;
                }
                throw HMSHandler.newMetaException(e);
            }
            finally {
                this.endFunction("alter_index", success, ex, base_table_name);
                for (MetaStoreEventListener listener : this.listeners) {
                    AlterIndexEvent alterIndexEvent = new AlterIndexEvent(oldIndex, newIndex, success, this);
                    listener.onAlterIndex(alterIndexEvent);
                }
            }
        }

        @Override
        public String getVersion() throws TException {
            this.endFunction(this.startFunction("getVersion"), true, null);
            return "3.0";
        }

        @Override
        public void alter_table(String dbname, String name, Table newTable) throws InvalidOperationException, MetaException {
            this.alter_table_core(dbname, name, newTable, null, false);
        }

        @Override
        public void alter_table_with_cascade(String dbname, String name, Table newTable, boolean cascade) throws InvalidOperationException, MetaException {
            this.alter_table_core(dbname, name, newTable, null, cascade);
        }

        @Override
        public void alter_table_with_environment_context(String dbname, String name, Table newTable, EnvironmentContext envContext) throws InvalidOperationException, MetaException {
            this.alter_table_core(dbname, name, newTable, envContext, false);
        }

        private void alter_table_core(String dbname, String name, Table newTable, EnvironmentContext envContext, boolean cascade) throws InvalidOperationException, MetaException {
            this.startFunction("alter_table", ": db=" + dbname + " tbl=" + name + " newtbl=" + newTable.getTableName());
            if (newTable.getParameters() == null || newTable.getParameters().get("transient_lastDdlTime") == null) {
                newTable.putToParameters("transient_lastDdlTime", Long.toString(System.currentTimeMillis() / 1000L));
            }
            boolean success = false;
            Exception ex = null;
            try {
                Table oldt = this.get_table_core(dbname, name);
                this.firePreEvent(new PreAlterTableEvent(oldt, newTable, this));
                this.alterHandler.alterTable(this.getMS(), this.wh, dbname, name, newTable, cascade);
                success = true;
                for (MetaStoreEventListener listener : this.listeners) {
                    AlterTableEvent alterTableEvent = new AlterTableEvent(oldt, newTable, success, this);
                    alterTableEvent.setEnvironmentContext(envContext);
                    listener.onAlterTable(alterTableEvent);
                }
            }
            catch (NoSuchObjectException e) {
                ex = e;
                throw new InvalidOperationException(e.getMessage());
            }
            catch (Exception e) {
                ex = e;
                if (e instanceof MetaException) {
                    throw (MetaException)e;
                }
                if (e instanceof InvalidOperationException) {
                    throw (InvalidOperationException)e;
                }
                throw HMSHandler.newMetaException(e);
            }
            finally {
                this.endFunction("alter_table", success, ex, name);
            }
        }

        @Override
        public List<String> get_tables(String dbname, String pattern) throws MetaException {
            this.startFunction("get_tables", ": db=" + dbname + " pat=" + pattern);
            List<String> ret = null;
            Exception ex = null;
            try {
                ret = this.getMS().getTables(dbname, pattern);
                this.endFunction("get_tables", ret != null, ex);
            }
            catch (Exception e) {
                try {
                    ex = e;
                    if (e instanceof MetaException) {
                        throw (MetaException)e;
                    }
                    throw HMSHandler.newMetaException(e);
                }
                catch (Throwable throwable) {
                    this.endFunction("get_tables", ret != null, ex);
                    throw throwable;
                }
            }
            return ret;
        }

        @Override
        public List<String> get_all_tables(String dbname) throws MetaException {
            this.startFunction("get_all_tables", ": db=" + dbname);
            List<String> ret = null;
            Exception ex = null;
            try {
                ret = this.getMS().getAllTables(dbname);
                this.endFunction("get_all_tables", ret != null, ex);
            }
            catch (Exception e) {
                try {
                    ex = e;
                    if (e instanceof MetaException) {
                        throw (MetaException)e;
                    }
                    throw HMSHandler.newMetaException(e);
                }
                catch (Throwable throwable) {
                    this.endFunction("get_all_tables", ret != null, ex);
                    throw throwable;
                }
            }
            return ret;
        }

        @Override
        public List<FieldSchema> get_fields(String db, String tableName) throws MetaException, UnknownTableException, UnknownDBException {
            return this.get_fields_with_environment_context(db, tableName, null);
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public List<FieldSchema> get_fields_with_environment_context(String db, String tableName, EnvironmentContext envContext) throws MetaException, UnknownTableException, UnknownDBException {
            Exception ex;
            List<FieldSchema> ret;
            block14: {
                this.startFunction("get_fields_with_environment_context", ": db=" + db + "tbl=" + tableName);
                String[] names = tableName.split("\\.");
                String base_table_name = names[0];
                ret = null;
                ex = null;
                ClassLoader orgHiveLoader = null;
                HiveConf curConf = this.hiveConf;
                try {
                    Table tbl;
                    try {
                        tbl = this.get_table_core(db, base_table_name);
                    }
                    catch (NoSuchObjectException e) {
                        throw new UnknownTableException(e.getMessage());
                    }
                    if (null == tbl.getSd().getSerdeInfo().getSerializationLib() || this.hiveConf.getStringCollection(HiveConf.ConfVars.SERDESUSINGMETASTOREFORSCHEMA.varname).contains(tbl.getSd().getSerdeInfo().getSerializationLib())) {
                        ret = tbl.getSd().getCols();
                    } else {
                        try {
                            String addedJars;
                            if (envContext != null && StringUtils.isNotBlank(addedJars = envContext.getProperties().get("hive.added.jars.path"))) {
                                curConf = this.getConf();
                                orgHiveLoader = curConf.getClassLoader();
                                ClassLoader loader = MetaStoreUtils.addToClassPath(orgHiveLoader, StringUtils.split(addedJars, ","));
                                curConf.setClassLoader(loader);
                            }
                            Deserializer s = MetaStoreUtils.getDeserializer((Configuration)curConf, tbl, false);
                            ret = MetaStoreUtils.getFieldsFromDeserializer(tableName, s);
                        }
                        catch (SerDeException e) {
                            org.apache.hadoop.util.StringUtils.stringifyException((Throwable)e);
                            throw new MetaException(e.getMessage());
                        }
                    }
                    if (orgHiveLoader == null) break block14;
                }
                catch (Exception e) {
                    try {
                        ex = e;
                        if (e instanceof UnknownDBException) {
                            throw (UnknownDBException)e;
                        }
                        if (e instanceof UnknownTableException) {
                            throw (UnknownTableException)e;
                        }
                        if (!(e instanceof MetaException)) throw HMSHandler.newMetaException(e);
                        throw (MetaException)e;
                    }
                    catch (Throwable throwable) {
                        if (orgHiveLoader != null) {
                            curConf.setClassLoader(orgHiveLoader);
                        }
                        this.endFunction("get_fields_with_environment_context", ret != null, ex, tableName);
                        throw throwable;
                    }
                }
                curConf.setClassLoader(orgHiveLoader);
            }
            this.endFunction("get_fields_with_environment_context", ret != null, ex, tableName);
            return ret;
        }

        @Override
        public List<FieldSchema> get_schema(String db, String tableName) throws MetaException, UnknownTableException, UnknownDBException {
            return this.get_schema_with_environment_context(db, tableName, null);
        }

        @Override
        public List<FieldSchema> get_schema_with_environment_context(String db, String tableName, EnvironmentContext envContext) throws MetaException, UnknownTableException, UnknownDBException {
            this.startFunction("get_schema_with_environment_context", ": db=" + db + "tbl=" + tableName);
            boolean success = false;
            Exception ex = null;
            try {
                Table tbl;
                String[] names = tableName.split("\\.");
                String base_table_name = names[0];
                try {
                    tbl = this.get_table_core(db, base_table_name);
                }
                catch (NoSuchObjectException e) {
                    throw new UnknownTableException(e.getMessage());
                }
                List<FieldSchema> fieldSchemas = this.get_fields_with_environment_context(db, base_table_name, envContext);
                if (tbl == null || fieldSchemas == null) {
                    throw new UnknownTableException(tableName + " doesn't exist");
                }
                if (tbl.getPartitionKeys() != null) {
                    fieldSchemas.addAll(tbl.getPartitionKeys());
                }
                success = true;
                List<FieldSchema> list = fieldSchemas;
                return list;
            }
            catch (Exception e) {
                ex = e;
                if (e instanceof UnknownDBException) {
                    throw (UnknownDBException)e;
                }
                if (e instanceof UnknownTableException) {
                    throw (UnknownTableException)e;
                }
                if (e instanceof MetaException) {
                    throw (MetaException)e;
                }
                MetaException me = new MetaException(e.toString());
                me.initCause(e);
                throw me;
            }
            finally {
                this.endFunction("get_schema_with_environment_context", success, ex, tableName);
            }
        }

        @Override
        public String getCpuProfile(int profileDurationInSec) throws TException {
            return "";
        }

        @Override
        public String get_config_value(String name, String defaultValue) throws TException, ConfigValSecurityException {
            this.startFunction("get_config_value", ": name=" + name + " defaultValue=" + defaultValue);
            boolean success = false;
            Exception ex = null;
            try {
                if (name == null) {
                    success = true;
                    String string = defaultValue;
                    return string;
                }
                if (!Pattern.matches("(hive|hdfs|mapred|maprfs|s3|s3n|mapreduce).*", name)) {
                    throw new ConfigValSecurityException("For security reasons, the config key " + name + " cannot be accessed");
                }
                String toReturn = defaultValue;
                try {
                    toReturn = this.hiveConf.get(name, defaultValue);
                }
                catch (RuntimeException e) {
                    LOG.error(threadLocalId.get().toString() + ": " + "RuntimeException thrown in get_config_value - msg: " + e.getMessage() + " cause: " + e.getCause());
                }
                success = true;
                String e = toReturn;
                return e;
            }
            catch (Exception e) {
                ex = e;
                if (e instanceof ConfigValSecurityException) {
                    throw (ConfigValSecurityException)e;
                }
                if (e instanceof TException) {
                    throw (TException)e;
                }
                TException te = new TException(e.toString());
                te.initCause(e);
                throw te;
            }
            finally {
                this.endFunction("get_config_value", success, ex);
            }
        }

        private List<String> getPartValsFromName(RawStore ms, String dbName, String tblName, String partName) throws MetaException, InvalidObjectException {
            LinkedHashMap<String, String> hm = Warehouse.makeSpecFromName(partName);
            Table t = ms.getTable(dbName, tblName);
            if (t == null) {
                throw new InvalidObjectException(dbName + "." + tblName + " table not found");
            }
            ArrayList<String> partVals = new ArrayList<String>();
            for (FieldSchema field : t.getPartitionKeys()) {
                String key = field.getName();
                String val = hm.get(key);
                if (val == null) {
                    throw new InvalidObjectException("incomplete partition name - missing " + key);
                }
                partVals.add(val);
            }
            return partVals;
        }

        private Partition get_partition_by_name_core(RawStore ms, String db_name, String tbl_name, String part_name) throws MetaException, NoSuchObjectException, TException {
            this.fireReadTablePreEvent(db_name, tbl_name);
            List<String> partVals = null;
            try {
                partVals = this.getPartValsFromName(ms, db_name, tbl_name, part_name);
            }
            catch (InvalidObjectException e) {
                throw new NoSuchObjectException(e.getMessage());
            }
            Partition p = ms.getPartition(db_name, tbl_name, partVals);
            if (p == null) {
                throw new NoSuchObjectException(db_name + "." + tbl_name + " partition (" + part_name + ") not found");
            }
            return p;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Partition get_partition_by_name(String db_name, String tbl_name, String part_name) throws MetaException, NoSuchObjectException, TException {
            this.startFunction("get_partition_by_name", ": db=" + db_name + " tbl=" + tbl_name + " part=" + part_name);
            Partition ret = null;
            Exception ex = null;
            try {
                ret = this.get_partition_by_name_core(this.getMS(), db_name, tbl_name, part_name);
                this.endFunction("get_partition_by_name", ret != null, ex, tbl_name);
            }
            catch (Exception e) {
                try {
                    ex = e;
                    this.rethrowException(e);
                    this.endFunction("get_partition_by_name", ret != null, ex, tbl_name);
                }
                catch (Throwable throwable) {
                    this.endFunction("get_partition_by_name", ret != null, ex, tbl_name);
                    throw throwable;
                }
            }
            return ret;
        }

        @Override
        public Partition append_partition_by_name(String db_name, String tbl_name, String part_name) throws InvalidObjectException, AlreadyExistsException, MetaException, TException {
            return this.append_partition_by_name_with_environment_context(db_name, tbl_name, part_name, null);
        }

        @Override
        public Partition append_partition_by_name_with_environment_context(String db_name, String tbl_name, String part_name, EnvironmentContext env_context) throws InvalidObjectException, AlreadyExistsException, MetaException, TException {
            this.startFunction("append_partition_by_name", ": db=" + db_name + " tbl=" + tbl_name + " part=" + part_name);
            Partition ret = null;
            Exception ex = null;
            try {
                RawStore ms = this.getMS();
                List<String> partVals = this.getPartValsFromName(ms, db_name, tbl_name, part_name);
                ret = this.append_partition_common(ms, db_name, tbl_name, partVals, env_context);
                this.endFunction("append_partition_by_name", ret != null, ex, tbl_name);
            }
            catch (Exception e) {
                try {
                    ex = e;
                    if (e instanceof InvalidObjectException) {
                        throw (InvalidObjectException)e;
                    }
                    if (e instanceof AlreadyExistsException) {
                        throw (AlreadyExistsException)e;
                    }
                    if (e instanceof MetaException) {
                        throw (MetaException)e;
                    }
                    if (e instanceof TException) {
                        throw (TException)e;
                    }
                    throw HMSHandler.newMetaException(e);
                }
                catch (Throwable throwable) {
                    this.endFunction("append_partition_by_name", ret != null, ex, tbl_name);
                    throw throwable;
                }
            }
            return ret;
        }

        private boolean drop_partition_by_name_core(RawStore ms, String db_name, String tbl_name, String part_name, boolean deleteData, EnvironmentContext envContext) throws NoSuchObjectException, MetaException, TException, IOException, InvalidObjectException, InvalidInputException {
            List<String> partVals = null;
            try {
                partVals = this.getPartValsFromName(ms, db_name, tbl_name, part_name);
            }
            catch (InvalidObjectException e) {
                throw new NoSuchObjectException(e.getMessage());
            }
            return this.drop_partition_common(ms, db_name, tbl_name, partVals, deleteData, envContext);
        }

        @Override
        public boolean drop_partition_by_name(String db_name, String tbl_name, String part_name, boolean deleteData) throws NoSuchObjectException, MetaException, TException {
            return this.drop_partition_by_name_with_environment_context(db_name, tbl_name, part_name, deleteData, null);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean drop_partition_by_name_with_environment_context(String db_name, String tbl_name, String part_name, boolean deleteData, EnvironmentContext envContext) throws NoSuchObjectException, MetaException, TException {
            this.startFunction("drop_partition_by_name", ": db=" + db_name + " tbl=" + tbl_name + " part=" + part_name);
            boolean ret = false;
            Exception ex = null;
            try {
                ret = this.drop_partition_by_name_core(this.getMS(), db_name, tbl_name, part_name, deleteData, envContext);
            }
            catch (IOException e) {
                ex = e;
                throw new MetaException(e.getMessage());
            }
            catch (Exception e) {
                ex = e;
                this.rethrowException(e);
            }
            finally {
                this.endFunction("drop_partition_by_name", ret, ex, tbl_name);
            }
            return ret;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public List<Partition> get_partitions_ps(String db_name, String tbl_name, List<String> part_vals, short max_parts) throws MetaException, TException, NoSuchObjectException {
            this.startPartitionFunction("get_partitions_ps", db_name, tbl_name, part_vals);
            List<Partition> ret = null;
            Exception ex = null;
            try {
                ret = this.get_partitions_ps_with_auth(db_name, tbl_name, part_vals, max_parts, null, null);
                this.endFunction("get_partitions_ps", ret != null, ex, tbl_name);
            }
            catch (Exception e) {
                try {
                    ex = e;
                    this.rethrowException(e);
                    this.endFunction("get_partitions_ps", ret != null, ex, tbl_name);
                }
                catch (Throwable throwable) {
                    this.endFunction("get_partitions_ps", ret != null, ex, tbl_name);
                    throw throwable;
                }
            }
            return ret;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Loose catch block
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public List<Partition> get_partitions_ps_with_auth(String db_name, String tbl_name, List<String> part_vals, short max_parts, String userName, List<String> groupNames) throws MetaException, TException, NoSuchObjectException {
            this.startPartitionFunction("get_partitions_ps_with_auth", db_name, tbl_name, part_vals);
            this.fireReadTablePreEvent(db_name, tbl_name);
            List<Partition> ret = null;
            Exception ex = null;
            try {
                ret = this.getMS().listPartitionsPsWithAuth(db_name, tbl_name, part_vals, max_parts, userName, groupNames);
                this.endFunction("get_partitions_ps_with_auth", ret != null, ex, tbl_name);
                return ret;
            }
            catch (InvalidObjectException e) {
                try {
                    ex = e;
                    throw new MetaException(e.getMessage());
                    catch (Exception e2) {
                        ex = e2;
                        this.rethrowException(e2);
                        this.endFunction("get_partitions_ps_with_auth", ret != null, ex, tbl_name);
                        return ret;
                    }
                }
                catch (Throwable throwable) {
                    this.endFunction("get_partitions_ps_with_auth", ret != null, ex, tbl_name);
                    throw throwable;
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public List<String> get_partition_names_ps(String db_name, String tbl_name, List<String> part_vals, short max_parts) throws MetaException, TException, NoSuchObjectException {
            this.startPartitionFunction("get_partitions_names_ps", db_name, tbl_name, part_vals);
            this.fireReadTablePreEvent(db_name, tbl_name);
            List<String> ret = null;
            Exception ex = null;
            try {
                ret = this.getMS().listPartitionNamesPs(db_name, tbl_name, part_vals, max_parts);
                this.endFunction("get_partitions_names_ps", ret != null, ex, tbl_name);
            }
            catch (Exception e) {
                try {
                    ex = e;
                    this.rethrowException(e);
                    this.endFunction("get_partitions_names_ps", ret != null, ex, tbl_name);
                }
                catch (Throwable throwable) {
                    this.endFunction("get_partitions_names_ps", ret != null, ex, tbl_name);
                    throw throwable;
                }
            }
            return ret;
        }

        @Override
        public List<String> partition_name_to_vals(String part_name) throws MetaException, TException {
            if (part_name.length() == 0) {
                return new ArrayList<String>();
            }
            LinkedHashMap<String, String> map = Warehouse.makeSpecFromName(part_name);
            ArrayList<String> part_vals = new ArrayList<String>();
            part_vals.addAll(map.values());
            return part_vals;
        }

        @Override
        public Map<String, String> partition_name_to_spec(String part_name) throws MetaException, TException {
            if (part_name.length() == 0) {
                return new HashMap<String, String>();
            }
            return Warehouse.makeSpecFromName(part_name);
        }

        @Override
        public Index add_index(Index newIndex, Table indexTable) throws InvalidObjectException, AlreadyExistsException, MetaException, TException {
            String tableName;
            this.startFunction("add_index", ": " + newIndex.toString() + " " + indexTable.toString());
            Index ret = null;
            Exception ex = null;
            try {
                ret = this.add_index_core(this.getMS(), newIndex, indexTable);
                tableName = indexTable != null ? indexTable.getTableName() : null;
            }
            catch (Exception e) {
                try {
                    ex = e;
                    if (e instanceof InvalidObjectException) {
                        throw (InvalidObjectException)e;
                    }
                    if (e instanceof AlreadyExistsException) {
                        throw (AlreadyExistsException)e;
                    }
                    if (e instanceof MetaException) {
                        throw (MetaException)e;
                    }
                    if (e instanceof TException) {
                        throw (TException)e;
                    }
                    throw HMSHandler.newMetaException(e);
                }
                catch (Throwable throwable) {
                    String tableName2 = indexTable != null ? indexTable.getTableName() : null;
                    this.endFunction("add_index", ret != null, ex, tableName2);
                    throw throwable;
                }
            }
            this.endFunction("add_index", ret != null, ex, tableName);
            return ret;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Index add_index_core(RawStore ms, Index index, Table indexTable) throws InvalidObjectException, AlreadyExistsException, MetaException {
            boolean success = false;
            boolean indexTableCreated = false;
            String[] qualified = MetaStoreUtils.getQualifiedName(index.getDbName(), index.getIndexTableName());
            try {
                ms.openTransaction();
                this.firePreEvent(new PreAddIndexEvent(index, this));
                Index old_index = null;
                try {
                    old_index = this.get_index_by_name(index.getDbName(), index.getOrigTableName(), index.getIndexName());
                }
                catch (Exception e) {
                    // empty catch block
                }
                if (old_index != null) {
                    throw new AlreadyExistsException("Index already exists:" + index);
                }
                Table origTbl = ms.getTable(index.getDbName(), index.getOrigTableName());
                if (origTbl == null) {
                    throw new InvalidObjectException("Unable to add index because database or the orginal table do not exist");
                }
                long time = System.currentTimeMillis() / 1000L;
                Table indexTbl = indexTable;
                if (indexTbl != null) {
                    try {
                        indexTbl = ms.getTable(qualified[0], qualified[1]);
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                    if (indexTbl != null) {
                        throw new InvalidObjectException("Unable to add index because index table already exists");
                    }
                    this.create_table(indexTable);
                    indexTableCreated = true;
                }
                index.setCreateTime((int)time);
                index.putToParameters("transient_lastDdlTime", Long.toString(time));
                ms.addIndex(index);
                success = ms.commitTransaction();
                Index index2 = index;
                return index2;
            }
            finally {
                if (!success) {
                    if (indexTableCreated) {
                        try {
                            this.drop_table(qualified[0], qualified[1], false);
                        }
                        catch (Exception e) {}
                    }
                    ms.rollbackTransaction();
                }
                for (MetaStoreEventListener listener : this.listeners) {
                    AddIndexEvent addIndexEvent = new AddIndexEvent(index, success, this);
                    listener.onAddIndex(addIndexEvent);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean drop_index_by_name(String dbName, String tblName, String indexName, boolean deleteData) throws NoSuchObjectException, MetaException, TException {
            this.startFunction("drop_index_by_name", ": db=" + dbName + " tbl=" + tblName + " index=" + indexName);
            boolean ret = false;
            Exception ex = null;
            try {
                ret = this.drop_index_by_name_core(this.getMS(), dbName, tblName, indexName, deleteData);
            }
            catch (IOException e) {
                ex = e;
                throw new MetaException(e.getMessage());
            }
            catch (Exception e) {
                ex = e;
                this.rethrowException(e);
            }
            finally {
                this.endFunction("drop_index_by_name", ret, ex, tblName);
            }
            return ret;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean drop_index_by_name_core(RawStore ms, String dbName, String tblName, String indexName, boolean deleteData) throws NoSuchObjectException, MetaException, TException, IOException, InvalidObjectException, InvalidInputException {
            boolean success = false;
            Index index = null;
            Path tblPath = null;
            List<Path> partPaths = null;
            try {
                ms.openTransaction();
                index = this.get_index_by_name(dbName, tblName, indexName);
                this.firePreEvent(new PreDropIndexEvent(index, this));
                ms.dropIndex(dbName, tblName, indexName);
                String idxTblName = index.getIndexTableName();
                if (idxTblName != null) {
                    String[] qualified = MetaStoreUtils.getQualifiedName(index.getDbName(), idxTblName);
                    Table tbl = this.get_table_core(qualified[0], qualified[1]);
                    if (tbl.getSd() == null) {
                        throw new MetaException("Table metadata is corrupted");
                    }
                    if (tbl.getSd().getLocation() != null && !this.wh.isWritable((tblPath = new Path(tbl.getSd().getLocation())).getParent())) {
                        throw new MetaException("Index table metadata not deleted since " + tblPath.getParent() + " is not writable by " + this.hiveConf.getUser());
                    }
                    partPaths = this.dropPartitionsAndGetLocations(ms, qualified[0], qualified[1], tblPath, tbl.getPartitionKeys(), deleteData);
                    if (!ms.dropTable(qualified[0], qualified[1])) {
                        throw new MetaException("Unable to drop underlying data table " + qualified[0] + "." + qualified[1] + " for index " + indexName);
                    }
                }
                success = ms.commitTransaction();
            }
            finally {
                if (!success) {
                    ms.rollbackTransaction();
                } else if (deleteData && tblPath != null) {
                    this.deletePartitionData(partPaths);
                    this.deleteTableData(tblPath);
                }
                for (MetaStoreEventListener listener : this.listeners) {
                    DropIndexEvent dropIndexEvent = new DropIndexEvent(index, success, this);
                    listener.onDropIndex(dropIndexEvent);
                }
            }
            return success;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Index get_index_by_name(String dbName, String tblName, String indexName) throws MetaException, NoSuchObjectException, TException {
            this.startFunction("get_index_by_name", ": db=" + dbName + " tbl=" + tblName + " index=" + indexName);
            Index ret = null;
            Exception ex = null;
            try {
                ret = this.get_index_by_name_core(this.getMS(), dbName, tblName, indexName);
                this.endFunction("get_index_by_name", ret != null, ex, tblName);
            }
            catch (Exception e) {
                try {
                    ex = e;
                    this.rethrowException(e);
                    this.endFunction("get_index_by_name", ret != null, ex, tblName);
                }
                catch (Throwable throwable) {
                    this.endFunction("get_index_by_name", ret != null, ex, tblName);
                    throw throwable;
                }
            }
            return ret;
        }

        private Index get_index_by_name_core(RawStore ms, String db_name, String tbl_name, String index_name) throws MetaException, NoSuchObjectException, TException {
            Index index = ms.getIndex(db_name, tbl_name, index_name);
            if (index == null) {
                throw new NoSuchObjectException(db_name + "." + tbl_name + " index=" + index_name + " not found");
            }
            return index;
        }

        @Override
        public List<String> get_index_names(String dbName, String tblName, short maxIndexes) throws MetaException, TException {
            this.startTableFunction("get_index_names", dbName, tblName);
            List<String> ret = null;
            Exception ex = null;
            try {
                ret = this.getMS().listIndexNames(dbName, tblName, maxIndexes);
                this.endFunction("get_index_names", ret != null, ex, tblName);
            }
            catch (Exception e) {
                try {
                    ex = e;
                    if (e instanceof MetaException) {
                        throw (MetaException)e;
                    }
                    if (e instanceof TException) {
                        throw (TException)e;
                    }
                    throw HMSHandler.newMetaException(e);
                }
                catch (Throwable throwable) {
                    this.endFunction("get_index_names", ret != null, ex, tblName);
                    throw throwable;
                }
            }
            return ret;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public List<Index> get_indexes(String dbName, String tblName, short maxIndexes) throws NoSuchObjectException, MetaException, TException {
            this.startTableFunction("get_indexes", dbName, tblName);
            List<Index> ret = null;
            Exception ex = null;
            try {
                ret = this.getMS().getIndexes(dbName, tblName, maxIndexes);
                this.endFunction("get_indexes", ret != null, ex, tblName);
            }
            catch (Exception e) {
                try {
                    ex = e;
                    this.rethrowException(e);
                    this.endFunction("get_indexes", ret != null, ex, tblName);
                }
                catch (Throwable throwable) {
                    this.endFunction("get_indexes", ret != null, ex, tblName);
                    throw throwable;
                }
            }
            return ret;
        }

        private String lowerCaseConvertPartName(String partName) throws MetaException {
            boolean isFirst = true;
            Map<String, String> partSpec = Warehouse.makeEscSpecFromName(partName);
            String convertedPartName = new String();
            for (Map.Entry<String, String> entry : partSpec.entrySet()) {
                String partColName = entry.getKey();
                String partColVal = entry.getValue();
                if (!isFirst) {
                    convertedPartName = convertedPartName + "/";
                } else {
                    isFirst = false;
                }
                convertedPartName = convertedPartName + partColName.toLowerCase() + "=" + partColVal;
            }
            return convertedPartName;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public ColumnStatistics get_table_column_statistics(String dbName, String tableName, String colName) throws NoSuchObjectException, MetaException, TException, InvalidInputException, InvalidObjectException {
            dbName = dbName.toLowerCase();
            tableName = tableName.toLowerCase();
            colName = colName.toLowerCase();
            this.startFunction("get_column_statistics_by_table: db=" + dbName + " table=" + tableName + " column=" + colName);
            ColumnStatistics statsObj = null;
            try {
                statsObj = this.getMS().getTableColumnStatistics(dbName, tableName, Lists.newArrayList(colName));
                assert (statsObj.getStatsObjSize() <= 1);
                ColumnStatistics columnStatistics = statsObj;
                this.endFunction("get_column_statistics_by_table: ", statsObj != null, null, tableName);
                return columnStatistics;
            }
            catch (Throwable throwable) {
                this.endFunction("get_column_statistics_by_table: ", statsObj != null, null, tableName);
                throw throwable;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public TableStatsResult get_table_statistics_req(TableStatsRequest request) throws MetaException, NoSuchObjectException, TException {
            String dbName = request.getDbName().toLowerCase();
            String tblName = request.getTblName().toLowerCase();
            this.startFunction("get_table_statistics_req: db=" + dbName + " table=" + tblName);
            TableStatsResult result = null;
            ArrayList<String> lowerCaseColNames = new ArrayList<String>(request.getColNames().size());
            for (String colName : request.getColNames()) {
                lowerCaseColNames.add(colName.toLowerCase());
            }
            try {
                ColumnStatistics cs = this.getMS().getTableColumnStatistics(dbName, tblName, lowerCaseColNames);
                result = new TableStatsResult(cs == null || cs.getStatsObj() == null ? Lists.newArrayList() : cs.getStatsObj());
                this.endFunction("get_table_statistics_req: ", result == null, null, tblName);
            }
            catch (Throwable throwable) {
                this.endFunction("get_table_statistics_req: ", result == null, null, tblName);
                throw throwable;
            }
            return result;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public ColumnStatistics get_partition_column_statistics(String dbName, String tableName, String partName, String colName) throws NoSuchObjectException, MetaException, InvalidInputException, TException, InvalidObjectException {
            List<ColumnStatistics> list;
            ColumnStatistics statsObj;
            block4: {
                dbName = dbName.toLowerCase();
                tableName = tableName.toLowerCase();
                colName = colName.toLowerCase();
                String convertedPartName = this.lowerCaseConvertPartName(partName);
                this.startFunction("get_column_statistics_by_partition: db=" + dbName + " table=" + tableName + " partition=" + convertedPartName + " column=" + colName);
                statsObj = null;
                try {
                    list = this.getMS().getPartitionColumnStatistics(dbName, tableName, Lists.newArrayList(convertedPartName), Lists.newArrayList(colName));
                    if (!list.isEmpty()) break block4;
                    ColumnStatistics columnStatistics = null;
                    this.endFunction("get_column_statistics_by_partition: ", statsObj != null, null, tableName);
                    return columnStatistics;
                }
                catch (Throwable throwable) {
                    this.endFunction("get_column_statistics_by_partition: ", statsObj != null, null, tableName);
                    throw throwable;
                }
            }
            if (list.size() != 1) {
                throw new MetaException(list.size() + " statistics for single column and partition");
            }
            statsObj = list.get(0);
            this.endFunction("get_column_statistics_by_partition: ", statsObj != null, null, tableName);
            return statsObj;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public PartitionsStatsResult get_partitions_statistics_req(PartitionsStatsRequest request) throws MetaException, NoSuchObjectException, TException {
            String dbName = request.getDbName().toLowerCase();
            String tblName = request.getTblName().toLowerCase();
            this.startFunction("get_partitions_statistics_req: db=" + dbName + " table=" + tblName);
            PartitionsStatsResult result = null;
            ArrayList<String> lowerCaseColNames = new ArrayList<String>(request.getColNames().size());
            for (String colName : request.getColNames()) {
                lowerCaseColNames.add(colName.toLowerCase());
            }
            ArrayList<String> lowerCasePartNames = new ArrayList<String>(request.getPartNames().size());
            for (String partName : request.getPartNames()) {
                lowerCasePartNames.add(this.lowerCaseConvertPartName(partName));
            }
            try {
                List<ColumnStatistics> stats = this.getMS().getPartitionColumnStatistics(dbName, tblName, lowerCasePartNames, lowerCaseColNames);
                HashMap<String, List<ColumnStatisticsObj>> map = new HashMap<String, List<ColumnStatisticsObj>>();
                for (ColumnStatistics stat : stats) {
                    map.put(stat.getStatsDesc().getPartName(), stat.getStatsObj());
                }
                result = new PartitionsStatsResult(map);
                this.endFunction("get_partitions_statistics_req: ", result == null, null, tblName);
            }
            catch (Throwable throwable) {
                this.endFunction("get_partitions_statistics_req: ", result == null, null, tblName);
                throw throwable;
            }
            return result;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean update_table_column_statistics(ColumnStatistics colStats) throws NoSuchObjectException, InvalidObjectException, MetaException, TException, InvalidInputException {
            String dbName = null;
            String tableName = null;
            String colName = null;
            ColumnStatisticsDesc statsDesc = colStats.getStatsDesc();
            dbName = statsDesc.getDbName().toLowerCase();
            tableName = statsDesc.getTableName().toLowerCase();
            statsDesc.setDbName(dbName);
            statsDesc.setTableName(tableName);
            long time = System.currentTimeMillis() / 1000L;
            statsDesc.setLastAnalyzed(time);
            List<ColumnStatisticsObj> statsObjs = colStats.getStatsObj();
            for (ColumnStatisticsObj statsObj : statsObjs) {
                colName = statsObj.getColName().toLowerCase();
                statsObj.setColName(colName);
                this.startFunction("write_column_statistics:  db=" + dbName + " table=" + tableName + " column=" + colName);
            }
            colStats.setStatsDesc(statsDesc);
            colStats.setStatsObj(statsObjs);
            boolean ret = false;
            try {
                boolean bl = ret = this.getMS().updateTableColumnStatistics(colStats);
                this.endFunction("write_column_statistics: ", ret, null, tableName);
                return bl;
            }
            catch (Throwable throwable) {
                this.endFunction("write_column_statistics: ", ret, null, tableName);
                throw throwable;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean update_partition_column_statistics(ColumnStatistics colStats) throws NoSuchObjectException, InvalidObjectException, MetaException, TException, InvalidInputException {
            String dbName = null;
            String tableName = null;
            String partName = null;
            String colName = null;
            ColumnStatisticsDesc statsDesc = colStats.getStatsDesc();
            dbName = statsDesc.getDbName().toLowerCase();
            tableName = statsDesc.getTableName().toLowerCase();
            partName = this.lowerCaseConvertPartName(statsDesc.getPartName());
            statsDesc.setDbName(dbName);
            statsDesc.setTableName(tableName);
            statsDesc.setPartName(partName);
            long time = System.currentTimeMillis() / 1000L;
            statsDesc.setLastAnalyzed(time);
            List<ColumnStatisticsObj> statsObjs = colStats.getStatsObj();
            for (ColumnStatisticsObj statsObj : statsObjs) {
                colName = statsObj.getColName().toLowerCase();
                statsObj.setColName(colName);
                this.startFunction("write_partition_column_statistics:  db=" + dbName + " table=" + tableName + " part=" + partName + "column=" + colName);
            }
            colStats.setStatsDesc(statsDesc);
            colStats.setStatsObj(statsObjs);
            boolean ret = false;
            try {
                List<String> partVals = this.getPartValsFromName(this.getMS(), dbName, tableName, partName);
                boolean bl = ret = this.getMS().updatePartitionColumnStatistics(colStats, partVals);
                this.endFunction("write_partition_column_statistics: ", ret, null, tableName);
                return bl;
            }
            catch (Throwable throwable) {
                this.endFunction("write_partition_column_statistics: ", ret, null, tableName);
                throw throwable;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean delete_partition_column_statistics(String dbName, String tableName, String partName, String colName) throws NoSuchObjectException, MetaException, InvalidObjectException, TException, InvalidInputException {
            dbName = dbName.toLowerCase();
            tableName = tableName.toLowerCase();
            if (colName != null) {
                colName = colName.toLowerCase();
            }
            String convertedPartName = this.lowerCaseConvertPartName(partName);
            this.startFunction("delete_column_statistics_by_partition: db=" + dbName + " table=" + tableName + " partition=" + convertedPartName + " column=" + colName);
            boolean ret = false;
            try {
                List<String> partVals = this.getPartValsFromName(this.getMS(), dbName, tableName, convertedPartName);
                ret = this.getMS().deletePartitionColumnStatistics(dbName, tableName, convertedPartName, partVals, colName);
                this.endFunction("delete_column_statistics_by_partition: ", ret, null, tableName);
            }
            catch (Throwable throwable) {
                this.endFunction("delete_column_statistics_by_partition: ", ret, null, tableName);
                throw throwable;
            }
            return ret;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean delete_table_column_statistics(String dbName, String tableName, String colName) throws NoSuchObjectException, MetaException, InvalidObjectException, TException, InvalidInputException {
            dbName = dbName.toLowerCase();
            tableName = tableName.toLowerCase();
            if (colName != null) {
                colName = colName.toLowerCase();
            }
            this.startFunction("delete_column_statistics_by_table: db=" + dbName + " table=" + tableName + " column=" + colName);
            boolean ret = false;
            try {
                ret = this.getMS().deleteTableColumnStatistics(dbName, tableName, colName);
                this.endFunction("delete_column_statistics_by_table: ", ret, null, tableName);
            }
            catch (Throwable throwable) {
                this.endFunction("delete_column_statistics_by_table: ", ret, null, tableName);
                throw throwable;
            }
            return ret;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public List<Partition> get_partitions_by_filter(String dbName, String tblName, String filter, short maxParts) throws MetaException, NoSuchObjectException, TException {
            this.startTableFunction("get_partitions_by_filter", dbName, tblName);
            this.fireReadTablePreEvent(dbName, tblName);
            List<Partition> ret = null;
            Exception ex = null;
            try {
                ret = this.getMS().getPartitionsByFilter(dbName, tblName, filter, maxParts);
                this.endFunction("get_partitions_by_filter", ret != null, ex, tblName);
            }
            catch (Exception e) {
                try {
                    ex = e;
                    this.rethrowException(e);
                    this.endFunction("get_partitions_by_filter", ret != null, ex, tblName);
                }
                catch (Throwable throwable) {
                    this.endFunction("get_partitions_by_filter", ret != null, ex, tblName);
                    throw throwable;
                }
            }
            return ret;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public List<PartitionSpec> get_part_specs_by_filter(String dbName, String tblName, String filter, int maxParts) throws MetaException, NoSuchObjectException, TException {
            this.startTableFunction("get_partitions_by_filter_pspec", dbName, tblName);
            List<PartitionSpec> partitionSpecs = null;
            try {
                Table table = this.get_table_core(dbName, tblName);
                List<Partition> partitions = this.get_partitions_by_filter(dbName, tblName, filter, (short)maxParts);
                if (HMSHandler.is_partition_spec_grouping_enabled(table)) {
                    partitionSpecs = this.get_partitionspecs_grouped_by_storage_descriptor(table, partitions);
                } else {
                    PartitionSpec pSpec = new PartitionSpec();
                    pSpec.setPartitionList(new PartitionListComposingSpec(partitions));
                    pSpec.setRootPath(table.getSd().getLocation());
                    pSpec.setDbName(dbName);
                    pSpec.setTableName(tblName);
                    partitionSpecs = Arrays.asList(pSpec);
                }
                List<PartitionSpec> list = partitionSpecs;
                this.endFunction("get_partitions_by_filter_pspec", partitionSpecs != null && !partitionSpecs.isEmpty(), null, tblName);
                return list;
            }
            catch (Throwable throwable) {
                this.endFunction("get_partitions_by_filter_pspec", partitionSpecs != null && !partitionSpecs.isEmpty(), null, tblName);
                throw throwable;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public PartitionsByExprResult get_partitions_by_expr(PartitionsByExprRequest req) throws TException {
            String dbName = req.getDbName();
            String tblName = req.getTblName();
            this.startTableFunction("get_partitions_by_expr", dbName, tblName);
            this.fireReadTablePreEvent(dbName, tblName);
            PartitionsByExprResult ret = null;
            Exception ex = null;
            try {
                LinkedList<Partition> partitions = new LinkedList<Partition>();
                boolean hasUnknownPartitions = this.getMS().getPartitionsByExpr(dbName, tblName, req.getExpr(), req.getDefaultPartitionName(), req.getMaxParts(), partitions);
                ret = new PartitionsByExprResult(partitions, hasUnknownPartitions);
                this.endFunction("get_partitions_by_expr", ret != null, ex, tblName);
            }
            catch (Exception e) {
                try {
                    ex = e;
                    this.rethrowException(e);
                    this.endFunction("get_partitions_by_expr", ret != null, ex, tblName);
                }
                catch (Throwable throwable) {
                    this.endFunction("get_partitions_by_expr", ret != null, ex, tblName);
                    throw throwable;
                }
            }
            return ret;
        }

        private void rethrowException(Exception e) throws MetaException, NoSuchObjectException, TException {
            if (e instanceof MetaException) {
                throw (MetaException)e;
            }
            if (e instanceof NoSuchObjectException) {
                throw (NoSuchObjectException)e;
            }
            if (e instanceof TException) {
                throw (TException)e;
            }
            throw HMSHandler.newMetaException(e);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public List<Partition> get_partitions_by_names(String dbName, String tblName, List<String> partNames) throws MetaException, NoSuchObjectException, TException {
            this.startTableFunction("get_partitions_by_names", dbName, tblName);
            this.fireReadTablePreEvent(dbName, tblName);
            List<Partition> ret = null;
            Exception ex = null;
            try {
                ret = this.getMS().getPartitionsByNames(dbName, tblName, partNames);
                this.endFunction("get_partitions_by_names", ret != null, ex, tblName);
            }
            catch (Exception e) {
                try {
                    ex = e;
                    this.rethrowException(e);
                    this.endFunction("get_partitions_by_names", ret != null, ex, tblName);
                }
                catch (Throwable throwable) {
                    this.endFunction("get_partitions_by_names", ret != null, ex, tblName);
                    throw throwable;
                }
            }
            return ret;
        }

        @Override
        public PrincipalPrivilegeSet get_privilege_set(HiveObjectRef hiveObject, String userName, List<String> groupNames) throws MetaException, TException {
            this.firePreEvent(new PreAuthorizationCallEvent(this));
            if (hiveObject.getObjectType() == HiveObjectType.COLUMN) {
                String partName = this.getPartName(hiveObject);
                return this.get_column_privilege_set(hiveObject.getDbName(), hiveObject.getObjectName(), partName, hiveObject.getColumnName(), userName, groupNames);
            }
            if (hiveObject.getObjectType() == HiveObjectType.PARTITION) {
                String partName = this.getPartName(hiveObject);
                return this.get_partition_privilege_set(hiveObject.getDbName(), hiveObject.getObjectName(), partName, userName, groupNames);
            }
            if (hiveObject.getObjectType() == HiveObjectType.DATABASE) {
                return this.get_db_privilege_set(hiveObject.getDbName(), userName, groupNames);
            }
            if (hiveObject.getObjectType() == HiveObjectType.TABLE) {
                return this.get_table_privilege_set(hiveObject.getDbName(), hiveObject.getObjectName(), userName, groupNames);
            }
            if (hiveObject.getObjectType() == HiveObjectType.GLOBAL) {
                return this.get_user_privilege_set(userName, groupNames);
            }
            return null;
        }

        private String getPartName(HiveObjectRef hiveObject) throws MetaException {
            String partName = null;
            List<String> partValue = hiveObject.getPartValues();
            if (partValue != null && partValue.size() > 0) {
                try {
                    Table table = this.get_table_core(hiveObject.getDbName(), hiveObject.getObjectName());
                    partName = Warehouse.makePartName(table.getPartitionKeys(), partValue);
                }
                catch (NoSuchObjectException e) {
                    throw new MetaException(e.getMessage());
                }
            }
            return partName;
        }

        private PrincipalPrivilegeSet get_column_privilege_set(String dbName, String tableName, String partName, String columnName, String userName, List<String> groupNames) throws MetaException, TException {
            this.incrementCounter("get_column_privilege_set");
            PrincipalPrivilegeSet ret = null;
            try {
                ret = this.getMS().getColumnPrivilegeSet(dbName, tableName, partName, columnName, userName, groupNames);
            }
            catch (MetaException e) {
                throw e;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            return ret;
        }

        private PrincipalPrivilegeSet get_db_privilege_set(String dbName, String userName, List<String> groupNames) throws MetaException, TException {
            this.incrementCounter("get_db_privilege_set");
            PrincipalPrivilegeSet ret = null;
            try {
                ret = this.getMS().getDBPrivilegeSet(dbName, userName, groupNames);
            }
            catch (MetaException e) {
                throw e;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            return ret;
        }

        private PrincipalPrivilegeSet get_partition_privilege_set(String dbName, String tableName, String partName, String userName, List<String> groupNames) throws MetaException, TException {
            this.incrementCounter("get_partition_privilege_set");
            PrincipalPrivilegeSet ret = null;
            try {
                ret = this.getMS().getPartitionPrivilegeSet(dbName, tableName, partName, userName, groupNames);
            }
            catch (MetaException e) {
                throw e;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            return ret;
        }

        private PrincipalPrivilegeSet get_table_privilege_set(String dbName, String tableName, String userName, List<String> groupNames) throws MetaException, TException {
            this.incrementCounter("get_table_privilege_set");
            PrincipalPrivilegeSet ret = null;
            try {
                ret = this.getMS().getTablePrivilegeSet(dbName, tableName, userName, groupNames);
            }
            catch (MetaException e) {
                throw e;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            return ret;
        }

        @Override
        public boolean grant_role(String roleName, String principalName, PrincipalType principalType, String grantor, PrincipalType grantorType, boolean grantOption) throws MetaException, TException {
            this.incrementCounter("add_role_member");
            this.firePreEvent(new PreAuthorizationCallEvent(this));
            if (HiveMetaStore.PUBLIC.equals(roleName)) {
                throw new MetaException("No user can be added to public. Since all users implictly belong to public role.");
            }
            Boolean ret = null;
            try {
                RawStore ms = this.getMS();
                Role role = ms.getRole(roleName);
                if (principalType == PrincipalType.ROLE && this.isNewRoleAParent(principalName, roleName)) {
                    throw new MetaException("Cannot grant role " + principalName + " to " + roleName + " as " + roleName + " already belongs to the role " + principalName + ". (no cycles allowed)");
                }
                ret = ms.grantRole(role, principalName, principalType, grantor, grantorType, grantOption);
            }
            catch (MetaException e) {
                throw e;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            return ret;
        }

        private boolean isNewRoleAParent(String newRole, String curRole) throws MetaException {
            if (newRole.equals(curRole)) {
                return true;
            }
            List<Role> parentRoleMaps = this.getMS().listRoles(curRole, PrincipalType.ROLE);
            for (Role parentRole : parentRoleMaps) {
                if (!this.isNewRoleAParent(newRole, parentRole.getRoleName())) continue;
                return true;
            }
            return false;
        }

        @Override
        public List<Role> list_roles(String principalName, PrincipalType principalType) throws MetaException, TException {
            this.incrementCounter("list_roles");
            this.firePreEvent(new PreAuthorizationCallEvent(this));
            return this.getMS().listRoles(principalName, principalType);
        }

        @Override
        public boolean create_role(Role role) throws MetaException, TException {
            this.incrementCounter("create_role");
            this.firePreEvent(new PreAuthorizationCallEvent(this));
            if (HiveMetaStore.PUBLIC.equals(role.getRoleName())) {
                throw new MetaException("public role implictly exists. It can't be created.");
            }
            Boolean ret = null;
            try {
                ret = this.getMS().addRole(role.getRoleName(), role.getOwnerName());
            }
            catch (MetaException e) {
                throw e;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            return ret;
        }

        @Override
        public boolean drop_role(String roleName) throws MetaException, TException {
            this.incrementCounter("drop_role");
            this.firePreEvent(new PreAuthorizationCallEvent(this));
            if (HiveMetaStore.ADMIN.equals(roleName) || HiveMetaStore.PUBLIC.equals(roleName)) {
                throw new MetaException("public,admin roles can't be dropped.");
            }
            Boolean ret = null;
            try {
                ret = this.getMS().removeRole(roleName);
            }
            catch (MetaException e) {
                throw e;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            return ret;
        }

        @Override
        public List<String> get_role_names() throws MetaException, TException {
            this.incrementCounter("get_role_names");
            this.firePreEvent(new PreAuthorizationCallEvent(this));
            List<String> ret = null;
            try {
                ret = this.getMS().listRoleNames();
                return ret;
            }
            catch (MetaException e) {
                throw e;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }

        @Override
        public boolean grant_privileges(PrivilegeBag privileges) throws MetaException, TException {
            this.incrementCounter("grant_privileges");
            this.firePreEvent(new PreAuthorizationCallEvent(this));
            Boolean ret = null;
            try {
                ret = this.getMS().grantPrivileges(privileges);
            }
            catch (MetaException e) {
                throw e;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            return ret;
        }

        @Override
        public boolean revoke_role(String roleName, String userName, PrincipalType principalType) throws MetaException, TException {
            return this.revoke_role(roleName, userName, principalType, false);
        }

        private boolean revoke_role(String roleName, String userName, PrincipalType principalType, boolean grantOption) throws MetaException, TException {
            this.incrementCounter("remove_role_member");
            this.firePreEvent(new PreAuthorizationCallEvent(this));
            if (HiveMetaStore.PUBLIC.equals(roleName)) {
                throw new MetaException("public role can't be revoked.");
            }
            Boolean ret = null;
            try {
                RawStore ms = this.getMS();
                Role mRole = ms.getRole(roleName);
                ret = ms.revokeRole(mRole, userName, principalType, grantOption);
            }
            catch (MetaException e) {
                throw e;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            return ret;
        }

        @Override
        public GrantRevokeRoleResponse grant_revoke_role(GrantRevokeRoleRequest request) throws MetaException, TException {
            GrantRevokeRoleResponse response = new GrantRevokeRoleResponse();
            boolean grantOption = false;
            if (request.isSetGrantOption()) {
                grantOption = request.isGrantOption();
            }
            switch (request.getRequestType()) {
                case GRANT: {
                    boolean result = this.grant_role(request.getRoleName(), request.getPrincipalName(), request.getPrincipalType(), request.getGrantor(), request.getGrantorType(), grantOption);
                    response.setSuccess(result);
                    break;
                }
                case REVOKE: {
                    boolean result = this.revoke_role(request.getRoleName(), request.getPrincipalName(), request.getPrincipalType(), grantOption);
                    response.setSuccess(result);
                    break;
                }
                default: {
                    throw new MetaException("Unknown request type " + request.getRequestType());
                }
            }
            return response;
        }

        @Override
        public GrantRevokePrivilegeResponse grant_revoke_privileges(GrantRevokePrivilegeRequest request) throws MetaException, TException {
            GrantRevokePrivilegeResponse response = new GrantRevokePrivilegeResponse();
            switch (request.getRequestType()) {
                case GRANT: {
                    boolean result = this.grant_privileges(request.getPrivileges());
                    response.setSuccess(result);
                    break;
                }
                case REVOKE: {
                    boolean revokeGrantOption = false;
                    if (request.isSetRevokeGrantOption()) {
                        revokeGrantOption = request.isRevokeGrantOption();
                    }
                    boolean result = this.revoke_privileges(request.getPrivileges(), revokeGrantOption);
                    response.setSuccess(result);
                    break;
                }
                default: {
                    throw new MetaException("Unknown request type " + request.getRequestType());
                }
            }
            return response;
        }

        @Override
        public boolean revoke_privileges(PrivilegeBag privileges) throws MetaException, TException {
            return this.revoke_privileges(privileges, false);
        }

        public boolean revoke_privileges(PrivilegeBag privileges, boolean grantOption) throws MetaException, TException {
            this.incrementCounter("revoke_privileges");
            this.firePreEvent(new PreAuthorizationCallEvent(this));
            Boolean ret = null;
            try {
                ret = this.getMS().revokePrivileges(privileges, grantOption);
            }
            catch (MetaException e) {
                throw e;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            return ret;
        }

        private PrincipalPrivilegeSet get_user_privilege_set(String userName, List<String> groupNames) throws MetaException, TException {
            this.incrementCounter("get_user_privilege_set");
            PrincipalPrivilegeSet ret = null;
            try {
                ret = this.getMS().getUserPrivilegeSet(userName, groupNames);
            }
            catch (MetaException e) {
                throw e;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            return ret;
        }

        @Override
        public List<HiveObjectPrivilege> list_privileges(String principalName, PrincipalType principalType, HiveObjectRef hiveObject) throws MetaException, TException {
            this.firePreEvent(new PreAuthorizationCallEvent(this));
            if (hiveObject.getObjectType() == null) {
                return this.getAllPrivileges(principalName, principalType);
            }
            if (hiveObject.getObjectType() == HiveObjectType.GLOBAL) {
                return this.list_global_privileges(principalName, principalType);
            }
            if (hiveObject.getObjectType() == HiveObjectType.DATABASE) {
                return this.list_db_privileges(principalName, principalType, hiveObject.getDbName());
            }
            if (hiveObject.getObjectType() == HiveObjectType.TABLE) {
                return this.list_table_privileges(principalName, principalType, hiveObject.getDbName(), hiveObject.getObjectName());
            }
            if (hiveObject.getObjectType() == HiveObjectType.PARTITION) {
                return this.list_partition_privileges(principalName, principalType, hiveObject.getDbName(), hiveObject.getObjectName(), hiveObject.getPartValues());
            }
            if (hiveObject.getObjectType() == HiveObjectType.COLUMN) {
                if (hiveObject.getPartValues() == null || hiveObject.getPartValues().isEmpty()) {
                    return this.list_table_column_privileges(principalName, principalType, hiveObject.getDbName(), hiveObject.getObjectName(), hiveObject.getColumnName());
                }
                return this.list_partition_column_privileges(principalName, principalType, hiveObject.getDbName(), hiveObject.getObjectName(), hiveObject.getPartValues(), hiveObject.getColumnName());
            }
            return null;
        }

        private List<HiveObjectPrivilege> getAllPrivileges(String principalName, PrincipalType principalType) throws TException {
            ArrayList<HiveObjectPrivilege> privs = new ArrayList<HiveObjectPrivilege>();
            privs.addAll(this.list_global_privileges(principalName, principalType));
            privs.addAll(this.list_db_privileges(principalName, principalType, null));
            privs.addAll(this.list_table_privileges(principalName, principalType, null, null));
            privs.addAll(this.list_partition_privileges(principalName, principalType, null, null, null));
            privs.addAll(this.list_table_column_privileges(principalName, principalType, null, null, null));
            privs.addAll(this.list_partition_column_privileges(principalName, principalType, null, null, null, null));
            return privs;
        }

        private List<HiveObjectPrivilege> list_table_column_privileges(String principalName, PrincipalType principalType, String dbName, String tableName, String columnName) throws MetaException, TException {
            this.incrementCounter("list_table_column_privileges");
            try {
                if (dbName == null) {
                    return this.getMS().listPrincipalTableColumnGrantsAll(principalName, principalType);
                }
                if (principalName == null) {
                    return this.getMS().listTableColumnGrantsAll(dbName, tableName, columnName);
                }
                List<HiveObjectPrivilege> result = this.getMS().listPrincipalTableColumnGrants(principalName, principalType, dbName, tableName, columnName);
                return result;
            }
            catch (MetaException e) {
                throw e;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }

        private List<HiveObjectPrivilege> list_partition_column_privileges(String principalName, PrincipalType principalType, String dbName, String tableName, List<String> partValues, String columnName) throws MetaException, TException {
            this.incrementCounter("list_partition_column_privileges");
            try {
                if (dbName == null) {
                    return this.getMS().listPrincipalPartitionColumnGrantsAll(principalName, principalType);
                }
                Table tbl = this.get_table_core(dbName, tableName);
                String partName = Warehouse.makePartName(tbl.getPartitionKeys(), partValues);
                if (principalName == null) {
                    return this.getMS().listPartitionColumnGrantsAll(dbName, tableName, partName, columnName);
                }
                List<HiveObjectPrivilege> result = this.getMS().listPrincipalPartitionColumnGrants(principalName, principalType, dbName, tableName, partValues, partName, columnName);
                return result;
            }
            catch (MetaException e) {
                throw e;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }

        private List<HiveObjectPrivilege> list_db_privileges(String principalName, PrincipalType principalType, String dbName) throws MetaException, TException {
            this.incrementCounter("list_security_db_grant");
            try {
                if (dbName == null) {
                    return this.getMS().listPrincipalDBGrantsAll(principalName, principalType);
                }
                if (principalName == null) {
                    return this.getMS().listDBGrantsAll(dbName);
                }
                return this.getMS().listPrincipalDBGrants(principalName, principalType, dbName);
            }
            catch (MetaException e) {
                throw e;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }

        private List<HiveObjectPrivilege> list_partition_privileges(String principalName, PrincipalType principalType, String dbName, String tableName, List<String> partValues) throws MetaException, TException {
            this.incrementCounter("list_security_partition_grant");
            try {
                if (dbName == null) {
                    return this.getMS().listPrincipalPartitionGrantsAll(principalName, principalType);
                }
                Table tbl = this.get_table_core(dbName, tableName);
                String partName = Warehouse.makePartName(tbl.getPartitionKeys(), partValues);
                if (principalName == null) {
                    return this.getMS().listPartitionGrantsAll(dbName, tableName, partName);
                }
                List<HiveObjectPrivilege> result = this.getMS().listPrincipalPartitionGrants(principalName, principalType, dbName, tableName, partValues, partName);
                return result;
            }
            catch (MetaException e) {
                throw e;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }

        private List<HiveObjectPrivilege> list_table_privileges(String principalName, PrincipalType principalType, String dbName, String tableName) throws MetaException, TException {
            this.incrementCounter("list_security_table_grant");
            try {
                if (dbName == null) {
                    return this.getMS().listPrincipalTableGrantsAll(principalName, principalType);
                }
                if (principalName == null) {
                    return this.getMS().listTableGrantsAll(dbName, tableName);
                }
                List<HiveObjectPrivilege> result = this.getMS().listAllTableGrants(principalName, principalType, dbName, tableName);
                return result;
            }
            catch (MetaException e) {
                throw e;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }

        private List<HiveObjectPrivilege> list_global_privileges(String principalName, PrincipalType principalType) throws MetaException, TException {
            this.incrementCounter("list_security_user_grant");
            try {
                if (principalName == null) {
                    return this.getMS().listGlobalGrantsAll();
                }
                List<HiveObjectPrivilege> result = this.getMS().listPrincipalGlobalGrants(principalName, principalType);
                return result;
            }
            catch (MetaException e) {
                throw e;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }

        @Override
        public void cancel_delegation_token(String token_str_form) throws MetaException, TException {
            this.startFunction("cancel_delegation_token");
            boolean success = false;
            Exception ex = null;
            try {
                HiveMetaStore.cancelDelegationToken(token_str_form);
                success = true;
            }
            catch (IOException e) {
                ex = e;
                throw new MetaException(e.getMessage());
            }
            catch (Exception e) {
                ex = e;
                if (e instanceof MetaException) {
                    throw (MetaException)e;
                }
                if (e instanceof TException) {
                    throw (TException)e;
                }
                throw HMSHandler.newMetaException(e);
            }
            finally {
                this.endFunction("cancel_delegation_token", success, ex);
            }
        }

        /*
         * Loose catch block
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public long renew_delegation_token(String token_str_form) throws MetaException, TException {
            this.startFunction("renew_delegation_token");
            Long ret = null;
            Exception ex = null;
            try {
                ret = HiveMetaStore.renewDelegationToken(token_str_form);
                this.endFunction("renew_delegation_token", ret != null, ex);
                return ret;
            }
            catch (IOException e) {
                try {
                    ex = e;
                    throw new MetaException(e.getMessage());
                    catch (Exception e2) {
                        ex = e2;
                        if (e2 instanceof MetaException) {
                            throw (MetaException)e2;
                        }
                        if (!(e2 instanceof TException)) throw HMSHandler.newMetaException(e2);
                        throw (TException)e2;
                    }
                }
                catch (Throwable throwable) {
                    this.endFunction("renew_delegation_token", ret != null, ex);
                    throw throwable;
                }
            }
        }

        /*
         * Loose catch block
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public String get_delegation_token(String token_owner, String renewer_kerberos_principal_name) throws MetaException, TException {
            this.startFunction("get_delegation_token");
            String ret = null;
            Exception ex = null;
            try {
                ret = HiveMetaStore.getDelegationToken(token_owner, renewer_kerberos_principal_name);
                this.endFunction("get_delegation_token", ret != null, ex);
                return ret;
            }
            catch (IOException e) {
                try {
                    ex = e;
                    throw new MetaException(e.getMessage());
                    catch (InterruptedException e2) {
                        ex = e2;
                        throw new MetaException(e2.getMessage());
                    }
                    catch (Exception e3) {
                        ex = e3;
                        if (e3 instanceof MetaException) {
                            throw (MetaException)e3;
                        }
                        if (!(e3 instanceof TException)) throw HMSHandler.newMetaException(e3);
                        throw (TException)e3;
                    }
                }
                catch (Throwable throwable) {
                    this.endFunction("get_delegation_token", ret != null, ex);
                    throw throwable;
                }
            }
        }

        @Override
        public void markPartitionForEvent(String db_name, String tbl_name, Map<String, String> partName, PartitionEventType evtType) throws MetaException, TException, NoSuchObjectException, UnknownDBException, UnknownTableException, InvalidPartitionException, UnknownPartitionException {
            Table tbl = null;
            Exception ex = null;
            try {
                this.startPartitionFunction("markPartitionForEvent", db_name, tbl_name, partName);
                this.firePreEvent(new PreLoadPartitionDoneEvent(db_name, tbl_name, partName, this));
                tbl = this.getMS().markPartitionForEvent(db_name, tbl_name, partName, evtType);
                if (null == tbl) {
                    throw new UnknownTableException("Table: " + tbl_name + " not found.");
                }
                for (MetaStoreEventListener listener : this.listeners) {
                    listener.onLoadPartitionDone(new LoadPartitionDoneEvent(true, tbl, partName, this));
                }
                this.endFunction("markPartitionForEvent", tbl != null, ex, tbl_name);
            }
            catch (Exception original) {
                try {
                    ex = original;
                    LOG.error("Exception caught in mark partition event ", (Throwable)original);
                    if (original instanceof NoSuchObjectException) {
                        throw (NoSuchObjectException)original;
                    }
                    if (original instanceof UnknownTableException) {
                        throw (UnknownTableException)original;
                    }
                    if (original instanceof UnknownDBException) {
                        throw (UnknownDBException)original;
                    }
                    if (original instanceof UnknownPartitionException) {
                        throw (UnknownPartitionException)original;
                    }
                    if (original instanceof InvalidPartitionException) {
                        throw (InvalidPartitionException)original;
                    }
                    if (original instanceof MetaException) {
                        throw (MetaException)original;
                    }
                    throw HMSHandler.newMetaException(original);
                }
                catch (Throwable throwable) {
                    this.endFunction("markPartitionForEvent", tbl != null, ex, tbl_name);
                    throw throwable;
                }
            }
        }

        @Override
        public boolean isPartitionMarkedForEvent(String db_name, String tbl_name, Map<String, String> partName, PartitionEventType evtType) throws MetaException, NoSuchObjectException, UnknownDBException, UnknownTableException, TException, UnknownPartitionException, InvalidPartitionException {
            this.startPartitionFunction("isPartitionMarkedForEvent", db_name, tbl_name, partName);
            Boolean ret = null;
            Exception ex = null;
            try {
                ret = this.getMS().isPartitionMarkedForEvent(db_name, tbl_name, partName, evtType);
                this.endFunction("isPartitionMarkedForEvent", ret != null, ex, tbl_name);
            }
            catch (Exception original) {
                try {
                    LOG.error("Exception caught for isPartitionMarkedForEvent ", (Throwable)original);
                    ex = original;
                    if (original instanceof NoSuchObjectException) {
                        throw (NoSuchObjectException)original;
                    }
                    if (original instanceof UnknownTableException) {
                        throw (UnknownTableException)original;
                    }
                    if (original instanceof UnknownDBException) {
                        throw (UnknownDBException)original;
                    }
                    if (original instanceof UnknownPartitionException) {
                        throw (UnknownPartitionException)original;
                    }
                    if (original instanceof InvalidPartitionException) {
                        throw (InvalidPartitionException)original;
                    }
                    if (original instanceof MetaException) {
                        throw (MetaException)original;
                    }
                    throw HMSHandler.newMetaException(original);
                }
                catch (Throwable throwable) {
                    this.endFunction("isPartitionMarkedForEvent", ret != null, ex, tbl_name);
                    throw throwable;
                }
            }
            return ret;
        }

        @Override
        public List<String> set_ugi(String username, List<String> groupNames) throws MetaException, TException {
            Collections.addAll(groupNames, username);
            return groupNames;
        }

        @Override
        public boolean partition_name_has_valid_characters(List<String> part_vals, boolean throw_exception) throws TException, MetaException {
            this.startFunction("partition_name_has_valid_characters");
            boolean ret = false;
            Exception ex = null;
            try {
                if (throw_exception) {
                    MetaStoreUtils.validatePartitionNameCharacters(part_vals, this.partitionValidationPattern);
                    ret = true;
                } else {
                    ret = MetaStoreUtils.partitionNameHasValidCharacters(part_vals, this.partitionValidationPattern);
                }
            }
            catch (Exception e) {
                if (e instanceof MetaException) {
                    throw (MetaException)e;
                }
                ex = e;
                throw HMSHandler.newMetaException(e);
            }
            this.endFunction("partition_name_has_valid_characters", true, null);
            return ret;
        }

        private static MetaException newMetaException(Exception e) {
            if (e instanceof MetaException) {
                return (MetaException)e;
            }
            MetaException me = new MetaException(e.toString());
            me.initCause(e);
            return me;
        }

        private void validateFunctionInfo(Function func) throws InvalidObjectException, MetaException {
            if (!MetaStoreUtils.validateName(func.getFunctionName(), null)) {
                throw new InvalidObjectException(func.getFunctionName() + " is not a valid object name");
            }
            String className = func.getClassName();
            if (className == null) {
                throw new InvalidObjectException("Function class name cannot be null");
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void create_function(Function func) throws AlreadyExistsException, InvalidObjectException, MetaException, NoSuchObjectException, TException {
            this.validateFunctionInfo(func);
            boolean success = false;
            RawStore ms = this.getMS();
            try {
                ms.openTransaction();
                Database db = ms.getDatabase(func.getDbName());
                if (db == null) {
                    throw new NoSuchObjectException("The database " + func.getDbName() + " does not exist");
                }
                Function existingFunc = ms.getFunction(func.getDbName(), func.getFunctionName());
                if (existingFunc != null) {
                    throw new AlreadyExistsException("Function " + func.getFunctionName() + " already exists");
                }
                long time = System.currentTimeMillis() / 1000L;
                func.setCreateTime((int)time);
                ms.createFunction(func);
                success = ms.commitTransaction();
            }
            finally {
                if (!success) {
                    ms.rollbackTransaction();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void drop_function(String dbName, String funcName) throws NoSuchObjectException, MetaException, InvalidObjectException, InvalidInputException {
            boolean success = false;
            Function func = null;
            RawStore ms = this.getMS();
            try {
                ms.openTransaction();
                func = ms.getFunction(dbName, funcName);
                if (func == null) {
                    throw new NoSuchObjectException("Function " + funcName + " does not exist");
                }
                ms.dropFunction(dbName, funcName);
                success = ms.commitTransaction();
            }
            finally {
                if (!success) {
                    ms.rollbackTransaction();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void alter_function(String dbName, String funcName, Function newFunc) throws InvalidOperationException, MetaException, TException {
            this.validateFunctionInfo(newFunc);
            boolean success = false;
            RawStore ms = this.getMS();
            try {
                ms.openTransaction();
                ms.alterFunction(dbName, funcName, newFunc);
                success = ms.commitTransaction();
            }
            finally {
                if (!success) {
                    ms.rollbackTransaction();
                }
            }
        }

        @Override
        public List<String> get_functions(String dbName, String pattern) throws MetaException {
            this.startFunction("get_functions", ": db=" + dbName + " pat=" + pattern);
            RawStore ms = this.getMS();
            Exception ex = null;
            List<String> funcNames = null;
            try {
                funcNames = ms.getFunctions(dbName, pattern);
                this.endFunction("get_functions", funcNames != null, ex);
            }
            catch (Exception e) {
                try {
                    ex = e;
                    throw HMSHandler.newMetaException(e);
                }
                catch (Throwable throwable) {
                    this.endFunction("get_functions", funcNames != null, ex);
                    throw throwable;
                }
            }
            return funcNames;
        }

        @Override
        public GetAllFunctionsResponse get_all_functions() throws MetaException {
            GetAllFunctionsResponse response = new GetAllFunctionsResponse();
            this.startFunction("get_all_functions");
            RawStore ms = this.getMS();
            List<Function> allFunctions = null;
            Exception ex = null;
            try {
                allFunctions = ms.getAllFunctions();
                this.endFunction("get_all_functions", allFunctions != null, ex);
            }
            catch (Exception e) {
                try {
                    ex = e;
                    throw HMSHandler.newMetaException(e);
                }
                catch (Throwable throwable) {
                    this.endFunction("get_all_functions", allFunctions != null, ex);
                    throw throwable;
                }
            }
            response.setFunctions(allFunctions);
            return response;
        }

        @Override
        public Function get_function(String dbName, String funcName) throws MetaException, NoSuchObjectException, TException {
            this.startFunction("get_function", ": " + dbName + "." + funcName);
            RawStore ms = this.getMS();
            Function func = null;
            Exception ex = null;
            try {
                func = ms.getFunction(dbName, funcName);
                if (func == null) {
                    throw new NoSuchObjectException("Function " + dbName + "." + funcName + " does not exist");
                }
                this.endFunction("get_function", func != null, ex);
            }
            catch (Exception e) {
                try {
                    ex = e;
                    throw HMSHandler.newMetaException(e);
                }
                catch (Throwable throwable) {
                    this.endFunction("get_function", func != null, ex);
                    throw throwable;
                }
            }
            return func;
        }

        @Override
        public GetOpenTxnsResponse get_open_txns() throws TException {
            return this.getTxnHandler().getOpenTxns();
        }

        @Override
        public GetOpenTxnsInfoResponse get_open_txns_info() throws TException {
            return this.getTxnHandler().getOpenTxnsInfo();
        }

        @Override
        public OpenTxnsResponse open_txns(OpenTxnRequest rqst) throws TException {
            return this.getTxnHandler().openTxns(rqst);
        }

        @Override
        public void abort_txn(AbortTxnRequest rqst) throws NoSuchTxnException, TException {
            this.getTxnHandler().abortTxn(rqst);
        }

        @Override
        public void commit_txn(CommitTxnRequest rqst) throws NoSuchTxnException, TxnAbortedException, TException {
            this.getTxnHandler().commitTxn(rqst);
        }

        @Override
        public LockResponse lock(LockRequest rqst) throws NoSuchTxnException, TxnAbortedException, TException {
            return this.getTxnHandler().lock(rqst);
        }

        @Override
        public LockResponse check_lock(CheckLockRequest rqst) throws NoSuchTxnException, TxnAbortedException, NoSuchLockException, TException {
            return this.getTxnHandler().checkLock(rqst);
        }

        @Override
        public void unlock(UnlockRequest rqst) throws NoSuchLockException, TxnOpenException, TException {
            this.getTxnHandler().unlock(rqst);
        }

        @Override
        public ShowLocksResponse show_locks(ShowLocksRequest rqst) throws TException {
            return this.getTxnHandler().showLocks(rqst);
        }

        @Override
        public void heartbeat(HeartbeatRequest ids) throws NoSuchLockException, NoSuchTxnException, TxnAbortedException, TException {
            this.getTxnHandler().heartbeat(ids);
        }

        @Override
        public HeartbeatTxnRangeResponse heartbeat_txn_range(HeartbeatTxnRangeRequest rqst) throws TException {
            return this.getTxnHandler().heartbeatTxnRange(rqst);
        }

        @Override
        public void compact(CompactionRequest rqst) throws TException {
            this.getTxnHandler().compact(rqst);
        }

        @Override
        public ShowCompactResponse show_compact(ShowCompactRequest rqst) throws TException {
            return this.getTxnHandler().showCompact(rqst);
        }

        @Override
        public void flushCache() throws TException {
            this.getMS().flushCache();
        }

        @Override
        public void add_dynamic_partitions(AddDynamicPartitions rqst) throws NoSuchTxnException, TxnAbortedException, TException {
            this.getTxnHandler().addDynamicPartitions(rqst);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Loose catch block
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public GetPrincipalsInRoleResponse get_principals_in_role(GetPrincipalsInRoleRequest request) throws MetaException, TException {
            this.incrementCounter("get_principals_in_role");
            this.firePreEvent(new PreAuthorizationCallEvent(this));
            Exception ex = null;
            GetPrincipalsInRoleResponse response = null;
            try {
                response = new GetPrincipalsInRoleResponse(this.getMS().listRoleMembers(request.getRoleName()));
                this.endFunction("get_principals_in_role", ex == null, ex);
                return response;
            }
            catch (MetaException e) {
                try {
                    throw e;
                    catch (Exception e2) {
                        ex = e2;
                        this.rethrowException(e2);
                        this.endFunction("get_principals_in_role", ex == null, ex);
                        return response;
                    }
                }
                catch (Throwable throwable) {
                    this.endFunction("get_principals_in_role", ex == null, ex);
                    throw throwable;
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Loose catch block
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public GetRoleGrantsForPrincipalResponse get_role_grants_for_principal(GetRoleGrantsForPrincipalRequest request) throws MetaException, TException {
            this.incrementCounter("get_role_grants_for_principal");
            this.firePreEvent(new PreAuthorizationCallEvent(this));
            Exception ex = null;
            List<RolePrincipalGrant> roleMaps = null;
            try {
                roleMaps = this.getMS().listRolesWithGrants(request.getPrincipal_name(), request.getPrincipal_type());
                this.endFunction("get_role_grants_for_principal", ex == null, ex);
                return new GetRoleGrantsForPrincipalResponse(roleMaps);
            }
            catch (MetaException e) {
                try {
                    throw e;
                    catch (Exception e2) {
                        ex = e2;
                        this.rethrowException(e2);
                        this.endFunction("get_role_grants_for_principal", ex == null, ex);
                        return new GetRoleGrantsForPrincipalResponse(roleMaps);
                    }
                }
                catch (Throwable throwable) {
                    this.endFunction("get_role_grants_for_principal", ex == null, ex);
                    throw throwable;
                }
            }
        }

        private List<RolePrincipalGrant> getRolePrincipalGrants(List<Role> roles) throws MetaException {
            ArrayList<RolePrincipalGrant> rolePrinGrantList = new ArrayList<RolePrincipalGrant>();
            if (roles != null) {
                for (Role role : roles) {
                    rolePrinGrantList.addAll(this.getMS().listRoleMembers(role.getRoleName()));
                }
            }
            return rolePrinGrantList;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public AggrStats get_aggr_stats_for(PartitionsStatsRequest request) throws NoSuchObjectException, MetaException, TException {
            String dbName = request.getDbName().toLowerCase();
            String tblName = request.getTblName().toLowerCase();
            this.startFunction("get_aggr_stats_for: db=" + request.getDbName() + " table=" + request.getTblName());
            ArrayList<String> lowerCaseColNames = new ArrayList<String>(request.getColNames().size());
            for (String colName : request.getColNames()) {
                lowerCaseColNames.add(colName.toLowerCase());
            }
            ArrayList<String> lowerCasePartNames = new ArrayList<String>(request.getPartNames().size());
            for (String partName : request.getPartNames()) {
                lowerCasePartNames.add(this.lowerCaseConvertPartName(partName));
            }
            AggrStats aggrStats = null;
            try {
                AggrStats aggrStats2 = aggrStats = new AggrStats(this.getMS().get_aggr_stats_for(dbName, tblName, lowerCasePartNames, lowerCaseColNames));
                this.endFunction("get_partitions_statistics_req: ", aggrStats == null, null, request.getTblName());
                return aggrStats2;
            }
            catch (Throwable throwable) {
                this.endFunction("get_partitions_statistics_req: ", aggrStats == null, null, request.getTblName());
                throw throwable;
            }
        }

        @Override
        public boolean set_aggr_stats_for(SetPartitionsStatsRequest request) throws NoSuchObjectException, InvalidObjectException, MetaException, InvalidInputException, TException {
            boolean ret = true;
            for (ColumnStatistics colStats : request.getColStats()) {
                ret = ret && this.update_partition_column_statistics(colStats);
            }
            return ret;
        }

        @Override
        public NotificationEventResponse get_next_notification(NotificationEventRequest rqst) throws TException {
            RawStore ms = this.getMS();
            return ms.getNextNotification(rqst);
        }

        @Override
        public CurrentNotificationEventId get_current_notificationEventId() throws TException {
            RawStore ms = this.getMS();
            return ms.getCurrentNotificationEventId();
        }

        @Override
        public FireEventResponse fire_listener_event(FireEventRequest rqst) throws TException {
            switch ((FireEventRequestData._Fields)rqst.getData().getSetField()) {
                case INSERT_DATA: {
                    InsertEvent event = new InsertEvent(rqst.getDbName(), rqst.getTableName(), rqst.getPartitionVals(), rqst.getData().getInsertData().getFilesAdded(), rqst.isSuccessful(), this);
                    for (MetaStoreEventListener listener : this.listeners) {
                        listener.onInsert(event);
                    }
                    return new FireEventResponse();
                }
            }
            throw new TException("Event type " + ((FireEventRequestData._Fields)rqst.getData().getSetField()).toString() + " not currently supported.");
        }

        @Override
        public GetFileMetadataByExprResult get_file_metadata_by_expr(GetFileMetadataByExprRequest req) throws TException {
            GetFileMetadataByExprResult result = new GetFileMetadataByExprResult();
            RawStore ms = this.getMS();
            if (!ms.isFileMetadataSupported()) {
                result.setIsSupported(false);
                result.setMetadata(EMPTY_MAP_FM2);
                return result;
            }
            result.setIsSupported(true);
            List<Long> fileIds = req.getFileIds();
            boolean needMetadata = !req.isSetDoGetFooters() || req.isDoGetFooters();
            FileMetadataExprType type = req.isSetType() ? req.getType() : FileMetadataExprType.ORC_SARG;
            ByteBuffer[] metadatas = needMetadata ? new ByteBuffer[fileIds.size()] : null;
            ByteBuffer[] ppdResults = new ByteBuffer[fileIds.size()];
            boolean[] eliminated = new boolean[fileIds.size()];
            this.getMS().getFileMetadataByExpr(fileIds, type, req.getExpr(), metadatas, ppdResults, eliminated);
            for (int i = 0; i < metadatas.length; ++i) {
                long fileId = fileIds.get(i);
                ByteBuffer metadata = metadatas[i];
                if (metadata == null) continue;
                metadata = eliminated[i] || !needMetadata ? null : this.handleReadOnlyBufferForThrift(metadata);
                MetadataPpdResult mpr = new MetadataPpdResult();
                ByteBuffer bitset = eliminated[i] ? null : this.handleReadOnlyBufferForThrift(ppdResults[i]);
                mpr.setMetadata(metadata);
                mpr.setIncludeBitset(bitset);
                result.putToMetadata(fileId, mpr);
            }
            if (!result.isSetMetadata()) {
                result.setMetadata(EMPTY_MAP_FM2);
            }
            return result;
        }

        @Override
        public GetFileMetadataResult get_file_metadata(GetFileMetadataRequest req) throws TException {
            GetFileMetadataResult result = new GetFileMetadataResult();
            RawStore ms = this.getMS();
            if (!ms.isFileMetadataSupported()) {
                result.setIsSupported(false);
                result.setMetadata(EMPTY_MAP_FM1);
                return result;
            }
            result.setIsSupported(true);
            List<Long> fileIds = req.getFileIds();
            ByteBuffer[] metadatas = ms.getFileMetadata(fileIds);
            assert (metadatas.length == fileIds.size());
            for (int i = 0; i < metadatas.length; ++i) {
                ByteBuffer bb = metadatas[i];
                if (bb == null) continue;
                bb = this.handleReadOnlyBufferForThrift(bb);
                result.putToMetadata(fileIds.get(i), bb);
            }
            if (!result.isSetMetadata()) {
                result.setMetadata(EMPTY_MAP_FM1);
            }
            return result;
        }

        private ByteBuffer handleReadOnlyBufferForThrift(ByteBuffer bb) {
            if (!bb.isReadOnly()) {
                return bb;
            }
            ByteBuffer copy = ByteBuffer.allocate(bb.capacity());
            copy.put(bb);
            copy.flip();
            return copy;
        }

        @Override
        public PutFileMetadataResult put_file_metadata(PutFileMetadataRequest req) throws TException {
            RawStore ms = this.getMS();
            if (ms.isFileMetadataSupported()) {
                ms.putFileMetadata(req.getFileIds(), req.getMetadata());
            }
            return new PutFileMetadataResult();
        }

        @Override
        public ClearFileMetadataResult clear_file_metadata(ClearFileMetadataRequest req) throws TException {
            this.getMS().putFileMetadata(req.getFileIds(), null);
            return new ClearFileMetadataResult();
        }

        static {
            threadLocalMS = new ThreadLocal<RawStore>(){

                @Override
                protected RawStore initialValue() {
                    return null;
                }
            };
            threadLocalTxn = new ThreadLocal<TxnHandler>(){

                @Override
                protected TxnHandler initialValue() {
                    return null;
                }
            };
            threadLocalConf = new ThreadLocal<Configuration>(){

                @Override
                protected Configuration initialValue() {
                    return null;
                }
            };
            auditLog = LoggerFactory.getLogger((String)(HiveMetaStore.class.getName() + ".audit"));
            auditFormatter = new ThreadLocal<Formatter>(){

                @Override
                protected Formatter initialValue() {
                    return new Formatter(new StringBuilder(HMSHandler.AUDIT_FORMAT.length() * 4));
                }
            };
            nextSerialNum = 0;
            threadLocalId = new ThreadLocal<Integer>(){

                @Override
                protected Integer initialValue() {
                    return new Integer(nextSerialNum++);
                }
            };
            threadLocalIpAddress = new ThreadLocal<String>(){

                @Override
                protected String initialValue() {
                    return null;
                }
            };
            EMPTY_MAP_FM1 = new HashMap<Long, ByteBuffer>(1);
            EMPTY_MAP_FM2 = new HashMap<Long, MetadataPpdResult>(1);
        }

        private static class StorageDescriptorKey {
            private final StorageDescriptor sd;

            StorageDescriptorKey(StorageDescriptor sd) {
                this.sd = sd;
            }

            StorageDescriptor getSd() {
                return this.sd;
            }

            private String hashCodeKey() {
                return this.sd.getInputFormat() + "\t" + this.sd.getOutputFormat() + "\t" + this.sd.getSerdeInfo().getSerializationLib() + "\t" + this.sd.getCols();
            }

            public int hashCode() {
                return this.hashCodeKey().hashCode();
            }

            public boolean equals(Object rhs) {
                if (rhs == this) {
                    return true;
                }
                if (!(rhs instanceof StorageDescriptorKey)) {
                    return false;
                }
                return this.hashCodeKey().equals(((StorageDescriptorKey)rhs).hashCodeKey());
            }
        }

        private static class PathAndPartValSize {
            public Path path;
            public int partValSize;

            public PathAndPartValSize(Path path, int partValSize) {
                this.path = path;
                this.partValSize = partValSize;
            }
        }

        private static class PartValEqWrapperLite {
            List<String> values;
            String location;

            public PartValEqWrapperLite(Partition partition) {
                this.values = partition.isSetValues() ? partition.getValues() : null;
                this.location = partition.getSd().getLocation();
            }

            public int hashCode() {
                return this.values == null ? 0 : this.values.hashCode();
            }

            public boolean equals(Object obj) {
                if (this == obj) {
                    return true;
                }
                if (obj == null || !(obj instanceof PartValEqWrapperLite)) {
                    return false;
                }
                List<String> lhsValues = this.values;
                List<String> rhsValues = ((PartValEqWrapperLite)obj).values;
                if (lhsValues == null || rhsValues == null) {
                    return lhsValues == rhsValues;
                }
                if (lhsValues.size() != rhsValues.size()) {
                    return false;
                }
                for (int i = 0; i < lhsValues.size(); ++i) {
                    String lhsValue = lhsValues.get(i);
                    String rhsValue = rhsValues.get(i);
                    if ((lhsValue != null || rhsValue == null) && (lhsValue == null || lhsValue.equals(rhsValue))) continue;
                    return false;
                }
                return true;
            }
        }

        private static class PartValEqWrapper {
            Partition partition;

            public PartValEqWrapper(Partition partition) {
                this.partition = partition;
            }

            public int hashCode() {
                return this.partition.isSetValues() ? this.partition.getValues().hashCode() : 0;
            }

            public boolean equals(Object obj) {
                if (this == obj) {
                    return true;
                }
                if (obj == null || !(obj instanceof PartValEqWrapper)) {
                    return false;
                }
                Partition p1 = this.partition;
                Partition p2 = ((PartValEqWrapper)obj).partition;
                if (!p1.isSetValues() || !p2.isSetValues()) {
                    return p1.isSetValues() == p2.isSetValues();
                }
                if (p1.getValues().size() != p2.getValues().size()) {
                    return false;
                }
                for (int i = 0; i < p1.getValues().size(); ++i) {
                    String v1 = p1.getValues().get(i);
                    String v2 = p2.getValues().get(i);
                    if (v1 == null && v2 == null || v1 != null && v1.equals(v2)) continue;
                    return false;
                }
                return true;
            }
        }
    }

    private static final class ChainedTTransportFactory
    extends TTransportFactory {
        private final TTransportFactory parentTransFactory;
        private final TTransportFactory childTransFactory;

        private ChainedTTransportFactory(TTransportFactory parentTransFactory, TTransportFactory childTransFactory) {
            this.parentTransFactory = parentTransFactory;
            this.childTransFactory = childTransFactory;
        }

        @Override
        public TTransport getTransport(TTransport trans) {
            return this.childTransFactory.getTransport(this.parentTransFactory.getTransport(trans));
        }
    }
}

