/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.txn.compactor;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.api.AbortTxnRequest;
import org.apache.hadoop.hive.metastore.api.CommitTxnRequest;
import org.apache.hadoop.hive.metastore.api.CompactionRequest;
import org.apache.hadoop.hive.metastore.api.CompactionType;
import org.apache.hadoop.hive.metastore.api.GetOpenTxnsResponse;
import org.apache.hadoop.hive.metastore.api.LockComponent;
import org.apache.hadoop.hive.metastore.api.LockLevel;
import org.apache.hadoop.hive.metastore.api.LockRequest;
import org.apache.hadoop.hive.metastore.api.LockResponse;
import org.apache.hadoop.hive.metastore.api.LockType;
import org.apache.hadoop.hive.metastore.api.Partition;
import org.apache.hadoop.hive.metastore.api.ShowCompactRequest;
import org.apache.hadoop.hive.metastore.api.ShowCompactResponse;
import org.apache.hadoop.hive.metastore.api.ShowCompactResponseElement;
import org.apache.hadoop.hive.metastore.api.Table;
import org.apache.hadoop.hive.ql.txn.compactor.CompactorTest;
import org.apache.hadoop.hive.ql.txn.compactor.Worker;
import org.junit.Assert;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestInitiator
extends CompactorTest {
    private static final String CLASS_NAME = TestInitiator.class.getName();
    private static final Logger LOG = LoggerFactory.getLogger((String)CLASS_NAME);

    @Test
    public void nothing() throws Exception {
        this.startInitiator();
    }

    @Test
    public void recoverFailedLocalWorkers() throws Exception {
        Table t = this.newTable("default", "rflw1", false);
        CompactionRequest rqst = new CompactionRequest("default", "rflw1", CompactionType.MINOR);
        this.txnHandler.compact(rqst);
        t = this.newTable("default", "rflw2", false);
        rqst = new CompactionRequest("default", "rflw2", CompactionType.MINOR);
        this.txnHandler.compact(rqst);
        this.txnHandler.findNextToCompact(Worker.hostname() + "-193892");
        this.txnHandler.findNextToCompact("nosuchhost-193892");
        this.startInitiator();
        ShowCompactResponse rsp = this.txnHandler.showCompact(new ShowCompactRequest());
        List compacts = rsp.getCompacts();
        Assert.assertEquals((long)2L, (long)compacts.size());
        boolean sawInitiated = false;
        for (ShowCompactResponseElement c : compacts) {
            if (c.getState().equals("working")) {
                Assert.assertEquals((Object)"nosuchhost-193892", (Object)c.getWorkerid());
                continue;
            }
            if (c.getState().equals("initiated")) {
                sawInitiated = true;
                continue;
            }
            Assert.fail((String)"Unexpected state");
        }
        Assert.assertTrue((boolean)sawInitiated);
    }

    @Test
    public void recoverFailedRemoteWorkers() throws Exception {
        Table t = this.newTable("default", "rfrw1", false);
        CompactionRequest rqst = new CompactionRequest("default", "rfrw1", CompactionType.MINOR);
        this.txnHandler.compact(rqst);
        this.txnHandler.findNextToCompact("nosuchhost-193892");
        this.conf.setTimeVar(HiveConf.ConfVars.HIVE_COMPACTOR_WORKER_TIMEOUT, 1L, TimeUnit.MILLISECONDS);
        this.startInitiator();
        ShowCompactResponse rsp = this.txnHandler.showCompact(new ShowCompactRequest());
        List compacts = rsp.getCompacts();
        Assert.assertEquals((long)1L, (long)compacts.size());
        Assert.assertEquals((Object)"initiated", (Object)((ShowCompactResponseElement)compacts.get(0)).getState());
    }

    @Test
    public void majorCompactOnTableTooManyAborts() throws Exception {
        Table t = this.newTable("default", "mcottma", false);
        HiveConf.setIntVar((Configuration)this.conf, (HiveConf.ConfVars)HiveConf.ConfVars.HIVE_COMPACTOR_ABORTEDTXN_THRESHOLD, (int)10);
        for (int i = 0; i < 11; ++i) {
            long txnid = this.openTxn();
            LockComponent comp = new LockComponent(LockType.SHARED_WRITE, LockLevel.TABLE, "default");
            comp.setTablename("mcottma");
            ArrayList<LockComponent> components = new ArrayList<LockComponent>(1);
            components.add(comp);
            LockRequest req = new LockRequest(components, "me", "localhost");
            req.setTxnid(txnid);
            LockResponse res = this.txnHandler.lock(req);
            this.txnHandler.abortTxn(new AbortTxnRequest(txnid));
        }
        this.startInitiator();
        ShowCompactResponse rsp = this.txnHandler.showCompact(new ShowCompactRequest());
        List compacts = rsp.getCompacts();
        Assert.assertEquals((long)1L, (long)compacts.size());
        Assert.assertEquals((Object)"initiated", (Object)((ShowCompactResponseElement)compacts.get(0)).getState());
        Assert.assertEquals((Object)"mcottma", (Object)((ShowCompactResponseElement)compacts.get(0)).getTablename());
        Assert.assertEquals((Object)CompactionType.MAJOR, (Object)((ShowCompactResponseElement)compacts.get(0)).getType());
    }

    @Test
    public void majorCompactOnPartitionTooManyAborts() throws Exception {
        Table t = this.newTable("default", "mcoptma", true);
        Partition p = this.newPartition(t, "today");
        HiveConf.setIntVar((Configuration)this.conf, (HiveConf.ConfVars)HiveConf.ConfVars.HIVE_COMPACTOR_ABORTEDTXN_THRESHOLD, (int)10);
        for (int i = 0; i < 11; ++i) {
            long txnid = this.openTxn();
            LockComponent comp = new LockComponent(LockType.SHARED_WRITE, LockLevel.TABLE, "default");
            comp.setTablename("mcoptma");
            comp.setPartitionname("ds=today");
            ArrayList<LockComponent> components = new ArrayList<LockComponent>(1);
            components.add(comp);
            LockRequest req = new LockRequest(components, "me", "localhost");
            req.setTxnid(txnid);
            LockResponse res = this.txnHandler.lock(req);
            this.txnHandler.abortTxn(new AbortTxnRequest(txnid));
        }
        this.startInitiator();
        ShowCompactResponse rsp = this.txnHandler.showCompact(new ShowCompactRequest());
        List compacts = rsp.getCompacts();
        Assert.assertEquals((long)1L, (long)compacts.size());
        Assert.assertEquals((Object)"initiated", (Object)((ShowCompactResponseElement)compacts.get(0)).getState());
        Assert.assertEquals((Object)"mcoptma", (Object)((ShowCompactResponseElement)compacts.get(0)).getTablename());
        Assert.assertEquals((Object)"ds=today", (Object)((ShowCompactResponseElement)compacts.get(0)).getPartitionname());
        Assert.assertEquals((Object)CompactionType.MAJOR, (Object)((ShowCompactResponseElement)compacts.get(0)).getType());
    }

    @Test
    public void noCompactOnManyDifferentPartitionAborts() throws Exception {
        int i;
        Table t = this.newTable("default", "ncomdpa", true);
        for (i = 0; i < 11; ++i) {
            Partition p = this.newPartition(t, "day-" + i);
        }
        HiveConf.setIntVar((Configuration)this.conf, (HiveConf.ConfVars)HiveConf.ConfVars.HIVE_COMPACTOR_ABORTEDTXN_THRESHOLD, (int)10);
        for (i = 0; i < 11; ++i) {
            long txnid = this.openTxn();
            LockComponent comp = new LockComponent(LockType.SHARED_WRITE, LockLevel.TABLE, "default");
            comp.setTablename("ncomdpa");
            comp.setPartitionname("ds=day-" + i);
            ArrayList<LockComponent> components = new ArrayList<LockComponent>(1);
            components.add(comp);
            LockRequest req = new LockRequest(components, "me", "localhost");
            req.setTxnid(txnid);
            LockResponse res = this.txnHandler.lock(req);
            this.txnHandler.abortTxn(new AbortTxnRequest(txnid));
        }
        this.startInitiator();
        ShowCompactResponse rsp = this.txnHandler.showCompact(new ShowCompactRequest());
        Assert.assertEquals((long)0L, (long)rsp.getCompactsSize());
    }

    @Test
    public void cleanEmptyAbortedTxns() throws Exception {
        Table t = this.newTable("default", "ceat", false);
        long txnid = this.openTxn();
        LockComponent comp = new LockComponent(LockType.SHARED_WRITE, LockLevel.TABLE, "default");
        comp.setTablename("ceat");
        ArrayList<LockComponent> components = new ArrayList<LockComponent>(1);
        components.add(comp);
        LockRequest req = new LockRequest(components, "me", "localhost");
        req.setTxnid(txnid);
        LockResponse res = this.txnHandler.lock(req);
        this.txnHandler.abortTxn(new AbortTxnRequest(txnid));
        for (int i = 0; i < 1050; ++i) {
            txnid = this.openTxn();
            this.txnHandler.abortTxn(new AbortTxnRequest(txnid));
        }
        GetOpenTxnsResponse openTxns = this.txnHandler.getOpenTxns();
        Assert.assertEquals((long)1051L, (long)openTxns.getOpen_txnsSize());
        this.startInitiator();
        openTxns = this.txnHandler.getOpenTxns();
        Assert.assertEquals((long)1L, (long)openTxns.getOpen_txnsSize());
    }

    @Test
    public void noCompactWhenNoCompactSet() throws Exception {
        HashMap<String, String> parameters = new HashMap<String, String>(1);
        parameters.put("NO_AUTO_COMPACTION", "true");
        Table t = this.newTable("default", "ncwncs", false, parameters);
        HiveConf.setIntVar((Configuration)this.conf, (HiveConf.ConfVars)HiveConf.ConfVars.HIVE_COMPACTOR_ABORTEDTXN_THRESHOLD, (int)10);
        for (int i = 0; i < 11; ++i) {
            long txnid = this.openTxn();
            LockComponent comp = new LockComponent(LockType.SHARED_WRITE, LockLevel.TABLE, "default");
            comp.setTablename("ncwncs");
            ArrayList<LockComponent> components = new ArrayList<LockComponent>(1);
            components.add(comp);
            LockRequest req = new LockRequest(components, "me", "localhost");
            req.setTxnid(txnid);
            LockResponse res = this.txnHandler.lock(req);
            this.txnHandler.abortTxn(new AbortTxnRequest(txnid));
        }
        this.startInitiator();
        ShowCompactResponse rsp = this.txnHandler.showCompact(new ShowCompactRequest());
        Assert.assertEquals((long)0L, (long)rsp.getCompactsSize());
    }

    @Test
    public void noCompactWhenNoCompactSetLowerCase() throws Exception {
        HashMap<String, String> parameters = new HashMap<String, String>(1);
        parameters.put("no_auto_compaction", "true");
        Table t = this.newTable("default", "ncwncs", false, parameters);
        HiveConf.setIntVar((Configuration)this.conf, (HiveConf.ConfVars)HiveConf.ConfVars.HIVE_COMPACTOR_ABORTEDTXN_THRESHOLD, (int)10);
        for (int i = 0; i < 11; ++i) {
            long txnid = this.openTxn();
            LockComponent comp = new LockComponent(LockType.SHARED_WRITE, LockLevel.TABLE, "default");
            comp.setTablename("ncwncs");
            ArrayList<LockComponent> components = new ArrayList<LockComponent>(1);
            components.add(comp);
            LockRequest req = new LockRequest(components, "me", "localhost");
            req.setTxnid(txnid);
            LockResponse res = this.txnHandler.lock(req);
            this.txnHandler.abortTxn(new AbortTxnRequest(txnid));
        }
        this.startInitiator();
        ShowCompactResponse rsp = this.txnHandler.showCompact(new ShowCompactRequest());
        Assert.assertEquals((long)0L, (long)rsp.getCompactsSize());
    }

    @Test
    public void noCompactWhenCompactAlreadyScheduled() throws Exception {
        Table t = this.newTable("default", "ncwcas", false);
        HiveConf.setIntVar((Configuration)this.conf, (HiveConf.ConfVars)HiveConf.ConfVars.HIVE_COMPACTOR_ABORTEDTXN_THRESHOLD, (int)10);
        for (int i = 0; i < 11; ++i) {
            long txnid = this.openTxn();
            LockComponent comp = new LockComponent(LockType.SHARED_WRITE, LockLevel.TABLE, "default");
            comp.setTablename("ncwcas");
            ArrayList<LockComponent> components = new ArrayList<LockComponent>(1);
            components.add(comp);
            LockRequest req = new LockRequest(components, "me", "localhost");
            req.setTxnid(txnid);
            LockResponse res = this.txnHandler.lock(req);
            this.txnHandler.abortTxn(new AbortTxnRequest(txnid));
        }
        CompactionRequest rqst = new CompactionRequest("default", "ncwcas", CompactionType.MAJOR);
        this.txnHandler.compact(rqst);
        ShowCompactResponse rsp = this.txnHandler.showCompact(new ShowCompactRequest());
        List compacts = rsp.getCompacts();
        Assert.assertEquals((long)1L, (long)compacts.size());
        Assert.assertEquals((Object)"initiated", (Object)((ShowCompactResponseElement)compacts.get(0)).getState());
        Assert.assertEquals((Object)"ncwcas", (Object)((ShowCompactResponseElement)compacts.get(0)).getTablename());
        this.startInitiator();
        rsp = this.txnHandler.showCompact(new ShowCompactRequest());
        compacts = rsp.getCompacts();
        Assert.assertEquals((long)1L, (long)compacts.size());
        Assert.assertEquals((Object)"initiated", (Object)((ShowCompactResponseElement)compacts.get(0)).getState());
        Assert.assertEquals((Object)"ncwcas", (Object)((ShowCompactResponseElement)compacts.get(0)).getTablename());
        Assert.assertEquals((Object)CompactionType.MAJOR, (Object)((ShowCompactResponseElement)compacts.get(0)).getType());
    }

    @Test
    public void compactTableHighDeltaPct() throws Exception {
        Table t = this.newTable("default", "cthdp", false);
        this.addBaseFile(t, null, 20L, 20);
        this.addDeltaFile(t, null, 21L, 22L, 2);
        this.addDeltaFile(t, null, 23L, 24L, 2);
        this.burnThroughTransactions(23);
        long txnid = this.openTxn();
        LockComponent comp = new LockComponent(LockType.SHARED_WRITE, LockLevel.TABLE, "default");
        comp.setTablename("cthdp");
        ArrayList<LockComponent> components = new ArrayList<LockComponent>(1);
        components.add(comp);
        LockRequest req = new LockRequest(components, "me", "localhost");
        req.setTxnid(txnid);
        LockResponse res = this.txnHandler.lock(req);
        this.txnHandler.commitTxn(new CommitTxnRequest(txnid));
        this.startInitiator();
        ShowCompactResponse rsp = this.txnHandler.showCompact(new ShowCompactRequest());
        List compacts = rsp.getCompacts();
        Assert.assertEquals((long)1L, (long)compacts.size());
        Assert.assertEquals((Object)"initiated", (Object)((ShowCompactResponseElement)compacts.get(0)).getState());
        Assert.assertEquals((Object)"cthdp", (Object)((ShowCompactResponseElement)compacts.get(0)).getTablename());
        Assert.assertEquals((Object)CompactionType.MAJOR, (Object)((ShowCompactResponseElement)compacts.get(0)).getType());
    }

    @Test
    public void compactPartitionHighDeltaPct() throws Exception {
        Table t = this.newTable("default", "cphdp", true);
        Partition p = this.newPartition(t, "today");
        this.addBaseFile(t, p, 20L, 20);
        this.addDeltaFile(t, p, 21L, 22L, 2);
        this.addDeltaFile(t, p, 23L, 24L, 2);
        this.burnThroughTransactions(23);
        long txnid = this.openTxn();
        LockComponent comp = new LockComponent(LockType.SHARED_WRITE, LockLevel.PARTITION, "default");
        comp.setTablename("cphdp");
        comp.setPartitionname("ds=today");
        ArrayList<LockComponent> components = new ArrayList<LockComponent>(1);
        components.add(comp);
        LockRequest req = new LockRequest(components, "me", "localhost");
        req.setTxnid(txnid);
        LockResponse res = this.txnHandler.lock(req);
        this.txnHandler.commitTxn(new CommitTxnRequest(txnid));
        this.startInitiator();
        ShowCompactResponse rsp = this.txnHandler.showCompact(new ShowCompactRequest());
        List compacts = rsp.getCompacts();
        Assert.assertEquals((long)1L, (long)compacts.size());
        Assert.assertEquals((Object)"initiated", (Object)((ShowCompactResponseElement)compacts.get(0)).getState());
        Assert.assertEquals((Object)"cphdp", (Object)((ShowCompactResponseElement)compacts.get(0)).getTablename());
        Assert.assertEquals((Object)"ds=today", (Object)((ShowCompactResponseElement)compacts.get(0)).getPartitionname());
        Assert.assertEquals((Object)CompactionType.MAJOR, (Object)((ShowCompactResponseElement)compacts.get(0)).getType());
    }

    @Test
    public void noCompactTableDeltaPctNotHighEnough() throws Exception {
        Table t = this.newTable("default", "nctdpnhe", false);
        this.addBaseFile(t, null, 50L, 50);
        this.addDeltaFile(t, null, 21L, 22L, 2);
        this.addDeltaFile(t, null, 23L, 24L, 2);
        this.burnThroughTransactions(53);
        long txnid = this.openTxn();
        LockComponent comp = new LockComponent(LockType.SHARED_WRITE, LockLevel.TABLE, "default");
        comp.setTablename("nctdpnhe");
        ArrayList<LockComponent> components = new ArrayList<LockComponent>(1);
        components.add(comp);
        LockRequest req = new LockRequest(components, "me", "localhost");
        req.setTxnid(txnid);
        LockResponse res = this.txnHandler.lock(req);
        this.txnHandler.commitTxn(new CommitTxnRequest(txnid));
        this.startInitiator();
        ShowCompactResponse rsp = this.txnHandler.showCompact(new ShowCompactRequest());
        Assert.assertEquals((long)0L, (long)rsp.getCompactsSize());
    }

    @Test
    public void compactTableTooManyDeltas() throws Exception {
        Table t = this.newTable("default", "cttmd", false);
        this.addBaseFile(t, null, 200L, 200);
        this.addDeltaFile(t, null, 201L, 201L, 1);
        this.addDeltaFile(t, null, 202L, 202L, 1);
        this.addDeltaFile(t, null, 203L, 203L, 1);
        this.addDeltaFile(t, null, 204L, 204L, 1);
        this.addDeltaFile(t, null, 205L, 205L, 1);
        this.addDeltaFile(t, null, 206L, 206L, 1);
        this.addDeltaFile(t, null, 207L, 207L, 1);
        this.addDeltaFile(t, null, 208L, 208L, 1);
        this.addDeltaFile(t, null, 209L, 209L, 1);
        this.addDeltaFile(t, null, 210L, 210L, 1);
        this.addDeltaFile(t, null, 211L, 211L, 1);
        this.burnThroughTransactions(210);
        long txnid = this.openTxn();
        LockComponent comp = new LockComponent(LockType.SHARED_WRITE, LockLevel.TABLE, "default");
        comp.setTablename("cttmd");
        ArrayList<LockComponent> components = new ArrayList<LockComponent>(1);
        components.add(comp);
        LockRequest req = new LockRequest(components, "me", "localhost");
        req.setTxnid(txnid);
        LockResponse res = this.txnHandler.lock(req);
        this.txnHandler.commitTxn(new CommitTxnRequest(txnid));
        this.startInitiator();
        ShowCompactResponse rsp = this.txnHandler.showCompact(new ShowCompactRequest());
        List compacts = rsp.getCompacts();
        Assert.assertEquals((long)1L, (long)compacts.size());
        Assert.assertEquals((Object)"initiated", (Object)((ShowCompactResponseElement)compacts.get(0)).getState());
        Assert.assertEquals((Object)"cttmd", (Object)((ShowCompactResponseElement)compacts.get(0)).getTablename());
        Assert.assertEquals((Object)CompactionType.MINOR, (Object)((ShowCompactResponseElement)compacts.get(0)).getType());
    }

    @Test
    public void compactPartitionTooManyDeltas() throws Exception {
        Table t = this.newTable("default", "cptmd", true);
        Partition p = this.newPartition(t, "today");
        this.addBaseFile(t, p, 200L, 200);
        this.addDeltaFile(t, p, 201L, 201L, 1);
        this.addDeltaFile(t, p, 202L, 202L, 1);
        this.addDeltaFile(t, p, 203L, 203L, 1);
        this.addDeltaFile(t, p, 204L, 204L, 1);
        this.addDeltaFile(t, p, 205L, 205L, 1);
        this.addDeltaFile(t, p, 206L, 206L, 1);
        this.addDeltaFile(t, p, 207L, 207L, 1);
        this.addDeltaFile(t, p, 208L, 208L, 1);
        this.addDeltaFile(t, p, 209L, 209L, 1);
        this.addDeltaFile(t, p, 210L, 210L, 1);
        this.addDeltaFile(t, p, 211L, 211L, 1);
        this.burnThroughTransactions(210);
        long txnid = this.openTxn();
        LockComponent comp = new LockComponent(LockType.SHARED_WRITE, LockLevel.PARTITION, "default");
        comp.setTablename("cptmd");
        comp.setPartitionname("ds=today");
        ArrayList<LockComponent> components = new ArrayList<LockComponent>(1);
        components.add(comp);
        LockRequest req = new LockRequest(components, "me", "localhost");
        req.setTxnid(txnid);
        LockResponse res = this.txnHandler.lock(req);
        this.txnHandler.commitTxn(new CommitTxnRequest(txnid));
        this.startInitiator();
        ShowCompactResponse rsp = this.txnHandler.showCompact(new ShowCompactRequest());
        List compacts = rsp.getCompacts();
        Assert.assertEquals((long)1L, (long)compacts.size());
        Assert.assertEquals((Object)"initiated", (Object)((ShowCompactResponseElement)compacts.get(0)).getState());
        Assert.assertEquals((Object)"cptmd", (Object)((ShowCompactResponseElement)compacts.get(0)).getTablename());
        Assert.assertEquals((Object)"ds=today", (Object)((ShowCompactResponseElement)compacts.get(0)).getPartitionname());
        Assert.assertEquals((Object)CompactionType.MINOR, (Object)((ShowCompactResponseElement)compacts.get(0)).getType());
    }

    @Test
    public void noCompactTableNotEnoughDeltas() throws Exception {
        Table t = this.newTable("default", "nctned", false);
        this.addBaseFile(t, null, 200L, 200);
        this.addDeltaFile(t, null, 201L, 205L, 5);
        this.addDeltaFile(t, null, 206L, 211L, 6);
        this.burnThroughTransactions(210);
        long txnid = this.openTxn();
        LockComponent comp = new LockComponent(LockType.SHARED_WRITE, LockLevel.TABLE, "default");
        comp.setTablename("nctned");
        ArrayList<LockComponent> components = new ArrayList<LockComponent>(1);
        components.add(comp);
        LockRequest req = new LockRequest(components, "me", "localhost");
        req.setTxnid(txnid);
        LockResponse res = this.txnHandler.lock(req);
        this.txnHandler.commitTxn(new CommitTxnRequest(txnid));
        this.startInitiator();
        ShowCompactResponse rsp = this.txnHandler.showCompact(new ShowCompactRequest());
        Assert.assertEquals((long)0L, (long)rsp.getCompactsSize());
    }

    @Test
    public void chooseMajorOverMinorWhenBothValid() throws Exception {
        Table t = this.newTable("default", "cmomwbv", false);
        this.addBaseFile(t, null, 200L, 200);
        this.addDeltaFile(t, null, 201L, 211L, 11);
        this.addDeltaFile(t, null, 212L, 222L, 11);
        this.addDeltaFile(t, null, 223L, 233L, 11);
        this.addDeltaFile(t, null, 234L, 244L, 11);
        this.addDeltaFile(t, null, 245L, 255L, 11);
        this.addDeltaFile(t, null, 256L, 266L, 11);
        this.addDeltaFile(t, null, 267L, 277L, 11);
        this.addDeltaFile(t, null, 278L, 288L, 11);
        this.addDeltaFile(t, null, 289L, 299L, 11);
        this.addDeltaFile(t, null, 300L, 310L, 11);
        this.addDeltaFile(t, null, 311L, 321L, 11);
        this.burnThroughTransactions(320);
        long txnid = this.openTxn();
        LockComponent comp = new LockComponent(LockType.SHARED_WRITE, LockLevel.TABLE, "default");
        comp.setTablename("cmomwbv");
        ArrayList<LockComponent> components = new ArrayList<LockComponent>(1);
        components.add(comp);
        LockRequest req = new LockRequest(components, "me", "localhost");
        req.setTxnid(txnid);
        LockResponse res = this.txnHandler.lock(req);
        this.txnHandler.commitTxn(new CommitTxnRequest(txnid));
        this.startInitiator();
        ShowCompactResponse rsp = this.txnHandler.showCompact(new ShowCompactRequest());
        List compacts = rsp.getCompacts();
        Assert.assertEquals((long)1L, (long)compacts.size());
        Assert.assertEquals((Object)"initiated", (Object)((ShowCompactResponseElement)compacts.get(0)).getState());
        Assert.assertEquals((Object)"cmomwbv", (Object)((ShowCompactResponseElement)compacts.get(0)).getTablename());
        Assert.assertEquals((Object)CompactionType.MAJOR, (Object)((ShowCompactResponseElement)compacts.get(0)).getType());
    }

    @Test
    public void enoughDeltasNoBase() throws Exception {
        Table t = this.newTable("default", "ednb", true);
        Partition p = this.newPartition(t, "today");
        this.addDeltaFile(t, p, 1L, 201L, 200);
        this.addDeltaFile(t, p, 202L, 202L, 1);
        this.addDeltaFile(t, p, 203L, 203L, 1);
        this.addDeltaFile(t, p, 204L, 204L, 1);
        this.addDeltaFile(t, p, 205L, 205L, 1);
        this.addDeltaFile(t, p, 206L, 206L, 1);
        this.addDeltaFile(t, p, 207L, 207L, 1);
        this.addDeltaFile(t, p, 208L, 208L, 1);
        this.addDeltaFile(t, p, 209L, 209L, 1);
        this.addDeltaFile(t, p, 210L, 210L, 1);
        this.addDeltaFile(t, p, 211L, 211L, 1);
        this.burnThroughTransactions(210);
        long txnid = this.openTxn();
        LockComponent comp = new LockComponent(LockType.SHARED_WRITE, LockLevel.PARTITION, "default");
        comp.setTablename("ednb");
        comp.setPartitionname("ds=today");
        ArrayList<LockComponent> components = new ArrayList<LockComponent>(1);
        components.add(comp);
        LockRequest req = new LockRequest(components, "me", "localhost");
        req.setTxnid(txnid);
        LockResponse res = this.txnHandler.lock(req);
        this.txnHandler.commitTxn(new CommitTxnRequest(txnid));
        this.startInitiator();
        ShowCompactResponse rsp = this.txnHandler.showCompact(new ShowCompactRequest());
        List compacts = rsp.getCompacts();
        Assert.assertEquals((long)1L, (long)compacts.size());
        Assert.assertEquals((Object)"initiated", (Object)((ShowCompactResponseElement)compacts.get(0)).getState());
        Assert.assertEquals((Object)"ednb", (Object)((ShowCompactResponseElement)compacts.get(0)).getTablename());
        Assert.assertEquals((Object)"ds=today", (Object)((ShowCompactResponseElement)compacts.get(0)).getPartitionname());
        Assert.assertEquals((Object)CompactionType.MAJOR, (Object)((ShowCompactResponseElement)compacts.get(0)).getType());
    }

    @Test
    public void twoTxnsOnSamePartitionGenerateOneCompactionRequest() throws Exception {
        Table t = this.newTable("default", "ttospgocr", true);
        Partition p = this.newPartition(t, "today");
        this.addBaseFile(t, p, 20L, 20);
        this.addDeltaFile(t, p, 21L, 22L, 2);
        this.addDeltaFile(t, p, 23L, 24L, 2);
        this.burnThroughTransactions(23);
        long txnid = this.openTxn();
        LockComponent comp = new LockComponent(LockType.SHARED_WRITE, LockLevel.PARTITION, "default");
        comp.setTablename("ttospgocr");
        comp.setPartitionname("ds=today");
        ArrayList<LockComponent> components = new ArrayList<LockComponent>(1);
        components.add(comp);
        LockRequest req = new LockRequest(components, "me", "localhost");
        req.setTxnid(txnid);
        LockResponse res = this.txnHandler.lock(req);
        this.txnHandler.commitTxn(new CommitTxnRequest(txnid));
        txnid = this.openTxn();
        comp = new LockComponent(LockType.SHARED_WRITE, LockLevel.PARTITION, "default");
        comp.setTablename("ttospgocr");
        comp.setPartitionname("ds=today");
        components = new ArrayList(1);
        components.add(comp);
        req = new LockRequest(components, "me", "localhost");
        req.setTxnid(txnid);
        res = this.txnHandler.lock(req);
        this.txnHandler.commitTxn(new CommitTxnRequest(txnid));
        this.startInitiator();
        ShowCompactResponse rsp = this.txnHandler.showCompact(new ShowCompactRequest());
        List compacts = rsp.getCompacts();
        Assert.assertEquals((long)1L, (long)compacts.size());
        Assert.assertEquals((Object)"initiated", (Object)((ShowCompactResponseElement)compacts.get(0)).getState());
        Assert.assertEquals((Object)"ttospgocr", (Object)((ShowCompactResponseElement)compacts.get(0)).getTablename());
        Assert.assertEquals((Object)"ds=today", (Object)((ShowCompactResponseElement)compacts.get(0)).getPartitionname());
        Assert.assertEquals((Object)CompactionType.MAJOR, (Object)((ShowCompactResponseElement)compacts.get(0)).getType());
    }

    @Test
    public void noCompactTableDynamicPartitioning() throws Exception {
        Table t = this.newTable("default", "nctdp", true);
        Partition p = this.newPartition(t, "today");
        this.addBaseFile(t, p, 20L, 20);
        this.addDeltaFile(t, p, 21L, 22L, 2);
        this.addDeltaFile(t, p, 23L, 24L, 2);
        this.burnThroughTransactions(23);
        long txnid = this.openTxn();
        LockComponent comp = new LockComponent(LockType.SHARED_WRITE, LockLevel.TABLE, "default");
        comp.setTablename("nctdp");
        ArrayList<LockComponent> components = new ArrayList<LockComponent>(1);
        components.add(comp);
        LockRequest req = new LockRequest(components, "me", "localhost");
        req.setTxnid(txnid);
        LockResponse res = this.txnHandler.lock(req);
        this.txnHandler.commitTxn(new CommitTxnRequest(txnid));
        this.startInitiator();
        ShowCompactResponse rsp = this.txnHandler.showCompact(new ShowCompactRequest());
        List compacts = rsp.getCompacts();
        Assert.assertEquals((long)0L, (long)compacts.size());
    }

    @Test
    public void dropTable() throws Exception {
        Table t = this.newTable("default", "dt", false);
        this.addBaseFile(t, null, 20L, 20);
        this.addDeltaFile(t, null, 21L, 22L, 2);
        this.addDeltaFile(t, null, 23L, 24L, 2);
        this.burnThroughTransactions(23);
        long txnid = this.openTxn();
        LockComponent comp = new LockComponent(LockType.SHARED_WRITE, LockLevel.PARTITION, "default");
        comp.setTablename("dt");
        ArrayList<LockComponent> components = new ArrayList<LockComponent>(1);
        components.add(comp);
        LockRequest req = new LockRequest(components, "me", "localhost");
        req.setTxnid(txnid);
        LockResponse res = this.txnHandler.lock(req);
        this.txnHandler.commitTxn(new CommitTxnRequest(txnid));
        this.ms.dropTable("default", "dt");
        this.startInitiator();
        ShowCompactResponse rsp = this.txnHandler.showCompact(new ShowCompactRequest());
        List compacts = rsp.getCompacts();
        Assert.assertEquals((long)0L, (long)compacts.size());
    }

    @Test
    public void dropPartition() throws Exception {
        Table t = this.newTable("default", "dp", true);
        Partition p = this.newPartition(t, "today");
        this.addBaseFile(t, p, 20L, 20);
        this.addDeltaFile(t, p, 21L, 22L, 2);
        this.addDeltaFile(t, p, 23L, 24L, 2);
        this.burnThroughTransactions(23);
        long txnid = this.openTxn();
        LockComponent comp = new LockComponent(LockType.SHARED_WRITE, LockLevel.PARTITION, "default");
        comp.setTablename("dp");
        comp.setPartitionname("ds=today");
        ArrayList<LockComponent> components = new ArrayList<LockComponent>(1);
        components.add(comp);
        LockRequest req = new LockRequest(components, "me", "localhost");
        req.setTxnid(txnid);
        LockResponse res = this.txnHandler.lock(req);
        this.txnHandler.commitTxn(new CommitTxnRequest(txnid));
        this.ms.dropPartition("default", "dp", Collections.singletonList("today"), true);
        this.startInitiator();
        ShowCompactResponse rsp = this.txnHandler.showCompact(new ShowCompactRequest());
        List compacts = rsp.getCompacts();
        Assert.assertEquals((long)0L, (long)compacts.size());
    }

    @Override
    boolean useHive130DeltaDirName() {
        return false;
    }
}

