/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.parse.authorization;

import java.util.HashMap;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.metadata.Hive;
import org.apache.hadoop.hive.ql.metadata.Partition;
import org.apache.hadoop.hive.ql.metadata.Table;
import org.apache.hadoop.hive.ql.parse.authorization.PrivilegesTestBase;
import org.apache.hadoop.hive.ql.security.authorization.PrivilegeType;
import org.apache.hadoop.hive.ql.session.SessionState;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;

public class TestPrivilegesV1
extends PrivilegesTestBase {
    private HiveConf conf;
    private Hive db;
    private Table table;
    private Partition partition;

    @Before
    public void setup() throws Exception {
        this.conf = new HiveConf();
        this.db = (Hive)Mockito.mock(Hive.class);
        this.table = new Table("default", "table1");
        this.partition = new Partition(this.table);
        SessionState.start((HiveConf)this.conf);
        Mockito.when((Object)this.db.getTable("default", "table1", false)).thenReturn((Object)this.table);
        Mockito.when((Object)this.db.getTable("default.table1", false)).thenReturn((Object)this.table);
        Mockito.when((Object)this.db.getPartition(this.table, new HashMap(), false)).thenReturn((Object)this.partition);
    }

    @Test
    public void testPrivInGrant() throws Exception {
        this.grantUserTable("all", PrivilegeType.ALL);
        this.grantUserTable("update", PrivilegeType.ALTER_DATA);
        this.grantUserTable("alter", PrivilegeType.ALTER_METADATA);
        this.grantUserTable("create", PrivilegeType.CREATE);
        this.grantUserTable("drop", PrivilegeType.DROP);
        this.grantUserTable("index", PrivilegeType.INDEX);
        this.grantUserTable("lock", PrivilegeType.LOCK);
        this.grantUserTable("select", PrivilegeType.SELECT);
        this.grantUserTable("show_database", PrivilegeType.SHOW_DATABASE);
    }

    @Test
    public void testPrivInGrantNotAccepted() throws Exception {
        this.grantUserTable("insert", PrivilegeType.INSERT);
        this.grantUserTable("delete", PrivilegeType.DELETE);
    }

    private void grantUserTable(String privName, PrivilegeType privType) throws Exception {
        TestPrivilegesV1.grantUserTable(privName, privType, this.conf, this.db);
    }
}

