/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.parse;

import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.Context;
import org.apache.hadoop.hive.ql.parse.ASTNode;
import org.apache.hadoop.hive.ql.parse.ParseDriver;
import org.apache.hadoop.hive.ql.parse.ParseException;
import org.apache.hadoop.hive.ql.parse.SemanticAnalyzer;
import org.apache.hadoop.hive.ql.parse.SemanticException;
import org.apache.hadoop.hive.ql.session.SessionState;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;

public class TestIUD {
    private static HiveConf conf;
    private ParseDriver pd;

    @BeforeClass
    public static void initialize() {
        conf = new HiveConf(SemanticAnalyzer.class);
        SessionState.start((HiveConf)conf);
    }

    @Before
    public void setup() throws SemanticException, IOException {
        this.pd = new ParseDriver();
    }

    ASTNode parse(String query) throws ParseException {
        ASTNode nd = null;
        try {
            nd = this.pd.parse(query, new Context((Configuration)conf));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return (ASTNode)nd.getChild(0);
    }

    @Test
    public void testDeleteNoWhere() throws ParseException {
        ASTNode ast = this.parse("DELETE FROM src");
        Assert.assertEquals((String)"AST doesn't match", (Object)"(tok_delete_from (tok_tabname src))", (Object)ast.toStringTree());
    }

    @Test
    public void testDeleteWithWhere() throws ParseException {
        ASTNode ast = this.parse("DELETE FROM src WHERE key IS NOT NULL AND src.value < 0");
        Assert.assertEquals((String)"AST doesn't match", (Object)"(tok_delete_from (tok_tabname src) (tok_where (and (tok_function tok_isnotnull (tok_table_or_col key)) (< (. (tok_table_or_col src) value) 0))))", (Object)ast.toStringTree());
    }

    @Test
    public void testUpdateNoWhereSingleSet() throws ParseException {
        ASTNode ast = this.parse("UPDATE src set key = 3");
        Assert.assertEquals((String)"AST doesn't match", (Object)"(tok_update_table (tok_tabname src) (tok_set_columns_clause (= (tok_table_or_col key) 3)))", (Object)ast.toStringTree());
    }

    @Test
    public void testUpdateNoWhereMultiSet() throws ParseException {
        ASTNode ast = this.parse("UPDATE src set key = 3, value = 8");
        Assert.assertEquals((String)"AST doesn't match", (Object)"(tok_update_table (tok_tabname src) (tok_set_columns_clause (= (tok_table_or_col key) 3) (= (tok_table_or_col value) 8)))", (Object)ast.toStringTree());
    }

    @Test
    public void testUpdateWithWhereSingleSet() throws ParseException {
        ASTNode ast = this.parse("UPDATE src SET key = 3 WHERE value IS NULL");
        Assert.assertEquals((String)"AST doesn't match", (Object)"(tok_update_table (tok_tabname src) (tok_set_columns_clause (= (tok_table_or_col key) 3)) (tok_where (tok_function tok_isnull (tok_table_or_col value))))", (Object)ast.toStringTree());
    }

    @Test
    public void testUpdateWithWhereSingleSetExpr() throws ParseException {
        ASTNode ast = this.parse("UPDATE src SET key = -3+(5*9)%8, val = cast(6.1 + c as INT), d = d - 1 WHERE value IS NULL");
        Assert.assertEquals((String)"AST doesn't match", (Object)"(tok_update_table (tok_tabname src) (tok_set_columns_clause (= (tok_table_or_col key) (+ (- 3) (% (* 5 9) 8))) (= (tok_table_or_col val) (tok_function tok_int (+ 6.1 (tok_table_or_col c)))) (= (tok_table_or_col d) (- (tok_table_or_col d) 1))) (tok_where (tok_function tok_isnull (tok_table_or_col value))))", (Object)ast.toStringTree());
    }

    @Test
    public void testUpdateWithWhereMultiSet() throws ParseException {
        ASTNode ast = this.parse("UPDATE src SET key = 3, value = 8 WHERE VALUE = 1230997");
        Assert.assertEquals((String)"AST doesn't match", (Object)"(tok_update_table (tok_tabname src) (tok_set_columns_clause (= (tok_table_or_col key) 3) (= (tok_table_or_col value) 8)) (tok_where (= (tok_table_or_col value) 1230997)))", (Object)ast.toStringTree());
    }

    @Test
    public void testStandardInsertIntoTable() throws ParseException {
        ASTNode ast = this.parse("INSERT into TABLE page_view SELECT pvs.viewTime, pvs.userid from page_view_stg pvs where pvs.userid is null");
        Assert.assertEquals((String)"AST doesn't match", (Object)"(tok_query (tok_from (tok_tabref (tok_tabname page_view_stg) pvs)) (tok_insert (tok_insert_into (tok_tab (tok_tabname page_view))) (tok_select (tok_selexpr (. (tok_table_or_col pvs) viewtime)) (tok_selexpr (. (tok_table_or_col pvs) userid))) (tok_where (tok_function tok_isnull (. (tok_table_or_col pvs) userid)))))", (Object)ast.toStringTree());
    }

    @Test
    public void testSelectStarFromAnonymousVirtTable1Row() throws ParseException {
        try {
            this.parse("select * from `values` (3,4)");
            Assert.assertFalse((String)"Expected ParseException", (boolean)true);
        }
        catch (ParseException ex) {
            Assert.assertEquals((String)"Failure didn't match.", (Object)"line 1:23 missing EOF at '(' near 'values'", (Object)ex.getMessage());
        }
    }

    @Test
    public void testSelectStarFromVirtTable1Row() throws ParseException {
        ASTNode ast = this.parse("select * from (values (3,4)) as vc(a,b)");
        Assert.assertEquals((String)"AST doesn't match", (Object)"(tok_query (tok_from (tok_virtual_table (tok_virtual_tabref (tok_tabname vc) (tok_col_name a b)) (tok_values_table (tok_value_row 3 4)))) (tok_insert (tok_destination (tok_dir tok_tmp_file)) (tok_select (tok_selexpr tok_allcolref))))", (Object)ast.toStringTree());
    }

    @Test
    public void testSelectStarFromVirtTable2Row() throws ParseException {
        ASTNode ast = this.parse("select * from (values (1,2),(3,4)) as vc(a,b)");
        Assert.assertEquals((String)"AST doesn't match", (Object)"(tok_query (tok_from (tok_virtual_table (tok_virtual_tabref (tok_tabname vc) (tok_col_name a b)) (tok_values_table (tok_value_row 1 2) (tok_value_row 3 4)))) (tok_insert (tok_destination (tok_dir tok_tmp_file)) (tok_select (tok_selexpr tok_allcolref))))", (Object)ast.toStringTree());
    }

    @Test
    public void testSelectStarFromVirtTable2RowNamedProjections() throws ParseException {
        ASTNode ast = this.parse("select a as c, b as d from (values (1,2),(3,4)) as vc(a,b)");
        Assert.assertEquals((String)"AST doesn't match", (Object)"(tok_query (tok_from (tok_virtual_table (tok_virtual_tabref (tok_tabname vc) (tok_col_name a b)) (tok_values_table (tok_value_row 1 2) (tok_value_row 3 4)))) (tok_insert (tok_destination (tok_dir tok_tmp_file)) (tok_select (tok_selexpr (tok_table_or_col a) c) (tok_selexpr (tok_table_or_col b) d))))", (Object)ast.toStringTree());
    }

    @Test
    public void testInsertIntoTableAsSelectFromNamedVirtTable() throws ParseException {
        ASTNode ast = this.parse("insert into page_view select a,b as c from (values (1,2),(3,4)) as vc(a,b) where b = 9");
        Assert.assertEquals((String)"AST doesn't match", (Object)"(tok_query (tok_from (tok_virtual_table (tok_virtual_tabref (tok_tabname vc) (tok_col_name a b)) (tok_values_table (tok_value_row 1 2) (tok_value_row 3 4)))) (tok_insert (tok_insert_into (tok_tab (tok_tabname page_view))) (tok_select (tok_selexpr (tok_table_or_col a)) (tok_selexpr (tok_table_or_col b) c)) (tok_where (= (tok_table_or_col b) 9))))", (Object)ast.toStringTree());
    }

    @Test
    public void testInsertIntoTableAsSelectFromNamedVirtTableNamedCol() throws ParseException {
        ASTNode ast = this.parse("insert into page_view(c1,c2) select a,b as c from (values (1,2),(3,4)) as vc(a,b) where b = 9");
        Assert.assertEquals((String)"AST doesn't match", (Object)"(tok_query (tok_from (tok_virtual_table (tok_virtual_tabref (tok_tabname vc) (tok_col_name a b)) (tok_values_table (tok_value_row 1 2) (tok_value_row 3 4)))) (tok_insert (tok_insert_into (tok_tab (tok_tabname page_view)) (tok_tabcolname c1 c2)) (tok_select (tok_selexpr (tok_table_or_col a)) (tok_selexpr (tok_table_or_col b) c)) (tok_where (= (tok_table_or_col b) 9))))", (Object)ast.toStringTree());
    }

    @Test
    public void testInsertIntoTableFromAnonymousTable1Row() throws ParseException {
        ASTNode ast = this.parse("insert into page_view values(1,2)");
        Assert.assertEquals((String)"AST doesn't match", (Object)"(tok_query (tok_from (tok_virtual_table (tok_virtual_tabref tok_anonymous) (tok_values_table (tok_value_row 1 2)))) (tok_insert (tok_insert_into (tok_tab (tok_tabname page_view))) (tok_select (tok_selexpr tok_allcolref))))", (Object)ast.toStringTree());
    }

    @Test
    public void testInsertIntoTableFromAnonymousTable1RowNamedCol() throws ParseException {
        ASTNode ast = this.parse("insert into page_view(a,b) values(1,2)");
        Assert.assertEquals((String)"AST doesn't match", (Object)"(tok_query (tok_from (tok_virtual_table (tok_virtual_tabref tok_anonymous) (tok_values_table (tok_value_row 1 2)))) (tok_insert (tok_insert_into (tok_tab (tok_tabname page_view)) (tok_tabcolname a b)) (tok_select (tok_selexpr tok_allcolref))))", (Object)ast.toStringTree());
    }

    @Test
    public void testInsertIntoTableFromAnonymousTable() throws ParseException {
        ASTNode ast = this.parse("insert into table page_view values(-1,2),(3,+4)");
        Assert.assertEquals((String)"AST doesn't match", (Object)"(tok_query (tok_from (tok_virtual_table (tok_virtual_tabref tok_anonymous) (tok_values_table (tok_value_row (- 1) 2) (tok_value_row 3 (+ 4))))) (tok_insert (tok_insert_into (tok_tab (tok_tabname page_view))) (tok_select (tok_selexpr tok_allcolref))))", (Object)ast.toStringTree());
        ast = this.parse("insert into page_view values(-1,2),(3,+4)");
        Assert.assertEquals((String)"AST doesn't match", (Object)"(tok_query (tok_from (tok_virtual_table (tok_virtual_tabref tok_anonymous) (tok_values_table (tok_value_row (- 1) 2) (tok_value_row 3 (+ 4))))) (tok_insert (tok_insert_into (tok_tab (tok_tabname page_view))) (tok_select (tok_selexpr tok_allcolref))))", (Object)ast.toStringTree());
    }

    @Test
    public void testMultiInsert() throws ParseException {
        ASTNode ast = this.parse("from S insert into T1 select a, b insert into T2 select c, d");
        Assert.assertEquals((String)"AST doesn't match", (Object)"(tok_query (tok_from (tok_tabref (tok_tabname s))) (tok_insert (tok_insert_into (tok_tab (tok_tabname t1))) (tok_select (tok_selexpr (tok_table_or_col a)) (tok_selexpr (tok_table_or_col b)))) (tok_insert (tok_insert_into (tok_tab (tok_tabname t2))) (tok_select (tok_selexpr (tok_table_or_col c)) (tok_selexpr (tok_table_or_col d)))))", (Object)ast.toStringTree());
    }
}

