/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.io.parquet;

import java.sql.Date;
import junit.framework.Assert;
import org.apache.hadoop.hive.common.type.HiveChar;
import org.apache.hadoop.hive.common.type.HiveVarchar;
import org.apache.hadoop.hive.ql.io.parquet.read.ParquetFilterPredicateConverter;
import org.apache.hadoop.hive.ql.io.sarg.PredicateLeaf;
import org.apache.hadoop.hive.ql.io.sarg.SearchArgument;
import org.apache.hadoop.hive.ql.io.sarg.SearchArgumentFactory;
import org.apache.hadoop.hive.serde2.io.HiveDecimalWritable;
import org.apache.parquet.filter2.predicate.FilterPredicate;
import org.apache.parquet.schema.MessageType;
import org.apache.parquet.schema.MessageTypeParser;
import org.junit.Test;

public class TestParquetRecordReaderWrapper {
    private static SearchArgument.TruthValue[] values(SearchArgument.TruthValue ... vals) {
        return vals;
    }

    @Test
    public void testBuilder() throws Exception {
        SearchArgument sarg = SearchArgumentFactory.newBuilder().startNot().startOr().isNull("x", PredicateLeaf.Type.LONG).between("y", PredicateLeaf.Type.LONG, (Object)10L, (Object)20L).in("z", PredicateLeaf.Type.LONG, new Object[]{1L, 2L, 3L}).nullSafeEquals("a", PredicateLeaf.Type.STRING, (Object)"stinger").end().end().build();
        MessageType schema = MessageTypeParser.parseMessageType((String)"message test { optional int32 x; required int32 y; required int32 z; optional binary a;}");
        FilterPredicate p = ParquetFilterPredicateConverter.toFilterPredicate((SearchArgument)sarg, (MessageType)schema);
        String expected = "and(and(and(not(eq(x, null)), not(and(lt(y, 20), not(lteq(y, 10))))), not(or(or(eq(z, 1), eq(z, 2)), eq(z, 3)))), not(eq(a, Binary{\"stinger\"})))";
        Assert.assertEquals((String)expected, (String)p.toString());
    }

    @Test
    public void testBuilderComplexTypes() throws Exception {
        SearchArgument sarg = SearchArgumentFactory.newBuilder().startAnd().lessThan("x", PredicateLeaf.Type.DATE, (Object)Date.valueOf("1970-1-11")).lessThanEquals("y", PredicateLeaf.Type.STRING, (Object)new HiveChar("hi", 10).toString()).equals("z", PredicateLeaf.Type.DECIMAL, (Object)new HiveDecimalWritable("1.0")).end().build();
        MessageType schema = MessageTypeParser.parseMessageType((String)"message test { required int32 x; required binary y; required binary z;}");
        Assert.assertEquals((String)"lteq(y, Binary{\"hi        \"})", (String)ParquetFilterPredicateConverter.toFilterPredicate((SearchArgument)sarg, (MessageType)schema).toString());
        sarg = SearchArgumentFactory.newBuilder().startNot().startOr().isNull("x", PredicateLeaf.Type.LONG).between("y", PredicateLeaf.Type.DECIMAL, (Object)new HiveDecimalWritable("10"), (Object)new HiveDecimalWritable("20.0")).in("z", PredicateLeaf.Type.LONG, new Object[]{1L, 2L, 3L}).nullSafeEquals("a", PredicateLeaf.Type.STRING, (Object)new HiveVarchar("stinger", 100).toString()).end().end().build();
        schema = MessageTypeParser.parseMessageType((String)"message test { optional int32 x; required binary y; required int32 z; optional binary a;}");
        FilterPredicate p = ParquetFilterPredicateConverter.toFilterPredicate((SearchArgument)sarg, (MessageType)schema);
        String expected = "and(and(not(eq(x, null)), not(or(or(eq(z, 1), eq(z, 2)), eq(z, 3)))), not(eq(a, Binary{\"stinger\"})))";
        Assert.assertEquals((String)expected, (String)p.toString());
    }

    @Test
    public void testBuilderComplexTypes2() throws Exception {
        SearchArgument sarg = SearchArgumentFactory.newBuilder().startAnd().lessThan("x", PredicateLeaf.Type.DATE, (Object)Date.valueOf("2005-3-12")).lessThanEquals("y", PredicateLeaf.Type.STRING, (Object)new HiveChar("hi", 10).toString()).equals("z", PredicateLeaf.Type.DECIMAL, (Object)new HiveDecimalWritable("1.0")).end().build();
        MessageType schema = MessageTypeParser.parseMessageType((String)"message test { required int32 x; required binary y; required binary z;}");
        Assert.assertEquals((String)"lteq(y, Binary{\"hi        \"})", (String)ParquetFilterPredicateConverter.toFilterPredicate((SearchArgument)sarg, (MessageType)schema).toString());
        sarg = SearchArgumentFactory.newBuilder().startNot().startOr().isNull("x", PredicateLeaf.Type.LONG).between("y", PredicateLeaf.Type.DECIMAL, (Object)new HiveDecimalWritable("10"), (Object)new HiveDecimalWritable("20.0")).in("z", PredicateLeaf.Type.LONG, new Object[]{1L, 2L, 3L}).nullSafeEquals("a", PredicateLeaf.Type.STRING, (Object)new HiveVarchar("stinger", 100).toString()).end().end().build();
        schema = MessageTypeParser.parseMessageType((String)"message test { optional int32 x; required binary y; required int32 z; optional binary a;}");
        FilterPredicate p = ParquetFilterPredicateConverter.toFilterPredicate((SearchArgument)sarg, (MessageType)schema);
        String expected = "and(and(not(eq(x, null)), not(or(or(eq(z, 1), eq(z, 2)), eq(z, 3)))), not(eq(a, Binary{\"stinger\"})))";
        Assert.assertEquals((String)expected, (String)p.toString());
    }

    @Test
    public void testBuilderFloat() throws Exception {
        SearchArgument sarg = SearchArgumentFactory.newBuilder().startAnd().lessThan("x", PredicateLeaf.Type.LONG, (Object)22L).lessThan("x1", PredicateLeaf.Type.LONG, (Object)22L).lessThanEquals("y", PredicateLeaf.Type.STRING, (Object)new HiveChar("hi", 10).toString()).equals("z", PredicateLeaf.Type.FLOAT, (Object)new Double(0.22)).equals("z1", PredicateLeaf.Type.FLOAT, (Object)new Double(0.22)).end().build();
        MessageType schema = MessageTypeParser.parseMessageType((String)"message test { required int32 x; required int32 x1; required binary y; required float z; required float z1;}");
        FilterPredicate p = ParquetFilterPredicateConverter.toFilterPredicate((SearchArgument)sarg, (MessageType)schema);
        String expected = "and(and(and(and(lt(x, 22), lt(x1, 22)), lteq(y, Binary{\"hi        \"})), eq(z, 0.22)), eq(z1, 0.22))";
        Assert.assertEquals((String)expected, (String)p.toString());
    }
}

