/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.io.parquet;

import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Properties;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.ql.io.parquet.serde.ArrayWritableObjectInspector;
import org.apache.hadoop.hive.ql.io.parquet.serde.ParquetHiveSerDe;
import org.apache.hadoop.hive.ql.io.parquet.write.DataWritableWriter;
import org.apache.hadoop.hive.serde2.Deserializer;
import org.apache.hadoop.hive.serde2.SerDeException;
import org.apache.hadoop.hive.serde2.SerDeUtils;
import org.apache.hadoop.hive.serde2.io.ByteWritable;
import org.apache.hadoop.hive.serde2.io.DoubleWritable;
import org.apache.hadoop.hive.serde2.io.ParquetHiveRecord;
import org.apache.hadoop.hive.serde2.io.ShortWritable;
import org.apache.hadoop.hive.serde2.objectinspector.StructObjectInspector;
import org.apache.hadoop.hive.serde2.typeinfo.StructTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfoFactory;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfoUtils;
import org.apache.hadoop.io.ArrayWritable;
import org.apache.hadoop.io.BooleanWritable;
import org.apache.hadoop.io.BytesWritable;
import org.apache.hadoop.io.FloatWritable;
import org.apache.hadoop.io.IntWritable;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.Writable;
import org.apache.parquet.io.api.Binary;
import org.apache.parquet.io.api.RecordConsumer;
import org.apache.parquet.schema.GroupType;
import org.apache.parquet.schema.MessageType;
import org.apache.parquet.schema.MessageTypeParser;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.InOrder;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;

public class TestDataWritableWriter {
    @Mock
    private RecordConsumer mockRecordConsumer;
    private InOrder inOrder;

    @Before
    public void initMocks() {
        MockitoAnnotations.initMocks((Object)this);
        this.inOrder = Mockito.inOrder((Object[])new Object[]{this.mockRecordConsumer});
    }

    private void startMessage() {
        ((RecordConsumer)this.inOrder.verify((Object)this.mockRecordConsumer)).startMessage();
    }

    private void endMessage() {
        ((RecordConsumer)this.inOrder.verify((Object)this.mockRecordConsumer)).endMessage();
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.mockRecordConsumer});
    }

    private void startField(String name, int index) {
        ((RecordConsumer)this.inOrder.verify((Object)this.mockRecordConsumer)).startField(name, index);
    }

    private void endField(String name, int index) {
        ((RecordConsumer)this.inOrder.verify((Object)this.mockRecordConsumer)).endField(name, index);
    }

    private void addInteger(int value) {
        ((RecordConsumer)this.inOrder.verify((Object)this.mockRecordConsumer)).addInteger(value);
    }

    private void addLong(int value) {
        ((RecordConsumer)this.inOrder.verify((Object)this.mockRecordConsumer)).addLong((long)value);
    }

    private void addFloat(float value) {
        ((RecordConsumer)this.inOrder.verify((Object)this.mockRecordConsumer)).addFloat(value);
    }

    private void addDouble(double value) {
        ((RecordConsumer)this.inOrder.verify((Object)this.mockRecordConsumer)).addDouble(value);
    }

    private void addBoolean(boolean value) {
        ((RecordConsumer)this.inOrder.verify((Object)this.mockRecordConsumer)).addBoolean(value);
    }

    private void addString(String value) {
        ((RecordConsumer)this.inOrder.verify((Object)this.mockRecordConsumer)).addBinary(Binary.fromString((String)value));
    }

    private void startGroup() {
        ((RecordConsumer)this.inOrder.verify((Object)this.mockRecordConsumer)).startGroup();
    }

    private void endGroup() {
        ((RecordConsumer)this.inOrder.verify((Object)this.mockRecordConsumer)).endGroup();
    }

    private Writable createNull() {
        return null;
    }

    private ByteWritable createTinyInt(byte value) {
        return new ByteWritable(value);
    }

    private ShortWritable createSmallInt(short value) {
        return new ShortWritable(value);
    }

    private LongWritable createBigInt(long value) {
        return new LongWritable(value);
    }

    private IntWritable createInt(int value) {
        return new IntWritable(value);
    }

    private FloatWritable createFloat(float value) {
        return new FloatWritable(value);
    }

    private DoubleWritable createDouble(double value) {
        return new DoubleWritable(value);
    }

    private BooleanWritable createBoolean(boolean value) {
        return new BooleanWritable(value);
    }

    private BytesWritable createString(String value) throws UnsupportedEncodingException {
        return new BytesWritable(value.getBytes("UTF-8"));
    }

    private ArrayWritable createGroup(Writable ... values) {
        return new ArrayWritable(Writable.class, values);
    }

    private ArrayWritable createArray(Writable ... values) {
        return new ArrayWritable(Writable.class, this.createGroup(values).get());
    }

    private List<String> createHiveColumnsFrom(String columnNamesStr) {
        List<Object> columnNames = columnNamesStr.length() == 0 ? new ArrayList() : Arrays.asList(columnNamesStr.split(","));
        return columnNames;
    }

    private List<TypeInfo> createHiveTypeInfoFrom(String columnsTypeStr) {
        ArrayList<TypeInfo> columnTypes = columnsTypeStr.length() == 0 ? new ArrayList<TypeInfo>() : TypeInfoUtils.getTypeInfosFromTypeString((String)columnsTypeStr);
        return columnTypes;
    }

    private ArrayWritableObjectInspector getObjectInspector(String columnNames, String columnTypes) {
        List<TypeInfo> columnTypeList = this.createHiveTypeInfoFrom(columnTypes);
        List<String> columnNameList = this.createHiveColumnsFrom(columnNames);
        StructTypeInfo rowTypeInfo = (StructTypeInfo)TypeInfoFactory.getStructTypeInfo(columnNameList, columnTypeList);
        return new ArrayWritableObjectInspector(rowTypeInfo);
    }

    private ParquetHiveRecord getParquetWritable(String columnNames, String columnTypes, ArrayWritable record) throws SerDeException {
        Properties recordProperties = new Properties();
        recordProperties.setProperty("columns", columnNames);
        recordProperties.setProperty("columns.types", columnTypes);
        ParquetHiveSerDe serDe = new ParquetHiveSerDe();
        SerDeUtils.initializeSerDe((Deserializer)serDe, (Configuration)new Configuration(), (Properties)recordProperties, null);
        return new ParquetHiveRecord(serDe.deserialize((Writable)record), (StructObjectInspector)this.getObjectInspector(columnNames, columnTypes));
    }

    private void writeParquetRecord(String schema, ParquetHiveRecord record) throws SerDeException {
        MessageType fileSchema = MessageTypeParser.parseMessageType((String)schema);
        DataWritableWriter hiveParquetWriter = new DataWritableWriter(this.mockRecordConsumer, (GroupType)fileSchema);
        hiveParquetWriter.write(record);
    }

    @Test
    public void testSimpleType() throws Exception {
        String columnNames = "int,double,boolean,float,string,tinyint,smallint,bigint";
        String columnTypes = "int,double,boolean,float,string,tinyint,smallint,bigint";
        String fileSchema = "message hive_schema {\n  optional int32 int;\n  optional double double;\n  optional boolean boolean;\n  optional float float;\n  optional binary string (UTF8);\n  optional int32 tinyint;\n  optional int32 smallint;\n  optional int64 bigint;\n}\n";
        ArrayWritable hiveRecord = this.createGroup(new Writable[]{this.createInt(1), this.createDouble(1.0), this.createBoolean(true), this.createFloat(1.0f), this.createString("one"), this.createTinyInt((byte)1), this.createSmallInt((short)1), this.createBigInt(1L)});
        this.writeParquetRecord(fileSchema, this.getParquetWritable(columnNames, columnTypes, hiveRecord));
        this.startMessage();
        this.startField("int", 0);
        this.addInteger(1);
        this.endField("int", 0);
        this.startField("double", 1);
        this.addDouble(1.0);
        this.endField("double", 1);
        this.startField("boolean", 2);
        this.addBoolean(true);
        this.endField("boolean", 2);
        this.startField("float", 3);
        this.addFloat(1.0f);
        this.endField("float", 3);
        this.startField("string", 4);
        this.addString("one");
        this.endField("string", 4);
        this.startField("tinyint", 5);
        this.addInteger(1);
        this.endField("tinyint", 5);
        this.startField("smallint", 6);
        this.addInteger(1);
        this.endField("smallint", 6);
        this.startField("bigint", 7);
        this.addLong(1);
        this.endField("bigint", 7);
        this.endMessage();
    }

    @Test
    public void testStructType() throws Exception {
        String columnNames = "structCol";
        String columnTypes = "struct<a:int,b:double,c:boolean>";
        String fileSchema = "message hive_schema {\n  optional group structCol {\n    optional int32 a;\n    optional double b;\n    optional boolean c;\n  }\n}\n";
        ArrayWritable hiveRecord = this.createGroup(new Writable[]{this.createGroup(new Writable[]{this.createInt(1), this.createDouble(1.0), this.createBoolean(true)})});
        this.writeParquetRecord(fileSchema, this.getParquetWritable(columnNames, columnTypes, hiveRecord));
        this.startMessage();
        this.startField("structCol", 0);
        this.startGroup();
        this.startField("a", 0);
        this.addInteger(1);
        this.endField("a", 0);
        this.startField("b", 1);
        this.addDouble(1.0);
        this.endField("b", 1);
        this.startField("c", 2);
        this.addBoolean(true);
        this.endField("c", 2);
        this.endGroup();
        this.endField("structCol", 0);
        this.endMessage();
    }

    @Test
    public void testArrayType() throws Exception {
        String columnNames = "arrayCol";
        String columnTypes = "array<int>";
        String fileSchema = "message hive_schema {\n  optional group arrayCol (LIST) {\n    repeated group array {\n      optional int32 array_element;\n    }\n  }\n}\n";
        ArrayWritable hiveRecord = this.createGroup(new Writable[]{this.createArray(new Writable[]{this.createInt(1), this.createNull(), this.createInt(2)})});
        this.writeParquetRecord(fileSchema, this.getParquetWritable(columnNames, columnTypes, hiveRecord));
        this.startMessage();
        this.startField("arrayCol", 0);
        this.startGroup();
        this.startField("array", 0);
        this.startGroup();
        this.startField("array_element", 0);
        this.addInteger(1);
        this.endField("array_element", 0);
        this.endGroup();
        this.startGroup();
        this.endGroup();
        this.startGroup();
        this.startField("array_element", 0);
        this.addInteger(2);
        this.endField("array_element", 0);
        this.endGroup();
        this.endField("array", 0);
        this.endGroup();
        this.endField("arrayCol", 0);
        this.endMessage();
    }

    @Test
    public void testMapType() throws Exception {
        String columnNames = "mapCol";
        String columnTypes = "map<string,int>";
        String fileSchema = "message hive_schema {\n  optional group mapCol (MAP) {\n    repeated group map (MAP_KEY_VALUE) {\n      required binary key;\n      optional int32 value;\n    }\n  }\n}\n";
        ArrayWritable hiveRecord = this.createGroup(new Writable[]{this.createGroup(new Writable[]{this.createArray(new Writable[]{this.createString("key1"), this.createInt(1)}), this.createArray(new Writable[]{this.createString("key2"), this.createInt(2)}), this.createArray(new Writable[]{this.createString("key3"), this.createNull()})})});
        this.writeParquetRecord(fileSchema, this.getParquetWritable(columnNames, columnTypes, hiveRecord));
        this.startMessage();
        this.startField("mapCol", 0);
        this.startGroup();
        this.startField("map", 0);
        this.startGroup();
        this.startField("key", 0);
        this.addString("key1");
        this.endField("key", 0);
        this.startField("value", 1);
        this.addInteger(1);
        this.endField("value", 1);
        this.endGroup();
        this.startGroup();
        this.startField("key", 0);
        this.addString("key2");
        this.endField("key", 0);
        this.startField("value", 1);
        this.addInteger(2);
        this.endField("value", 1);
        this.endGroup();
        this.startGroup();
        this.startField("key", 0);
        this.addString("key3");
        this.endField("key", 0);
        this.endGroup();
        this.endField("map", 0);
        this.endGroup();
        this.endField("mapCol", 0);
        this.endMessage();
    }

    @Test
    public void testArrayOfArrays() throws Exception {
        String columnNames = "array_of_arrays";
        String columnTypes = "array<array<int>>";
        String fileSchema = "message hive_schema {\n  optional group array_of_arrays (LIST) {\n    repeated group array {\n      optional group array_element (LIST) {\n        repeated group array {\n          optional int32 array_element;\n        }\n      }\n    }\n  }\n}\n";
        ArrayWritable hiveRecord = this.createGroup(new Writable[]{this.createArray(new Writable[]{this.createArray(new Writable[]{this.createInt(1), this.createInt(2)})})});
        this.writeParquetRecord(fileSchema, this.getParquetWritable(columnNames, columnTypes, hiveRecord));
        this.startMessage();
        this.startField("array_of_arrays", 0);
        this.startGroup();
        this.startField("array", 0);
        this.startGroup();
        this.startField("array_element", 0);
        this.startGroup();
        this.startField("array", 0);
        this.startGroup();
        this.startField("array_element", 0);
        this.addInteger(1);
        this.endField("array_element", 0);
        this.endGroup();
        this.startGroup();
        this.startField("array_element", 0);
        this.addInteger(2);
        this.endField("array_element", 0);
        this.endGroup();
        this.endField("array", 0);
        this.endGroup();
        this.endField("array_element", 0);
        this.endGroup();
        this.endField("array", 0);
        this.endGroup();
        this.endField("array_of_arrays", 0);
        this.endMessage();
    }

    @Test
    public void testExpectedStructTypeOnRecord() throws Exception {
        String columnNames = "structCol";
        String columnTypes = "int";
        ArrayWritable hiveRecord = this.createGroup(new Writable[]{this.createInt(1)});
        String fileSchema = "message hive_schema {\n  optional group structCol {\n      optional int32 int;\n    }\n}\n";
        try {
            this.writeParquetRecord(fileSchema, this.getParquetWritable(columnNames, columnTypes, hiveRecord));
            Assert.fail();
        }
        catch (RuntimeException e) {
            Assert.assertEquals((Object)"Parquet record is malformed: Invalid data type: expected STRUCT type, but found: PRIMITIVE", (Object)e.getMessage());
        }
    }

    @Test
    public void testExpectedArrayTypeOnRecord() throws Exception {
        String columnNames = "arrayCol";
        String columnTypes = "int";
        ArrayWritable hiveRecord = this.createGroup(new Writable[]{this.createInt(1)});
        String fileSchema = "message hive_schema {\n  optional group arrayCol (LIST) {\n    repeated group bag {\n      optional int32 array_element;\n    }\n  }\n}\n";
        try {
            this.writeParquetRecord(fileSchema, this.getParquetWritable(columnNames, columnTypes, hiveRecord));
            Assert.fail();
        }
        catch (RuntimeException e) {
            Assert.assertEquals((Object)"Parquet record is malformed: Invalid data type: expected LIST type, but found: PRIMITIVE", (Object)e.getMessage());
        }
    }

    @Test
    public void testExpectedMapTypeOnRecord() throws Exception {
        String columnNames = "mapCol";
        String columnTypes = "int";
        ArrayWritable hiveRecord = this.createGroup(new Writable[]{this.createInt(1)});
        String fileSchema = "message hive_schema {\n  optional group mapCol (MAP) {\n    repeated group map (MAP_KEY_VALUE) {\n      required binary key;\n      optional int32 value;\n    }\n  }\n}\n";
        try {
            this.writeParquetRecord(fileSchema, this.getParquetWritable(columnNames, columnTypes, hiveRecord));
            Assert.fail();
        }
        catch (RuntimeException e) {
            Assert.assertEquals((Object)"Parquet record is malformed: Invalid data type: expected MAP type, but found: PRIMITIVE", (Object)e.getMessage());
        }
    }
}

