/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.io.orc;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.sql.Timestamp;
import java.util.ArrayList;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.PositionedReadable;
import org.apache.hadoop.fs.Seekable;
import org.apache.hadoop.hive.common.io.DiskRangeList;
import org.apache.hadoop.hive.common.type.HiveDecimal;
import org.apache.hadoop.hive.ql.io.orc.OrcFile;
import org.apache.hadoop.hive.ql.io.orc.Reader;
import org.apache.hadoop.hive.ql.io.orc.RecordReaderImpl;
import org.apache.hadoop.hive.ql.io.orc.RecordReaderUtils;
import org.apache.hadoop.hive.ql.io.sarg.PredicateLeaf;
import org.apache.hadoop.hive.ql.io.sarg.SearchArgument;
import org.apache.hadoop.hive.ql.io.sarg.TestSearchArgumentImpl;
import org.apache.hadoop.hive.serde2.io.DateWritable;
import org.apache.hadoop.hive.serde2.io.HiveDecimalWritable;
import org.apache.hadoop.io.DataOutputBuffer;
import org.apache.orc.BloomFilterIO;
import org.apache.orc.ColumnStatistics;
import org.apache.orc.OrcProto;
import org.apache.orc.impl.ColumnStatisticsImpl;
import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.MockSettings;
import org.mockito.Mockito;

public class TestRecordReaderImpl {
    private final MockSettings settings = Mockito.withSettings().verboseLogging();

    @Test
    public void testMaxLengthToReader() throws Exception {
        Configuration conf = new Configuration();
        OrcProto.Type rowType = OrcProto.Type.newBuilder().setKind(OrcProto.Type.Kind.STRUCT).build();
        OrcProto.Footer footer = OrcProto.Footer.newBuilder().setHeaderLength(0L).setContentLength(0L).setNumberOfRows(0L).setRowIndexStride(0).addTypes(rowType).build();
        OrcProto.PostScript ps = OrcProto.PostScript.newBuilder().setCompression(OrcProto.CompressionKind.NONE).setFooterLength((long)footer.getSerializedSize()).setMagic("ORC").addVersion(0).addVersion(11).build();
        DataOutputBuffer buffer = new DataOutputBuffer();
        footer.writeTo((OutputStream)buffer);
        ps.writeTo((OutputStream)buffer);
        buffer.write(ps.getSerializedSize());
        FileSystem fs = (FileSystem)Mockito.mock(FileSystem.class, (MockSettings)this.settings);
        FSDataInputStream file = new FSDataInputStream((InputStream)new BufferInStream(buffer.getData(), buffer.getLength()));
        Path p = new Path("/dir/file.orc");
        Mockito.when((Object)fs.open(p)).thenReturn((Object)file);
        OrcFile.ReaderOptions options = OrcFile.readerOptions((Configuration)conf);
        options.filesystem(fs);
        options.maxLength((long)buffer.getLength());
        Mockito.when((Object)fs.getFileStatus(p)).thenReturn((Object)new FileStatus(10L, false, 3, 3000L, 0L, p));
        Reader reader = OrcFile.createReader((Path)p, (OrcFile.ReaderOptions)options);
    }

    @Test
    public void testCompareToRangeInt() throws Exception {
        junit.framework.Assert.assertEquals((Object)RecordReaderImpl.Location.BEFORE, (Object)RecordReaderImpl.compareToRange((Comparable)Long.valueOf(19L), (Object)20L, (Object)40L));
        junit.framework.Assert.assertEquals((Object)RecordReaderImpl.Location.AFTER, (Object)RecordReaderImpl.compareToRange((Comparable)Long.valueOf(41L), (Object)20L, (Object)40L));
        junit.framework.Assert.assertEquals((Object)RecordReaderImpl.Location.MIN, (Object)RecordReaderImpl.compareToRange((Comparable)Long.valueOf(20L), (Object)20L, (Object)40L));
        junit.framework.Assert.assertEquals((Object)RecordReaderImpl.Location.MIDDLE, (Object)RecordReaderImpl.compareToRange((Comparable)Long.valueOf(21L), (Object)20L, (Object)40L));
        junit.framework.Assert.assertEquals((Object)RecordReaderImpl.Location.MAX, (Object)RecordReaderImpl.compareToRange((Comparable)Long.valueOf(40L), (Object)20L, (Object)40L));
        junit.framework.Assert.assertEquals((Object)RecordReaderImpl.Location.BEFORE, (Object)RecordReaderImpl.compareToRange((Comparable)Long.valueOf(0L), (Object)1L, (Object)1L));
        junit.framework.Assert.assertEquals((Object)RecordReaderImpl.Location.MIN, (Object)RecordReaderImpl.compareToRange((Comparable)Long.valueOf(1L), (Object)1L, (Object)1L));
        junit.framework.Assert.assertEquals((Object)RecordReaderImpl.Location.AFTER, (Object)RecordReaderImpl.compareToRange((Comparable)Long.valueOf(2L), (Object)1L, (Object)1L));
    }

    @Test
    public void testCompareToRangeString() throws Exception {
        junit.framework.Assert.assertEquals((Object)RecordReaderImpl.Location.BEFORE, (Object)RecordReaderImpl.compareToRange((Comparable)((Object)"a"), (Object)"b", (Object)"c"));
        junit.framework.Assert.assertEquals((Object)RecordReaderImpl.Location.AFTER, (Object)RecordReaderImpl.compareToRange((Comparable)((Object)"d"), (Object)"b", (Object)"c"));
        junit.framework.Assert.assertEquals((Object)RecordReaderImpl.Location.MIN, (Object)RecordReaderImpl.compareToRange((Comparable)((Object)"b"), (Object)"b", (Object)"c"));
        junit.framework.Assert.assertEquals((Object)RecordReaderImpl.Location.MIDDLE, (Object)RecordReaderImpl.compareToRange((Comparable)((Object)"bb"), (Object)"b", (Object)"c"));
        junit.framework.Assert.assertEquals((Object)RecordReaderImpl.Location.MAX, (Object)RecordReaderImpl.compareToRange((Comparable)((Object)"c"), (Object)"b", (Object)"c"));
        junit.framework.Assert.assertEquals((Object)RecordReaderImpl.Location.BEFORE, (Object)RecordReaderImpl.compareToRange((Comparable)((Object)"a"), (Object)"b", (Object)"b"));
        junit.framework.Assert.assertEquals((Object)RecordReaderImpl.Location.MIN, (Object)RecordReaderImpl.compareToRange((Comparable)((Object)"b"), (Object)"b", (Object)"b"));
        junit.framework.Assert.assertEquals((Object)RecordReaderImpl.Location.AFTER, (Object)RecordReaderImpl.compareToRange((Comparable)((Object)"c"), (Object)"b", (Object)"b"));
    }

    @Test
    public void testCompareToCharNeedConvert() throws Exception {
        junit.framework.Assert.assertEquals((Object)RecordReaderImpl.Location.BEFORE, (Object)RecordReaderImpl.compareToRange((Comparable)((Object)"apple"), (Object)"hello", (Object)"world"));
        junit.framework.Assert.assertEquals((Object)RecordReaderImpl.Location.AFTER, (Object)RecordReaderImpl.compareToRange((Comparable)((Object)"zombie"), (Object)"hello", (Object)"world"));
        junit.framework.Assert.assertEquals((Object)RecordReaderImpl.Location.MIN, (Object)RecordReaderImpl.compareToRange((Comparable)((Object)"hello"), (Object)"hello", (Object)"world"));
        junit.framework.Assert.assertEquals((Object)RecordReaderImpl.Location.MIDDLE, (Object)RecordReaderImpl.compareToRange((Comparable)((Object)"pilot"), (Object)"hello", (Object)"world"));
        junit.framework.Assert.assertEquals((Object)RecordReaderImpl.Location.MAX, (Object)RecordReaderImpl.compareToRange((Comparable)((Object)"world"), (Object)"hello", (Object)"world"));
        junit.framework.Assert.assertEquals((Object)RecordReaderImpl.Location.BEFORE, (Object)RecordReaderImpl.compareToRange((Comparable)((Object)"apple"), (Object)"hello", (Object)"hello"));
        junit.framework.Assert.assertEquals((Object)RecordReaderImpl.Location.MIN, (Object)RecordReaderImpl.compareToRange((Comparable)((Object)"hello"), (Object)"hello", (Object)"hello"));
        junit.framework.Assert.assertEquals((Object)RecordReaderImpl.Location.AFTER, (Object)RecordReaderImpl.compareToRange((Comparable)((Object)"zombie"), (Object)"hello", (Object)"hello"));
    }

    @Test
    public void testGetMin() throws Exception {
        junit.framework.Assert.assertEquals((Object)10L, (Object)RecordReaderImpl.getMin((ColumnStatistics)ColumnStatisticsImpl.deserialize((OrcProto.ColumnStatistics)TestRecordReaderImpl.createIntStats(10L, 100L))));
        junit.framework.Assert.assertEquals((Object)10.0, (Object)RecordReaderImpl.getMin((ColumnStatistics)ColumnStatisticsImpl.deserialize((OrcProto.ColumnStatistics)OrcProto.ColumnStatistics.newBuilder().setDoubleStatistics(OrcProto.DoubleStatistics.newBuilder().setMinimum(10.0).setMaximum(100.0).build()).build())));
        junit.framework.Assert.assertEquals(null, (Object)RecordReaderImpl.getMin((ColumnStatistics)ColumnStatisticsImpl.deserialize((OrcProto.ColumnStatistics)OrcProto.ColumnStatistics.newBuilder().setStringStatistics(OrcProto.StringStatistics.newBuilder().build()).build())));
        junit.framework.Assert.assertEquals((Object)"a", (Object)RecordReaderImpl.getMin((ColumnStatistics)ColumnStatisticsImpl.deserialize((OrcProto.ColumnStatistics)OrcProto.ColumnStatistics.newBuilder().setStringStatistics(OrcProto.StringStatistics.newBuilder().setMinimum("a").setMaximum("b").build()).build())));
        junit.framework.Assert.assertEquals((Object)"hello", (Object)RecordReaderImpl.getMin((ColumnStatistics)ColumnStatisticsImpl.deserialize((OrcProto.ColumnStatistics)TestRecordReaderImpl.createStringStats("hello", "world"))));
        junit.framework.Assert.assertEquals((Object)HiveDecimal.create((String)"111.1"), (Object)RecordReaderImpl.getMin((ColumnStatistics)ColumnStatisticsImpl.deserialize((OrcProto.ColumnStatistics)TestRecordReaderImpl.createDecimalStats("111.1", "112.1"))));
    }

    private static OrcProto.ColumnStatistics createIntStats(Long min, Long max) {
        OrcProto.IntegerStatistics.Builder intStats = OrcProto.IntegerStatistics.newBuilder();
        if (min != null) {
            intStats.setMinimum(min.longValue());
        }
        if (max != null) {
            intStats.setMaximum(max.longValue());
        }
        return OrcProto.ColumnStatistics.newBuilder().setIntStatistics(intStats.build()).build();
    }

    private static OrcProto.ColumnStatistics createBooleanStats(int n, int trueCount) {
        OrcProto.BucketStatistics.Builder boolStats = OrcProto.BucketStatistics.newBuilder();
        boolStats.addCount((long)trueCount);
        return OrcProto.ColumnStatistics.newBuilder().setNumberOfValues((long)n).setBucketStatistics(boolStats.build()).build();
    }

    private static OrcProto.ColumnStatistics createIntStats(int min, int max) {
        OrcProto.IntegerStatistics.Builder intStats = OrcProto.IntegerStatistics.newBuilder();
        intStats.setMinimum((long)min);
        intStats.setMaximum((long)max);
        return OrcProto.ColumnStatistics.newBuilder().setIntStatistics(intStats.build()).build();
    }

    private static OrcProto.ColumnStatistics createDoubleStats(double min, double max) {
        OrcProto.DoubleStatistics.Builder dblStats = OrcProto.DoubleStatistics.newBuilder();
        dblStats.setMinimum(min);
        dblStats.setMaximum(max);
        return OrcProto.ColumnStatistics.newBuilder().setDoubleStatistics(dblStats.build()).build();
    }

    private static OrcProto.ColumnStatistics createStringStats(String min, String max, boolean hasNull) {
        OrcProto.StringStatistics.Builder strStats = OrcProto.StringStatistics.newBuilder();
        strStats.setMinimum(min);
        strStats.setMaximum(max);
        return OrcProto.ColumnStatistics.newBuilder().setStringStatistics(strStats.build()).setHasNull(hasNull).build();
    }

    private static OrcProto.ColumnStatistics createStringStats(String min, String max) {
        OrcProto.StringStatistics.Builder strStats = OrcProto.StringStatistics.newBuilder();
        strStats.setMinimum(min);
        strStats.setMaximum(max);
        return OrcProto.ColumnStatistics.newBuilder().setStringStatistics(strStats.build()).build();
    }

    private static OrcProto.ColumnStatistics createDateStats(int min, int max) {
        OrcProto.DateStatistics.Builder dateStats = OrcProto.DateStatistics.newBuilder();
        dateStats.setMinimum(min);
        dateStats.setMaximum(max);
        return OrcProto.ColumnStatistics.newBuilder().setDateStatistics(dateStats.build()).build();
    }

    private static OrcProto.ColumnStatistics createTimestampStats(long min, long max) {
        OrcProto.TimestampStatistics.Builder tsStats = OrcProto.TimestampStatistics.newBuilder();
        tsStats.setMinimum(min);
        tsStats.setMaximum(max);
        return OrcProto.ColumnStatistics.newBuilder().setTimestampStatistics(tsStats.build()).build();
    }

    private static OrcProto.ColumnStatistics createDecimalStats(String min, String max) {
        OrcProto.DecimalStatistics.Builder decStats = OrcProto.DecimalStatistics.newBuilder();
        decStats.setMinimum(min);
        decStats.setMaximum(max);
        return OrcProto.ColumnStatistics.newBuilder().setDecimalStatistics(decStats.build()).build();
    }

    private static OrcProto.ColumnStatistics createDecimalStats(String min, String max, boolean hasNull) {
        OrcProto.DecimalStatistics.Builder decStats = OrcProto.DecimalStatistics.newBuilder();
        decStats.setMinimum(min);
        decStats.setMaximum(max);
        return OrcProto.ColumnStatistics.newBuilder().setDecimalStatistics(decStats.build()).setHasNull(hasNull).build();
    }

    @Test
    public void testGetMax() throws Exception {
        junit.framework.Assert.assertEquals((Object)100L, (Object)RecordReaderImpl.getMax((ColumnStatistics)ColumnStatisticsImpl.deserialize((OrcProto.ColumnStatistics)TestRecordReaderImpl.createIntStats(10L, 100L))));
        junit.framework.Assert.assertEquals((Object)100.0, (Object)RecordReaderImpl.getMax((ColumnStatistics)ColumnStatisticsImpl.deserialize((OrcProto.ColumnStatistics)OrcProto.ColumnStatistics.newBuilder().setDoubleStatistics(OrcProto.DoubleStatistics.newBuilder().setMinimum(10.0).setMaximum(100.0).build()).build())));
        junit.framework.Assert.assertEquals(null, (Object)RecordReaderImpl.getMax((ColumnStatistics)ColumnStatisticsImpl.deserialize((OrcProto.ColumnStatistics)OrcProto.ColumnStatistics.newBuilder().setStringStatistics(OrcProto.StringStatistics.newBuilder().build()).build())));
        junit.framework.Assert.assertEquals((Object)"b", (Object)RecordReaderImpl.getMax((ColumnStatistics)ColumnStatisticsImpl.deserialize((OrcProto.ColumnStatistics)OrcProto.ColumnStatistics.newBuilder().setStringStatistics(OrcProto.StringStatistics.newBuilder().setMinimum("a").setMaximum("b").build()).build())));
        junit.framework.Assert.assertEquals((Object)"world", (Object)RecordReaderImpl.getMax((ColumnStatistics)ColumnStatisticsImpl.deserialize((OrcProto.ColumnStatistics)TestRecordReaderImpl.createStringStats("hello", "world"))));
        junit.framework.Assert.assertEquals((Object)HiveDecimal.create((String)"112.1"), (Object)RecordReaderImpl.getMax((ColumnStatistics)ColumnStatisticsImpl.deserialize((OrcProto.ColumnStatistics)TestRecordReaderImpl.createDecimalStats("111.1", "112.1"))));
    }

    @Test
    public void testPredEvalWithBooleanStats() throws Exception {
        PredicateLeaf pred = TestSearchArgumentImpl.createPredicateLeaf(PredicateLeaf.Operator.NULL_SAFE_EQUALS, PredicateLeaf.Type.BOOLEAN, "x", true, null);
        junit.framework.Assert.assertEquals((Object)SearchArgument.TruthValue.YES_NO, (Object)RecordReaderImpl.evaluatePredicateProto((OrcProto.ColumnStatistics)TestRecordReaderImpl.createBooleanStats(10, 10), (PredicateLeaf)pred, null));
        junit.framework.Assert.assertEquals((Object)SearchArgument.TruthValue.NO, (Object)RecordReaderImpl.evaluatePredicateProto((OrcProto.ColumnStatistics)TestRecordReaderImpl.createBooleanStats(10, 0), (PredicateLeaf)pred, null));
        pred = TestSearchArgumentImpl.createPredicateLeaf(PredicateLeaf.Operator.NULL_SAFE_EQUALS, PredicateLeaf.Type.BOOLEAN, "x", true, null);
        junit.framework.Assert.assertEquals((Object)SearchArgument.TruthValue.YES_NO, (Object)RecordReaderImpl.evaluatePredicateProto((OrcProto.ColumnStatistics)TestRecordReaderImpl.createBooleanStats(10, 10), (PredicateLeaf)pred, null));
        junit.framework.Assert.assertEquals((Object)SearchArgument.TruthValue.NO, (Object)RecordReaderImpl.evaluatePredicateProto((OrcProto.ColumnStatistics)TestRecordReaderImpl.createBooleanStats(10, 0), (PredicateLeaf)pred, null));
        pred = TestSearchArgumentImpl.createPredicateLeaf(PredicateLeaf.Operator.NULL_SAFE_EQUALS, PredicateLeaf.Type.BOOLEAN, "x", false, null);
        junit.framework.Assert.assertEquals((Object)SearchArgument.TruthValue.NO, (Object)RecordReaderImpl.evaluatePredicateProto((OrcProto.ColumnStatistics)TestRecordReaderImpl.createBooleanStats(10, 10), (PredicateLeaf)pred, null));
        junit.framework.Assert.assertEquals((Object)SearchArgument.TruthValue.YES_NO, (Object)RecordReaderImpl.evaluatePredicateProto((OrcProto.ColumnStatistics)TestRecordReaderImpl.createBooleanStats(10, 0), (PredicateLeaf)pred, null));
    }

    @Test
    public void testPredEvalWithIntStats() throws Exception {
        PredicateLeaf pred = TestSearchArgumentImpl.createPredicateLeaf(PredicateLeaf.Operator.NULL_SAFE_EQUALS, PredicateLeaf.Type.LONG, "x", 15L, null);
        junit.framework.Assert.assertEquals((Object)SearchArgument.TruthValue.YES_NO, (Object)RecordReaderImpl.evaluatePredicateProto((OrcProto.ColumnStatistics)TestRecordReaderImpl.createIntStats(10, 100), (PredicateLeaf)pred, null));
        pred = TestSearchArgumentImpl.createPredicateLeaf(PredicateLeaf.Operator.NULL_SAFE_EQUALS, PredicateLeaf.Type.FLOAT, "x", 15.0, null);
        junit.framework.Assert.assertEquals((Object)SearchArgument.TruthValue.YES_NO, (Object)RecordReaderImpl.evaluatePredicateProto((OrcProto.ColumnStatistics)TestRecordReaderImpl.createIntStats(10, 100), (PredicateLeaf)pred, null));
        pred = TestSearchArgumentImpl.createPredicateLeaf(PredicateLeaf.Operator.NULL_SAFE_EQUALS, PredicateLeaf.Type.STRING, "x", "15", null);
        junit.framework.Assert.assertEquals((Object)SearchArgument.TruthValue.NO, (Object)RecordReaderImpl.evaluatePredicateProto((OrcProto.ColumnStatistics)TestRecordReaderImpl.createIntStats(10, 100), (PredicateLeaf)pred, null));
        pred = TestSearchArgumentImpl.createPredicateLeaf(PredicateLeaf.Operator.NULL_SAFE_EQUALS, PredicateLeaf.Type.DATE, "x", new DateWritable(15).get(), null);
        junit.framework.Assert.assertEquals((Object)SearchArgument.TruthValue.YES_NO, (Object)RecordReaderImpl.evaluatePredicateProto((OrcProto.ColumnStatistics)TestRecordReaderImpl.createIntStats(10, 100), (PredicateLeaf)pred, null));
        pred = TestSearchArgumentImpl.createPredicateLeaf(PredicateLeaf.Operator.NULL_SAFE_EQUALS, PredicateLeaf.Type.DECIMAL, "x", new HiveDecimalWritable("15"), null);
        junit.framework.Assert.assertEquals((Object)SearchArgument.TruthValue.YES_NO, (Object)RecordReaderImpl.evaluatePredicateProto((OrcProto.ColumnStatistics)TestRecordReaderImpl.createIntStats(10, 100), (PredicateLeaf)pred, null));
        pred = TestSearchArgumentImpl.createPredicateLeaf(PredicateLeaf.Operator.NULL_SAFE_EQUALS, PredicateLeaf.Type.TIMESTAMP, "x", new Timestamp(15L), null);
        junit.framework.Assert.assertEquals((Object)SearchArgument.TruthValue.YES_NO, (Object)RecordReaderImpl.evaluatePredicateProto((OrcProto.ColumnStatistics)TestRecordReaderImpl.createIntStats(10, 100), (PredicateLeaf)pred, null));
    }

    @Test
    public void testPredEvalWithDoubleStats() throws Exception {
        PredicateLeaf pred = TestSearchArgumentImpl.createPredicateLeaf(PredicateLeaf.Operator.NULL_SAFE_EQUALS, PredicateLeaf.Type.LONG, "x", 15L, null);
        junit.framework.Assert.assertEquals((Object)SearchArgument.TruthValue.YES_NO, (Object)RecordReaderImpl.evaluatePredicateProto((OrcProto.ColumnStatistics)TestRecordReaderImpl.createDoubleStats(10.0, 100.0), (PredicateLeaf)pred, null));
        pred = TestSearchArgumentImpl.createPredicateLeaf(PredicateLeaf.Operator.NULL_SAFE_EQUALS, PredicateLeaf.Type.FLOAT, "x", 15.0, null);
        junit.framework.Assert.assertEquals((Object)SearchArgument.TruthValue.YES_NO, (Object)RecordReaderImpl.evaluatePredicateProto((OrcProto.ColumnStatistics)TestRecordReaderImpl.createDoubleStats(10.0, 100.0), (PredicateLeaf)pred, null));
        pred = TestSearchArgumentImpl.createPredicateLeaf(PredicateLeaf.Operator.NULL_SAFE_EQUALS, PredicateLeaf.Type.STRING, "x", "15", null);
        junit.framework.Assert.assertEquals((Object)SearchArgument.TruthValue.NO, (Object)RecordReaderImpl.evaluatePredicateProto((OrcProto.ColumnStatistics)TestRecordReaderImpl.createDoubleStats(10.0, 100.0), (PredicateLeaf)pred, null));
        pred = TestSearchArgumentImpl.createPredicateLeaf(PredicateLeaf.Operator.NULL_SAFE_EQUALS, PredicateLeaf.Type.DATE, "x", new DateWritable(15).get(), null);
        junit.framework.Assert.assertEquals((Object)SearchArgument.TruthValue.YES_NO, (Object)RecordReaderImpl.evaluatePredicateProto((OrcProto.ColumnStatistics)TestRecordReaderImpl.createDoubleStats(10.0, 100.0), (PredicateLeaf)pred, null));
        pred = TestSearchArgumentImpl.createPredicateLeaf(PredicateLeaf.Operator.NULL_SAFE_EQUALS, PredicateLeaf.Type.DECIMAL, "x", new HiveDecimalWritable("15"), null);
        junit.framework.Assert.assertEquals((Object)SearchArgument.TruthValue.YES_NO, (Object)RecordReaderImpl.evaluatePredicateProto((OrcProto.ColumnStatistics)TestRecordReaderImpl.createDoubleStats(10.0, 100.0), (PredicateLeaf)pred, null));
        pred = TestSearchArgumentImpl.createPredicateLeaf(PredicateLeaf.Operator.NULL_SAFE_EQUALS, PredicateLeaf.Type.TIMESTAMP, "x", new Timestamp(15000L), null);
        junit.framework.Assert.assertEquals((Object)SearchArgument.TruthValue.YES_NO, (Object)RecordReaderImpl.evaluatePredicateProto((OrcProto.ColumnStatistics)TestRecordReaderImpl.createDoubleStats(10.0, 100.0), (PredicateLeaf)pred, null));
        pred = TestSearchArgumentImpl.createPredicateLeaf(PredicateLeaf.Operator.NULL_SAFE_EQUALS, PredicateLeaf.Type.TIMESTAMP, "x", new Timestamp(150000L), null);
        junit.framework.Assert.assertEquals((Object)SearchArgument.TruthValue.NO, (Object)RecordReaderImpl.evaluatePredicateProto((OrcProto.ColumnStatistics)TestRecordReaderImpl.createDoubleStats(10.0, 100.0), (PredicateLeaf)pred, null));
    }

    @Test
    public void testPredEvalWithStringStats() throws Exception {
        PredicateLeaf pred = TestSearchArgumentImpl.createPredicateLeaf(PredicateLeaf.Operator.NULL_SAFE_EQUALS, PredicateLeaf.Type.LONG, "x", 100L, null);
        junit.framework.Assert.assertEquals((Object)SearchArgument.TruthValue.YES_NO, (Object)RecordReaderImpl.evaluatePredicateProto((OrcProto.ColumnStatistics)TestRecordReaderImpl.createStringStats("10", "1000"), (PredicateLeaf)pred, null));
        pred = TestSearchArgumentImpl.createPredicateLeaf(PredicateLeaf.Operator.NULL_SAFE_EQUALS, PredicateLeaf.Type.FLOAT, "x", 100.0, null);
        junit.framework.Assert.assertEquals((Object)SearchArgument.TruthValue.YES_NO, (Object)RecordReaderImpl.evaluatePredicateProto((OrcProto.ColumnStatistics)TestRecordReaderImpl.createStringStats("10", "1000"), (PredicateLeaf)pred, null));
        pred = TestSearchArgumentImpl.createPredicateLeaf(PredicateLeaf.Operator.NULL_SAFE_EQUALS, PredicateLeaf.Type.STRING, "x", "100", null);
        junit.framework.Assert.assertEquals((Object)SearchArgument.TruthValue.YES_NO, (Object)RecordReaderImpl.evaluatePredicateProto((OrcProto.ColumnStatistics)TestRecordReaderImpl.createStringStats("10", "1000"), (PredicateLeaf)pred, null));
        pred = TestSearchArgumentImpl.createPredicateLeaf(PredicateLeaf.Operator.NULL_SAFE_EQUALS, PredicateLeaf.Type.DATE, "x", new DateWritable(100).get(), null);
        junit.framework.Assert.assertEquals((Object)SearchArgument.TruthValue.YES_NO, (Object)RecordReaderImpl.evaluatePredicateProto((OrcProto.ColumnStatistics)TestRecordReaderImpl.createDateStats(10, 1000), (PredicateLeaf)pred, null));
        pred = TestSearchArgumentImpl.createPredicateLeaf(PredicateLeaf.Operator.NULL_SAFE_EQUALS, PredicateLeaf.Type.DECIMAL, "x", new HiveDecimalWritable("100"), null);
        junit.framework.Assert.assertEquals((Object)SearchArgument.TruthValue.YES_NO, (Object)RecordReaderImpl.evaluatePredicateProto((OrcProto.ColumnStatistics)TestRecordReaderImpl.createStringStats("10", "1000"), (PredicateLeaf)pred, null));
        pred = TestSearchArgumentImpl.createPredicateLeaf(PredicateLeaf.Operator.NULL_SAFE_EQUALS, PredicateLeaf.Type.TIMESTAMP, "x", new Timestamp(100L), null);
        junit.framework.Assert.assertEquals((Object)SearchArgument.TruthValue.YES_NO, (Object)RecordReaderImpl.evaluatePredicateProto((OrcProto.ColumnStatistics)TestRecordReaderImpl.createStringStats("10", "1000"), (PredicateLeaf)pred, null));
    }

    @Test
    public void testPredEvalWithDateStats() throws Exception {
        PredicateLeaf pred = TestSearchArgumentImpl.createPredicateLeaf(PredicateLeaf.Operator.NULL_SAFE_EQUALS, PredicateLeaf.Type.LONG, "x", 15L, null);
        junit.framework.Assert.assertEquals((Object)SearchArgument.TruthValue.YES_NO, (Object)RecordReaderImpl.evaluatePredicateProto((OrcProto.ColumnStatistics)TestRecordReaderImpl.createDateStats(10, 100), (PredicateLeaf)pred, null));
        pred = TestSearchArgumentImpl.createPredicateLeaf(PredicateLeaf.Operator.NULL_SAFE_EQUALS, PredicateLeaf.Type.FLOAT, "x", 15.0, null);
        junit.framework.Assert.assertEquals((Object)SearchArgument.TruthValue.YES_NO, (Object)RecordReaderImpl.evaluatePredicateProto((OrcProto.ColumnStatistics)TestRecordReaderImpl.createDateStats(10, 100), (PredicateLeaf)pred, null));
        pred = TestSearchArgumentImpl.createPredicateLeaf(PredicateLeaf.Operator.NULL_SAFE_EQUALS, PredicateLeaf.Type.STRING, "x", "15", null);
        junit.framework.Assert.assertEquals((Object)SearchArgument.TruthValue.NO, (Object)RecordReaderImpl.evaluatePredicateProto((OrcProto.ColumnStatistics)TestRecordReaderImpl.createDateStats(10, 100), (PredicateLeaf)pred, null));
        pred = TestSearchArgumentImpl.createPredicateLeaf(PredicateLeaf.Operator.NULL_SAFE_EQUALS, PredicateLeaf.Type.STRING, "x", "1970-01-11", null);
        junit.framework.Assert.assertEquals((Object)SearchArgument.TruthValue.YES_NO, (Object)RecordReaderImpl.evaluatePredicateProto((OrcProto.ColumnStatistics)TestRecordReaderImpl.createDateStats(10, 100), (PredicateLeaf)pred, null));
        pred = TestSearchArgumentImpl.createPredicateLeaf(PredicateLeaf.Operator.NULL_SAFE_EQUALS, PredicateLeaf.Type.STRING, "x", "15.1", null);
        junit.framework.Assert.assertEquals((Object)SearchArgument.TruthValue.NO, (Object)RecordReaderImpl.evaluatePredicateProto((OrcProto.ColumnStatistics)TestRecordReaderImpl.createDateStats(10, 100), (PredicateLeaf)pred, null));
        pred = TestSearchArgumentImpl.createPredicateLeaf(PredicateLeaf.Operator.NULL_SAFE_EQUALS, PredicateLeaf.Type.STRING, "x", "__a15__1", null);
        junit.framework.Assert.assertEquals((Object)SearchArgument.TruthValue.NO, (Object)RecordReaderImpl.evaluatePredicateProto((OrcProto.ColumnStatistics)TestRecordReaderImpl.createDateStats(10, 100), (PredicateLeaf)pred, null));
        pred = TestSearchArgumentImpl.createPredicateLeaf(PredicateLeaf.Operator.NULL_SAFE_EQUALS, PredicateLeaf.Type.STRING, "x", "2000-01-16", null);
        junit.framework.Assert.assertEquals((Object)SearchArgument.TruthValue.NO, (Object)RecordReaderImpl.evaluatePredicateProto((OrcProto.ColumnStatistics)TestRecordReaderImpl.createDateStats(10, 100), (PredicateLeaf)pred, null));
        pred = TestSearchArgumentImpl.createPredicateLeaf(PredicateLeaf.Operator.NULL_SAFE_EQUALS, PredicateLeaf.Type.STRING, "x", "1970-01-16", null);
        junit.framework.Assert.assertEquals((Object)SearchArgument.TruthValue.YES_NO, (Object)RecordReaderImpl.evaluatePredicateProto((OrcProto.ColumnStatistics)TestRecordReaderImpl.createDateStats(10, 100), (PredicateLeaf)pred, null));
        pred = TestSearchArgumentImpl.createPredicateLeaf(PredicateLeaf.Operator.NULL_SAFE_EQUALS, PredicateLeaf.Type.DATE, "x", new DateWritable(15).get(), null);
        junit.framework.Assert.assertEquals((Object)SearchArgument.TruthValue.YES_NO, (Object)RecordReaderImpl.evaluatePredicateProto((OrcProto.ColumnStatistics)TestRecordReaderImpl.createDateStats(10, 100), (PredicateLeaf)pred, null));
        pred = TestSearchArgumentImpl.createPredicateLeaf(PredicateLeaf.Operator.NULL_SAFE_EQUALS, PredicateLeaf.Type.DATE, "x", new DateWritable(150).get(), null);
        junit.framework.Assert.assertEquals((Object)SearchArgument.TruthValue.NO, (Object)RecordReaderImpl.evaluatePredicateProto((OrcProto.ColumnStatistics)TestRecordReaderImpl.createDateStats(10, 100), (PredicateLeaf)pred, null));
        pred = TestSearchArgumentImpl.createPredicateLeaf(PredicateLeaf.Operator.NULL_SAFE_EQUALS, PredicateLeaf.Type.DECIMAL, "x", new HiveDecimalWritable("15"), null);
        junit.framework.Assert.assertEquals((Object)SearchArgument.TruthValue.YES_NO, (Object)RecordReaderImpl.evaluatePredicateProto((OrcProto.ColumnStatistics)TestRecordReaderImpl.createDateStats(10, 100), (PredicateLeaf)pred, null));
        pred = TestSearchArgumentImpl.createPredicateLeaf(PredicateLeaf.Operator.NULL_SAFE_EQUALS, PredicateLeaf.Type.TIMESTAMP, "x", new Timestamp(15L), null);
        junit.framework.Assert.assertEquals((Object)SearchArgument.TruthValue.NO, (Object)RecordReaderImpl.evaluatePredicateProto((OrcProto.ColumnStatistics)TestRecordReaderImpl.createDateStats(10, 100), (PredicateLeaf)pred, null));
        pred = TestSearchArgumentImpl.createPredicateLeaf(PredicateLeaf.Operator.NULL_SAFE_EQUALS, PredicateLeaf.Type.TIMESTAMP, "x", new Timestamp(1296000000L), null);
        junit.framework.Assert.assertEquals((Object)SearchArgument.TruthValue.YES_NO, (Object)RecordReaderImpl.evaluatePredicateProto((OrcProto.ColumnStatistics)TestRecordReaderImpl.createDateStats(10, 100), (PredicateLeaf)pred, null));
    }

    @Test
    public void testPredEvalWithDecimalStats() throws Exception {
        PredicateLeaf pred = TestSearchArgumentImpl.createPredicateLeaf(PredicateLeaf.Operator.NULL_SAFE_EQUALS, PredicateLeaf.Type.LONG, "x", 15L, null);
        junit.framework.Assert.assertEquals((Object)SearchArgument.TruthValue.YES_NO, (Object)RecordReaderImpl.evaluatePredicateProto((OrcProto.ColumnStatistics)TestRecordReaderImpl.createDecimalStats("10.0", "100.0"), (PredicateLeaf)pred, null));
        pred = TestSearchArgumentImpl.createPredicateLeaf(PredicateLeaf.Operator.NULL_SAFE_EQUALS, PredicateLeaf.Type.FLOAT, "x", 15.0, null);
        junit.framework.Assert.assertEquals((Object)SearchArgument.TruthValue.YES_NO, (Object)RecordReaderImpl.evaluatePredicateProto((OrcProto.ColumnStatistics)TestRecordReaderImpl.createDecimalStats("10.0", "100.0"), (PredicateLeaf)pred, null));
        pred = TestSearchArgumentImpl.createPredicateLeaf(PredicateLeaf.Operator.NULL_SAFE_EQUALS, PredicateLeaf.Type.STRING, "x", "15", null);
        junit.framework.Assert.assertEquals((Object)SearchArgument.TruthValue.NO, (Object)RecordReaderImpl.evaluatePredicateProto((OrcProto.ColumnStatistics)TestRecordReaderImpl.createDecimalStats("10.0", "100.0"), (PredicateLeaf)pred, null));
        pred = TestSearchArgumentImpl.createPredicateLeaf(PredicateLeaf.Operator.NULL_SAFE_EQUALS, PredicateLeaf.Type.DATE, "x", new DateWritable(15).get(), null);
        junit.framework.Assert.assertEquals((Object)SearchArgument.TruthValue.YES_NO, (Object)RecordReaderImpl.evaluatePredicateProto((OrcProto.ColumnStatistics)TestRecordReaderImpl.createDecimalStats("10.0", "100.0"), (PredicateLeaf)pred, null));
        pred = TestSearchArgumentImpl.createPredicateLeaf(PredicateLeaf.Operator.NULL_SAFE_EQUALS, PredicateLeaf.Type.DECIMAL, "x", new HiveDecimalWritable("15"), null);
        junit.framework.Assert.assertEquals((Object)SearchArgument.TruthValue.YES_NO, (Object)RecordReaderImpl.evaluatePredicateProto((OrcProto.ColumnStatistics)TestRecordReaderImpl.createDecimalStats("10.0", "100.0"), (PredicateLeaf)pred, null));
        pred = TestSearchArgumentImpl.createPredicateLeaf(PredicateLeaf.Operator.NULL_SAFE_EQUALS, PredicateLeaf.Type.TIMESTAMP, "x", new Timestamp(15000L), null);
        junit.framework.Assert.assertEquals((Object)SearchArgument.TruthValue.YES_NO, (Object)RecordReaderImpl.evaluatePredicateProto((OrcProto.ColumnStatistics)TestRecordReaderImpl.createDecimalStats("10.0", "100.0"), (PredicateLeaf)pred, null));
        pred = TestSearchArgumentImpl.createPredicateLeaf(PredicateLeaf.Operator.NULL_SAFE_EQUALS, PredicateLeaf.Type.TIMESTAMP, "x", new Timestamp(150000L), null);
        junit.framework.Assert.assertEquals((Object)SearchArgument.TruthValue.NO, (Object)RecordReaderImpl.evaluatePredicateProto((OrcProto.ColumnStatistics)TestRecordReaderImpl.createDecimalStats("10.0", "100.0"), (PredicateLeaf)pred, null));
    }

    @Test
    public void testPredEvalWithTimestampStats() throws Exception {
        PredicateLeaf pred = TestSearchArgumentImpl.createPredicateLeaf(PredicateLeaf.Operator.NULL_SAFE_EQUALS, PredicateLeaf.Type.LONG, "x", 15L, null);
        junit.framework.Assert.assertEquals((Object)SearchArgument.TruthValue.YES_NO, (Object)RecordReaderImpl.evaluatePredicateProto((OrcProto.ColumnStatistics)TestRecordReaderImpl.createTimestampStats(10L, 100L), (PredicateLeaf)pred, null));
        pred = TestSearchArgumentImpl.createPredicateLeaf(PredicateLeaf.Operator.NULL_SAFE_EQUALS, PredicateLeaf.Type.FLOAT, "x", 15.0, null);
        junit.framework.Assert.assertEquals((Object)SearchArgument.TruthValue.NO, (Object)RecordReaderImpl.evaluatePredicateProto((OrcProto.ColumnStatistics)TestRecordReaderImpl.createTimestampStats(10L, 100L), (PredicateLeaf)pred, null));
        junit.framework.Assert.assertEquals((Object)SearchArgument.TruthValue.YES_NO, (Object)RecordReaderImpl.evaluatePredicateProto((OrcProto.ColumnStatistics)TestRecordReaderImpl.createTimestampStats(10000L, 100000L), (PredicateLeaf)pred, null));
        pred = TestSearchArgumentImpl.createPredicateLeaf(PredicateLeaf.Operator.NULL_SAFE_EQUALS, PredicateLeaf.Type.STRING, "x", "15", null);
        junit.framework.Assert.assertEquals((Object)SearchArgument.TruthValue.NO, (Object)RecordReaderImpl.evaluatePredicateProto((OrcProto.ColumnStatistics)TestRecordReaderImpl.createTimestampStats(10L, 100L), (PredicateLeaf)pred, null));
        pred = TestSearchArgumentImpl.createPredicateLeaf(PredicateLeaf.Operator.NULL_SAFE_EQUALS, PredicateLeaf.Type.STRING, "x", new Timestamp(15L).toString(), null);
        junit.framework.Assert.assertEquals((Object)SearchArgument.TruthValue.YES_NO, (Object)RecordReaderImpl.evaluatePredicateProto((OrcProto.ColumnStatistics)TestRecordReaderImpl.createTimestampStats(10L, 100L), (PredicateLeaf)pred, null));
        pred = TestSearchArgumentImpl.createPredicateLeaf(PredicateLeaf.Operator.NULL_SAFE_EQUALS, PredicateLeaf.Type.DATE, "x", new DateWritable(15).get(), null);
        junit.framework.Assert.assertEquals((Object)SearchArgument.TruthValue.NO, (Object)RecordReaderImpl.evaluatePredicateProto((OrcProto.ColumnStatistics)TestRecordReaderImpl.createTimestampStats(10L, 100L), (PredicateLeaf)pred, null));
        junit.framework.Assert.assertEquals((Object)SearchArgument.TruthValue.YES_NO, (Object)RecordReaderImpl.evaluatePredicateProto((OrcProto.ColumnStatistics)TestRecordReaderImpl.createTimestampStats(864000000L, 8640000000L), (PredicateLeaf)pred, null));
        pred = TestSearchArgumentImpl.createPredicateLeaf(PredicateLeaf.Operator.NULL_SAFE_EQUALS, PredicateLeaf.Type.DECIMAL, "x", new HiveDecimalWritable("15"), null);
        junit.framework.Assert.assertEquals((Object)SearchArgument.TruthValue.NO, (Object)RecordReaderImpl.evaluatePredicateProto((OrcProto.ColumnStatistics)TestRecordReaderImpl.createTimestampStats(10L, 100L), (PredicateLeaf)pred, null));
        junit.framework.Assert.assertEquals((Object)SearchArgument.TruthValue.YES_NO, (Object)RecordReaderImpl.evaluatePredicateProto((OrcProto.ColumnStatistics)TestRecordReaderImpl.createTimestampStats(10000L, 100000L), (PredicateLeaf)pred, null));
        pred = TestSearchArgumentImpl.createPredicateLeaf(PredicateLeaf.Operator.NULL_SAFE_EQUALS, PredicateLeaf.Type.TIMESTAMP, "x", new Timestamp(15L), null);
        junit.framework.Assert.assertEquals((Object)SearchArgument.TruthValue.YES_NO, (Object)RecordReaderImpl.evaluatePredicateProto((OrcProto.ColumnStatistics)TestRecordReaderImpl.createTimestampStats(10L, 100L), (PredicateLeaf)pred, null));
        junit.framework.Assert.assertEquals((Object)SearchArgument.TruthValue.NO, (Object)RecordReaderImpl.evaluatePredicateProto((OrcProto.ColumnStatistics)TestRecordReaderImpl.createTimestampStats(10000L, 100000L), (PredicateLeaf)pred, null));
    }

    @Test
    public void testEquals() throws Exception {
        PredicateLeaf pred = TestSearchArgumentImpl.createPredicateLeaf(PredicateLeaf.Operator.EQUALS, PredicateLeaf.Type.LONG, "x", 15L, null);
        junit.framework.Assert.assertEquals((Object)SearchArgument.TruthValue.NO_NULL, (Object)RecordReaderImpl.evaluatePredicateProto((OrcProto.ColumnStatistics)TestRecordReaderImpl.createIntStats(20L, 30L), (PredicateLeaf)pred, null));
        junit.framework.Assert.assertEquals((Object)SearchArgument.TruthValue.YES_NO_NULL, (Object)RecordReaderImpl.evaluatePredicateProto((OrcProto.ColumnStatistics)TestRecordReaderImpl.createIntStats(15L, 30L), (PredicateLeaf)pred, null));
        junit.framework.Assert.assertEquals((Object)SearchArgument.TruthValue.YES_NO_NULL, (Object)RecordReaderImpl.evaluatePredicateProto((OrcProto.ColumnStatistics)TestRecordReaderImpl.createIntStats(10L, 30L), (PredicateLeaf)pred, null));
        junit.framework.Assert.assertEquals((Object)SearchArgument.TruthValue.YES_NO_NULL, (Object)RecordReaderImpl.evaluatePredicateProto((OrcProto.ColumnStatistics)TestRecordReaderImpl.createIntStats(10L, 15L), (PredicateLeaf)pred, null));
        junit.framework.Assert.assertEquals((Object)SearchArgument.TruthValue.NO_NULL, (Object)RecordReaderImpl.evaluatePredicateProto((OrcProto.ColumnStatistics)TestRecordReaderImpl.createIntStats(0L, 10L), (PredicateLeaf)pred, null));
        junit.framework.Assert.assertEquals((Object)SearchArgument.TruthValue.YES_NULL, (Object)RecordReaderImpl.evaluatePredicateProto((OrcProto.ColumnStatistics)TestRecordReaderImpl.createIntStats(15L, 15L), (PredicateLeaf)pred, null));
    }

    @Test
    public void testNullSafeEquals() throws Exception {
        PredicateLeaf pred = TestSearchArgumentImpl.createPredicateLeaf(PredicateLeaf.Operator.NULL_SAFE_EQUALS, PredicateLeaf.Type.LONG, "x", 15L, null);
        junit.framework.Assert.assertEquals((Object)SearchArgument.TruthValue.NO, (Object)RecordReaderImpl.evaluatePredicateProto((OrcProto.ColumnStatistics)TestRecordReaderImpl.createIntStats(20L, 30L), (PredicateLeaf)pred, null));
        junit.framework.Assert.assertEquals((Object)SearchArgument.TruthValue.YES_NO, (Object)RecordReaderImpl.evaluatePredicateProto((OrcProto.ColumnStatistics)TestRecordReaderImpl.createIntStats(15L, 30L), (PredicateLeaf)pred, null));
        junit.framework.Assert.assertEquals((Object)SearchArgument.TruthValue.YES_NO, (Object)RecordReaderImpl.evaluatePredicateProto((OrcProto.ColumnStatistics)TestRecordReaderImpl.createIntStats(10L, 30L), (PredicateLeaf)pred, null));
        junit.framework.Assert.assertEquals((Object)SearchArgument.TruthValue.YES_NO, (Object)RecordReaderImpl.evaluatePredicateProto((OrcProto.ColumnStatistics)TestRecordReaderImpl.createIntStats(10L, 15L), (PredicateLeaf)pred, null));
        junit.framework.Assert.assertEquals((Object)SearchArgument.TruthValue.NO, (Object)RecordReaderImpl.evaluatePredicateProto((OrcProto.ColumnStatistics)TestRecordReaderImpl.createIntStats(0L, 10L), (PredicateLeaf)pred, null));
        junit.framework.Assert.assertEquals((Object)SearchArgument.TruthValue.YES_NO, (Object)RecordReaderImpl.evaluatePredicateProto((OrcProto.ColumnStatistics)TestRecordReaderImpl.createIntStats(15L, 15L), (PredicateLeaf)pred, null));
    }

    @Test
    public void testLessThan() throws Exception {
        PredicateLeaf lessThan = TestSearchArgumentImpl.createPredicateLeaf(PredicateLeaf.Operator.LESS_THAN, PredicateLeaf.Type.LONG, "x", 15L, null);
        junit.framework.Assert.assertEquals((Object)SearchArgument.TruthValue.NO_NULL, (Object)RecordReaderImpl.evaluatePredicateProto((OrcProto.ColumnStatistics)TestRecordReaderImpl.createIntStats(20L, 30L), (PredicateLeaf)lessThan, null));
        junit.framework.Assert.assertEquals((Object)SearchArgument.TruthValue.NO_NULL, (Object)RecordReaderImpl.evaluatePredicateProto((OrcProto.ColumnStatistics)TestRecordReaderImpl.createIntStats(15L, 30L), (PredicateLeaf)lessThan, null));
        junit.framework.Assert.assertEquals((Object)SearchArgument.TruthValue.YES_NO_NULL, (Object)RecordReaderImpl.evaluatePredicateProto((OrcProto.ColumnStatistics)TestRecordReaderImpl.createIntStats(10L, 30L), (PredicateLeaf)lessThan, null));
        junit.framework.Assert.assertEquals((Object)SearchArgument.TruthValue.YES_NO_NULL, (Object)RecordReaderImpl.evaluatePredicateProto((OrcProto.ColumnStatistics)TestRecordReaderImpl.createIntStats(10L, 15L), (PredicateLeaf)lessThan, null));
        junit.framework.Assert.assertEquals((Object)SearchArgument.TruthValue.YES_NULL, (Object)RecordReaderImpl.evaluatePredicateProto((OrcProto.ColumnStatistics)TestRecordReaderImpl.createIntStats(0L, 10L), (PredicateLeaf)lessThan, null));
    }

    @Test
    public void testLessThanEquals() throws Exception {
        PredicateLeaf pred = TestSearchArgumentImpl.createPredicateLeaf(PredicateLeaf.Operator.LESS_THAN_EQUALS, PredicateLeaf.Type.LONG, "x", 15L, null);
        junit.framework.Assert.assertEquals((Object)SearchArgument.TruthValue.NO_NULL, (Object)RecordReaderImpl.evaluatePredicateProto((OrcProto.ColumnStatistics)TestRecordReaderImpl.createIntStats(20L, 30L), (PredicateLeaf)pred, null));
        junit.framework.Assert.assertEquals((Object)SearchArgument.TruthValue.YES_NO_NULL, (Object)RecordReaderImpl.evaluatePredicateProto((OrcProto.ColumnStatistics)TestRecordReaderImpl.createIntStats(15L, 30L), (PredicateLeaf)pred, null));
        junit.framework.Assert.assertEquals((Object)SearchArgument.TruthValue.YES_NO_NULL, (Object)RecordReaderImpl.evaluatePredicateProto((OrcProto.ColumnStatistics)TestRecordReaderImpl.createIntStats(10L, 30L), (PredicateLeaf)pred, null));
        junit.framework.Assert.assertEquals((Object)SearchArgument.TruthValue.YES_NULL, (Object)RecordReaderImpl.evaluatePredicateProto((OrcProto.ColumnStatistics)TestRecordReaderImpl.createIntStats(10L, 15L), (PredicateLeaf)pred, null));
        junit.framework.Assert.assertEquals((Object)SearchArgument.TruthValue.YES_NULL, (Object)RecordReaderImpl.evaluatePredicateProto((OrcProto.ColumnStatistics)TestRecordReaderImpl.createIntStats(0L, 10L), (PredicateLeaf)pred, null));
    }

    @Test
    public void testIn() throws Exception {
        ArrayList<Object> args = new ArrayList<Object>();
        args.add(10L);
        args.add(20L);
        PredicateLeaf pred = TestSearchArgumentImpl.createPredicateLeaf(PredicateLeaf.Operator.IN, PredicateLeaf.Type.LONG, "x", null, args);
        junit.framework.Assert.assertEquals((Object)SearchArgument.TruthValue.YES_NULL, (Object)RecordReaderImpl.evaluatePredicateProto((OrcProto.ColumnStatistics)TestRecordReaderImpl.createIntStats(20L, 20L), (PredicateLeaf)pred, null));
        junit.framework.Assert.assertEquals((Object)SearchArgument.TruthValue.NO_NULL, (Object)RecordReaderImpl.evaluatePredicateProto((OrcProto.ColumnStatistics)TestRecordReaderImpl.createIntStats(30L, 30L), (PredicateLeaf)pred, null));
        junit.framework.Assert.assertEquals((Object)SearchArgument.TruthValue.YES_NO_NULL, (Object)RecordReaderImpl.evaluatePredicateProto((OrcProto.ColumnStatistics)TestRecordReaderImpl.createIntStats(10L, 30L), (PredicateLeaf)pred, null));
        junit.framework.Assert.assertEquals((Object)SearchArgument.TruthValue.NO_NULL, (Object)RecordReaderImpl.evaluatePredicateProto((OrcProto.ColumnStatistics)TestRecordReaderImpl.createIntStats(12L, 18L), (PredicateLeaf)pred, null));
    }

    @Test
    public void testBetween() throws Exception {
        ArrayList<Object> args = new ArrayList<Object>();
        args.add(10L);
        args.add(20L);
        PredicateLeaf pred = TestSearchArgumentImpl.createPredicateLeaf(PredicateLeaf.Operator.BETWEEN, PredicateLeaf.Type.LONG, "x", null, args);
        junit.framework.Assert.assertEquals((Object)SearchArgument.TruthValue.NO_NULL, (Object)RecordReaderImpl.evaluatePredicateProto((OrcProto.ColumnStatistics)TestRecordReaderImpl.createIntStats(0L, 5L), (PredicateLeaf)pred, null));
        junit.framework.Assert.assertEquals((Object)SearchArgument.TruthValue.NO_NULL, (Object)RecordReaderImpl.evaluatePredicateProto((OrcProto.ColumnStatistics)TestRecordReaderImpl.createIntStats(30L, 40L), (PredicateLeaf)pred, null));
        junit.framework.Assert.assertEquals((Object)SearchArgument.TruthValue.YES_NO_NULL, (Object)RecordReaderImpl.evaluatePredicateProto((OrcProto.ColumnStatistics)TestRecordReaderImpl.createIntStats(5L, 15L), (PredicateLeaf)pred, null));
        junit.framework.Assert.assertEquals((Object)SearchArgument.TruthValue.YES_NO_NULL, (Object)RecordReaderImpl.evaluatePredicateProto((OrcProto.ColumnStatistics)TestRecordReaderImpl.createIntStats(15L, 25L), (PredicateLeaf)pred, null));
        junit.framework.Assert.assertEquals((Object)SearchArgument.TruthValue.YES_NO_NULL, (Object)RecordReaderImpl.evaluatePredicateProto((OrcProto.ColumnStatistics)TestRecordReaderImpl.createIntStats(5L, 25L), (PredicateLeaf)pred, null));
        junit.framework.Assert.assertEquals((Object)SearchArgument.TruthValue.YES_NULL, (Object)RecordReaderImpl.evaluatePredicateProto((OrcProto.ColumnStatistics)TestRecordReaderImpl.createIntStats(10L, 20L), (PredicateLeaf)pred, null));
        junit.framework.Assert.assertEquals((Object)SearchArgument.TruthValue.YES_NULL, (Object)RecordReaderImpl.evaluatePredicateProto((OrcProto.ColumnStatistics)TestRecordReaderImpl.createIntStats(12L, 18L), (PredicateLeaf)pred, null));
    }

    @Test
    public void testIsNull() throws Exception {
        PredicateLeaf pred = TestSearchArgumentImpl.createPredicateLeaf(PredicateLeaf.Operator.IS_NULL, PredicateLeaf.Type.LONG, "x", null, null);
        junit.framework.Assert.assertEquals((Object)SearchArgument.TruthValue.YES_NO, (Object)RecordReaderImpl.evaluatePredicateProto((OrcProto.ColumnStatistics)TestRecordReaderImpl.createIntStats(20L, 30L), (PredicateLeaf)pred, null));
    }

    @Test
    public void testEqualsWithNullInStats() throws Exception {
        PredicateLeaf pred = TestSearchArgumentImpl.createPredicateLeaf(PredicateLeaf.Operator.EQUALS, PredicateLeaf.Type.STRING, "x", "c", null);
        junit.framework.Assert.assertEquals((Object)SearchArgument.TruthValue.NO_NULL, (Object)RecordReaderImpl.evaluatePredicateProto((OrcProto.ColumnStatistics)TestRecordReaderImpl.createStringStats("d", "e", true), (PredicateLeaf)pred, null));
        junit.framework.Assert.assertEquals((Object)SearchArgument.TruthValue.NO_NULL, (Object)RecordReaderImpl.evaluatePredicateProto((OrcProto.ColumnStatistics)TestRecordReaderImpl.createStringStats("a", "b", true), (PredicateLeaf)pred, null));
        junit.framework.Assert.assertEquals((Object)SearchArgument.TruthValue.YES_NO_NULL, (Object)RecordReaderImpl.evaluatePredicateProto((OrcProto.ColumnStatistics)TestRecordReaderImpl.createStringStats("b", "c", true), (PredicateLeaf)pred, null));
        junit.framework.Assert.assertEquals((Object)SearchArgument.TruthValue.YES_NO_NULL, (Object)RecordReaderImpl.evaluatePredicateProto((OrcProto.ColumnStatistics)TestRecordReaderImpl.createStringStats("c", "d", true), (PredicateLeaf)pred, null));
        junit.framework.Assert.assertEquals((Object)SearchArgument.TruthValue.YES_NO_NULL, (Object)RecordReaderImpl.evaluatePredicateProto((OrcProto.ColumnStatistics)TestRecordReaderImpl.createStringStats("b", "d", true), (PredicateLeaf)pred, null));
        junit.framework.Assert.assertEquals((Object)SearchArgument.TruthValue.YES_NULL, (Object)RecordReaderImpl.evaluatePredicateProto((OrcProto.ColumnStatistics)TestRecordReaderImpl.createStringStats("c", "c", true), (PredicateLeaf)pred, null));
    }

    @Test
    public void testNullSafeEqualsWithNullInStats() throws Exception {
        PredicateLeaf pred = TestSearchArgumentImpl.createPredicateLeaf(PredicateLeaf.Operator.NULL_SAFE_EQUALS, PredicateLeaf.Type.STRING, "x", "c", null);
        junit.framework.Assert.assertEquals((Object)SearchArgument.TruthValue.NO, (Object)RecordReaderImpl.evaluatePredicateProto((OrcProto.ColumnStatistics)TestRecordReaderImpl.createStringStats("d", "e", true), (PredicateLeaf)pred, null));
        junit.framework.Assert.assertEquals((Object)SearchArgument.TruthValue.NO, (Object)RecordReaderImpl.evaluatePredicateProto((OrcProto.ColumnStatistics)TestRecordReaderImpl.createStringStats("a", "b", true), (PredicateLeaf)pred, null));
        junit.framework.Assert.assertEquals((Object)SearchArgument.TruthValue.YES_NO, (Object)RecordReaderImpl.evaluatePredicateProto((OrcProto.ColumnStatistics)TestRecordReaderImpl.createStringStats("b", "c", true), (PredicateLeaf)pred, null));
        junit.framework.Assert.assertEquals((Object)SearchArgument.TruthValue.YES_NO, (Object)RecordReaderImpl.evaluatePredicateProto((OrcProto.ColumnStatistics)TestRecordReaderImpl.createStringStats("c", "d", true), (PredicateLeaf)pred, null));
        junit.framework.Assert.assertEquals((Object)SearchArgument.TruthValue.YES_NO, (Object)RecordReaderImpl.evaluatePredicateProto((OrcProto.ColumnStatistics)TestRecordReaderImpl.createStringStats("b", "d", true), (PredicateLeaf)pred, null));
        junit.framework.Assert.assertEquals((Object)SearchArgument.TruthValue.YES_NO, (Object)RecordReaderImpl.evaluatePredicateProto((OrcProto.ColumnStatistics)TestRecordReaderImpl.createStringStats("c", "c", true), (PredicateLeaf)pred, null));
    }

    @Test
    public void testLessThanWithNullInStats() throws Exception {
        PredicateLeaf pred = TestSearchArgumentImpl.createPredicateLeaf(PredicateLeaf.Operator.LESS_THAN, PredicateLeaf.Type.STRING, "x", "c", null);
        junit.framework.Assert.assertEquals((Object)SearchArgument.TruthValue.NO_NULL, (Object)RecordReaderImpl.evaluatePredicateProto((OrcProto.ColumnStatistics)TestRecordReaderImpl.createStringStats("d", "e", true), (PredicateLeaf)pred, null));
        junit.framework.Assert.assertEquals((Object)SearchArgument.TruthValue.YES_NULL, (Object)RecordReaderImpl.evaluatePredicateProto((OrcProto.ColumnStatistics)TestRecordReaderImpl.createStringStats("a", "b", true), (PredicateLeaf)pred, null));
        junit.framework.Assert.assertEquals((Object)SearchArgument.TruthValue.YES_NO_NULL, (Object)RecordReaderImpl.evaluatePredicateProto((OrcProto.ColumnStatistics)TestRecordReaderImpl.createStringStats("b", "c", true), (PredicateLeaf)pred, null));
        junit.framework.Assert.assertEquals((Object)SearchArgument.TruthValue.NO_NULL, (Object)RecordReaderImpl.evaluatePredicateProto((OrcProto.ColumnStatistics)TestRecordReaderImpl.createStringStats("c", "d", true), (PredicateLeaf)pred, null));
        junit.framework.Assert.assertEquals((Object)SearchArgument.TruthValue.YES_NO_NULL, (Object)RecordReaderImpl.evaluatePredicateProto((OrcProto.ColumnStatistics)TestRecordReaderImpl.createStringStats("b", "d", true), (PredicateLeaf)pred, null));
        junit.framework.Assert.assertEquals((Object)SearchArgument.TruthValue.NO_NULL, (Object)RecordReaderImpl.evaluatePredicateProto((OrcProto.ColumnStatistics)TestRecordReaderImpl.createStringStats("c", "c", true), (PredicateLeaf)pred, null));
    }

    @Test
    public void testLessThanEqualsWithNullInStats() throws Exception {
        PredicateLeaf pred = TestSearchArgumentImpl.createPredicateLeaf(PredicateLeaf.Operator.LESS_THAN_EQUALS, PredicateLeaf.Type.STRING, "x", "c", null);
        junit.framework.Assert.assertEquals((Object)SearchArgument.TruthValue.NO_NULL, (Object)RecordReaderImpl.evaluatePredicateProto((OrcProto.ColumnStatistics)TestRecordReaderImpl.createStringStats("d", "e", true), (PredicateLeaf)pred, null));
        junit.framework.Assert.assertEquals((Object)SearchArgument.TruthValue.YES_NULL, (Object)RecordReaderImpl.evaluatePredicateProto((OrcProto.ColumnStatistics)TestRecordReaderImpl.createStringStats("a", "b", true), (PredicateLeaf)pred, null));
        junit.framework.Assert.assertEquals((Object)SearchArgument.TruthValue.YES_NULL, (Object)RecordReaderImpl.evaluatePredicateProto((OrcProto.ColumnStatistics)TestRecordReaderImpl.createStringStats("b", "c", true), (PredicateLeaf)pred, null));
        junit.framework.Assert.assertEquals((Object)SearchArgument.TruthValue.YES_NO_NULL, (Object)RecordReaderImpl.evaluatePredicateProto((OrcProto.ColumnStatistics)TestRecordReaderImpl.createStringStats("c", "d", true), (PredicateLeaf)pred, null));
        junit.framework.Assert.assertEquals((Object)SearchArgument.TruthValue.YES_NO_NULL, (Object)RecordReaderImpl.evaluatePredicateProto((OrcProto.ColumnStatistics)TestRecordReaderImpl.createStringStats("b", "d", true), (PredicateLeaf)pred, null));
        junit.framework.Assert.assertEquals((Object)SearchArgument.TruthValue.YES_NO_NULL, (Object)RecordReaderImpl.evaluatePredicateProto((OrcProto.ColumnStatistics)TestRecordReaderImpl.createStringStats("c", "c", true), (PredicateLeaf)pred, null));
    }

    @Test
    public void testInWithNullInStats() throws Exception {
        ArrayList<Object> args = new ArrayList<Object>();
        args.add("c");
        args.add("f");
        PredicateLeaf pred = TestSearchArgumentImpl.createPredicateLeaf(PredicateLeaf.Operator.IN, PredicateLeaf.Type.STRING, "x", null, args);
        junit.framework.Assert.assertEquals((Object)SearchArgument.TruthValue.NO_NULL, (Object)RecordReaderImpl.evaluatePredicateProto((OrcProto.ColumnStatistics)TestRecordReaderImpl.createStringStats("d", "e", true), (PredicateLeaf)pred, null));
        junit.framework.Assert.assertEquals((Object)SearchArgument.TruthValue.NO_NULL, (Object)RecordReaderImpl.evaluatePredicateProto((OrcProto.ColumnStatistics)TestRecordReaderImpl.createStringStats("a", "b", true), (PredicateLeaf)pred, null));
        junit.framework.Assert.assertEquals((Object)SearchArgument.TruthValue.YES_NO_NULL, (Object)RecordReaderImpl.evaluatePredicateProto((OrcProto.ColumnStatistics)TestRecordReaderImpl.createStringStats("e", "f", true), (PredicateLeaf)pred, null));
        junit.framework.Assert.assertEquals((Object)SearchArgument.TruthValue.YES_NO_NULL, (Object)RecordReaderImpl.evaluatePredicateProto((OrcProto.ColumnStatistics)TestRecordReaderImpl.createStringStats("c", "d", true), (PredicateLeaf)pred, null));
        junit.framework.Assert.assertEquals((Object)SearchArgument.TruthValue.YES_NO_NULL, (Object)RecordReaderImpl.evaluatePredicateProto((OrcProto.ColumnStatistics)TestRecordReaderImpl.createStringStats("b", "d", true), (PredicateLeaf)pred, null));
        junit.framework.Assert.assertEquals((Object)SearchArgument.TruthValue.YES_NULL, (Object)RecordReaderImpl.evaluatePredicateProto((OrcProto.ColumnStatistics)TestRecordReaderImpl.createStringStats("c", "c", true), (PredicateLeaf)pred, null));
    }

    @Test
    public void testBetweenWithNullInStats() throws Exception {
        ArrayList<Object> args = new ArrayList<Object>();
        args.add("c");
        args.add("f");
        PredicateLeaf pred = TestSearchArgumentImpl.createPredicateLeaf(PredicateLeaf.Operator.BETWEEN, PredicateLeaf.Type.STRING, "x", null, args);
        junit.framework.Assert.assertEquals((Object)SearchArgument.TruthValue.YES_NULL, (Object)RecordReaderImpl.evaluatePredicateProto((OrcProto.ColumnStatistics)TestRecordReaderImpl.createStringStats("d", "e", true), (PredicateLeaf)pred, null));
        junit.framework.Assert.assertEquals((Object)SearchArgument.TruthValue.YES_NULL, (Object)RecordReaderImpl.evaluatePredicateProto((OrcProto.ColumnStatistics)TestRecordReaderImpl.createStringStats("e", "f", true), (PredicateLeaf)pred, null));
        junit.framework.Assert.assertEquals((Object)SearchArgument.TruthValue.NO_NULL, (Object)RecordReaderImpl.evaluatePredicateProto((OrcProto.ColumnStatistics)TestRecordReaderImpl.createStringStats("h", "g", true), (PredicateLeaf)pred, null));
        junit.framework.Assert.assertEquals((Object)SearchArgument.TruthValue.YES_NO_NULL, (Object)RecordReaderImpl.evaluatePredicateProto((OrcProto.ColumnStatistics)TestRecordReaderImpl.createStringStats("f", "g", true), (PredicateLeaf)pred, null));
        junit.framework.Assert.assertEquals((Object)SearchArgument.TruthValue.YES_NO_NULL, (Object)RecordReaderImpl.evaluatePredicateProto((OrcProto.ColumnStatistics)TestRecordReaderImpl.createStringStats("e", "g", true), (PredicateLeaf)pred, null));
        junit.framework.Assert.assertEquals((Object)SearchArgument.TruthValue.YES_NULL, (Object)RecordReaderImpl.evaluatePredicateProto((OrcProto.ColumnStatistics)TestRecordReaderImpl.createStringStats("c", "e", true), (PredicateLeaf)pred, null));
        junit.framework.Assert.assertEquals((Object)SearchArgument.TruthValue.YES_NULL, (Object)RecordReaderImpl.evaluatePredicateProto((OrcProto.ColumnStatistics)TestRecordReaderImpl.createStringStats("c", "f", true), (PredicateLeaf)pred, null));
        junit.framework.Assert.assertEquals((Object)SearchArgument.TruthValue.YES_NO_NULL, (Object)RecordReaderImpl.evaluatePredicateProto((OrcProto.ColumnStatistics)TestRecordReaderImpl.createStringStats("c", "g", true), (PredicateLeaf)pred, null));
        junit.framework.Assert.assertEquals((Object)SearchArgument.TruthValue.NO_NULL, (Object)RecordReaderImpl.evaluatePredicateProto((OrcProto.ColumnStatistics)TestRecordReaderImpl.createStringStats("a", "b", true), (PredicateLeaf)pred, null));
        junit.framework.Assert.assertEquals((Object)SearchArgument.TruthValue.YES_NO_NULL, (Object)RecordReaderImpl.evaluatePredicateProto((OrcProto.ColumnStatistics)TestRecordReaderImpl.createStringStats("a", "c", true), (PredicateLeaf)pred, null));
        junit.framework.Assert.assertEquals((Object)SearchArgument.TruthValue.YES_NO_NULL, (Object)RecordReaderImpl.evaluatePredicateProto((OrcProto.ColumnStatistics)TestRecordReaderImpl.createStringStats("b", "d", true), (PredicateLeaf)pred, null));
        junit.framework.Assert.assertEquals((Object)SearchArgument.TruthValue.YES_NULL, (Object)RecordReaderImpl.evaluatePredicateProto((OrcProto.ColumnStatistics)TestRecordReaderImpl.createStringStats("c", "c", true), (PredicateLeaf)pred, null));
    }

    @Test
    public void testIsNullWithNullInStats() throws Exception {
        PredicateLeaf pred = TestSearchArgumentImpl.createPredicateLeaf(PredicateLeaf.Operator.IS_NULL, PredicateLeaf.Type.STRING, "x", null, null);
        junit.framework.Assert.assertEquals((Object)SearchArgument.TruthValue.YES_NO, (Object)RecordReaderImpl.evaluatePredicateProto((OrcProto.ColumnStatistics)TestRecordReaderImpl.createStringStats("c", "d", true), (PredicateLeaf)pred, null));
        junit.framework.Assert.assertEquals((Object)SearchArgument.TruthValue.NO, (Object)RecordReaderImpl.evaluatePredicateProto((OrcProto.ColumnStatistics)TestRecordReaderImpl.createStringStats("c", "d", false), (PredicateLeaf)pred, null));
    }

    @Test
    public void testOverlap() throws Exception {
        Assert.assertTrue((!RecordReaderUtils.overlap((long)0L, (long)10L, (long)-10L, (long)-1L) ? 1 : 0) != 0);
        Assert.assertTrue((boolean)RecordReaderUtils.overlap((long)0L, (long)10L, (long)-1L, (long)0L));
        Assert.assertTrue((boolean)RecordReaderUtils.overlap((long)0L, (long)10L, (long)-1L, (long)1L));
        Assert.assertTrue((boolean)RecordReaderUtils.overlap((long)0L, (long)10L, (long)2L, (long)8L));
        Assert.assertTrue((boolean)RecordReaderUtils.overlap((long)0L, (long)10L, (long)5L, (long)10L));
        Assert.assertTrue((boolean)RecordReaderUtils.overlap((long)0L, (long)10L, (long)10L, (long)11L));
        Assert.assertTrue((boolean)RecordReaderUtils.overlap((long)0L, (long)10L, (long)0L, (long)10L));
        Assert.assertTrue((boolean)RecordReaderUtils.overlap((long)0L, (long)10L, (long)-1L, (long)11L));
        Assert.assertTrue((!RecordReaderUtils.overlap((long)0L, (long)10L, (long)11L, (long)12L) ? 1 : 0) != 0);
    }

    private static DiskRangeList diskRanges(Integer ... points) {
        DiskRangeList head = null;
        DiskRangeList tail = null;
        for (int i = 0; i < points.length; i += 2) {
            DiskRangeList range = new DiskRangeList((long)points[i].intValue(), (long)points[i + 1].intValue());
            if (tail == null) {
                head = tail = range;
                continue;
            }
            tail = tail.insertAfter(range);
        }
        return head;
    }

    @Test
    public void testGetIndexPosition() throws Exception {
        junit.framework.Assert.assertEquals((int)0, (int)RecordReaderUtils.getIndexPosition((OrcProto.ColumnEncoding.Kind)OrcProto.ColumnEncoding.Kind.DIRECT, (OrcProto.Type.Kind)OrcProto.Type.Kind.INT, (OrcProto.Stream.Kind)OrcProto.Stream.Kind.PRESENT, (boolean)true, (boolean)true));
        junit.framework.Assert.assertEquals((int)4, (int)RecordReaderUtils.getIndexPosition((OrcProto.ColumnEncoding.Kind)OrcProto.ColumnEncoding.Kind.DIRECT, (OrcProto.Type.Kind)OrcProto.Type.Kind.INT, (OrcProto.Stream.Kind)OrcProto.Stream.Kind.DATA, (boolean)true, (boolean)true));
        junit.framework.Assert.assertEquals((int)3, (int)RecordReaderUtils.getIndexPosition((OrcProto.ColumnEncoding.Kind)OrcProto.ColumnEncoding.Kind.DIRECT, (OrcProto.Type.Kind)OrcProto.Type.Kind.INT, (OrcProto.Stream.Kind)OrcProto.Stream.Kind.DATA, (boolean)false, (boolean)true));
        junit.framework.Assert.assertEquals((int)0, (int)RecordReaderUtils.getIndexPosition((OrcProto.ColumnEncoding.Kind)OrcProto.ColumnEncoding.Kind.DIRECT, (OrcProto.Type.Kind)OrcProto.Type.Kind.INT, (OrcProto.Stream.Kind)OrcProto.Stream.Kind.DATA, (boolean)true, (boolean)false));
        junit.framework.Assert.assertEquals((int)4, (int)RecordReaderUtils.getIndexPosition((OrcProto.ColumnEncoding.Kind)OrcProto.ColumnEncoding.Kind.DICTIONARY, (OrcProto.Type.Kind)OrcProto.Type.Kind.STRING, (OrcProto.Stream.Kind)OrcProto.Stream.Kind.DATA, (boolean)true, (boolean)true));
        junit.framework.Assert.assertEquals((int)4, (int)RecordReaderUtils.getIndexPosition((OrcProto.ColumnEncoding.Kind)OrcProto.ColumnEncoding.Kind.DIRECT, (OrcProto.Type.Kind)OrcProto.Type.Kind.BINARY, (OrcProto.Stream.Kind)OrcProto.Stream.Kind.DATA, (boolean)true, (boolean)true));
        junit.framework.Assert.assertEquals((int)3, (int)RecordReaderUtils.getIndexPosition((OrcProto.ColumnEncoding.Kind)OrcProto.ColumnEncoding.Kind.DIRECT, (OrcProto.Type.Kind)OrcProto.Type.Kind.BINARY, (OrcProto.Stream.Kind)OrcProto.Stream.Kind.DATA, (boolean)false, (boolean)true));
        junit.framework.Assert.assertEquals((int)6, (int)RecordReaderUtils.getIndexPosition((OrcProto.ColumnEncoding.Kind)OrcProto.ColumnEncoding.Kind.DIRECT, (OrcProto.Type.Kind)OrcProto.Type.Kind.BINARY, (OrcProto.Stream.Kind)OrcProto.Stream.Kind.LENGTH, (boolean)true, (boolean)true));
        junit.framework.Assert.assertEquals((int)4, (int)RecordReaderUtils.getIndexPosition((OrcProto.ColumnEncoding.Kind)OrcProto.ColumnEncoding.Kind.DIRECT, (OrcProto.Type.Kind)OrcProto.Type.Kind.BINARY, (OrcProto.Stream.Kind)OrcProto.Stream.Kind.LENGTH, (boolean)false, (boolean)true));
        junit.framework.Assert.assertEquals((int)4, (int)RecordReaderUtils.getIndexPosition((OrcProto.ColumnEncoding.Kind)OrcProto.ColumnEncoding.Kind.DIRECT, (OrcProto.Type.Kind)OrcProto.Type.Kind.DECIMAL, (OrcProto.Stream.Kind)OrcProto.Stream.Kind.DATA, (boolean)true, (boolean)true));
        junit.framework.Assert.assertEquals((int)3, (int)RecordReaderUtils.getIndexPosition((OrcProto.ColumnEncoding.Kind)OrcProto.ColumnEncoding.Kind.DIRECT, (OrcProto.Type.Kind)OrcProto.Type.Kind.DECIMAL, (OrcProto.Stream.Kind)OrcProto.Stream.Kind.DATA, (boolean)false, (boolean)true));
        junit.framework.Assert.assertEquals((int)6, (int)RecordReaderUtils.getIndexPosition((OrcProto.ColumnEncoding.Kind)OrcProto.ColumnEncoding.Kind.DIRECT, (OrcProto.Type.Kind)OrcProto.Type.Kind.DECIMAL, (OrcProto.Stream.Kind)OrcProto.Stream.Kind.SECONDARY, (boolean)true, (boolean)true));
        junit.framework.Assert.assertEquals((int)4, (int)RecordReaderUtils.getIndexPosition((OrcProto.ColumnEncoding.Kind)OrcProto.ColumnEncoding.Kind.DIRECT, (OrcProto.Type.Kind)OrcProto.Type.Kind.DECIMAL, (OrcProto.Stream.Kind)OrcProto.Stream.Kind.SECONDARY, (boolean)false, (boolean)true));
        junit.framework.Assert.assertEquals((int)4, (int)RecordReaderUtils.getIndexPosition((OrcProto.ColumnEncoding.Kind)OrcProto.ColumnEncoding.Kind.DIRECT, (OrcProto.Type.Kind)OrcProto.Type.Kind.TIMESTAMP, (OrcProto.Stream.Kind)OrcProto.Stream.Kind.DATA, (boolean)true, (boolean)true));
        junit.framework.Assert.assertEquals((int)3, (int)RecordReaderUtils.getIndexPosition((OrcProto.ColumnEncoding.Kind)OrcProto.ColumnEncoding.Kind.DIRECT, (OrcProto.Type.Kind)OrcProto.Type.Kind.TIMESTAMP, (OrcProto.Stream.Kind)OrcProto.Stream.Kind.DATA, (boolean)false, (boolean)true));
        junit.framework.Assert.assertEquals((int)7, (int)RecordReaderUtils.getIndexPosition((OrcProto.ColumnEncoding.Kind)OrcProto.ColumnEncoding.Kind.DIRECT, (OrcProto.Type.Kind)OrcProto.Type.Kind.TIMESTAMP, (OrcProto.Stream.Kind)OrcProto.Stream.Kind.SECONDARY, (boolean)true, (boolean)true));
        junit.framework.Assert.assertEquals((int)5, (int)RecordReaderUtils.getIndexPosition((OrcProto.ColumnEncoding.Kind)OrcProto.ColumnEncoding.Kind.DIRECT, (OrcProto.Type.Kind)OrcProto.Type.Kind.TIMESTAMP, (OrcProto.Stream.Kind)OrcProto.Stream.Kind.SECONDARY, (boolean)false, (boolean)true));
    }

    @Test
    public void testPartialPlan() throws Exception {
        ArrayList<OrcProto.Stream> streams = new ArrayList<OrcProto.Stream>();
        streams.add(OrcProto.Stream.newBuilder().setKind(OrcProto.Stream.Kind.PRESENT).setColumn(1).setLength(1000L).build());
        streams.add(OrcProto.Stream.newBuilder().setKind(OrcProto.Stream.Kind.DATA).setColumn(1).setLength(99000L).build());
        streams.add(OrcProto.Stream.newBuilder().setKind(OrcProto.Stream.Kind.PRESENT).setColumn(2).setLength(2000L).build());
        streams.add(OrcProto.Stream.newBuilder().setKind(OrcProto.Stream.Kind.DATA).setColumn(2).setLength(98000L).build());
        boolean[] columns = new boolean[]{true, true, false};
        boolean[] rowGroups = new boolean[]{true, true, false, false, true, false};
        OrcProto.RowIndex[] indexes = new OrcProto.RowIndex[columns.length];
        indexes[1] = OrcProto.RowIndex.newBuilder().addEntry(OrcProto.RowIndexEntry.newBuilder().addPositions(0L).addPositions(-1L).addPositions(-1L).addPositions(0L).build()).addEntry(OrcProto.RowIndexEntry.newBuilder().addPositions(100L).addPositions(-1L).addPositions(-1L).addPositions(10000L).build()).addEntry(OrcProto.RowIndexEntry.newBuilder().addPositions(200L).addPositions(-1L).addPositions(-1L).addPositions(20000L).build()).addEntry(OrcProto.RowIndexEntry.newBuilder().addPositions(300L).addPositions(-1L).addPositions(-1L).addPositions(30000L).build()).addEntry(OrcProto.RowIndexEntry.newBuilder().addPositions(400L).addPositions(-1L).addPositions(-1L).addPositions(40000L).build()).addEntry(OrcProto.RowIndexEntry.newBuilder().addPositions(500L).addPositions(-1L).addPositions(-1L).addPositions(50000L).build()).build();
        ArrayList<OrcProto.ColumnEncoding> encodings = new ArrayList<OrcProto.ColumnEncoding>();
        encodings.add(OrcProto.ColumnEncoding.newBuilder().setKind(OrcProto.ColumnEncoding.Kind.DIRECT).build());
        encodings.add(OrcProto.ColumnEncoding.newBuilder().setKind(OrcProto.ColumnEncoding.Kind.DIRECT).build());
        encodings.add(OrcProto.ColumnEncoding.newBuilder().setKind(OrcProto.ColumnEncoding.Kind.DIRECT).build());
        ArrayList<OrcProto.Type> types = new ArrayList<OrcProto.Type>();
        types.add(OrcProto.Type.newBuilder().setKind(OrcProto.Type.Kind.STRUCT).addSubtypes(1).addSubtypes(2).addFieldNames("x").addFieldNames("y").build());
        types.add(OrcProto.Type.newBuilder().setKind(OrcProto.Type.Kind.INT).build());
        types.add(OrcProto.Type.newBuilder().setKind(OrcProto.Type.Kind.INT).build());
        DiskRangeList result = RecordReaderImpl.planReadPartialDataStreams(streams, (OrcProto.RowIndex[])indexes, (boolean[])columns, (boolean[])rowGroups, (boolean)false, encodings, types, (int)32768, (boolean)false);
        Assert.assertThat((Object)result, (Matcher)Is.is((Object)TestRecordReaderImpl.diskRanges(0, 1000, 100, 1000, 400, 1000, 1000, 15098, 11000, 25098, 41000, 55098)));
        result = RecordReaderImpl.planReadPartialDataStreams(streams, (OrcProto.RowIndex[])indexes, (boolean[])columns, (boolean[])rowGroups, (boolean)false, encodings, types, (int)32768, (boolean)true);
        Assert.assertThat((Object)result, (Matcher)Is.is((Object)TestRecordReaderImpl.diskRanges(0, 25098, 41000, 55098)));
        rowGroups = new boolean[]{false, false, false, false, false, false};
        result = RecordReaderImpl.planReadPartialDataStreams(streams, (OrcProto.RowIndex[])indexes, (boolean[])columns, (boolean[])rowGroups, (boolean)false, encodings, types, (int)32768, (boolean)false);
        Assert.assertNull((Object)result);
        rowGroups = null;
        columns = new boolean[]{true, false, true};
        result = RecordReaderImpl.planReadPartialDataStreams(streams, (OrcProto.RowIndex[])indexes, (boolean[])columns, null, (boolean)false, encodings, types, (int)32768, (boolean)false);
        Assert.assertThat((Object)result, (Matcher)Is.is((Object)TestRecordReaderImpl.diskRanges(100000, 102000, 102000, 200000)));
        result = RecordReaderImpl.planReadPartialDataStreams(streams, (OrcProto.RowIndex[])indexes, (boolean[])columns, null, (boolean)false, encodings, types, (int)32768, (boolean)true);
        Assert.assertThat((Object)result, (Matcher)Is.is((Object)TestRecordReaderImpl.diskRanges(100000, 200000)));
        rowGroups = new boolean[]{false, true, false, false, false, false};
        indexes[2] = indexes[1];
        indexes[1] = null;
        result = RecordReaderImpl.planReadPartialDataStreams(streams, (OrcProto.RowIndex[])indexes, (boolean[])columns, (boolean[])rowGroups, (boolean)false, encodings, types, (int)32768, (boolean)false);
        Assert.assertThat((Object)result, (Matcher)Is.is((Object)TestRecordReaderImpl.diskRanges(100100, 102000, 112000, 126098)));
        result = RecordReaderImpl.planReadPartialDataStreams(streams, (OrcProto.RowIndex[])indexes, (boolean[])columns, (boolean[])rowGroups, (boolean)false, encodings, types, (int)32768, (boolean)true);
        Assert.assertThat((Object)result, (Matcher)Is.is((Object)TestRecordReaderImpl.diskRanges(100100, 102000, 112000, 126098)));
        rowGroups = new boolean[]{false, false, false, false, false, true};
        indexes[1] = indexes[2];
        columns = new boolean[]{true, true, true};
        result = RecordReaderImpl.planReadPartialDataStreams(streams, (OrcProto.RowIndex[])indexes, (boolean[])columns, (boolean[])rowGroups, (boolean)false, encodings, types, (int)32768, (boolean)false);
        Assert.assertThat((Object)result, (Matcher)Is.is((Object)TestRecordReaderImpl.diskRanges(500, 1000, 51000, 100000, 100500, 102000, 152000, 200000)));
        result = RecordReaderImpl.planReadPartialDataStreams(streams, (OrcProto.RowIndex[])indexes, (boolean[])columns, (boolean[])rowGroups, (boolean)false, encodings, types, (int)32768, (boolean)true);
        Assert.assertThat((Object)result, (Matcher)Is.is((Object)TestRecordReaderImpl.diskRanges(500, 1000, 51000, 100000, 100500, 102000, 152000, 200000)));
    }

    @Test
    public void testPartialPlanCompressed() throws Exception {
        ArrayList<OrcProto.Stream> streams = new ArrayList<OrcProto.Stream>();
        streams.add(OrcProto.Stream.newBuilder().setKind(OrcProto.Stream.Kind.PRESENT).setColumn(1).setLength(1000L).build());
        streams.add(OrcProto.Stream.newBuilder().setKind(OrcProto.Stream.Kind.DATA).setColumn(1).setLength(99000L).build());
        streams.add(OrcProto.Stream.newBuilder().setKind(OrcProto.Stream.Kind.PRESENT).setColumn(2).setLength(2000L).build());
        streams.add(OrcProto.Stream.newBuilder().setKind(OrcProto.Stream.Kind.DATA).setColumn(2).setLength(98000L).build());
        boolean[] columns = new boolean[]{true, true, false};
        boolean[] rowGroups = new boolean[]{true, true, false, false, true, false};
        OrcProto.RowIndex[] indexes = new OrcProto.RowIndex[columns.length];
        indexes[1] = OrcProto.RowIndex.newBuilder().addEntry(OrcProto.RowIndexEntry.newBuilder().addPositions(0L).addPositions(-1L).addPositions(-1L).addPositions(-1L).addPositions(0L).build()).addEntry(OrcProto.RowIndexEntry.newBuilder().addPositions(100L).addPositions(-1L).addPositions(-1L).addPositions(-1L).addPositions(10000L).build()).addEntry(OrcProto.RowIndexEntry.newBuilder().addPositions(200L).addPositions(-1L).addPositions(-1L).addPositions(-1L).addPositions(20000L).build()).addEntry(OrcProto.RowIndexEntry.newBuilder().addPositions(300L).addPositions(-1L).addPositions(-1L).addPositions(-1L).addPositions(30000L).build()).addEntry(OrcProto.RowIndexEntry.newBuilder().addPositions(400L).addPositions(-1L).addPositions(-1L).addPositions(-1L).addPositions(40000L).build()).addEntry(OrcProto.RowIndexEntry.newBuilder().addPositions(500L).addPositions(-1L).addPositions(-1L).addPositions(-1L).addPositions(50000L).build()).build();
        ArrayList<OrcProto.ColumnEncoding> encodings = new ArrayList<OrcProto.ColumnEncoding>();
        encodings.add(OrcProto.ColumnEncoding.newBuilder().setKind(OrcProto.ColumnEncoding.Kind.DIRECT).build());
        encodings.add(OrcProto.ColumnEncoding.newBuilder().setKind(OrcProto.ColumnEncoding.Kind.DIRECT).build());
        encodings.add(OrcProto.ColumnEncoding.newBuilder().setKind(OrcProto.ColumnEncoding.Kind.DIRECT).build());
        ArrayList<OrcProto.Type> types = new ArrayList<OrcProto.Type>();
        types.add(OrcProto.Type.newBuilder().setKind(OrcProto.Type.Kind.STRUCT).addSubtypes(1).addSubtypes(2).addFieldNames("x").addFieldNames("y").build());
        types.add(OrcProto.Type.newBuilder().setKind(OrcProto.Type.Kind.INT).build());
        types.add(OrcProto.Type.newBuilder().setKind(OrcProto.Type.Kind.INT).build());
        DiskRangeList result = RecordReaderImpl.planReadPartialDataStreams(streams, (OrcProto.RowIndex[])indexes, (boolean[])columns, (boolean[])rowGroups, (boolean)true, encodings, types, (int)32768, (boolean)false);
        Assert.assertThat((Object)result, (Matcher)Is.is((Object)TestRecordReaderImpl.diskRanges(0, 1000, 100, 1000, 400, 1000, 1000, 76542, 11000, 86542, 41000, 100000)));
        rowGroups = new boolean[]{false, false, false, false, false, true};
        result = RecordReaderImpl.planReadPartialDataStreams(streams, (OrcProto.RowIndex[])indexes, (boolean[])columns, (boolean[])rowGroups, (boolean)true, encodings, types, (int)32768, (boolean)false);
        Assert.assertThat((Object)result, (Matcher)Is.is((Object)TestRecordReaderImpl.diskRanges(500, 1000, 51000, 100000)));
    }

    @Test
    public void testPartialPlanString() throws Exception {
        ArrayList<OrcProto.Stream> streams = new ArrayList<OrcProto.Stream>();
        streams.add(OrcProto.Stream.newBuilder().setKind(OrcProto.Stream.Kind.PRESENT).setColumn(1).setLength(1000L).build());
        streams.add(OrcProto.Stream.newBuilder().setKind(OrcProto.Stream.Kind.DATA).setColumn(1).setLength(94000L).build());
        streams.add(OrcProto.Stream.newBuilder().setKind(OrcProto.Stream.Kind.LENGTH).setColumn(1).setLength(2000L).build());
        streams.add(OrcProto.Stream.newBuilder().setKind(OrcProto.Stream.Kind.DICTIONARY_DATA).setColumn(1).setLength(3000L).build());
        streams.add(OrcProto.Stream.newBuilder().setKind(OrcProto.Stream.Kind.PRESENT).setColumn(2).setLength(2000L).build());
        streams.add(OrcProto.Stream.newBuilder().setKind(OrcProto.Stream.Kind.DATA).setColumn(2).setLength(98000L).build());
        boolean[] columns = new boolean[]{true, true, false};
        boolean[] rowGroups = new boolean[]{false, true, false, false, true, true};
        OrcProto.RowIndex[] indexes = new OrcProto.RowIndex[columns.length];
        indexes[1] = OrcProto.RowIndex.newBuilder().addEntry(OrcProto.RowIndexEntry.newBuilder().addPositions(0L).addPositions(-1L).addPositions(-1L).addPositions(0L).build()).addEntry(OrcProto.RowIndexEntry.newBuilder().addPositions(100L).addPositions(-1L).addPositions(-1L).addPositions(10000L).build()).addEntry(OrcProto.RowIndexEntry.newBuilder().addPositions(200L).addPositions(-1L).addPositions(-1L).addPositions(20000L).build()).addEntry(OrcProto.RowIndexEntry.newBuilder().addPositions(300L).addPositions(-1L).addPositions(-1L).addPositions(30000L).build()).addEntry(OrcProto.RowIndexEntry.newBuilder().addPositions(400L).addPositions(-1L).addPositions(-1L).addPositions(40000L).build()).addEntry(OrcProto.RowIndexEntry.newBuilder().addPositions(500L).addPositions(-1L).addPositions(-1L).addPositions(50000L).build()).build();
        ArrayList<OrcProto.ColumnEncoding> encodings = new ArrayList<OrcProto.ColumnEncoding>();
        encodings.add(OrcProto.ColumnEncoding.newBuilder().setKind(OrcProto.ColumnEncoding.Kind.DIRECT).build());
        encodings.add(OrcProto.ColumnEncoding.newBuilder().setKind(OrcProto.ColumnEncoding.Kind.DICTIONARY).build());
        encodings.add(OrcProto.ColumnEncoding.newBuilder().setKind(OrcProto.ColumnEncoding.Kind.DIRECT).build());
        ArrayList<OrcProto.Type> types = new ArrayList<OrcProto.Type>();
        types.add(OrcProto.Type.newBuilder().setKind(OrcProto.Type.Kind.STRUCT).addSubtypes(1).addSubtypes(2).addFieldNames("x").addFieldNames("y").build());
        types.add(OrcProto.Type.newBuilder().setKind(OrcProto.Type.Kind.STRING).build());
        types.add(OrcProto.Type.newBuilder().setKind(OrcProto.Type.Kind.INT).build());
        DiskRangeList result = RecordReaderImpl.planReadPartialDataStreams(streams, (OrcProto.RowIndex[])indexes, (boolean[])columns, (boolean[])rowGroups, (boolean)false, encodings, types, (int)32768, (boolean)false);
        Assert.assertThat((Object)result, (Matcher)Is.is((Object)TestRecordReaderImpl.diskRanges(100, 1000, 400, 1000, 500, 1000, 11000, 25098, 41000, 55098, 51000, 95000, 95000, 97000, 97000, 100000)));
    }

    @Test
    public void testIntNullSafeEqualsBloomFilter() throws Exception {
        PredicateLeaf pred = TestSearchArgumentImpl.createPredicateLeaf(PredicateLeaf.Operator.NULL_SAFE_EQUALS, PredicateLeaf.Type.LONG, "x", 15L, null);
        BloomFilterIO bf = new BloomFilterIO(10000L);
        for (int i = 20; i < 1000; ++i) {
            bf.addLong((long)i);
        }
        ColumnStatisticsImpl cs = ColumnStatisticsImpl.deserialize((OrcProto.ColumnStatistics)TestRecordReaderImpl.createIntStats(10, 100));
        junit.framework.Assert.assertEquals((Object)SearchArgument.TruthValue.NO, (Object)RecordReaderImpl.evaluatePredicate((ColumnStatistics)cs, (PredicateLeaf)pred, (BloomFilterIO)bf));
        bf.addLong(15L);
        junit.framework.Assert.assertEquals((Object)SearchArgument.TruthValue.YES_NO, (Object)RecordReaderImpl.evaluatePredicate((ColumnStatistics)cs, (PredicateLeaf)pred, (BloomFilterIO)bf));
    }

    @Test
    public void testIntEqualsBloomFilter() throws Exception {
        PredicateLeaf pred = TestSearchArgumentImpl.createPredicateLeaf(PredicateLeaf.Operator.EQUALS, PredicateLeaf.Type.LONG, "x", 15L, null);
        BloomFilterIO bf = new BloomFilterIO(10000L);
        for (int i = 20; i < 1000; ++i) {
            bf.addLong((long)i);
        }
        ColumnStatisticsImpl cs = ColumnStatisticsImpl.deserialize((OrcProto.ColumnStatistics)TestRecordReaderImpl.createIntStats(10, 100));
        junit.framework.Assert.assertEquals((Object)SearchArgument.TruthValue.NO_NULL, (Object)RecordReaderImpl.evaluatePredicate((ColumnStatistics)cs, (PredicateLeaf)pred, (BloomFilterIO)bf));
        bf.addLong(15L);
        junit.framework.Assert.assertEquals((Object)SearchArgument.TruthValue.YES_NO_NULL, (Object)RecordReaderImpl.evaluatePredicate((ColumnStatistics)cs, (PredicateLeaf)pred, (BloomFilterIO)bf));
    }

    @Test
    public void testIntInBloomFilter() throws Exception {
        ArrayList<Object> args = new ArrayList<Object>();
        args.add(15L);
        args.add(19L);
        PredicateLeaf pred = TestSearchArgumentImpl.createPredicateLeaf(PredicateLeaf.Operator.IN, PredicateLeaf.Type.LONG, "x", null, args);
        BloomFilterIO bf = new BloomFilterIO(10000L);
        for (int i = 20; i < 1000; ++i) {
            bf.addLong((long)i);
        }
        ColumnStatisticsImpl cs = ColumnStatisticsImpl.deserialize((OrcProto.ColumnStatistics)TestRecordReaderImpl.createIntStats(10, 100));
        junit.framework.Assert.assertEquals((Object)SearchArgument.TruthValue.NO_NULL, (Object)RecordReaderImpl.evaluatePredicate((ColumnStatistics)cs, (PredicateLeaf)pred, (BloomFilterIO)bf));
        bf.addLong(19L);
        junit.framework.Assert.assertEquals((Object)SearchArgument.TruthValue.YES_NO_NULL, (Object)RecordReaderImpl.evaluatePredicate((ColumnStatistics)cs, (PredicateLeaf)pred, (BloomFilterIO)bf));
        bf.addLong(15L);
        junit.framework.Assert.assertEquals((Object)SearchArgument.TruthValue.YES_NO_NULL, (Object)RecordReaderImpl.evaluatePredicate((ColumnStatistics)cs, (PredicateLeaf)pred, (BloomFilterIO)bf));
    }

    @Test
    public void testDoubleNullSafeEqualsBloomFilter() throws Exception {
        PredicateLeaf pred = TestSearchArgumentImpl.createPredicateLeaf(PredicateLeaf.Operator.NULL_SAFE_EQUALS, PredicateLeaf.Type.FLOAT, "x", 15.0, null);
        BloomFilterIO bf = new BloomFilterIO(10000L);
        for (int i = 20; i < 1000; ++i) {
            bf.addDouble((double)i);
        }
        ColumnStatisticsImpl cs = ColumnStatisticsImpl.deserialize((OrcProto.ColumnStatistics)TestRecordReaderImpl.createDoubleStats(10.0, 100.0));
        junit.framework.Assert.assertEquals((Object)SearchArgument.TruthValue.NO, (Object)RecordReaderImpl.evaluatePredicate((ColumnStatistics)cs, (PredicateLeaf)pred, (BloomFilterIO)bf));
        bf.addDouble(15.0);
        junit.framework.Assert.assertEquals((Object)SearchArgument.TruthValue.YES_NO, (Object)RecordReaderImpl.evaluatePredicate((ColumnStatistics)cs, (PredicateLeaf)pred, (BloomFilterIO)bf));
    }

    @Test
    public void testDoubleEqualsBloomFilter() throws Exception {
        PredicateLeaf pred = TestSearchArgumentImpl.createPredicateLeaf(PredicateLeaf.Operator.EQUALS, PredicateLeaf.Type.FLOAT, "x", 15.0, null);
        BloomFilterIO bf = new BloomFilterIO(10000L);
        for (int i = 20; i < 1000; ++i) {
            bf.addDouble((double)i);
        }
        ColumnStatisticsImpl cs = ColumnStatisticsImpl.deserialize((OrcProto.ColumnStatistics)TestRecordReaderImpl.createDoubleStats(10.0, 100.0));
        junit.framework.Assert.assertEquals((Object)SearchArgument.TruthValue.NO_NULL, (Object)RecordReaderImpl.evaluatePredicate((ColumnStatistics)cs, (PredicateLeaf)pred, (BloomFilterIO)bf));
        bf.addDouble(15.0);
        junit.framework.Assert.assertEquals((Object)SearchArgument.TruthValue.YES_NO_NULL, (Object)RecordReaderImpl.evaluatePredicate((ColumnStatistics)cs, (PredicateLeaf)pred, (BloomFilterIO)bf));
    }

    @Test
    public void testDoubleInBloomFilter() throws Exception {
        ArrayList<Object> args = new ArrayList<Object>();
        args.add(15.0);
        args.add(19.0);
        PredicateLeaf pred = TestSearchArgumentImpl.createPredicateLeaf(PredicateLeaf.Operator.IN, PredicateLeaf.Type.FLOAT, "x", null, args);
        BloomFilterIO bf = new BloomFilterIO(10000L);
        for (int i = 20; i < 1000; ++i) {
            bf.addDouble((double)i);
        }
        ColumnStatisticsImpl cs = ColumnStatisticsImpl.deserialize((OrcProto.ColumnStatistics)TestRecordReaderImpl.createDoubleStats(10.0, 100.0));
        junit.framework.Assert.assertEquals((Object)SearchArgument.TruthValue.NO_NULL, (Object)RecordReaderImpl.evaluatePredicate((ColumnStatistics)cs, (PredicateLeaf)pred, (BloomFilterIO)bf));
        bf.addDouble(19.0);
        junit.framework.Assert.assertEquals((Object)SearchArgument.TruthValue.YES_NO_NULL, (Object)RecordReaderImpl.evaluatePredicate((ColumnStatistics)cs, (PredicateLeaf)pred, (BloomFilterIO)bf));
        bf.addDouble(15.0);
        junit.framework.Assert.assertEquals((Object)SearchArgument.TruthValue.YES_NO_NULL, (Object)RecordReaderImpl.evaluatePredicate((ColumnStatistics)cs, (PredicateLeaf)pred, (BloomFilterIO)bf));
    }

    @Test
    public void testStringNullSafeEqualsBloomFilter() throws Exception {
        PredicateLeaf pred = TestSearchArgumentImpl.createPredicateLeaf(PredicateLeaf.Operator.NULL_SAFE_EQUALS, PredicateLeaf.Type.STRING, "x", "str_15", null);
        BloomFilterIO bf = new BloomFilterIO(10000L);
        for (int i = 20; i < 1000; ++i) {
            bf.addString("str_" + i);
        }
        ColumnStatisticsImpl cs = ColumnStatisticsImpl.deserialize((OrcProto.ColumnStatistics)TestRecordReaderImpl.createStringStats("str_10", "str_200"));
        junit.framework.Assert.assertEquals((Object)SearchArgument.TruthValue.NO, (Object)RecordReaderImpl.evaluatePredicate((ColumnStatistics)cs, (PredicateLeaf)pred, (BloomFilterIO)bf));
        bf.addString("str_15");
        junit.framework.Assert.assertEquals((Object)SearchArgument.TruthValue.YES_NO, (Object)RecordReaderImpl.evaluatePredicate((ColumnStatistics)cs, (PredicateLeaf)pred, (BloomFilterIO)bf));
    }

    @Test
    public void testStringEqualsBloomFilter() throws Exception {
        PredicateLeaf pred = TestSearchArgumentImpl.createPredicateLeaf(PredicateLeaf.Operator.EQUALS, PredicateLeaf.Type.STRING, "x", "str_15", null);
        BloomFilterIO bf = new BloomFilterIO(10000L);
        for (int i = 20; i < 1000; ++i) {
            bf.addString("str_" + i);
        }
        ColumnStatisticsImpl cs = ColumnStatisticsImpl.deserialize((OrcProto.ColumnStatistics)TestRecordReaderImpl.createStringStats("str_10", "str_200"));
        junit.framework.Assert.assertEquals((Object)SearchArgument.TruthValue.NO_NULL, (Object)RecordReaderImpl.evaluatePredicate((ColumnStatistics)cs, (PredicateLeaf)pred, (BloomFilterIO)bf));
        bf.addString("str_15");
        junit.framework.Assert.assertEquals((Object)SearchArgument.TruthValue.YES_NO_NULL, (Object)RecordReaderImpl.evaluatePredicate((ColumnStatistics)cs, (PredicateLeaf)pred, (BloomFilterIO)bf));
    }

    @Test
    public void testStringInBloomFilter() throws Exception {
        ArrayList<Object> args = new ArrayList<Object>();
        args.add("str_15");
        args.add("str_19");
        PredicateLeaf pred = TestSearchArgumentImpl.createPredicateLeaf(PredicateLeaf.Operator.IN, PredicateLeaf.Type.STRING, "x", null, args);
        BloomFilterIO bf = new BloomFilterIO(10000L);
        for (int i = 20; i < 1000; ++i) {
            bf.addString("str_" + i);
        }
        ColumnStatisticsImpl cs = ColumnStatisticsImpl.deserialize((OrcProto.ColumnStatistics)TestRecordReaderImpl.createStringStats("str_10", "str_200"));
        junit.framework.Assert.assertEquals((Object)SearchArgument.TruthValue.NO_NULL, (Object)RecordReaderImpl.evaluatePredicate((ColumnStatistics)cs, (PredicateLeaf)pred, (BloomFilterIO)bf));
        bf.addString("str_19");
        junit.framework.Assert.assertEquals((Object)SearchArgument.TruthValue.YES_NO_NULL, (Object)RecordReaderImpl.evaluatePredicate((ColumnStatistics)cs, (PredicateLeaf)pred, (BloomFilterIO)bf));
        bf.addString("str_15");
        junit.framework.Assert.assertEquals((Object)SearchArgument.TruthValue.YES_NO_NULL, (Object)RecordReaderImpl.evaluatePredicate((ColumnStatistics)cs, (PredicateLeaf)pred, (BloomFilterIO)bf));
    }

    @Test
    public void testDateWritableNullSafeEqualsBloomFilter() throws Exception {
        PredicateLeaf pred = TestSearchArgumentImpl.createPredicateLeaf(PredicateLeaf.Operator.NULL_SAFE_EQUALS, PredicateLeaf.Type.DATE, "x", new DateWritable(15).get(), null);
        BloomFilterIO bf = new BloomFilterIO(10000L);
        for (int i = 20; i < 1000; ++i) {
            bf.addLong((long)new DateWritable(i).getDays());
        }
        ColumnStatisticsImpl cs = ColumnStatisticsImpl.deserialize((OrcProto.ColumnStatistics)TestRecordReaderImpl.createDateStats(10, 100));
        junit.framework.Assert.assertEquals((Object)SearchArgument.TruthValue.NO, (Object)RecordReaderImpl.evaluatePredicate((ColumnStatistics)cs, (PredicateLeaf)pred, (BloomFilterIO)bf));
        bf.addLong((long)new DateWritable(15).getDays());
        junit.framework.Assert.assertEquals((Object)SearchArgument.TruthValue.YES_NO, (Object)RecordReaderImpl.evaluatePredicate((ColumnStatistics)cs, (PredicateLeaf)pred, (BloomFilterIO)bf));
    }

    @Test
    public void testDateWritableEqualsBloomFilter() throws Exception {
        PredicateLeaf pred = TestSearchArgumentImpl.createPredicateLeaf(PredicateLeaf.Operator.EQUALS, PredicateLeaf.Type.DATE, "x", new DateWritable(15).get(), null);
        BloomFilterIO bf = new BloomFilterIO(10000L);
        for (int i = 20; i < 1000; ++i) {
            bf.addLong((long)new DateWritable(i).getDays());
        }
        ColumnStatisticsImpl cs = ColumnStatisticsImpl.deserialize((OrcProto.ColumnStatistics)TestRecordReaderImpl.createDateStats(10, 100));
        junit.framework.Assert.assertEquals((Object)SearchArgument.TruthValue.NO_NULL, (Object)RecordReaderImpl.evaluatePredicate((ColumnStatistics)cs, (PredicateLeaf)pred, (BloomFilterIO)bf));
        bf.addLong((long)new DateWritable(15).getDays());
        junit.framework.Assert.assertEquals((Object)SearchArgument.TruthValue.YES_NO_NULL, (Object)RecordReaderImpl.evaluatePredicate((ColumnStatistics)cs, (PredicateLeaf)pred, (BloomFilterIO)bf));
    }

    @Test
    public void testDateWritableInBloomFilter() throws Exception {
        ArrayList<Object> args = new ArrayList<Object>();
        args.add(new DateWritable(15).get());
        args.add(new DateWritable(19).get());
        PredicateLeaf pred = TestSearchArgumentImpl.createPredicateLeaf(PredicateLeaf.Operator.IN, PredicateLeaf.Type.DATE, "x", null, args);
        BloomFilterIO bf = new BloomFilterIO(10000L);
        for (int i = 20; i < 1000; ++i) {
            bf.addLong((long)new DateWritable(i).getDays());
        }
        ColumnStatisticsImpl cs = ColumnStatisticsImpl.deserialize((OrcProto.ColumnStatistics)TestRecordReaderImpl.createDateStats(10, 100));
        junit.framework.Assert.assertEquals((Object)SearchArgument.TruthValue.NO_NULL, (Object)RecordReaderImpl.evaluatePredicate((ColumnStatistics)cs, (PredicateLeaf)pred, (BloomFilterIO)bf));
        bf.addLong((long)new DateWritable(19).getDays());
        junit.framework.Assert.assertEquals((Object)SearchArgument.TruthValue.YES_NO_NULL, (Object)RecordReaderImpl.evaluatePredicate((ColumnStatistics)cs, (PredicateLeaf)pred, (BloomFilterIO)bf));
        bf.addLong((long)new DateWritable(15).getDays());
        junit.framework.Assert.assertEquals((Object)SearchArgument.TruthValue.YES_NO_NULL, (Object)RecordReaderImpl.evaluatePredicate((ColumnStatistics)cs, (PredicateLeaf)pred, (BloomFilterIO)bf));
    }

    @Test
    public void testTimestampNullSafeEqualsBloomFilter() throws Exception {
        PredicateLeaf pred = TestSearchArgumentImpl.createPredicateLeaf(PredicateLeaf.Operator.NULL_SAFE_EQUALS, PredicateLeaf.Type.TIMESTAMP, "x", new Timestamp(15L), null);
        BloomFilterIO bf = new BloomFilterIO(10000L);
        for (int i = 20; i < 1000; ++i) {
            bf.addLong(new Timestamp(i).getTime());
        }
        ColumnStatisticsImpl cs = ColumnStatisticsImpl.deserialize((OrcProto.ColumnStatistics)TestRecordReaderImpl.createTimestampStats(10L, 100L));
        junit.framework.Assert.assertEquals((Object)SearchArgument.TruthValue.NO, (Object)RecordReaderImpl.evaluatePredicate((ColumnStatistics)cs, (PredicateLeaf)pred, (BloomFilterIO)bf));
        bf.addLong(new Timestamp(15L).getTime());
        junit.framework.Assert.assertEquals((Object)SearchArgument.TruthValue.YES_NO, (Object)RecordReaderImpl.evaluatePredicate((ColumnStatistics)cs, (PredicateLeaf)pred, (BloomFilterIO)bf));
    }

    @Test
    public void testTimestampEqualsBloomFilter() throws Exception {
        PredicateLeaf pred = TestSearchArgumentImpl.createPredicateLeaf(PredicateLeaf.Operator.EQUALS, PredicateLeaf.Type.TIMESTAMP, "x", new Timestamp(15L), null);
        BloomFilterIO bf = new BloomFilterIO(10000L);
        for (int i = 20; i < 1000; ++i) {
            bf.addLong(new Timestamp(i).getTime());
        }
        ColumnStatisticsImpl cs = ColumnStatisticsImpl.deserialize((OrcProto.ColumnStatistics)TestRecordReaderImpl.createTimestampStats(10L, 100L));
        junit.framework.Assert.assertEquals((Object)SearchArgument.TruthValue.NO_NULL, (Object)RecordReaderImpl.evaluatePredicate((ColumnStatistics)cs, (PredicateLeaf)pred, (BloomFilterIO)bf));
        bf.addLong(new Timestamp(15L).getTime());
        junit.framework.Assert.assertEquals((Object)SearchArgument.TruthValue.YES_NO_NULL, (Object)RecordReaderImpl.evaluatePredicate((ColumnStatistics)cs, (PredicateLeaf)pred, (BloomFilterIO)bf));
    }

    @Test
    public void testTimestampInBloomFilter() throws Exception {
        ArrayList<Object> args = new ArrayList<Object>();
        args.add(new Timestamp(15L));
        args.add(new Timestamp(19L));
        PredicateLeaf pred = TestSearchArgumentImpl.createPredicateLeaf(PredicateLeaf.Operator.IN, PredicateLeaf.Type.TIMESTAMP, "x", null, args);
        BloomFilterIO bf = new BloomFilterIO(10000L);
        for (int i = 20; i < 1000; ++i) {
            bf.addLong(new Timestamp(i).getTime());
        }
        ColumnStatisticsImpl cs = ColumnStatisticsImpl.deserialize((OrcProto.ColumnStatistics)TestRecordReaderImpl.createTimestampStats(10L, 100L));
        junit.framework.Assert.assertEquals((Object)SearchArgument.TruthValue.NO_NULL, (Object)RecordReaderImpl.evaluatePredicate((ColumnStatistics)cs, (PredicateLeaf)pred, (BloomFilterIO)bf));
        bf.addLong(new Timestamp(19L).getTime());
        junit.framework.Assert.assertEquals((Object)SearchArgument.TruthValue.YES_NO_NULL, (Object)RecordReaderImpl.evaluatePredicate((ColumnStatistics)cs, (PredicateLeaf)pred, (BloomFilterIO)bf));
        bf.addLong(new Timestamp(15L).getTime());
        junit.framework.Assert.assertEquals((Object)SearchArgument.TruthValue.YES_NO_NULL, (Object)RecordReaderImpl.evaluatePredicate((ColumnStatistics)cs, (PredicateLeaf)pred, (BloomFilterIO)bf));
    }

    @Test
    public void testDecimalNullSafeEqualsBloomFilter() throws Exception {
        PredicateLeaf pred = TestSearchArgumentImpl.createPredicateLeaf(PredicateLeaf.Operator.NULL_SAFE_EQUALS, PredicateLeaf.Type.DECIMAL, "x", new HiveDecimalWritable("15"), null);
        BloomFilterIO bf = new BloomFilterIO(10000L);
        for (int i = 20; i < 1000; ++i) {
            bf.addString(HiveDecimal.create((int)i).toString());
        }
        ColumnStatisticsImpl cs = ColumnStatisticsImpl.deserialize((OrcProto.ColumnStatistics)TestRecordReaderImpl.createDecimalStats("10", "200"));
        junit.framework.Assert.assertEquals((Object)SearchArgument.TruthValue.NO, (Object)RecordReaderImpl.evaluatePredicate((ColumnStatistics)cs, (PredicateLeaf)pred, (BloomFilterIO)bf));
        bf.addString(HiveDecimal.create((int)15).toString());
        junit.framework.Assert.assertEquals((Object)SearchArgument.TruthValue.YES_NO, (Object)RecordReaderImpl.evaluatePredicate((ColumnStatistics)cs, (PredicateLeaf)pred, (BloomFilterIO)bf));
    }

    @Test
    public void testDecimalEqualsBloomFilter() throws Exception {
        PredicateLeaf pred = TestSearchArgumentImpl.createPredicateLeaf(PredicateLeaf.Operator.EQUALS, PredicateLeaf.Type.DECIMAL, "x", new HiveDecimalWritable("15"), null);
        BloomFilterIO bf = new BloomFilterIO(10000L);
        for (int i = 20; i < 1000; ++i) {
            bf.addString(HiveDecimal.create((int)i).toString());
        }
        ColumnStatisticsImpl cs = ColumnStatisticsImpl.deserialize((OrcProto.ColumnStatistics)TestRecordReaderImpl.createDecimalStats("10", "200"));
        junit.framework.Assert.assertEquals((Object)SearchArgument.TruthValue.NO_NULL, (Object)RecordReaderImpl.evaluatePredicate((ColumnStatistics)cs, (PredicateLeaf)pred, (BloomFilterIO)bf));
        bf.addString(HiveDecimal.create((int)15).toString());
        junit.framework.Assert.assertEquals((Object)SearchArgument.TruthValue.YES_NO_NULL, (Object)RecordReaderImpl.evaluatePredicate((ColumnStatistics)cs, (PredicateLeaf)pred, (BloomFilterIO)bf));
    }

    @Test
    public void testDecimalInBloomFilter() throws Exception {
        ArrayList<Object> args = new ArrayList<Object>();
        args.add(new HiveDecimalWritable("15"));
        args.add(new HiveDecimalWritable("19"));
        PredicateLeaf pred = TestSearchArgumentImpl.createPredicateLeaf(PredicateLeaf.Operator.IN, PredicateLeaf.Type.DECIMAL, "x", null, args);
        BloomFilterIO bf = new BloomFilterIO(10000L);
        for (int i = 20; i < 1000; ++i) {
            bf.addString(HiveDecimal.create((int)i).toString());
        }
        ColumnStatisticsImpl cs = ColumnStatisticsImpl.deserialize((OrcProto.ColumnStatistics)TestRecordReaderImpl.createDecimalStats("10", "200"));
        junit.framework.Assert.assertEquals((Object)SearchArgument.TruthValue.NO_NULL, (Object)RecordReaderImpl.evaluatePredicate((ColumnStatistics)cs, (PredicateLeaf)pred, (BloomFilterIO)bf));
        bf.addString(HiveDecimal.create((int)19).toString());
        junit.framework.Assert.assertEquals((Object)SearchArgument.TruthValue.YES_NO_NULL, (Object)RecordReaderImpl.evaluatePredicate((ColumnStatistics)cs, (PredicateLeaf)pred, (BloomFilterIO)bf));
        bf.addString(HiveDecimal.create((int)15).toString());
        junit.framework.Assert.assertEquals((Object)SearchArgument.TruthValue.YES_NO_NULL, (Object)RecordReaderImpl.evaluatePredicate((ColumnStatistics)cs, (PredicateLeaf)pred, (BloomFilterIO)bf));
    }

    @Test
    public void testNullsInBloomFilter() throws Exception {
        ArrayList<Object> args = new ArrayList<Object>();
        args.add(new HiveDecimalWritable("15"));
        args.add(null);
        args.add(new HiveDecimalWritable("19"));
        PredicateLeaf pred = TestSearchArgumentImpl.createPredicateLeaf(PredicateLeaf.Operator.IN, PredicateLeaf.Type.DECIMAL, "x", null, args);
        BloomFilterIO bf = new BloomFilterIO(10000L);
        for (int i = 20; i < 1000; ++i) {
            bf.addString(HiveDecimal.create((int)i).toString());
        }
        ColumnStatisticsImpl cs = ColumnStatisticsImpl.deserialize((OrcProto.ColumnStatistics)TestRecordReaderImpl.createDecimalStats("10", "200", false));
        junit.framework.Assert.assertEquals((Object)SearchArgument.TruthValue.NO, (Object)RecordReaderImpl.evaluatePredicate((ColumnStatistics)cs, (PredicateLeaf)pred, (BloomFilterIO)bf));
        cs = ColumnStatisticsImpl.deserialize((OrcProto.ColumnStatistics)TestRecordReaderImpl.createDecimalStats("10", "200", true));
        junit.framework.Assert.assertEquals((Object)SearchArgument.TruthValue.YES_NO_NULL, (Object)RecordReaderImpl.evaluatePredicate((ColumnStatistics)cs, (PredicateLeaf)pred, (BloomFilterIO)bf));
        bf.addString(HiveDecimal.create((int)19).toString());
        junit.framework.Assert.assertEquals((Object)SearchArgument.TruthValue.YES_NO_NULL, (Object)RecordReaderImpl.evaluatePredicate((ColumnStatistics)cs, (PredicateLeaf)pred, (BloomFilterIO)bf));
        bf.addString(HiveDecimal.create((int)15).toString());
        junit.framework.Assert.assertEquals((Object)SearchArgument.TruthValue.YES_NO_NULL, (Object)RecordReaderImpl.evaluatePredicate((ColumnStatistics)cs, (PredicateLeaf)pred, (BloomFilterIO)bf));
    }

    static class BufferInStream
    extends InputStream
    implements PositionedReadable,
    Seekable {
        private final byte[] buffer;
        private final int length;
        private int position = 0;

        BufferInStream(byte[] bytes, int length) {
            this.buffer = bytes;
            this.length = length;
        }

        @Override
        public int read() {
            if (this.position < this.length) {
                return this.buffer[this.position++];
            }
            return -1;
        }

        @Override
        public int read(byte[] bytes, int offset, int length) {
            int lengthToRead = Math.min(length, this.length - this.position);
            if (lengthToRead >= 0) {
                for (int i = 0; i < lengthToRead; ++i) {
                    bytes[offset + i] = this.buffer[this.position++];
                }
                return lengthToRead;
            }
            return -1;
        }

        public int read(long position, byte[] bytes, int offset, int length) {
            this.position = (int)position;
            return this.read(bytes, offset, length);
        }

        public void readFully(long position, byte[] bytes, int offset, int length) throws IOException {
            this.position = (int)position;
            while (length > 0) {
                int result = this.read(bytes, offset, length);
                offset += result;
                length -= result;
                if (result >= 0) continue;
                throw new IOException("Read past end of buffer at " + offset);
            }
        }

        public void readFully(long position, byte[] bytes) throws IOException {
            this.readFully(position, bytes, 0, bytes.length);
        }

        public void seek(long position) {
            this.position = (int)position;
        }

        public long getPos() {
            return this.position;
        }

        public boolean seekToNewSource(long position) throws IOException {
            this.position = (int)position;
            return false;
        }
    }
}

