/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.io.orc;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.PrintStream;
import java.util.Random;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.ql.io.orc.CompressionKind;
import org.apache.hadoop.hive.ql.io.orc.FileDump;
import org.apache.hadoop.hive.ql.io.orc.OrcFile;
import org.apache.hadoop.hive.ql.io.orc.Writer;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspectorFactory;
import org.apache.orc.OrcFile;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TestName;

public class TestRLEv2 {
    Path workDir = new Path(System.getProperty("test.tmp.dir", "target" + File.separator + "test" + File.separator + "tmp"));
    Path testFilePath;
    Configuration conf;
    FileSystem fs;
    @Rule
    public TestName testCaseName = new TestName();

    @Before
    public void openFileSystem() throws Exception {
        this.conf = new Configuration();
        this.fs = FileSystem.getLocal((Configuration)this.conf);
        this.testFilePath = new Path(this.workDir, "TestRLEv2." + this.testCaseName.getMethodName() + ".orc");
        this.fs.delete(this.testFilePath, false);
    }

    @Test
    public void testFixedDeltaZero() throws Exception {
        ObjectInspector inspector = ObjectInspectorFactory.getReflectionObjectInspector(Integer.class, (ObjectInspectorFactory.ObjectInspectorOptions)ObjectInspectorFactory.ObjectInspectorOptions.JAVA);
        Writer w = OrcFile.createWriter((Path)this.testFilePath, (OrcFile.WriterOptions)OrcFile.writerOptions((Configuration)this.conf).compress(CompressionKind.NONE).inspector(inspector).rowIndexStride(0).encodingStrategy(OrcFile.EncodingStrategy.COMPRESSION).version(OrcFile.Version.V_0_12));
        for (int i = 0; i < 5120; ++i) {
            w.addRow((Object)123);
        }
        w.close();
        PrintStream origOut = System.out;
        ByteArrayOutputStream myOut = new ByteArrayOutputStream();
        System.setOut(new PrintStream(myOut));
        FileDump.main((String[])new String[]{this.testFilePath.toUri().toString()});
        System.out.flush();
        String outDump = new String(myOut.toByteArray());
        Assert.assertEquals((Object)true, (Object)outDump.contains("Stream: column 0 section DATA start: 3 length 50"));
        System.setOut(origOut);
    }

    @Test
    public void testFixedDeltaOne() throws Exception {
        ObjectInspector inspector = ObjectInspectorFactory.getReflectionObjectInspector(Integer.class, (ObjectInspectorFactory.ObjectInspectorOptions)ObjectInspectorFactory.ObjectInspectorOptions.JAVA);
        Writer w = OrcFile.createWriter((Path)this.testFilePath, (OrcFile.WriterOptions)OrcFile.writerOptions((Configuration)this.conf).compress(CompressionKind.NONE).inspector(inspector).rowIndexStride(0).encodingStrategy(OrcFile.EncodingStrategy.COMPRESSION).version(OrcFile.Version.V_0_12));
        for (int i = 0; i < 5120; ++i) {
            w.addRow((Object)(i % 512));
        }
        w.close();
        PrintStream origOut = System.out;
        ByteArrayOutputStream myOut = new ByteArrayOutputStream();
        System.setOut(new PrintStream(myOut));
        FileDump.main((String[])new String[]{this.testFilePath.toUri().toString()});
        System.out.flush();
        String outDump = new String(myOut.toByteArray());
        Assert.assertEquals((Object)true, (Object)outDump.contains("Stream: column 0 section DATA start: 3 length 40"));
        System.setOut(origOut);
    }

    @Test
    public void testFixedDeltaOneDescending() throws Exception {
        ObjectInspector inspector = ObjectInspectorFactory.getReflectionObjectInspector(Integer.class, (ObjectInspectorFactory.ObjectInspectorOptions)ObjectInspectorFactory.ObjectInspectorOptions.JAVA);
        Writer w = OrcFile.createWriter((Path)this.testFilePath, (OrcFile.WriterOptions)OrcFile.writerOptions((Configuration)this.conf).compress(CompressionKind.NONE).inspector(inspector).rowIndexStride(0).encodingStrategy(OrcFile.EncodingStrategy.COMPRESSION).version(OrcFile.Version.V_0_12));
        for (int i = 0; i < 5120; ++i) {
            w.addRow((Object)(512 - i % 512));
        }
        w.close();
        PrintStream origOut = System.out;
        ByteArrayOutputStream myOut = new ByteArrayOutputStream();
        System.setOut(new PrintStream(myOut));
        FileDump.main((String[])new String[]{this.testFilePath.toUri().toString()});
        System.out.flush();
        String outDump = new String(myOut.toByteArray());
        Assert.assertEquals((Object)true, (Object)outDump.contains("Stream: column 0 section DATA start: 3 length 50"));
        System.setOut(origOut);
    }

    @Test
    public void testFixedDeltaLarge() throws Exception {
        ObjectInspector inspector = ObjectInspectorFactory.getReflectionObjectInspector(Integer.class, (ObjectInspectorFactory.ObjectInspectorOptions)ObjectInspectorFactory.ObjectInspectorOptions.JAVA);
        Writer w = OrcFile.createWriter((Path)this.testFilePath, (OrcFile.WriterOptions)OrcFile.writerOptions((Configuration)this.conf).compress(CompressionKind.NONE).inspector(inspector).rowIndexStride(0).encodingStrategy(OrcFile.EncodingStrategy.COMPRESSION).version(OrcFile.Version.V_0_12));
        for (int i = 0; i < 5120; ++i) {
            w.addRow((Object)(i % 512 + i % 512 * 100));
        }
        w.close();
        PrintStream origOut = System.out;
        ByteArrayOutputStream myOut = new ByteArrayOutputStream();
        System.setOut(new PrintStream(myOut));
        FileDump.main((String[])new String[]{this.testFilePath.toUri().toString()});
        System.out.flush();
        String outDump = new String(myOut.toByteArray());
        Assert.assertEquals((Object)true, (Object)outDump.contains("Stream: column 0 section DATA start: 3 length 50"));
        System.setOut(origOut);
    }

    @Test
    public void testFixedDeltaLargeDescending() throws Exception {
        ObjectInspector inspector = ObjectInspectorFactory.getReflectionObjectInspector(Integer.class, (ObjectInspectorFactory.ObjectInspectorOptions)ObjectInspectorFactory.ObjectInspectorOptions.JAVA);
        Writer w = OrcFile.createWriter((Path)this.testFilePath, (OrcFile.WriterOptions)OrcFile.writerOptions((Configuration)this.conf).compress(CompressionKind.NONE).inspector(inspector).rowIndexStride(0).encodingStrategy(OrcFile.EncodingStrategy.COMPRESSION).version(OrcFile.Version.V_0_12));
        for (int i = 0; i < 5120; ++i) {
            w.addRow((Object)(512 - i % 512 + i % 512 * 100));
        }
        w.close();
        PrintStream origOut = System.out;
        ByteArrayOutputStream myOut = new ByteArrayOutputStream();
        System.setOut(new PrintStream(myOut));
        FileDump.main((String[])new String[]{this.testFilePath.toUri().toString()});
        System.out.flush();
        String outDump = new String(myOut.toByteArray());
        Assert.assertEquals((Object)true, (Object)outDump.contains("Stream: column 0 section DATA start: 3 length 60"));
        System.setOut(origOut);
    }

    @Test
    public void testShortRepeat() throws Exception {
        ObjectInspector inspector = ObjectInspectorFactory.getReflectionObjectInspector(Integer.class, (ObjectInspectorFactory.ObjectInspectorOptions)ObjectInspectorFactory.ObjectInspectorOptions.JAVA);
        Writer w = OrcFile.createWriter((Path)this.testFilePath, (OrcFile.WriterOptions)OrcFile.writerOptions((Configuration)this.conf).compress(CompressionKind.NONE).inspector(inspector).rowIndexStride(0).encodingStrategy(OrcFile.EncodingStrategy.COMPRESSION).version(OrcFile.Version.V_0_12));
        for (int i = 0; i < 5; ++i) {
            w.addRow((Object)10);
        }
        w.close();
        PrintStream origOut = System.out;
        ByteArrayOutputStream myOut = new ByteArrayOutputStream();
        System.setOut(new PrintStream(myOut));
        FileDump.main((String[])new String[]{this.testFilePath.toUri().toString()});
        System.out.flush();
        String outDump = new String(myOut.toByteArray());
        Assert.assertEquals((Object)true, (Object)outDump.contains("Stream: column 0 section DATA start: 3 length 2"));
        System.setOut(origOut);
    }

    @Test
    public void testDeltaUnknownSign() throws Exception {
        ObjectInspector inspector = ObjectInspectorFactory.getReflectionObjectInspector(Integer.class, (ObjectInspectorFactory.ObjectInspectorOptions)ObjectInspectorFactory.ObjectInspectorOptions.JAVA);
        Writer w = OrcFile.createWriter((Path)this.testFilePath, (OrcFile.WriterOptions)OrcFile.writerOptions((Configuration)this.conf).compress(CompressionKind.NONE).inspector(inspector).rowIndexStride(0).encodingStrategy(OrcFile.EncodingStrategy.COMPRESSION).version(OrcFile.Version.V_0_12));
        w.addRow((Object)0);
        for (int i = 0; i < 511; ++i) {
            w.addRow((Object)i);
        }
        w.close();
        PrintStream origOut = System.out;
        ByteArrayOutputStream myOut = new ByteArrayOutputStream();
        System.setOut(new PrintStream(myOut));
        FileDump.main((String[])new String[]{this.testFilePath.toUri().toString()});
        System.out.flush();
        String outDump = new String(myOut.toByteArray());
        Assert.assertEquals((Object)true, (Object)outDump.contains("Stream: column 0 section DATA start: 3 length 642"));
        System.setOut(origOut);
    }

    @Test
    public void testPatchedBase() throws Exception {
        ObjectInspector inspector = ObjectInspectorFactory.getReflectionObjectInspector(Integer.class, (ObjectInspectorFactory.ObjectInspectorOptions)ObjectInspectorFactory.ObjectInspectorOptions.JAVA);
        Writer w = OrcFile.createWriter((Path)this.testFilePath, (OrcFile.WriterOptions)OrcFile.writerOptions((Configuration)this.conf).compress(CompressionKind.NONE).inspector(inspector).rowIndexStride(0).encodingStrategy(OrcFile.EncodingStrategy.COMPRESSION).version(OrcFile.Version.V_0_12));
        Random rand = new Random(123L);
        w.addRow((Object)10000000);
        for (int i = 0; i < 511; ++i) {
            w.addRow((Object)rand.nextInt(i + 1));
        }
        w.close();
        PrintStream origOut = System.out;
        ByteArrayOutputStream myOut = new ByteArrayOutputStream();
        System.setOut(new PrintStream(myOut));
        FileDump.main((String[])new String[]{this.testFilePath.toUri().toString()});
        System.out.flush();
        String outDump = new String(myOut.toByteArray());
        Assert.assertEquals((Object)true, (Object)outDump.contains("Stream: column 0 section DATA start: 3 length 583"));
        System.setOut(origOut);
    }
}

