/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.io.orc;

import com.google.common.collect.Lists;
import java.io.File;
import java.io.IOException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.common.type.HiveDecimal;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.exec.SerializationUtilities;
import org.apache.hadoop.hive.ql.io.orc.CompressionKind;
import org.apache.hadoop.hive.ql.io.orc.OrcFile;
import org.apache.hadoop.hive.ql.io.orc.OrcInputFormat;
import org.apache.hadoop.hive.ql.io.orc.TestOrcFile;
import org.apache.hadoop.hive.ql.io.orc.Writer;
import org.apache.hadoop.hive.ql.plan.ExprNodeColumnDesc;
import org.apache.hadoop.hive.ql.plan.ExprNodeConstantDesc;
import org.apache.hadoop.hive.ql.plan.ExprNodeGenericFuncDesc;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDF;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFOPAnd;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFOPEqual;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFOPEqualOrLessThan;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspectorFactory;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapred.FileInputFormat;
import org.apache.hadoop.mapred.InputSplit;
import org.apache.hadoop.mapred.JobConf;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TestName;

public class TestOrcSplitElimination {
    Path workDir = new Path(System.getProperty("test.tmp.dir", "target" + File.separator + "test" + File.separator + "tmp"));
    JobConf conf;
    FileSystem fs;
    Path testFilePath;
    @Rule
    public TestName testCaseName = new TestName();

    @Before
    public void openFileSystem() throws Exception {
        this.conf = new JobConf();
        this.conf.set("columns", "userid,string1,subtype,decimal1,ts");
        this.conf.set("columns.types", "bigint,string,double,decimal,timestamp");
        this.conf.set("hive.io.file.read.all.columns", "false");
        this.conf.set("hive.io.file.readcolumn.ids", "0,2");
        this.conf.set("hive.io.file.readcolumn.names", "userid,subtype");
        this.fs = FileSystem.getLocal((Configuration)this.conf);
        this.testFilePath = new Path(this.workDir, "TestOrcFile." + this.testCaseName.getMethodName() + ".orc");
        this.fs.delete(this.testFilePath, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSplitEliminationSmallMaxSplit() throws Exception {
        Class<TestOrcFile> clazz = TestOrcFile.class;
        synchronized (TestOrcFile.class) {
            ObjectInspector inspector = ObjectInspectorFactory.getReflectionObjectInspector(AllTypesRow.class, (ObjectInspectorFactory.ObjectInspectorOptions)ObjectInspectorFactory.ObjectInspectorOptions.JAVA);
            // ** MonitorExit[var2_1] (shouldn't be in output)
            Writer writer = OrcFile.createWriter((FileSystem)this.fs, (Path)this.testFilePath, (Configuration)this.conf, (ObjectInspector)inspector, (long)100000L, (CompressionKind)CompressionKind.NONE, (int)10000, (int)10000);
            this.writeData(writer);
            writer.close();
            HiveConf.setLongVar((Configuration)this.conf, (HiveConf.ConfVars)HiveConf.ConfVars.MAPREDMINSPLITSIZE, (long)1000L);
            HiveConf.setLongVar((Configuration)this.conf, (HiveConf.ConfVars)HiveConf.ConfVars.MAPREDMAXSPLITSIZE, (long)5000L);
            OrcInputFormat in = new OrcInputFormat();
            FileInputFormat.setInputPaths((JobConf)this.conf, (String)this.testFilePath.toString());
            GenericUDFOPEqualOrLessThan udf = new GenericUDFOPEqualOrLessThan();
            ArrayList childExpr = Lists.newArrayList();
            ExprNodeColumnDesc col = new ExprNodeColumnDesc(Long.class, "userid", "T", false);
            ExprNodeConstantDesc con = new ExprNodeConstantDesc((Object)100);
            childExpr.add(col);
            childExpr.add(con);
            ExprNodeGenericFuncDesc en = new ExprNodeGenericFuncDesc(inspector, (GenericUDF)udf, (List)childExpr);
            String sargStr = SerializationUtilities.serializeExpression((ExprNodeGenericFuncDesc)en);
            this.conf.set("hive.io.filter.expr.serialized", sargStr);
            InputSplit[] splits = in.getSplits(this.conf, 1);
            Assert.assertEquals((long)5L, (long)splits.length);
            con = new ExprNodeConstantDesc((Object)1);
            childExpr.set(1, con);
            en = new ExprNodeGenericFuncDesc(inspector, (GenericUDF)udf, (List)childExpr);
            sargStr = SerializationUtilities.serializeExpression((ExprNodeGenericFuncDesc)en);
            this.conf.set("hive.io.filter.expr.serialized", sargStr);
            splits = in.getSplits(this.conf, 1);
            Assert.assertEquals((long)0L, (long)splits.length);
            con = new ExprNodeConstantDesc((Object)2);
            childExpr.set(1, con);
            en = new ExprNodeGenericFuncDesc(inspector, (GenericUDF)udf, (List)childExpr);
            sargStr = SerializationUtilities.serializeExpression((ExprNodeGenericFuncDesc)en);
            this.conf.set("hive.io.filter.expr.serialized", sargStr);
            splits = in.getSplits(this.conf, 1);
            Assert.assertEquals((long)1L, (long)splits.length);
            con = new ExprNodeConstantDesc((Object)5);
            childExpr.set(1, con);
            en = new ExprNodeGenericFuncDesc(inspector, (GenericUDF)udf, (List)childExpr);
            sargStr = SerializationUtilities.serializeExpression((ExprNodeGenericFuncDesc)en);
            this.conf.set("hive.io.filter.expr.serialized", sargStr);
            splits = in.getSplits(this.conf, 1);
            Assert.assertEquals((long)2L, (long)splits.length);
            con = new ExprNodeConstantDesc((Object)13);
            childExpr.set(1, con);
            en = new ExprNodeGenericFuncDesc(inspector, (GenericUDF)udf, (List)childExpr);
            sargStr = SerializationUtilities.serializeExpression((ExprNodeGenericFuncDesc)en);
            this.conf.set("hive.io.filter.expr.serialized", sargStr);
            splits = in.getSplits(this.conf, 1);
            Assert.assertEquals((long)3L, (long)splits.length);
            con = new ExprNodeConstantDesc((Object)29);
            childExpr.set(1, con);
            en = new ExprNodeGenericFuncDesc(inspector, (GenericUDF)udf, (List)childExpr);
            sargStr = SerializationUtilities.serializeExpression((ExprNodeGenericFuncDesc)en);
            this.conf.set("hive.io.filter.expr.serialized", sargStr);
            splits = in.getSplits(this.conf, 1);
            Assert.assertEquals((long)4L, (long)splits.length);
            con = new ExprNodeConstantDesc((Object)70);
            childExpr.set(1, con);
            en = new ExprNodeGenericFuncDesc(inspector, (GenericUDF)udf, (List)childExpr);
            sargStr = SerializationUtilities.serializeExpression((ExprNodeGenericFuncDesc)en);
            this.conf.set("hive.io.filter.expr.serialized", sargStr);
            splits = in.getSplits(this.conf, 1);
            Assert.assertEquals((long)5L, (long)splits.length);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSplitEliminationLargeMaxSplit() throws Exception {
        Class<TestOrcFile> clazz = TestOrcFile.class;
        synchronized (TestOrcFile.class) {
            ObjectInspector inspector = ObjectInspectorFactory.getReflectionObjectInspector(AllTypesRow.class, (ObjectInspectorFactory.ObjectInspectorOptions)ObjectInspectorFactory.ObjectInspectorOptions.JAVA);
            // ** MonitorExit[var2_1] (shouldn't be in output)
            Writer writer = OrcFile.createWriter((FileSystem)this.fs, (Path)this.testFilePath, (Configuration)this.conf, (ObjectInspector)inspector, (long)100000L, (CompressionKind)CompressionKind.NONE, (int)10000, (int)10000);
            this.writeData(writer);
            writer.close();
            HiveConf.setLongVar((Configuration)this.conf, (HiveConf.ConfVars)HiveConf.ConfVars.MAPREDMINSPLITSIZE, (long)1000L);
            HiveConf.setLongVar((Configuration)this.conf, (HiveConf.ConfVars)HiveConf.ConfVars.MAPREDMAXSPLITSIZE, (long)150000L);
            OrcInputFormat in = new OrcInputFormat();
            FileInputFormat.setInputPaths((JobConf)this.conf, (String)this.testFilePath.toString());
            GenericUDFOPEqualOrLessThan udf = new GenericUDFOPEqualOrLessThan();
            ArrayList childExpr = Lists.newArrayList();
            ExprNodeColumnDesc col = new ExprNodeColumnDesc(Long.class, "userid", "T", false);
            ExprNodeConstantDesc con = new ExprNodeConstantDesc((Object)100);
            childExpr.add(col);
            childExpr.add(con);
            ExprNodeGenericFuncDesc en = new ExprNodeGenericFuncDesc(inspector, (GenericUDF)udf, (List)childExpr);
            String sargStr = SerializationUtilities.serializeExpression((ExprNodeGenericFuncDesc)en);
            this.conf.set("hive.io.filter.expr.serialized", sargStr);
            InputSplit[] splits = in.getSplits(this.conf, 1);
            Assert.assertEquals((long)2L, (long)splits.length);
            con = new ExprNodeConstantDesc((Object)0);
            childExpr.set(1, con);
            en = new ExprNodeGenericFuncDesc(inspector, (GenericUDF)udf, (List)childExpr);
            sargStr = SerializationUtilities.serializeExpression((ExprNodeGenericFuncDesc)en);
            this.conf.set("hive.io.filter.expr.serialized", sargStr);
            splits = in.getSplits(this.conf, 1);
            Assert.assertEquals((long)0L, (long)splits.length);
            con = new ExprNodeConstantDesc((Object)2);
            childExpr.set(1, con);
            en = new ExprNodeGenericFuncDesc(inspector, (GenericUDF)udf, (List)childExpr);
            sargStr = SerializationUtilities.serializeExpression((ExprNodeGenericFuncDesc)en);
            this.conf.set("hive.io.filter.expr.serialized", sargStr);
            splits = in.getSplits(this.conf, 1);
            Assert.assertEquals((long)1L, (long)splits.length);
            con = new ExprNodeConstantDesc((Object)5);
            childExpr.set(1, con);
            en = new ExprNodeGenericFuncDesc(inspector, (GenericUDF)udf, (List)childExpr);
            sargStr = SerializationUtilities.serializeExpression((ExprNodeGenericFuncDesc)en);
            this.conf.set("hive.io.filter.expr.serialized", sargStr);
            splits = in.getSplits(this.conf, 1);
            Assert.assertEquals((long)2L, (long)splits.length);
            con = new ExprNodeConstantDesc((Object)13);
            childExpr.set(1, con);
            en = new ExprNodeGenericFuncDesc(inspector, (GenericUDF)udf, (List)childExpr);
            sargStr = SerializationUtilities.serializeExpression((ExprNodeGenericFuncDesc)en);
            this.conf.set("hive.io.filter.expr.serialized", sargStr);
            splits = in.getSplits(this.conf, 1);
            Assert.assertEquals((long)2L, (long)splits.length);
            con = new ExprNodeConstantDesc((Object)29);
            childExpr.set(1, con);
            en = new ExprNodeGenericFuncDesc(inspector, (GenericUDF)udf, (List)childExpr);
            sargStr = SerializationUtilities.serializeExpression((ExprNodeGenericFuncDesc)en);
            this.conf.set("hive.io.filter.expr.serialized", sargStr);
            splits = in.getSplits(this.conf, 1);
            Assert.assertEquals((long)2L, (long)splits.length);
            con = new ExprNodeConstantDesc((Object)70);
            childExpr.set(1, con);
            en = new ExprNodeGenericFuncDesc(inspector, (GenericUDF)udf, (List)childExpr);
            sargStr = SerializationUtilities.serializeExpression((ExprNodeGenericFuncDesc)en);
            this.conf.set("hive.io.filter.expr.serialized", sargStr);
            splits = in.getSplits(this.conf, 1);
            Assert.assertEquals((long)2L, (long)splits.length);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSplitEliminationComplexExpr() throws Exception {
        Class<TestOrcFile> clazz = TestOrcFile.class;
        synchronized (TestOrcFile.class) {
            ObjectInspector inspector = ObjectInspectorFactory.getReflectionObjectInspector(AllTypesRow.class, (ObjectInspectorFactory.ObjectInspectorOptions)ObjectInspectorFactory.ObjectInspectorOptions.JAVA);
            // ** MonitorExit[var2_1] (shouldn't be in output)
            Writer writer = OrcFile.createWriter((FileSystem)this.fs, (Path)this.testFilePath, (Configuration)this.conf, (ObjectInspector)inspector, (long)100000L, (CompressionKind)CompressionKind.NONE, (int)10000, (int)10000);
            this.writeData(writer);
            writer.close();
            HiveConf.setLongVar((Configuration)this.conf, (HiveConf.ConfVars)HiveConf.ConfVars.MAPREDMINSPLITSIZE, (long)1000L);
            HiveConf.setLongVar((Configuration)this.conf, (HiveConf.ConfVars)HiveConf.ConfVars.MAPREDMAXSPLITSIZE, (long)150000L);
            OrcInputFormat in = new OrcInputFormat();
            FileInputFormat.setInputPaths((JobConf)this.conf, (String)this.testFilePath.toString());
            GenericUDFOPEqualOrLessThan udf = new GenericUDFOPEqualOrLessThan();
            ArrayList childExpr = Lists.newArrayList();
            ExprNodeColumnDesc col = new ExprNodeColumnDesc(Long.class, "userid", "T", false);
            ExprNodeConstantDesc con = new ExprNodeConstantDesc((Object)100);
            childExpr.add(col);
            childExpr.add(con);
            ExprNodeGenericFuncDesc en = new ExprNodeGenericFuncDesc(inspector, (GenericUDF)udf, (List)childExpr);
            GenericUDFOPEqualOrLessThan udf1 = new GenericUDFOPEqualOrLessThan();
            ArrayList childExpr1 = Lists.newArrayList();
            ExprNodeColumnDesc col1 = new ExprNodeColumnDesc(Double.class, "subtype", "T", false);
            ExprNodeConstantDesc con1 = new ExprNodeConstantDesc((Object)1000.0);
            childExpr1.add(col1);
            childExpr1.add(con1);
            ExprNodeGenericFuncDesc en1 = new ExprNodeGenericFuncDesc(inspector, (GenericUDF)udf1, (List)childExpr1);
            GenericUDFOPAnd udf2 = new GenericUDFOPAnd();
            ArrayList childExpr2 = Lists.newArrayList();
            childExpr2.add(en);
            childExpr2.add(en1);
            ExprNodeGenericFuncDesc en2 = new ExprNodeGenericFuncDesc(inspector, (GenericUDF)udf2, (List)childExpr2);
            String sargStr = SerializationUtilities.serializeExpression((ExprNodeGenericFuncDesc)en2);
            this.conf.set("hive.io.filter.expr.serialized", sargStr);
            InputSplit[] splits = in.getSplits(this.conf, 1);
            Assert.assertEquals((long)2L, (long)splits.length);
            con = new ExprNodeConstantDesc((Object)2);
            childExpr.set(1, con);
            en = new ExprNodeGenericFuncDesc(inspector, (GenericUDF)udf, (List)childExpr);
            con1 = new ExprNodeConstantDesc((Object)0.0);
            childExpr1.set(1, con1);
            en1 = new ExprNodeGenericFuncDesc(inspector, (GenericUDF)udf1, (List)childExpr1);
            childExpr2.set(0, en);
            childExpr2.set(1, en1);
            en2 = new ExprNodeGenericFuncDesc(inspector, (GenericUDF)udf2, (List)childExpr2);
            sargStr = SerializationUtilities.serializeExpression((ExprNodeGenericFuncDesc)en2);
            this.conf.set("hive.io.filter.expr.serialized", sargStr);
            splits = in.getSplits(this.conf, 1);
            Assert.assertEquals((long)0L, (long)splits.length);
            con = new ExprNodeConstantDesc((Object)2);
            childExpr.set(1, con);
            en = new ExprNodeGenericFuncDesc(inspector, (GenericUDF)udf, (List)childExpr);
            con1 = new ExprNodeConstantDesc((Object)1.0);
            childExpr1.set(1, con1);
            en1 = new ExprNodeGenericFuncDesc(inspector, (GenericUDF)udf1, (List)childExpr1);
            childExpr2.set(0, en);
            childExpr2.set(1, en1);
            en2 = new ExprNodeGenericFuncDesc(inspector, (GenericUDF)udf2, (List)childExpr2);
            sargStr = SerializationUtilities.serializeExpression((ExprNodeGenericFuncDesc)en2);
            this.conf.set("hive.io.filter.expr.serialized", sargStr);
            splits = in.getSplits(this.conf, 1);
            Assert.assertEquals((long)1L, (long)splits.length);
            udf = new GenericUDFOPEqual();
            con = new ExprNodeConstantDesc((Object)13);
            childExpr.set(1, con);
            en = new ExprNodeGenericFuncDesc(inspector, (GenericUDF)udf, (List)childExpr);
            con1 = new ExprNodeConstantDesc((Object)80.0);
            childExpr1.set(1, con1);
            en1 = new ExprNodeGenericFuncDesc(inspector, (GenericUDF)udf1, (List)childExpr1);
            childExpr2.set(0, en);
            childExpr2.set(1, en1);
            en2 = new ExprNodeGenericFuncDesc(inspector, (GenericUDF)udf2, (List)childExpr2);
            sargStr = SerializationUtilities.serializeExpression((ExprNodeGenericFuncDesc)en2);
            this.conf.set("hive.io.filter.expr.serialized", sargStr);
            splits = in.getSplits(this.conf, 1);
            Assert.assertEquals((long)2L, (long)splits.length);
            udf = new GenericUDFOPEqual();
            con = new ExprNodeConstantDesc((Object)13);
            childExpr.set(1, con);
            en = new ExprNodeGenericFuncDesc(inspector, (GenericUDF)udf, (List)childExpr);
            udf1 = new GenericUDFOPEqual();
            con1 = new ExprNodeConstantDesc((Object)80.0);
            childExpr1.set(1, con1);
            en1 = new ExprNodeGenericFuncDesc(inspector, (GenericUDF)udf1, (List)childExpr1);
            childExpr2.set(0, en);
            childExpr2.set(1, en1);
            en2 = new ExprNodeGenericFuncDesc(inspector, (GenericUDF)udf2, (List)childExpr2);
            sargStr = SerializationUtilities.serializeExpression((ExprNodeGenericFuncDesc)en2);
            this.conf.set("hive.io.filter.expr.serialized", sargStr);
            splits = in.getSplits(this.conf, 1);
            Assert.assertEquals((long)1L, (long)splits.length);
            return;
        }
    }

    private void writeData(Writer writer) throws IOException {
        for (int i = 0; i < 25000; ++i) {
            if (i == 0) {
                writer.addRow((Object)new AllTypesRow(2L, "foo", 0.8, HiveDecimal.create((String)"1.2"), new Timestamp(0L)));
                continue;
            }
            if (i == 5000) {
                writer.addRow((Object)new AllTypesRow(13L, "bar", 80.0, HiveDecimal.create((String)"2.2"), new Timestamp(5000L)));
                continue;
            }
            if (i == 10000) {
                writer.addRow((Object)new AllTypesRow(29L, "cat", 8.0, HiveDecimal.create((String)"3.3"), new Timestamp(10000L)));
                continue;
            }
            if (i == 15000) {
                writer.addRow((Object)new AllTypesRow(70L, "dog", 1.8, HiveDecimal.create((String)"4.4"), new Timestamp(15000L)));
                continue;
            }
            if (i == 20000) {
                writer.addRow((Object)new AllTypesRow(5L, "eat", 0.8, HiveDecimal.create((String)"5.5"), new Timestamp(20000L)));
                continue;
            }
            writer.addRow((Object)new AllTypesRow(100L, "zebra", 8.0, HiveDecimal.create((String)"0.0"), new Timestamp(250000L)));
        }
    }

    public static class AllTypesRow {
        Long userid;
        Text string1;
        Double subtype;
        HiveDecimal decimal1;
        Timestamp ts;

        AllTypesRow(Long uid, String s1, Double d1, HiveDecimal decimal, Timestamp ts) {
            this.userid = uid;
            this.string1 = new Text(s1);
            this.subtype = d1;
            this.decimal1 = decimal;
            this.ts = ts;
        }
    }
}

