/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.io.orc;

import com.google.common.collect.Lists;
import java.io.File;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import junit.framework.Assert;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.common.type.HiveDecimal;
import org.apache.hadoop.hive.ql.io.orc.OrcFile;
import org.apache.hadoop.hive.ql.io.orc.Reader;
import org.apache.hadoop.hive.ql.io.orc.RecordReader;
import org.apache.hadoop.hive.ql.io.orc.Writer;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspectorFactory;
import org.apache.hadoop.hive.serde2.objectinspector.StructField;
import org.apache.hadoop.hive.serde2.objectinspector.StructObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.BinaryObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.StringObjectInspector;
import org.apache.hadoop.io.BytesWritable;
import org.apache.hadoop.io.Text;
import org.apache.hive.common.util.HiveTestUtils;
import org.apache.orc.BinaryColumnStatistics;
import org.apache.orc.BooleanColumnStatistics;
import org.apache.orc.ColumnStatistics;
import org.apache.orc.DoubleColumnStatistics;
import org.apache.orc.IntegerColumnStatistics;
import org.apache.orc.OrcFile;
import org.apache.orc.StringColumnStatistics;
import org.apache.orc.StripeInformation;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TestName;

public class TestOrcSerDeStats {
    Path workDir = new Path(System.getProperty("test.tmp.dir", "target" + File.separator + "test" + File.separator + "tmp"));
    Configuration conf;
    FileSystem fs;
    Path testFilePath;
    @Rule
    public TestName testCaseName = new TestName();

    private static InnerStruct inner(int i, String s) {
        return new InnerStruct(i, s);
    }

    private static Map<Text, InnerStruct> map(InnerStruct ... items) {
        HashMap<Text, InnerStruct> result = new HashMap<Text, InnerStruct>();
        for (InnerStruct i : items) {
            result.put(new Text(i.string1), i);
        }
        return result;
    }

    private static List<InnerStruct> list(InnerStruct ... items) {
        ArrayList<InnerStruct> result = new ArrayList<InnerStruct>();
        result.addAll(Arrays.asList(items));
        return result;
    }

    private static BytesWritable bytes(int ... items) {
        BytesWritable result = new BytesWritable();
        result.setSize(items.length);
        for (int i = 0; i < items.length; ++i) {
            result.getBytes()[i] = (byte)items[i];
        }
        return result;
    }

    @Before
    public void openFileSystem() throws Exception {
        this.conf = new Configuration();
        this.fs = FileSystem.getLocal((Configuration)this.conf);
        this.testFilePath = new Path(this.workDir, "TestOrcSerDeStats." + this.testCaseName.getMethodName() + ".orc");
        this.fs.delete(this.testFilePath, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testStringAndBinaryStatistics() throws Exception {
        Class<TestOrcSerDeStats> clazz = TestOrcSerDeStats.class;
        synchronized (TestOrcSerDeStats.class) {
            ObjectInspector inspector = ObjectInspectorFactory.getReflectionObjectInspector(SimpleStruct.class, (ObjectInspectorFactory.ObjectInspectorOptions)ObjectInspectorFactory.ObjectInspectorOptions.JAVA);
            // ** MonitorExit[var2_1] (shouldn't be in output)
            Writer writer = OrcFile.createWriter((Path)this.testFilePath, (OrcFile.WriterOptions)OrcFile.writerOptions((Configuration)this.conf).inspector(inspector).stripeSize(100000L).bufferSize(10000));
            writer.addRow((Object)new SimpleStruct(TestOrcSerDeStats.bytes(0, 1, 2, 3, 4), "foo"));
            writer.addRow((Object)new SimpleStruct(TestOrcSerDeStats.bytes(0, 1, 2, 3), "bar"));
            writer.addRow((Object)new SimpleStruct(TestOrcSerDeStats.bytes(0, 1, 2, 3, 4, 5), null));
            writer.addRow((Object)new SimpleStruct(null, "hi"));
            writer.close();
            Assert.assertEquals((long)4L, (long)writer.getNumberOfRows());
            Assert.assertEquals((long)273L, (long)writer.getRawDataSize());
            Reader reader = OrcFile.createReader((Path)this.testFilePath, (OrcFile.ReaderOptions)OrcFile.readerOptions((Configuration)this.conf).filesystem(this.fs));
            Assert.assertEquals((long)4L, (long)reader.getNumberOfRows());
            Assert.assertEquals((long)273L, (long)reader.getRawDataSize());
            Assert.assertEquals((long)15L, (long)reader.getRawDataSizeOfColumns((List)Lists.newArrayList((Object[])new String[]{"bytes1"})));
            Assert.assertEquals((long)258L, (long)reader.getRawDataSizeOfColumns((List)Lists.newArrayList((Object[])new String[]{"string1"})));
            Assert.assertEquals((long)273L, (long)reader.getRawDataSizeOfColumns((List)Lists.newArrayList((Object[])new String[]{"bytes1", "string1"})));
            ColumnStatistics[] stats = reader.getStatistics();
            Assert.assertEquals((long)4L, (long)stats[0].getNumberOfValues());
            Assert.assertEquals((String)"count: 4 hasNull: false", (String)stats[0].toString());
            Assert.assertEquals((long)3L, (long)stats[1].getNumberOfValues());
            Assert.assertEquals((long)15L, (long)((BinaryColumnStatistics)stats[1]).getSum());
            Assert.assertEquals((String)"count: 3 hasNull: true sum: 15", (String)stats[1].toString());
            Assert.assertEquals((long)3L, (long)stats[2].getNumberOfValues());
            Assert.assertEquals((String)"bar", (String)((StringColumnStatistics)stats[2]).getMinimum());
            Assert.assertEquals((String)"hi", (String)((StringColumnStatistics)stats[2]).getMaximum());
            Assert.assertEquals((long)8L, (long)((StringColumnStatistics)stats[2]).getSum());
            Assert.assertEquals((String)"count: 3 hasNull: true min: bar max: hi sum: 8", (String)stats[2].toString());
            StructObjectInspector readerInspector = (StructObjectInspector)reader.getObjectInspector();
            Assert.assertEquals((Object)ObjectInspector.Category.STRUCT, (Object)readerInspector.getCategory());
            Assert.assertEquals((String)"struct<bytes1:binary,string1:string>", (String)readerInspector.getTypeName());
            List fields = readerInspector.getAllStructFieldRefs();
            BinaryObjectInspector bi = (BinaryObjectInspector)readerInspector.getStructFieldRef("bytes1").getFieldObjectInspector();
            StringObjectInspector st = (StringObjectInspector)readerInspector.getStructFieldRef("string1").getFieldObjectInspector();
            RecordReader rows = reader.rows();
            Object row = rows.next(null);
            Assert.assertNotNull((Object)row);
            Assert.assertEquals((Object)TestOrcSerDeStats.bytes(0, 1, 2, 3, 4), (Object)bi.getPrimitiveWritableObject(readerInspector.getStructFieldData(row, (StructField)fields.get(0))));
            Assert.assertEquals((String)"foo", (String)st.getPrimitiveJavaObject(readerInspector.getStructFieldData(row, (StructField)fields.get(1))));
            Assert.assertEquals((boolean)true, (boolean)rows.hasNext());
            row = rows.next(row);
            Assert.assertEquals((Object)TestOrcSerDeStats.bytes(0, 1, 2, 3), (Object)bi.getPrimitiveWritableObject(readerInspector.getStructFieldData(row, (StructField)fields.get(0))));
            Assert.assertEquals((String)"bar", (String)st.getPrimitiveJavaObject(readerInspector.getStructFieldData(row, (StructField)fields.get(1))));
            Assert.assertEquals((boolean)true, (boolean)rows.hasNext());
            row = rows.next(row);
            Assert.assertEquals((Object)TestOrcSerDeStats.bytes(0, 1, 2, 3, 4, 5), (Object)bi.getPrimitiveWritableObject(readerInspector.getStructFieldData(row, (StructField)fields.get(0))));
            Assert.assertNull((Object)st.getPrimitiveJavaObject(readerInspector.getStructFieldData(row, (StructField)fields.get(1))));
            Assert.assertEquals((boolean)true, (boolean)rows.hasNext());
            row = rows.next(row);
            Assert.assertNull((Object)bi.getPrimitiveWritableObject(readerInspector.getStructFieldData(row, (StructField)fields.get(0))));
            Assert.assertEquals((String)"hi", (String)st.getPrimitiveJavaObject(readerInspector.getStructFieldData(row, (StructField)fields.get(1))));
            Assert.assertEquals((boolean)false, (boolean)rows.hasNext());
            rows.close();
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testOrcSerDeStatsList() throws Exception {
        Class<TestOrcSerDeStats> clazz = TestOrcSerDeStats.class;
        synchronized (TestOrcSerDeStats.class) {
            ObjectInspector inspector = ObjectInspectorFactory.getReflectionObjectInspector(ListStruct.class, (ObjectInspectorFactory.ObjectInspectorOptions)ObjectInspectorFactory.ObjectInspectorOptions.JAVA);
            // ** MonitorExit[var2_1] (shouldn't be in output)
            Writer writer = OrcFile.createWriter((Path)this.testFilePath, (OrcFile.WriterOptions)OrcFile.writerOptions((Configuration)this.conf).inspector(inspector).stripeSize(10000L).bufferSize(10000));
            for (int row = 0; row < 5000; ++row) {
                ArrayList<String> test = new ArrayList<String>();
                for (int i = 0; i < 1000; ++i) {
                    test.add("hi");
                }
                writer.addRow((Object)new ListStruct(test));
            }
            writer.close();
            Assert.assertEquals((long)5000L, (long)writer.getNumberOfRows());
            Assert.assertEquals((long)430000000L, (long)writer.getRawDataSize());
            Reader reader = OrcFile.createReader((Path)this.testFilePath, (OrcFile.ReaderOptions)OrcFile.readerOptions((Configuration)this.conf).filesystem(this.fs));
            Assert.assertEquals((long)5000L, (long)reader.getNumberOfRows());
            Assert.assertEquals((long)430000000L, (long)reader.getRawDataSize());
            Assert.assertEquals((long)430000000L, (long)reader.getRawDataSizeOfColumns((List)Lists.newArrayList((Object[])new String[]{"list1"})));
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testOrcSerDeStatsMap() throws Exception {
        Class<TestOrcSerDeStats> clazz = TestOrcSerDeStats.class;
        synchronized (TestOrcSerDeStats.class) {
            ObjectInspector inspector = ObjectInspectorFactory.getReflectionObjectInspector(MapStruct.class, (ObjectInspectorFactory.ObjectInspectorOptions)ObjectInspectorFactory.ObjectInspectorOptions.JAVA);
            // ** MonitorExit[var2_1] (shouldn't be in output)
            Writer writer = OrcFile.createWriter((Path)this.testFilePath, (OrcFile.WriterOptions)OrcFile.writerOptions((Configuration)this.conf).inspector(inspector).stripeSize(10000L).bufferSize(10000));
            for (int row = 0; row < 1000; ++row) {
                HashMap<String, Double> test = new HashMap<String, Double>();
                for (int i = 0; i < 10; ++i) {
                    test.put("hi" + i, 2.0);
                }
                writer.addRow((Object)new MapStruct(test));
            }
            writer.close();
            Assert.assertEquals((long)1000L, (long)writer.getNumberOfRows());
            Assert.assertEquals((long)950000L, (long)writer.getRawDataSize());
            Reader reader = OrcFile.createReader((Path)this.testFilePath, (OrcFile.ReaderOptions)OrcFile.readerOptions((Configuration)this.conf).filesystem(this.fs));
            Assert.assertEquals((long)1000L, (long)reader.getNumberOfRows());
            Assert.assertEquals((long)950000L, (long)reader.getRawDataSize());
            Assert.assertEquals((long)950000L, (long)reader.getRawDataSizeOfColumns((List)Lists.newArrayList((Object[])new String[]{"map1"})));
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testOrcSerDeStatsSimpleWithNulls() throws Exception {
        Class<TestOrcSerDeStats> clazz = TestOrcSerDeStats.class;
        synchronized (TestOrcSerDeStats.class) {
            ObjectInspector inspector = ObjectInspectorFactory.getReflectionObjectInspector(SimpleStruct.class, (ObjectInspectorFactory.ObjectInspectorOptions)ObjectInspectorFactory.ObjectInspectorOptions.JAVA);
            // ** MonitorExit[var2_1] (shouldn't be in output)
            Writer writer = OrcFile.createWriter((Path)this.testFilePath, (OrcFile.WriterOptions)OrcFile.writerOptions((Configuration)this.conf).inspector(inspector).stripeSize(10000L).bufferSize(10000));
            for (int row = 0; row < 1000; ++row) {
                if (row % 2 == 0) {
                    writer.addRow((Object)new SimpleStruct(new BytesWritable(new byte[]{1, 2, 3}), "hi"));
                    continue;
                }
                writer.addRow(null);
            }
            writer.close();
            Assert.assertEquals((long)1000L, (long)writer.getNumberOfRows());
            Assert.assertEquals((long)44500L, (long)writer.getRawDataSize());
            Reader reader = OrcFile.createReader((Path)this.testFilePath, (OrcFile.ReaderOptions)OrcFile.readerOptions((Configuration)this.conf).filesystem(this.fs));
            Assert.assertEquals((long)1000L, (long)reader.getNumberOfRows());
            Assert.assertEquals((long)44500L, (long)reader.getRawDataSize());
            Assert.assertEquals((long)1500L, (long)reader.getRawDataSizeOfColumns((List)Lists.newArrayList((Object[])new String[]{"bytes1"})));
            Assert.assertEquals((long)43000L, (long)reader.getRawDataSizeOfColumns((List)Lists.newArrayList((Object[])new String[]{"string1"})));
            Assert.assertEquals((long)44500L, (long)reader.getRawDataSizeOfColumns((List)Lists.newArrayList((Object[])new String[]{"bytes1", "string1"})));
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testOrcSerDeStatsComplex() throws Exception {
        Class<TestOrcSerDeStats> clazz = TestOrcSerDeStats.class;
        synchronized (TestOrcSerDeStats.class) {
            ObjectInspector inspector = ObjectInspectorFactory.getReflectionObjectInspector(BigRow.class, (ObjectInspectorFactory.ObjectInspectorOptions)ObjectInspectorFactory.ObjectInspectorOptions.JAVA);
            // ** MonitorExit[var2_1] (shouldn't be in output)
            Writer writer = OrcFile.createWriter((Path)this.testFilePath, (OrcFile.WriterOptions)OrcFile.writerOptions((Configuration)this.conf).inspector(inspector).stripeSize(100000L).bufferSize(10000));
            writer.addRow((Object)new BigRow(false, (byte)1, (short)1024, 65536, Long.MAX_VALUE, Float.valueOf(1.0f), -15.0, TestOrcSerDeStats.bytes(0, 1, 2, 3, 4), "hi", new MiddleStruct(TestOrcSerDeStats.inner(1, "bye"), TestOrcSerDeStats.inner(2, "sigh")), TestOrcSerDeStats.list(TestOrcSerDeStats.inner(3, "good"), TestOrcSerDeStats.inner(4, "bad")), TestOrcSerDeStats.map(new InnerStruct[0]), Timestamp.valueOf("2000-03-12 15:00:00"), HiveDecimal.create((String)"12345678.6547456")));
            writer.addRow((Object)new BigRow(true, (byte)100, (short)2048, 65536, Long.MAX_VALUE, Float.valueOf(2.0f), -5.0, TestOrcSerDeStats.bytes(new int[0]), "bye", new MiddleStruct(TestOrcSerDeStats.inner(1, "bye"), TestOrcSerDeStats.inner(2, "sigh")), TestOrcSerDeStats.list(TestOrcSerDeStats.inner(100000000, "cat"), TestOrcSerDeStats.inner(-100000, "in"), TestOrcSerDeStats.inner(1234, "hat")), TestOrcSerDeStats.map(TestOrcSerDeStats.inner(5, "chani"), TestOrcSerDeStats.inner(1, "mauddib")), Timestamp.valueOf("2000-03-11 15:00:00"), HiveDecimal.create((String)"12345678.6547452")));
            writer.close();
            long rowCount = writer.getNumberOfRows();
            long rawDataSize = writer.getRawDataSize();
            Assert.assertEquals((long)2L, (long)rowCount);
            Assert.assertEquals((long)1740L, (long)rawDataSize);
            Reader reader = OrcFile.createReader((Path)this.testFilePath, (OrcFile.ReaderOptions)OrcFile.readerOptions((Configuration)this.conf).filesystem(this.fs));
            Assert.assertEquals((long)2L, (long)reader.getNumberOfRows());
            Assert.assertEquals((long)1740L, (long)reader.getRawDataSize());
            Assert.assertEquals((long)8L, (long)reader.getRawDataSizeOfColumns((List)Lists.newArrayList((Object[])new String[]{"boolean1"})));
            Assert.assertEquals((long)8L, (long)reader.getRawDataSizeOfColumns((List)Lists.newArrayList((Object[])new String[]{"byte1"})));
            Assert.assertEquals((long)8L, (long)reader.getRawDataSizeOfColumns((List)Lists.newArrayList((Object[])new String[]{"short1"})));
            Assert.assertEquals((long)8L, (long)reader.getRawDataSizeOfColumns((List)Lists.newArrayList((Object[])new String[]{"int1"})));
            Assert.assertEquals((long)16L, (long)reader.getRawDataSizeOfColumns((List)Lists.newArrayList((Object[])new String[]{"long1"})));
            Assert.assertEquals((long)8L, (long)reader.getRawDataSizeOfColumns((List)Lists.newArrayList((Object[])new String[]{"float1"})));
            Assert.assertEquals((long)16L, (long)reader.getRawDataSizeOfColumns((List)Lists.newArrayList((Object[])new String[]{"double1"})));
            Assert.assertEquals((long)5L, (long)reader.getRawDataSizeOfColumns((List)Lists.newArrayList((Object[])new String[]{"bytes1"})));
            Assert.assertEquals((long)172L, (long)reader.getRawDataSizeOfColumns((List)Lists.newArrayList((Object[])new String[]{"string1"})));
            Assert.assertEquals((long)455L, (long)reader.getRawDataSizeOfColumns((List)Lists.newArrayList((Object[])new String[]{"list"})));
            Assert.assertEquals((long)368L, (long)reader.getRawDataSizeOfColumns((List)Lists.newArrayList((Object[])new String[]{"map"})));
            Assert.assertEquals((long)364L, (long)reader.getRawDataSizeOfColumns((List)Lists.newArrayList((Object[])new String[]{"middle"})));
            Assert.assertEquals((long)80L, (long)reader.getRawDataSizeOfColumns((List)Lists.newArrayList((Object[])new String[]{"ts"})));
            Assert.assertEquals((long)224L, (long)reader.getRawDataSizeOfColumns((List)Lists.newArrayList((Object[])new String[]{"decimal1"})));
            Assert.assertEquals((long)88L, (long)reader.getRawDataSizeOfColumns((List)Lists.newArrayList((Object[])new String[]{"ts", "int1"})));
            Assert.assertEquals((long)1195L, (long)reader.getRawDataSizeOfColumns((List)Lists.newArrayList((Object[])new String[]{"middle", "list", "map", "float1"})));
            Assert.assertEquals((long)185L, (long)reader.getRawDataSizeOfColumns((List)Lists.newArrayList((Object[])new String[]{"bytes1", "byte1", "string1"})));
            Assert.assertEquals((long)rawDataSize, (long)reader.getRawDataSizeOfColumns((List)Lists.newArrayList((Object[])new String[]{"boolean1", "byte1", "short1", "int1", "long1", "float1", "double1", "bytes1", "string1", "list", "map", "middle", "ts", "decimal1"})));
            ColumnStatistics[] stats = reader.getStatistics();
            Assert.assertEquals((long)2L, (long)stats[1].getNumberOfValues());
            Assert.assertEquals((long)1L, (long)((BooleanColumnStatistics)stats[1]).getFalseCount());
            Assert.assertEquals((long)1L, (long)((BooleanColumnStatistics)stats[1]).getTrueCount());
            Assert.assertEquals((String)"count: 2 hasNull: false true: 1", (String)stats[1].toString());
            Assert.assertEquals((long)2048L, (long)((IntegerColumnStatistics)stats[3]).getMaximum());
            Assert.assertEquals((long)1024L, (long)((IntegerColumnStatistics)stats[3]).getMinimum());
            Assert.assertEquals((boolean)true, (boolean)((IntegerColumnStatistics)stats[3]).isSumDefined());
            Assert.assertEquals((long)3072L, (long)((IntegerColumnStatistics)stats[3]).getSum());
            Assert.assertEquals((String)"count: 2 hasNull: false min: 1024 max: 2048 sum: 3072", (String)stats[3].toString());
            Assert.assertEquals((long)Long.MAX_VALUE, (long)((IntegerColumnStatistics)stats[5]).getMaximum());
            Assert.assertEquals((long)Long.MAX_VALUE, (long)((IntegerColumnStatistics)stats[5]).getMinimum());
            Assert.assertEquals((boolean)false, (boolean)((IntegerColumnStatistics)stats[5]).isSumDefined());
            Assert.assertEquals((String)"count: 2 hasNull: false min: 9223372036854775807 max: 9223372036854775807", (String)stats[5].toString());
            Assert.assertEquals((Object)-15.0, (Object)((DoubleColumnStatistics)stats[7]).getMinimum());
            Assert.assertEquals((Object)-5.0, (Object)((DoubleColumnStatistics)stats[7]).getMaximum());
            Assert.assertEquals((double)-20.0, (double)((DoubleColumnStatistics)stats[7]).getSum(), (double)1.0E-5);
            Assert.assertEquals((String)"count: 2 hasNull: false min: -15.0 max: -5.0 sum: -20.0", (String)stats[7].toString());
            Assert.assertEquals((String)"count: 2 hasNull: false min: bye max: hi sum: 5", (String)stats[9].toString());
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testOrcSerDeStatsComplexOldFormat() throws Exception {
        Class<TestOrcSerDeStats> clazz = TestOrcSerDeStats.class;
        synchronized (TestOrcSerDeStats.class) {
            ObjectInspector inspector = ObjectInspectorFactory.getReflectionObjectInspector(BigRow.class, (ObjectInspectorFactory.ObjectInspectorOptions)ObjectInspectorFactory.ObjectInspectorOptions.JAVA);
            // ** MonitorExit[var2_1] (shouldn't be in output)
            Writer writer = OrcFile.createWriter((Path)this.testFilePath, (OrcFile.WriterOptions)OrcFile.writerOptions((Configuration)this.conf).inspector(inspector).stripeSize(100000L).version(OrcFile.Version.V_0_11).bufferSize(10000));
            writer.addRow((Object)new BigRow(false, (byte)1, (short)1024, 65536, Long.MAX_VALUE, Float.valueOf(1.0f), -15.0, TestOrcSerDeStats.bytes(0, 1, 2, 3, 4), "hi", new MiddleStruct(TestOrcSerDeStats.inner(1, "bye"), TestOrcSerDeStats.inner(2, "sigh")), TestOrcSerDeStats.list(TestOrcSerDeStats.inner(3, "good"), TestOrcSerDeStats.inner(4, "bad")), TestOrcSerDeStats.map(new InnerStruct[0]), Timestamp.valueOf("2000-03-12 15:00:00"), HiveDecimal.create((String)"12345678.6547456")));
            writer.addRow((Object)new BigRow(true, (byte)100, (short)2048, 65536, Long.MAX_VALUE, Float.valueOf(2.0f), -5.0, TestOrcSerDeStats.bytes(new int[0]), "bye", new MiddleStruct(TestOrcSerDeStats.inner(1, "bye"), TestOrcSerDeStats.inner(2, "sigh")), TestOrcSerDeStats.list(TestOrcSerDeStats.inner(100000000, "cat"), TestOrcSerDeStats.inner(-100000, "in"), TestOrcSerDeStats.inner(1234, "hat")), TestOrcSerDeStats.map(TestOrcSerDeStats.inner(5, "chani"), TestOrcSerDeStats.inner(1, "mauddib")), Timestamp.valueOf("2000-03-11 15:00:00"), HiveDecimal.create((String)"12345678.6547452")));
            writer.close();
            long rowCount = writer.getNumberOfRows();
            long rawDataSize = writer.getRawDataSize();
            Assert.assertEquals((long)2L, (long)rowCount);
            Assert.assertEquals((long)1740L, (long)rawDataSize);
            Reader reader = OrcFile.createReader((Path)this.testFilePath, (OrcFile.ReaderOptions)OrcFile.readerOptions((Configuration)this.conf).filesystem(this.fs));
            Assert.assertEquals((long)2L, (long)reader.getNumberOfRows());
            Assert.assertEquals((long)1740L, (long)reader.getRawDataSize());
            Assert.assertEquals((long)8L, (long)reader.getRawDataSizeOfColumns((List)Lists.newArrayList((Object[])new String[]{"boolean1"})));
            Assert.assertEquals((long)8L, (long)reader.getRawDataSizeOfColumns((List)Lists.newArrayList((Object[])new String[]{"byte1"})));
            Assert.assertEquals((long)8L, (long)reader.getRawDataSizeOfColumns((List)Lists.newArrayList((Object[])new String[]{"short1"})));
            Assert.assertEquals((long)8L, (long)reader.getRawDataSizeOfColumns((List)Lists.newArrayList((Object[])new String[]{"int1"})));
            Assert.assertEquals((long)16L, (long)reader.getRawDataSizeOfColumns((List)Lists.newArrayList((Object[])new String[]{"long1"})));
            Assert.assertEquals((long)8L, (long)reader.getRawDataSizeOfColumns((List)Lists.newArrayList((Object[])new String[]{"float1"})));
            Assert.assertEquals((long)16L, (long)reader.getRawDataSizeOfColumns((List)Lists.newArrayList((Object[])new String[]{"double1"})));
            Assert.assertEquals((long)5L, (long)reader.getRawDataSizeOfColumns((List)Lists.newArrayList((Object[])new String[]{"bytes1"})));
            Assert.assertEquals((long)172L, (long)reader.getRawDataSizeOfColumns((List)Lists.newArrayList((Object[])new String[]{"string1"})));
            Assert.assertEquals((long)455L, (long)reader.getRawDataSizeOfColumns((List)Lists.newArrayList((Object[])new String[]{"list"})));
            Assert.assertEquals((long)368L, (long)reader.getRawDataSizeOfColumns((List)Lists.newArrayList((Object[])new String[]{"map"})));
            Assert.assertEquals((long)364L, (long)reader.getRawDataSizeOfColumns((List)Lists.newArrayList((Object[])new String[]{"middle"})));
            Assert.assertEquals((long)80L, (long)reader.getRawDataSizeOfColumns((List)Lists.newArrayList((Object[])new String[]{"ts"})));
            Assert.assertEquals((long)224L, (long)reader.getRawDataSizeOfColumns((List)Lists.newArrayList((Object[])new String[]{"decimal1"})));
            Assert.assertEquals((long)88L, (long)reader.getRawDataSizeOfColumns((List)Lists.newArrayList((Object[])new String[]{"ts", "int1"})));
            Assert.assertEquals((long)1195L, (long)reader.getRawDataSizeOfColumns((List)Lists.newArrayList((Object[])new String[]{"middle", "list", "map", "float1"})));
            Assert.assertEquals((long)185L, (long)reader.getRawDataSizeOfColumns((List)Lists.newArrayList((Object[])new String[]{"bytes1", "byte1", "string1"})));
            Assert.assertEquals((long)rawDataSize, (long)reader.getRawDataSizeOfColumns((List)Lists.newArrayList((Object[])new String[]{"boolean1", "byte1", "short1", "int1", "long1", "float1", "double1", "bytes1", "string1", "list", "map", "middle", "ts", "decimal1"})));
            ColumnStatistics[] stats = reader.getStatistics();
            Assert.assertEquals((long)2L, (long)stats[1].getNumberOfValues());
            Assert.assertEquals((long)1L, (long)((BooleanColumnStatistics)stats[1]).getFalseCount());
            Assert.assertEquals((long)1L, (long)((BooleanColumnStatistics)stats[1]).getTrueCount());
            Assert.assertEquals((String)"count: 2 hasNull: false true: 1", (String)stats[1].toString());
            Assert.assertEquals((long)2048L, (long)((IntegerColumnStatistics)stats[3]).getMaximum());
            Assert.assertEquals((long)1024L, (long)((IntegerColumnStatistics)stats[3]).getMinimum());
            Assert.assertEquals((boolean)true, (boolean)((IntegerColumnStatistics)stats[3]).isSumDefined());
            Assert.assertEquals((long)3072L, (long)((IntegerColumnStatistics)stats[3]).getSum());
            Assert.assertEquals((String)"count: 2 hasNull: false min: 1024 max: 2048 sum: 3072", (String)stats[3].toString());
            Assert.assertEquals((long)Long.MAX_VALUE, (long)((IntegerColumnStatistics)stats[5]).getMaximum());
            Assert.assertEquals((long)Long.MAX_VALUE, (long)((IntegerColumnStatistics)stats[5]).getMinimum());
            Assert.assertEquals((boolean)false, (boolean)((IntegerColumnStatistics)stats[5]).isSumDefined());
            Assert.assertEquals((String)"count: 2 hasNull: false min: 9223372036854775807 max: 9223372036854775807", (String)stats[5].toString());
            Assert.assertEquals((Object)-15.0, (Object)((DoubleColumnStatistics)stats[7]).getMinimum());
            Assert.assertEquals((Object)-5.0, (Object)((DoubleColumnStatistics)stats[7]).getMaximum());
            Assert.assertEquals((double)-20.0, (double)((DoubleColumnStatistics)stats[7]).getSum(), (double)1.0E-5);
            Assert.assertEquals((String)"count: 2 hasNull: false min: -15.0 max: -5.0 sum: -20.0", (String)stats[7].toString());
            Assert.assertEquals((long)5L, (long)((BinaryColumnStatistics)stats[8]).getSum());
            Assert.assertEquals((String)"count: 2 hasNull: false sum: 5", (String)stats[8].toString());
            Assert.assertEquals((String)"bye", (String)((StringColumnStatistics)stats[9]).getMinimum());
            Assert.assertEquals((String)"hi", (String)((StringColumnStatistics)stats[9]).getMaximum());
            Assert.assertEquals((long)5L, (long)((StringColumnStatistics)stats[9]).getSum());
            Assert.assertEquals((String)"count: 2 hasNull: false min: bye max: hi sum: 5", (String)stats[9].toString());
            return;
        }
    }

    @Test(expected=ClassCastException.class)
    public void testSerdeStatsOldFormat() throws Exception {
        Path oldFilePath = new Path(HiveTestUtils.getFileFromClasspath((String)"orc-file-11-format.orc"));
        Reader reader = OrcFile.createReader((Path)oldFilePath, (OrcFile.ReaderOptions)OrcFile.readerOptions((Configuration)this.conf).filesystem(this.fs));
        int stripeCount = 0;
        int rowCount = 0;
        long currentOffset = -1L;
        for (StripeInformation stripe : reader.getStripes()) {
            ++stripeCount;
            rowCount = (int)((long)rowCount + stripe.getNumberOfRows());
            if (currentOffset < 0L) {
                currentOffset = stripe.getOffset() + stripe.getIndexLength() + stripe.getDataLength() + stripe.getFooterLength();
                continue;
            }
            Assert.assertEquals((long)currentOffset, (long)stripe.getOffset());
            currentOffset += stripe.getIndexLength() + stripe.getDataLength() + stripe.getFooterLength();
        }
        Assert.assertEquals((long)reader.getNumberOfRows(), (long)rowCount);
        Assert.assertEquals((long)6300000L, (long)reader.getRawDataSize());
        Assert.assertEquals((int)2, (int)stripeCount);
        ColumnStatistics[] stats = reader.getStatistics();
        Assert.assertEquals((long)7500L, (long)stats[1].getNumberOfValues());
        Assert.assertEquals((long)3750L, (long)((BooleanColumnStatistics)stats[1]).getFalseCount());
        Assert.assertEquals((long)3750L, (long)((BooleanColumnStatistics)stats[1]).getTrueCount());
        Assert.assertEquals((String)"count: 7500 hasNull: true true: 3750", (String)stats[1].toString());
        Assert.assertEquals((long)2048L, (long)((IntegerColumnStatistics)stats[3]).getMaximum());
        Assert.assertEquals((long)1024L, (long)((IntegerColumnStatistics)stats[3]).getMinimum());
        Assert.assertEquals((boolean)true, (boolean)((IntegerColumnStatistics)stats[3]).isSumDefined());
        Assert.assertEquals((long)11520000L, (long)((IntegerColumnStatistics)stats[3]).getSum());
        Assert.assertEquals((String)"count: 7500 hasNull: true min: 1024 max: 2048 sum: 11520000", (String)stats[3].toString());
        Assert.assertEquals((long)Long.MAX_VALUE, (long)((IntegerColumnStatistics)stats[5]).getMaximum());
        Assert.assertEquals((long)Long.MAX_VALUE, (long)((IntegerColumnStatistics)stats[5]).getMinimum());
        Assert.assertEquals((boolean)false, (boolean)((IntegerColumnStatistics)stats[5]).isSumDefined());
        Assert.assertEquals((String)"count: 7500 hasNull: true min: 9223372036854775807 max: 9223372036854775807", (String)stats[5].toString());
        Assert.assertEquals((Object)-15.0, (Object)((DoubleColumnStatistics)stats[7]).getMinimum());
        Assert.assertEquals((Object)-5.0, (Object)((DoubleColumnStatistics)stats[7]).getMaximum());
        Assert.assertEquals((double)-75000.0, (double)((DoubleColumnStatistics)stats[7]).getSum(), (double)1.0E-5);
        Assert.assertEquals((String)"count: 7500 hasNull: true min: -15.0 max: -5.0 sum: -75000.0", (String)stats[7].toString());
        Assert.assertEquals((String)"bye", (String)((StringColumnStatistics)stats[9]).getMinimum());
        Assert.assertEquals((String)"hi", (String)((StringColumnStatistics)stats[9]).getMaximum());
        Assert.assertEquals((long)0L, (long)((StringColumnStatistics)stats[9]).getSum());
        Assert.assertEquals((String)"count: 7500 hasNull: true min: bye max: hi sum: 0", (String)stats[9].toString());
        Assert.assertEquals((String)"count: 7500 hasNull: true", (String)stats[8].toString());
        Assert.assertEquals((long)5L, (long)((BinaryColumnStatistics)stats[8]).getSum());
    }

    public static class BigRow {
        Boolean boolean1;
        Byte byte1;
        Short short1;
        Integer int1;
        Long long1;
        Float float1;
        Double double1;
        BytesWritable bytes1;
        Text string1;
        List<InnerStruct> list = new ArrayList<InnerStruct>();
        Map<Text, InnerStruct> map = new HashMap<Text, InnerStruct>();
        Timestamp ts;
        HiveDecimal decimal1;
        MiddleStruct middle;

        BigRow(Boolean b1, Byte b2, Short s1, Integer i1, Long l1, Float f1, Double d1, BytesWritable b3, String s2, MiddleStruct m1, List<InnerStruct> l2, Map<Text, InnerStruct> m2, Timestamp ts1, HiveDecimal dec1) {
            this.boolean1 = b1;
            this.byte1 = b2;
            this.short1 = s1;
            this.int1 = i1;
            this.long1 = l1;
            this.float1 = f1;
            this.double1 = d1;
            this.bytes1 = b3;
            this.string1 = s2 == null ? null : new Text(s2);
            this.middle = m1;
            this.list = l2;
            this.map = m2;
            this.ts = ts1;
            this.decimal1 = dec1;
        }
    }

    public static class MiddleStruct {
        List<InnerStruct> list = new ArrayList<InnerStruct>();

        MiddleStruct(InnerStruct ... items) {
            this.list.clear();
            this.list.addAll(Arrays.asList(items));
        }
    }

    public static class InnerStruct {
        int int1;
        Text string1 = new Text();

        InnerStruct(int int1, String string1) {
            this.int1 = int1;
            this.string1.set(string1);
        }
    }

    public static class SimpleStruct {
        BytesWritable bytes1;
        Text string1;

        SimpleStruct(BytesWritable b1, String s1) {
            this.bytes1 = b1;
            this.string1 = s1 == null ? null : new Text(s1);
        }
    }

    public static class MapStruct {
        Map<String, Double> map1;

        public MapStruct(Map<String, Double> m1) {
            this.map1 = m1;
        }
    }

    public static class ListStruct {
        List<String> list1;

        public ListStruct(List<String> l1) {
            this.list1 = l1;
        }
    }
}

