/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.io.orc;

import java.io.File;
import java.io.FileOutputStream;
import java.io.PrintStream;
import java.sql.Timestamp;
import java.util.List;
import junit.framework.Assert;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.common.type.HiveDecimal;
import org.apache.hadoop.hive.ql.io.orc.FileDump;
import org.apache.hadoop.hive.ql.io.orc.OrcFile;
import org.apache.hadoop.hive.ql.io.orc.Reader;
import org.apache.hadoop.hive.ql.io.orc.TestFileDump;
import org.apache.hadoop.hive.ql.io.orc.TestOrcFile;
import org.apache.hadoop.hive.ql.io.orc.Writer;
import org.apache.hadoop.hive.serde2.io.DateWritable;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspectorFactory;
import org.apache.hadoop.io.BytesWritable;
import org.apache.hadoop.io.Text;
import org.apache.orc.ColumnStatistics;
import org.apache.orc.DateColumnStatistics;
import org.apache.orc.DecimalColumnStatistics;
import org.apache.orc.DoubleColumnStatistics;
import org.apache.orc.IntegerColumnStatistics;
import org.apache.orc.StringColumnStatistics;
import org.apache.orc.StripeStatistics;
import org.apache.orc.TimestampColumnStatistics;
import org.apache.orc.TypeDescription;
import org.apache.orc.impl.ColumnStatisticsImpl;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TestName;

public class TestColumnStatistics {
    Path workDir = new Path(System.getProperty("test.tmp.dir", "target" + File.separator + "test" + File.separator + "tmp"));
    Configuration conf;
    FileSystem fs;
    Path testFilePath;
    @Rule
    public TestName testCaseName = new TestName();

    @Test
    public void testLongMerge() throws Exception {
        TypeDescription schema = TypeDescription.createInt();
        ColumnStatisticsImpl stats1 = ColumnStatisticsImpl.create((TypeDescription)schema);
        ColumnStatisticsImpl stats2 = ColumnStatisticsImpl.create((TypeDescription)schema);
        stats1.updateInteger(10L, 2);
        stats2.updateInteger(1L, 1);
        stats2.updateInteger(1000L, 1);
        stats1.merge(stats2);
        IntegerColumnStatistics typed = (IntegerColumnStatistics)stats1;
        Assert.assertEquals((long)1L, (long)typed.getMinimum());
        Assert.assertEquals((long)1000L, (long)typed.getMaximum());
        stats1.reset();
        stats1.updateInteger(-10L, 1);
        stats1.updateInteger(10000L, 1);
        stats1.merge(stats2);
        Assert.assertEquals((long)-10L, (long)typed.getMinimum());
        Assert.assertEquals((long)10000L, (long)typed.getMaximum());
    }

    @Test
    public void testDoubleMerge() throws Exception {
        TypeDescription schema = TypeDescription.createDouble();
        ColumnStatisticsImpl stats1 = ColumnStatisticsImpl.create((TypeDescription)schema);
        ColumnStatisticsImpl stats2 = ColumnStatisticsImpl.create((TypeDescription)schema);
        stats1.updateDouble(10.0);
        stats1.updateDouble(100.0);
        stats2.updateDouble(1.0);
        stats2.updateDouble(1000.0);
        stats1.merge(stats2);
        DoubleColumnStatistics typed = (DoubleColumnStatistics)stats1;
        Assert.assertEquals((double)1.0, (double)typed.getMinimum(), (double)0.001);
        Assert.assertEquals((double)1000.0, (double)typed.getMaximum(), (double)0.001);
        stats1.reset();
        stats1.updateDouble(-10.0);
        stats1.updateDouble(10000.0);
        stats1.merge(stats2);
        Assert.assertEquals((double)-10.0, (double)typed.getMinimum(), (double)0.001);
        Assert.assertEquals((double)10000.0, (double)typed.getMaximum(), (double)0.001);
    }

    @Test
    public void testStringMerge() throws Exception {
        TypeDescription schema = TypeDescription.createString();
        ColumnStatisticsImpl stats1 = ColumnStatisticsImpl.create((TypeDescription)schema);
        ColumnStatisticsImpl stats2 = ColumnStatisticsImpl.create((TypeDescription)schema);
        stats1.updateString(new Text("bob"));
        stats1.updateString(new Text("david"));
        stats1.updateString(new Text("charles"));
        stats2.updateString(new Text("anne"));
        byte[] erin = new byte[]{0, 1, 2, 3, 4, 5, 101, 114, 105, 110};
        stats2.updateString(erin, 6, 4, 5);
        Assert.assertEquals((long)24L, (long)((StringColumnStatistics)stats2).getSum());
        stats1.merge(stats2);
        StringColumnStatistics typed = (StringColumnStatistics)stats1;
        Assert.assertEquals((String)"anne", (String)typed.getMinimum());
        Assert.assertEquals((String)"erin", (String)typed.getMaximum());
        Assert.assertEquals((long)39L, (long)typed.getSum());
        stats1.reset();
        stats1.updateString(new Text("aaa"));
        stats1.updateString(new Text("zzz"));
        stats1.merge(stats2);
        Assert.assertEquals((String)"aaa", (String)typed.getMinimum());
        Assert.assertEquals((String)"zzz", (String)typed.getMaximum());
    }

    @Test
    public void testDateMerge() throws Exception {
        TypeDescription schema = TypeDescription.createDate();
        ColumnStatisticsImpl stats1 = ColumnStatisticsImpl.create((TypeDescription)schema);
        ColumnStatisticsImpl stats2 = ColumnStatisticsImpl.create((TypeDescription)schema);
        stats1.updateDate(new DateWritable(1000));
        stats1.updateDate(new DateWritable(100));
        stats2.updateDate(new DateWritable(10));
        stats2.updateDate(new DateWritable(2000));
        stats1.merge(stats2);
        DateColumnStatistics typed = (DateColumnStatistics)stats1;
        Assert.assertEquals((Object)new DateWritable(10).get(), (Object)typed.getMinimum());
        Assert.assertEquals((Object)new DateWritable(2000).get(), (Object)typed.getMaximum());
        stats1.reset();
        stats1.updateDate(new DateWritable(-10));
        stats1.updateDate(new DateWritable(10000));
        stats1.merge(stats2);
        Assert.assertEquals((Object)new DateWritable(-10).get(), (Object)typed.getMinimum());
        Assert.assertEquals((Object)new DateWritable(10000).get(), (Object)typed.getMaximum());
    }

    @Test
    public void testTimestampMerge() throws Exception {
        TypeDescription schema = TypeDescription.createTimestamp();
        ColumnStatisticsImpl stats1 = ColumnStatisticsImpl.create((TypeDescription)schema);
        ColumnStatisticsImpl stats2 = ColumnStatisticsImpl.create((TypeDescription)schema);
        stats1.updateTimestamp(new Timestamp(10L));
        stats1.updateTimestamp(new Timestamp(100L));
        stats2.updateTimestamp(new Timestamp(1L));
        stats2.updateTimestamp(new Timestamp(1000L));
        stats1.merge(stats2);
        TimestampColumnStatistics typed = (TimestampColumnStatistics)stats1;
        Assert.assertEquals((long)1L, (long)typed.getMinimum().getTime());
        Assert.assertEquals((long)1000L, (long)typed.getMaximum().getTime());
        stats1.reset();
        stats1.updateTimestamp(new Timestamp(-10L));
        stats1.updateTimestamp(new Timestamp(10000L));
        stats1.merge(stats2);
        Assert.assertEquals((long)-10L, (long)typed.getMinimum().getTime());
        Assert.assertEquals((long)10000L, (long)typed.getMaximum().getTime());
    }

    @Test
    public void testDecimalMerge() throws Exception {
        TypeDescription schema = TypeDescription.createDecimal().withPrecision(38).withScale(16);
        ColumnStatisticsImpl stats1 = ColumnStatisticsImpl.create((TypeDescription)schema);
        ColumnStatisticsImpl stats2 = ColumnStatisticsImpl.create((TypeDescription)schema);
        stats1.updateDecimal(HiveDecimal.create((int)10));
        stats1.updateDecimal(HiveDecimal.create((int)100));
        stats2.updateDecimal(HiveDecimal.create((int)1));
        stats2.updateDecimal(HiveDecimal.create((int)1000));
        stats1.merge(stats2);
        DecimalColumnStatistics typed = (DecimalColumnStatistics)stats1;
        Assert.assertEquals((long)1L, (long)typed.getMinimum().longValue());
        Assert.assertEquals((long)1000L, (long)typed.getMaximum().longValue());
        stats1.reset();
        stats1.updateDecimal(HiveDecimal.create((int)-10));
        stats1.updateDecimal(HiveDecimal.create((int)10000));
        stats1.merge(stats2);
        Assert.assertEquals((long)-10L, (long)typed.getMinimum().longValue());
        Assert.assertEquals((long)10000L, (long)typed.getMaximum().longValue());
    }

    @Before
    public void openFileSystem() throws Exception {
        this.conf = new Configuration();
        this.fs = FileSystem.getLocal((Configuration)this.conf);
        this.fs.setWorkingDirectory(this.workDir);
        this.testFilePath = new Path("TestOrcFile." + this.testCaseName.getMethodName() + ".orc");
        this.fs.delete(this.testFilePath, false);
    }

    private static BytesWritable bytes(int ... items) {
        BytesWritable result = new BytesWritable();
        result.setSize(items.length);
        for (int i = 0; i < items.length; ++i) {
            result.getBytes()[i] = (byte)items[i];
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testHasNull() throws Exception {
        Class<TestOrcFile> clazz = TestOrcFile.class;
        synchronized (TestOrcFile.class) {
            int i;
            ObjectInspector inspector = ObjectInspectorFactory.getReflectionObjectInspector(SimpleStruct.class, (ObjectInspectorFactory.ObjectInspectorOptions)ObjectInspectorFactory.ObjectInspectorOptions.JAVA);
            // ** MonitorExit[var2_1] (shouldn't be in output)
            Writer writer = OrcFile.createWriter((Path)this.testFilePath, (OrcFile.WriterOptions)OrcFile.writerOptions((Configuration)this.conf).inspector(inspector).rowIndexStride(1000).stripeSize(10000L).bufferSize(10000));
            for (i = 0; i < 1000; ++i) {
                writer.addRow((Object)new SimpleStruct(TestColumnStatistics.bytes(1, 2, 3), "RG1"));
            }
            for (i = 0; i < 1000; ++i) {
                writer.addRow((Object)new SimpleStruct(TestColumnStatistics.bytes(1, 2, 3), null));
            }
            for (i = 0; i < 1000; ++i) {
                writer.addRow((Object)new SimpleStruct(TestColumnStatistics.bytes(1, 2, 3), "RG3"));
            }
            for (i = 0; i < 1000; ++i) {
                writer.addRow((Object)new SimpleStruct(TestColumnStatistics.bytes(1, 2, 3), null));
            }
            for (i = 0; i < 1000; ++i) {
                writer.addRow((Object)new SimpleStruct(TestColumnStatistics.bytes(1, 2, 3), null));
            }
            for (i = 0; i < 5000; ++i) {
                writer.addRow((Object)new SimpleStruct(TestColumnStatistics.bytes(1, 2, 3), null));
            }
            for (i = 0; i < 5000; ++i) {
                writer.addRow((Object)new SimpleStruct(TestColumnStatistics.bytes(1, 2, 3), "STRIPE-3"));
            }
            for (i = 0; i < 5000; ++i) {
                writer.addRow((Object)new SimpleStruct(TestColumnStatistics.bytes(1, 2, 3), null));
            }
            writer.close();
            Reader reader = OrcFile.createReader((Path)this.testFilePath, (OrcFile.ReaderOptions)OrcFile.readerOptions((Configuration)this.conf).filesystem(this.fs));
            ColumnStatistics[] stats = reader.getStatistics();
            Assert.assertEquals((long)20000L, (long)stats[0].getNumberOfValues());
            Assert.assertEquals((long)20000L, (long)stats[1].getNumberOfValues());
            Assert.assertEquals((long)7000L, (long)stats[2].getNumberOfValues());
            Assert.assertEquals((boolean)false, (boolean)stats[0].hasNull());
            Assert.assertEquals((boolean)false, (boolean)stats[1].hasNull());
            Assert.assertEquals((boolean)true, (boolean)stats[2].hasNull());
            List stripeStats = reader.getStripeStatistics();
            StripeStatistics ss1 = (StripeStatistics)stripeStats.get(0);
            ColumnStatistics ss1_cs1 = ss1.getColumnStatistics()[0];
            ColumnStatistics ss1_cs2 = ss1.getColumnStatistics()[1];
            ColumnStatistics ss1_cs3 = ss1.getColumnStatistics()[2];
            Assert.assertEquals((boolean)false, (boolean)ss1_cs1.hasNull());
            Assert.assertEquals((boolean)false, (boolean)ss1_cs2.hasNull());
            Assert.assertEquals((boolean)true, (boolean)ss1_cs3.hasNull());
            StripeStatistics ss2 = (StripeStatistics)stripeStats.get(1);
            ColumnStatistics ss2_cs1 = ss2.getColumnStatistics()[0];
            ColumnStatistics ss2_cs2 = ss2.getColumnStatistics()[1];
            ColumnStatistics ss2_cs3 = ss2.getColumnStatistics()[2];
            Assert.assertEquals((boolean)false, (boolean)ss2_cs1.hasNull());
            Assert.assertEquals((boolean)false, (boolean)ss2_cs2.hasNull());
            Assert.assertEquals((boolean)true, (boolean)ss2_cs3.hasNull());
            StripeStatistics ss3 = (StripeStatistics)stripeStats.get(2);
            ColumnStatistics ss3_cs1 = ss3.getColumnStatistics()[0];
            ColumnStatistics ss3_cs2 = ss3.getColumnStatistics()[1];
            ColumnStatistics ss3_cs3 = ss3.getColumnStatistics()[2];
            Assert.assertEquals((boolean)false, (boolean)ss3_cs1.hasNull());
            Assert.assertEquals((boolean)false, (boolean)ss3_cs2.hasNull());
            Assert.assertEquals((boolean)false, (boolean)ss3_cs3.hasNull());
            StripeStatistics ss4 = (StripeStatistics)stripeStats.get(3);
            ColumnStatistics ss4_cs1 = ss4.getColumnStatistics()[0];
            ColumnStatistics ss4_cs2 = ss4.getColumnStatistics()[1];
            ColumnStatistics ss4_cs3 = ss4.getColumnStatistics()[2];
            Assert.assertEquals((boolean)false, (boolean)ss4_cs1.hasNull());
            Assert.assertEquals((boolean)false, (boolean)ss4_cs2.hasNull());
            Assert.assertEquals((boolean)true, (boolean)ss4_cs3.hasNull());
            PrintStream origOut = System.out;
            String outputFilename = "orc-file-has-null.out";
            FileOutputStream myOut = new FileOutputStream(this.workDir + File.separator + outputFilename);
            System.setOut(new PrintStream(myOut));
            FileDump.main((String[])new String[]{this.testFilePath.toString(), "--rowindex=2"});
            System.out.flush();
            System.setOut(origOut);
            TestFileDump.checkOutput(outputFilename, this.workDir + File.separator + outputFilename);
            return;
        }
    }

    public static class SimpleStruct {
        BytesWritable bytes1;
        Text string1;

        SimpleStruct(BytesWritable b1, String s1) {
            this.bytes1 = b1;
            this.string1 = s1 == null ? null : new Text(s1);
        }
    }
}

