/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.io;

import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.Random;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.LocalFileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.io.RCFile;
import org.apache.hadoop.hive.ql.io.RCFileInputFormat;
import org.apache.hadoop.hive.ql.io.RCFileOutputFormat;
import org.apache.hadoop.hive.ql.io.RCFileRecordReader;
import org.apache.hadoop.hive.serde2.ColumnProjectionUtils;
import org.apache.hadoop.hive.serde2.Deserializer;
import org.apache.hadoop.hive.serde2.SerDeException;
import org.apache.hadoop.hive.serde2.SerDeUtils;
import org.apache.hadoop.hive.serde2.columnar.BytesRefArrayWritable;
import org.apache.hadoop.hive.serde2.columnar.BytesRefWritable;
import org.apache.hadoop.hive.serde2.columnar.ColumnarSerDe;
import org.apache.hadoop.hive.serde2.io.ByteWritable;
import org.apache.hadoop.hive.serde2.io.DoubleWritable;
import org.apache.hadoop.hive.serde2.io.ShortWritable;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspectorUtils;
import org.apache.hadoop.hive.serde2.objectinspector.StructField;
import org.apache.hadoop.hive.serde2.objectinspector.StructObjectInspector;
import org.apache.hadoop.io.IntWritable;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.io.compress.CompressionCodec;
import org.apache.hadoop.io.compress.DefaultCodec;
import org.apache.hadoop.mapred.FileSplit;
import org.apache.hadoop.mapred.InputSplit;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.RecordReader;
import org.apache.hadoop.mapred.Reporter;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestRCFile {
    private static final Logger LOG = LoggerFactory.getLogger(TestRCFile.class);
    private Configuration conf;
    private ColumnarSerDe serDe;
    private Path dir;
    private Path file;
    private FileSystem fs;
    private Properties tbl;
    private final Writable[] expectedFieldsData = new Writable[]{new ByteWritable(123), new ShortWritable(456), new IntWritable(789), new LongWritable(1000L), new DoubleWritable(5.3), new Text("hive and hadoop"), null, null};
    private final Object[] expectedPartitalFieldsData = new Object[]{null, null, new IntWritable(789), new LongWritable(1000L), null, null, null, null};
    private final BytesRefArrayWritable patialS = new BytesRefArrayWritable();
    private byte[][] bytesArray;
    private BytesRefArrayWritable s;

    @Before
    public void setup() throws Exception {
        this.conf = new Configuration();
        ColumnProjectionUtils.setReadAllColumns((Configuration)this.conf);
        this.fs = FileSystem.getLocal((Configuration)this.conf);
        this.dir = new Path(System.getProperty("test.tmp.dir", ".") + "/mapred");
        this.file = new Path(this.dir, "test_rcfile");
        this.cleanup();
        this.serDe = new ColumnarSerDe();
        this.tbl = TestRCFile.createProperties();
        SerDeUtils.initializeSerDe((Deserializer)this.serDe, (Configuration)this.conf, (Properties)this.tbl, null);
        try {
            this.bytesArray = new byte[][]{"123".getBytes("UTF-8"), "456".getBytes("UTF-8"), "789".getBytes("UTF-8"), "1000".getBytes("UTF-8"), "5.3".getBytes("UTF-8"), "hive and hadoop".getBytes("UTF-8"), new byte[0], "NULL".getBytes("UTF-8")};
            this.s = new BytesRefArrayWritable(this.bytesArray.length);
            this.s.set(0, new BytesRefWritable("123".getBytes("UTF-8")));
            this.s.set(1, new BytesRefWritable("456".getBytes("UTF-8")));
            this.s.set(2, new BytesRefWritable("789".getBytes("UTF-8")));
            this.s.set(3, new BytesRefWritable("1000".getBytes("UTF-8")));
            this.s.set(4, new BytesRefWritable("5.3".getBytes("UTF-8")));
            this.s.set(5, new BytesRefWritable("hive and hadoop".getBytes("UTF-8")));
            this.s.set(6, new BytesRefWritable("NULL".getBytes("UTF-8")));
            this.s.set(7, new BytesRefWritable("NULL".getBytes("UTF-8")));
            this.patialS.set(0, new BytesRefWritable("NULL".getBytes("UTF-8")));
            this.patialS.set(1, new BytesRefWritable("NULL".getBytes("UTF-8")));
            this.patialS.set(2, new BytesRefWritable("789".getBytes("UTF-8")));
            this.patialS.set(3, new BytesRefWritable("1000".getBytes("UTF-8")));
            this.patialS.set(4, new BytesRefWritable("NULL".getBytes("UTF-8")));
            this.patialS.set(5, new BytesRefWritable("".getBytes("UTF-8")));
            this.patialS.set(6, new BytesRefWritable("NULL".getBytes("UTF-8")));
            this.patialS.set(7, new BytesRefWritable("".getBytes("UTF-8")));
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    @After
    public void teardown() throws Exception {
        this.cleanup();
    }

    private void cleanup() throws IOException {
        if (this.fs != null && this.dir != null) {
            this.fs.delete(this.dir, true);
            if (this.fs.exists(this.dir)) {
                throw new RuntimeException("Could not delete " + this.dir);
            }
        }
    }

    @Test
    public void testSimpleReadAndWrite() throws IOException, SerDeException {
        BytesRefWritable cu;
        int i;
        this.cleanup();
        byte[][] record_1 = new byte[][]{"123".getBytes("UTF-8"), "456".getBytes("UTF-8"), "789".getBytes("UTF-8"), "1000".getBytes("UTF-8"), "5.3".getBytes("UTF-8"), "hive and hadoop".getBytes("UTF-8"), new byte[0], "NULL".getBytes("UTF-8")};
        byte[][] record_2 = new byte[][]{"100".getBytes("UTF-8"), "200".getBytes("UTF-8"), "123".getBytes("UTF-8"), "1000".getBytes("UTF-8"), "5.3".getBytes("UTF-8"), "hive and hadoop".getBytes("UTF-8"), new byte[0], "NULL".getBytes("UTF-8")};
        RCFileOutputFormat.setColumnNumber((Configuration)this.conf, (int)this.expectedFieldsData.length);
        RCFile.Writer writer = new RCFile.Writer(this.fs, this.conf, this.file, null, RCFile.createMetadata((Text[])new Text[]{new Text("apple"), new Text("block"), new Text("cat"), new Text("dog")}), (CompressionCodec)new DefaultCodec());
        BytesRefArrayWritable bytes = new BytesRefArrayWritable(record_1.length);
        for (i = 0; i < record_1.length; ++i) {
            cu = new BytesRefWritable(record_1[i], 0, record_1[i].length);
            bytes.set(i, cu);
        }
        writer.append((Writable)bytes);
        bytes.clear();
        for (i = 0; i < record_2.length; ++i) {
            cu = new BytesRefWritable(record_2[i], 0, record_2[i].length);
            bytes.set(i, cu);
        }
        writer.append((Writable)bytes);
        writer.close();
        Object[] expectedRecord_1 = new Object[]{new ByteWritable(123), new ShortWritable(456), new IntWritable(789), new LongWritable(1000L), new DoubleWritable(5.3), new Text("hive and hadoop"), null, null};
        Object[] expectedRecord_2 = new Object[]{new ByteWritable(100), new ShortWritable(200), new IntWritable(123), new LongWritable(1000L), new DoubleWritable(5.3), new Text("hive and hadoop"), null, null};
        RCFile.Reader reader = new RCFile.Reader(this.fs, this.file, this.conf);
        Assert.assertEquals((Object)new Text("block"), (Object)reader.getMetadata().get(new Text("apple")));
        Assert.assertEquals((Object)new Text("block"), (Object)reader.getMetadataValueOf(new Text("apple")));
        Assert.assertEquals((Object)new Text("dog"), (Object)reader.getMetadataValueOf(new Text("cat")));
        LongWritable rowID = new LongWritable();
        for (int i2 = 0; i2 < 2; ++i2) {
            reader.next(rowID);
            BytesRefArrayWritable cols = new BytesRefArrayWritable();
            reader.getCurrentRow(cols);
            cols.resetValid(8);
            Object row = this.serDe.deserialize((Writable)cols);
            StructObjectInspector oi = (StructObjectInspector)this.serDe.getObjectInspector();
            List fieldRefs = oi.getAllStructFieldRefs();
            Assert.assertEquals((String)"Field size should be 8", (long)8L, (long)fieldRefs.size());
            for (int j = 0; j < fieldRefs.size(); ++j) {
                Object fieldData = oi.getStructFieldData(row, (StructField)fieldRefs.get(j));
                Object standardWritableData = ObjectInspectorUtils.copyToStandardObject((Object)fieldData, (ObjectInspector)((StructField)fieldRefs.get(j)).getFieldObjectInspector(), (ObjectInspectorUtils.ObjectInspectorCopyOption)ObjectInspectorUtils.ObjectInspectorCopyOption.WRITABLE);
                if (i2 == 0) {
                    Assert.assertEquals((String)("Field " + i2), (Object)standardWritableData, (Object)expectedRecord_1[j]);
                    continue;
                }
                Assert.assertEquals((String)("Field " + i2), (Object)standardWritableData, (Object)expectedRecord_2[j]);
            }
        }
        reader.close();
    }

    @Test
    public void testGetColumn() throws IOException {
        BytesRefWritable cu;
        int i;
        this.cleanup();
        RCFileOutputFormat.setColumnNumber((Configuration)this.conf, (int)this.expectedFieldsData.length);
        RCFile.Writer writer = new RCFile.Writer(this.fs, this.conf, this.file, null, RCFile.createMetadata((Text[])new Text[]{new Text("apple"), new Text("block"), new Text("cat"), new Text("dog")}), (CompressionCodec)new DefaultCodec());
        byte[][] record_1 = new byte[][]{"123".getBytes("UTF-8"), "456".getBytes("UTF-8"), "789".getBytes("UTF-8"), "1000".getBytes("UTF-8"), "5.3".getBytes("UTF-8"), "hive and hadoop".getBytes("UTF-8"), new byte[0], "NULL".getBytes("UTF-8")};
        byte[][] record_2 = new byte[][]{"100".getBytes("UTF-8"), "200".getBytes("UTF-8"), "123".getBytes("UTF-8"), "1000".getBytes("UTF-8"), "5.3".getBytes("UTF-8"), "hive and hadoop".getBytes("UTF-8"), new byte[0], "NULL".getBytes("UTF-8")};
        BytesRefArrayWritable bytes = new BytesRefArrayWritable(record_1.length);
        for (i = 0; i < record_1.length; ++i) {
            cu = new BytesRefWritable(record_1[i], 0, record_1[i].length);
            bytes.set(i, cu);
        }
        writer.append((Writable)bytes);
        bytes.clear();
        for (i = 0; i < record_2.length; ++i) {
            cu = new BytesRefWritable(record_2[i], 0, record_2[i].length);
            bytes.set(i, cu);
        }
        writer.append((Writable)bytes);
        writer.close();
        RCFile.Reader reader = new RCFile.Reader(this.fs, this.file, this.conf);
        LongWritable rowID = new LongWritable();
        Assert.assertTrue((boolean)reader.next(rowID));
        Assert.assertEquals((long)rowID.get(), (long)0L);
        Assert.assertTrue((boolean)reader.next(rowID));
        Assert.assertEquals((long)rowID.get(), (long)1L);
        BytesRefArrayWritable result = null;
        for (int col = 0; col < 8; ++col) {
            BytesRefArrayWritable result2 = reader.getColumn(col, result);
            if (result == null) {
                Assert.assertNotNull((Object)result2);
                result = result2;
            } else {
                Assert.assertSame((Object)result2, result);
            }
            Assert.assertEquals((long)2L, (long)result.size());
            for (int row = 0; row < result.size(); ++row) {
                BytesRefWritable brw = result.get(row);
                int start = brw.getStart();
                int len = brw.getLength();
                byte[] actualData = Arrays.copyOfRange(brw.getData(), start, start + len);
                byte[] expectedData = row == 0 ? record_1[col] : record_2[col];
                Assert.assertArrayEquals((String)("col=" + col + " : row=" + row), (byte[])expectedData, (byte[])actualData);
            }
            result.clear();
        }
        reader.close();
    }

    @Test
    public void testReadCorruptFile() throws IOException, SerDeException {
        boolean more;
        this.cleanup();
        byte[][] record = new byte[][]{null, null, null, null, null, null, null, null};
        RCFileOutputFormat.setColumnNumber((Configuration)this.conf, (int)this.expectedFieldsData.length);
        RCFile.Writer writer = new RCFile.Writer(this.fs, this.conf, this.file, null, (CompressionCodec)new DefaultCodec());
        BytesRefArrayWritable bytes = new BytesRefArrayWritable(record.length);
        int recCount = 100;
        Random rand = new Random();
        for (int recIdx = 0; recIdx < 100; ++recIdx) {
            int i;
            for (i = 0; i < record.length; ++i) {
                record[i] = new Integer(rand.nextInt()).toString().getBytes("UTF-8");
            }
            for (i = 0; i < record.length; ++i) {
                BytesRefWritable cu = new BytesRefWritable(record[i], 0, record[i].length);
                bytes.set(i, cu);
            }
            writer.append((Writable)bytes);
            bytes.clear();
        }
        writer.close();
        RandomAccessFile raf = new RandomAccessFile(this.file.toUri().getPath(), "rw");
        long corruptOffset = raf.length() / 2L;
        LOG.info("corrupting " + raf + " at offset " + corruptOffset);
        raf.seek(corruptOffset);
        raf.writeBytes("junkjunkjunkjunkjunkjunkjunkjunk");
        raf.close();
        Configuration tmpConf = new Configuration(this.conf);
        tmpConf.setBoolean("hive.io.rcfile.tolerate.corruptions", true);
        RCFile.Reader reader = new RCFile.Reader(this.fs, this.file, tmpConf);
        LongWritable rowID = new LongWritable();
        while (more = reader.next(rowID)) {
            BytesRefArrayWritable cols = new BytesRefArrayWritable();
            reader.getCurrentRow(cols);
            cols.resetValid(8);
        }
        reader.close();
    }

    @Test
    public void testReadOldFileHeader() throws IOException {
        String[] row = new String[]{"Tester", "Bart", "333 X St.", "Reno", "NV", "USA"};
        RCFile.Reader reader = new RCFile.Reader(this.fs, new Path("src/test/data/rc-file-v0.rc"), this.conf);
        LongWritable rowID = new LongWritable();
        BytesRefArrayWritable cols = new BytesRefArrayWritable();
        Assert.assertTrue((String)"old file reader first row", (boolean)reader.next(rowID));
        reader.getCurrentRow(cols);
        Assert.assertEquals((long)row.length, (long)cols.size());
        for (int i = 0; i < cols.size(); ++i) {
            Assert.assertEquals((Object)row[i], (Object)new String(cols.get(i).getBytesCopy()));
        }
        Assert.assertFalse((String)"old file reader end", (boolean)reader.next(rowID));
        reader.close();
    }

    @Test
    public void testWriteAndFullyRead() throws IOException, SerDeException {
        this.writeTest(this.fs, 10000, this.file, this.bytesArray);
        this.fullyReadTest(this.fs, 10000, this.file);
    }

    @Test
    public void testWriteAndPartialRead() throws IOException, SerDeException {
        this.writeTest(this.fs, 10000, this.file, this.bytesArray);
        this.partialReadTest(this.fs, 10000, this.file);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws Exception {
        int count = 10000;
        boolean create = true;
        Configuration conf = new Configuration();
        LocalFileSystem fs = FileSystem.getLocal((Configuration)conf);
        Path file = null;
        ColumnarSerDe serDe = new ColumnarSerDe();
        Properties tbl = TestRCFile.createProperties();
        SerDeUtils.initializeSerDe((Deserializer)serDe, (Configuration)conf, (Properties)tbl, null);
        String usage = "Usage: RCFile [-count N] file";
        if (args.length == 0) {
            System.err.println(usage);
            System.exit(-1);
        }
        try {
            for (int i = 0; i < args.length; ++i) {
                if (args[i] == null) continue;
                if (args[i].equals("-count")) {
                    count = Integer.parseInt(args[++i]);
                    continue;
                }
                file = new Path(args[i]);
            }
            if (file == null) {
                System.err.println(usage);
                System.exit(-1);
            }
            LOG.info("count = " + count);
            LOG.info("create = " + create);
            LOG.info("file = " + file);
            TestRCFile test = new TestRCFile();
            test.testSimpleReadAndWrite();
            byte[][] bytesArray = new byte[][]{"123".getBytes("UTF-8"), "456".getBytes("UTF-8"), "789".getBytes("UTF-8"), "1000".getBytes("UTF-8"), "5.3".getBytes("UTF-8"), "hive and hadoop".getBytes("UTF-8"), new byte[0], "NULL".getBytes("UTF-8")};
            test.writeTest((FileSystem)fs, count, file, bytesArray);
            test.fullyReadTest((FileSystem)fs, count, file);
            test.partialReadTest((FileSystem)fs, count, file);
            System.out.println("Finished.");
        }
        finally {
            fs.close();
        }
    }

    private void writeTest(FileSystem fs, int count, Path file, byte[][] fieldsData) throws IOException, SerDeException {
        this.writeTest(fs, count, file, fieldsData, this.conf);
    }

    private void writeTest(FileSystem fs, int count, Path file, byte[][] fieldsData, Configuration conf) throws IOException, SerDeException {
        int i;
        this.cleanup();
        RCFileOutputFormat.setColumnNumber((Configuration)conf, (int)fieldsData.length);
        RCFile.Writer writer = new RCFile.Writer(fs, conf, file, null, (CompressionCodec)new DefaultCodec());
        BytesRefArrayWritable bytes = new BytesRefArrayWritable(fieldsData.length);
        for (i = 0; i < fieldsData.length; ++i) {
            BytesRefWritable cu = null;
            cu = new BytesRefWritable(fieldsData[i], 0, fieldsData[i].length);
            bytes.set(i, cu);
        }
        for (i = 0; i < count; ++i) {
            writer.append((Writable)bytes);
        }
        writer.close();
        long fileLen = fs.getFileStatus(file).getLen();
        System.out.println("The file size of RCFile with " + bytes.size() + " number columns and " + count + " number rows is " + fileLen);
    }

    private static Properties createProperties() {
        Properties tbl = new Properties();
        tbl.setProperty("serialization.format", "9");
        tbl.setProperty("columns", "abyte,ashort,aint,along,adouble,astring,anullint,anullstring");
        tbl.setProperty("columns.types", "tinyint:smallint:int:bigint:double:string:int:string");
        tbl.setProperty("serialization.null.format", "NULL");
        return tbl;
    }

    public void fullyReadTest(FileSystem fs, int count, Path file) throws IOException, SerDeException {
        LOG.debug("reading " + count + " records");
        long start = System.currentTimeMillis();
        ColumnProjectionUtils.setReadAllColumns((Configuration)this.conf);
        RCFile.Reader reader = new RCFile.Reader(fs, file, this.conf);
        LongWritable rowID = new LongWritable();
        int actualRead = 0;
        BytesRefArrayWritable cols = new BytesRefArrayWritable();
        while (reader.next(rowID)) {
            reader.getCurrentRow(cols);
            cols.resetValid(8);
            Object row = this.serDe.deserialize((Writable)cols);
            StructObjectInspector oi = (StructObjectInspector)this.serDe.getObjectInspector();
            List fieldRefs = oi.getAllStructFieldRefs();
            Assert.assertEquals((String)"Field size should be 8", (long)8L, (long)fieldRefs.size());
            for (int i = 0; i < fieldRefs.size(); ++i) {
                Object fieldData = oi.getStructFieldData(row, (StructField)fieldRefs.get(i));
                Object standardWritableData = ObjectInspectorUtils.copyToStandardObject((Object)fieldData, (ObjectInspector)((StructField)fieldRefs.get(i)).getFieldObjectInspector(), (ObjectInspectorUtils.ObjectInspectorCopyOption)ObjectInspectorUtils.ObjectInspectorCopyOption.WRITABLE);
                Assert.assertEquals((String)("Field " + i), (Object)standardWritableData, (Object)this.expectedFieldsData[i]);
            }
            Assert.assertEquals((String)"Class of the serialized object should be BytesRefArrayWritable", BytesRefArrayWritable.class, (Object)this.serDe.getSerializedClass());
            BytesRefArrayWritable serializedText = (BytesRefArrayWritable)this.serDe.serialize(row, (ObjectInspector)oi);
            Assert.assertEquals((String)"Serialized data", (Object)this.s, (Object)serializedText);
            ++actualRead;
        }
        reader.close();
        Assert.assertEquals((String)("Expect " + count + " rows, actual read " + actualRead), (long)actualRead, (long)count);
        long cost = System.currentTimeMillis() - start;
        LOG.debug("reading fully costs:" + cost + " milliseconds");
    }

    private void partialReadTest(FileSystem fs, int count, Path file) throws IOException, SerDeException {
        LOG.debug("reading " + count + " records");
        long start = System.currentTimeMillis();
        ArrayList<Integer> readCols = new ArrayList<Integer>();
        readCols.add(2);
        readCols.add(3);
        ColumnProjectionUtils.appendReadColumns((Configuration)this.conf, readCols);
        RCFile.Reader reader = new RCFile.Reader(fs, file, this.conf);
        LongWritable rowID = new LongWritable();
        BytesRefArrayWritable cols = new BytesRefArrayWritable();
        while (reader.next(rowID)) {
            reader.getCurrentRow(cols);
            cols.resetValid(8);
            Object row = this.serDe.deserialize((Writable)cols);
            StructObjectInspector oi = (StructObjectInspector)this.serDe.getObjectInspector();
            List fieldRefs = oi.getAllStructFieldRefs();
            Assert.assertEquals((String)"Field size should be 8", (long)8L, (long)fieldRefs.size());
            Iterator i$ = readCols.iterator();
            while (i$.hasNext()) {
                int i = (Integer)i$.next();
                Object fieldData = oi.getStructFieldData(row, (StructField)fieldRefs.get(i));
                Object standardWritableData = ObjectInspectorUtils.copyToStandardObject((Object)fieldData, (ObjectInspector)((StructField)fieldRefs.get(i)).getFieldObjectInspector(), (ObjectInspectorUtils.ObjectInspectorCopyOption)ObjectInspectorUtils.ObjectInspectorCopyOption.WRITABLE);
                Assert.assertEquals((String)("Field " + i), (Object)standardWritableData, (Object)this.expectedPartitalFieldsData[i]);
            }
            Assert.assertEquals((String)"Class of the serialized object should be BytesRefArrayWritable", BytesRefArrayWritable.class, (Object)this.serDe.getSerializedClass());
            BytesRefArrayWritable serializedBytes = (BytesRefArrayWritable)this.serDe.serialize(row, (ObjectInspector)oi);
            Assert.assertEquals((String)"Serialized data", (Object)this.patialS, (Object)serializedBytes);
        }
        reader.close();
        long cost = System.currentTimeMillis() - start;
        LOG.debug("reading fully costs:" + cost + " milliseconds");
    }

    @Test
    public void testSynAndSplit() throws IOException {
        this.splitBeforeSync();
        this.splitRightBeforeSync();
        this.splitInMiddleOfSync();
        this.splitRightAfterSync();
        this.splitAfterSync();
    }

    @Test
    public void testSync() throws IOException {
        int i;
        Path testDir = new Path(System.getProperty("test.tmp.dir", ".") + "/mapred/testsync");
        Path testFile = new Path(testDir, "test_rcfile");
        this.fs.delete(testFile, true);
        int intervalRecordCount = 500;
        CompressionCodec codec = null;
        int writeCount = 2500;
        Configuration cloneConf = new Configuration(this.conf);
        RCFileOutputFormat.setColumnNumber((Configuration)cloneConf, (int)this.bytesArray.length);
        cloneConf.setInt(HiveConf.ConfVars.HIVE_RCFILE_RECORD_INTERVAL.varname, intervalRecordCount);
        RCFile.Writer writer = new RCFile.Writer(this.fs, cloneConf, testFile, null, codec);
        BytesRefArrayWritable bytes = new BytesRefArrayWritable(this.bytesArray.length);
        for (i = 0; i < this.bytesArray.length; ++i) {
            BytesRefWritable cu = null;
            cu = new BytesRefWritable(this.bytesArray[i], 0, this.bytesArray[i].length);
            bytes.set(i, cu);
        }
        for (i = 0; i < writeCount; ++i) {
            writer.append((Writable)bytes);
        }
        writer.close();
        long fileLen = this.fs.getFileStatus(testFile).getLen();
        RCFileInputFormat inputFormat = new RCFileInputFormat();
        JobConf jobconf = new JobConf(cloneConf);
        jobconf.set("mapred.input.dir", testDir.toString());
        HiveConf.setLongVar((Configuration)jobconf, (HiveConf.ConfVars)HiveConf.ConfVars.MAPREDMINSPLITSIZE, (long)fileLen);
        InputSplit[] splits = inputFormat.getSplits(jobconf, 1);
        RCFileRecordReader rr = new RCFileRecordReader((Configuration)jobconf, (FileSplit)splits[0]);
        long lastSync = 0L;
        for (int i2 = 0; i2 < 2500; ++i2) {
            rr.sync((long)i2);
            if (rr.getPos() < lastSync) {
                String reason = String.format("Sync at offset %d skipped sync block at location %d (returned %d instead)", i2 - 1, rr.getPos(), lastSync);
                System.out.println(reason);
                Assert.fail((String)reason);
            }
            lastSync = rr.getPos();
        }
        rr.close();
    }

    private void splitBeforeSync() throws IOException {
        this.writeThenReadByRecordReader(600, 1000, 2, 1L, null);
    }

    private void splitRightBeforeSync() throws IOException {
        this.writeThenReadByRecordReader(500, 1000, 2, 17750L, null);
    }

    private void splitInMiddleOfSync() throws IOException {
        this.writeThenReadByRecordReader(500, 1000, 2, 17760L, null);
    }

    private void splitRightAfterSync() throws IOException {
        this.writeThenReadByRecordReader(500, 1000, 2, 17770L, null);
    }

    private void splitAfterSync() throws IOException {
        this.writeThenReadByRecordReader(500, 1000, 2, 19950L, null);
    }

    private void writeThenReadByRecordReader(int intervalRecordCount, int writeCount, int splitNumber, long minSplitSize, CompressionCodec codec) throws IOException {
        int i;
        Path testDir = new Path(System.getProperty("test.tmp.dir", ".") + "/mapred/testsmallfirstsplit");
        Path testFile = new Path(testDir, "test_rcfile");
        this.fs.delete(testFile, true);
        Configuration cloneConf = new Configuration(this.conf);
        RCFileOutputFormat.setColumnNumber((Configuration)cloneConf, (int)this.bytesArray.length);
        cloneConf.setInt(HiveConf.ConfVars.HIVE_RCFILE_RECORD_INTERVAL.varname, intervalRecordCount);
        RCFile.Writer writer = new RCFile.Writer(this.fs, cloneConf, testFile, null, codec);
        BytesRefArrayWritable bytes = new BytesRefArrayWritable(this.bytesArray.length);
        for (i = 0; i < this.bytesArray.length; ++i) {
            BytesRefWritable cu = null;
            cu = new BytesRefWritable(this.bytesArray[i], 0, this.bytesArray[i].length);
            bytes.set(i, cu);
        }
        for (i = 0; i < writeCount; ++i) {
            if (i == intervalRecordCount) {
                System.out.println("write position:" + writer.getLength());
            }
            writer.append((Writable)bytes);
        }
        writer.close();
        RCFileInputFormat inputFormat = new RCFileInputFormat();
        JobConf jonconf = new JobConf(cloneConf);
        jonconf.set("mapred.input.dir", testDir.toString());
        HiveConf.setLongVar((Configuration)jonconf, (HiveConf.ConfVars)HiveConf.ConfVars.MAPREDMINSPLITSIZE, (long)minSplitSize);
        InputSplit[] splits = inputFormat.getSplits(jonconf, splitNumber);
        Assert.assertEquals((String)("splits length should be " + splitNumber), (long)splits.length, (long)splitNumber);
        int readCount = 0;
        for (int i2 = 0; i2 < splits.length; ++i2) {
            int previousReadCount = readCount;
            RecordReader rr = inputFormat.getRecordReader(splits[i2], jonconf, Reporter.NULL);
            Object key = rr.createKey();
            Object value = rr.createValue();
            while (rr.next(key, value)) {
                ++readCount;
            }
            rr.close();
            System.out.println("The " + i2 + "th split read " + (readCount - previousReadCount));
        }
        Assert.assertEquals((String)"readCount should be equal to writeCount", (long)writeCount, (long)readCount);
    }

    @Test
    public void testCloseForErroneousRCFile() throws IOException {
        Configuration conf = new Configuration();
        LocalFileSystem fs = FileSystem.getLocal((Configuration)conf);
        Path path = new Path(System.getProperty("test.tmp.dir", ".") + "/broken.rcfile");
        fs.create(path).close();
        final TestFSDataInputStream[] openedFile = new TestFSDataInputStream[1];
        try {
            new RCFile.Reader((FileSystem)fs, path, conf){

                protected FSDataInputStream openFile(FileSystem fs, Path file, int bufferSize, long length) throws IOException {
                    FSDataInputStream in = super.openFile(fs, file, bufferSize, length);
                    openedFile[0] = new TestFSDataInputStream((InputStream)in);
                    return openedFile[0];
                }
            };
            Assert.fail((String)"IOException expected.");
        }
        catch (IOException expected) {
            // empty catch block
        }
        Assert.assertNotNull((String)(path + " should have been opened."), (Object)((Object)openedFile[0]));
        Assert.assertTrue((String)("InputStream for " + path + " should have been closed."), (boolean)openedFile[0].isClosed());
    }

    public void testRCFileHeader(char[] expected, Configuration conf) throws IOException, SerDeException {
        this.writeTest(this.fs, 10000, this.file, this.bytesArray, conf);
        FSDataInputStream di = this.fs.open(this.file, 10000);
        byte[] bytes = new byte[3];
        di.read(bytes);
        for (int i = 0; i < expected.length; ++i) {
            Assert.assertTrue((String)"Headers did not match", (bytes[i] == expected[i] ? 1 : 0) != 0);
        }
        di.close();
    }

    @Test
    public void testNonExplicitRCFileHeader() throws IOException, SerDeException {
        Configuration conf = new Configuration();
        conf.setBoolean(HiveConf.ConfVars.HIVEUSEEXPLICITRCFILEHEADER.varname, false);
        char[] expected = new char[]{'S', 'E', 'Q'};
        this.testRCFileHeader(expected, conf);
    }

    @Test
    public void testExplicitRCFileHeader() throws IOException, SerDeException {
        Configuration conf = new Configuration();
        conf.setBoolean(HiveConf.ConfVars.HIVEUSEEXPLICITRCFILEHEADER.varname, true);
        char[] expected = new char[]{'R', 'C', 'F'};
        this.testRCFileHeader(expected, conf);
    }

    private static class TestFSDataInputStream
    extends FSDataInputStream {
        private boolean closed = false;

        private TestFSDataInputStream(InputStream in) throws IOException {
            super(in);
        }

        public void close() throws IOException {
            this.closed = true;
            super.close();
        }

        public boolean isClosed() {
            return this.closed;
        }
    }
}

