/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.vector.mapjoin.fast;

import java.util.Random;
import org.apache.hadoop.hive.ql.exec.JoinUtil;
import org.apache.hadoop.hive.ql.exec.vector.mapjoin.fast.CommonFastHashTable;
import org.apache.hadoop.hive.ql.exec.vector.mapjoin.fast.RandomByteArrayStream;
import org.apache.hadoop.hive.ql.exec.vector.mapjoin.fast.RandomLongStream;
import org.apache.hadoop.hive.ql.exec.vector.mapjoin.fast.VectorMapJoinFastLongHashMap;
import org.apache.hadoop.hive.ql.exec.vector.mapjoin.hashtable.VectorMapJoinHashMapResult;
import org.apache.hadoop.hive.ql.plan.VectorMapJoinDesc;
import org.junit.Assert;
import org.junit.Test;

public class TestVectorMapJoinFastLongHashMap
extends CommonFastHashTable {
    @Test
    public void testPutGetOne() throws Exception {
        random = new Random(47496L);
        VectorMapJoinFastLongHashMap map = new VectorMapJoinFastLongHashMap(false, false, VectorMapJoinDesc.HashTableKeyType.LONG, 8, 0.75f, 128);
        RandomLongStream randomLongKeyStream = new RandomLongStream(random);
        RandomByteArrayStream randomByteArrayValueStream = new RandomByteArrayStream(random);
        long key = randomLongKeyStream.next();
        byte[] value = randomByteArrayValueStream.next();
        map.putRow(key, value);
        this.verifyHashMapResult(map, key, randomByteArrayValueStream.get(0));
        key = randomLongKeyStream.next();
        value = randomByteArrayValueStream.next();
        map.putRow(key, value);
        this.verifyHashMapResult(map, key, randomByteArrayValueStream.get(1));
    }

    @Test
    public void testPutGetMultiple() throws Exception {
        random = new Random(2990L);
        VectorMapJoinFastLongHashMap map = new VectorMapJoinFastLongHashMap(false, false, VectorMapJoinDesc.HashTableKeyType.LONG, 8, 0.75f, 128);
        RandomLongStream randomLongKeyStream = new RandomLongStream(random);
        RandomByteArrayStream randomByteArrayValueStream = new RandomByteArrayStream(random);
        long key = randomLongKeyStream.next();
        byte[] value = randomByteArrayValueStream.next();
        map.putRow(key, value);
        this.verifyHashMapResult(map, key, value);
        for (int i = 0; i < 3; ++i) {
            value = randomByteArrayValueStream.next();
            map.putRow(key, value);
            this.verifyHashMapResult(map, key, randomByteArrayValueStream);
        }
    }

    @Test
    public void testGetNonExistent() throws Exception {
        random = new Random(16916L);
        VectorMapJoinFastLongHashMap map = new VectorMapJoinFastLongHashMap(false, false, VectorMapJoinDesc.HashTableKeyType.LONG, 8, 0.75f, 128);
        RandomLongStream randomLongKeyStream = new RandomLongStream(random);
        RandomByteArrayStream randomByteArrayValueStream = new RandomByteArrayStream(random);
        long key = randomLongKeyStream.next();
        byte[] value = randomByteArrayValueStream.next();
        map.putRow(key, value);
        map.putRow(++key, value);
        VectorMapJoinHashMapResult hashMapResult = map.createHashMapResult();
        JoinUtil.JoinResult joinResult = map.lookup(++key, hashMapResult);
        Assert.assertTrue((joinResult == JoinUtil.JoinResult.NOMATCH ? 1 : 0) != 0);
        Assert.assertTrue((!hashMapResult.hasRows() ? 1 : 0) != 0);
    }

    @Test
    public void testPutWithFullMap() throws Exception {
        VectorMapJoinHashMapResult hashMapResult;
        int i;
        random = new Random(26078L);
        VectorMapJoinFastLongHashMap map = new VectorMapJoinFastLongHashMap(false, false, VectorMapJoinDesc.HashTableKeyType.LONG, 8, 1.0f, 128);
        RandomLongStream randomLongKeyStream = new RandomLongStream(random);
        RandomByteArrayStream randomByteArrayValueStream = new RandomByteArrayStream(random);
        for (i = 0; i < 8; ++i) {
            long key = randomLongKeyStream.next();
            byte[] value = randomByteArrayValueStream.next();
            map.putRow(key, value);
        }
        for (i = 0; i < randomLongKeyStream.size(); ++i) {
            this.verifyHashMapResult(map, randomLongKeyStream.get(i), randomByteArrayValueStream.get(i));
        }
        long anotherKey = randomLongKeyStream.next();
        JoinUtil.JoinResult joinResult = map.lookup(anotherKey, hashMapResult = map.createHashMapResult());
        Assert.assertTrue((joinResult == JoinUtil.JoinResult.NOMATCH ? 1 : 0) != 0);
    }

    @Test
    public void testExpand() throws Exception {
        random = new Random(22470L);
        VectorMapJoinFastLongHashMap map = new VectorMapJoinFastLongHashMap(false, false, VectorMapJoinDesc.HashTableKeyType.LONG, 1, 1.0E-7f, 128);
        RandomLongStream randomLongKeyStream = new RandomLongStream(random);
        RandomByteArrayStream randomByteArrayValueStream = new RandomByteArrayStream(random);
        for (int i = 0; i < 18; ++i) {
            long key = randomLongKeyStream.next();
            byte[] value = randomByteArrayValueStream.next();
            map.putRow(key, value);
            for (int j = 0; j <= i; ++j) {
                this.verifyHashMapResult(map, randomLongKeyStream.get(j), randomByteArrayValueStream.get(j));
            }
        }
    }

    @Test
    public void testLarge() throws Exception {
        int i;
        random = new Random(40719L);
        VectorMapJoinFastLongHashMap map = new VectorMapJoinFastLongHashMap(false, false, VectorMapJoinDesc.HashTableKeyType.LONG, 0x800000, 0.75f, 0x100000);
        RandomLongStream randomLongKeyStream = new RandomLongStream(random);
        int largeSize = 1000;
        RandomByteArrayStream[] randomByteArrayValueStreams = new RandomByteArrayStream[1000];
        for (i = 0; i < 1000; ++i) {
            randomByteArrayValueStreams[i] = new RandomByteArrayStream(random);
            int count = TestVectorMapJoinFastLongHashMap.generateLargeCount();
            long key = randomLongKeyStream.next();
            for (int v = 0; v < count; ++v) {
                byte[] value = randomByteArrayValueStreams[i].next();
                map.putRow(key, value);
            }
        }
        for (i = 0; i < 1000; ++i) {
            this.verifyHashMapResult(map, randomLongKeyStream.get(i), randomByteArrayValueStreams[i]);
        }
    }

    @Test
    public void testLargeAndExpand() throws Exception {
        int i;
        random = new Random(46809L);
        VectorMapJoinFastLongHashMap map = new VectorMapJoinFastLongHashMap(false, false, VectorMapJoinDesc.HashTableKeyType.LONG, 512, 0.75f, 8192);
        RandomLongStream randomLongKeyStream = new RandomLongStream(random);
        int largeSize = 1000;
        RandomByteArrayStream[] randomByteArrayValueStreams = new RandomByteArrayStream[1000];
        for (i = 0; i < 1000; ++i) {
            randomByteArrayValueStreams[i] = new RandomByteArrayStream(random);
            int count = TestVectorMapJoinFastLongHashMap.generateLargeCount();
            long key = randomLongKeyStream.next();
            for (int v = 0; v < count; ++v) {
                byte[] value = randomByteArrayValueStreams[i].next();
                map.putRow(key, value);
            }
        }
        for (i = 0; i < 1000; ++i) {
            this.verifyHashMapResult(map, randomLongKeyStream.get(i), randomByteArrayValueStreams[i]);
        }
    }

    private void verifyHashMapResult(VectorMapJoinFastLongHashMap map, long key, RandomByteArrayStream randomByteArrayValueStream) {
        VectorMapJoinHashMapResult hashMapResult = map.createHashMapResult();
        JoinUtil.JoinResult joinResult = map.lookup(key, hashMapResult);
        if (joinResult != JoinUtil.JoinResult.MATCH) {
            Assert.assertTrue((boolean)false);
        }
        CommonFastHashTable.verifyHashMapResult(hashMapResult, randomByteArrayValueStream);
    }

    private void verifyHashMapResult(VectorMapJoinFastLongHashMap map, long key, byte[] valueBytes) {
        VectorMapJoinHashMapResult hashMapResult = map.createHashMapResult();
        JoinUtil.JoinResult joinResult = map.lookup(key, hashMapResult);
        if (joinResult != JoinUtil.JoinResult.MATCH) {
            Assert.assertTrue((boolean)false);
        }
        CommonFastHashTable.verifyHashMapResult(hashMapResult, valueBytes);
    }
}

