/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.vector;

import java.util.Arrays;
import java.util.Random;
import junit.framework.TestCase;
import org.apache.hadoop.hive.ql.exec.vector.ColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.RandomRowObjectSource;
import org.apache.hadoop.hive.ql.exec.vector.VectorAssignRowSameBatch;
import org.apache.hadoop.hive.ql.exec.vector.VectorExtractRowSameBatch;
import org.apache.hadoop.hive.ql.exec.vector.VectorizedRowBatch;
import org.apache.hadoop.hive.ql.exec.vector.VectorizedRowBatchCtx;
import org.apache.hadoop.hive.ql.metadata.HiveException;

public class TestVectorRowObject
extends TestCase {
    void examineBatch(VectorizedRowBatch batch, VectorExtractRowSameBatch vectorExtractRow, Object[][] randomRows, int firstRandomRowIndex) {
        int rowSize = vectorExtractRow.getCount();
        Object[] row = new Object[rowSize];
        for (int i = 0; i < batch.size; ++i) {
            vectorExtractRow.extractRow(i, row);
            Object[] expectedRow = randomRows[firstRandomRowIndex + i];
            for (int c = 0; c < rowSize; ++c) {
                if (row[c].equals(expectedRow[c])) continue;
                TestVectorRowObject.fail((String)("Row " + (firstRandomRowIndex + i) + " and column " + c + " mismatch"));
            }
        }
    }

    void testVectorRowObject(int caseNum, Random r) throws HiveException {
        String[] emptyScratchTypeNames = new String[]{};
        RandomRowObjectSource source = new RandomRowObjectSource();
        source.init(r);
        VectorizedRowBatchCtx batchContext = new VectorizedRowBatchCtx();
        batchContext.init(source.rowStructObjectInspector(), emptyScratchTypeNames);
        VectorizedRowBatch batch = batchContext.createVectorizedRowBatch();
        for (ColumnVector cv : batch.cols) {
            Arrays.fill(cv.isNull, true);
            cv.noNulls = false;
        }
        VectorAssignRowSameBatch vectorAssignRow = new VectorAssignRowSameBatch();
        vectorAssignRow.init(source.typeNames());
        vectorAssignRow.setOneBatch(batch);
        VectorExtractRowSameBatch vectorExtractRow = new VectorExtractRowSameBatch();
        vectorExtractRow.init(source.typeNames());
        vectorExtractRow.setOneBatch(batch);
        Object[][] randomRows = source.randomRows(100000);
        int firstRandomRowIndex = 0;
        for (int i = 0; i < randomRows.length; ++i) {
            Object[] row = randomRows[i];
            vectorAssignRow.assignRow(batch.size, row);
            ++batch.size;
            if (batch.size != 1024) continue;
            this.examineBatch(batch, vectorExtractRow, randomRows, firstRandomRowIndex);
            firstRandomRowIndex = i + 1;
            batch.reset();
        }
        if (batch.size > 0) {
            this.examineBatch(batch, vectorExtractRow, randomRows, firstRandomRowIndex);
        }
    }

    public void testVectorRowObject() throws Throwable {
        try {
            Random r = new Random(5678L);
            for (int c = 0; c < 10; ++c) {
                this.testVectorRowObject(c, r);
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
            throw e;
        }
    }
}

