/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.tez;

import java.io.IOException;
import java.util.HashSet;
import java.util.Set;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.ql.exec.tez.HostAffinitySplitLocationProvider;
import org.apache.hadoop.hive.ql.io.orc.OrcSplit;
import org.apache.hadoop.mapred.FileSplit;
import org.apache.hadoop.mapred.InputSplit;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;

public class TestHostAffinitySplitLocationProvider {
    private static final String[] locations;
    private static final Set<String> locationsSet;
    private static final String[] executorLocations;
    private static final Set<String> executorLocationsSet;

    @Test(timeout=5000L)
    public void testNonFileSplits() throws IOException {
        HostAffinitySplitLocationProvider locationProvider = new HostAffinitySplitLocationProvider(executorLocations);
        InputSplit inputSplit1 = this.createMockInputSplit(new String[]{locations[0], locations[1]});
        InputSplit inputSplit2 = this.createMockInputSplit(new String[]{locations[2], locations[3]});
        Assert.assertArrayEquals((Object[])new String[]{locations[0], locations[1]}, (Object[])locationProvider.getLocations(inputSplit1));
        Assert.assertArrayEquals((Object[])new String[]{locations[2], locations[3]}, (Object[])locationProvider.getLocations(inputSplit2));
    }

    @Test(timeout=5000L)
    public void testOrcSplitsBasic() throws IOException {
        HostAffinitySplitLocationProvider locationProvider = new HostAffinitySplitLocationProvider(executorLocations);
        InputSplit os1 = this.createMockFileSplit(true, "path1", 0L, 1000L, new String[]{locations[0], locations[1]});
        InputSplit os2 = this.createMockFileSplit(true, "path2", 0L, 2000L, new String[]{locations[2], locations[3]});
        InputSplit os3 = this.createMockFileSplit(true, "path3", 1000L, 2000L, new String[]{locations[0], locations[3]});
        String[] retLoc1 = locationProvider.getLocations(os1);
        String[] retLoc2 = locationProvider.getLocations(os2);
        String[] retLoc3 = locationProvider.getLocations(os3);
        Assert.assertEquals((long)1L, (long)retLoc1.length);
        Assert.assertFalse((boolean)locationsSet.contains(retLoc1[0]));
        Assert.assertTrue((boolean)executorLocationsSet.contains(retLoc1[0]));
        Assert.assertEquals((long)1L, (long)retLoc2.length);
        Assert.assertFalse((boolean)locationsSet.contains(retLoc2[0]));
        Assert.assertTrue((boolean)executorLocationsSet.contains(retLoc2[0]));
        Assert.assertEquals((long)1L, (long)retLoc3.length);
        Assert.assertFalse((boolean)locationsSet.contains(retLoc3[0]));
        Assert.assertTrue((boolean)executorLocationsSet.contains(retLoc3[0]));
    }

    @Test(timeout=5000L)
    public void testOrcSplitsLocationAffinity() throws IOException {
        HostAffinitySplitLocationProvider locationProvider = new HostAffinitySplitLocationProvider(executorLocations);
        InputSplit os11 = this.createMockFileSplit(true, "path1", 0L, 15000L, new String[]{locations[0], locations[1]});
        InputSplit os12 = this.createMockFileSplit(true, "path1", 0L, 30000L, new String[]{locations[0], locations[1]});
        InputSplit os13 = this.createMockFileSplit(true, "path1", 15000L, 30000L, new String[]{locations[0], locations[1]});
        Object[] retLoc11 = locationProvider.getLocations(os11);
        Object[] retLoc12 = locationProvider.getLocations(os12);
        Object[] retLoc13 = locationProvider.getLocations(os13);
        Assert.assertEquals((long)1L, (long)retLoc11.length);
        Assert.assertFalse((boolean)locationsSet.contains(retLoc11[0]));
        Assert.assertTrue((boolean)executorLocationsSet.contains(retLoc11[0]));
        Assert.assertEquals((long)1L, (long)retLoc12.length);
        Assert.assertFalse((boolean)locationsSet.contains(retLoc12[0]));
        Assert.assertTrue((boolean)executorLocationsSet.contains(retLoc12[0]));
        Assert.assertEquals((long)1L, (long)retLoc13.length);
        Assert.assertFalse((boolean)locationsSet.contains(retLoc13[0]));
        Assert.assertTrue((boolean)executorLocationsSet.contains(retLoc13[0]));
        Assert.assertEquals((Object)retLoc11[0], (Object)retLoc12[0]);
        Assert.assertNotEquals((Object)retLoc11[0], (Object)retLoc13[0]);
        Object[] retLoc112 = locationProvider.getLocations(os11);
        Object[] retLoc122 = locationProvider.getLocations(os12);
        Object[] retLoc132 = locationProvider.getLocations(os13);
        Assert.assertArrayEquals((Object[])retLoc11, (Object[])retLoc112);
        Assert.assertArrayEquals((Object[])retLoc12, (Object[])retLoc122);
        Assert.assertArrayEquals((Object[])retLoc13, (Object[])retLoc132);
    }

    private InputSplit createMockInputSplit(String[] locations) throws IOException {
        InputSplit inputSplit = (InputSplit)Mockito.mock(InputSplit.class);
        ((InputSplit)Mockito.doReturn((Object)locations).when((Object)inputSplit)).getLocations();
        return inputSplit;
    }

    private InputSplit createMockFileSplit(boolean createOrcSplit, String fakePathString, long start, long length, String[] locations) throws IOException {
        FileSplit fileSplit = createOrcSplit ? (FileSplit)Mockito.mock(OrcSplit.class) : (FileSplit)Mockito.mock(FileSplit.class);
        ((FileSplit)Mockito.doReturn((Object)start).when((Object)fileSplit)).getStart();
        ((FileSplit)Mockito.doReturn((Object)length).when((Object)fileSplit)).getLength();
        ((FileSplit)Mockito.doReturn((Object)new Path(fakePathString)).when((Object)fileSplit)).getPath();
        ((FileSplit)Mockito.doReturn((Object)locations).when((Object)fileSplit)).getLocations();
        ((FileSplit)Mockito.doReturn((Object)locations).when((Object)fileSplit)).getLocations();
        return fileSplit;
    }

    static {
        int i;
        locations = new String[5];
        locationsSet = new HashSet<String>();
        executorLocations = new String[9];
        executorLocationsSet = new HashSet<String>();
        for (i = 0; i < 5; ++i) {
            TestHostAffinitySplitLocationProvider.locations[i] = "location" + i;
            locationsSet.add(locations[i]);
        }
        for (i = 0; i < 9; ++i) {
            TestHostAffinitySplitLocationProvider.executorLocations[i] = "execLocation" + i;
            executorLocationsSet.add(executorLocations[i]);
        }
    }
}

