/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import junit.framework.TestCase;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.CompilationOpContext;
import org.apache.hadoop.hive.ql.Driver;
import org.apache.hadoop.hive.ql.exec.CollectOperator;
import org.apache.hadoop.hive.ql.exec.FetchOperator;
import org.apache.hadoop.hive.ql.exec.MapOperator;
import org.apache.hadoop.hive.ql.exec.Operator;
import org.apache.hadoop.hive.ql.exec.OperatorFactory;
import org.apache.hadoop.hive.ql.exec.ScriptOperator;
import org.apache.hadoop.hive.ql.exec.TestExecDriver;
import org.apache.hadoop.hive.ql.exec.TextRecordReader;
import org.apache.hadoop.hive.ql.exec.TextRecordWriter;
import org.apache.hadoop.hive.ql.exec.Utilities;
import org.apache.hadoop.hive.ql.io.IOContextMap;
import org.apache.hadoop.hive.ql.parse.TypeCheckProcFactory;
import org.apache.hadoop.hive.ql.plan.CollectDesc;
import org.apache.hadoop.hive.ql.plan.ExprNodeColumnDesc;
import org.apache.hadoop.hive.ql.plan.ExprNodeConstantDesc;
import org.apache.hadoop.hive.ql.plan.ExprNodeDesc;
import org.apache.hadoop.hive.ql.plan.MapredWork;
import org.apache.hadoop.hive.ql.plan.OperatorDesc;
import org.apache.hadoop.hive.ql.plan.PartitionDesc;
import org.apache.hadoop.hive.ql.plan.PlanUtils;
import org.apache.hadoop.hive.ql.plan.ScriptDesc;
import org.apache.hadoop.hive.ql.plan.SelectDesc;
import org.apache.hadoop.hive.ql.plan.TableDesc;
import org.apache.hadoop.hive.ql.processors.CommandProcessorResponse;
import org.apache.hadoop.hive.ql.session.SessionState;
import org.apache.hadoop.hive.serde2.objectinspector.InspectableObject;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspectorFactory;
import org.apache.hadoop.hive.serde2.objectinspector.PrimitiveObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.StructField;
import org.apache.hadoop.hive.serde2.objectinspector.StructObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.JavaStringObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.PrimitiveObjectInspectorFactory;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.mapred.InputSplit;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.TextInputFormat;
import org.junit.Assert;
import org.junit.Test;

public class TestOperators
extends TestCase {
    protected InspectableObject[] r;

    protected void setUp() {
        this.r = new InspectableObject[5];
        ArrayList<String> names = new ArrayList<String>(3);
        names.add("col0");
        names.add("col1");
        names.add("col2");
        ArrayList<JavaStringObjectInspector> objectInspectors = new ArrayList<JavaStringObjectInspector>(3);
        objectInspectors.add(PrimitiveObjectInspectorFactory.javaStringObjectInspector);
        objectInspectors.add(PrimitiveObjectInspectorFactory.javaStringObjectInspector);
        objectInspectors.add(PrimitiveObjectInspectorFactory.javaStringObjectInspector);
        for (int i = 0; i < 5; ++i) {
            ArrayList<String> data = new ArrayList<String>();
            data.add("" + i);
            data.add("" + (i + 1));
            data.add("" + (i + 2));
            try {
                this.r[i] = new InspectableObject();
                this.r[i].o = data;
                this.r[i].oi = ObjectInspectorFactory.getStandardStructObjectInspector(names, objectInspectors);
                continue;
            }
            catch (Throwable e) {
                throw new RuntimeException(e);
            }
        }
    }

    private void testTaskIds(String[] taskIds, String expectedAttemptId, String expectedTaskId) {
        JobConf conf = new JobConf(TestOperators.class);
        for (String one : taskIds) {
            conf.set("mapred.task.id", one);
            String attemptId = Utilities.getTaskId((Configuration)conf);
            TestOperators.assertEquals((String)expectedAttemptId, (String)attemptId);
            TestOperators.assertEquals((String)Utilities.getTaskIdFromFilename((String)attemptId), (String)expectedTaskId);
            TestOperators.assertEquals((String)Utilities.getTaskIdFromFilename((String)(attemptId + ".gz")), (String)expectedTaskId);
            TestOperators.assertEquals((String)Utilities.getTaskIdFromFilename((String)Utilities.toTempPath((Path)new Path(attemptId + ".gz")).toString()), (String)expectedTaskId);
        }
    }

    public void testFileSinkOperator() throws Throwable {
        try {
            this.testTaskIds(new String[]{"attempt_200707121733_0003_m_000005_0", "attempt_local_0001_m_000005_0", "task_200709221812_0001_m_000005_0", "task_local_0001_m_000005_0"}, "000005_0", "000005");
            this.testTaskIds(new String[]{"job_local_0001_map_000005", "job_local_0001_reduce_000005"}, "000005", "000005");
            this.testTaskIds(new String[]{"1234567"}, "1234567", "1234567");
            TestOperators.assertEquals((String)Utilities.getTaskIdFromFilename((String)"/mnt/dev005/task_local_0001_m_000005_0"), (String)"000005");
            System.out.println("FileSink Operator ok");
        }
        catch (Throwable e) {
            e.printStackTrace();
            throw e;
        }
    }

    public void testScriptOperatorEnvVarsProcessing() throws Throwable {
        try {
            ScriptOperator scriptOperator = new ScriptOperator(new CompilationOpContext());
            TestOperators.assertEquals((String)"a_b_c", (String)scriptOperator.safeEnvVarName("a.b.c"));
            TestOperators.assertEquals((String)"a_b_c", (String)scriptOperator.safeEnvVarName("a-b-c"));
            TestOperators.assertEquals((String)"value", (String)scriptOperator.safeEnvVarValue("value", "name", false));
            TestOperators.assertEquals((String)"value", (String)scriptOperator.safeEnvVarValue("value", "name", true));
            char[] array = new char[20481];
            Arrays.fill(array, 'a');
            String hugeEnvVar = new String(array);
            TestOperators.assertEquals((int)20481, (int)hugeEnvVar.length());
            TestOperators.assertEquals((int)20481, (int)scriptOperator.safeEnvVarValue(hugeEnvVar, "name", false).length());
            TestOperators.assertEquals((int)20480, (int)scriptOperator.safeEnvVarValue(hugeEnvVar, "name", true).length());
            JobConf hconf = new JobConf(ScriptOperator.class);
            hconf.set("name", hugeEnvVar);
            HashMap env = new HashMap();
            HiveConf.setBoolVar((Configuration)hconf, (HiveConf.ConfVars)HiveConf.ConfVars.HIVESCRIPTTRUNCATEENV, (boolean)false);
            scriptOperator.addJobConfToEnvironment((Configuration)hconf, env);
            TestOperators.assertEquals((int)20481, (int)((String)env.get("name")).length());
            HiveConf.setBoolVar((Configuration)hconf, (HiveConf.ConfVars)HiveConf.ConfVars.HIVESCRIPTTRUNCATEENV, (boolean)true);
            scriptOperator.addJobConfToEnvironment((Configuration)hconf, env);
            TestOperators.assertEquals((int)20480, (int)((String)env.get("name")).length());
            System.out.println("Script Operator Environment Variables processing ok");
        }
        catch (Throwable e) {
            e.printStackTrace();
            throw e;
        }
    }

    public void testScriptOperatorBlacklistedEnvVarsProcessing() {
        ScriptOperator scriptOperator = new ScriptOperator(new CompilationOpContext());
        JobConf hconf = new JobConf(ScriptOperator.class);
        HashMap env = new HashMap();
        HiveConf.setVar((Configuration)hconf, (HiveConf.ConfVars)HiveConf.ConfVars.HIVESCRIPT_ENV_BLACKLIST, (String)"foobar");
        hconf.set("foobar", "foobar");
        hconf.set("barfoo", "barfoo");
        scriptOperator.addJobConfToEnvironment((Configuration)hconf, env);
        Assert.assertFalse((boolean)env.containsKey("foobar"));
        Assert.assertTrue((boolean)env.containsKey("barfoo"));
    }

    public void testScriptOperator() throws Throwable {
        try {
            System.out.println("Testing Script Operator");
            ExprNodeColumnDesc exprDesc1 = TestExecDriver.getStringColumn("col1");
            ExprNodeColumnDesc expr1 = TestExecDriver.getStringColumn("col0");
            ExprNodeConstantDesc expr2 = new ExprNodeConstantDesc((Object)"1");
            ExprNodeDesc exprDesc2 = TypeCheckProcFactory.DefaultExprProcessor.getFuncExprNodeDesc((String)"concat", (ExprNodeDesc[])new ExprNodeDesc[]{expr1, expr2});
            ArrayList<Object> earr = new ArrayList<Object>();
            earr.add(exprDesc1);
            earr.add(exprDesc2);
            ArrayList<String> outputCols = new ArrayList<String>();
            for (int i = 0; i < earr.size(); ++i) {
                outputCols.add("_col" + i);
            }
            SelectDesc selectCtx = new SelectDesc(earr, outputCols);
            Operator op = OperatorFactory.get((CompilationOpContext)new CompilationOpContext(), SelectDesc.class);
            op.setConf((OperatorDesc)selectCtx);
            TableDesc scriptOutput = PlanUtils.getDefaultTableDesc((String)"9", (String)"a,b");
            TableDesc scriptInput = PlanUtils.getDefaultTableDesc((String)"9", (String)"a,b");
            ScriptDesc sd = new ScriptDesc("cat", scriptOutput, TextRecordWriter.class, scriptInput, TextRecordReader.class, TextRecordReader.class, PlanUtils.getDefaultTableDesc((String)"9", (String)"key"));
            Operator sop = OperatorFactory.getAndMakeChild((OperatorDesc)sd, (Operator)op, (Operator[])new Operator[0]);
            CollectDesc cd = new CollectDesc(Integer.valueOf(10));
            CollectOperator cdop = (CollectOperator)OperatorFactory.getAndMakeChild((OperatorDesc)cd, (Operator)sop, (Operator[])new Operator[0]);
            op.initialize((Configuration)new JobConf(TestOperators.class), new ObjectInspector[]{this.r[0].oi});
            for (int i = 0; i < 5; ++i) {
                op.process(this.r[i].o, 0);
            }
            op.close(false);
            InspectableObject io = new InspectableObject();
            for (int i = 0; i < 5; ++i) {
                cdop.retrieve(io);
                System.out.println("[" + i + "] io.o=" + io.o);
                System.out.println("[" + i + "] io.oi=" + io.oi);
                StructObjectInspector soi = (StructObjectInspector)io.oi;
                assert (soi != null);
                StructField a = soi.getStructFieldRef("a");
                StructField b = soi.getStructFieldRef("b");
                TestOperators.assertEquals((Object)("" + (i + 1)), (Object)((PrimitiveObjectInspector)a.getFieldObjectInspector()).getPrimitiveJavaObject(soi.getStructFieldData(io.o, a)));
                TestOperators.assertEquals((Object)(i + "1"), (Object)((PrimitiveObjectInspector)b.getFieldObjectInspector()).getPrimitiveJavaObject(soi.getStructFieldData(io.o, b)));
            }
            System.out.println("Script Operator ok");
        }
        catch (Throwable e) {
            e.printStackTrace();
            throw e;
        }
    }

    public void testMapOperator() throws Throwable {
        try {
            System.out.println("Testing Map Operator");
            JobConf hconf = new JobConf(TestOperators.class);
            hconf.set("mapreduce.map.input.file", "hdfs:///testDir/testFile");
            IOContextMap.get((Configuration)hconf).setInputPath(new Path("hdfs:///testDir/testFile"));
            ArrayList<String> aliases = new ArrayList<String>();
            aliases.add("a");
            aliases.add("b");
            LinkedHashMap<String, ArrayList<String>> pathToAliases = new LinkedHashMap<String, ArrayList<String>>();
            pathToAliases.put("hdfs:///testDir", aliases);
            TableDesc td = Utilities.defaultTd;
            PartitionDesc pd = new PartitionDesc(td, null);
            LinkedHashMap<String, PartitionDesc> pathToPartitionInfo = new LinkedHashMap<String, PartitionDesc>();
            pathToPartitionInfo.put("hdfs:///testDir", pd);
            CompilationOpContext ctx = new CompilationOpContext();
            CollectDesc cd = new CollectDesc(Integer.valueOf(1));
            CollectOperator cdop1 = (CollectOperator)OperatorFactory.get((CompilationOpContext)ctx, CollectDesc.class);
            cdop1.setConf((OperatorDesc)cd);
            CollectOperator cdop2 = (CollectOperator)OperatorFactory.get((CompilationOpContext)ctx, CollectDesc.class);
            cdop2.setConf((OperatorDesc)cd);
            LinkedHashMap<String, CollectOperator> aliasToWork = new LinkedHashMap<String, CollectOperator>();
            aliasToWork.put("a", cdop1);
            aliasToWork.put("b", cdop2);
            MapredWork mrwork = new MapredWork();
            mrwork.getMapWork().setPathToAliases(pathToAliases);
            mrwork.getMapWork().setPathToPartitionInfo(pathToPartitionInfo);
            mrwork.getMapWork().setAliasToWork(aliasToWork);
            MapOperator mo = new MapOperator(new CompilationOpContext());
            mo.initializeAsRoot(hconf, mrwork.getMapWork());
            Text tw = new Text();
            InspectableObject io1 = new InspectableObject();
            InspectableObject io2 = new InspectableObject();
            for (int i = 0; i < 5; ++i) {
                String answer = "[[" + i + ", " + (i + 1) + ", " + (i + 2) + "]]";
                tw.set("" + i + "\u0001" + (i + 1) + "\u0001" + (i + 2));
                mo.process((Writable)tw);
                cdop1.retrieve(io1);
                cdop2.retrieve(io2);
                System.out.println("io1.o.toString() = " + io1.o.toString());
                System.out.println("io2.o.toString() = " + io2.o.toString());
                System.out.println("answer.toString() = " + answer.toString());
                TestOperators.assertEquals((String)answer.toString(), (String)io1.o.toString());
                TestOperators.assertEquals((String)answer.toString(), (String)io2.o.toString());
            }
            System.out.println("Map Operator ok");
        }
        catch (Throwable e) {
            e.printStackTrace();
            throw e;
        }
    }

    @Test
    public void testFetchOperatorContextQuoting() throws Exception {
        JobConf conf = new JobConf();
        ArrayList<Path> list = new ArrayList<Path>();
        list.add(new Path("hdfs://nn.example.com/fi\tl\\e\t1"));
        list.add(new Path("hdfs://nn.example.com/file\t2"));
        list.add(new Path("file:/file3"));
        FetchOperator.setFetchOperatorContext((JobConf)conf, list);
        String[] parts = conf.get("hive.complete.dir.list").split("\t");
        TestOperators.assertEquals((int)3, (int)parts.length);
        TestOperators.assertEquals((String)"hdfs://nn.example.com/fi\\tl\\\\e\\t1", (String)parts[0]);
        TestOperators.assertEquals((String)"hdfs://nn.example.com/file\\t2", (String)parts[1]);
        TestOperators.assertEquals((String)"file:/file3", (String)parts[2]);
    }

    @Test
    public void testFetchOperatorContext() throws Exception {
        HiveConf conf = new HiveConf();
        conf.set("hive.support.concurrency", "false");
        conf.setVar(HiveConf.ConfVars.HIVEMAPREDMODE, "nonstrict");
        SessionState.start((HiveConf)conf);
        String cmd = "create table fetchOp (id int, name string) partitioned by (state string) row format delimited fields terminated by '|' stored as inputformat 'org.apache.hadoop.hive.ql.exec.TestOperators$CustomInFmt' outputformat 'org.apache.hadoop.hive.ql.io.HiveIgnoreKeyTextOutputFormat' tblproperties ('myprop1'='val1', 'myprop2' = 'val2')";
        Driver driver = new Driver();
        driver.init();
        CommandProcessorResponse response = driver.run(cmd);
        TestOperators.assertEquals((int)0, (int)response.getResponseCode());
        ArrayList result = new ArrayList();
        cmd = "load data local inpath '../data/files/employee.dat' overwrite into table fetchOp partition (state='CA')";
        driver.init();
        response = driver.run(cmd);
        TestOperators.assertEquals((int)0, (int)response.getResponseCode());
        cmd = "load data local inpath '../data/files/employee2.dat' overwrite into table fetchOp partition (state='OR')";
        driver.init();
        response = driver.run(cmd);
        TestOperators.assertEquals((int)0, (int)response.getResponseCode());
        cmd = "select * from fetchOp";
        driver.init();
        driver.setMaxRows(500);
        response = driver.run(cmd);
        TestOperators.assertEquals((int)0, (int)response.getResponseCode());
        driver.getResults(result);
        TestOperators.assertEquals((int)20, (int)result.size());
        driver.close();
    }

    public static class CustomInFmt
    extends TextInputFormat {
        public InputSplit[] getSplits(JobConf job, int splits) throws IOException {
            TestCase.assertEquals((String)"val1", (String)job.get("myprop1"));
            TestCase.assertEquals((String)"val2", (String)job.get("myprop2"));
            String[] dirs = job.get("hive.complete.dir.list").split("\t");
            TestCase.assertEquals((int)2, (int)dirs.length);
            TestCase.assertEquals((boolean)true, (boolean)dirs[0].endsWith("/state=CA"));
            TestCase.assertEquals((boolean)true, (boolean)dirs[1].endsWith("/state=OR"));
            return super.getSplits(job, splits);
        }
    }
}

