/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.io.orc;

import com.google.common.math.LongMath;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigInteger;
import org.apache.hadoop.hive.ql.io.orc.SerializationUtils;
import org.junit.Assert;
import org.junit.Test;

public class TestSerializationUtils {
    private InputStream fromBuffer(ByteArrayOutputStream buffer) {
        return new ByteArrayInputStream(buffer.toByteArray());
    }

    @Test
    public void testDoubles() throws Exception {
        double tolerance = 1.0E-16;
        ByteArrayOutputStream buffer = new ByteArrayOutputStream();
        SerializationUtils utils = new SerializationUtils();
        utils.writeDouble((OutputStream)buffer, 1.343822337759E9);
        Assert.assertEquals((double)1.343822337759E9, (double)utils.readDouble(this.fromBuffer(buffer)), (double)tolerance);
        buffer = new ByteArrayOutputStream();
        utils.writeDouble((OutputStream)buffer, 0.8);
        double got = utils.readDouble(this.fromBuffer(buffer));
        Assert.assertEquals((double)0.8, (double)got, (double)tolerance);
    }

    @Test
    public void testBigIntegers() throws Exception {
        ByteArrayOutputStream buffer = new ByteArrayOutputStream();
        SerializationUtils.writeBigInteger((OutputStream)buffer, (BigInteger)BigInteger.valueOf(0L));
        Assert.assertArrayEquals((byte[])new byte[]{0}, (byte[])buffer.toByteArray());
        Assert.assertEquals((long)0L, (long)SerializationUtils.readBigInteger((InputStream)this.fromBuffer(buffer)).longValue());
        buffer.reset();
        SerializationUtils.writeBigInteger((OutputStream)buffer, (BigInteger)BigInteger.valueOf(1L));
        Assert.assertArrayEquals((byte[])new byte[]{2}, (byte[])buffer.toByteArray());
        Assert.assertEquals((long)1L, (long)SerializationUtils.readBigInteger((InputStream)this.fromBuffer(buffer)).longValue());
        buffer.reset();
        SerializationUtils.writeBigInteger((OutputStream)buffer, (BigInteger)BigInteger.valueOf(-1L));
        Assert.assertArrayEquals((byte[])new byte[]{1}, (byte[])buffer.toByteArray());
        Assert.assertEquals((long)-1L, (long)SerializationUtils.readBigInteger((InputStream)this.fromBuffer(buffer)).longValue());
        buffer.reset();
        SerializationUtils.writeBigInteger((OutputStream)buffer, (BigInteger)BigInteger.valueOf(50L));
        Assert.assertArrayEquals((byte[])new byte[]{100}, (byte[])buffer.toByteArray());
        Assert.assertEquals((long)50L, (long)SerializationUtils.readBigInteger((InputStream)this.fromBuffer(buffer)).longValue());
        buffer.reset();
        SerializationUtils.writeBigInteger((OutputStream)buffer, (BigInteger)BigInteger.valueOf(-50L));
        Assert.assertArrayEquals((byte[])new byte[]{99}, (byte[])buffer.toByteArray());
        Assert.assertEquals((long)-50L, (long)SerializationUtils.readBigInteger((InputStream)this.fromBuffer(buffer)).longValue());
        for (int i = -8192; i < 8192; ++i) {
            buffer.reset();
            SerializationUtils.writeBigInteger((OutputStream)buffer, (BigInteger)BigInteger.valueOf(i));
            Assert.assertEquals((String)("compare length for " + i), (long)(i >= -64 && i < 64 ? 1L : 2L), (long)buffer.size());
            Assert.assertEquals((String)("compare result for " + i), (long)i, (long)SerializationUtils.readBigInteger((InputStream)this.fromBuffer(buffer)).intValue());
        }
        buffer.reset();
        SerializationUtils.writeBigInteger((OutputStream)buffer, (BigInteger)new BigInteger("123456789abcdef0", 16));
        Assert.assertEquals((Object)new BigInteger("123456789abcdef0", 16), (Object)SerializationUtils.readBigInteger((InputStream)this.fromBuffer(buffer)));
        buffer.reset();
        SerializationUtils.writeBigInteger((OutputStream)buffer, (BigInteger)new BigInteger("-123456789abcdef0", 16));
        Assert.assertEquals((Object)new BigInteger("-123456789abcdef0", 16), (Object)SerializationUtils.readBigInteger((InputStream)this.fromBuffer(buffer)));
        StringBuilder buf = new StringBuilder();
        for (int i = 0; i < 256; ++i) {
            String num = Integer.toHexString(i);
            if (num.length() == 1) {
                buf.append('0');
            }
            buf.append(num);
        }
        buffer.reset();
        SerializationUtils.writeBigInteger((OutputStream)buffer, (BigInteger)new BigInteger(buf.toString(), 16));
        Assert.assertEquals((Object)new BigInteger(buf.toString(), 16), (Object)SerializationUtils.readBigInteger((InputStream)this.fromBuffer(buffer)));
        buffer.reset();
        SerializationUtils.writeBigInteger((OutputStream)buffer, (BigInteger)new BigInteger("ff000000000000000000000000000000000000000000ff", 16));
        Assert.assertEquals((Object)new BigInteger("ff000000000000000000000000000000000000000000ff", 16), (Object)SerializationUtils.readBigInteger((InputStream)this.fromBuffer(buffer)));
    }

    @Test
    public void testSubtractionOverflow() {
        SerializationUtils utils = new SerializationUtils();
        Assert.assertEquals((Object)false, (Object)utils.isSafeSubtract(22222222222L, Long.MIN_VALUE));
        Assert.assertEquals((Object)false, (Object)utils.isSafeSubtract(-22222222222L, Long.MAX_VALUE));
        Assert.assertEquals((Object)false, (Object)utils.isSafeSubtract(Long.MIN_VALUE, Long.MAX_VALUE));
        Assert.assertEquals((Object)true, (Object)utils.isSafeSubtract(-1553103058346370095L, 6553103058346370095L));
        Assert.assertEquals((Object)true, (Object)utils.isSafeSubtract(0L, Long.MAX_VALUE));
        Assert.assertEquals((Object)true, (Object)utils.isSafeSubtract(Long.MIN_VALUE, 0L));
    }

    @Test
    public void testSubtractionOverflowGuava() {
        try {
            LongMath.checkedSubtract((long)22222222222L, (long)Long.MIN_VALUE);
            Assert.fail((String)"expected ArithmeticException for overflow");
        }
        catch (ArithmeticException ex) {
            Assert.assertEquals((Object)ex.getMessage(), (Object)"overflow");
        }
        try {
            LongMath.checkedSubtract((long)-22222222222L, (long)Long.MAX_VALUE);
            Assert.fail((String)"expected ArithmeticException for overflow");
        }
        catch (ArithmeticException ex) {
            Assert.assertEquals((Object)ex.getMessage(), (Object)"overflow");
        }
        try {
            LongMath.checkedSubtract((long)Long.MIN_VALUE, (long)Long.MAX_VALUE);
            Assert.fail((String)"expected ArithmeticException for overflow");
        }
        catch (ArithmeticException ex) {
            Assert.assertEquals((Object)ex.getMessage(), (Object)"overflow");
        }
        Assert.assertEquals((long)-8106206116692740190L, (long)LongMath.checkedSubtract((long)-1553103058346370095L, (long)6553103058346370095L));
        Assert.assertEquals((long)-9223372036854775807L, (long)LongMath.checkedSubtract((long)0L, (long)Long.MAX_VALUE));
        Assert.assertEquals((long)Long.MIN_VALUE, (long)LongMath.checkedSubtract((long)Long.MIN_VALUE, (long)0L));
    }

    public static void main(String[] args) throws Exception {
        TestSerializationUtils test = new TestSerializationUtils();
        test.testDoubles();
        test.testBigIntegers();
    }
}

