/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.io.orc;

import java.io.File;
import java.io.IOException;
import java.lang.management.ManagementFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.io.orc.CompressionKind;
import org.apache.hadoop.hive.ql.io.orc.OrcFile;
import org.apache.hadoop.hive.ql.io.orc.TestOrcFile;
import org.apache.hadoop.hive.ql.io.orc.Writer;
import org.apache.hadoop.hive.ql.io.orc.WriterImpl;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspectorFactory;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TestName;

public class TestOrcWideTable {
    private static final int MEMORY_FOR_ORC = 0x20000000;
    Path workDir = new Path(System.getProperty("test.tmp.dir", "target" + File.separator + "test" + File.separator + "tmp"));
    Configuration conf;
    FileSystem fs;
    Path testFilePath;
    float memoryPercent;
    @Rule
    public TestName testCaseName = new TestName();

    @Before
    public void openFileSystem() throws Exception {
        this.conf = new Configuration();
        this.fs = FileSystem.getLocal((Configuration)this.conf);
        this.testFilePath = new Path(this.workDir, "TestOrcFile." + this.testCaseName.getMethodName() + ".orc");
        this.fs.delete(this.testFilePath, false);
        this.memoryPercent = 5.368709E8f / (float)ManagementFactory.getMemoryMXBean().getHeapMemoryUsage().getMax();
        this.conf.setFloat(HiveConf.ConfVars.HIVE_ORC_FILE_MEMORY_POOL.varname, this.memoryPercent);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testBufferSizeFor1Col() throws IOException {
        Class<TestOrcFile> clazz = TestOrcFile.class;
        synchronized (TestOrcFile.class) {
            ObjectInspector inspector = ObjectInspectorFactory.getReflectionObjectInspector(Long.class, (ObjectInspectorFactory.ObjectInspectorOptions)ObjectInspectorFactory.ObjectInspectorOptions.JAVA);
            // ** MonitorExit[var2_1] (shouldn't be in output)
            int bufferSize = 131072;
            Writer writer = OrcFile.createWriter((Path)this.testFilePath, (OrcFile.WriterOptions)OrcFile.writerOptions((Configuration)this.conf).inspector(inspector).stripeSize(100000L).compress(CompressionKind.NONE).bufferSize(bufferSize));
            if (writer instanceof WriterImpl) {
                WriterImpl orcWriter = (WriterImpl)writer;
                int newBufferSize = orcWriter.getEstimatedBufferSize(bufferSize);
                Assert.assertEquals((long)bufferSize, (long)newBufferSize);
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testBufferSizeFor1000Col() throws IOException {
        Class<TestOrcFile> clazz = TestOrcFile.class;
        synchronized (TestOrcFile.class) {
            ObjectInspector inspector = ObjectInspectorFactory.getReflectionObjectInspector(Long.class, (ObjectInspectorFactory.ObjectInspectorOptions)ObjectInspectorFactory.ObjectInspectorOptions.JAVA);
            // ** MonitorExit[var2_1] (shouldn't be in output)
            int bufferSize = 131072;
            String columns = this.getRandomColumnNames(1000);
            this.conf.set("columns", columns);
            Writer writer = OrcFile.createWriter((Path)this.testFilePath, (OrcFile.WriterOptions)OrcFile.writerOptions((Configuration)this.conf).inspector(inspector).stripeSize(100000L).compress(CompressionKind.NONE).bufferSize(bufferSize));
            if (writer instanceof WriterImpl) {
                WriterImpl orcWriter = (WriterImpl)writer;
                int newBufferSize = orcWriter.getEstimatedBufferSize(bufferSize);
                Assert.assertEquals((long)bufferSize, (long)newBufferSize);
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testBufferSizeFor2000Col() throws IOException {
        Class<TestOrcFile> clazz = TestOrcFile.class;
        synchronized (TestOrcFile.class) {
            ObjectInspector inspector = ObjectInspectorFactory.getReflectionObjectInspector(Long.class, (ObjectInspectorFactory.ObjectInspectorOptions)ObjectInspectorFactory.ObjectInspectorOptions.JAVA);
            // ** MonitorExit[var2_1] (shouldn't be in output)
            int bufferSize = 262144;
            String columns = this.getRandomColumnNames(2000);
            this.conf.set("columns", columns);
            Writer writer = OrcFile.createWriter((Path)this.testFilePath, (OrcFile.WriterOptions)OrcFile.writerOptions((Configuration)this.conf).inspector(inspector).stripeSize(100000L).compress(CompressionKind.ZLIB).bufferSize(bufferSize));
            if (writer instanceof WriterImpl) {
                WriterImpl orcWriter = (WriterImpl)writer;
                int newBufferSize = orcWriter.getEstimatedBufferSize(bufferSize);
                Assert.assertEquals((long)32768L, (long)newBufferSize);
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testBufferSizeFor2000ColNoCompression() throws IOException {
        Class<TestOrcFile> clazz = TestOrcFile.class;
        synchronized (TestOrcFile.class) {
            ObjectInspector inspector = ObjectInspectorFactory.getReflectionObjectInspector(Long.class, (ObjectInspectorFactory.ObjectInspectorOptions)ObjectInspectorFactory.ObjectInspectorOptions.JAVA);
            // ** MonitorExit[var2_1] (shouldn't be in output)
            int bufferSize = 262144;
            String columns = this.getRandomColumnNames(2000);
            this.conf.set("columns", columns);
            Writer writer = OrcFile.createWriter((Path)this.testFilePath, (OrcFile.WriterOptions)OrcFile.writerOptions((Configuration)this.conf).inspector(inspector).stripeSize(100000L).compress(CompressionKind.NONE).bufferSize(bufferSize));
            if (writer instanceof WriterImpl) {
                WriterImpl orcWriter = (WriterImpl)writer;
                int newBufferSize = orcWriter.getEstimatedBufferSize(bufferSize);
                Assert.assertEquals((long)65536L, (long)newBufferSize);
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testBufferSizeFor4000Col() throws IOException {
        Class<TestOrcFile> clazz = TestOrcFile.class;
        synchronized (TestOrcFile.class) {
            ObjectInspector inspector = ObjectInspectorFactory.getReflectionObjectInspector(Long.class, (ObjectInspectorFactory.ObjectInspectorOptions)ObjectInspectorFactory.ObjectInspectorOptions.JAVA);
            // ** MonitorExit[var2_1] (shouldn't be in output)
            int bufferSize = 262144;
            String columns = this.getRandomColumnNames(4000);
            this.conf.set("columns", columns);
            Writer writer = OrcFile.createWriter((Path)this.testFilePath, (OrcFile.WriterOptions)OrcFile.writerOptions((Configuration)this.conf).inspector(inspector).stripeSize(100000L).compress(CompressionKind.ZLIB).bufferSize(bufferSize));
            if (writer instanceof WriterImpl) {
                WriterImpl orcWriter = (WriterImpl)writer;
                int newBufferSize = orcWriter.getEstimatedBufferSize(bufferSize);
                Assert.assertEquals((long)16384L, (long)newBufferSize);
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testBufferSizeFor4000ColNoCompression() throws IOException {
        Class<TestOrcFile> clazz = TestOrcFile.class;
        synchronized (TestOrcFile.class) {
            ObjectInspector inspector = ObjectInspectorFactory.getReflectionObjectInspector(Long.class, (ObjectInspectorFactory.ObjectInspectorOptions)ObjectInspectorFactory.ObjectInspectorOptions.JAVA);
            // ** MonitorExit[var2_1] (shouldn't be in output)
            int bufferSize = 262144;
            String columns = this.getRandomColumnNames(4000);
            this.conf.set("columns", columns);
            Writer writer = OrcFile.createWriter((Path)this.testFilePath, (OrcFile.WriterOptions)OrcFile.writerOptions((Configuration)this.conf).inspector(inspector).stripeSize(100000L).compress(CompressionKind.NONE).bufferSize(bufferSize));
            if (writer instanceof WriterImpl) {
                WriterImpl orcWriter = (WriterImpl)writer;
                int newBufferSize = orcWriter.getEstimatedBufferSize(bufferSize);
                Assert.assertEquals((long)32768L, (long)newBufferSize);
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testBufferSizeFor25000Col() throws IOException {
        Class<TestOrcFile> clazz = TestOrcFile.class;
        synchronized (TestOrcFile.class) {
            ObjectInspector inspector = ObjectInspectorFactory.getReflectionObjectInspector(Long.class, (ObjectInspectorFactory.ObjectInspectorOptions)ObjectInspectorFactory.ObjectInspectorOptions.JAVA);
            // ** MonitorExit[var2_1] (shouldn't be in output)
            int bufferSize = 262144;
            String columns = this.getRandomColumnNames(25000);
            this.conf.set("columns", columns);
            Writer writer = OrcFile.createWriter((Path)this.testFilePath, (OrcFile.WriterOptions)OrcFile.writerOptions((Configuration)this.conf).inspector(inspector).stripeSize(100000L).compress(CompressionKind.NONE).bufferSize(bufferSize));
            if (writer instanceof WriterImpl) {
                WriterImpl orcWriter = (WriterImpl)writer;
                int newBufferSize = orcWriter.getEstimatedBufferSize(bufferSize);
                Assert.assertEquals((long)4096L, (long)newBufferSize);
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testBufferSizeManualOverride1() throws IOException {
        Class<TestOrcFile> clazz = TestOrcFile.class;
        synchronized (TestOrcFile.class) {
            ObjectInspector inspector = ObjectInspectorFactory.getReflectionObjectInspector(Long.class, (ObjectInspectorFactory.ObjectInspectorOptions)ObjectInspectorFactory.ObjectInspectorOptions.JAVA);
            // ** MonitorExit[var2_1] (shouldn't be in output)
            int bufferSize = 1024;
            String columns = this.getRandomColumnNames(2000);
            this.conf.set("columns", columns);
            Writer writer = OrcFile.createWriter((Path)this.testFilePath, (OrcFile.WriterOptions)OrcFile.writerOptions((Configuration)this.conf).inspector(inspector).stripeSize(100000L).compress(CompressionKind.NONE).bufferSize(bufferSize));
            if (writer instanceof WriterImpl) {
                WriterImpl orcWriter = (WriterImpl)writer;
                int newBufferSize = orcWriter.getEstimatedBufferSize(bufferSize);
                Assert.assertEquals((long)bufferSize, (long)newBufferSize);
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testBufferSizeManualOverride2() throws IOException {
        Class<TestOrcFile> clazz = TestOrcFile.class;
        synchronized (TestOrcFile.class) {
            ObjectInspector inspector = ObjectInspectorFactory.getReflectionObjectInspector(Long.class, (ObjectInspectorFactory.ObjectInspectorOptions)ObjectInspectorFactory.ObjectInspectorOptions.JAVA);
            // ** MonitorExit[var2_1] (shouldn't be in output)
            int bufferSize = 2048;
            String columns = this.getRandomColumnNames(4000);
            this.conf.set("columns", columns);
            Writer writer = OrcFile.createWriter((Path)this.testFilePath, (OrcFile.WriterOptions)OrcFile.writerOptions((Configuration)this.conf).inspector(inspector).stripeSize(100000L).compress(CompressionKind.NONE).bufferSize(bufferSize));
            if (writer instanceof WriterImpl) {
                WriterImpl orcWriter = (WriterImpl)writer;
                int newBufferSize = orcWriter.getEstimatedBufferSize(bufferSize);
                Assert.assertEquals((long)bufferSize, (long)newBufferSize);
            }
            return;
        }
    }

    private String getRandomColumnNames(int n) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < n - 1; ++i) {
            sb.append("col").append(i).append(",");
        }
        sb.append("col").append(n - 1);
        return sb.toString();
    }
}

