/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.vector.mapjoin.fast;

import java.util.Random;
import org.apache.hadoop.hive.ql.exec.vector.mapjoin.VectorMapJoinRowBytesContainer;
import org.apache.hadoop.hive.ql.exec.vector.mapjoin.fast.RandomByteArrayStream;
import org.apache.hadoop.hive.serde2.ByteStream;
import org.junit.Assert;
import org.junit.Test;

public class TestVectorMapJoinRowBytesContainer {
    public void doFillReplay(Random random, int maxCount) throws Exception {
        int i;
        RandomByteArrayStream randomByteArrayStream = new RandomByteArrayStream(random);
        VectorMapJoinRowBytesContainer vectorMapJoinRowBytesContainer = new VectorMapJoinRowBytesContainer();
        int count = Math.min(maxCount, random.nextInt(500));
        for (i = 0; i < count; ++i) {
            byte[] bytes = randomByteArrayStream.next();
            ByteStream.Output output = vectorMapJoinRowBytesContainer.getOuputForRowBytes();
            output.write(bytes);
            vectorMapJoinRowBytesContainer.finishRow();
        }
        vectorMapJoinRowBytesContainer.prepareForReading();
        for (i = 0; i < count; ++i) {
            byte[] expectedBytes;
            if (!vectorMapJoinRowBytesContainer.readNext()) {
                Assert.assertTrue((boolean)false);
            }
            byte[] readBytes = vectorMapJoinRowBytesContainer.currentBytes();
            int readOffset = vectorMapJoinRowBytesContainer.currentOffset();
            int readLength = vectorMapJoinRowBytesContainer.currentLength();
            if (readLength != (expectedBytes = randomByteArrayStream.get(i)).length) {
                Assert.assertTrue((boolean)false);
            }
            for (int j = 0; j < readLength; ++j) {
                byte readByte = readBytes[readOffset + j];
                byte expectedByte = expectedBytes[j];
                if (readByte == expectedByte) continue;
                Assert.assertTrue((boolean)false);
            }
        }
    }

    @Test
    public void testFillReplay() throws Exception {
        Random random = new Random(47496L);
        for (int i = 0; i < 10; ++i) {
            this.doFillReplay(random, 1 << i);
        }
    }
}

