/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.lockmgr;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import junit.framework.Assert;
import org.apache.hadoop.hive.ql.lockmgr.DummyTxnManager;
import org.apache.hadoop.hive.ql.lockmgr.HiveLockMode;
import org.apache.hadoop.hive.ql.lockmgr.HiveLockObj;
import org.apache.hadoop.hive.ql.lockmgr.HiveLockObject;
import org.junit.Test;

public class TestDummyTxnManager {
    @Test
    public void testDedupLockObjects() {
        ArrayList<HiveLockObj> lockObjs = new ArrayList<HiveLockObj>();
        String path1 = "path1";
        String path2 = "path2";
        HiveLockObject.HiveLockObjectData lockData1 = new HiveLockObject.HiveLockObjectData("query1", "1", "IMPLICIT", "drop table table1");
        HiveLockObject.HiveLockObjectData lockData2 = new HiveLockObject.HiveLockObjectData("query1", "1", "IMPLICIT", "drop table table1");
        lockObjs.add(new HiveLockObj(new HiveLockObject(path1, lockData1), HiveLockMode.SHARED));
        String name1 = ((HiveLockObj)lockObjs.get(lockObjs.size() - 1)).getName();
        lockObjs.add(new HiveLockObj(new HiveLockObject(path1, lockData1), HiveLockMode.EXCLUSIVE));
        lockObjs.add(new HiveLockObj(new HiveLockObject(path2, lockData2), HiveLockMode.SHARED));
        String name2 = ((HiveLockObj)lockObjs.get(lockObjs.size() - 1)).getName();
        lockObjs.add(new HiveLockObj(new HiveLockObject(path2, lockData2), HiveLockMode.SHARED));
        lockObjs.add(new HiveLockObj(new HiveLockObject(path2, lockData2), HiveLockMode.SHARED));
        DummyTxnManager.dedupLockObjects(lockObjs);
        Assert.assertEquals((String)"Locks should be deduped", (int)2, (int)lockObjs.size());
        Comparator<HiveLockObj> cmp = new Comparator<HiveLockObj>(){

            @Override
            public int compare(HiveLockObj lock1, HiveLockObj lock2) {
                return lock1.getName().compareTo(lock2.getName());
            }
        };
        Collections.sort(lockObjs, cmp);
        HiveLockObj lockObj = (HiveLockObj)lockObjs.get(0);
        Assert.assertEquals((String)name1, (String)lockObj.getName());
        Assert.assertEquals((Object)HiveLockMode.EXCLUSIVE, (Object)lockObj.getMode());
        lockObj = (HiveLockObj)lockObjs.get(1);
        Assert.assertEquals((String)name2, (String)lockObj.getName());
        Assert.assertEquals((Object)HiveLockMode.SHARED, (Object)lockObj.getMode());
    }
}

