/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.vector;

import java.sql.Date;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import junit.framework.TestCase;
import org.apache.commons.lang.ArrayUtils;
import org.apache.hadoop.hive.common.type.HiveChar;
import org.apache.hadoop.hive.common.type.HiveDecimal;
import org.apache.hadoop.hive.common.type.HiveIntervalDayTime;
import org.apache.hadoop.hive.common.type.HiveIntervalYearMonth;
import org.apache.hadoop.hive.common.type.HiveVarchar;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspectorFactory;
import org.apache.hadoop.hive.serde2.objectinspector.PrimitiveObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.StructObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.PrimitiveObjectInspectorFactory;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.WritableBooleanObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.WritableByteObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.WritableDateObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.WritableDoubleObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.WritableFloatObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.WritableHiveCharObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.WritableHiveDecimalObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.WritableHiveIntervalDayTimeObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.WritableHiveIntervalYearMonthObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.WritableHiveVarcharObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.WritableIntObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.WritableLongObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.WritableShortObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.WritableStringObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.WritableTimestampObjectInspector;
import org.apache.hadoop.hive.serde2.typeinfo.CharTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.DecimalTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.PrimitiveTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfoUtils;
import org.apache.hadoop.hive.serde2.typeinfo.VarcharTypeInfo;

public class RandomRowObjectSource {
    private Random r;
    private int columnCount;
    private List<String> typeNames;
    private PrimitiveObjectInspector.PrimitiveCategory[] primitiveCategories;
    private PrimitiveTypeInfo[] primitiveTypeInfos;
    private List<ObjectInspector> primitiveObjectInspectorList;
    private StructObjectInspector rowStructObjectInspector;
    private static String[] possibleHiveTypeNames = new String[]{"boolean", "tinyint", "smallint", "int", "bigint", "date", "float", "double", "string", "char", "varchar", "binary", "date", "timestamp", "interval_year_month", "interval_day_time", "decimal"};
    private static final String DECIMAL_CHARS = "0123456789";

    public List<String> typeNames() {
        return this.typeNames;
    }

    public PrimitiveObjectInspector.PrimitiveCategory[] primitiveCategories() {
        return this.primitiveCategories;
    }

    public PrimitiveTypeInfo[] primitiveTypeInfos() {
        return this.primitiveTypeInfos;
    }

    public StructObjectInspector rowStructObjectInspector() {
        return this.rowStructObjectInspector;
    }

    public void init(Random r) {
        this.r = r;
        this.chooseSchema();
    }

    private void chooseSchema() {
        this.columnCount = 1 + this.r.nextInt(20);
        this.typeNames = new ArrayList<String>(this.columnCount);
        this.primitiveCategories = new PrimitiveObjectInspector.PrimitiveCategory[this.columnCount];
        this.primitiveTypeInfos = new PrimitiveTypeInfo[this.columnCount];
        this.primitiveObjectInspectorList = new ArrayList<ObjectInspector>(this.columnCount);
        ArrayList<String> columnNames = new ArrayList<String>(this.columnCount);
        for (int c = 0; c < this.columnCount; ++c) {
            PrimitiveObjectInspector.PrimitiveCategory primitiveCategory;
            PrimitiveTypeInfo primitiveTypeInfo;
            columnNames.add(String.format("col%d", c));
            int typeNum = this.r.nextInt(possibleHiveTypeNames.length);
            String typeName = possibleHiveTypeNames[typeNum];
            if (typeName.equals("char")) {
                int maxLength = 1 + this.r.nextInt(100);
                typeName = String.format("char(%d)", maxLength);
            } else if (typeName.equals("varchar")) {
                int maxLength = 1 + this.r.nextInt(100);
                typeName = String.format("varchar(%d)", maxLength);
            } else if (typeName.equals("decimal")) {
                typeName = String.format("decimal(%d,%d)", 38, 18);
            }
            this.primitiveTypeInfos[c] = primitiveTypeInfo = (PrimitiveTypeInfo)TypeInfoUtils.getTypeInfoFromTypeString((String)typeName);
            this.primitiveCategories[c] = primitiveCategory = primitiveTypeInfo.getPrimitiveCategory();
            this.primitiveObjectInspectorList.add((ObjectInspector)PrimitiveObjectInspectorFactory.getPrimitiveWritableObjectInspector((PrimitiveTypeInfo)primitiveTypeInfo));
            this.typeNames.add(typeName);
        }
        this.rowStructObjectInspector = ObjectInspectorFactory.getStandardStructObjectInspector(columnNames, this.primitiveObjectInspectorList);
    }

    public Object[][] randomRows(int n) {
        Object[][] result = new Object[n][];
        for (int i = 0; i < n; ++i) {
            result[i] = this.randomRow();
        }
        return result;
    }

    public Object[] randomRow() {
        Object[] row = new Object[this.columnCount];
        for (int c = 0; c < this.columnCount; ++c) {
            Object object = this.randomObject(c);
            if (object == null) {
                throw new Error("Unexpected null for column " + c);
            }
            row[c] = this.getWritableObject(c, object);
            if (row[c] != null) continue;
            throw new Error("Unexpected null for writable for column " + c);
        }
        return row;
    }

    public Object getWritableObject(int column, Object object) {
        ObjectInspector objectInspector = this.primitiveObjectInspectorList.get(column);
        PrimitiveObjectInspector.PrimitiveCategory primitiveCategory = this.primitiveCategories[column];
        PrimitiveTypeInfo primitiveTypeInfo = this.primitiveTypeInfos[column];
        switch (primitiveCategory) {
            case BOOLEAN: {
                return ((WritableBooleanObjectInspector)objectInspector).create(((Boolean)object).booleanValue());
            }
            case BYTE: {
                return ((WritableByteObjectInspector)objectInspector).create(((Byte)object).byteValue());
            }
            case SHORT: {
                return ((WritableShortObjectInspector)objectInspector).create(((Short)object).shortValue());
            }
            case INT: {
                return ((WritableIntObjectInspector)objectInspector).create(((Integer)object).intValue());
            }
            case LONG: {
                return ((WritableLongObjectInspector)objectInspector).create(((Long)object).longValue());
            }
            case DATE: {
                return ((WritableDateObjectInspector)objectInspector).create((Date)object);
            }
            case FLOAT: {
                return ((WritableFloatObjectInspector)objectInspector).create(((Float)object).floatValue());
            }
            case DOUBLE: {
                return ((WritableDoubleObjectInspector)objectInspector).create(((Double)object).doubleValue());
            }
            case STRING: {
                return ((WritableStringObjectInspector)objectInspector).create((String)object);
            }
            case CHAR: {
                WritableHiveCharObjectInspector writableCharObjectInspector = new WritableHiveCharObjectInspector((CharTypeInfo)primitiveTypeInfo);
                return writableCharObjectInspector.create(new HiveChar("", -1));
            }
            case VARCHAR: {
                WritableHiveVarcharObjectInspector writableVarcharObjectInspector = new WritableHiveVarcharObjectInspector((VarcharTypeInfo)primitiveTypeInfo);
                return writableVarcharObjectInspector.create(new HiveVarchar("", -1));
            }
            case BINARY: {
                return PrimitiveObjectInspectorFactory.writableBinaryObjectInspector.create(ArrayUtils.EMPTY_BYTE_ARRAY);
            }
            case TIMESTAMP: {
                return ((WritableTimestampObjectInspector)objectInspector).create(new Timestamp(0L));
            }
            case INTERVAL_YEAR_MONTH: {
                return ((WritableHiveIntervalYearMonthObjectInspector)objectInspector).create(new HiveIntervalYearMonth(0));
            }
            case INTERVAL_DAY_TIME: {
                return ((WritableHiveIntervalDayTimeObjectInspector)objectInspector).create(new HiveIntervalDayTime(0L, 0));
            }
            case DECIMAL: {
                WritableHiveDecimalObjectInspector writableDecimalObjectInspector = new WritableHiveDecimalObjectInspector((DecimalTypeInfo)primitiveTypeInfo);
                return writableDecimalObjectInspector.create(HiveDecimal.ZERO);
            }
        }
        throw new Error("Unknown primitive category " + primitiveCategory);
    }

    public Object randomObject(int column) {
        PrimitiveObjectInspector.PrimitiveCategory primitiveCategory = this.primitiveCategories[column];
        PrimitiveTypeInfo primitiveTypeInfo = this.primitiveTypeInfos[column];
        switch (primitiveCategory) {
            case BOOLEAN: {
                return this.r.nextInt(1) == 1;
            }
            case BYTE: {
                return (byte)this.r.nextInt();
            }
            case SHORT: {
                return (short)this.r.nextInt();
            }
            case INT: {
                return this.r.nextInt();
            }
            case LONG: {
                return this.r.nextLong();
            }
            case DATE: {
                return RandomRowObjectSource.getRandDate(this.r);
            }
            case FLOAT: {
                return Float.valueOf(this.r.nextFloat() * 10.0f - 5.0f);
            }
            case DOUBLE: {
                return this.r.nextDouble() * 10.0 - 5.0;
            }
            case STRING: {
                return RandomRowObjectSource.getRandString(this.r);
            }
            case CHAR: {
                return RandomRowObjectSource.getRandHiveChar(this.r, (CharTypeInfo)primitiveTypeInfo);
            }
            case VARCHAR: {
                return RandomRowObjectSource.getRandHiveVarchar(this.r, (VarcharTypeInfo)primitiveTypeInfo);
            }
            case BINARY: {
                return RandomRowObjectSource.getRandBinary(this.r, 1 + this.r.nextInt(100));
            }
            case TIMESTAMP: {
                return RandomRowObjectSource.getRandTimestamp(this.r);
            }
            case INTERVAL_YEAR_MONTH: {
                return RandomRowObjectSource.getRandIntervalYearMonth(this.r);
            }
            case INTERVAL_DAY_TIME: {
                return RandomRowObjectSource.getRandIntervalDayTime(this.r);
            }
            case DECIMAL: {
                return RandomRowObjectSource.getRandHiveDecimal(this.r, (DecimalTypeInfo)primitiveTypeInfo);
            }
        }
        throw new Error("Unknown primitive category " + primitiveCategory);
    }

    public static String getRandString(Random r) {
        return RandomRowObjectSource.getRandString(r, null, r.nextInt(10));
    }

    public static String getRandString(Random r, String characters, int length) {
        if (characters == null) {
            characters = "ABCDEFGHIJKLMabcdefghijklm";
        }
        StringBuilder sb = new StringBuilder();
        sb.append("");
        for (int i = 0; i < length; ++i) {
            if (characters == null) {
                sb.append((char)r.nextInt(128));
                continue;
            }
            sb.append(characters.charAt(r.nextInt(characters.length())));
        }
        return sb.toString();
    }

    public static HiveChar getRandHiveChar(Random r, CharTypeInfo charTypeInfo) {
        int maxLength = 1 + r.nextInt(charTypeInfo.getLength());
        String randomString = RandomRowObjectSource.getRandString(r, "abcdefghijklmnopqrstuvwxyz", 100);
        HiveChar hiveChar = new HiveChar(randomString, maxLength);
        return hiveChar;
    }

    public static HiveVarchar getRandHiveVarchar(Random r, VarcharTypeInfo varcharTypeInfo) {
        int maxLength = 1 + r.nextInt(varcharTypeInfo.getLength());
        String randomString = RandomRowObjectSource.getRandString(r, "abcdefghijklmnopqrstuvwxyz", 100);
        HiveVarchar hiveVarchar = new HiveVarchar(randomString, maxLength);
        return hiveVarchar;
    }

    public static byte[] getRandBinary(Random r, int len) {
        byte[] bytes = new byte[len];
        for (int j = 0; j < len; ++j) {
            bytes[j] = (byte)r.nextInt();
        }
        return bytes;
    }

    public static HiveDecimal getRandHiveDecimal(Random r, DecimalTypeInfo decimalTypeInfo) {
        StringBuilder sb;
        HiveDecimal bd;
        do {
            sb = new StringBuilder();
            int precision = 1 + r.nextInt(18);
            int scale = 0 + r.nextInt(precision + 1);
            int integerDigits = precision - scale;
            if (r.nextBoolean()) {
                sb.append("-");
            }
            if (integerDigits == 0) {
                sb.append("0");
            } else {
                sb.append(RandomRowObjectSource.getRandString(r, DECIMAL_CHARS, integerDigits));
            }
            if (scale == 0) continue;
            sb.append(".");
            sb.append(RandomRowObjectSource.getRandString(r, DECIMAL_CHARS, scale));
        } while ((bd = HiveDecimal.create((String)sb.toString())).scale() > bd.precision());
        return bd;
    }

    public static Date getRandDate(Random r) {
        String dateStr = String.format("%d-%02d-%02d", 1800 + r.nextInt(500), 1 + r.nextInt(12), 1 + r.nextInt(28));
        Date dateVal = Date.valueOf(dateStr);
        return dateVal;
    }

    public static Timestamp getRandTimestamp(Random r) {
        String optionalNanos = "";
        if (r.nextInt(2) == 1) {
            optionalNanos = String.format(".%09d", 0 + r.nextInt(1000000000));
        }
        String timestampStr = String.format("%d-%02d-%02d %02d:%02d:%02d%s", 1970 + r.nextInt(200), 1 + r.nextInt(12), 1 + r.nextInt(28), 0 + r.nextInt(24), 0 + r.nextInt(60), 0 + r.nextInt(60), optionalNanos);
        Timestamp timestampVal = Timestamp.valueOf(timestampStr);
        return timestampVal;
    }

    public static HiveIntervalYearMonth getRandIntervalYearMonth(Random r) {
        String yearMonthSignStr = r.nextInt(2) == 0 ? "" : "-";
        String intervalYearMonthStr = String.format("%s%d-%d", yearMonthSignStr, 1800 + r.nextInt(500), 0 + r.nextInt(12));
        HiveIntervalYearMonth intervalYearMonthVal = HiveIntervalYearMonth.valueOf((String)intervalYearMonthStr);
        TestCase.assertTrue((intervalYearMonthVal != null ? 1 : 0) != 0);
        return intervalYearMonthVal;
    }

    public static HiveIntervalDayTime getRandIntervalDayTime(Random r) {
        String optionalNanos = "";
        if (r.nextInt(2) == 1) {
            optionalNanos = String.format(".%09d", 0 + r.nextInt(1000000000));
        }
        String yearMonthSignStr = r.nextInt(2) == 0 ? "" : "-";
        String dayTimeStr = String.format("%s%d %02d:%02d:%02d%s", yearMonthSignStr, 1 + r.nextInt(28), 0 + r.nextInt(24), 0 + r.nextInt(60), 0 + r.nextInt(60), optionalNanos);
        HiveIntervalDayTime intervalDayTimeVal = HiveIntervalDayTime.valueOf((String)dayTimeStr);
        TestCase.assertTrue((intervalDayTimeVal != null ? 1 : 0) != 0);
        return intervalDayTimeVal;
    }
}

