/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.udf;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.hadoop.hive.ql.exec.Description;
import org.apache.hadoop.hive.ql.exec.UDF;
import org.apache.hadoop.io.Text;

@Description(name="regexp_replace", value="_FUNC_(str, regexp, rep) - replace all substrings of str that match regexp with rep", extended="Example:\n  > SELECT _FUNC_('100-200', '(\\d+)', 'num') FROM src LIMIT 1;\n  'num-num'")
public class UDFRegExpReplace
extends UDF {
    private final Text lastRegex = new Text();
    private Pattern p = null;
    private final Text lastReplacement = new Text();
    private String replacementString = "";
    private Text result = new Text();

    public Text evaluate(Text s, Text regex, Text replacement) {
        if (s == null || regex == null || replacement == null) {
            return null;
        }
        if (!regex.equals((Object)this.lastRegex) || this.p == null) {
            this.lastRegex.set(regex);
            this.p = Pattern.compile(regex.toString());
        }
        Matcher m = this.p.matcher(s.toString());
        if (!replacement.equals((Object)this.lastReplacement)) {
            this.lastReplacement.set(replacement);
            this.replacementString = replacement.toString();
        }
        StringBuffer sb = new StringBuffer();
        while (m.find()) {
            m.appendReplacement(sb, this.replacementString);
        }
        m.appendTail(sb);
        this.result.set(sb.toString());
        return this.result;
    }
}

