/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.io.parquet;

import java.util.Arrays;
import java.util.List;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.ql.io.parquet.AbstractTestParquetDirect;
import org.apache.hadoop.hive.serde2.io.DoubleWritable;
import org.apache.hadoop.io.ArrayWritable;
import org.apache.hadoop.io.IntWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.Writable;
import org.junit.Assert;
import org.junit.Test;
import parquet.io.api.Binary;
import parquet.io.api.RecordConsumer;
import parquet.schema.MessageType;
import parquet.schema.OriginalType;
import parquet.schema.PrimitiveType;
import parquet.schema.Types;

public class TestMapStructures
extends AbstractTestParquetDirect {
    @Test
    public void testStringMapRequiredPrimitive() throws Exception {
        Path test = this.writeDirect("StringMapRequiredPrimitive", (MessageType)((Types.GroupBuilder)((Types.GroupBuilder)((Types.GroupBuilder)((Types.GroupBuilder)((Types.PrimitiveBuilder)((Types.GroupBuilder)Types.buildMessage().optionalGroup().as(OriginalType.MAP)).repeatedGroup().required(PrimitiveType.PrimitiveTypeName.BINARY).as(OriginalType.UTF8)).named("key")).required(PrimitiveType.PrimitiveTypeName.INT32).named("value")).named("key_value")).named("votes")).named("StringMapRequiredPrimitive"), new AbstractTestParquetDirect.DirectWriter(){

            @Override
            public void write(RecordConsumer rc) {
                rc.startMessage();
                rc.startField("votes", 0);
                rc.startGroup();
                rc.startField("key_value", 0);
                rc.startGroup();
                rc.startField("key", 0);
                rc.addBinary(Binary.fromString((String)"lettuce"));
                rc.endField("key", 0);
                rc.startField("value", 1);
                rc.addInteger(34);
                rc.endField("value", 1);
                rc.endGroup();
                rc.startGroup();
                rc.startField("key", 0);
                rc.addBinary(Binary.fromString((String)"cabbage"));
                rc.endField("key", 0);
                rc.startField("value", 1);
                rc.addInteger(18);
                rc.endField("value", 1);
                rc.endGroup();
                rc.endField("key_value", 0);
                rc.endGroup();
                rc.endField("votes", 0);
                rc.endMessage();
            }
        });
        ArrayWritable expected = TestMapStructures.record(new Writable[]{TestMapStructures.list(new Writable[]{TestMapStructures.record(new Writable[]{new Text("lettuce"), new IntWritable(34)}), TestMapStructures.record(new Writable[]{new Text("cabbage"), new IntWritable(18)})})});
        List<ArrayWritable> records = TestMapStructures.read(test);
        Assert.assertEquals((String)"Should have only one record", (long)1L, (long)records.size());
        TestMapStructures.assertEquals("Should match expected record", expected, records.get(0));
        this.deserialize((Writable)records.get(0), Arrays.asList("votes"), Arrays.asList("map<string,int>"));
    }

    @Test
    public void testStringMapOptionalPrimitive() throws Exception {
        Path test = this.writeDirect("StringMapOptionalPrimitive", (MessageType)((Types.GroupBuilder)((Types.GroupBuilder)((Types.GroupBuilder)((Types.GroupBuilder)((Types.PrimitiveBuilder)((Types.GroupBuilder)Types.buildMessage().optionalGroup().as(OriginalType.MAP)).repeatedGroup().required(PrimitiveType.PrimitiveTypeName.BINARY).as(OriginalType.UTF8)).named("key")).optional(PrimitiveType.PrimitiveTypeName.INT32).named("value")).named("key_value")).named("votes")).named("StringMapOptionalPrimitive"), new AbstractTestParquetDirect.DirectWriter(){

            @Override
            public void write(RecordConsumer rc) {
                rc.startMessage();
                rc.startField("votes", 0);
                rc.startGroup();
                rc.startField("key_value", 0);
                rc.startGroup();
                rc.startField("key", 0);
                rc.addBinary(Binary.fromString((String)"lettuce"));
                rc.endField("key", 0);
                rc.startField("value", 1);
                rc.addInteger(34);
                rc.endField("value", 1);
                rc.endGroup();
                rc.startGroup();
                rc.startField("key", 0);
                rc.addBinary(Binary.fromString((String)"kale"));
                rc.endField("key", 0);
                rc.endGroup();
                rc.startGroup();
                rc.startField("key", 0);
                rc.addBinary(Binary.fromString((String)"cabbage"));
                rc.endField("key", 0);
                rc.startField("value", 1);
                rc.addInteger(18);
                rc.endField("value", 1);
                rc.endGroup();
                rc.endField("key_value", 0);
                rc.endGroup();
                rc.endField("votes", 0);
                rc.endMessage();
            }
        });
        ArrayWritable expected = TestMapStructures.record(new Writable[]{TestMapStructures.list(new Writable[]{TestMapStructures.record(new Writable[]{new Text("lettuce"), new IntWritable(34)}), TestMapStructures.record(new Writable[]{new Text("kale"), null}), TestMapStructures.record(new Writable[]{new Text("cabbage"), new IntWritable(18)})})});
        List<ArrayWritable> records = TestMapStructures.read(test);
        Assert.assertEquals((String)"Should have only one record", (long)1L, (long)records.size());
        TestMapStructures.assertEquals("Should match expected record", expected, records.get(0));
        this.deserialize((Writable)records.get(0), Arrays.asList("votes"), Arrays.asList("map<string,int>"));
    }

    @Test
    public void testStringMapOfOptionalArray() throws Exception {
        Path test = this.writeDirect("StringMapOfOptionalArray", (MessageType)((Types.GroupBuilder)((Types.GroupBuilder)((Types.GroupBuilder)((Types.GroupBuilder)((Types.GroupBuilder)((Types.PrimitiveBuilder)((Types.GroupBuilder)((Types.GroupBuilder)((Types.PrimitiveBuilder)((Types.GroupBuilder)Types.buildMessage().optionalGroup().as(OriginalType.MAP)).repeatedGroup().required(PrimitiveType.PrimitiveTypeName.BINARY).as(OriginalType.UTF8)).named("key")).optionalGroup().as(OriginalType.LIST)).repeatedGroup().optional(PrimitiveType.PrimitiveTypeName.BINARY).as(OriginalType.UTF8)).named("element")).named("list")).named("value")).named("key_value")).named("examples")).named("StringMapOfOptionalArray"), new AbstractTestParquetDirect.DirectWriter(){

            @Override
            public void write(RecordConsumer rc) {
                rc.startMessage();
                rc.startField("examples", 0);
                rc.startGroup();
                rc.startField("key_value", 0);
                rc.startGroup();
                rc.startField("key", 0);
                rc.addBinary(Binary.fromString((String)"green"));
                rc.endField("key", 0);
                rc.startField("value", 1);
                rc.startGroup();
                rc.startField("list", 0);
                rc.startGroup();
                rc.startField("element", 0);
                rc.addBinary(Binary.fromString((String)"lettuce"));
                rc.endField("element", 0);
                rc.endGroup();
                rc.startGroup();
                rc.startField("element", 0);
                rc.addBinary(Binary.fromString((String)"kale"));
                rc.endField("element", 0);
                rc.endGroup();
                rc.startGroup();
                rc.endGroup();
                rc.endField("list", 0);
                rc.endGroup();
                rc.endField("value", 1);
                rc.endGroup();
                rc.startGroup();
                rc.startField("key", 0);
                rc.addBinary(Binary.fromString((String)"brown"));
                rc.endField("key", 0);
                rc.endGroup();
                rc.endField("key_value", 0);
                rc.endGroup();
                rc.endField("examples", 0);
                rc.endMessage();
            }
        });
        ArrayWritable expected = TestMapStructures.record(new Writable[]{TestMapStructures.list(new Writable[]{TestMapStructures.record(new Writable[]{new Text("green"), TestMapStructures.list(new Writable[]{new Text("lettuce"), new Text("kale"), null})}), TestMapStructures.record(new Writable[]{new Text("brown"), null})})});
        List<ArrayWritable> records = TestMapStructures.read(test);
        Assert.assertEquals((String)"Should have only one record", (long)1L, (long)records.size());
        TestMapStructures.assertEquals("Should match expected record", expected, records.get(0));
        this.deserialize((Writable)records.get(0), Arrays.asList("examples"), Arrays.asList("map<string,array<string>>"));
    }

    @Test
    public void testStringMapOfOptionalIntArray() throws Exception {
        Path test = this.writeDirect("StringMapOfOptionalIntArray", (MessageType)((Types.GroupBuilder)((Types.GroupBuilder)((Types.GroupBuilder)((Types.GroupBuilder)((Types.GroupBuilder)((Types.GroupBuilder)((Types.GroupBuilder)((Types.PrimitiveBuilder)((Types.GroupBuilder)Types.buildMessage().optionalGroup().as(OriginalType.MAP)).repeatedGroup().required(PrimitiveType.PrimitiveTypeName.BINARY).as(OriginalType.UTF8)).named("key")).optionalGroup().as(OriginalType.LIST)).repeatedGroup().optional(PrimitiveType.PrimitiveTypeName.INT32).named("element")).named("list")).named("value")).named("key_value")).named("examples")).named("StringMapOfOptionalIntArray"), new AbstractTestParquetDirect.DirectWriter(){

            @Override
            public void write(RecordConsumer rc) {
                rc.startMessage();
                rc.startField("examples", 0);
                rc.startGroup();
                rc.startField("key_value", 0);
                rc.startGroup();
                rc.startField("key", 0);
                rc.addBinary(Binary.fromString((String)"low"));
                rc.endField("key", 0);
                rc.startField("value", 1);
                rc.startGroup();
                rc.startField("list", 0);
                rc.startGroup();
                rc.startField("element", 0);
                rc.addInteger(34);
                rc.endField("element", 0);
                rc.endGroup();
                rc.startGroup();
                rc.startField("element", 0);
                rc.addInteger(35);
                rc.endField("element", 0);
                rc.endGroup();
                rc.startGroup();
                rc.endGroup();
                rc.endField("list", 0);
                rc.endGroup();
                rc.endField("value", 1);
                rc.endGroup();
                rc.startGroup();
                rc.startField("key", 0);
                rc.addBinary(Binary.fromString((String)"high"));
                rc.endField("key", 0);
                rc.startField("value", 1);
                rc.startGroup();
                rc.startField("list", 0);
                rc.startGroup();
                rc.startField("element", 0);
                rc.addInteger(340);
                rc.endField("element", 0);
                rc.endGroup();
                rc.startGroup();
                rc.startField("element", 0);
                rc.addInteger(360);
                rc.endField("element", 0);
                rc.endGroup();
                rc.endField("list", 0);
                rc.endGroup();
                rc.endField("value", 1);
                rc.endGroup();
                rc.endField("key_value", 0);
                rc.endGroup();
                rc.endField("examples", 0);
                rc.endMessage();
            }
        });
        ArrayWritable expected = TestMapStructures.record(new Writable[]{TestMapStructures.list(new Writable[]{TestMapStructures.record(new Writable[]{new Text("low"), TestMapStructures.list(new Writable[]{new IntWritable(34), new IntWritable(35), null})}), TestMapStructures.record(new Writable[]{new Text("high"), TestMapStructures.list(new Writable[]{new IntWritable(340), new IntWritable(360)})})})});
        List<ArrayWritable> records = TestMapStructures.read(test);
        Assert.assertEquals((String)"Should have only one record", (long)1L, (long)records.size());
        TestMapStructures.assertEquals("Should match expected record", expected, records.get(0));
        this.deserialize((Writable)records.get(0), Arrays.asList("examples"), Arrays.asList("map<string,array<int>>"));
    }

    @Test
    public void testMapWithComplexKey() throws Exception {
        Path test = this.writeDirect("MapWithComplexKey", (MessageType)((Types.GroupBuilder)((Types.GroupBuilder)((Types.GroupBuilder)((Types.GroupBuilder)((Types.GroupBuilder)((Types.GroupBuilder)((Types.GroupBuilder)Types.buildMessage().optionalGroup().as(OriginalType.MAP)).repeatedGroup().requiredGroup().required(PrimitiveType.PrimitiveTypeName.INT32).named("x")).required(PrimitiveType.PrimitiveTypeName.INT32).named("y")).named("key")).optional(PrimitiveType.PrimitiveTypeName.DOUBLE).named("value")).named("key_value")).named("matrix")).named("MapWithComplexKey"), new AbstractTestParquetDirect.DirectWriter(){

            @Override
            public void write(RecordConsumer rc) {
                rc.startMessage();
                rc.startField("matrix", 0);
                rc.startGroup();
                rc.startField("key_value", 0);
                rc.startGroup();
                rc.startField("key", 0);
                rc.startGroup();
                rc.startField("x", 0);
                rc.addInteger(7);
                rc.endField("x", 0);
                rc.startField("y", 1);
                rc.addInteger(22);
                rc.endField("y", 1);
                rc.endGroup();
                rc.endField("key", 0);
                rc.startField("value", 1);
                rc.addDouble(3.14);
                rc.endField("value", 1);
                rc.endGroup();
                rc.endField("key_value", 0);
                rc.endGroup();
                rc.endField("matrix", 0);
                rc.endMessage();
            }
        });
        ArrayWritable expected = TestMapStructures.record(new Writable[]{TestMapStructures.list(new Writable[]{TestMapStructures.record(new Writable[]{TestMapStructures.record(new Writable[]{new IntWritable(7), new IntWritable(22)}), new DoubleWritable(3.14)})})});
        List<ArrayWritable> records = TestMapStructures.read(test);
        Assert.assertEquals((String)"Should have only one record", (long)1L, (long)records.size());
        TestMapStructures.assertEquals("Should match expected record", expected, records.get(0));
        this.deserialize((Writable)records.get(0), Arrays.asList("matrix"), Arrays.asList("map<struct<x:int,y:int>,bigint>"));
    }

    @Test
    public void testDoubleMapWithStructValue() throws Exception {
        Path test = this.writeDirect("DoubleMapWithStructValue", (MessageType)((Types.GroupBuilder)((Types.GroupBuilder)((Types.GroupBuilder)((Types.GroupBuilder)((Types.GroupBuilder)((Types.GroupBuilder)((Types.GroupBuilder)Types.buildMessage().optionalGroup().as(OriginalType.MAP)).repeatedGroup().optional(PrimitiveType.PrimitiveTypeName.DOUBLE).named("key")).optionalGroup().required(PrimitiveType.PrimitiveTypeName.INT32).named("x")).required(PrimitiveType.PrimitiveTypeName.INT32).named("y")).named("value")).named("key_value")).named("approx")).named("DoubleMapWithStructValue"), new AbstractTestParquetDirect.DirectWriter(){

            @Override
            public void write(RecordConsumer rc) {
                rc.startMessage();
                rc.startField("approx", 0);
                rc.startGroup();
                rc.startField("key_value", 0);
                rc.startGroup();
                rc.startField("key", 0);
                rc.addDouble(3.14);
                rc.endField("key", 0);
                rc.startField("value", 1);
                rc.startGroup();
                rc.startField("x", 0);
                rc.addInteger(7);
                rc.endField("x", 0);
                rc.startField("y", 1);
                rc.addInteger(22);
                rc.endField("y", 1);
                rc.endGroup();
                rc.endField("value", 1);
                rc.endGroup();
                rc.endField("key_value", 0);
                rc.endGroup();
                rc.endField("approx", 0);
                rc.endMessage();
            }
        });
        ArrayWritable expected = TestMapStructures.record(new Writable[]{TestMapStructures.list(new Writable[]{TestMapStructures.record(new Writable[]{new DoubleWritable(3.14), TestMapStructures.record(new Writable[]{new IntWritable(7), new IntWritable(22)})})})});
        List<ArrayWritable> records = TestMapStructures.read(test);
        Assert.assertEquals((String)"Should have only one record", (long)1L, (long)records.size());
        TestMapStructures.assertEquals("Should match expected record", expected, records.get(0));
        this.deserialize((Writable)records.get(0), Arrays.asList("approx"), Arrays.asList("map<bigint,struct<x:int,y:int>>"));
    }

    @Test
    public void testNestedMap() throws Exception {
        Path test = this.writeDirect("DoubleMapWithStructValue", (MessageType)((Types.GroupBuilder)((Types.GroupBuilder)((Types.GroupBuilder)((Types.GroupBuilder)((Types.GroupBuilder)((Types.GroupBuilder)((Types.PrimitiveBuilder)((Types.GroupBuilder)((Types.GroupBuilder)((Types.PrimitiveBuilder)((Types.GroupBuilder)Types.buildMessage().optionalGroup().as(OriginalType.MAP)).repeatedGroup().optional(PrimitiveType.PrimitiveTypeName.BINARY).as(OriginalType.UTF8)).named("key")).optionalGroup().as(OriginalType.MAP)).repeatedGroup().optional(PrimitiveType.PrimitiveTypeName.BINARY).as(OriginalType.UTF8)).named("key")).required(PrimitiveType.PrimitiveTypeName.INT32).named("value")).named("key_value")).named("value")).named("key_value")).named("map_of_maps")).named("NestedMap"), new AbstractTestParquetDirect.DirectWriter(){

            @Override
            public void write(RecordConsumer rc) {
                rc.startMessage();
                rc.startField("map_of_maps", 0);
                rc.startGroup();
                rc.startField("key_value", 0);
                rc.startGroup();
                rc.startField("key", 0);
                rc.addBinary(Binary.fromString((String)"a"));
                rc.endField("key", 0);
                rc.startField("value", 1);
                rc.startGroup();
                rc.startField("key_value", 0);
                rc.startGroup();
                rc.startField("key", 0);
                rc.addBinary(Binary.fromString((String)"b"));
                rc.endField("key", 0);
                rc.startField("value", 1);
                rc.addInteger(1);
                rc.endField("value", 1);
                rc.endGroup();
                rc.endField("key_value", 0);
                rc.endGroup();
                rc.endField("value", 1);
                rc.endGroup();
                rc.startGroup();
                rc.startField("key", 0);
                rc.addBinary(Binary.fromString((String)"b"));
                rc.endField("key", 0);
                rc.startField("value", 1);
                rc.startGroup();
                rc.startField("key_value", 0);
                rc.startGroup();
                rc.startField("key", 0);
                rc.addBinary(Binary.fromString((String)"a"));
                rc.endField("key", 0);
                rc.startField("value", 1);
                rc.addInteger(-1);
                rc.endField("value", 1);
                rc.endGroup();
                rc.startGroup();
                rc.startField("key", 0);
                rc.addBinary(Binary.fromString((String)"b"));
                rc.endField("key", 0);
                rc.startField("value", 1);
                rc.addInteger(-2);
                rc.endField("value", 1);
                rc.endGroup();
                rc.endField("key_value", 0);
                rc.endGroup();
                rc.endField("value", 1);
                rc.endGroup();
                rc.endField("key_value", 0);
                rc.endGroup();
                rc.endField("map_of_maps", 0);
                rc.endMessage();
            }
        });
        ArrayWritable expected = TestMapStructures.record(new Writable[]{TestMapStructures.list(new Writable[]{TestMapStructures.record(new Writable[]{new Text("a"), TestMapStructures.list(new Writable[]{TestMapStructures.record(new Writable[]{new Text("b"), new IntWritable(1)})})}), TestMapStructures.record(new Writable[]{new Text("b"), TestMapStructures.list(new Writable[]{TestMapStructures.record(new Writable[]{new Text("a"), new IntWritable(-1)}), TestMapStructures.record(new Writable[]{new Text("b"), new IntWritable(-2)})})})})});
        List<ArrayWritable> records = TestMapStructures.read(test);
        Assert.assertEquals((String)"Should have only one record", (long)1L, (long)records.size());
        TestMapStructures.assertEquals("Should match expected record", expected, records.get(0));
        this.deserialize((Writable)records.get(0), Arrays.asList("map_of_maps"), Arrays.asList("map<string,map<string,int>>"));
    }
}

