/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.hooks;

import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.Driver;
import org.apache.hadoop.hive.ql.hooks.HookUtils;
import org.apache.hadoop.hive.ql.hooks.Redactor;
import org.apache.hadoop.hive.ql.session.SessionState;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;

public class TestHooks {
    @BeforeClass
    public static void onetimeSetup() throws Exception {
        HiveConf conf = new HiveConf(TestHooks.class);
        Driver driver = TestHooks.createDriver(conf);
        int ret = driver.run("create table t1(i int)").getResponseCode();
        Assert.assertEquals((String)"Checking command success", (long)0L, (long)ret);
    }

    @AfterClass
    public static void onetimeTeardown() throws Exception {
        HiveConf conf = new HiveConf(TestHooks.class);
        Driver driver = TestHooks.createDriver(conf);
        driver.run("drop table t1");
    }

    @Before
    public void setup() {
    }

    @Test
    public void testRedactLogString() throws Exception {
        HiveConf conf = new HiveConf(TestHooks.class);
        HiveConf.setVar((Configuration)conf, (HiveConf.ConfVars)HiveConf.ConfVars.QUERYREDACTORHOOKS, (String)SimpleQueryRedactor.class.getName());
        String str = HookUtils.redactLogString(null, null);
        Assert.assertEquals((Object)str, null);
        str = HookUtils.redactLogString((HiveConf)conf, null);
        Assert.assertEquals((Object)str, null);
        str = HookUtils.redactLogString((HiveConf)conf, (String)"select 'XXX' from t1");
        Assert.assertEquals((Object)str, (Object)"select 'AAA' from t1");
    }

    @Test
    public void testQueryRedactor() throws Exception {
        HiveConf conf = new HiveConf(TestHooks.class);
        HiveConf.setVar((Configuration)conf, (HiveConf.ConfVars)HiveConf.ConfVars.QUERYREDACTORHOOKS, (String)SimpleQueryRedactor.class.getName());
        Driver driver = TestHooks.createDriver(conf);
        int ret = driver.compile("select 'XXX' from t1");
        Assert.assertEquals((String)"Checking command success", (long)0L, (long)ret);
        Assert.assertEquals((Object)"select 'AAA' from t1", (Object)HiveConf.getVar((Configuration)conf, (HiveConf.ConfVars)HiveConf.ConfVars.HIVEQUERYSTRING));
    }

    private static Driver createDriver(HiveConf conf) {
        HiveConf.setBoolVar((Configuration)conf, (HiveConf.ConfVars)HiveConf.ConfVars.HIVE_SUPPORT_CONCURRENCY, (boolean)false);
        SessionState.start((HiveConf)conf);
        Driver driver = new Driver(conf);
        driver.init();
        return driver;
    }

    public static class SimpleQueryRedactor
    extends Redactor {
        public String redactQuery(String query) {
            return query.replaceAll("XXX", "AAA");
        }
    }
}

