/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.udf;

import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.udf.UDFJson;
import org.apache.hadoop.io.Text;
import org.junit.Assert;
import org.junit.Test;

public class TestUDFJson {
    @Test
    public void testJson() throws HiveException {
        String book0 = "{\"author\":\"Nigel Rees\",\"title\":\"Sayings of the Century\",\"category\":\"reference\",\"price\":8.95}";
        String backet0 = "[1,2,{\"b\":\"y\",\"a\":\"x\"}]";
        String backet = "[" + backet0 + ",[3,4],[5,6]]";
        String backetFlat = backet0.substring(0, backet0.length() - 1) + ",3,4,5,6]";
        String book = "[" + book0 + ",{\"author\":\"Herman Melville\",\"title\":\"Moby Dick\"," + "\"category\":\"fiction\",\"price\":8.99" + ",\"isbn\":\"0-553-21311-3\"},{\"author\":\"J. R. R. Tolkien\"" + ",\"title\":\"The Lord of the Rings\",\"category\":\"fiction\"" + ",\"reader\":[{\"age\":25,\"name\":\"bob\"},{\"age\":26,\"name\":\"jack\"}]" + ",\"price\":22.99,\"isbn\":\"0-395-19395-8\"}]";
        String json = "{\"store\":{\"fruit\":[{\"weight\":8,\"type\":\"apple\"},{\"weight\":9,\"type\":\"pear\"}],\"basket\":" + backet + ",\"book\":" + book + ",\"bicycle\":{\"price\":19.95,\"color\":\"red\"}}" + ",\"email\":\"amy@only_for_json_udf_test.net\"" + ",\"owner\":\"amy\",\"zip code\":\"94025\",\"fb:testid\":\"1234\"}";
        UDFJson udf = new UDFJson();
        this.runTest(json, "$.owner", "amy", udf);
        this.runTest(json, "$.store.bicycle", "{\"price\":19.95,\"color\":\"red\"}", udf);
        this.runTest(json, "$.store.book", book, udf);
        this.runTest(json, "$.store.book[0]", book0, udf);
        this.runTest(json, "$.store.book[*]", book, udf);
        this.runTest(json, "$.store.book[0].category", "reference", udf);
        this.runTest(json, "$.store.book[*].category", "[\"reference\",\"fiction\",\"fiction\"]", udf);
        this.runTest(json, "$.store.book[*].reader[0].age", "25", udf);
        this.runTest(json, "$.store.book[*].reader[*].age", "[25,26]", udf);
        this.runTest(json, "$.store.basket[0][1]", "2", udf);
        this.runTest(json, "$.store.basket[*]", backet, udf);
        this.runTest(json, "$.store.basket[*][0]", "[1,3,5]", udf);
        this.runTest(json, "$.store.basket[0][*]", backet0, udf);
        this.runTest(json, "$.store.basket[*][*]", backetFlat, udf);
        this.runTest(json, "$.store.basket[0][2].b", "y", udf);
        this.runTest(json, "$.store.basket[0][*].b", "[\"y\"]", udf);
        this.runTest(json, "$.non_exist_key", null, udf);
        this.runTest(json, "$.store.book[10]", null, udf);
        this.runTest(json, "$.store.book[0].non_exist_key", null, udf);
        this.runTest(json, "$.store.basket[*].non_exist_key", null, udf);
        this.runTest(json, "$.store.basket[0][*].non_exist_key", null, udf);
        this.runTest(json, "$.store.basket[*][*].non_exist_key", null, udf);
        this.runTest(json, "$.zip code", "94025", udf);
        this.runTest(json, "$.fb:testid", "1234", udf);
        this.runTest("{\"a\":\"b\nc\"}", "$.a", "b\nc", udf);
    }

    @Test
    public void testRootArray() throws HiveException {
        UDFJson udf = new UDFJson();
        this.runTest("[1,2,3]", "$[0]", "1", udf);
        this.runTest("[1,2,3]", "$.[0]", "1", udf);
        this.runTest("[1,2,3]", "$.[1]", "2", udf);
        this.runTest("[1,2,3]", "$[1]", "2", udf);
        this.runTest("[1,2,3]", "$[3]", null, udf);
        this.runTest("[1,2,3]", "$.[*]", "[1,2,3]", udf);
        this.runTest("[1,2,3]", "$[*]", "[1,2,3]", udf);
        this.runTest("[1,2,3]", "$", "[1,2,3]", udf);
        this.runTest("[{\"k1\":\"v1\"},{\"k2\":\"v2\"},{\"k3\":\"v3\"}]", "$[2]", "{\"k3\":\"v3\"}", udf);
        this.runTest("[{\"k1\":\"v1\"},{\"k2\":\"v2\"},{\"k3\":\"v3\"}]", "$[2].k3", "v3", udf);
        this.runTest("[{\"k1\":[{\"k11\":[1,2,3]}]}]", "$[0].k1[0].k11[1]", "2", udf);
        this.runTest("[{\"k1\":[{\"k11\":[1,2,3]}]}]", "$[0].k1[0].k11", "[1,2,3]", udf);
        this.runTest("[{\"k1\":[{\"k11\":[1,2,3]}]}]", "$[0].k1[0]", "{\"k11\":[1,2,3]}", udf);
        this.runTest("[{\"k1\":[{\"k11\":[1,2,3]}]}]", "$[0].k1", "[{\"k11\":[1,2,3]}]", udf);
        this.runTest("[{\"k1\":[{\"k11\":[1,2,3]}]}]", "$[0]", "{\"k1\":[{\"k11\":[1,2,3]}]}", udf);
        this.runTest("[[1,2,3],[4,5,6],[7,8,9]]", "$[1]", "[4,5,6]", udf);
        this.runTest("[[1,2,3],[4,5,6],[7,8,9]]", "$[1][0]", "4", udf);
        this.runTest("[\"a\",\"b\"]", "$[1]", "b", udf);
        this.runTest("[[\"a\",\"b\"]]", "$[0][1]", "b", udf);
        this.runTest("[1,2,3]", "[0]", null, udf);
        this.runTest("[1,2,3]", "$0", null, udf);
        this.runTest("[1,2,3]", "0", null, udf);
        this.runTest("[1,2,3]", "$.", null, udf);
        this.runTest("[1,2,3]", "$", "[1,2,3]", udf);
        this.runTest("{\"a\":4}", "$", "{\"a\":4}", udf);
    }

    protected void runTest(String json, String path, String exp, UDFJson udf) {
        Text res = udf.evaluate(json, path);
        if (exp == null) {
            Assert.assertNull((Object)res);
        } else {
            Assert.assertNotNull((Object)res);
            Assert.assertEquals((String)"get_json_object test", (Object)exp, (Object)res.toString());
        }
    }
}

