/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.vector;

import java.util.Arrays;
import junit.framework.Assert;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.ql.exec.vector.VectorLimitOperator;
import org.apache.hadoop.hive.ql.exec.vector.VectorizedRowBatch;
import org.apache.hadoop.hive.ql.exec.vector.util.FakeVectorRowBatchFromObjectIterables;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.plan.LimitDesc;
import org.apache.hadoop.hive.ql.plan.OperatorDesc;
import org.junit.Test;

public class TestVectorLimitOperator {
    @Test
    public void testLimitLessThanBatchSize() throws HiveException {
        this.validateVectorLimitOperator(2, 5, 2);
    }

    @Test
    public void testLimitGreaterThanBatchSize() throws HiveException {
        this.validateVectorLimitOperator(100, 3, 3);
    }

    @Test
    public void testLimitWithZeroBatchSize() throws HiveException {
        this.validateVectorLimitOperator(5, 0, 0);
    }

    private void validateVectorLimitOperator(int limit, int batchSize, int expectedBatchSize) throws HiveException {
        FakeVectorRowBatchFromObjectIterables frboi = new FakeVectorRowBatchFromObjectIterables(batchSize, new String[]{"tinyint", "double"}, Arrays.asList(1, 2, 3, 4), Arrays.asList(323.0, 34.5, null, 89.3));
        VectorizedRowBatch vrb = frboi.produceNextBatch();
        LimitDesc ld = new LimitDesc(limit);
        VectorLimitOperator lo = new VectorLimitOperator(null, (OperatorDesc)ld);
        lo.initialize(new Configuration(), null);
        lo.process((Object)vrb, 0);
        Assert.assertEquals((int)vrb.size, (int)expectedBatchSize);
    }
}

