/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.tez;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.hadoop.hive.ql.exec.tez.DynamicPartitionPruner;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.plan.ExprNodeDesc;
import org.apache.hadoop.hive.ql.plan.MapWork;
import org.apache.hadoop.hive.ql.plan.TableDesc;
import org.apache.hadoop.hive.serde2.SerDeException;
import org.apache.hadoop.mapred.JobConf;
import org.apache.tez.runtime.api.InputInitializerContext;
import org.apache.tez.runtime.api.events.InputInitializerEvent;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;

public class TestDynamicPartitionPruner {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=5000L)
    public void testNoPruning() throws InterruptedException, IOException, HiveException, SerDeException {
        InputInitializerContext mockInitContext = (InputInitializerContext)Mockito.mock(InputInitializerContext.class);
        MapWork mapWork = (MapWork)Mockito.mock(MapWork.class);
        DynamicPartitionPrunerForEventTesting pruner = new DynamicPartitionPrunerForEventTesting(mockInitContext, mapWork);
        PruneRunnable pruneRunnable = new PruneRunnable(pruner);
        Thread t = new Thread(pruneRunnable);
        t.start();
        try {
            pruneRunnable.start();
            pruneRunnable.awaitEnd();
        }
        finally {
            t.interrupt();
            t.join();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=5000L)
    public void testSingleSourceOrdering1() throws InterruptedException, IOException, HiveException, SerDeException {
        InputInitializerContext mockInitContext = (InputInitializerContext)Mockito.mock(InputInitializerContext.class);
        ((InputInitializerContext)Mockito.doReturn((Object)1).when((Object)mockInitContext)).getVertexNumTasks("v1");
        MapWork mapWork = this.createMockMapWork(new TestSource("v1", 1));
        DynamicPartitionPrunerForEventTesting pruner = new DynamicPartitionPrunerForEventTesting(mockInitContext, mapWork);
        PruneRunnable pruneRunnable = new PruneRunnable(pruner);
        Thread t = new Thread(pruneRunnable);
        t.start();
        try {
            pruneRunnable.start();
            InputInitializerEvent event = InputInitializerEvent.create((String)"FakeTarget", (String)"TargetInput", (ByteBuffer)ByteBuffer.allocate(0));
            event.setSourceVertexName("v1");
            pruner.addEvent(event);
            pruner.processVertex("v1");
            pruneRunnable.awaitEnd();
            Assert.assertFalse((boolean)pruneRunnable.inError.get());
        }
        finally {
            t.interrupt();
            t.join();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=5000L)
    public void testSingleSourceOrdering2() throws InterruptedException, IOException, HiveException, SerDeException {
        InputInitializerContext mockInitContext = (InputInitializerContext)Mockito.mock(InputInitializerContext.class);
        ((InputInitializerContext)Mockito.doReturn((Object)1).when((Object)mockInitContext)).getVertexNumTasks("v1");
        MapWork mapWork = this.createMockMapWork(new TestSource("v1", 1));
        DynamicPartitionPrunerForEventTesting pruner = new DynamicPartitionPrunerForEventTesting(mockInitContext, mapWork);
        PruneRunnable pruneRunnable = new PruneRunnable(pruner);
        Thread t = new Thread(pruneRunnable);
        t.start();
        try {
            pruneRunnable.start();
            InputInitializerEvent event = InputInitializerEvent.create((String)"FakeTarget", (String)"TargetInput", (ByteBuffer)ByteBuffer.allocate(0));
            event.setSourceVertexName("v1");
            pruner.processVertex("v1");
            pruner.addEvent(event);
            pruneRunnable.awaitEnd();
            Assert.assertFalse((boolean)pruneRunnable.inError.get());
        }
        finally {
            t.interrupt();
            t.join();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=5000L)
    public void testSingleSourceMultipleFiltersOrdering1() throws InterruptedException, SerDeException {
        InputInitializerContext mockInitContext = (InputInitializerContext)Mockito.mock(InputInitializerContext.class);
        ((InputInitializerContext)Mockito.doReturn((Object)2).when((Object)mockInitContext)).getVertexNumTasks("v1");
        MapWork mapWork = this.createMockMapWork(new TestSource("v1", 2));
        DynamicPartitionPrunerForEventTesting pruner = new DynamicPartitionPrunerForEventTesting(mockInitContext, mapWork);
        PruneRunnable pruneRunnable = new PruneRunnable(pruner);
        Thread t = new Thread(pruneRunnable);
        t.start();
        try {
            pruneRunnable.start();
            InputInitializerEvent event = InputInitializerEvent.create((String)"FakeTarget", (String)"TargetInput", (ByteBuffer)ByteBuffer.allocate(0));
            event.setSourceVertexName("v1");
            pruner.addEvent(event);
            pruner.addEvent(event);
            pruner.addEvent(event);
            pruner.addEvent(event);
            pruner.processVertex("v1");
            pruneRunnable.awaitEnd();
            Assert.assertFalse((boolean)pruneRunnable.inError.get());
        }
        finally {
            t.interrupt();
            t.join();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=5000L)
    public void testSingleSourceMultipleFiltersOrdering2() throws InterruptedException, SerDeException {
        InputInitializerContext mockInitContext = (InputInitializerContext)Mockito.mock(InputInitializerContext.class);
        ((InputInitializerContext)Mockito.doReturn((Object)2).when((Object)mockInitContext)).getVertexNumTasks("v1");
        MapWork mapWork = this.createMockMapWork(new TestSource("v1", 2));
        DynamicPartitionPrunerForEventTesting pruner = new DynamicPartitionPrunerForEventTesting(mockInitContext, mapWork);
        PruneRunnable pruneRunnable = new PruneRunnable(pruner);
        Thread t = new Thread(pruneRunnable);
        t.start();
        try {
            pruneRunnable.start();
            InputInitializerEvent event = InputInitializerEvent.create((String)"FakeTarget", (String)"TargetInput", (ByteBuffer)ByteBuffer.allocate(0));
            event.setSourceVertexName("v1");
            pruner.processVertex("v1");
            pruner.addEvent(event);
            pruner.addEvent(event);
            pruner.addEvent(event);
            pruner.addEvent(event);
            pruneRunnable.awaitEnd();
            Assert.assertFalse((boolean)pruneRunnable.inError.get());
        }
        finally {
            t.interrupt();
            t.join();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=5000L)
    public void testMultipleSourcesOrdering1() throws InterruptedException, SerDeException {
        InputInitializerContext mockInitContext = (InputInitializerContext)Mockito.mock(InputInitializerContext.class);
        ((InputInitializerContext)Mockito.doReturn((Object)2).when((Object)mockInitContext)).getVertexNumTasks("v1");
        ((InputInitializerContext)Mockito.doReturn((Object)3).when((Object)mockInitContext)).getVertexNumTasks("v2");
        MapWork mapWork = this.createMockMapWork(new TestSource("v1", 2), new TestSource("v2", 1));
        DynamicPartitionPrunerForEventTesting pruner = new DynamicPartitionPrunerForEventTesting(mockInitContext, mapWork);
        PruneRunnable pruneRunnable = new PruneRunnable(pruner);
        Thread t = new Thread(pruneRunnable);
        t.start();
        try {
            pruneRunnable.start();
            InputInitializerEvent eventV1 = InputInitializerEvent.create((String)"FakeTarget", (String)"TargetInput", (ByteBuffer)ByteBuffer.allocate(0));
            eventV1.setSourceVertexName("v1");
            InputInitializerEvent eventV2 = InputInitializerEvent.create((String)"FakeTarget", (String)"TargetInput", (ByteBuffer)ByteBuffer.allocate(0));
            eventV2.setSourceVertexName("v2");
            pruner.addEvent(eventV1);
            pruner.addEvent(eventV1);
            pruner.addEvent(eventV1);
            pruner.addEvent(eventV1);
            pruner.addEvent(eventV2);
            pruner.addEvent(eventV2);
            pruner.addEvent(eventV2);
            pruner.processVertex("v1");
            pruner.processVertex("v2");
            pruneRunnable.awaitEnd();
            Assert.assertFalse((boolean)pruneRunnable.inError.get());
        }
        finally {
            t.interrupt();
            t.join();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=5000L)
    public void testMultipleSourcesOrdering2() throws InterruptedException, SerDeException {
        InputInitializerContext mockInitContext = (InputInitializerContext)Mockito.mock(InputInitializerContext.class);
        ((InputInitializerContext)Mockito.doReturn((Object)2).when((Object)mockInitContext)).getVertexNumTasks("v1");
        ((InputInitializerContext)Mockito.doReturn((Object)3).when((Object)mockInitContext)).getVertexNumTasks("v2");
        MapWork mapWork = this.createMockMapWork(new TestSource("v1", 2), new TestSource("v2", 1));
        DynamicPartitionPrunerForEventTesting pruner = new DynamicPartitionPrunerForEventTesting(mockInitContext, mapWork);
        PruneRunnable pruneRunnable = new PruneRunnable(pruner);
        Thread t = new Thread(pruneRunnable);
        t.start();
        try {
            pruneRunnable.start();
            InputInitializerEvent eventV1 = InputInitializerEvent.create((String)"FakeTarget", (String)"TargetInput", (ByteBuffer)ByteBuffer.allocate(0));
            eventV1.setSourceVertexName("v1");
            InputInitializerEvent eventV2 = InputInitializerEvent.create((String)"FakeTarget", (String)"TargetInput", (ByteBuffer)ByteBuffer.allocate(0));
            eventV2.setSourceVertexName("v2");
            pruner.processVertex("v1");
            pruner.processVertex("v2");
            pruner.addEvent(eventV1);
            pruner.addEvent(eventV1);
            pruner.addEvent(eventV1);
            pruner.addEvent(eventV1);
            pruner.addEvent(eventV2);
            pruner.addEvent(eventV2);
            pruner.addEvent(eventV2);
            pruneRunnable.awaitEnd();
            Assert.assertFalse((boolean)pruneRunnable.inError.get());
        }
        finally {
            t.interrupt();
            t.join();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=5000L)
    public void testMultipleSourcesOrdering3() throws InterruptedException, SerDeException {
        InputInitializerContext mockInitContext = (InputInitializerContext)Mockito.mock(InputInitializerContext.class);
        ((InputInitializerContext)Mockito.doReturn((Object)2).when((Object)mockInitContext)).getVertexNumTasks("v1");
        ((InputInitializerContext)Mockito.doReturn((Object)3).when((Object)mockInitContext)).getVertexNumTasks("v2");
        MapWork mapWork = this.createMockMapWork(new TestSource("v1", 2), new TestSource("v2", 1));
        DynamicPartitionPrunerForEventTesting pruner = new DynamicPartitionPrunerForEventTesting(mockInitContext, mapWork);
        PruneRunnable pruneRunnable = new PruneRunnable(pruner);
        Thread t = new Thread(pruneRunnable);
        t.start();
        try {
            pruneRunnable.start();
            InputInitializerEvent eventV1 = InputInitializerEvent.create((String)"FakeTarget", (String)"TargetInput", (ByteBuffer)ByteBuffer.allocate(0));
            eventV1.setSourceVertexName("v1");
            InputInitializerEvent eventV2 = InputInitializerEvent.create((String)"FakeTarget", (String)"TargetInput", (ByteBuffer)ByteBuffer.allocate(0));
            eventV2.setSourceVertexName("v2");
            pruner.addEvent(eventV1);
            pruner.addEvent(eventV1);
            pruner.processVertex("v1");
            pruner.addEvent(eventV1);
            pruner.addEvent(eventV1);
            pruner.addEvent(eventV2);
            pruner.processVertex("v2");
            pruner.addEvent(eventV2);
            pruner.addEvent(eventV2);
            pruneRunnable.awaitEnd();
            Assert.assertFalse((boolean)pruneRunnable.inError.get());
        }
        finally {
            t.interrupt();
            t.join();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=5000L, expected=IllegalStateException.class)
    public void testExtraEvents() throws InterruptedException, IOException, HiveException, SerDeException {
        InputInitializerContext mockInitContext = (InputInitializerContext)Mockito.mock(InputInitializerContext.class);
        ((InputInitializerContext)Mockito.doReturn((Object)1).when((Object)mockInitContext)).getVertexNumTasks("v1");
        MapWork mapWork = this.createMockMapWork(new TestSource("v1", 1));
        DynamicPartitionPrunerForEventTesting pruner = new DynamicPartitionPrunerForEventTesting(mockInitContext, mapWork);
        PruneRunnable pruneRunnable = new PruneRunnable(pruner);
        Thread t = new Thread(pruneRunnable);
        t.start();
        try {
            pruneRunnable.start();
            InputInitializerEvent event = InputInitializerEvent.create((String)"FakeTarget", (String)"TargetInput", (ByteBuffer)ByteBuffer.allocate(0));
            event.setSourceVertexName("v1");
            pruner.addEvent(event);
            pruner.addEvent(event);
            pruner.processVertex("v1");
            pruneRunnable.awaitEnd();
            Assert.assertFalse((boolean)pruneRunnable.inError.get());
        }
        finally {
            t.interrupt();
            t.join();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=20000L)
    public void testMissingEvent() throws InterruptedException, IOException, HiveException, SerDeException {
        InputInitializerContext mockInitContext = (InputInitializerContext)Mockito.mock(InputInitializerContext.class);
        ((InputInitializerContext)Mockito.doReturn((Object)1).when((Object)mockInitContext)).getVertexNumTasks("v1");
        MapWork mapWork = this.createMockMapWork(new TestSource("v1", 1));
        DynamicPartitionPrunerForEventTesting pruner = new DynamicPartitionPrunerForEventTesting(mockInitContext, mapWork);
        PruneRunnable pruneRunnable = new PruneRunnable(pruner);
        Thread t = new Thread(pruneRunnable);
        t.start();
        try {
            pruneRunnable.start();
            InputInitializerEvent event = InputInitializerEvent.create((String)"FakeTarget", (String)"TargetInput", (ByteBuffer)ByteBuffer.allocate(0));
            event.setSourceVertexName("v1");
            pruner.processVertex("v1");
            Thread.sleep(3000L);
            Assert.assertFalse((boolean)pruneRunnable.ended.get());
            Assert.assertFalse((boolean)pruneRunnable.inError.get());
        }
        finally {
            t.interrupt();
            t.join();
        }
    }

    private MapWork createMockMapWork(TestSource ... testSources) {
        MapWork mapWork = (MapWork)Mockito.mock(MapWork.class);
        HashMap<String, LinkedList<Object>> tableMap = new HashMap<String, LinkedList<Object>>();
        HashMap<String, LinkedList<String>> columnMap = new HashMap<String, LinkedList<String>>();
        HashMap<String, LinkedList<Object>> exprMap = new HashMap<String, LinkedList<Object>>();
        int count = 0;
        for (TestSource testSource : testSources) {
            for (int i = 0; i < testSource.numExpressions; ++i) {
                LinkedList<Object> tableDescList = (LinkedList<Object>)tableMap.get(testSource.vertexName);
                if (tableDescList == null) {
                    tableDescList = new LinkedList<Object>();
                    tableMap.put(testSource.vertexName, tableDescList);
                }
                tableDescList.add(Mockito.mock(TableDesc.class));
                LinkedList<String> columnList = (LinkedList<String>)columnMap.get(testSource.vertexName);
                if (columnList == null) {
                    columnList = new LinkedList<String>();
                    columnMap.put(testSource.vertexName, columnList);
                }
                columnList.add(testSource.vertexName + "c_" + count + "_" + i);
                LinkedList<Object> exprNodeDescList = (LinkedList<Object>)exprMap.get(testSource.vertexName);
                if (exprNodeDescList == null) {
                    exprNodeDescList = new LinkedList<Object>();
                    exprMap.put(testSource.vertexName, exprNodeDescList);
                }
                exprNodeDescList.add(Mockito.mock(ExprNodeDesc.class));
            }
            ++count;
        }
        ((MapWork)Mockito.doReturn(tableMap).when((Object)mapWork)).getEventSourceTableDescMap();
        ((MapWork)Mockito.doReturn(columnMap).when((Object)mapWork)).getEventSourceColumnNameMap();
        ((MapWork)Mockito.doReturn(exprMap).when((Object)mapWork)).getEventSourcePartKeyExprMap();
        return mapWork;
    }

    private static class DynamicPartitionPrunerForEventTesting
    extends DynamicPartitionPruner {
        public DynamicPartitionPrunerForEventTesting(InputInitializerContext context, MapWork work) throws SerDeException {
            super(context, work, new JobConf());
        }

        protected DynamicPartitionPruner.SourceInfo createSourceInfo(TableDesc t, ExprNodeDesc partKeyExpr, String columnName, JobConf jobConf) throws SerDeException {
            return new DynamicPartitionPruner.SourceInfo(t, partKeyExpr, columnName, jobConf, null);
        }

        protected String processPayload(ByteBuffer payload, String sourceName) throws SerDeException, IOException {
            return sourceName;
        }

        protected void prunePartitionSingleSource(String source, DynamicPartitionPruner.SourceInfo si) throws HiveException {
        }
    }

    private static class TestSource {
        String vertexName;
        int numExpressions;

        public TestSource(String vertexName, int numExpressions) {
            this.vertexName = vertexName;
            this.numExpressions = numExpressions;
        }
    }

    private static class PruneRunnable
    implements Runnable {
        final DynamicPartitionPruner pruner;
        final ReentrantLock lock = new ReentrantLock();
        final Condition endCondition = this.lock.newCondition();
        final Condition startCondition = this.lock.newCondition();
        final AtomicBoolean started = new AtomicBoolean(false);
        final AtomicBoolean ended = new AtomicBoolean(false);
        final AtomicBoolean inError = new AtomicBoolean(false);

        private PruneRunnable(DynamicPartitionPruner pruner) {
            this.pruner = pruner;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void start() {
            this.started.set(true);
            this.lock.lock();
            try {
                this.startCondition.signal();
            }
            finally {
                this.lock.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void awaitEnd() throws InterruptedException {
            this.lock.lock();
            try {
                while (!this.ended.get()) {
                    this.endCondition.await();
                }
            }
            finally {
                this.lock.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                this.lock.lock();
                try {
                    while (!this.started.get()) {
                        this.startCondition.await();
                    }
                }
                finally {
                    this.lock.unlock();
                }
                this.pruner.prune();
                this.lock.lock();
                try {
                    this.ended.set(true);
                    this.endCondition.signal();
                }
                finally {
                    this.lock.unlock();
                }
            }
            catch (IOException | InterruptedException | HiveException | SerDeException e) {
                this.inError.set(true);
            }
        }
    }
}

