/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.parse;

import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.Context;
import org.apache.hadoop.hive.ql.parse.ASTNode;
import org.apache.hadoop.hive.ql.parse.ParseDriver;
import org.apache.hadoop.hive.ql.parse.ParseException;
import org.apache.hadoop.hive.ql.parse.SemanticAnalyzer;
import org.apache.hadoop.hive.ql.parse.SemanticException;
import org.apache.hadoop.hive.ql.session.SessionState;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;

public class TestIUD {
    private static HiveConf conf;
    private ParseDriver pd;

    @BeforeClass
    public static void initialize() {
        conf = new HiveConf(SemanticAnalyzer.class);
        SessionState.start((HiveConf)conf);
    }

    @Before
    public void setup() throws SemanticException, IOException {
        this.pd = new ParseDriver();
    }

    ASTNode parse(String query) throws ParseException {
        ASTNode nd = null;
        try {
            nd = this.pd.parse(query, new Context((Configuration)conf));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return (ASTNode)nd.getChild(0);
    }

    @Test
    public void testDeleteNoWhere() throws ParseException {
        ASTNode ast = this.parse("DELETE FROM src");
        Assert.assertEquals((String)"AST doesn't match", (Object)"(TOK_DELETE_FROM (TOK_TABNAME src))", (Object)ast.toStringTree());
    }

    @Test
    public void testDeleteWithWhere() throws ParseException {
        ASTNode ast = this.parse("DELETE FROM src WHERE key IS NOT NULL AND src.value < 0");
        Assert.assertEquals((String)"AST doesn't match", (Object)"(TOK_DELETE_FROM (TOK_TABNAME src) (TOK_WHERE (AND (TOK_FUNCTION TOK_ISNOTNULL (TOK_TABLE_OR_COL key)) (< (. (TOK_TABLE_OR_COL src) value) 0))))", (Object)ast.toStringTree());
    }

    @Test
    public void testUpdateNoWhereSingleSet() throws ParseException {
        ASTNode ast = this.parse("UPDATE src set key = 3");
        Assert.assertEquals((String)"AST doesn't match", (Object)"(TOK_UPDATE_TABLE (TOK_TABNAME src) (TOK_SET_COLUMNS_CLAUSE (= (TOK_TABLE_OR_COL key) 3)))", (Object)ast.toStringTree());
    }

    @Test
    public void testUpdateNoWhereMultiSet() throws ParseException {
        ASTNode ast = this.parse("UPDATE src set key = 3, value = 8");
        Assert.assertEquals((String)"AST doesn't match", (Object)"(TOK_UPDATE_TABLE (TOK_TABNAME src) (TOK_SET_COLUMNS_CLAUSE (= (TOK_TABLE_OR_COL key) 3) (= (TOK_TABLE_OR_COL value) 8)))", (Object)ast.toStringTree());
    }

    @Test
    public void testUpdateWithWhereSingleSet() throws ParseException {
        ASTNode ast = this.parse("UPDATE src SET key = 3 WHERE value IS NULL");
        Assert.assertEquals((String)"AST doesn't match", (Object)"(TOK_UPDATE_TABLE (TOK_TABNAME src) (TOK_SET_COLUMNS_CLAUSE (= (TOK_TABLE_OR_COL key) 3)) (TOK_WHERE (TOK_FUNCTION TOK_ISNULL (TOK_TABLE_OR_COL value))))", (Object)ast.toStringTree());
    }

    @Test
    public void testUpdateWithWhereSingleSetExpr() throws ParseException {
        ASTNode ast = this.parse("UPDATE src SET key = -3+(5*9)%8, val = cast(6.1 + c as INT), d = d - 1 WHERE value IS NULL");
        Assert.assertEquals((String)"AST doesn't match", (Object)"(TOK_UPDATE_TABLE (TOK_TABNAME src) (TOK_SET_COLUMNS_CLAUSE (= (TOK_TABLE_OR_COL key) (+ (- 3) (% (* 5 9) 8))) (= (TOK_TABLE_OR_COL val) (TOK_FUNCTION TOK_INT (+ 6.1 (TOK_TABLE_OR_COL c)))) (= (TOK_TABLE_OR_COL d) (- (TOK_TABLE_OR_COL d) 1))) (TOK_WHERE (TOK_FUNCTION TOK_ISNULL (TOK_TABLE_OR_COL value))))", (Object)ast.toStringTree());
    }

    @Test
    public void testUpdateWithWhereMultiSet() throws ParseException {
        ASTNode ast = this.parse("UPDATE src SET key = 3, value = 8 WHERE VALUE = 1230997");
        Assert.assertEquals((String)"AST doesn't match", (Object)"(TOK_UPDATE_TABLE (TOK_TABNAME src) (TOK_SET_COLUMNS_CLAUSE (= (TOK_TABLE_OR_COL key) 3) (= (TOK_TABLE_OR_COL value) 8)) (TOK_WHERE (= (TOK_TABLE_OR_COL VALUE) 1230997)))", (Object)ast.toStringTree());
    }

    @Test
    public void testStandardInsertIntoTable() throws ParseException {
        ASTNode ast = this.parse("INSERT into TABLE page_view SELECT pvs.viewTime, pvs.userid from page_view_stg pvs where pvs.userid is null");
        Assert.assertEquals((String)"AST doesn't match", (Object)"(TOK_QUERY (TOK_FROM (TOK_TABREF (TOK_TABNAME page_view_stg) pvs)) (TOK_INSERT (TOK_INSERT_INTO (TOK_TAB (TOK_TABNAME page_view))) (TOK_SELECT (TOK_SELEXPR (. (TOK_TABLE_OR_COL pvs) viewTime)) (TOK_SELEXPR (. (TOK_TABLE_OR_COL pvs) userid))) (TOK_WHERE (TOK_FUNCTION TOK_ISNULL (. (TOK_TABLE_OR_COL pvs) userid)))))", (Object)ast.toStringTree());
    }

    @Test
    public void testSelectStarFromAnonymousVirtTable1Row() throws ParseException {
        try {
            this.parse("select * from `values` (3,4)");
            Assert.assertFalse((String)"Expected ParseException", (boolean)true);
        }
        catch (ParseException ex) {
            Assert.assertEquals((String)"Failure didn't match.", (Object)"line 1:23 missing EOF at '(' near 'values'", (Object)ex.getMessage());
        }
    }

    @Test
    public void testSelectStarFromVirtTable1Row() throws ParseException {
        ASTNode ast = this.parse("select * from (values (3,4)) as VC(a,b)");
        Assert.assertEquals((String)"AST doesn't match", (Object)"(TOK_QUERY (TOK_FROM (TOK_VIRTUAL_TABLE (TOK_VIRTUAL_TABREF (TOK_TABNAME VC) (TOK_COL_NAME a b)) (TOK_VALUES_TABLE (TOK_VALUE_ROW 3 4)))) (TOK_INSERT (TOK_DESTINATION (TOK_DIR TOK_TMP_FILE)) (TOK_SELECT (TOK_SELEXPR TOK_ALLCOLREF))))", (Object)ast.toStringTree());
    }

    @Test
    public void testSelectStarFromVirtTable2Row() throws ParseException {
        ASTNode ast = this.parse("select * from (values (1,2),(3,4)) as VC(a,b)");
        Assert.assertEquals((String)"AST doesn't match", (Object)"(TOK_QUERY (TOK_FROM (TOK_VIRTUAL_TABLE (TOK_VIRTUAL_TABREF (TOK_TABNAME VC) (TOK_COL_NAME a b)) (TOK_VALUES_TABLE (TOK_VALUE_ROW 1 2) (TOK_VALUE_ROW 3 4)))) (TOK_INSERT (TOK_DESTINATION (TOK_DIR TOK_TMP_FILE)) (TOK_SELECT (TOK_SELEXPR TOK_ALLCOLREF))))", (Object)ast.toStringTree());
    }

    @Test
    public void testSelectStarFromVirtTable2RowNamedProjections() throws ParseException {
        ASTNode ast = this.parse("select a as c, b as d from (values (1,2),(3,4)) as VC(a,b)");
        Assert.assertEquals((String)"AST doesn't match", (Object)"(TOK_QUERY (TOK_FROM (TOK_VIRTUAL_TABLE (TOK_VIRTUAL_TABREF (TOK_TABNAME VC) (TOK_COL_NAME a b)) (TOK_VALUES_TABLE (TOK_VALUE_ROW 1 2) (TOK_VALUE_ROW 3 4)))) (TOK_INSERT (TOK_DESTINATION (TOK_DIR TOK_TMP_FILE)) (TOK_SELECT (TOK_SELEXPR (TOK_TABLE_OR_COL a) c) (TOK_SELEXPR (TOK_TABLE_OR_COL b) d))))", (Object)ast.toStringTree());
    }

    @Test
    public void testInsertIntoTableAsSelectFromNamedVirtTable() throws ParseException {
        ASTNode ast = this.parse("insert into page_view select a,b as c from (values (1,2),(3,4)) as VC(a,b) where b = 9");
        Assert.assertEquals((String)"AST doesn't match", (Object)"(TOK_QUERY (TOK_FROM (TOK_VIRTUAL_TABLE (TOK_VIRTUAL_TABREF (TOK_TABNAME VC) (TOK_COL_NAME a b)) (TOK_VALUES_TABLE (TOK_VALUE_ROW 1 2) (TOK_VALUE_ROW 3 4)))) (TOK_INSERT (TOK_INSERT_INTO (TOK_TAB (TOK_TABNAME page_view))) (TOK_SELECT (TOK_SELEXPR (TOK_TABLE_OR_COL a)) (TOK_SELEXPR (TOK_TABLE_OR_COL b) c)) (TOK_WHERE (= (TOK_TABLE_OR_COL b) 9))))", (Object)ast.toStringTree());
    }

    @Test
    public void testInsertIntoTableAsSelectFromNamedVirtTableNamedCol() throws ParseException {
        ASTNode ast = this.parse("insert into page_view(c1,c2) select a,b as c from (values (1,2),(3,4)) as VC(a,b) where b = 9");
        Assert.assertEquals((String)"AST doesn't match", (Object)"(TOK_QUERY (TOK_FROM (TOK_VIRTUAL_TABLE (TOK_VIRTUAL_TABREF (TOK_TABNAME VC) (TOK_COL_NAME a b)) (TOK_VALUES_TABLE (TOK_VALUE_ROW 1 2) (TOK_VALUE_ROW 3 4)))) (TOK_INSERT (TOK_INSERT_INTO (TOK_TAB (TOK_TABNAME page_view)) (TOK_TABCOLNAME c1 c2)) (TOK_SELECT (TOK_SELEXPR (TOK_TABLE_OR_COL a)) (TOK_SELEXPR (TOK_TABLE_OR_COL b) c)) (TOK_WHERE (= (TOK_TABLE_OR_COL b) 9))))", (Object)ast.toStringTree());
    }

    @Test
    public void testInsertIntoTableFromAnonymousTable1Row() throws ParseException {
        ASTNode ast = this.parse("insert into page_view values(1,2)");
        Assert.assertEquals((String)"AST doesn't match", (Object)"(TOK_QUERY (TOK_FROM (TOK_VIRTUAL_TABLE (TOK_VIRTUAL_TABREF TOK_ANONYMOUS) (TOK_VALUES_TABLE (TOK_VALUE_ROW 1 2)))) (TOK_INSERT (TOK_INSERT_INTO (TOK_TAB (TOK_TABNAME page_view))) (TOK_SELECT (TOK_SELEXPR TOK_ALLCOLREF))))", (Object)ast.toStringTree());
    }

    @Test
    public void testInsertIntoTableFromAnonymousTable1RowNamedCol() throws ParseException {
        ASTNode ast = this.parse("insert into page_view(a,b) values(1,2)");
        Assert.assertEquals((String)"AST doesn't match", (Object)"(TOK_QUERY (TOK_FROM (TOK_VIRTUAL_TABLE (TOK_VIRTUAL_TABREF TOK_ANONYMOUS) (TOK_VALUES_TABLE (TOK_VALUE_ROW 1 2)))) (TOK_INSERT (TOK_INSERT_INTO (TOK_TAB (TOK_TABNAME page_view)) (TOK_TABCOLNAME a b)) (TOK_SELECT (TOK_SELEXPR TOK_ALLCOLREF))))", (Object)ast.toStringTree());
    }

    @Test
    public void testInsertIntoTableFromAnonymousTable() throws ParseException {
        ASTNode ast = this.parse("insert into table page_view values(-1,2),(3,+4)");
        Assert.assertEquals((String)"AST doesn't match", (Object)"(TOK_QUERY (TOK_FROM (TOK_VIRTUAL_TABLE (TOK_VIRTUAL_TABREF TOK_ANONYMOUS) (TOK_VALUES_TABLE (TOK_VALUE_ROW (- 1) 2) (TOK_VALUE_ROW 3 (+ 4))))) (TOK_INSERT (TOK_INSERT_INTO (TOK_TAB (TOK_TABNAME page_view))) (TOK_SELECT (TOK_SELEXPR TOK_ALLCOLREF))))", (Object)ast.toStringTree());
        ast = this.parse("insert into page_view values(-1,2),(3,+4)");
        Assert.assertEquals((String)"AST doesn't match", (Object)"(TOK_QUERY (TOK_FROM (TOK_VIRTUAL_TABLE (TOK_VIRTUAL_TABREF TOK_ANONYMOUS) (TOK_VALUES_TABLE (TOK_VALUE_ROW (- 1) 2) (TOK_VALUE_ROW 3 (+ 4))))) (TOK_INSERT (TOK_INSERT_INTO (TOK_TAB (TOK_TABNAME page_view))) (TOK_SELECT (TOK_SELEXPR TOK_ALLCOLREF))))", (Object)ast.toStringTree());
    }

    @Test
    public void testMultiInsert() throws ParseException {
        ASTNode ast = this.parse("from S insert into T1 select a, b insert into T2 select c, d");
        Assert.assertEquals((String)"AST doesn't match", (Object)"(TOK_QUERY (TOK_FROM (TOK_TABREF (TOK_TABNAME S))) (TOK_INSERT (TOK_INSERT_INTO (TOK_TAB (TOK_TABNAME T1))) (TOK_SELECT (TOK_SELEXPR (TOK_TABLE_OR_COL a)) (TOK_SELEXPR (TOK_TABLE_OR_COL b)))) (TOK_INSERT (TOK_INSERT_INTO (TOK_TAB (TOK_TABNAME T2))) (TOK_SELECT (TOK_SELEXPR (TOK_TABLE_OR_COL c)) (TOK_SELEXPR (TOK_TABLE_OR_COL d)))))", (Object)ast.toStringTree());
    }
}

