/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.io.orc;

import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.PrintStream;
import java.sql.Date;
import java.sql.Timestamp;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.common.type.HiveChar;
import org.apache.hadoop.hive.common.type.HiveDecimal;
import org.apache.hadoop.hive.common.type.HiveVarchar;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.io.orc.CompressionKind;
import org.apache.hadoop.hive.ql.io.orc.FileDump;
import org.apache.hadoop.hive.ql.io.orc.OrcFile;
import org.apache.hadoop.hive.ql.io.orc.TestOrcFile;
import org.apache.hadoop.hive.ql.io.orc.Writer;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspectorFactory;
import org.apache.hive.common.util.HiveTestUtils;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TestFileDump {
    Path workDir = new Path(System.getProperty("test.tmp.dir"));
    Configuration conf;
    FileSystem fs;
    Path testFilePath;

    @Before
    public void openFileSystem() throws Exception {
        this.conf = new Configuration();
        this.fs = FileSystem.getLocal((Configuration)this.conf);
        this.fs.setWorkingDirectory(this.workDir);
        this.testFilePath = new Path("TestFileDump.testDump.orc");
        this.fs.delete(this.testFilePath, false);
    }

    static void checkOutput(String expected, String actual) throws Exception {
        BufferedReader eStream = new BufferedReader(new FileReader(HiveTestUtils.getFileFromClasspath((String)expected)));
        BufferedReader aStream = new BufferedReader(new FileReader(actual));
        String expectedLine = eStream.readLine().trim();
        while (expectedLine != null) {
            String actualLine = aStream.readLine().trim();
            System.out.println("actual:   " + actualLine);
            System.out.println("expected: " + expectedLine);
            Assert.assertEquals((Object)expectedLine, (Object)actualLine);
            expectedLine = eStream.readLine();
            expectedLine = expectedLine == null ? null : expectedLine.trim();
        }
        Assert.assertNull((Object)eStream.readLine());
        Assert.assertNull((Object)aStream.readLine());
        eStream.close();
        aStream.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testDump() throws Exception {
        Class<TestOrcFile> clazz = TestOrcFile.class;
        synchronized (TestOrcFile.class) {
            ObjectInspector inspector = ObjectInspectorFactory.getReflectionObjectInspector(MyRecord.class, (ObjectInspectorFactory.ObjectInspectorOptions)ObjectInspectorFactory.ObjectInspectorOptions.JAVA);
            // ** MonitorExit[var2_1] (shouldn't be in output)
            this.conf.set(HiveConf.ConfVars.HIVE_ORC_ENCODING_STRATEGY.varname, "COMPRESSION");
            Writer writer = OrcFile.createWriter((FileSystem)this.fs, (Path)this.testFilePath, (Configuration)this.conf, (ObjectInspector)inspector, (long)100000L, (CompressionKind)CompressionKind.ZLIB, (int)10000, (int)1000);
            Random r1 = new Random(1L);
            String[] words = new String[]{"It", "was", "the", "best", "of", "times,", "it", "was", "the", "worst", "of", "times,", "it", "was", "the", "age", "of", "wisdom,", "it", "was", "the", "age", "of", "foolishness,", "it", "was", "the", "epoch", "of", "belief,", "it", "was", "the", "epoch", "of", "incredulity,", "it", "was", "the", "season", "of", "Light,", "it", "was", "the", "season", "of", "Darkness,", "it", "was", "the", "spring", "of", "hope,", "it", "was", "the", "winter", "of", "despair,", "we", "had", "everything", "before", "us,", "we", "had", "nothing", "before", "us,", "we", "were", "all", "going", "direct", "to", "Heaven,", "we", "were", "all", "going", "direct", "the", "other", "way"};
            for (int i = 0; i < 21000; ++i) {
                writer.addRow((Object)new MyRecord(r1.nextInt(), r1.nextLong(), words[r1.nextInt(words.length)]));
            }
            writer.close();
            PrintStream origOut = System.out;
            String outputFilename = "orc-file-dump.out";
            FileOutputStream myOut = new FileOutputStream(this.workDir + File.separator + outputFilename);
            System.setOut(new PrintStream(myOut));
            FileDump.main((String[])new String[]{this.testFilePath.toString(), "--rowindex=1,2,3"});
            System.out.flush();
            System.setOut(origOut);
            TestFileDump.checkOutput(outputFilename, this.workDir + File.separator + outputFilename);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testDataDump() throws Exception {
        Class<TestOrcFile> clazz = TestOrcFile.class;
        synchronized (TestOrcFile.class) {
            ObjectInspector inspector = ObjectInspectorFactory.getReflectionObjectInspector(AllTypesRecord.class, (ObjectInspectorFactory.ObjectInspectorOptions)ObjectInspectorFactory.ObjectInspectorOptions.JAVA);
            // ** MonitorExit[var2_1] (shouldn't be in output)
            Writer writer = OrcFile.createWriter((FileSystem)this.fs, (Path)this.testFilePath, (Configuration)this.conf, (ObjectInspector)inspector, (long)100000L, (CompressionKind)CompressionKind.NONE, (int)10000, (int)1000);
            HashMap<String, String> m = new HashMap<String, String>(2);
            m.put("k1", "v1");
            writer.addRow((Object)new AllTypesRecord(true, 10, 100, 1000, 10000L, 4.0f, 20.0, HiveDecimal.create((String)"4.2222"), new Timestamp(1416967764000L), new Date(1416967764000L), "string", new HiveChar("hello", 5), new HiveVarchar("hello", 10), m, Arrays.asList(100, 200), new AllTypesRecord.Struct(10, "foo")));
            m.clear();
            m.put("k3", "v3");
            writer.addRow((Object)new AllTypesRecord(false, 20, 200, 2000, 20000L, 8.0f, 40.0, HiveDecimal.create((String)"2.2222"), new Timestamp(1416967364000L), new Date(1411967764000L), "abcd", new HiveChar("world", 5), new HiveVarchar("world", 10), m, Arrays.asList(200, 300), new AllTypesRecord.Struct(20, "bar")));
            writer.close();
            PrintStream origOut = System.out;
            ByteArrayOutputStream myOut = new ByteArrayOutputStream();
            System.setOut(new PrintStream(myOut));
            FileDump.main((String[])new String[]{this.testFilePath.toString(), "-d"});
            System.out.flush();
            System.setOut(origOut);
            String[] lines = myOut.toString().split("\n");
            Assert.assertEquals((Object)"{\"b\":true,\"bt\":10,\"s\":100,\"i\":1000,\"l\":10000,\"f\":4,\"d\":20,\"de\":\"4.2222\",\"t\":\"2014-11-25 18:09:24\",\"dt\":\"2014-11-25\",\"str\":\"string\",\"c\":\"hello                                                                                                                                                                                                                                                          \",\"vc\":\"hello\",\"m\":[{\"_key\":\"k1\",\"_value\":\"v1\"}],\"a\":[100,200],\"st\":{\"i\":10,\"s\":\"foo\"}}", (Object)lines[0]);
            Assert.assertEquals((Object)"{\"b\":false,\"bt\":20,\"s\":200,\"i\":2000,\"l\":20000,\"f\":8,\"d\":40,\"de\":\"2.2222\",\"t\":\"2014-11-25 18:02:44\",\"dt\":\"2014-09-28\",\"str\":\"abcd\",\"c\":\"world                                                                                                                                                                                                                                                          \",\"vc\":\"world\",\"m\":[{\"_key\":\"k3\",\"_value\":\"v3\"}],\"a\":[200,300],\"st\":{\"i\":20,\"s\":\"bar\"}}", (Object)lines[1]);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testDictionaryThreshold() throws Exception {
        Class<TestOrcFile> clazz = TestOrcFile.class;
        synchronized (TestOrcFile.class) {
            ObjectInspector inspector = ObjectInspectorFactory.getReflectionObjectInspector(MyRecord.class, (ObjectInspectorFactory.ObjectInspectorOptions)ObjectInspectorFactory.ObjectInspectorOptions.JAVA);
            // ** MonitorExit[var2_1] (shouldn't be in output)
            Configuration conf = new Configuration();
            conf.set(HiveConf.ConfVars.HIVE_ORC_ENCODING_STRATEGY.varname, "COMPRESSION");
            conf.setFloat(HiveConf.ConfVars.HIVE_ORC_DICTIONARY_KEY_SIZE_THRESHOLD.varname, 0.49f);
            Writer writer = OrcFile.createWriter((FileSystem)this.fs, (Path)this.testFilePath, (Configuration)conf, (ObjectInspector)inspector, (long)100000L, (CompressionKind)CompressionKind.ZLIB, (int)10000, (int)1000);
            Random r1 = new Random(1L);
            String[] words = new String[]{"It", "was", "the", "best", "of", "times,", "it", "was", "the", "worst", "of", "times,", "it", "was", "the", "age", "of", "wisdom,", "it", "was", "the", "age", "of", "foolishness,", "it", "was", "the", "epoch", "of", "belief,", "it", "was", "the", "epoch", "of", "incredulity,", "it", "was", "the", "season", "of", "Light,", "it", "was", "the", "season", "of", "Darkness,", "it", "was", "the", "spring", "of", "hope,", "it", "was", "the", "winter", "of", "despair,", "we", "had", "everything", "before", "us,", "we", "had", "nothing", "before", "us,", "we", "were", "all", "going", "direct", "to", "Heaven,", "we", "were", "all", "going", "direct", "the", "other", "way"};
            int nextInt = 0;
            for (int i = 0; i < 21000; ++i) {
                if (i % 2 == 0) {
                    int n = nextInt = r1.nextInt(words.length);
                    words[n] = words[n] + "-" + i;
                }
                writer.addRow((Object)new MyRecord(r1.nextInt(), r1.nextLong(), words[nextInt]));
            }
            writer.close();
            PrintStream origOut = System.out;
            String outputFilename = "orc-file-dump-dictionary-threshold.out";
            FileOutputStream myOut = new FileOutputStream(this.workDir + File.separator + outputFilename);
            System.setOut(new PrintStream(myOut));
            FileDump.main((String[])new String[]{this.testFilePath.toString(), "--rowindex=1,2,3"});
            System.out.flush();
            System.setOut(origOut);
            TestFileDump.checkOutput(outputFilename, this.workDir + File.separator + outputFilename);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testBloomFilter() throws Exception {
        Class<TestOrcFile> clazz = TestOrcFile.class;
        synchronized (TestOrcFile.class) {
            ObjectInspector inspector = ObjectInspectorFactory.getReflectionObjectInspector(MyRecord.class, (ObjectInspectorFactory.ObjectInspectorOptions)ObjectInspectorFactory.ObjectInspectorOptions.JAVA);
            // ** MonitorExit[var2_1] (shouldn't be in output)
            this.conf.set(HiveConf.ConfVars.HIVE_ORC_ENCODING_STRATEGY.varname, "COMPRESSION");
            OrcFile.WriterOptions options = OrcFile.writerOptions((Configuration)this.conf).fileSystem(this.fs).inspector(inspector).stripeSize(100000L).compress(CompressionKind.ZLIB).bufferSize(10000).rowIndexStride(1000).bloomFilterColumns("s");
            Writer writer = OrcFile.createWriter((Path)this.testFilePath, (OrcFile.WriterOptions)options);
            Random r1 = new Random(1L);
            String[] words = new String[]{"It", "was", "the", "best", "of", "times,", "it", "was", "the", "worst", "of", "times,", "it", "was", "the", "age", "of", "wisdom,", "it", "was", "the", "age", "of", "foolishness,", "it", "was", "the", "epoch", "of", "belief,", "it", "was", "the", "epoch", "of", "incredulity,", "it", "was", "the", "season", "of", "Light,", "it", "was", "the", "season", "of", "Darkness,", "it", "was", "the", "spring", "of", "hope,", "it", "was", "the", "winter", "of", "despair,", "we", "had", "everything", "before", "us,", "we", "had", "nothing", "before", "us,", "we", "were", "all", "going", "direct", "to", "Heaven,", "we", "were", "all", "going", "direct", "the", "other", "way"};
            for (int i = 0; i < 21000; ++i) {
                writer.addRow((Object)new MyRecord(r1.nextInt(), r1.nextLong(), words[r1.nextInt(words.length)]));
            }
            writer.close();
            PrintStream origOut = System.out;
            String outputFilename = "orc-file-dump-bloomfilter.out";
            FileOutputStream myOut = new FileOutputStream(this.workDir + File.separator + outputFilename);
            System.setOut(new PrintStream(myOut));
            FileDump.main((String[])new String[]{this.testFilePath.toString(), "--rowindex=3"});
            System.out.flush();
            System.setOut(origOut);
            TestFileDump.checkOutput(outputFilename, this.workDir + File.separator + outputFilename);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testBloomFilter2() throws Exception {
        Class<TestOrcFile> clazz = TestOrcFile.class;
        synchronized (TestOrcFile.class) {
            ObjectInspector inspector = ObjectInspectorFactory.getReflectionObjectInspector(MyRecord.class, (ObjectInspectorFactory.ObjectInspectorOptions)ObjectInspectorFactory.ObjectInspectorOptions.JAVA);
            // ** MonitorExit[var2_1] (shouldn't be in output)
            this.conf.set(HiveConf.ConfVars.HIVE_ORC_ENCODING_STRATEGY.varname, "COMPRESSION");
            OrcFile.WriterOptions options = OrcFile.writerOptions((Configuration)this.conf).fileSystem(this.fs).inspector(inspector).stripeSize(100000L).compress(CompressionKind.ZLIB).bufferSize(10000).rowIndexStride(1000).bloomFilterColumns("l").bloomFilterFpp(0.01);
            Writer writer = OrcFile.createWriter((Path)this.testFilePath, (OrcFile.WriterOptions)options);
            Random r1 = new Random(1L);
            String[] words = new String[]{"It", "was", "the", "best", "of", "times,", "it", "was", "the", "worst", "of", "times,", "it", "was", "the", "age", "of", "wisdom,", "it", "was", "the", "age", "of", "foolishness,", "it", "was", "the", "epoch", "of", "belief,", "it", "was", "the", "epoch", "of", "incredulity,", "it", "was", "the", "season", "of", "Light,", "it", "was", "the", "season", "of", "Darkness,", "it", "was", "the", "spring", "of", "hope,", "it", "was", "the", "winter", "of", "despair,", "we", "had", "everything", "before", "us,", "we", "had", "nothing", "before", "us,", "we", "were", "all", "going", "direct", "to", "Heaven,", "we", "were", "all", "going", "direct", "the", "other", "way"};
            for (int i = 0; i < 21000; ++i) {
                writer.addRow((Object)new MyRecord(r1.nextInt(), r1.nextLong(), words[r1.nextInt(words.length)]));
            }
            writer.close();
            PrintStream origOut = System.out;
            String outputFilename = "orc-file-dump-bloomfilter2.out";
            FileOutputStream myOut = new FileOutputStream(this.workDir + File.separator + outputFilename);
            System.setOut(new PrintStream(myOut));
            FileDump.main((String[])new String[]{this.testFilePath.toString(), "--rowindex=2"});
            System.out.flush();
            System.setOut(origOut);
            TestFileDump.checkOutput(outputFilename, this.workDir + File.separator + outputFilename);
            return;
        }
    }

    static class AllTypesRecord {
        boolean b;
        byte bt;
        short s;
        int i;
        long l;
        float f;
        double d;
        HiveDecimal de;
        Timestamp t;
        Date dt;
        String str;
        HiveChar c;
        HiveVarchar vc;
        Map<String, String> m;
        List<Integer> a;
        Struct st;

        AllTypesRecord(boolean b, byte bt, short s, int i, long l, float f, double d, HiveDecimal de, Timestamp t, Date dt, String str, HiveChar c, HiveVarchar vc, Map<String, String> m, List<Integer> a, Struct st) {
            this.b = b;
            this.bt = bt;
            this.s = s;
            this.i = i;
            this.l = l;
            this.f = f;
            this.d = d;
            this.de = de;
            this.t = t;
            this.dt = dt;
            this.str = str;
            this.c = c;
            this.vc = vc;
            this.m = m;
            this.a = a;
            this.st = st;
        }

        static class Struct {
            int i;
            String s;

            Struct(int i, String s) {
                this.i = i;
                this.s = s;
            }
        }
    }

    static class MyRecord {
        int i;
        long l;
        String s;

        MyRecord(int i, long l, String s) {
            this.i = i;
            this.l = l;
            this.s = s;
        }
    }
}

