/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.EOFException;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.common.ValidReadTxnList;
import org.apache.hadoop.hive.common.ValidTxnList;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.exec.FileSinkOperator;
import org.apache.hadoop.hive.ql.exec.OperatorFactory;
import org.apache.hadoop.hive.ql.exec.Task;
import org.apache.hadoop.hive.ql.io.AcidInputFormat;
import org.apache.hadoop.hive.ql.io.AcidOutputFormat;
import org.apache.hadoop.hive.ql.io.AcidUtils;
import org.apache.hadoop.hive.ql.io.RecordIdentifier;
import org.apache.hadoop.hive.ql.io.RecordUpdater;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.plan.DynamicPartitionCtx;
import org.apache.hadoop.hive.ql.plan.ExprNodeColumnDesc;
import org.apache.hadoop.hive.ql.plan.FileSinkDesc;
import org.apache.hadoop.hive.ql.plan.OperatorDesc;
import org.apache.hadoop.hive.ql.plan.TableDesc;
import org.apache.hadoop.hive.ql.stats.StatsAggregator;
import org.apache.hadoop.hive.ql.stats.StatsPublisher;
import org.apache.hadoop.hive.serde2.SerDe;
import org.apache.hadoop.hive.serde2.SerDeException;
import org.apache.hadoop.hive.serde2.SerDeStats;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspectorFactory;
import org.apache.hadoop.hive.serde2.objectinspector.StructObjectInspector;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfoFactory;
import org.apache.hadoop.io.BinaryComparable;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.io.WritableComparable;
import org.apache.hadoop.mapred.FileInputFormat;
import org.apache.hadoop.mapred.FileOutputFormat;
import org.apache.hadoop.mapred.InputSplit;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.RecordReader;
import org.apache.hadoop.mapred.RecordWriter;
import org.apache.hadoop.mapred.Reporter;
import org.apache.hadoop.util.Progressable;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.mockito.Mockito;

public class TestFileSinkOperator {
    private static String PARTCOL_NAME = "partval";
    private static final Log LOG = LogFactory.getLog((String)TestFileSinkOperator.class.getName());
    private static File tmpdir;
    private static TableDesc nonAcidTableDescriptor;
    private static TableDesc acidTableDescriptor;
    private static ObjectInspector inspector;
    private static List<TFSORow> rows;
    private static ValidTxnList txnList;
    private Path basePath;
    private JobConf jc;

    @BeforeClass
    public static void classSetup() {
        Properties properties = new Properties();
        properties.setProperty("serialization.lib", TFSOSerDe.class.getName());
        nonAcidTableDescriptor = new TableDesc(TFSOInputFormat.class, TFSOOutputFormat.class, properties);
        properties = new Properties(properties);
        properties.setProperty("bucket_count", "1");
        acidTableDescriptor = new TableDesc(TFSOInputFormat.class, TFSOOutputFormat.class, properties);
        tmpdir = new File(System.getProperty("java.io.tmpdir") + System.getProperty("file.separator") + "testFileSinkOperator");
        tmpdir.mkdir();
        tmpdir.deleteOnExit();
        txnList = new ValidReadTxnList(new long[0], 2L);
    }

    @Test
    public void testNonAcidWrite() throws Exception {
        this.setBasePath("write");
        this.setupData(DataFormat.SIMPLE);
        FileSinkOperator op = this.getFileSink(AcidUtils.Operation.NOT_ACID, false, 0L);
        this.processRows(op);
        this.confirmOutput();
    }

    @Test
    public void testInsert() throws Exception {
        this.setBasePath("insert");
        this.setupData(DataFormat.SIMPLE);
        FileSinkOperator op = this.getFileSink(AcidUtils.Operation.INSERT, false, 1L);
        this.processRows(op);
        Assert.assertEquals((Object)"10", (Object)TFSOStatsPublisher.stats.get("numRows"));
        this.confirmOutput();
    }

    @Test
    public void testUpdate() throws Exception {
        this.setBasePath("update");
        this.setupData(DataFormat.WITH_RECORD_ID);
        FileSinkOperator op = this.getFileSink(AcidUtils.Operation.UPDATE, false, 2L);
        this.processRows(op);
        Assert.assertEquals((Object)"0", (Object)TFSOStatsPublisher.stats.get("numRows"));
        this.confirmOutput();
    }

    @Test
    public void testDelete() throws Exception {
        this.setBasePath("delete");
        this.setupData(DataFormat.WITH_RECORD_ID);
        FileSinkOperator op = this.getFileSink(AcidUtils.Operation.DELETE, false, 2L);
        this.processRows(op);
        Assert.assertEquals((Object)"-10", (Object)TFSOStatsPublisher.stats.get("numRows"));
        this.confirmOutput();
    }

    @Test
    public void testNonAcidDynamicPartitioning() throws Exception {
        this.setBasePath("writeDP");
        this.setupData(DataFormat.WITH_PARTITION_VALUE);
        FileSinkOperator op = this.getFileSink(AcidUtils.Operation.NOT_ACID, true, 0L);
        this.processRows(op);
        this.confirmOutput();
    }

    @Test
    public void testInsertDynamicPartitioning() throws Exception {
        this.setBasePath("insertDP");
        this.setupData(DataFormat.WITH_PARTITION_VALUE);
        FileSinkOperator op = this.getFileSink(AcidUtils.Operation.INSERT, true, 1L);
        this.processRows(op);
        Assert.assertEquals((Object)"5", (Object)TFSOStatsPublisher.stats.get("numRows"));
        this.confirmOutput();
    }

    @Test
    public void testUpdateDynamicPartitioning() throws Exception {
        this.setBasePath("updateDP");
        this.setupData(DataFormat.WITH_RECORD_ID_AND_PARTITION_VALUE);
        FileSinkOperator op = this.getFileSink(AcidUtils.Operation.UPDATE, true, 2L);
        this.processRows(op);
        Assert.assertEquals((Object)"0", (Object)TFSOStatsPublisher.stats.get("numRows"));
        this.confirmOutput();
    }

    @Test
    public void testDeleteDynamicPartitioning() throws Exception {
        this.setBasePath("deleteDP");
        this.setupData(DataFormat.WITH_RECORD_ID_AND_PARTITION_VALUE);
        FileSinkOperator op = this.getFileSink(AcidUtils.Operation.DELETE, true, 2L);
        this.processRows(op);
        Assert.assertEquals((Object)"-5", (Object)TFSOStatsPublisher.stats.get("numRows"));
        this.confirmOutput();
    }

    @Before
    public void setup() throws Exception {
        this.jc = new JobConf();
        this.jc.set("hive.stats.tmp.loc", File.createTempFile("TestFileSinkOperator", "stats").getPath());
        this.jc.set(HiveConf.ConfVars.HIVE_STATS_DEFAULT_PUBLISHER.varname, TFSOStatsPublisher.class.getName());
        this.jc.set(HiveConf.ConfVars.HIVE_STATS_DEFAULT_AGGREGATOR.varname, TFSOStatsAggregator.class.getName());
        this.jc.set(HiveConf.ConfVars.HIVESTATSDBCLASS.varname, "custom");
    }

    private void setBasePath(String testName) {
        this.basePath = new Path(new File(tmpdir, testName).getPath());
    }

    private void setupData(DataFormat format) {
        inspector = ObjectInspectorFactory.getReflectionObjectInspector(TFSORow.class, (ObjectInspectorFactory.ObjectInspectorOptions)ObjectInspectorFactory.ObjectInspectorOptions.JAVA);
        rows = new ArrayList<TFSORow>();
        switch (format) {
            case SIMPLE: {
                for (int i = 0; i < 10; ++i) {
                    rows.add(new TFSORow(new Text("mary had a little lamb")));
                }
                break;
            }
            case WITH_RECORD_ID: {
                for (int i = 0; i < 10; ++i) {
                    rows.add(new TFSORow(new Text("its fleect was white as snow"), new RecordIdentifier(1L, 1, (long)i)));
                }
                break;
            }
            case WITH_PARTITION_VALUE: {
                for (int i = 0; i < 10; ++i) {
                    rows.add(new TFSORow(new Text("its fleect was white as snow"), i < 5 ? new Text("Monday") : new Text("Tuesday")));
                }
                break;
            }
            case WITH_RECORD_ID_AND_PARTITION_VALUE: {
                for (int i = 0; i < 10; ++i) {
                    rows.add(new TFSORow(new Text("its fleect was white as snow"), i < 5 ? new Text("Monday") : new Text("Tuesday"), new RecordIdentifier(1L, 1, (long)i)));
                }
                break;
            }
            default: {
                throw new RuntimeException("Unknown option!");
            }
        }
    }

    private FileSinkOperator getFileSink(AcidUtils.Operation writeType, boolean dynamic, long txnId) throws IOException, HiveException {
        TableDesc tableDesc = null;
        switch (writeType) {
            case DELETE: 
            case UPDATE: 
            case INSERT: {
                tableDesc = acidTableDescriptor;
                break;
            }
            case NOT_ACID: {
                tableDesc = nonAcidTableDescriptor;
            }
        }
        FileSinkDesc desc = null;
        if (dynamic) {
            ArrayList<ExprNodeColumnDesc> partCols = new ArrayList<ExprNodeColumnDesc>(1);
            partCols.add(new ExprNodeColumnDesc((TypeInfo)TypeInfoFactory.stringTypeInfo, PARTCOL_NAME, "a", true));
            LinkedHashMap<String, Object> partColMap = new LinkedHashMap<String, Object>(1);
            partColMap.put(PARTCOL_NAME, null);
            DynamicPartitionCtx dpCtx = new DynamicPartitionCtx(null, partColMap, "Sunday", 100);
            HashMap<String, String> partColNames = new HashMap<String, String>(1);
            partColNames.put(PARTCOL_NAME, PARTCOL_NAME);
            dpCtx.setInputToDPCols(partColNames);
            desc = new FileSinkDesc(this.basePath, tableDesc, false, 1, false, false, 1, 1, partCols, dpCtx);
        } else {
            desc = new FileSinkDesc(this.basePath, tableDesc, false);
        }
        desc.setWriteType(writeType);
        desc.setGatherStats(true);
        if (txnId > 0L) {
            desc.setTransactionId(txnId);
        }
        if (writeType != AcidUtils.Operation.NOT_ACID) {
            desc.setTransactionId(1L);
        }
        FileSinkOperator op = (FileSinkOperator)OperatorFactory.get(FileSinkDesc.class);
        op.setConf((OperatorDesc)desc);
        op.initialize((Configuration)this.jc, new ObjectInspector[]{inspector});
        return op;
    }

    private void processRows(FileSinkOperator op) throws HiveException {
        for (TFSORow r : rows) {
            op.process((Object)r, 0);
        }
        op.jobCloseOp((Configuration)this.jc, true);
        op.close(false);
    }

    private void confirmOutput() throws IOException, SerDeException {
        int i;
        Path[] paths = this.findFilesInBasePath();
        TFSOInputFormat input = new TFSOInputFormat();
        FileInputFormat.setInputPaths((JobConf)this.jc, (Path[])paths);
        InputSplit[] splits = input.getSplits(this.jc, 1);
        RecordReader<NullWritable, TFSORow> reader = input.getRecordReader(splits[0], this.jc, (Reporter)Mockito.mock(Reporter.class));
        NullWritable key = (NullWritable)reader.createKey();
        TFSORow value = (TFSORow)reader.createValue();
        ArrayList<TFSORow> results = new ArrayList<TFSORow>(rows.size());
        ArrayList<TFSORow> sortedRows = new ArrayList<TFSORow>(rows.size());
        for (i = 0; i < rows.size(); ++i) {
            Assert.assertTrue((boolean)reader.next((Object)key, (Object)value));
            results.add(new TFSORow(value));
            sortedRows.add(new TFSORow(rows.get(i)));
        }
        Assert.assertFalse((boolean)reader.next((Object)key, (Object)value));
        Collections.sort(results);
        Collections.sort(sortedRows);
        for (i = 0; i < rows.size(); ++i) {
            Assert.assertTrue((boolean)((TFSORow)sortedRows.get(i)).equals(results.get(i)));
        }
    }

    private Path[] findFilesInBasePath() throws IOException {
        Path parent = this.basePath.getParent();
        String last = this.basePath.getName();
        Path tmpPath = new Path(parent, "_tmp." + last);
        FileSystem fs = this.basePath.getFileSystem((Configuration)this.jc);
        ArrayList<Path> paths = new ArrayList<Path>();
        this.recurseOnPath(tmpPath, fs, paths);
        return paths.toArray(new Path[paths.size()]);
    }

    private void recurseOnPath(Path p, FileSystem fs, List<Path> paths) throws IOException {
        if (fs.getFileStatus(p).isDir()) {
            FileStatus[] stats;
            for (FileStatus stat : stats = fs.listStatus(p)) {
                this.recurseOnPath(stat.getPath(), fs, paths);
            }
        } else {
            paths.add(p);
        }
    }

    public static class TFSOStatsAggregator
    implements StatsAggregator {
        public boolean connect(Configuration hconf, Task sourceTask) {
            return true;
        }

        public String aggregateStats(String keyPrefix, String statType) {
            return null;
        }

        public boolean closeConnection() {
            return true;
        }

        public boolean cleanUp(String keyPrefix) {
            return true;
        }
    }

    public static class TFSOStatsPublisher
    implements StatsPublisher {
        static Map<String, String> stats;

        public boolean init(Configuration hconf) {
            return true;
        }

        public boolean connect(Configuration hconf) {
            return true;
        }

        public boolean publishStat(String fileID, Map<String, String> stats) {
            TFSOStatsPublisher.stats = stats;
            return true;
        }

        public boolean closeConnection() {
            return true;
        }
    }

    public static class TFSOSerDe
    implements SerDe {
        public void initialize(Configuration conf, Properties tbl) throws SerDeException {
        }

        public Class<? extends Writable> getSerializedClass() {
            return TFSORow.class;
        }

        public Writable serialize(Object obj, ObjectInspector objInspector) throws SerDeException {
            assert (obj instanceof TFSORow) : "Expected TFSORow or decendent, got " + obj.getClass().getName();
            return (TFSORow)obj;
        }

        public Object deserialize(Writable blob) throws SerDeException {
            assert (blob instanceof TFSORow) : "Expected TFSORow or decendent, got " + blob.getClass().getName();
            return blob;
        }

        public ObjectInspector getObjectInspector() throws SerDeException {
            return null;
        }

        public SerDeStats getSerDeStats() {
            return null;
        }
    }

    public static class TFSOOutputFormat
    extends FileOutputFormat<NullWritable, TFSORow>
    implements AcidOutputFormat<NullWritable, TFSORow> {
        List<TFSORow> records = new ArrayList<TFSORow>();
        long numRecordsAdded = 0L;
        FSDataOutputStream out = null;

        public RecordUpdater getRecordUpdater(final Path path, final AcidOutputFormat.Options options) throws IOException {
            StructObjectInspector inspector = (StructObjectInspector)options.getInspector();
            return new RecordUpdater(){

                public void insert(long currentTransaction, Object row) throws IOException {
                    this.addRow(row);
                    ++TFSOOutputFormat.this.numRecordsAdded;
                }

                public void update(long currentTransaction, Object row) throws IOException {
                    this.addRow(row);
                }

                public void delete(long currentTransaction, Object row) throws IOException {
                    this.addRow(row);
                    --TFSOOutputFormat.this.numRecordsAdded;
                }

                private void addRow(Object row) {
                    assert (row instanceof TFSORow) : "Expected TFSORow but got " + row.getClass().getName();
                    TFSOOutputFormat.this.records.add((TFSORow)row);
                }

                public void flush() throws IOException {
                    if (TFSOOutputFormat.this.out == null) {
                        FileSystem fs = path.getFileSystem(options.getConfiguration());
                        TFSOOutputFormat.this.out = fs.create(path);
                    }
                    for (TFSORow r : TFSOOutputFormat.this.records) {
                        r.write((DataOutput)TFSOOutputFormat.this.out);
                    }
                    TFSOOutputFormat.this.records.clear();
                    TFSOOutputFormat.this.out.flush();
                }

                public void close(boolean abort) throws IOException {
                    this.flush();
                    TFSOOutputFormat.this.out.close();
                }

                public SerDeStats getStats() {
                    SerDeStats stats = new SerDeStats();
                    stats.setRowCount(TFSOOutputFormat.this.numRecordsAdded);
                    return stats;
                }
            };
        }

        public FileSinkOperator.RecordWriter getRawRecordWriter(Path path, AcidOutputFormat.Options options) throws IOException {
            return null;
        }

        public FileSinkOperator.RecordWriter getHiveRecordWriter(final JobConf jc, final Path finalOutPath, Class<? extends Writable> valueClass, boolean isCompressed, Properties tableProperties, Progressable progress) throws IOException {
            return new FileSinkOperator.RecordWriter(){

                public void write(Writable w) throws IOException {
                    Assert.assertTrue((boolean)(w instanceof TFSORow));
                    TFSOOutputFormat.this.records.add((TFSORow)w);
                }

                public void close(boolean abort) throws IOException {
                    if (TFSOOutputFormat.this.out == null) {
                        FileSystem fs = finalOutPath.getFileSystem((Configuration)jc);
                        TFSOOutputFormat.this.out = fs.create(finalOutPath);
                    }
                    for (TFSORow r : TFSOOutputFormat.this.records) {
                        r.write((DataOutput)TFSOOutputFormat.this.out);
                    }
                    TFSOOutputFormat.this.records.clear();
                    TFSOOutputFormat.this.out.flush();
                    TFSOOutputFormat.this.out.close();
                }
            };
        }

        public RecordWriter<NullWritable, TFSORow> getRecordWriter(FileSystem fileSystem, JobConf entries, String s, Progressable progressable) throws IOException {
            return null;
        }

        public void checkOutputSpecs(FileSystem fileSystem, JobConf entries) throws IOException {
        }
    }

    private static class TFSOInputFormat
    extends FileInputFormat<NullWritable, TFSORow>
    implements AcidInputFormat<NullWritable, TFSORow> {
        FSDataInputStream[] in = null;
        int readingFrom = -1;

        private TFSOInputFormat() {
        }

        public RecordReader<NullWritable, TFSORow> getRecordReader(InputSplit inputSplit, JobConf entries, Reporter reporter) throws IOException {
            if (this.in == null) {
                Path[] paths = FileInputFormat.getInputPaths((JobConf)entries);
                this.in = new FSDataInputStream[paths.length];
                FileSystem fs = paths[0].getFileSystem((Configuration)entries);
                for (int i = 0; i < paths.length; ++i) {
                    this.in[i] = fs.open(paths[i]);
                }
                this.readingFrom = 0;
            }
            return new RecordReader<NullWritable, TFSORow>(){

                public boolean next(NullWritable nullWritable, TFSORow tfsoRecord) throws IOException {
                    try {
                        tfsoRecord.readFields((DataInput)TFSOInputFormat.this.in[TFSOInputFormat.this.readingFrom]);
                        return true;
                    }
                    catch (EOFException e) {
                        TFSOInputFormat.this.in[TFSOInputFormat.this.readingFrom].close();
                        if (++TFSOInputFormat.this.readingFrom >= TFSOInputFormat.this.in.length) {
                            return false;
                        }
                        return this.next(nullWritable, tfsoRecord);
                    }
                }

                public NullWritable createKey() {
                    return NullWritable.get();
                }

                public TFSORow createValue() {
                    return new TFSORow();
                }

                public long getPos() throws IOException {
                    return 0L;
                }

                public void close() throws IOException {
                }

                public float getProgress() throws IOException {
                    return 0.0f;
                }
            };
        }

        public AcidInputFormat.RowReader<TFSORow> getReader(InputSplit split, AcidInputFormat.Options options) throws IOException {
            return null;
        }

        public AcidInputFormat.RawReader<TFSORow> getRawReader(Configuration conf, boolean collapseEvents, int bucket, ValidTxnList validTxnList, Path baseDirectory, Path[] deltaDirectory) throws IOException {
            return null;
        }

        public boolean validateInput(FileSystem fs, HiveConf conf, ArrayList<FileStatus> files) throws IOException {
            return false;
        }
    }

    private static class TFSORow
    implements WritableComparable<TFSORow> {
        private RecordIdentifier recId;
        private Text data;
        private Text partVal;

        TFSORow() {
            this(null, null, null);
        }

        TFSORow(Text t) {
            this(t, null, null);
        }

        TFSORow(Text t, Text pv) {
            this(t, pv, null);
        }

        TFSORow(Text t, RecordIdentifier ri) {
            this(t, null, ri);
        }

        TFSORow(Text t, Text pv, RecordIdentifier ri) {
            this.data = t;
            this.partVal = pv;
            this.recId = ri;
        }

        TFSORow(TFSORow other) {
            this(other.data, other.partVal, other.recId);
        }

        public void write(DataOutput dataOutput) throws IOException {
            this.data.write(dataOutput);
            if (this.partVal == null) {
                dataOutput.writeBoolean(false);
            } else {
                dataOutput.writeBoolean(true);
                this.partVal.write(dataOutput);
            }
            if (this.recId == null) {
                dataOutput.writeBoolean(false);
            } else {
                dataOutput.writeBoolean(true);
                this.recId.write(dataOutput);
            }
        }

        public void readFields(DataInput dataInput) throws IOException {
            this.data = new Text();
            this.data.readFields(dataInput);
            boolean notNull = dataInput.readBoolean();
            if (notNull) {
                this.partVal = new Text();
                this.partVal.readFields(dataInput);
            }
            if (notNull = dataInput.readBoolean()) {
                this.recId = new RecordIdentifier();
                this.recId.readFields(dataInput);
            }
        }

        public boolean equals(Object obj) {
            if (obj instanceof TFSORow) {
                TFSORow other = (TFSORow)obj;
                if (this.data == null && other.data == null) {
                    return this.checkPartVal(other);
                }
                if (this.data == null) {
                    return false;
                }
                if (this.data.equals((Object)other.data)) {
                    return this.checkPartVal(other);
                }
                return false;
            }
            return false;
        }

        private boolean checkPartVal(TFSORow other) {
            if (this.partVal == null && other.partVal == null) {
                return this.checkRecId(other);
            }
            if (this.partVal == null) {
                return false;
            }
            if (this.partVal.equals((Object)other.partVal)) {
                return this.checkRecId(other);
            }
            return false;
        }

        private boolean checkRecId(TFSORow other) {
            if (this.recId == null && other.recId == null) {
                return true;
            }
            if (this.recId == null) {
                return false;
            }
            return this.recId.equals((Object)other.recId);
        }

        public int compareTo(TFSORow other) {
            if (this.recId == null && other.recId == null) {
                return this.comparePartVal(other);
            }
            if (this.recId == null) {
                return -1;
            }
            int rc = this.recId.compareTo(other.recId);
            if (rc == 0) {
                return this.comparePartVal(other);
            }
            return rc;
        }

        private int comparePartVal(TFSORow other) {
            if (this.partVal == null && other.partVal == null) {
                return this.compareData(other);
            }
            if (this.partVal == null) {
                return -1;
            }
            int rc = this.partVal.compareTo((BinaryComparable)other.partVal);
            if (rc == 0) {
                return this.compareData(other);
            }
            return rc;
        }

        private int compareData(TFSORow other) {
            if (this.data == null && other.data == null) {
                return 0;
            }
            if (this.data == null) {
                return -1;
            }
            return this.data.compareTo((BinaryComparable)other.data);
        }
    }

    private static enum DataFormat {
        SIMPLE,
        WITH_RECORD_ID,
        WITH_PARTITION_VALUE,
        WITH_RECORD_ID_AND_PARTITION_VALUE;

    }
}

