/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.txn.compactor;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import junit.framework.Assert;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.MetaStoreThread;
import org.apache.hadoop.hive.metastore.api.CompactionRequest;
import org.apache.hadoop.hive.metastore.api.CompactionType;
import org.apache.hadoop.hive.metastore.api.LockComponent;
import org.apache.hadoop.hive.metastore.api.LockLevel;
import org.apache.hadoop.hive.metastore.api.LockRequest;
import org.apache.hadoop.hive.metastore.api.LockResponse;
import org.apache.hadoop.hive.metastore.api.LockType;
import org.apache.hadoop.hive.metastore.api.Partition;
import org.apache.hadoop.hive.metastore.api.ShowCompactRequest;
import org.apache.hadoop.hive.metastore.api.ShowCompactResponse;
import org.apache.hadoop.hive.metastore.api.ShowCompactResponseElement;
import org.apache.hadoop.hive.metastore.api.Table;
import org.apache.hadoop.hive.metastore.api.UnlockRequest;
import org.apache.hadoop.hive.metastore.txn.CompactionInfo;
import org.apache.hadoop.hive.ql.txn.compactor.CompactorTest;
import org.junit.Test;

public class TestCleaner
extends CompactorTest {
    private static final Log LOG = LogFactory.getLog((String)TestCleaner.class.getName());

    @Test
    public void nothing() throws Exception {
        this.startCleaner();
    }

    @Test
    public void cleanupAfterMajorTableCompaction() throws Exception {
        Table t = this.newTable("default", "camtc", false);
        this.addBaseFile(t, null, 20L, 20);
        this.addDeltaFile(t, null, 21L, 22L, 2);
        this.addDeltaFile(t, null, 23L, 24L, 2);
        this.addBaseFile(t, null, 25L, 25);
        this.burnThroughTransactions(25);
        CompactionRequest rqst = new CompactionRequest("default", "camtc", CompactionType.MAJOR);
        this.txnHandler.compact(rqst);
        CompactionInfo ci = this.txnHandler.findNextToCompact("fred");
        this.txnHandler.markCompacted(ci);
        this.txnHandler.setRunAs(ci.id, System.getProperty("user.name"));
        this.startCleaner();
        ShowCompactResponse rsp = this.txnHandler.showCompact(new ShowCompactRequest());
        Assert.assertEquals((int)0, (int)rsp.getCompactsSize());
        List<Path> paths = this.getDirectories(this.conf, t, null);
        Assert.assertEquals((int)1, (int)paths.size());
        Assert.assertEquals((String)"base_25", (String)paths.get(0).getName());
    }

    @Test
    public void cleanupAfterMajorPartitionCompaction() throws Exception {
        Table t = this.newTable("default", "campc", true);
        Partition p = this.newPartition(t, "today");
        this.addBaseFile(t, p, 20L, 20);
        this.addDeltaFile(t, p, 21L, 22L, 2);
        this.addDeltaFile(t, p, 23L, 24L, 2);
        this.addBaseFile(t, p, 25L, 25);
        this.burnThroughTransactions(25);
        CompactionRequest rqst = new CompactionRequest("default", "campc", CompactionType.MAJOR);
        rqst.setPartitionname("ds=today");
        this.txnHandler.compact(rqst);
        CompactionInfo ci = this.txnHandler.findNextToCompact("fred");
        this.txnHandler.markCompacted(ci);
        this.txnHandler.setRunAs(ci.id, System.getProperty("user.name"));
        this.startCleaner();
        ShowCompactResponse rsp = this.txnHandler.showCompact(new ShowCompactRequest());
        Assert.assertEquals((int)0, (int)rsp.getCompactsSize());
        List<Path> paths = this.getDirectories(this.conf, t, p);
        Assert.assertEquals((int)1, (int)paths.size());
        Assert.assertEquals((String)"base_25", (String)paths.get(0).getName());
    }

    @Test
    public void cleanupAfterMinorTableCompaction() throws Exception {
        Table t = this.newTable("default", "camitc", false);
        this.addBaseFile(t, null, 20L, 20);
        this.addDeltaFile(t, null, 21L, 22L, 2);
        this.addDeltaFile(t, null, 23L, 24L, 2);
        this.addDeltaFile(t, null, 21L, 24L, 4);
        this.burnThroughTransactions(25);
        CompactionRequest rqst = new CompactionRequest("default", "camitc", CompactionType.MINOR);
        this.txnHandler.compact(rqst);
        CompactionInfo ci = this.txnHandler.findNextToCompact("fred");
        this.txnHandler.markCompacted(ci);
        this.txnHandler.setRunAs(ci.id, System.getProperty("user.name"));
        this.startCleaner();
        ShowCompactResponse rsp = this.txnHandler.showCompact(new ShowCompactRequest());
        Assert.assertEquals((int)0, (int)rsp.getCompactsSize());
        List<Path> paths = this.getDirectories(this.conf, t, null);
        Assert.assertEquals((int)2, (int)paths.size());
        boolean sawBase = false;
        boolean sawDelta = false;
        for (Path p : paths) {
            if (p.getName().equals("base_20")) {
                sawBase = true;
                continue;
            }
            if (p.getName().equals("delta_21_24")) {
                sawDelta = true;
                continue;
            }
            Assert.fail((String)("Unexpected file " + p.getName()));
        }
        Assert.assertTrue((boolean)sawBase);
        Assert.assertTrue((boolean)sawDelta);
    }

    @Test
    public void cleanupAfterMinorPartitionCompaction() throws Exception {
        Table t = this.newTable("default", "camipc", true);
        Partition p = this.newPartition(t, "today");
        this.addBaseFile(t, p, 20L, 20);
        this.addDeltaFile(t, p, 21L, 22L, 2);
        this.addDeltaFile(t, p, 23L, 24L, 2);
        this.addDeltaFile(t, p, 21L, 24L, 4);
        this.burnThroughTransactions(25);
        CompactionRequest rqst = new CompactionRequest("default", "camipc", CompactionType.MINOR);
        rqst.setPartitionname("ds=today");
        this.txnHandler.compact(rqst);
        CompactionInfo ci = this.txnHandler.findNextToCompact("fred");
        this.txnHandler.markCompacted(ci);
        this.txnHandler.setRunAs(ci.id, System.getProperty("user.name"));
        this.startCleaner();
        ShowCompactResponse rsp = this.txnHandler.showCompact(new ShowCompactRequest());
        Assert.assertEquals((int)0, (int)rsp.getCompactsSize());
        List<Path> paths = this.getDirectories(this.conf, t, p);
        Assert.assertEquals((int)2, (int)paths.size());
        boolean sawBase = false;
        boolean sawDelta = false;
        for (Path path : paths) {
            if (path.getName().equals("base_20")) {
                sawBase = true;
                continue;
            }
            if (path.getName().equals("delta_21_24")) {
                sawDelta = true;
                continue;
            }
            Assert.fail((String)("Unexpected file " + path.getName()));
        }
        Assert.assertTrue((boolean)sawBase);
        Assert.assertTrue((boolean)sawDelta);
    }

    @Test
    public void blockedByLockTable() throws Exception {
        Table t = this.newTable("default", "bblt", false);
        this.addBaseFile(t, null, 20L, 20);
        this.addDeltaFile(t, null, 21L, 22L, 2);
        this.addDeltaFile(t, null, 23L, 24L, 2);
        this.addDeltaFile(t, null, 21L, 24L, 4);
        this.burnThroughTransactions(25);
        CompactionRequest rqst = new CompactionRequest("default", "bblt", CompactionType.MINOR);
        this.txnHandler.compact(rqst);
        CompactionInfo ci = this.txnHandler.findNextToCompact("fred");
        this.txnHandler.markCompacted(ci);
        this.txnHandler.setRunAs(ci.id, System.getProperty("user.name"));
        LockComponent comp = new LockComponent(LockType.SHARED_READ, LockLevel.TABLE, "default");
        comp.setTablename("bblt");
        ArrayList<LockComponent> components = new ArrayList<LockComponent>(1);
        components.add(comp);
        LockRequest req = new LockRequest(components, "me", "localhost");
        LockResponse res = this.txnHandler.lock(req);
        this.startCleaner();
        ShowCompactResponse rsp = this.txnHandler.showCompact(new ShowCompactRequest());
        List compacts = rsp.getCompacts();
        Assert.assertEquals((int)1, (int)compacts.size());
        Assert.assertEquals((String)"ready for cleaning", (String)((ShowCompactResponseElement)compacts.get(0)).getState());
        Assert.assertEquals((String)"bblt", (String)((ShowCompactResponseElement)compacts.get(0)).getTablename());
        Assert.assertEquals((Object)CompactionType.MINOR, (Object)((ShowCompactResponseElement)compacts.get(0)).getType());
    }

    @Test
    public void blockedByLockPartition() throws Exception {
        Table t = this.newTable("default", "bblp", true);
        Partition p = this.newPartition(t, "today");
        this.addBaseFile(t, p, 20L, 20);
        this.addDeltaFile(t, p, 21L, 22L, 2);
        this.addDeltaFile(t, p, 23L, 24L, 2);
        this.addDeltaFile(t, p, 21L, 24L, 4);
        this.burnThroughTransactions(25);
        CompactionRequest rqst = new CompactionRequest("default", "bblp", CompactionType.MINOR);
        rqst.setPartitionname("ds=today");
        this.txnHandler.compact(rqst);
        CompactionInfo ci = this.txnHandler.findNextToCompact("fred");
        this.txnHandler.markCompacted(ci);
        this.txnHandler.setRunAs(ci.id, System.getProperty("user.name"));
        LockComponent comp = new LockComponent(LockType.SHARED_WRITE, LockLevel.PARTITION, "default");
        comp.setTablename("bblp");
        comp.setPartitionname("ds=today");
        ArrayList<LockComponent> components = new ArrayList<LockComponent>(1);
        components.add(comp);
        LockRequest req = new LockRequest(components, "me", "localhost");
        LockResponse res = this.txnHandler.lock(req);
        this.startCleaner();
        ShowCompactResponse rsp = this.txnHandler.showCompact(new ShowCompactRequest());
        List compacts = rsp.getCompacts();
        Assert.assertEquals((int)1, (int)compacts.size());
        Assert.assertEquals((String)"ready for cleaning", (String)((ShowCompactResponseElement)compacts.get(0)).getState());
        Assert.assertEquals((String)"bblp", (String)((ShowCompactResponseElement)compacts.get(0)).getTablename());
        Assert.assertEquals((String)"ds=today", (String)((ShowCompactResponseElement)compacts.get(0)).getPartitionname());
        Assert.assertEquals((Object)CompactionType.MINOR, (Object)((ShowCompactResponseElement)compacts.get(0)).getType());
    }

    @Test
    public void notBlockedBySubsequentLock() throws Exception {
        Table t = this.newTable("default", "bblt", false);
        this.conf.setTimeVar(HiveConf.ConfVars.HIVE_COMPACTOR_CLEANER_RUN_INTERVAL, 100L, TimeUnit.MILLISECONDS);
        this.addBaseFile(t, null, 20L, 20);
        this.addDeltaFile(t, null, 21L, 22L, 2);
        this.addDeltaFile(t, null, 23L, 24L, 2);
        this.addDeltaFile(t, null, 21L, 24L, 4);
        this.burnThroughTransactions(25);
        CompactionRequest rqst = new CompactionRequest("default", "bblt", CompactionType.MINOR);
        this.txnHandler.compact(rqst);
        CompactionInfo ci = this.txnHandler.findNextToCompact("fred");
        this.txnHandler.markCompacted(ci);
        this.txnHandler.setRunAs(ci.id, System.getProperty("user.name"));
        LockComponent comp = new LockComponent(LockType.SHARED_READ, LockLevel.TABLE, "default");
        comp.setTablename("bblt");
        ArrayList<LockComponent> components = new ArrayList<LockComponent>(1);
        components.add(comp);
        LockRequest req = new LockRequest(components, "me", "localhost");
        LockResponse res = this.txnHandler.lock(req);
        MetaStoreThread.BooleanPointer looped = new MetaStoreThread.BooleanPointer();
        looped.boolVal = false;
        this.startCleaner(looped);
        while (!looped.boolVal) {
            Thread.currentThread();
            Thread.sleep(100L);
        }
        ShowCompactResponse rsp = this.txnHandler.showCompact(new ShowCompactRequest());
        List compacts = rsp.getCompacts();
        Assert.assertEquals((int)1, (int)compacts.size());
        LockComponent comp2 = new LockComponent(LockType.SHARED_READ, LockLevel.TABLE, "default");
        comp2.setTablename("bblt");
        ArrayList<LockComponent> components2 = new ArrayList<LockComponent>(1);
        components2.add(comp2);
        LockRequest req2 = new LockRequest(components, "me", "localhost");
        LockResponse res2 = this.txnHandler.lock(req2);
        this.txnHandler.unlock(new UnlockRequest(res.getLockid()));
        looped.boolVal = false;
        while (!looped.boolVal) {
            Thread.currentThread();
            Thread.sleep(100L);
        }
        this.stopThread();
        Thread.currentThread();
        Thread.sleep(200L);
        rsp = this.txnHandler.showCompact(new ShowCompactRequest());
        compacts = rsp.getCompacts();
        Assert.assertEquals((int)0, (int)compacts.size());
    }

    @Test
    public void partitionNotBlockedBySubsequentLock() throws Exception {
        Table t = this.newTable("default", "bblt", true);
        Partition p = this.newPartition(t, "today");
        this.conf.setTimeVar(HiveConf.ConfVars.HIVE_COMPACTOR_CLEANER_RUN_INTERVAL, 100L, TimeUnit.MILLISECONDS);
        this.addBaseFile(t, p, 20L, 20);
        this.addDeltaFile(t, p, 21L, 22L, 2);
        this.addDeltaFile(t, p, 23L, 24L, 2);
        this.addDeltaFile(t, p, 21L, 24L, 4);
        this.burnThroughTransactions(25);
        CompactionRequest rqst = new CompactionRequest("default", "bblt", CompactionType.MINOR);
        rqst.setPartitionname("ds=today");
        this.txnHandler.compact(rqst);
        CompactionInfo ci = this.txnHandler.findNextToCompact("fred");
        this.txnHandler.markCompacted(ci);
        this.txnHandler.setRunAs(ci.id, System.getProperty("user.name"));
        LockComponent comp = new LockComponent(LockType.SHARED_READ, LockLevel.PARTITION, "default");
        comp.setTablename("bblt");
        comp.setPartitionname("ds=today");
        ArrayList<LockComponent> components = new ArrayList<LockComponent>(1);
        components.add(comp);
        LockRequest req = new LockRequest(components, "me", "localhost");
        LockResponse res = this.txnHandler.lock(req);
        MetaStoreThread.BooleanPointer looped = new MetaStoreThread.BooleanPointer();
        looped.boolVal = false;
        this.startCleaner(looped);
        while (!looped.boolVal) {
            Thread.currentThread();
            Thread.sleep(100L);
        }
        ShowCompactResponse rsp = this.txnHandler.showCompact(new ShowCompactRequest());
        List compacts = rsp.getCompacts();
        Assert.assertEquals((int)1, (int)compacts.size());
        LockComponent comp2 = new LockComponent(LockType.SHARED_READ, LockLevel.PARTITION, "default");
        comp2.setTablename("bblt");
        comp2.setPartitionname("ds=today");
        ArrayList<LockComponent> components2 = new ArrayList<LockComponent>(1);
        components2.add(comp2);
        LockRequest req2 = new LockRequest(components, "me", "localhost");
        LockResponse res2 = this.txnHandler.lock(req2);
        this.txnHandler.unlock(new UnlockRequest(res.getLockid()));
        looped.boolVal = false;
        while (!looped.boolVal) {
            Thread.currentThread();
            Thread.sleep(100L);
        }
        this.stopThread();
        Thread.currentThread();
        Thread.sleep(200L);
        rsp = this.txnHandler.showCompact(new ShowCompactRequest());
        compacts = rsp.getCompacts();
        Assert.assertEquals((int)0, (int)compacts.size());
    }

    @Test
    public void cleanupAfterMajorPartitionCompactionNoBase() throws Exception {
        Table t = this.newTable("default", "campcnb", true);
        Partition p = this.newPartition(t, "today");
        this.addDeltaFile(t, p, 1L, 22L, 22);
        this.addDeltaFile(t, p, 23L, 24L, 2);
        this.addBaseFile(t, p, 25L, 25);
        this.burnThroughTransactions(25);
        CompactionRequest rqst = new CompactionRequest("default", "campcnb", CompactionType.MAJOR);
        rqst.setPartitionname("ds=today");
        this.txnHandler.compact(rqst);
        CompactionInfo ci = this.txnHandler.findNextToCompact("fred");
        this.txnHandler.markCompacted(ci);
        this.txnHandler.setRunAs(ci.id, System.getProperty("user.name"));
        this.startCleaner();
        ShowCompactResponse rsp = this.txnHandler.showCompact(new ShowCompactRequest());
        Assert.assertEquals((int)0, (int)rsp.getCompactsSize());
        List<Path> paths = this.getDirectories(this.conf, t, p);
        Assert.assertEquals((int)1, (int)paths.size());
        Assert.assertEquals((String)"base_25", (String)paths.get(0).getName());
    }
}

