/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.io.orc;

import java.sql.Timestamp;
import junit.framework.Assert;
import org.apache.hadoop.hive.common.type.HiveDecimal;
import org.apache.hadoop.hive.ql.io.orc.ColumnStatisticsImpl;
import org.apache.hadoop.hive.ql.io.orc.DateColumnStatistics;
import org.apache.hadoop.hive.ql.io.orc.DecimalColumnStatistics;
import org.apache.hadoop.hive.ql.io.orc.DoubleColumnStatistics;
import org.apache.hadoop.hive.ql.io.orc.IntegerColumnStatistics;
import org.apache.hadoop.hive.ql.io.orc.StringColumnStatistics;
import org.apache.hadoop.hive.ql.io.orc.TimestampColumnStatistics;
import org.apache.hadoop.hive.serde2.io.DateWritable;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.JavaDateObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.JavaDoubleObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.JavaHiveDecimalObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.JavaIntObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.JavaStringObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.JavaTimestampObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.PrimitiveObjectInspectorFactory;
import org.apache.hadoop.io.Text;
import org.junit.Test;

public class TestColumnStatistics {
    @Test
    public void testLongMerge() throws Exception {
        JavaIntObjectInspector inspector = PrimitiveObjectInspectorFactory.javaIntObjectInspector;
        ColumnStatisticsImpl stats1 = ColumnStatisticsImpl.create((ObjectInspector)inspector);
        ColumnStatisticsImpl stats2 = ColumnStatisticsImpl.create((ObjectInspector)inspector);
        stats1.updateInteger(10L);
        stats1.updateInteger(10L);
        stats2.updateInteger(1L);
        stats2.updateInteger(1000L);
        stats1.merge(stats2);
        IntegerColumnStatistics typed = (IntegerColumnStatistics)stats1;
        Assert.assertEquals((long)1L, (long)typed.getMinimum());
        Assert.assertEquals((long)1000L, (long)typed.getMaximum());
        stats1.reset();
        stats1.updateInteger(-10L);
        stats1.updateInteger(10000L);
        stats1.merge(stats2);
        Assert.assertEquals((long)-10L, (long)typed.getMinimum());
        Assert.assertEquals((long)10000L, (long)typed.getMaximum());
    }

    @Test
    public void testDoubleMerge() throws Exception {
        JavaDoubleObjectInspector inspector = PrimitiveObjectInspectorFactory.javaDoubleObjectInspector;
        ColumnStatisticsImpl stats1 = ColumnStatisticsImpl.create((ObjectInspector)inspector);
        ColumnStatisticsImpl stats2 = ColumnStatisticsImpl.create((ObjectInspector)inspector);
        stats1.updateDouble(10.0);
        stats1.updateDouble(100.0);
        stats2.updateDouble(1.0);
        stats2.updateDouble(1000.0);
        stats1.merge(stats2);
        DoubleColumnStatistics typed = (DoubleColumnStatistics)stats1;
        Assert.assertEquals((double)1.0, (double)typed.getMinimum(), (double)0.001);
        Assert.assertEquals((double)1000.0, (double)typed.getMaximum(), (double)0.001);
        stats1.reset();
        stats1.updateDouble(-10.0);
        stats1.updateDouble(10000.0);
        stats1.merge(stats2);
        Assert.assertEquals((double)-10.0, (double)typed.getMinimum(), (double)0.001);
        Assert.assertEquals((double)10000.0, (double)typed.getMaximum(), (double)0.001);
    }

    @Test
    public void testStringMerge() throws Exception {
        JavaStringObjectInspector inspector = PrimitiveObjectInspectorFactory.javaStringObjectInspector;
        ColumnStatisticsImpl stats1 = ColumnStatisticsImpl.create((ObjectInspector)inspector);
        ColumnStatisticsImpl stats2 = ColumnStatisticsImpl.create((ObjectInspector)inspector);
        stats1.updateString(new Text("bob"));
        stats1.updateString(new Text("david"));
        stats1.updateString(new Text("charles"));
        stats2.updateString(new Text("anne"));
        stats2.updateString(new Text("erin"));
        stats1.merge(stats2);
        StringColumnStatistics typed = (StringColumnStatistics)stats1;
        Assert.assertEquals((String)"anne", (String)typed.getMinimum());
        Assert.assertEquals((String)"erin", (String)typed.getMaximum());
        stats1.reset();
        stats1.updateString(new Text("aaa"));
        stats1.updateString(new Text("zzz"));
        stats1.merge(stats2);
        Assert.assertEquals((String)"aaa", (String)typed.getMinimum());
        Assert.assertEquals((String)"zzz", (String)typed.getMaximum());
    }

    @Test
    public void testDateMerge() throws Exception {
        JavaDateObjectInspector inspector = PrimitiveObjectInspectorFactory.javaDateObjectInspector;
        ColumnStatisticsImpl stats1 = ColumnStatisticsImpl.create((ObjectInspector)inspector);
        ColumnStatisticsImpl stats2 = ColumnStatisticsImpl.create((ObjectInspector)inspector);
        stats1.updateDate(new DateWritable(1000));
        stats1.updateDate(new DateWritable(100));
        stats2.updateDate(new DateWritable(10));
        stats2.updateDate(new DateWritable(2000));
        stats1.merge(stats2);
        DateColumnStatistics typed = (DateColumnStatistics)stats1;
        Assert.assertEquals((Object)new DateWritable(10), (Object)typed.getMinimum());
        Assert.assertEquals((Object)new DateWritable(2000), (Object)typed.getMaximum());
        stats1.reset();
        stats1.updateDate(new DateWritable(-10));
        stats1.updateDate(new DateWritable(10000));
        stats1.merge(stats2);
        Assert.assertEquals((int)-10, (int)typed.getMinimum().getDays());
        Assert.assertEquals((int)10000, (int)typed.getMaximum().getDays());
    }

    @Test
    public void testTimestampMerge() throws Exception {
        JavaTimestampObjectInspector inspector = PrimitiveObjectInspectorFactory.javaTimestampObjectInspector;
        ColumnStatisticsImpl stats1 = ColumnStatisticsImpl.create((ObjectInspector)inspector);
        ColumnStatisticsImpl stats2 = ColumnStatisticsImpl.create((ObjectInspector)inspector);
        stats1.updateTimestamp(new Timestamp(10L));
        stats1.updateTimestamp(new Timestamp(100L));
        stats2.updateTimestamp(new Timestamp(1L));
        stats2.updateTimestamp(new Timestamp(1000L));
        stats1.merge(stats2);
        TimestampColumnStatistics typed = (TimestampColumnStatistics)stats1;
        Assert.assertEquals((long)1L, (long)typed.getMinimum().getTime());
        Assert.assertEquals((long)1000L, (long)typed.getMaximum().getTime());
        stats1.reset();
        stats1.updateTimestamp(new Timestamp(-10L));
        stats1.updateTimestamp(new Timestamp(10000L));
        stats1.merge(stats2);
        Assert.assertEquals((long)-10L, (long)typed.getMinimum().getTime());
        Assert.assertEquals((long)10000L, (long)typed.getMaximum().getTime());
    }

    @Test
    public void testDecimalMerge() throws Exception {
        JavaHiveDecimalObjectInspector inspector = PrimitiveObjectInspectorFactory.javaHiveDecimalObjectInspector;
        ColumnStatisticsImpl stats1 = ColumnStatisticsImpl.create((ObjectInspector)inspector);
        ColumnStatisticsImpl stats2 = ColumnStatisticsImpl.create((ObjectInspector)inspector);
        stats1.updateDecimal(HiveDecimal.create((int)10));
        stats1.updateDecimal(HiveDecimal.create((int)100));
        stats2.updateDecimal(HiveDecimal.create((int)1));
        stats2.updateDecimal(HiveDecimal.create((int)1000));
        stats1.merge(stats2);
        DecimalColumnStatistics typed = (DecimalColumnStatistics)stats1;
        Assert.assertEquals((long)1L, (long)typed.getMinimum().longValue());
        Assert.assertEquals((long)1000L, (long)typed.getMaximum().longValue());
        stats1.reset();
        stats1.updateDecimal(HiveDecimal.create((int)-10));
        stats1.updateDecimal(HiveDecimal.create((int)10000));
        stats1.merge(stats2);
        Assert.assertEquals((long)-10L, (long)typed.getMinimum().longValue());
        Assert.assertEquals((long)10000L, (long)typed.getMaximum().longValue());
    }
}

