/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.vector.expressions;

import org.apache.hadoop.hive.common.type.HiveDecimal;
import org.apache.hadoop.hive.ql.exec.vector.BytesColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.DecimalColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.DoubleColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.LongColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.VectorizedRowBatch;
import org.apache.hadoop.hive.ql.exec.vector.expressions.CastBooleanToStringViaLongToString;
import org.apache.hadoop.hive.ql.exec.vector.expressions.CastDecimalToBoolean;
import org.apache.hadoop.hive.ql.exec.vector.expressions.CastDecimalToDouble;
import org.apache.hadoop.hive.ql.exec.vector.expressions.CastDecimalToLong;
import org.apache.hadoop.hive.ql.exec.vector.expressions.CastDecimalToString;
import org.apache.hadoop.hive.ql.exec.vector.expressions.CastDecimalToTimestamp;
import org.apache.hadoop.hive.ql.exec.vector.expressions.CastDoubleToDecimal;
import org.apache.hadoop.hive.ql.exec.vector.expressions.CastLongToDecimal;
import org.apache.hadoop.hive.ql.exec.vector.expressions.CastLongToString;
import org.apache.hadoop.hive.ql.exec.vector.expressions.CastStringToDecimal;
import org.apache.hadoop.hive.ql.exec.vector.expressions.CastTimestampToDecimal;
import org.apache.hadoop.hive.ql.exec.vector.expressions.StringExpr;
import org.apache.hadoop.hive.ql.exec.vector.expressions.TestVectorMathFunctions;
import org.apache.hadoop.hive.ql.exec.vector.expressions.gen.CastDoubleToBooleanViaDoubleToLong;
import org.apache.hadoop.hive.ql.exec.vector.expressions.gen.CastDoubleToLong;
import org.apache.hadoop.hive.ql.exec.vector.expressions.gen.CastDoubleToTimestampViaDoubleToLong;
import org.apache.hadoop.hive.ql.exec.vector.expressions.gen.CastLongToBooleanViaLongToLong;
import org.apache.hadoop.hive.ql.exec.vector.expressions.gen.CastLongToDouble;
import org.apache.hadoop.hive.ql.exec.vector.expressions.gen.CastLongToTimestampViaLongToLong;
import org.apache.hadoop.hive.ql.exec.vector.expressions.gen.CastTimestampToDoubleViaLongToDouble;
import org.apache.hadoop.hive.ql.exec.vector.expressions.gen.CastTimestampToLongViaLongToLong;
import org.junit.Assert;
import org.junit.Test;

public class TestVectorTypeCasts {
    private static final long NANOS_PER_SECOND = 1000000000L;
    private static final long MICROS_PER_SECOND = 1000000L;

    @Test
    public void testVectorCastLongToDouble() {
        VectorizedRowBatch b = TestVectorMathFunctions.getVectorizedRowBatchLongInDoubleOut();
        DoubleColumnVector resultV = (DoubleColumnVector)b.cols[1];
        b.cols[0].noNulls = true;
        CastLongToDouble expr = new CastLongToDouble(0, 1);
        expr.evaluate(b);
        junit.framework.Assert.assertEquals((Object)2.0, (Object)resultV.vector[4]);
    }

    @Test
    public void testVectorCastDoubleToLong() {
        VectorizedRowBatch b = TestVectorMathFunctions.getVectorizedRowBatchDoubleInLongOut();
        LongColumnVector resultV = (LongColumnVector)b.cols[1];
        b.cols[0].noNulls = true;
        CastDoubleToLong expr = new CastDoubleToLong(0, 1);
        expr.evaluate(b);
        junit.framework.Assert.assertEquals((long)1L, (long)resultV.vector[6]);
    }

    @Test
    public void testCastDoubleToBoolean() {
        VectorizedRowBatch b = TestVectorMathFunctions.getVectorizedRowBatchDoubleInLongOut();
        LongColumnVector resultV = (LongColumnVector)b.cols[1];
        b.cols[0].noNulls = true;
        CastDoubleToBooleanViaDoubleToLong expr = new CastDoubleToBooleanViaDoubleToLong(0, 1);
        expr.evaluate(b);
        junit.framework.Assert.assertEquals((long)0L, (long)resultV.vector[3]);
        junit.framework.Assert.assertEquals((long)1L, (long)resultV.vector[4]);
    }

    @Test
    public void testCastDoubleToTimestamp() {
        VectorizedRowBatch b = TestVectorMathFunctions.getVectorizedRowBatchDoubleInLongOut();
        LongColumnVector resultV = (LongColumnVector)b.cols[1];
        b.cols[0].noNulls = true;
        CastDoubleToTimestampViaDoubleToLong expr = new CastDoubleToTimestampViaDoubleToLong(0, 1);
        expr.evaluate(b);
        junit.framework.Assert.assertEquals((long)0L, (long)resultV.vector[3]);
        junit.framework.Assert.assertEquals((long)500000000L, (long)resultV.vector[4]);
    }

    @Test
    public void testCastLongToBoolean() {
        VectorizedRowBatch b = TestVectorMathFunctions.getVectorizedRowBatchLongInLongOut();
        LongColumnVector inV = (LongColumnVector)b.cols[0];
        inV.vector[0] = 0L;
        LongColumnVector resultV = (LongColumnVector)b.cols[1];
        b.cols[0].noNulls = true;
        CastLongToBooleanViaLongToLong expr = new CastLongToBooleanViaLongToLong(0, 1);
        expr.evaluate(b);
        junit.framework.Assert.assertEquals((long)0L, (long)resultV.vector[0]);
        junit.framework.Assert.assertEquals((long)1L, (long)resultV.vector[1]);
    }

    @Test
    public void testCastLongToTimestamp() {
        VectorizedRowBatch b = TestVectorMathFunctions.getVectorizedRowBatchLongInLongOut();
        LongColumnVector resultV = (LongColumnVector)b.cols[1];
        b.cols[0].noNulls = true;
        CastLongToTimestampViaLongToLong expr = new CastLongToTimestampViaLongToLong(0, 1);
        expr.evaluate(b);
        junit.framework.Assert.assertEquals((long)-2000000L, (long)resultV.vector[0]);
        junit.framework.Assert.assertEquals((long)2000000L, (long)resultV.vector[1]);
    }

    @Test
    public void testCastTimestampToLong() {
        VectorizedRowBatch b = TestVectorMathFunctions.getVectorizedRowBatchLongInLongOut();
        LongColumnVector inV = (LongColumnVector)b.cols[0];
        inV.vector[0] = 1000000000L;
        LongColumnVector resultV = (LongColumnVector)b.cols[1];
        b.cols[0].noNulls = true;
        CastTimestampToLongViaLongToLong expr = new CastTimestampToLongViaLongToLong(0, 1);
        expr.evaluate(b);
        junit.framework.Assert.assertEquals((long)1L, (long)resultV.vector[0]);
    }

    @Test
    public void testCastTimestampToDouble() {
        VectorizedRowBatch b = TestVectorMathFunctions.getVectorizedRowBatchLongInDoubleOut();
        LongColumnVector inV = (LongColumnVector)b.cols[0];
        DoubleColumnVector resultV = (DoubleColumnVector)b.cols[1];
        b.cols[0].noNulls = true;
        CastTimestampToDoubleViaLongToDouble expr = new CastTimestampToDoubleViaLongToDouble(0, 1);
        expr.evaluate(b);
        junit.framework.Assert.assertEquals((Object)-1.0E-9, (Object)resultV.vector[1]);
        junit.framework.Assert.assertEquals((Object)1.0E-9, (Object)resultV.vector[3]);
    }

    public byte[] toBytes(String s) {
        byte[] b = null;
        try {
            b = s.getBytes("UTF-8");
        }
        catch (Exception e) {
            throw new RuntimeException("Could not convert string to UTF-8 byte array.");
        }
        return b;
    }

    @Test
    public void testCastLongToString() {
        VectorizedRowBatch b = TestVectorMathFunctions.getBatchForStringMath();
        BytesColumnVector resultV = (BytesColumnVector)b.cols[2];
        b.cols[1].noNulls = true;
        CastLongToString expr = new CastLongToString(1, 2);
        expr.evaluate(b);
        byte[] num255 = this.toBytes("255");
        junit.framework.Assert.assertEquals((int)0, (int)StringExpr.compare((byte[])num255, (int)0, (int)num255.length, (byte[])resultV.vector[1], (int)resultV.start[1], (int)resultV.length[1]));
    }

    @Test
    public void testCastBooleanToString() {
        byte[] t = this.toBytes("TRUE");
        byte[] f = this.toBytes("FALSE");
        VectorizedRowBatch b = TestVectorMathFunctions.getBatchForStringMath();
        LongColumnVector inV = (LongColumnVector)b.cols[1];
        BytesColumnVector resultV = (BytesColumnVector)b.cols[2];
        inV.vector[1] = 1L;
        CastBooleanToStringViaLongToString expr = new CastBooleanToStringViaLongToString(1, 2);
        expr.evaluate(b);
        junit.framework.Assert.assertEquals((int)0, (int)StringExpr.compare((byte[])f, (int)0, (int)f.length, (byte[])resultV.vector[0], (int)resultV.start[0], (int)resultV.length[0]));
        junit.framework.Assert.assertEquals((int)0, (int)StringExpr.compare((byte[])t, (int)0, (int)t.length, (byte[])resultV.vector[1], (int)resultV.start[1], (int)resultV.length[1]));
    }

    @Test
    public void testCastDecimalToLong() {
        VectorizedRowBatch b = this.getBatchDecimalLong();
        CastDecimalToLong expr = new CastDecimalToLong(0, 1);
        expr.evaluate(b);
        LongColumnVector r = (LongColumnVector)b.cols[1];
        Assert.assertEquals((long)1L, (long)r.vector[0]);
        Assert.assertEquals((long)-2L, (long)r.vector[1]);
        Assert.assertEquals((long)9999999999999999L, (long)r.vector[2]);
        b = this.getBatchDecimalLong();
        b.cols[0].noNulls = false;
        b.cols[0].isNull[1] = true;
        expr.evaluate(b);
        r = (LongColumnVector)b.cols[1];
        Assert.assertFalse((boolean)r.noNulls);
        Assert.assertTrue((boolean)r.isNull[1]);
        Assert.assertFalse((boolean)r.isNull[0]);
        Assert.assertEquals((long)1L, (long)r.vector[0]);
        b = this.getBatchDecimalLong();
        b.cols[0].isRepeating = true;
        expr.evaluate(b);
        r = (LongColumnVector)b.cols[1];
        Assert.assertTrue((boolean)r.isRepeating);
        Assert.assertEquals((long)1L, (long)r.vector[0]);
        b = this.getBatchDecimalLong();
        b.cols[0].isRepeating = true;
        b.cols[0].noNulls = false;
        b.cols[0].isNull[0] = true;
        expr.evaluate(b);
        r = (LongColumnVector)b.cols[1];
        Assert.assertTrue((boolean)r.isRepeating);
        Assert.assertTrue((boolean)r.isNull[0]);
    }

    @Test
    public void testCastDecimalToBoolean() {
        VectorizedRowBatch b = this.getBatchDecimalLong();
        CastDecimalToBoolean expr = new CastDecimalToBoolean(0, 1);
        DecimalColumnVector in = (DecimalColumnVector)b.cols[0];
        in.vector[1].set(HiveDecimal.create((int)0));
        expr.evaluate(b);
        LongColumnVector r = (LongColumnVector)b.cols[1];
        Assert.assertEquals((long)1L, (long)r.vector[0]);
        Assert.assertEquals((long)0L, (long)r.vector[1]);
        Assert.assertEquals((long)1L, (long)r.vector[2]);
    }

    private VectorizedRowBatch getBatchDecimalLong() {
        VectorizedRowBatch b = new VectorizedRowBatch(2);
        int scale = 2;
        DecimalColumnVector dv = new DecimalColumnVector(18, scale);
        b.cols[0] = dv;
        b.cols[1] = new LongColumnVector();
        b.size = 3;
        dv.vector[0].set(HiveDecimal.create((String)"1.1").setScale(scale));
        dv.vector[1].set(HiveDecimal.create((String)"-2.2").setScale(scale));
        dv.vector[2].set(HiveDecimal.create((String)"9999999999999999.00").setScale(scale));
        return b;
    }

    @Test
    public void testCastDecimalToDouble() {
        double eps = 1.0E-6;
        VectorizedRowBatch b = this.getBatchDecimalDouble();
        CastDecimalToDouble expr = new CastDecimalToDouble(0, 1);
        expr.evaluate(b);
        DoubleColumnVector r = (DoubleColumnVector)b.cols[1];
        Assert.assertEquals((double)1.1, (double)r.vector[0], (double)1.0E-6);
        Assert.assertEquals((double)-2.2, (double)r.vector[1], (double)1.0E-6);
        Assert.assertEquals((double)1.0E16, (double)r.vector[2], (double)1.0E-6);
        b = this.getBatchDecimalDouble();
        b.cols[0].noNulls = false;
        b.cols[0].isNull[1] = true;
        expr.evaluate(b);
        r = (DoubleColumnVector)b.cols[1];
        Assert.assertFalse((boolean)r.noNulls);
        Assert.assertTrue((boolean)r.isNull[1]);
        Assert.assertFalse((boolean)r.isNull[0]);
        Assert.assertEquals((double)1.1, (double)r.vector[0], (double)1.0E-6);
        b = this.getBatchDecimalDouble();
        b.cols[0].isRepeating = true;
        expr.evaluate(b);
        r = (DoubleColumnVector)b.cols[1];
        Assert.assertTrue((boolean)r.isRepeating);
        Assert.assertEquals((double)1.1, (double)r.vector[0], (double)1.0E-6);
        b = this.getBatchDecimalDouble();
        b.cols[0].isRepeating = true;
        b.cols[0].noNulls = false;
        b.cols[0].isNull[0] = true;
        expr.evaluate(b);
        r = (DoubleColumnVector)b.cols[1];
        Assert.assertTrue((boolean)r.isRepeating);
        Assert.assertTrue((boolean)r.isNull[0]);
    }

    private VectorizedRowBatch getBatchDecimalDouble() {
        VectorizedRowBatch b = new VectorizedRowBatch(2);
        int scale = 2;
        DecimalColumnVector dv = new DecimalColumnVector(18, scale);
        b.cols[0] = dv;
        b.cols[1] = new DoubleColumnVector();
        b.size = 3;
        dv.vector[0].set(HiveDecimal.create((String)"1.1").setScale(scale));
        dv.vector[1].set(HiveDecimal.create((String)"-2.2").setScale(scale));
        dv.vector[2].set(HiveDecimal.create((String)"9999999999999999.00").setScale(scale));
        return b;
    }

    @Test
    public void testCastDecimalToString() {
        VectorizedRowBatch b = this.getBatchDecimalString();
        CastDecimalToString expr = new CastDecimalToString(0, 1);
        expr.evaluate(b);
        BytesColumnVector r = (BytesColumnVector)b.cols[1];
        byte[] v = this.toBytes("1.1");
        Assert.assertTrue((String)(Integer.valueOf(v.length).toString() + " " + r.length[0]), (v.length == r.length[0] ? 1 : 0) != 0);
        junit.framework.Assert.assertEquals((int)0, (int)StringExpr.compare((byte[])v, (int)0, (int)v.length, (byte[])r.vector[0], (int)r.start[0], (int)r.length[0]));
        v = this.toBytes("-2.2");
        junit.framework.Assert.assertEquals((int)0, (int)StringExpr.compare((byte[])v, (int)0, (int)v.length, (byte[])r.vector[1], (int)r.start[1], (int)r.length[1]));
        v = this.toBytes("9999999999999999");
        junit.framework.Assert.assertEquals((int)0, (int)StringExpr.compare((byte[])v, (int)0, (int)v.length, (byte[])r.vector[2], (int)r.start[2], (int)r.length[2]));
    }

    private VectorizedRowBatch getBatchDecimalString() {
        VectorizedRowBatch b = new VectorizedRowBatch(2);
        int scale = 2;
        DecimalColumnVector dv = new DecimalColumnVector(18, scale);
        b.cols[0] = dv;
        b.cols[1] = new BytesColumnVector();
        b.size = 3;
        dv.vector[0].set(HiveDecimal.create((String)"1.1").setScale(scale));
        dv.vector[1].set(HiveDecimal.create((String)"-2.2").setScale(scale));
        dv.vector[2].set(HiveDecimal.create((String)"9999999999999999.00").setScale(scale));
        return b;
    }

    @Test
    public void testCastDecimalToTimestamp() {
        VectorizedRowBatch b = this.getBatchDecimalLong2();
        CastDecimalToTimestamp expr = new CastDecimalToTimestamp(0, 1);
        expr.evaluate(b);
        LongColumnVector r = (LongColumnVector)b.cols[1];
        Assert.assertEquals((long)1111111111L, (long)r.vector[0]);
        Assert.assertEquals((long)-2222222222L, (long)r.vector[1]);
        Assert.assertEquals((long)31536000999999999L, (long)r.vector[2]);
    }

    private VectorizedRowBatch getBatchDecimalLong2() {
        VectorizedRowBatch b = new VectorizedRowBatch(2);
        int scale = 9;
        DecimalColumnVector dv = new DecimalColumnVector(18, scale);
        b.cols[0] = dv;
        b.cols[1] = new LongColumnVector();
        b.size = 3;
        dv.vector[0].set(HiveDecimal.create((String)"1.111111111").setScale(scale));
        dv.vector[1].set(HiveDecimal.create((String)"-2.222222222").setScale(scale));
        dv.vector[2].set(HiveDecimal.create((String)"31536000.999999999").setScale(scale));
        return b;
    }

    @Test
    public void testCastLongToDecimal() {
        VectorizedRowBatch b = this.getBatchLongDecimal();
        CastLongToDecimal expr = new CastLongToDecimal(0, 1);
        expr.evaluate(b);
        DecimalColumnVector r = (DecimalColumnVector)b.cols[1];
        Assert.assertTrue((boolean)r.vector[0].getHiveDecimal().equals((Object)HiveDecimal.create((String)"0")));
        Assert.assertTrue((boolean)r.vector[1].getHiveDecimal().equals((Object)HiveDecimal.create((String)"-1")));
        Assert.assertTrue((boolean)r.vector[2].getHiveDecimal().equals((Object)HiveDecimal.create((String)"99999999999999")));
    }

    private VectorizedRowBatch getBatchLongDecimal() {
        VectorizedRowBatch b = new VectorizedRowBatch(2);
        LongColumnVector lv = new LongColumnVector();
        b.cols[0] = lv;
        b.cols[1] = new DecimalColumnVector(18, 2);
        lv.vector[0] = 0L;
        lv.vector[1] = -1L;
        lv.vector[2] = 99999999999999L;
        return b;
    }

    @Test
    public void testCastDoubleToDecimal() {
        VectorizedRowBatch b = this.getBatchDoubleDecimal();
        CastDoubleToDecimal expr = new CastDoubleToDecimal(0, 1);
        expr.evaluate(b);
        DecimalColumnVector r = (DecimalColumnVector)b.cols[1];
        Assert.assertTrue((boolean)r.vector[0].getHiveDecimal().equals((Object)HiveDecimal.create((String)"0.0")));
        Assert.assertTrue((boolean)r.vector[1].getHiveDecimal().equals((Object)HiveDecimal.create((String)"-1.0")));
        Assert.assertTrue((boolean)r.vector[2].getHiveDecimal().equals((Object)HiveDecimal.create((String)"99999999999999")));
    }

    private VectorizedRowBatch getBatchDoubleDecimal() {
        VectorizedRowBatch b = new VectorizedRowBatch(2);
        int scale = 2;
        DoubleColumnVector dv = new DoubleColumnVector();
        b.cols[0] = dv;
        b.cols[1] = new DecimalColumnVector(18, scale);
        b.size = 3;
        dv.vector[0] = 0.0;
        dv.vector[1] = -1.0;
        dv.vector[2] = 9.9999999999999E13;
        return b;
    }

    @Test
    public void testCastStringToDecimal() {
        VectorizedRowBatch b = this.getBatchStringDecimal();
        CastStringToDecimal expr = new CastStringToDecimal(0, 1);
        expr.evaluate(b);
        DecimalColumnVector r = (DecimalColumnVector)b.cols[1];
        Assert.assertTrue((boolean)r.vector[0].getHiveDecimal().equals((Object)HiveDecimal.create((String)"1.10")));
        Assert.assertTrue((boolean)r.vector[1].getHiveDecimal().equals((Object)HiveDecimal.create((String)"-2.20")));
        Assert.assertTrue((boolean)r.vector[2].getHiveDecimal().equals((Object)HiveDecimal.create((String)"99999999999999.0")));
    }

    private VectorizedRowBatch getBatchStringDecimal() {
        VectorizedRowBatch b = new VectorizedRowBatch(2);
        BytesColumnVector bv = new BytesColumnVector();
        b.cols[0] = bv;
        b.cols[1] = new DecimalColumnVector(18, 2);
        bv.initBuffer();
        byte[] x0 = this.toBytes("1.10");
        byte[] x1 = this.toBytes("-2.20");
        byte[] x2 = this.toBytes("99999999999999.0");
        bv.setVal(0, x0, 0, x0.length);
        bv.setVal(1, x1, 0, x1.length);
        bv.setVal(2, x2, 0, x2.length);
        return b;
    }

    @Test
    public void testCastTimestampToDecimal() {
        VectorizedRowBatch b = this.getBatchLongDecimal();
        CastTimestampToDecimal expr = new CastTimestampToDecimal(0, 1);
        LongColumnVector inL = (LongColumnVector)b.cols[0];
        inL.vector[1] = -1990000000L;
        expr.evaluate(b);
        DecimalColumnVector r = (DecimalColumnVector)b.cols[1];
        Assert.assertTrue((boolean)r.vector[0].getHiveDecimal().equals((Object)HiveDecimal.create((String)"0.00")));
        Assert.assertTrue((boolean)r.vector[1].getHiveDecimal().equals((Object)HiveDecimal.create((String)"-1.99")));
        Assert.assertTrue((boolean)r.vector[2].getHiveDecimal().equals((Object)HiveDecimal.create((String)"100000.00")));
        b = this.getBatchLongDecimalPrec5Scale2();
        expr.evaluate(b);
        r = (DecimalColumnVector)b.cols[1];
        Assert.assertFalse((boolean)r.noNulls);
        Assert.assertFalse((boolean)r.isNull[0]);
        Assert.assertFalse((boolean)r.isNull[1]);
        Assert.assertTrue((boolean)r.isNull[2]);
    }

    private VectorizedRowBatch getBatchLongDecimalPrec5Scale2() {
        VectorizedRowBatch b = new VectorizedRowBatch(2);
        LongColumnVector lv = new LongColumnVector();
        b.cols[0] = lv;
        b.cols[1] = new DecimalColumnVector(5, 2);
        lv.vector[0] = 0L;
        lv.vector[1] = -1L;
        lv.vector[2] = 99999999999999L;
        return b;
    }

    private VectorizedRowBatch getBatchDecimalDecimal() {
        VectorizedRowBatch b = new VectorizedRowBatch(2);
        DecimalColumnVector v0 = new DecimalColumnVector(18, 4);
        b.cols[0] = v0;
        DecimalColumnVector v1 = new DecimalColumnVector(5, 2);
        b.cols[1] = v1;
        v0.vector[0].set(HiveDecimal.create((String)"10.0001"));
        v0.vector[1].set(HiveDecimal.create((String)"-9999999.9999"));
        v1.vector[0].set(HiveDecimal.create((String)"100.01"));
        v1.vector[1].set(HiveDecimal.create((String)"-200.02"));
        b.size = 2;
        return b;
    }
}

