/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.io.parquet.serde;

import java.sql.Timestamp;
import java.util.Calendar;
import java.util.TimeZone;
import junit.framework.Assert;
import junit.framework.TestCase;
import org.apache.hadoop.hive.ql.io.parquet.timestamp.NanoTime;
import org.apache.hadoop.hive.ql.io.parquet.timestamp.NanoTimeUtils;

public class TestParquetTimestampUtils
extends TestCase {
    public void testJulianDay() {
        Calendar cal = Calendar.getInstance();
        cal.set(1, 1968);
        cal.set(2, 4);
        cal.set(5, 23);
        cal.set(11, 0);
        cal.setTimeZone(TimeZone.getTimeZone("GMT"));
        Timestamp ts = new Timestamp(cal.getTimeInMillis());
        NanoTime nt = NanoTimeUtils.getNanoTime((Timestamp)ts);
        Assert.assertEquals((int)nt.getJulianDay(), (int)2440000);
        Timestamp tsFetched = NanoTimeUtils.getTimestamp((NanoTime)nt);
        Assert.assertEquals((Object)tsFetched, (Object)ts);
        Calendar cal1 = Calendar.getInstance();
        cal1.set(1, 2005);
        cal1.set(2, 0);
        cal1.set(5, 1);
        cal1.set(11, 0);
        cal1.setTimeZone(TimeZone.getTimeZone("GMT"));
        Timestamp ts1 = new Timestamp(cal1.getTimeInMillis());
        NanoTime nt1 = NanoTimeUtils.getNanoTime((Timestamp)ts1);
        Timestamp ts1Fetched = NanoTimeUtils.getTimestamp((NanoTime)nt1);
        Assert.assertEquals((Object)ts1Fetched, (Object)ts1);
        Calendar cal2 = Calendar.getInstance();
        cal2.set(1, 2005);
        cal2.set(2, 0);
        cal2.set(5, 31);
        cal2.set(11, 0);
        cal2.setTimeZone(TimeZone.getTimeZone("UTC"));
        Timestamp ts2 = new Timestamp(cal2.getTimeInMillis());
        NanoTime nt2 = NanoTimeUtils.getNanoTime((Timestamp)ts2);
        Timestamp ts2Fetched = NanoTimeUtils.getTimestamp((NanoTime)nt2);
        Assert.assertEquals((Object)ts2Fetched, (Object)ts2);
        Assert.assertEquals((int)(nt2.getJulianDay() - nt1.getJulianDay()), (int)30);
    }

    public void testNanos() {
        Calendar cal = Calendar.getInstance();
        cal.set(1, 1968);
        cal.set(2, 4);
        cal.set(5, 23);
        cal.set(11, 1);
        cal.set(12, 1);
        cal.set(13, 1);
        cal.setTimeZone(TimeZone.getTimeZone("GMT"));
        Timestamp ts = new Timestamp(cal.getTimeInMillis());
        ts.setNanos(1);
        NanoTime nt = NanoTimeUtils.getNanoTime((Timestamp)ts);
        Assert.assertEquals((long)nt.getTimeOfDayNanos(), (long)3661000000001L);
        cal = Calendar.getInstance();
        cal.set(1, 1968);
        cal.set(2, 4);
        cal.set(5, 23);
        cal.set(11, 23);
        cal.set(12, 59);
        cal.set(13, 59);
        cal.setTimeZone(TimeZone.getTimeZone("GMT"));
        ts = new Timestamp(cal.getTimeInMillis());
        ts.setNanos(999999999);
        nt = NanoTimeUtils.getNanoTime((Timestamp)ts);
        Assert.assertEquals((long)nt.getTimeOfDayNanos(), (long)86399999999999L);
        Calendar cal2 = Calendar.getInstance();
        cal2.set(1, 1968);
        cal2.set(2, 4);
        cal2.set(5, 23);
        cal2.set(11, 0);
        cal2.set(12, 10);
        cal2.set(13, 0);
        cal2.setTimeZone(TimeZone.getTimeZone("GMT"));
        Timestamp ts2 = new Timestamp(cal2.getTimeInMillis());
        ts2.setNanos(10);
        Calendar cal1 = Calendar.getInstance();
        cal1.set(1, 1968);
        cal1.set(2, 4);
        cal1.set(5, 23);
        cal1.set(11, 0);
        cal1.set(12, 0);
        cal1.set(13, 0);
        cal1.setTimeZone(TimeZone.getTimeZone("GMT"));
        Timestamp ts1 = new Timestamp(cal1.getTimeInMillis());
        ts1.setNanos(1);
        NanoTime n2 = NanoTimeUtils.getNanoTime((Timestamp)ts2);
        NanoTime n1 = NanoTimeUtils.getNanoTime((Timestamp)ts1);
        Assert.assertEquals((long)(n2.getTimeOfDayNanos() - n1.getTimeOfDayNanos()), (long)600000000009L);
    }

    public void testTimezone() {
        Calendar cal = Calendar.getInstance();
        cal.set(1, 1968);
        cal.set(2, 4);
        cal.set(5, 23);
        cal.set(11, 17);
        cal.set(12, 1);
        cal.set(13, 1);
        cal.setTimeZone(TimeZone.getTimeZone("US/Pacific"));
        Timestamp ts = new Timestamp(cal.getTimeInMillis());
        ts.setNanos(1);
        NanoTime nt = NanoTimeUtils.getNanoTime((Timestamp)ts);
        long timeOfDayNanos = nt.getTimeOfDayNanos();
        Assert.assertTrue((timeOfDayNanos == 61000000001L || timeOfDayNanos == 3661000000001L ? 1 : 0) != 0);
        Assert.assertEquals((int)nt.getJulianDay(), (int)2440001);
    }

    public void testValues() {
        this.verifyTsString("2011-01-01 01:01:01.111111111");
        this.verifyTsString("2012-02-02 02:02:02.222222222");
        this.verifyTsString("2013-03-03 03:03:03.333333333");
        this.verifyTsString("2014-04-04 04:04:04.444444444");
        this.verifyTsString("2015-05-05 05:05:05.555555555");
        this.verifyTsString("2016-06-06 06:06:06.666666666");
        this.verifyTsString("2017-07-07 07:07:07.777777777");
        this.verifyTsString("2018-08-08 08:08:08.888888888");
        this.verifyTsString("2019-09-09 09:09:09.999999999");
        this.verifyTsString("2020-10-10 10:10:10.101010101");
        this.verifyTsString("2021-11-11 11:11:11.111111111");
        this.verifyTsString("2022-12-12 12:12:12.121212121");
        this.verifyTsString("2023-01-02 13:13:13.131313131");
        this.verifyTsString("2024-02-02 14:14:14.141414141");
        this.verifyTsString("2025-03-03 15:15:15.151515151");
        this.verifyTsString("2026-04-04 16:16:16.161616161");
        this.verifyTsString("2027-05-05 17:17:17.171717171");
        this.verifyTsString("2028-06-06 18:18:18.181818181");
        this.verifyTsString("2029-07-07 19:19:19.191919191");
        this.verifyTsString("2030-08-08 20:20:20.202020202");
        this.verifyTsString("2031-09-09 21:21:21.212121212");
        this.verifyTsString("9999-09-09 09:09:09.999999999");
        this.verifyTsString("0001-01-01 00:00:00.0");
    }

    private void verifyTsString(String tsString) {
        Timestamp ts = Timestamp.valueOf(tsString);
        NanoTime nt = NanoTimeUtils.getNanoTime((Timestamp)ts);
        Timestamp tsFetched = NanoTimeUtils.getTimestamp((NanoTime)nt);
        Assert.assertEquals((String)tsString, (String)tsFetched.toString());
    }
}

