/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.io.orc;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.sql.Date;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Properties;
import java.util.TimeZone;
import java.util.TreeSet;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.BlockLocation;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FSInputStream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.hive.common.type.HiveDecimal;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.exec.FileSinkOperator;
import org.apache.hadoop.hive.ql.exec.Utilities;
import org.apache.hadoop.hive.ql.exec.mr.ExecMapper;
import org.apache.hadoop.hive.ql.exec.vector.BytesColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.DecimalColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.DoubleColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.LongColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.VectorizedRowBatch;
import org.apache.hadoop.hive.ql.io.AcidOutputFormat;
import org.apache.hadoop.hive.ql.io.CombineHiveInputFormat;
import org.apache.hadoop.hive.ql.io.HiveInputFormat;
import org.apache.hadoop.hive.ql.io.InputFormatChecker;
import org.apache.hadoop.hive.ql.io.orc.OrcFile;
import org.apache.hadoop.hive.ql.io.orc.OrcInputFormat;
import org.apache.hadoop.hive.ql.io.orc.OrcOutputFormat;
import org.apache.hadoop.hive.ql.io.orc.OrcProto;
import org.apache.hadoop.hive.ql.io.orc.OrcRecordUpdater;
import org.apache.hadoop.hive.ql.io.orc.OrcSerde;
import org.apache.hadoop.hive.ql.io.orc.OrcSplit;
import org.apache.hadoop.hive.ql.io.orc.OrcStruct;
import org.apache.hadoop.hive.ql.io.orc.Reader;
import org.apache.hadoop.hive.ql.io.orc.TestOrcFile;
import org.apache.hadoop.hive.ql.io.orc.Writer;
import org.apache.hadoop.hive.ql.io.orc.WriterImpl;
import org.apache.hadoop.hive.ql.io.sarg.PredicateLeaf;
import org.apache.hadoop.hive.ql.io.sarg.SearchArgument;
import org.apache.hadoop.hive.ql.io.sarg.SearchArgumentFactory;
import org.apache.hadoop.hive.ql.plan.MapWork;
import org.apache.hadoop.hive.ql.plan.PartitionDesc;
import org.apache.hadoop.hive.ql.plan.TableDesc;
import org.apache.hadoop.hive.serde2.ColumnProjectionUtils;
import org.apache.hadoop.hive.serde2.Deserializer;
import org.apache.hadoop.hive.serde2.SerDeUtils;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspectorFactory;
import org.apache.hadoop.hive.serde2.objectinspector.StructField;
import org.apache.hadoop.hive.serde2.objectinspector.StructObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.IntObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.PrimitiveObjectInspectorFactory;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.StringObjectInspector;
import org.apache.hadoop.hive.shims.CombineHiveKey;
import org.apache.hadoop.io.DataOutputBuffer;
import org.apache.hadoop.io.IntWritable;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.mapred.FileInputFormat;
import org.apache.hadoop.mapred.InputSplit;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.RecordReader;
import org.apache.hadoop.mapred.RecordWriter;
import org.apache.hadoop.mapred.Reporter;
import org.apache.hadoop.util.Progressable;
import org.apache.hadoop.util.StringUtils;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TestName;

public class TestInputOutputFormat {
    Path workDir = new Path(System.getProperty("test.tmp.dir", "target/tmp"));
    static final int MILLIS_IN_DAY = 86400000;
    private static final SimpleDateFormat DATE_FORMAT = new SimpleDateFormat("yyyy/MM/dd");
    private static final SimpleDateFormat TIME_FORMAT = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss.SSS");
    private static final TimeZone LOCAL_TIMEZONE = TimeZone.getDefault();
    @Rule
    public TestName testCaseName = new TestName();
    JobConf conf;
    FileSystem fs;
    Path testFilePath;

    @Before
    public void openFileSystem() throws Exception {
        this.conf = new JobConf();
        this.fs = FileSystem.getLocal((Configuration)this.conf);
        this.testFilePath = new Path(this.workDir, "TestInputOutputFormat." + this.testCaseName.getMethodName() + ".orc");
        this.fs.delete(this.testFilePath, false);
    }

    @Test
    public void testOverlap() throws Exception {
        Assert.assertEquals((long)0L, (long)OrcInputFormat.SplitGenerator.getOverlap((long)100L, (long)100L, (long)200L, (long)100L));
        Assert.assertEquals((long)0L, (long)OrcInputFormat.SplitGenerator.getOverlap((long)0L, (long)1000L, (long)2000L, (long)100L));
        Assert.assertEquals((long)100L, (long)OrcInputFormat.SplitGenerator.getOverlap((long)1000L, (long)1000L, (long)1500L, (long)100L));
        Assert.assertEquals((long)250L, (long)OrcInputFormat.SplitGenerator.getOverlap((long)1000L, (long)250L, (long)500L, (long)2000L));
        Assert.assertEquals((long)100L, (long)OrcInputFormat.SplitGenerator.getOverlap((long)1000L, (long)1000L, (long)1900L, (long)1000L));
        Assert.assertEquals((long)500L, (long)OrcInputFormat.SplitGenerator.getOverlap((long)2000L, (long)1000L, (long)2500L, (long)2000L));
    }

    @Test
    public void testGetInputPaths() throws Exception {
        this.conf.set("mapred.input.dir", "a,b,c");
        Assert.assertArrayEquals((Object[])new Path[]{new Path("a"), new Path("b"), new Path("c")}, (Object[])OrcInputFormat.getInputPaths((Configuration)this.conf));
        this.conf.set("mapred.input.dir", "/a/b/c/d/e");
        Assert.assertArrayEquals((Object[])new Path[]{new Path("/a/b/c/d/e")}, (Object[])OrcInputFormat.getInputPaths((Configuration)this.conf));
        this.conf.set("mapred.input.dir", "/a/b/c\\,d,/e/f\\,g/h");
        Assert.assertArrayEquals((Object[])new Path[]{new Path("/a/b/c,d"), new Path("/e/f,g/h")}, (Object[])OrcInputFormat.getInputPaths((Configuration)this.conf));
    }

    @Test
    public void testFileGenerator() throws Exception {
        TestContext context = new TestContext((Configuration)this.conf);
        MockFileSystem fs = new MockFileSystem((Configuration)this.conf, new MockFile("mock:/a/b/part-00", 1000, new byte[0], new MockBlock[0]), new MockFile("mock:/a/b/part-01", 1000, new byte[0], new MockBlock[0]), new MockFile("mock:/a/b/_part-02", 1000, new byte[0], new MockBlock[0]), new MockFile("mock:/a/b/.part-03", 1000, new byte[0], new MockBlock[0]), new MockFile("mock:/a/b/part-04", 1000, new byte[0], new MockBlock[0]));
        OrcInputFormat.FileGenerator gen = new OrcInputFormat.FileGenerator((OrcInputFormat.Context)context, (FileSystem)fs, (Path)new MockPath(fs, "mock:/a/b"));
        gen.run();
        if (context.getErrors().size() > 0) {
            for (Throwable th : context.getErrors()) {
                System.out.println(StringUtils.stringifyException((Throwable)th));
            }
            throw new IOException("Errors during file generation");
        }
        Assert.assertEquals((long)-1L, (long)context.getSchedulers());
        Assert.assertEquals((long)3L, (long)context.queue.size());
        Assert.assertEquals((Object)new Path("mock:/a/b/part-00"), (Object)((OrcInputFormat.SplitGenerator)context.queue.get(0)).getPath());
        Assert.assertEquals((Object)new Path("mock:/a/b/part-01"), (Object)((OrcInputFormat.SplitGenerator)context.queue.get(1)).getPath());
        Assert.assertEquals((Object)new Path("mock:/a/b/part-04"), (Object)((OrcInputFormat.SplitGenerator)context.queue.get(2)).getPath());
    }

    static void fill(DataOutputBuffer out, long length) throws IOException {
        int i = 0;
        while ((long)i < length) {
            out.write(0);
            ++i;
        }
    }

    static byte[] createMockOrcFile(long ... stripeLengths) throws IOException {
        OrcProto.Footer.Builder footer = OrcProto.Footer.newBuilder();
        long headerLen = 3L;
        long offset = 3L;
        DataOutputBuffer buffer = new DataOutputBuffer();
        for (long stripeLength : stripeLengths) {
            footer.addStripes(OrcProto.StripeInformation.newBuilder().setOffset(offset).setIndexLength(0L).setDataLength(stripeLength - 10L).setFooterLength(10L).setNumberOfRows(1000L));
            offset += stripeLength;
        }
        TestInputOutputFormat.fill(buffer, offset);
        footer.addTypes(OrcProto.Type.newBuilder().setKind(OrcProto.Type.Kind.STRUCT).addFieldNames("col1").addSubtypes(1));
        footer.addTypes(OrcProto.Type.newBuilder().setKind(OrcProto.Type.Kind.STRING));
        footer.setNumberOfRows((long)(1000 * stripeLengths.length)).setHeaderLength(3L).setContentLength(offset - 3L);
        footer.build().writeTo((OutputStream)buffer);
        int footerEnd = buffer.getLength();
        OrcProto.PostScript ps = OrcProto.PostScript.newBuilder().setCompression(OrcProto.CompressionKind.NONE).setFooterLength((long)footerEnd - offset).setMagic("ORC").build();
        ps.writeTo((OutputStream)buffer);
        buffer.write(buffer.getLength() - footerEnd);
        byte[] result = new byte[buffer.getLength()];
        System.arraycopy(buffer.getData(), 0, result, 0, buffer.getLength());
        return result;
    }

    @Test
    public void testAddSplit() throws Exception {
        MockFileSystem fs = new MockFileSystem((Configuration)this.conf, new MockFile("mock:/a/file", 500, TestInputOutputFormat.createMockOrcFile(197L, 300L, 600L, 200L, 200L, 100L, 100L, 100L, 100L, 100L), new MockBlock("host1-1", "host1-2", "host1-3"), new MockBlock("host2-1", "host0", "host2-3"), new MockBlock("host0", "host3-2", "host3-3"), new MockBlock("host4-1", "host4-2", "host4-3"), new MockBlock("host5-1", "host5-2", "host5-3")));
        OrcInputFormat.Context context = new OrcInputFormat.Context((Configuration)this.conf);
        OrcInputFormat.SplitGenerator splitter = new OrcInputFormat.SplitGenerator(context, (FileSystem)fs, fs.getFileStatus(new Path("/a/file")), null, true, new ArrayList(), true);
        splitter.createSplit(0L, 200L, null);
        OrcSplit result = context.getResult(-1);
        Assert.assertEquals((long)0L, (long)result.getStart());
        Assert.assertEquals((long)200L, (long)result.getLength());
        Assert.assertEquals((Object)"mock:/a/file", (Object)result.getPath().toString());
        String[] locs = result.getLocations();
        Assert.assertEquals((long)3L, (long)locs.length);
        Assert.assertEquals((Object)"host1-1", (Object)locs[0]);
        Assert.assertEquals((Object)"host1-2", (Object)locs[1]);
        Assert.assertEquals((Object)"host1-3", (Object)locs[2]);
        splitter.createSplit(500L, 600L, null);
        result = context.getResult(-1);
        locs = result.getLocations();
        Assert.assertEquals((long)3L, (long)locs.length);
        Assert.assertEquals((Object)"host2-1", (Object)locs[0]);
        Assert.assertEquals((Object)"host0", (Object)locs[1]);
        Assert.assertEquals((Object)"host2-3", (Object)locs[2]);
        splitter.createSplit(0L, 2500L, null);
        result = context.getResult(-1);
        locs = result.getLocations();
        Assert.assertEquals((long)1L, (long)locs.length);
        Assert.assertEquals((Object)"host0", (Object)locs[0]);
    }

    @Test
    public void testSplitGenerator() throws Exception {
        long[] stripeSizes = new long[]{197L, 300L, 600L, 200L, 200L, 100L, 100L, 100L, 100L, 100L};
        MockFileSystem fs = new MockFileSystem((Configuration)this.conf, new MockFile("mock:/a/file", 500, TestInputOutputFormat.createMockOrcFile(stripeSizes), new MockBlock("host1-1", "host1-2", "host1-3"), new MockBlock("host2-1", "host0", "host2-3"), new MockBlock("host0", "host3-2", "host3-3"), new MockBlock("host4-1", "host4-2", "host4-3"), new MockBlock("host5-1", "host5-2", "host5-3")));
        this.conf.setInt(OrcInputFormat.MAX_SPLIT_SIZE, 300);
        this.conf.setInt(OrcInputFormat.MIN_SPLIT_SIZE, 200);
        OrcInputFormat.Context context = new OrcInputFormat.Context((Configuration)this.conf);
        OrcInputFormat.SplitGenerator splitter = new OrcInputFormat.SplitGenerator(context, (FileSystem)fs, fs.getFileStatus(new Path("/a/file")), null, true, new ArrayList(), true);
        splitter.run();
        if (context.getErrors().size() > 0) {
            for (Throwable th : context.getErrors()) {
                System.out.println(StringUtils.stringifyException((Throwable)th));
            }
            throw new IOException("Errors during splitting");
        }
        OrcSplit result = context.getResult(0);
        Assert.assertEquals((long)3L, (long)result.getStart());
        Assert.assertEquals((long)497L, (long)result.getLength());
        result = context.getResult(1);
        Assert.assertEquals((long)500L, (long)result.getStart());
        Assert.assertEquals((long)600L, (long)result.getLength());
        result = context.getResult(2);
        Assert.assertEquals((long)1100L, (long)result.getStart());
        Assert.assertEquals((long)400L, (long)result.getLength());
        result = context.getResult(3);
        Assert.assertEquals((long)1500L, (long)result.getStart());
        Assert.assertEquals((long)300L, (long)result.getLength());
        result = context.getResult(4);
        Assert.assertEquals((long)1800L, (long)result.getStart());
        Assert.assertEquals((long)200L, (long)result.getLength());
        this.conf.setInt(OrcInputFormat.MIN_SPLIT_SIZE, 0);
        this.conf.setInt(OrcInputFormat.MAX_SPLIT_SIZE, 0);
        context = new OrcInputFormat.Context((Configuration)this.conf);
        splitter = new OrcInputFormat.SplitGenerator(context, (FileSystem)fs, fs.getFileStatus(new Path("/a/file")), null, true, new ArrayList(), true);
        splitter.run();
        if (context.getErrors().size() > 0) {
            for (Throwable th : context.getErrors()) {
                System.out.println(StringUtils.stringifyException((Throwable)th));
            }
            throw new IOException("Errors during splitting");
        }
        for (int i = 0; i < stripeSizes.length; ++i) {
            Assert.assertEquals((String)("checking stripe " + i + " size"), (long)stripeSizes[i], (long)context.getResult(i).getLength());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testInOutFormat() throws Exception {
        Properties properties = new Properties();
        Class<TestOrcFile> clazz = TestOrcFile.class;
        synchronized (TestOrcFile.class) {
            StructObjectInspector inspector = (StructObjectInspector)ObjectInspectorFactory.getReflectionObjectInspector(MyRow.class, (ObjectInspectorFactory.ObjectInspectorOptions)ObjectInspectorFactory.ObjectInspectorOptions.JAVA);
            // ** MonitorExit[var3_2] (shouldn't be in output)
            OrcSerde serde = new OrcSerde();
            OrcOutputFormat outFormat = new OrcOutputFormat();
            FileSinkOperator.RecordWriter writer = outFormat.getHiveRecordWriter(this.conf, this.testFilePath, MyRow.class, true, properties, (Progressable)Reporter.NULL);
            writer.write(serde.serialize((Object)new MyRow(1, 2), (ObjectInspector)inspector));
            writer.write(serde.serialize((Object)new MyRow(2, 2), (ObjectInspector)inspector));
            writer.write(serde.serialize((Object)new MyRow(3, 2), (ObjectInspector)inspector));
            writer.close(true);
            serde = new OrcSerde();
            properties.setProperty("columns", "x,y");
            properties.setProperty("columns.types", "int:int");
            SerDeUtils.initializeSerDe((Deserializer)serde, (Configuration)this.conf, (Properties)properties, null);
            Assert.assertEquals(OrcSerde.OrcSerdeRow.class, (Object)serde.getSerializedClass());
            inspector = (StructObjectInspector)serde.getObjectInspector();
            Assert.assertEquals((Object)"struct<x:int,y:int>", (Object)inspector.getTypeName());
            OrcInputFormat in = new OrcInputFormat();
            FileInputFormat.setInputPaths((JobConf)this.conf, (String)this.testFilePath.toString());
            InputSplit[] splits = in.getSplits(this.conf, 1);
            Assert.assertEquals((long)1L, (long)splits.length);
            ArrayList<FileStatus> fileList = new ArrayList<FileStatus>();
            Assert.assertEquals((Object)false, (Object)((InputFormatChecker)in).validateInput(this.fs, new HiveConf(), fileList));
            fileList.add(this.fs.getFileStatus(this.testFilePath));
            Assert.assertEquals((Object)true, (Object)((InputFormatChecker)in).validateInput(this.fs, new HiveConf(), fileList));
            fileList.add(this.fs.getFileStatus(this.workDir));
            Assert.assertEquals((Object)false, (Object)((InputFormatChecker)in).validateInput(this.fs, new HiveConf(), fileList));
            RecordReader reader = in.getRecordReader(splits[0], this.conf, Reporter.NULL);
            Object key = reader.createKey();
            Writable value = (Writable)reader.createValue();
            int rowNum = 0;
            List fields = inspector.getAllStructFieldRefs();
            IntObjectInspector intInspector = (IntObjectInspector)((StructField)fields.get(0)).getFieldObjectInspector();
            Assert.assertEquals((double)0.33, (double)reader.getProgress(), (double)0.01);
            while (reader.next(key, (Object)value)) {
                Assert.assertEquals((long)(++rowNum), (long)intInspector.get(inspector.getStructFieldData(serde.deserialize(value), (StructField)fields.get(0))));
                Assert.assertEquals((long)2L, (long)intInspector.get(inspector.getStructFieldData(serde.deserialize(value), (StructField)fields.get(1))));
            }
            Assert.assertEquals((long)3L, (long)rowNum);
            Assert.assertEquals((double)1.0, (double)reader.getProgress(), (double)1.0E-5);
            reader.close();
            ColumnProjectionUtils.appendReadColumns((Configuration)this.conf, Collections.singletonList(0));
            reader = in.getRecordReader(splits[0], this.conf, Reporter.NULL);
            key = reader.createKey();
            value = (Writable)reader.createValue();
            rowNum = 0;
            fields = inspector.getAllStructFieldRefs();
            while (reader.next(key, (Object)value)) {
                Assert.assertEquals((long)(++rowNum), (long)intInspector.get(inspector.getStructFieldData((Object)value, (StructField)fields.get(0))));
                Assert.assertEquals(null, (Object)inspector.getStructFieldData((Object)value, (StructField)fields.get(1)));
            }
            Assert.assertEquals((long)3L, (long)rowNum);
            reader.close();
            ColumnProjectionUtils.setReadAllColumns((Configuration)this.conf);
            reader = in.getRecordReader(splits[0], this.conf, Reporter.NULL);
            key = reader.createKey();
            value = (Writable)reader.createValue();
            rowNum = 0;
            fields = inspector.getAllStructFieldRefs();
            while (reader.next(key, (Object)value)) {
                Assert.assertEquals((long)(++rowNum), (long)intInspector.get(inspector.getStructFieldData((Object)value, (StructField)fields.get(0))));
                Assert.assertEquals((long)2L, (long)intInspector.get(inspector.getStructFieldData(serde.deserialize(value), (StructField)fields.get(1))));
            }
            Assert.assertEquals((long)3L, (long)rowNum);
            reader.close();
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testMROutput() throws Exception {
        Properties properties = new Properties();
        Class<TestOrcFile> clazz = TestOrcFile.class;
        synchronized (TestOrcFile.class) {
            StructObjectInspector inspector = (StructObjectInspector)ObjectInspectorFactory.getReflectionObjectInspector(NestedRow.class, (ObjectInspectorFactory.ObjectInspectorOptions)ObjectInspectorFactory.ObjectInspectorOptions.JAVA);
            // ** MonitorExit[var3_2] (shouldn't be in output)
            OrcSerde serde = new OrcSerde();
            OrcOutputFormat outFormat = new OrcOutputFormat();
            RecordWriter writer = outFormat.getRecordWriter(this.fs, this.conf, this.testFilePath.toString(), (Progressable)Reporter.NULL);
            writer.write((Object)NullWritable.get(), (Object)serde.serialize((Object)new NestedRow(1, 2, 3), (ObjectInspector)inspector));
            writer.write((Object)NullWritable.get(), (Object)serde.serialize((Object)new NestedRow(4, 5, 6), (ObjectInspector)inspector));
            writer.write((Object)NullWritable.get(), (Object)serde.serialize((Object)new NestedRow(7, 8, 9), (ObjectInspector)inspector));
            writer.close(Reporter.NULL);
            serde = new OrcSerde();
            properties.setProperty("columns", "z,r");
            properties.setProperty("columns.types", "int:struct<x:int,y:int>");
            SerDeUtils.initializeSerDe((Deserializer)serde, (Configuration)this.conf, (Properties)properties, null);
            inspector = (StructObjectInspector)serde.getObjectInspector();
            OrcInputFormat in = new OrcInputFormat();
            FileInputFormat.setInputPaths((JobConf)this.conf, (String)this.testFilePath.toString());
            InputSplit[] splits = in.getSplits(this.conf, 1);
            Assert.assertEquals((long)1L, (long)splits.length);
            ColumnProjectionUtils.appendReadColumns((Configuration)this.conf, Collections.singletonList(1));
            RecordReader reader = in.getRecordReader(splits[0], this.conf, Reporter.NULL);
            Object key = reader.createKey();
            Object value = reader.createValue();
            int rowNum = 0;
            List fields = inspector.getAllStructFieldRefs();
            StructObjectInspector inner = (StructObjectInspector)((StructField)fields.get(1)).getFieldObjectInspector();
            List inFields = inner.getAllStructFieldRefs();
            IntObjectInspector intInspector = (IntObjectInspector)((StructField)fields.get(0)).getFieldObjectInspector();
            while (reader.next(key, value)) {
                Assert.assertEquals(null, (Object)inspector.getStructFieldData(value, (StructField)fields.get(0)));
                Object sub = inspector.getStructFieldData(value, (StructField)fields.get(1));
                Assert.assertEquals((long)(3 * rowNum + 1), (long)intInspector.get(inner.getStructFieldData(sub, (StructField)inFields.get(0))));
                Assert.assertEquals((long)(3 * rowNum + 2), (long)intInspector.get(inner.getStructFieldData(sub, (StructField)inFields.get(1))));
                ++rowNum;
            }
            Assert.assertEquals((long)3L, (long)rowNum);
            reader.close();
            return;
        }
    }

    @Test
    public void testEmptyFile() throws Exception {
        Properties properties = new Properties();
        OrcOutputFormat outFormat = new OrcOutputFormat();
        FileSinkOperator.RecordWriter writer = outFormat.getHiveRecordWriter(this.conf, this.testFilePath, MyRow.class, true, properties, (Progressable)Reporter.NULL);
        writer.close(true);
        properties.setProperty("columns", "x,y");
        properties.setProperty("columns.types", "int:int");
        OrcSerde serde = new OrcSerde();
        SerDeUtils.initializeSerDe((Deserializer)serde, (Configuration)this.conf, (Properties)properties, null);
        OrcInputFormat in = new OrcInputFormat();
        FileInputFormat.setInputPaths((JobConf)this.conf, (String)this.testFilePath.toString());
        InputSplit[] splits = in.getSplits(this.conf, 1);
        Assert.assertTrue((1 == splits.length ? 1 : 0) != 0);
        Assert.assertEquals(null, (Object)serde.getSerDeStats());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testDefaultTypes() throws Exception {
        Properties properties = new Properties();
        Class<TestOrcFile> clazz = TestOrcFile.class;
        synchronized (TestOrcFile.class) {
            StructObjectInspector inspector = (StructObjectInspector)ObjectInspectorFactory.getReflectionObjectInspector(StringRow.class, (ObjectInspectorFactory.ObjectInspectorOptions)ObjectInspectorFactory.ObjectInspectorOptions.JAVA);
            // ** MonitorExit[var3_2] (shouldn't be in output)
            OrcSerde serde = new OrcSerde();
            OrcOutputFormat outFormat = new OrcOutputFormat();
            FileSinkOperator.RecordWriter writer = outFormat.getHiveRecordWriter(this.conf, this.testFilePath, StringRow.class, true, properties, (Progressable)Reporter.NULL);
            writer.write(serde.serialize((Object)new StringRow("owen"), (ObjectInspector)inspector));
            writer.write(serde.serialize((Object)new StringRow("beth"), (ObjectInspector)inspector));
            writer.write(serde.serialize((Object)new StringRow("laurel"), (ObjectInspector)inspector));
            writer.write(serde.serialize((Object)new StringRow("hazen"), (ObjectInspector)inspector));
            writer.write(serde.serialize((Object)new StringRow("colin"), (ObjectInspector)inspector));
            writer.write(serde.serialize((Object)new StringRow("miles"), (ObjectInspector)inspector));
            writer.close(true);
            serde = new OrcSerde();
            properties.setProperty("columns", "str,str2");
            SerDeUtils.initializeSerDe((Deserializer)serde, (Configuration)this.conf, (Properties)properties, null);
            inspector = (StructObjectInspector)serde.getObjectInspector();
            Assert.assertEquals((Object)"struct<str:string,str2:string>", (Object)inspector.getTypeName());
            OrcInputFormat in = new OrcInputFormat();
            FileInputFormat.setInputPaths((JobConf)this.conf, (String)this.testFilePath.toString());
            InputSplit[] splits = in.getSplits(this.conf, 1);
            Assert.assertEquals((long)1L, (long)splits.length);
            RecordReader reader = in.getRecordReader(splits[0], this.conf, Reporter.NULL);
            Object key = reader.createKey();
            Writable value = (Writable)reader.createValue();
            List fields = inspector.getAllStructFieldRefs();
            StringObjectInspector strInspector = (StringObjectInspector)((StructField)fields.get(0)).getFieldObjectInspector();
            Assert.assertEquals((Object)true, (Object)reader.next(key, (Object)value));
            Assert.assertEquals((Object)"owen", (Object)strInspector.getPrimitiveJavaObject(inspector.getStructFieldData((Object)value, (StructField)fields.get(0))));
            Assert.assertEquals((Object)true, (Object)reader.next(key, (Object)value));
            Assert.assertEquals((Object)"beth", (Object)strInspector.getPrimitiveJavaObject(inspector.getStructFieldData((Object)value, (StructField)fields.get(0))));
            Assert.assertEquals((Object)true, (Object)reader.next(key, (Object)value));
            Assert.assertEquals((Object)"laurel", (Object)strInspector.getPrimitiveJavaObject(inspector.getStructFieldData((Object)value, (StructField)fields.get(0))));
            Assert.assertEquals((Object)true, (Object)reader.next(key, (Object)value));
            Assert.assertEquals((Object)"hazen", (Object)strInspector.getPrimitiveJavaObject(inspector.getStructFieldData((Object)value, (StructField)fields.get(0))));
            Assert.assertEquals((Object)true, (Object)reader.next(key, (Object)value));
            Assert.assertEquals((Object)"colin", (Object)strInspector.getPrimitiveJavaObject(inspector.getStructFieldData((Object)value, (StructField)fields.get(0))));
            Assert.assertEquals((Object)true, (Object)reader.next(key, (Object)value));
            Assert.assertEquals((Object)"miles", (Object)strInspector.getPrimitiveJavaObject(inspector.getStructFieldData((Object)value, (StructField)fields.get(0))));
            Assert.assertEquals((Object)false, (Object)reader.next(key, (Object)value));
            reader.close();
            return;
        }
    }

    JobConf createMockExecutionEnvironment(Path workDir, Path warehouseDir, String tableName, ObjectInspector objectInspector, boolean isVectorized, int partitions) throws IOException {
        Utilities.clearWorkMap();
        JobConf conf = new JobConf();
        conf.set("hive.exec.plan", workDir.toString());
        conf.set("mapred.job.tracker", "local");
        conf.set("hive.vectorized.execution.enabled", Boolean.toString(isVectorized));
        conf.set("fs.mock.impl", MockFileSystem.class.getName());
        conf.set("mapred.mapper.class", ExecMapper.class.getName());
        Path root = new Path(warehouseDir, tableName);
        ((MockFileSystem)root.getFileSystem((Configuration)conf)).clear();
        String[] partPath = new String[partitions];
        StringBuilder buffer = new StringBuilder();
        for (int p = 0; p < partitions; ++p) {
            partPath[p] = new Path(root, "p=" + p).toString();
            if (p != 0) {
                buffer.append(',');
            }
            buffer.append(partPath[p]);
        }
        conf.set("mapred.input.dir", buffer.toString());
        StringBuilder columnIds = new StringBuilder();
        StringBuilder columnNames = new StringBuilder();
        StringBuilder columnTypes = new StringBuilder();
        StructObjectInspector structOI = (StructObjectInspector)objectInspector;
        List fields = structOI.getAllStructFieldRefs();
        int numCols = fields.size();
        for (int i = 0; i < numCols; ++i) {
            if (i != 0) {
                columnIds.append(',');
                columnNames.append(',');
                columnTypes.append(',');
            }
            columnIds.append(i);
            columnNames.append(((StructField)fields.get(i)).getFieldName());
            columnTypes.append(((StructField)fields.get(i)).getFieldObjectInspector().getTypeName());
        }
        conf.set("hive.io.file.readcolumn.ids", columnIds.toString());
        conf.set("partition_columns", "p");
        conf.set("columns", columnNames.toString());
        conf.set("columns.types", columnTypes.toString());
        MockFileSystem fs = (MockFileSystem)warehouseDir.getFileSystem((Configuration)conf);
        fs.clear();
        Properties tblProps = new Properties();
        tblProps.put("name", tableName);
        tblProps.put("serialization.lib", OrcSerde.class.getName());
        tblProps.put("columns", columnNames.toString());
        tblProps.put("columns.types", columnTypes.toString());
        TableDesc tbl = new TableDesc(OrcInputFormat.class, OrcOutputFormat.class, tblProps);
        MapWork mapWork = new MapWork();
        mapWork.setVectorMode(isVectorized);
        mapWork.setUseBucketizedHiveInputFormat(false);
        LinkedHashMap aliasMap = new LinkedHashMap();
        ArrayList<String> aliases = new ArrayList<String>();
        aliases.add(tableName);
        LinkedHashMap<String, PartitionDesc> partMap = new LinkedHashMap<String, PartitionDesc>();
        for (int p = 0; p < partitions; ++p) {
            aliasMap.put(partPath[p], aliases);
            LinkedHashMap partSpec = new LinkedHashMap();
            PartitionDesc part = new PartitionDesc(tbl, partSpec);
            partMap.put(partPath[p], part);
        }
        mapWork.setPathToAliases(aliasMap);
        mapWork.setPathToPartitionInfo(partMap);
        mapWork.setAllColumnVectorMaps(new HashMap());
        mapWork.setAllScratchColumnVectorTypeMaps(new HashMap());
        FileSystem localFs = FileSystem.getLocal((Configuration)conf).getRaw();
        Path mapXml = new Path(workDir, "map.xml");
        localFs.delete(mapXml, true);
        FSDataOutputStream planStream = localFs.create(mapXml);
        Utilities.serializePlan((Object)mapWork, (OutputStream)planStream, (Configuration)conf);
        planStream.close();
        return conf;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testVectorization() throws Exception {
        Class<TestOrcFile> clazz = TestOrcFile.class;
        synchronized (TestOrcFile.class) {
            StructObjectInspector inspector = (StructObjectInspector)ObjectInspectorFactory.getReflectionObjectInspector(MyRow.class, (ObjectInspectorFactory.ObjectInspectorOptions)ObjectInspectorFactory.ObjectInspectorOptions.JAVA);
            // ** MonitorExit[var2_1] (shouldn't be in output)
            JobConf conf = this.createMockExecutionEnvironment(this.workDir, new Path("mock:///"), "vectorization", (ObjectInspector)inspector, true, 1);
            Writer writer = OrcFile.createWriter((Path)new Path(conf.get("mapred.input.dir") + "/0_0"), (OrcFile.WriterOptions)OrcFile.writerOptions((Configuration)conf).blockPadding(false).bufferSize(1024).inspector((ObjectInspector)inspector));
            for (int i = 0; i < 10; ++i) {
                writer.addRow((Object)new MyRow(i, 2 * i));
            }
            writer.close();
            ((MockOutputStream)((WriterImpl)writer).getStream()).setBlocks(new MockBlock("host0", "host1"));
            HiveInputFormat inputFormat = new HiveInputFormat();
            InputSplit[] splits = inputFormat.getSplits(conf, 10);
            Assert.assertEquals((long)1L, (long)splits.length);
            RecordReader reader = inputFormat.getRecordReader(splits[0], conf, Reporter.NULL);
            NullWritable key = (NullWritable)reader.createKey();
            VectorizedRowBatch value = (VectorizedRowBatch)reader.createValue();
            Assert.assertEquals((Object)true, (Object)reader.next((Object)key, (Object)value));
            Assert.assertEquals((long)10L, (long)value.count());
            LongColumnVector col0 = (LongColumnVector)value.cols[0];
            for (int i = 0; i < 10; ++i) {
                Assert.assertEquals((String)("checking " + i), (long)i, (long)col0.vector[i]);
            }
            Assert.assertEquals((Object)false, (Object)reader.next((Object)key, (Object)value));
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testVectorizationWithBuckets() throws Exception {
        Class<TestOrcFile> clazz = TestOrcFile.class;
        synchronized (TestOrcFile.class) {
            StructObjectInspector inspector = (StructObjectInspector)ObjectInspectorFactory.getReflectionObjectInspector(MyRow.class, (ObjectInspectorFactory.ObjectInspectorOptions)ObjectInspectorFactory.ObjectInspectorOptions.JAVA);
            // ** MonitorExit[var2_1] (shouldn't be in output)
            JobConf conf = this.createMockExecutionEnvironment(this.workDir, new Path("mock:///"), "vectorBuckets", (ObjectInspector)inspector, true, 1);
            Writer writer = OrcFile.createWriter((Path)new Path(conf.get("mapred.input.dir") + "/0_0"), (OrcFile.WriterOptions)OrcFile.writerOptions((Configuration)conf).blockPadding(false).bufferSize(1024).inspector((ObjectInspector)inspector));
            for (int i = 0; i < 10; ++i) {
                writer.addRow((Object)new MyRow(i, 2 * i));
            }
            writer.close();
            ((MockOutputStream)((WriterImpl)writer).getStream()).setBlocks(new MockBlock("host0", "host1"));
            conf.setInt("bucket_count", 3);
            HiveInputFormat inputFormat = new HiveInputFormat();
            InputSplit[] splits = inputFormat.getSplits(conf, 10);
            Assert.assertEquals((long)1L, (long)splits.length);
            RecordReader reader = inputFormat.getRecordReader(splits[0], conf, Reporter.NULL);
            NullWritable key = (NullWritable)reader.createKey();
            VectorizedRowBatch value = (VectorizedRowBatch)reader.createValue();
            Assert.assertEquals((Object)true, (Object)reader.next((Object)key, (Object)value));
            Assert.assertEquals((long)10L, (long)value.count());
            LongColumnVector col0 = (LongColumnVector)value.cols[0];
            for (int i = 0; i < 10; ++i) {
                Assert.assertEquals((String)("checking " + i), (long)i, (long)col0.vector[i]);
            }
            Assert.assertEquals((Object)false, (Object)reader.next((Object)key, (Object)value));
            return;
        }
    }

    @Test
    public void testVectorizationWithAcid() throws Exception {
        BigRowInspector inspector = new BigRowInspector();
        JobConf conf = this.createMockExecutionEnvironment(this.workDir, new Path("mock:///"), "vectorizationAcid", (ObjectInspector)inspector, true, 1);
        Path partDir = new Path(conf.get("mapred.input.dir"));
        OrcRecordUpdater writer = new OrcRecordUpdater(partDir, new AcidOutputFormat.Options((Configuration)conf).maximumTransactionId(10L).writingBase(true).bucket(0).inspector((ObjectInspector)inspector));
        for (int i = 0; i < 100; ++i) {
            BigRow row = new BigRow(i);
            writer.insert(10L, (Object)row);
        }
        WriterImpl baseWriter = (WriterImpl)writer.getWriter();
        writer.close(false);
        ((MockOutputStream)baseWriter.getStream()).setBlocks(new MockBlock("host0", "host1"));
        HiveInputFormat inputFormat = new HiveInputFormat();
        InputSplit[] splits = inputFormat.getSplits(conf, 10);
        Assert.assertEquals((long)1L, (long)splits.length);
        RecordReader reader = inputFormat.getRecordReader(splits[0], conf, Reporter.NULL);
        NullWritable key = (NullWritable)reader.createKey();
        VectorizedRowBatch value = (VectorizedRowBatch)reader.createValue();
        Assert.assertEquals((Object)true, (Object)reader.next((Object)key, (Object)value));
        Assert.assertEquals((long)100L, (long)value.count());
        LongColumnVector booleanColumn = (LongColumnVector)value.cols[0];
        LongColumnVector byteColumn = (LongColumnVector)value.cols[1];
        LongColumnVector shortColumn = (LongColumnVector)value.cols[2];
        LongColumnVector intColumn = (LongColumnVector)value.cols[3];
        LongColumnVector longColumn = (LongColumnVector)value.cols[4];
        DoubleColumnVector floatColumn = (DoubleColumnVector)value.cols[5];
        DoubleColumnVector doubleCoulmn = (DoubleColumnVector)value.cols[6];
        BytesColumnVector stringColumn = (BytesColumnVector)value.cols[7];
        DecimalColumnVector decimalColumn = (DecimalColumnVector)value.cols[8];
        LongColumnVector dateColumn = (LongColumnVector)value.cols[9];
        LongColumnVector timestampColumn = (LongColumnVector)value.cols[10];
        for (int i = 0; i < 100; ++i) {
            Assert.assertEquals((String)("checking boolean " + i), (long)(i % 2 == 0 ? 1L : 0L), (long)booleanColumn.vector[i]);
            Assert.assertEquals((String)("checking byte " + i), (long)((byte)i), (long)byteColumn.vector[i]);
            Assert.assertEquals((String)("checking short " + i), (long)((short)i), (long)shortColumn.vector[i]);
            Assert.assertEquals((String)("checking int " + i), (long)i, (long)intColumn.vector[i]);
            Assert.assertEquals((String)("checking long " + i), (long)i, (long)longColumn.vector[i]);
            Assert.assertEquals((String)("checking float " + i), (double)i, (double)floatColumn.vector[i], (double)1.0E-4);
            Assert.assertEquals((String)("checking double " + i), (double)i, (double)doubleCoulmn.vector[i], (double)1.0E-4);
            Assert.assertEquals((String)("checking string " + i), (Object)new Text(Long.toHexString(i)), (Object)stringColumn.getWritableObject(i));
            Assert.assertEquals((String)("checking decimal " + i), (Object)HiveDecimal.create((int)i), (Object)decimalColumn.vector[i].getHiveDecimal());
            Assert.assertEquals((String)("checking date " + i), (long)i, (long)dateColumn.vector[i]);
            long millis = (long)i * 86400000L;
            millis -= (long)LOCAL_TIMEZONE.getOffset(millis);
            Assert.assertEquals((String)("checking timestamp " + i), (long)(millis * 1000000L), (long)timestampColumn.vector[i]);
        }
        Assert.assertEquals((Object)false, (Object)reader.next((Object)key, (Object)value));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCombinationInputFormat() throws Exception {
        Class<TestOrcFile> clazz = TestOrcFile.class;
        synchronized (TestOrcFile.class) {
            StructObjectInspector inspector = (StructObjectInspector)ObjectInspectorFactory.getReflectionObjectInspector(MyRow.class, (ObjectInspectorFactory.ObjectInspectorOptions)ObjectInspectorFactory.ObjectInspectorOptions.JAVA);
            // ** MonitorExit[var2_1] (shouldn't be in output)
            JobConf conf = this.createMockExecutionEnvironment(this.workDir, new Path("mock:///"), "combination", (ObjectInspector)inspector, false, 1);
            Path partDir = new Path(conf.get("mapred.input.dir"));
            Writer writer = OrcFile.createWriter((Path)new Path(partDir, "0_0"), (OrcFile.WriterOptions)OrcFile.writerOptions((Configuration)conf).blockPadding(false).bufferSize(1024).inspector((ObjectInspector)inspector));
            for (int i = 0; i < 10; ++i) {
                writer.addRow((Object)new MyRow(i, 2 * i));
            }
            writer.close();
            MockOutputStream outputStream = (MockOutputStream)((WriterImpl)writer).getStream();
            outputStream.setBlocks(new MockBlock("host0", "host1"));
            int length0 = ((MockOutputStream)outputStream).file.length;
            writer = OrcFile.createWriter((Path)new Path(partDir, "1_0"), (OrcFile.WriterOptions)OrcFile.writerOptions((Configuration)conf).blockPadding(false).bufferSize(1024).inspector((ObjectInspector)inspector));
            for (int i = 10; i < 20; ++i) {
                writer.addRow((Object)new MyRow(i, 2 * i));
            }
            writer.close();
            outputStream = (MockOutputStream)((WriterImpl)writer).getStream();
            outputStream.setBlocks(new MockBlock("host1", "host2"));
            CombineHiveInputFormat inputFormat = new CombineHiveInputFormat();
            InputSplit[] splits = inputFormat.getSplits(conf, 1);
            Assert.assertEquals((long)1L, (long)splits.length);
            CombineHiveInputFormat.CombineHiveInputSplit split = (CombineHiveInputFormat.CombineHiveInputSplit)splits[0];
            Assert.assertEquals((long)2L, (long)split.getNumPaths());
            Assert.assertEquals((Object)(partDir.toString() + "/0_0"), (Object)split.getPath(0).toString());
            Assert.assertEquals((Object)(partDir.toString() + "/1_0"), (Object)split.getPath(1).toString());
            Assert.assertEquals((long)length0, (long)split.getLength(0));
            Assert.assertEquals((long)((MockOutputStream)outputStream).file.length, (long)split.getLength(1));
            Assert.assertEquals((long)0L, (long)split.getOffset(0));
            Assert.assertEquals((long)0L, (long)split.getOffset(1));
            Assert.assertTrue((3 >= split.getLocations().length ? 1 : 0) != 0);
            RecordReader reader = inputFormat.getRecordReader((InputSplit)split, conf, Reporter.NULL);
            CombineHiveKey key = (CombineHiveKey)reader.createKey();
            OrcStruct value = (OrcStruct)reader.createValue();
            for (int i = 0; i < 20; ++i) {
                Assert.assertEquals((Object)true, (Object)reader.next((Object)key, (Object)value));
                Assert.assertEquals((long)i, (long)((IntWritable)value.getFieldValue(0)).get());
            }
            Assert.assertEquals((Object)false, (Object)reader.next((Object)key, (Object)value));
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCombinationInputFormatWithAcid() throws Exception {
        int PARTITIONS = 2;
        int BUCKETS = 3;
        Class<TestOrcFile> clazz = TestOrcFile.class;
        synchronized (TestOrcFile.class) {
            StructObjectInspector inspector = (StructObjectInspector)ObjectInspectorFactory.getReflectionObjectInspector(MyRow.class, (ObjectInspectorFactory.ObjectInspectorOptions)ObjectInspectorFactory.ObjectInspectorOptions.JAVA);
            // ** MonitorExit[var4_3] (shouldn't be in output)
            JobConf conf = this.createMockExecutionEnvironment(this.workDir, new Path("mock:///"), "combinationAcid", (ObjectInspector)inspector, false, 2);
            Path[] partDir = new Path[2];
            String[] paths = conf.getStrings("mapred.input.dir");
            for (int p = 0; p < 2; ++p) {
                partDir[p] = new Path(paths[p]);
            }
            OrcRecordUpdater writer = new OrcRecordUpdater(partDir[0], new AcidOutputFormat.Options((Configuration)conf).maximumTransactionId(10L).writingBase(true).bucket(0).inspector((ObjectInspector)inspector));
            for (int i = 0; i < 10; ++i) {
                writer.insert(10L, (Object)new MyRow(i, 2 * i));
            }
            WriterImpl baseWriter = (WriterImpl)writer.getWriter();
            writer.close(false);
            MockOutputStream outputStream = (MockOutputStream)baseWriter.getStream();
            outputStream.setBlocks(new MockBlock("host1", "host2"));
            writer = new OrcRecordUpdater(partDir[0], new AcidOutputFormat.Options((Configuration)conf).maximumTransactionId(10L).writingBase(true).bucket(1).inspector((ObjectInspector)inspector));
            for (int i = 10; i < 20; ++i) {
                writer.insert(10L, (Object)new MyRow(i, 2 * i));
            }
            WriterImpl deltaWriter = (WriterImpl)writer.getWriter();
            outputStream = (MockOutputStream)deltaWriter.getStream();
            writer.close(false);
            outputStream.setBlocks(new MockBlock("host1", "host2"));
            for (int bucket = 0; bucket < 3; ++bucket) {
                Writer orc = OrcFile.createWriter((Path)new Path(partDir[1], "00000" + bucket + "_0"), (OrcFile.WriterOptions)OrcFile.writerOptions((Configuration)conf).blockPadding(false).bufferSize(1024).inspector((ObjectInspector)inspector));
                orc.addRow((Object)new MyRow(1, 2));
                outputStream = (MockOutputStream)((WriterImpl)orc).getStream();
                orc.close();
                outputStream.setBlocks(new MockBlock("host3", "host4"));
            }
            conf.setInt("bucket_count", 3);
            CombineHiveInputFormat inputFormat = new CombineHiveInputFormat();
            InputSplit[] splits = inputFormat.getSplits(conf, 1);
            Assert.assertEquals((long)3L, (long)splits.length);
            HiveInputFormat.HiveInputSplit split = (HiveInputFormat.HiveInputSplit)splits[0];
            Assert.assertEquals((Object)"org.apache.hadoop.hive.ql.io.orc.OrcInputFormat", (Object)split.inputFormatClassName());
            Assert.assertEquals((Object)"mock:/combinationAcid/p=0/base_0000010/bucket_00000", (Object)split.getPath().toString());
            Assert.assertEquals((long)0L, (long)split.getStart());
            Assert.assertEquals((long)582L, (long)split.getLength());
            split = (HiveInputFormat.HiveInputSplit)splits[1];
            Assert.assertEquals((Object)"org.apache.hadoop.hive.ql.io.orc.OrcInputFormat", (Object)split.inputFormatClassName());
            Assert.assertEquals((Object)"mock:/combinationAcid/p=0/base_0000010/bucket_00001", (Object)split.getPath().toString());
            Assert.assertEquals((long)0L, (long)split.getStart());
            Assert.assertEquals((long)603L, (long)split.getLength());
            CombineHiveInputFormat.CombineHiveInputSplit combineSplit = (CombineHiveInputFormat.CombineHiveInputSplit)splits[2];
            Assert.assertEquals((long)3L, (long)combineSplit.getNumPaths());
            for (int bucket = 0; bucket < 3; ++bucket) {
                Assert.assertEquals((Object)("mock:/combinationAcid/p=1/00000" + bucket + "_0"), (Object)combineSplit.getPath(bucket).toString());
                Assert.assertEquals((long)0L, (long)combineSplit.getOffset(bucket));
                Assert.assertEquals((long)227L, (long)combineSplit.getLength(bucket));
            }
            String[] hosts = combineSplit.getLocations();
            Assert.assertEquals((long)2L, (long)hosts.length);
            return;
        }
    }

    @Test
    public void testSetSearchArgument() throws Exception {
        Reader.Options options = new Reader.Options();
        ArrayList<OrcProto.Type> types = new ArrayList<OrcProto.Type>();
        OrcProto.Type.Builder builder = OrcProto.Type.newBuilder();
        builder.setKind(OrcProto.Type.Kind.STRUCT).addAllFieldNames(Arrays.asList("op", "otid", "bucket", "rowid", "ctid", "row")).addAllSubtypes(Arrays.asList(1, 2, 3, 4, 5, 6));
        types.add(builder.build());
        builder.clear().setKind(OrcProto.Type.Kind.INT);
        types.add(builder.build());
        types.add(builder.build());
        types.add(builder.build());
        types.add(builder.build());
        types.add(builder.build());
        builder.clear().setKind(OrcProto.Type.Kind.STRUCT).addAllFieldNames(Arrays.asList("url", "purchase", "cost", "store")).addAllSubtypes(Arrays.asList(7, 8, 9, 10));
        types.add(builder.build());
        builder.clear().setKind(OrcProto.Type.Kind.STRING);
        types.add(builder.build());
        builder.clear().setKind(OrcProto.Type.Kind.INT);
        types.add(builder.build());
        types.add(builder.build());
        types.add(builder.build());
        SearchArgument isNull = SearchArgumentFactory.newBuilder().startAnd().isNull("cost").end().build();
        this.conf.set("sarg.pushdown", isNull.toKryo());
        this.conf.set("hive.io.file.readcolumn.names", "url,cost");
        options.include(new boolean[]{true, true, false, true, false});
        OrcInputFormat.setSearchArgument((Reader.Options)options, types, (Configuration)this.conf, (boolean)false);
        String[] colNames = options.getColumnNames();
        Assert.assertEquals(null, (Object)colNames[0]);
        Assert.assertEquals((Object)"url", (Object)colNames[1]);
        Assert.assertEquals(null, (Object)colNames[2]);
        Assert.assertEquals((Object)"cost", (Object)colNames[3]);
        Assert.assertEquals(null, (Object)colNames[4]);
        SearchArgument arg = options.getSearchArgument();
        List leaves = arg.getLeaves();
        Assert.assertEquals((Object)"cost", (Object)((PredicateLeaf)leaves.get(0)).getColumnName());
        Assert.assertEquals((Object)PredicateLeaf.Operator.IS_NULL, (Object)((PredicateLeaf)leaves.get(0)).getOperator());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSplitElimination() throws Exception {
        Properties properties = new Properties();
        Class<TestOrcFile> clazz = TestOrcFile.class;
        synchronized (TestOrcFile.class) {
            StructObjectInspector inspector = (StructObjectInspector)ObjectInspectorFactory.getReflectionObjectInspector(NestedRow.class, (ObjectInspectorFactory.ObjectInspectorOptions)ObjectInspectorFactory.ObjectInspectorOptions.JAVA);
            // ** MonitorExit[var3_2] (shouldn't be in output)
            OrcSerde serde = new OrcSerde();
            OrcOutputFormat outFormat = new OrcOutputFormat();
            this.conf.setInt("mapred.max.split.size", 50);
            RecordWriter writer = outFormat.getRecordWriter(this.fs, this.conf, this.testFilePath.toString(), (Progressable)Reporter.NULL);
            writer.write((Object)NullWritable.get(), (Object)serde.serialize((Object)new NestedRow(1, 2, 3), (ObjectInspector)inspector));
            writer.write((Object)NullWritable.get(), (Object)serde.serialize((Object)new NestedRow(4, 5, 6), (ObjectInspector)inspector));
            writer.write((Object)NullWritable.get(), (Object)serde.serialize((Object)new NestedRow(7, 8, 9), (ObjectInspector)inspector));
            writer.close(Reporter.NULL);
            serde = new OrcSerde();
            SearchArgument sarg = SearchArgumentFactory.newBuilder().startAnd().lessThan("z", (Object)new Integer(0)).end().build();
            this.conf.set("sarg.pushdown", sarg.toKryo());
            this.conf.set("hive.io.file.readcolumn.names", "z,r");
            properties.setProperty("columns", "z,r");
            properties.setProperty("columns.types", "int:struct<x:int,y:int>");
            SerDeUtils.initializeSerDe((Deserializer)serde, (Configuration)this.conf, (Properties)properties, null);
            inspector = (StructObjectInspector)serde.getObjectInspector();
            OrcInputFormat in = new OrcInputFormat();
            FileInputFormat.setInputPaths((JobConf)this.conf, (String)this.testFilePath.toString());
            InputSplit[] splits = in.getSplits(this.conf, 1);
            Assert.assertEquals((long)0L, (long)splits.length);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSplitEliminationNullStats() throws Exception {
        Properties properties = new Properties();
        Class<TestOrcFile> clazz = TestOrcFile.class;
        synchronized (TestOrcFile.class) {
            StructObjectInspector inspector = (StructObjectInspector)ObjectInspectorFactory.getReflectionObjectInspector(SimpleRow.class, (ObjectInspectorFactory.ObjectInspectorOptions)ObjectInspectorFactory.ObjectInspectorOptions.JAVA);
            // ** MonitorExit[var3_2] (shouldn't be in output)
            OrcSerde serde = new OrcSerde();
            OrcOutputFormat outFormat = new OrcOutputFormat();
            this.conf.setInt("mapred.max.split.size", 50);
            RecordWriter writer = outFormat.getRecordWriter(this.fs, this.conf, this.testFilePath.toString(), (Progressable)Reporter.NULL);
            writer.write((Object)NullWritable.get(), (Object)serde.serialize((Object)new SimpleRow(null), (ObjectInspector)inspector));
            writer.write((Object)NullWritable.get(), (Object)serde.serialize((Object)new SimpleRow(null), (ObjectInspector)inspector));
            writer.write((Object)NullWritable.get(), (Object)serde.serialize((Object)new SimpleRow(null), (ObjectInspector)inspector));
            writer.close(Reporter.NULL);
            serde = new OrcSerde();
            SearchArgument sarg = SearchArgumentFactory.newBuilder().startAnd().lessThan("z", (Object)new String("foo")).end().build();
            this.conf.set("sarg.pushdown", sarg.toKryo());
            this.conf.set("hive.io.file.readcolumn.names", "z");
            properties.setProperty("columns", "z");
            properties.setProperty("columns.types", "string");
            SerDeUtils.initializeSerDe((Deserializer)serde, (Configuration)this.conf, (Properties)properties, null);
            inspector = (StructObjectInspector)serde.getObjectInspector();
            OrcInputFormat in = new OrcInputFormat();
            FileInputFormat.setInputPaths((JobConf)this.conf, (String)this.testFilePath.toString());
            InputSplit[] splits = in.getSplits(this.conf, 1);
            Assert.assertEquals((long)0L, (long)splits.length);
            return;
        }
    }

    static {
        TimeZone gmt = TimeZone.getTimeZone("GMT+0");
        DATE_FORMAT.setTimeZone(gmt);
        TIME_FORMAT.setTimeZone(gmt);
    }

    static class StringRow
    implements Writable {
        String str;
        String str2;

        StringRow(String s) {
            this.str = s;
            this.str2 = s;
        }

        public void write(DataOutput dataOutput) throws IOException {
            throw new UnsupportedOperationException("no write");
        }

        public void readFields(DataInput dataInput) throws IOException {
            throw new UnsupportedOperationException("no read");
        }
    }

    static class NestedRow
    implements Writable {
        int z;
        MyRow r;

        NestedRow(int x, int y, int z) {
            this.z = z;
            this.r = new MyRow(x, y);
        }

        public void write(DataOutput dataOutput) throws IOException {
            throw new UnsupportedOperationException("unsupported");
        }

        public void readFields(DataInput dataInput) throws IOException {
            throw new UnsupportedOperationException("unsupported");
        }
    }

    static class SimpleRow
    implements Writable {
        Text z;

        public SimpleRow(Text t) {
            this.z = t;
        }

        public void write(DataOutput dataOutput) throws IOException {
            throw new UnsupportedOperationException("unsupported");
        }

        public void readFields(DataInput dataInput) throws IOException {
            throw new UnsupportedOperationException("unsupported");
        }
    }

    public static class MockFileSystem
    extends FileSystem {
        final List<MockFile> files = new ArrayList<MockFile>();
        Path workingDir = new Path("/");

        public MockFileSystem() {
        }

        public void initialize(URI uri, Configuration conf) {
            this.setConf(conf);
        }

        public MockFileSystem(Configuration conf, MockFile ... files) {
            this.setConf(conf);
            this.files.addAll(Arrays.asList(files));
        }

        void clear() {
            this.files.clear();
        }

        public URI getUri() {
            try {
                return new URI("mock:///");
            }
            catch (URISyntaxException err) {
                throw new IllegalArgumentException("huh?", err);
            }
        }

        public FSDataInputStream open(Path path, int i) throws IOException {
            for (MockFile file : this.files) {
                if (!file.path.equals((Object)path)) continue;
                return new FSDataInputStream((InputStream)((Object)new MockInputStream(file)));
            }
            throw new IOException("File not found: " + path);
        }

        public FSDataOutputStream create(Path path, FsPermission fsPermission, boolean overwrite, int bufferSize, short replication, long blockSize, Progressable progressable) throws IOException {
            MockFile file = null;
            for (MockFile currentFile : this.files) {
                if (!currentFile.path.equals((Object)path)) continue;
                file = currentFile;
                break;
            }
            if (file == null) {
                file = new MockFile(path.toString(), (int)blockSize, new byte[0], new MockBlock[0]);
                this.files.add(file);
            }
            return new MockOutputStream(file);
        }

        public FSDataOutputStream append(Path path, int bufferSize, Progressable progressable) throws IOException {
            return this.create(path, FsPermission.getDefault(), true, bufferSize, (short)3, 262144L, progressable);
        }

        public boolean rename(Path path, Path path2) throws IOException {
            return false;
        }

        public boolean delete(Path path) throws IOException {
            return false;
        }

        public boolean delete(Path path, boolean b) throws IOException {
            return false;
        }

        public FileStatus[] listStatus(Path path) throws IOException {
            path = path.makeQualified((FileSystem)this);
            ArrayList<FileStatus> result = new ArrayList<FileStatus>();
            String pathname = path.toString();
            String pathnameAsDir = pathname + "/";
            TreeSet<String> dirs = new TreeSet<String>();
            for (MockFile file : this.files) {
                String filename = file.path.toString();
                if (pathname.equals(filename)) {
                    return new FileStatus[]{this.createStatus(file)};
                }
                if (!filename.startsWith(pathnameAsDir)) continue;
                String tail = filename.substring(pathnameAsDir.length());
                int nextSlash = tail.indexOf(47);
                if (nextSlash > 0) {
                    dirs.add(tail.substring(0, nextSlash));
                    continue;
                }
                result.add(this.createStatus(file));
            }
            for (String dir : dirs) {
                result.add(this.createDirectory(new MockPath(this, pathnameAsDir + dir)));
            }
            return result.toArray(new FileStatus[result.size()]);
        }

        public void setWorkingDirectory(Path path) {
            this.workingDir = path;
        }

        public Path getWorkingDirectory() {
            return this.workingDir;
        }

        public boolean mkdirs(Path path, FsPermission fsPermission) {
            return false;
        }

        private FileStatus createStatus(MockFile file) {
            return new FileStatus((long)file.length, false, 1, (long)file.blockSize, 0L, 0L, FsPermission.createImmutable((short)644), "owen", "group", file.path);
        }

        private FileStatus createDirectory(Path dir) {
            return new FileStatus(0L, true, 0, 0L, 0L, 0L, FsPermission.createImmutable((short)755), "owen", "group", dir);
        }

        public FileStatus getFileStatus(Path path) throws IOException {
            path = path.makeQualified((FileSystem)this);
            String pathnameAsDir = path.toString() + "/";
            for (MockFile file : this.files) {
                if (file.path.equals((Object)path)) {
                    return this.createStatus(file);
                }
                if (!file.path.toString().startsWith(pathnameAsDir)) continue;
                return this.createDirectory(path);
            }
            throw new FileNotFoundException("File " + path + " does not exist");
        }

        public BlockLocation[] getFileBlockLocations(FileStatus stat, long start, long len) {
            ArrayList<BlockLocation> result = new ArrayList<BlockLocation>();
            for (MockFile file : this.files) {
                if (!file.path.equals((Object)stat.getPath())) continue;
                for (MockBlock block : file.blocks) {
                    if (OrcInputFormat.SplitGenerator.getOverlap((long)block.offset, (long)block.length, (long)start, (long)len) <= 0L) continue;
                    String[] topology = new String[block.hosts.length];
                    for (int i = 0; i < topology.length; ++i) {
                        topology[i] = "/rack/ " + block.hosts[i];
                    }
                    result.add(new BlockLocation(block.hosts, block.hosts, topology, (long)block.offset, (long)block.length));
                }
                return result.toArray(new BlockLocation[result.size()]);
            }
            return new BlockLocation[0];
        }

        public String toString() {
            StringBuilder buffer = new StringBuilder();
            buffer.append("mockFs{files:[");
            for (int i = 0; i < this.files.size(); ++i) {
                if (i != 0) {
                    buffer.append(", ");
                }
                buffer.append(this.files.get(i));
            }
            buffer.append("]}");
            return buffer.toString();
        }
    }

    public static class MockOutputStream
    extends FSDataOutputStream {
        private final MockFile file;

        public MockOutputStream(MockFile file) throws IOException {
            super((OutputStream)new DataOutputBuffer(), null);
            this.file = file;
        }

        public void setBlocks(MockBlock ... blocks) {
            this.file.blocks = blocks;
            int offset = 0;
            for (int i = 0; offset < this.file.length && i < blocks.length; offset += blocks[i].length, ++i) {
                blocks[i].offset = offset;
                blocks[i].length = Math.min(this.file.length - offset, this.file.blockSize);
            }
        }

        public void close() throws IOException {
            super.close();
            DataOutputBuffer buf = (DataOutputBuffer)this.getWrappedStream();
            this.file.length = buf.getLength();
            this.file.content = new byte[this.file.length];
            System.arraycopy(buf.getData(), 0, this.file.content, 0, this.file.length);
        }

        public String toString() {
            return "Out stream to " + this.file.toString();
        }
    }

    public static class MockPath
    extends Path {
        private final FileSystem fs;

        public MockPath(FileSystem fs, String path) {
            super(path);
            this.fs = fs;
        }

        public FileSystem getFileSystem(Configuration conf) {
            return this.fs;
        }
    }

    static class MockInputStream
    extends FSInputStream {
        final MockFile file;
        int offset = 0;

        public MockInputStream(MockFile file) throws IOException {
            this.file = file;
        }

        public void seek(long offset) throws IOException {
            this.offset = (int)offset;
        }

        public long getPos() throws IOException {
            return this.offset;
        }

        public boolean seekToNewSource(long l) throws IOException {
            return false;
        }

        public int read() throws IOException {
            if (this.offset < this.file.length) {
                return this.file.content[this.offset++] & 0xFF;
            }
            return -1;
        }
    }

    public static class MockFile {
        final Path path;
        int blockSize;
        int length;
        MockBlock[] blocks;
        byte[] content;

        public MockFile(String path, int blockSize, byte[] content, MockBlock ... blocks) {
            this.path = new Path(path);
            this.blockSize = blockSize;
            this.blocks = blocks;
            this.content = content;
            this.length = content.length;
            int offset = 0;
            for (MockBlock block : blocks) {
                block.offset = offset;
                block.length = Math.min(this.length - offset, blockSize);
                offset += block.length;
            }
        }

        public String toString() {
            StringBuilder buffer = new StringBuilder();
            buffer.append("mockFile{path: ");
            buffer.append(this.path.toString());
            buffer.append(", blkSize: ");
            buffer.append(this.blockSize);
            buffer.append(", len: ");
            buffer.append(this.length);
            buffer.append(", blocks: [");
            for (int i = 0; i < this.blocks.length; ++i) {
                if (i != 0) {
                    buffer.append(", ");
                }
                buffer.append(this.blocks[i]);
            }
            buffer.append("]}");
            return buffer.toString();
        }
    }

    public static class MockBlock {
        int offset;
        int length;
        final String[] hosts;

        public MockBlock(String ... hosts) {
            this.hosts = hosts;
        }

        public String toString() {
            StringBuilder buffer = new StringBuilder();
            buffer.append("block{offset: ");
            buffer.append(this.offset);
            buffer.append(", length: ");
            buffer.append(this.length);
            buffer.append(", hosts: [");
            for (int i = 0; i < this.hosts.length; ++i) {
                if (i != 0) {
                    buffer.append(", ");
                }
                buffer.append(this.hosts[i]);
            }
            buffer.append("]}");
            return buffer.toString();
        }
    }

    static class TestContext
    extends OrcInputFormat.Context {
        List<Runnable> queue = new ArrayList<Runnable>();

        TestContext(Configuration conf) {
            super(conf);
        }

        public void schedule(Runnable runnable) {
            this.queue.add(runnable);
        }
    }

    public static class MyRow
    implements Writable {
        int x;
        int y;

        MyRow(int x, int y) {
            this.x = x;
            this.y = y;
        }

        public void write(DataOutput dataOutput) throws IOException {
            throw new UnsupportedOperationException("no write");
        }

        public void readFields(DataInput dataInput) throws IOException {
            throw new UnsupportedOperationException("no read");
        }
    }

    public static class BigRowInspector
    extends StructObjectInspector {
        static final List<BigRowField> FIELDS = new ArrayList<BigRowField>();

        public List<? extends StructField> getAllStructFieldRefs() {
            return FIELDS;
        }

        public StructField getStructFieldRef(String fieldName) {
            for (StructField structField : FIELDS) {
                if (!structField.getFieldName().equals(fieldName)) continue;
                return structField;
            }
            throw new IllegalArgumentException("Can't find field " + fieldName);
        }

        public Object getStructFieldData(Object data, StructField fieldRef) {
            BigRow obj = (BigRow)data;
            switch (((BigRowField)fieldRef).id) {
                case 0: {
                    return obj.booleanValue;
                }
                case 1: {
                    return obj.byteValue;
                }
                case 2: {
                    return obj.shortValue;
                }
                case 3: {
                    return obj.intValue;
                }
                case 4: {
                    return obj.longValue;
                }
                case 5: {
                    return Float.valueOf(obj.floatValue);
                }
                case 6: {
                    return obj.doubleValue;
                }
                case 7: {
                    return obj.stringValue;
                }
                case 8: {
                    return obj.decimalValue;
                }
                case 9: {
                    return obj.dateValue;
                }
                case 10: {
                    return obj.timestampValue;
                }
            }
            throw new IllegalArgumentException("No such field " + fieldRef);
        }

        public List<Object> getStructFieldsDataAsList(Object data) {
            BigRow obj = (BigRow)data;
            ArrayList<Object> result = new ArrayList<Object>(11);
            result.add(obj.booleanValue);
            result.add(obj.byteValue);
            result.add(obj.shortValue);
            result.add(obj.intValue);
            result.add(obj.longValue);
            result.add(Float.valueOf(obj.floatValue));
            result.add(obj.doubleValue);
            result.add(obj.stringValue);
            result.add(obj.decimalValue);
            result.add(obj.dateValue);
            result.add(obj.timestampValue);
            return result;
        }

        public String getTypeName() {
            return "struct<booleanValue:boolean,byteValue:tinyint,shortValue:smallint,intValue:int,longValue:bigint,floatValue:float,doubleValue:double,stringValue:string,decimalValue:decimal>";
        }

        public ObjectInspector.Category getCategory() {
            return ObjectInspector.Category.STRUCT;
        }

        static {
            FIELDS.add(new BigRowField(0, "booleanValue", (ObjectInspector)PrimitiveObjectInspectorFactory.javaBooleanObjectInspector));
            FIELDS.add(new BigRowField(1, "byteValue", (ObjectInspector)PrimitiveObjectInspectorFactory.javaByteObjectInspector));
            FIELDS.add(new BigRowField(2, "shortValue", (ObjectInspector)PrimitiveObjectInspectorFactory.javaShortObjectInspector));
            FIELDS.add(new BigRowField(3, "intValue", (ObjectInspector)PrimitiveObjectInspectorFactory.javaIntObjectInspector));
            FIELDS.add(new BigRowField(4, "longValue", (ObjectInspector)PrimitiveObjectInspectorFactory.javaLongObjectInspector));
            FIELDS.add(new BigRowField(5, "floatValue", (ObjectInspector)PrimitiveObjectInspectorFactory.javaFloatObjectInspector));
            FIELDS.add(new BigRowField(6, "doubleValue", (ObjectInspector)PrimitiveObjectInspectorFactory.javaDoubleObjectInspector));
            FIELDS.add(new BigRowField(7, "stringValue", (ObjectInspector)PrimitiveObjectInspectorFactory.javaStringObjectInspector));
            FIELDS.add(new BigRowField(8, "decimalValue", (ObjectInspector)PrimitiveObjectInspectorFactory.javaHiveDecimalObjectInspector));
            FIELDS.add(new BigRowField(9, "dateValue", (ObjectInspector)PrimitiveObjectInspectorFactory.javaDateObjectInspector));
            FIELDS.add(new BigRowField(10, "timestampValue", (ObjectInspector)PrimitiveObjectInspectorFactory.javaTimestampObjectInspector));
        }
    }

    public static class BigRowField
    implements StructField {
        private final int id;
        private final String fieldName;
        private final ObjectInspector inspector;

        BigRowField(int id, String fieldName, ObjectInspector inspector) {
            this.id = id;
            this.fieldName = fieldName;
            this.inspector = inspector;
        }

        public String getFieldName() {
            return this.fieldName;
        }

        public ObjectInspector getFieldObjectInspector() {
            return this.inspector;
        }

        public String getFieldComment() {
            return null;
        }

        public int getFieldID() {
            return this.id;
        }

        public String toString() {
            return "field " + this.id + " " + this.fieldName;
        }
    }

    public static class BigRow
    implements Writable {
        boolean booleanValue;
        byte byteValue;
        short shortValue;
        int intValue;
        long longValue;
        float floatValue;
        double doubleValue;
        String stringValue;
        HiveDecimal decimalValue;
        Date dateValue;
        Timestamp timestampValue;

        BigRow(long x) {
            this.booleanValue = x % 2L == 0L;
            this.byteValue = (byte)x;
            this.shortValue = (short)x;
            this.intValue = (int)x;
            this.longValue = x;
            this.floatValue = x;
            this.doubleValue = x;
            this.stringValue = Long.toHexString(x);
            this.decimalValue = HiveDecimal.create((long)x);
            long millisUtc = x * 86400000L;
            millisUtc -= (long)LOCAL_TIMEZONE.getOffset(millisUtc);
            this.dateValue = new Date(millisUtc);
            this.timestampValue = new Timestamp(millisUtc);
        }

        public void write(DataOutput dataOutput) throws IOException {
            throw new UnsupportedOperationException("no write");
        }

        public void readFields(DataInput dataInput) throws IOException {
            throw new UnsupportedOperationException("no read");
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append("bigrow{booleanValue: ");
            builder.append(this.booleanValue);
            builder.append(", byteValue: ");
            builder.append(this.byteValue);
            builder.append(", shortValue: ");
            builder.append(this.shortValue);
            builder.append(", intValue: ");
            builder.append(this.intValue);
            builder.append(", longValue: ");
            builder.append(this.longValue);
            builder.append(", floatValue: ");
            builder.append(this.floatValue);
            builder.append(", doubleValue: ");
            builder.append(this.doubleValue);
            builder.append(", stringValue: ");
            builder.append(this.stringValue);
            builder.append(", decimalValue: ");
            builder.append(this.decimalValue);
            builder.append(", dateValue: ");
            builder.append(DATE_FORMAT.format(this.dateValue));
            builder.append(", timestampValue: ");
            builder.append(TIME_FORMAT.format(this.timestampValue));
            builder.append("}");
            return builder.toString();
        }
    }
}

