/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.io;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import junit.framework.TestCase;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.ContentSummary;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.Context;
import org.apache.hadoop.hive.ql.Driver;
import org.apache.hadoop.hive.ql.QueryPlan;
import org.apache.hadoop.hive.ql.exec.Utilities;
import org.apache.hadoop.hive.ql.exec.mr.MapRedTask;
import org.apache.hadoop.hive.ql.io.CombineHiveInputFormat;
import org.apache.hadoop.hive.ql.io.SymlinkTextInputFormat;
import org.apache.hadoop.hive.ql.plan.MapWork;
import org.apache.hadoop.hive.ql.plan.MapredWork;
import org.apache.hadoop.hive.ql.plan.PartitionDesc;
import org.apache.hadoop.hive.ql.plan.TableDesc;
import org.apache.hadoop.hive.ql.session.SessionState;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapred.FileInputFormat;
import org.apache.hadoop.mapred.InputSplit;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.RecordReader;
import org.apache.hadoop.mapred.Reporter;
import org.apache.hadoop.util.ReflectionUtils;

public class TestSymlinkTextInputFormat
extends TestCase {
    private static Log log = LogFactory.getLog(TestSymlinkTextInputFormat.class);
    private Configuration conf;
    private JobConf job;
    private FileSystem fileSystem;
    private Path testDir;
    Reporter reporter;
    private Path dataDir1;
    private Path dataDir2;
    private Path symlinkDir;

    protected void setUp() throws IOException {
        this.conf = new Configuration();
        this.job = new JobConf(this.conf);
        TableDesc tblDesc = Utilities.defaultTd;
        PartitionDesc partDesc = new PartitionDesc(tblDesc, null);
        LinkedHashMap<String, PartitionDesc> pt = new LinkedHashMap<String, PartitionDesc>();
        pt.put("/tmp/testfolder", partDesc);
        MapredWork mrwork = new MapredWork();
        mrwork.getMapWork().setPathToPartitionInfo(pt);
        Utilities.setMapRedWork((Configuration)this.job, (MapredWork)mrwork, (Path)new Path("/tmp/" + System.getProperty("user.name"), "hive"));
        this.fileSystem = FileSystem.getLocal((Configuration)this.conf);
        this.testDir = new Path(System.getProperty("test.tmp.dir", System.getProperty("user.dir", new File(".").getAbsolutePath())) + "/TestSymlinkTextInputFormat");
        this.reporter = Reporter.NULL;
        this.fileSystem.delete(this.testDir, true);
        this.dataDir1 = new Path(this.testDir, "datadir1");
        this.dataDir2 = new Path(this.testDir, "datadir2");
        this.symlinkDir = new Path(this.testDir, "symlinkdir");
    }

    protected void tearDown() throws IOException {
        this.fileSystem.delete(this.testDir, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testCombine() throws Exception {
        JobConf newJob = new JobConf((Configuration)this.job);
        FileSystem fs = this.dataDir1.getFileSystem((Configuration)newJob);
        int symbolLinkedFileSize = 0;
        Path dir1_file1 = new Path(this.dataDir1, "combinefile1_1");
        this.writeTextFile(dir1_file1, "dir1_file1_line1\ndir1_file1_line2\n");
        symbolLinkedFileSize = (int)((long)symbolLinkedFileSize + fs.getFileStatus(dir1_file1).getLen());
        Path dir2_file1 = new Path(this.dataDir2, "combinefile2_1");
        this.writeTextFile(dir2_file1, "dir2_file1_line1\ndir2_file1_line2\n");
        symbolLinkedFileSize = (int)((long)symbolLinkedFileSize + fs.getFileStatus(dir2_file1).getLen());
        this.writeSymlinkFile(new Path(this.symlinkDir, "symlink_file"), new Path(this.dataDir1, "combinefile1_1"), new Path(this.dataDir2, "combinefile2_1"));
        HiveConf hiveConf = new HiveConf(TestSymlinkTextInputFormat.class);
        HiveConf.setBoolVar((Configuration)hiveConf, (HiveConf.ConfVars)HiveConf.ConfVars.HIVE_REWORK_MAPREDWORK, (boolean)true);
        HiveConf.setBoolVar((Configuration)hiveConf, (HiveConf.ConfVars)HiveConf.ConfVars.HIVE_SUPPORT_CONCURRENCY, (boolean)false);
        Driver drv = new Driver(hiveConf);
        drv.init();
        String tblName = "text_symlink_text";
        String createSymlinkTableCmd = "create table " + tblName + " (key int) stored as " + " inputformat 'org.apache.hadoop.hive.ql.io.SymlinkTextInputFormat' " + " outputformat 'org.apache.hadoop.hive.ql.io.IgnoreKeyTextOutputFormat'";
        SessionState.start((HiveConf)hiveConf);
        boolean tblCreated = false;
        try {
            int ecode = 0;
            ecode = drv.run(createSymlinkTableCmd).getResponseCode();
            if (ecode != 0) {
                throw new Exception("Create table command: " + createSymlinkTableCmd + " failed with exit code= " + ecode);
            }
            tblCreated = true;
            String loadFileCommand = "LOAD DATA LOCAL INPATH '" + new Path(this.symlinkDir, "symlink_file").toString() + "' INTO TABLE " + tblName;
            ecode = drv.run(loadFileCommand).getResponseCode();
            if (ecode != 0) {
                throw new Exception("Load data command: " + loadFileCommand + " failed with exit code= " + ecode);
            }
            String cmd = "select key*1 from " + tblName;
            drv.compile(cmd);
            Context ctx = new Context((Configuration)newJob);
            Path emptyScratchDir = ctx.getMRTmpPath();
            FileSystem fileSys = emptyScratchDir.getFileSystem((Configuration)newJob);
            fileSys.mkdirs(emptyScratchDir);
            QueryPlan plan = drv.getPlan();
            MapRedTask selectTask = (MapRedTask)plan.getRootTasks().get(0);
            List inputPaths = Utilities.getInputPaths((JobConf)newJob, (MapWork)((MapredWork)selectTask.getWork()).getMapWork(), (Path)emptyScratchDir, (Context)ctx, (boolean)false);
            Utilities.setInputPaths((JobConf)newJob, (List)inputPaths);
            Utilities.setMapRedWork((Configuration)newJob, (MapredWork)((MapredWork)selectTask.getWork()), (Path)ctx.getMRTmpPath());
            CombineHiveInputFormat combineInputFormat = (CombineHiveInputFormat)ReflectionUtils.newInstance(CombineHiveInputFormat.class, (Configuration)newJob);
            InputSplit[] retSplits = combineInputFormat.getSplits(newJob, 1);
            TestSymlinkTextInputFormat.assertEquals((int)1, (int)retSplits.length);
        }
        catch (Exception e) {
            e.printStackTrace();
            TestSymlinkTextInputFormat.fail((String)("Caught exception " + e));
        }
        finally {
            if (tblCreated) {
                drv.run("drop table text_symlink_text").getResponseCode();
            }
        }
    }

    public void testAccuracy1() throws IOException {
        FileSystem fs = this.dataDir1.getFileSystem((Configuration)this.job);
        int symbolLinkedFileSize = 0;
        Path dir1_file1 = new Path(this.dataDir1, "file1");
        this.writeTextFile(dir1_file1, "dir1_file1_line1\ndir1_file1_line2\n");
        symbolLinkedFileSize = (int)((long)symbolLinkedFileSize + fs.getFileStatus(dir1_file1).getLen());
        Path dir1_file2 = new Path(this.dataDir1, "file2");
        this.writeTextFile(dir1_file2, "dir1_file2_line1\ndir1_file2_line2\n");
        Path dir2_file1 = new Path(this.dataDir2, "file1");
        this.writeTextFile(dir2_file1, "dir2_file1_line1\ndir2_file1_line2\n");
        Path dir2_file2 = new Path(this.dataDir2, "file2");
        this.writeTextFile(dir2_file2, "dir2_file2_line1\ndir2_file2_line2\n");
        symbolLinkedFileSize = (int)((long)symbolLinkedFileSize + fs.getFileStatus(dir2_file2).getLen());
        this.writeSymlinkFile(new Path(this.symlinkDir, "symlink_file"), new Path(this.dataDir1, "file1"), new Path(this.dataDir2, "file2"));
        SymlinkTextInputFormat inputFormat = new SymlinkTextInputFormat();
        ContentSummary cs = inputFormat.getContentSummary(this.symlinkDir, this.job);
        TestSymlinkTextInputFormat.assertEquals((long)symbolLinkedFileSize, (long)cs.getLength());
        TestSymlinkTextInputFormat.assertEquals((long)2L, (long)cs.getFileCount());
        TestSymlinkTextInputFormat.assertEquals((long)0L, (long)cs.getDirectoryCount());
        FileInputFormat.setInputPaths((JobConf)this.job, (Path[])new Path[]{this.symlinkDir});
        InputSplit[] splits = inputFormat.getSplits(this.job, 2);
        log.info((Object)("Number of splits: " + splits.length));
        ArrayList<String> received = new ArrayList<String>();
        for (InputSplit split : splits) {
            RecordReader reader = inputFormat.getRecordReader(split, this.job, this.reporter);
            LongWritable key = (LongWritable)reader.createKey();
            Text value = (Text)reader.createValue();
            while (reader.next((Object)key, (Object)value)) {
                received.add(value.toString());
            }
            reader.close();
        }
        ArrayList<String> expected = new ArrayList<String>();
        expected.add("dir1_file1_line1");
        expected.add("dir1_file1_line2");
        expected.add("dir2_file2_line1");
        expected.add("dir2_file2_line2");
        TestSymlinkTextInputFormat.assertEquals(expected, received);
    }

    public void testAccuracy2() throws IOException {
        this.fileSystem.mkdirs(this.symlinkDir);
        FileInputFormat.setInputPaths((JobConf)this.job, (Path[])new Path[]{this.symlinkDir});
        SymlinkTextInputFormat inputFormat = new SymlinkTextInputFormat();
        ContentSummary cs = inputFormat.getContentSummary(this.symlinkDir, this.job);
        TestSymlinkTextInputFormat.assertEquals((long)0L, (long)cs.getLength());
        TestSymlinkTextInputFormat.assertEquals((long)0L, (long)cs.getFileCount());
        TestSymlinkTextInputFormat.assertEquals((long)0L, (long)cs.getDirectoryCount());
        InputSplit[] splits = inputFormat.getSplits(this.job, 2);
        log.info((Object)("Number of splits: " + splits.length));
        ArrayList<String> received = new ArrayList<String>();
        for (InputSplit split : splits) {
            RecordReader reader = inputFormat.getRecordReader(split, this.job, this.reporter);
            LongWritable key = (LongWritable)reader.createKey();
            Text value = (Text)reader.createValue();
            while (reader.next((Object)key, (Object)value)) {
                received.add(value.toString());
            }
            reader.close();
        }
        ArrayList expected = new ArrayList();
        TestSymlinkTextInputFormat.assertEquals(expected, received);
    }

    public void testFailure() {
        SymlinkTextInputFormat inputFormat = new SymlinkTextInputFormat();
        try {
            inputFormat.getSplits(this.job, 2);
            TestSymlinkTextInputFormat.fail((String)"IOException expected if no job input paths specified.");
        }
        catch (IOException e) {
            TestSymlinkTextInputFormat.assertEquals((String)"Incorrect exception message for no job input paths error.", (String)"No input paths specified in job.", (String)e.getMessage());
        }
    }

    private void writeTextFile(Path file, String content) throws IOException {
        OutputStreamWriter writer = new OutputStreamWriter((OutputStream)this.fileSystem.create(file));
        writer.write(content);
        writer.close();
    }

    private void writeSymlinkFile(Path symlinkFile, Path ... paths) throws IOException {
        OutputStreamWriter writer = new OutputStreamWriter((OutputStream)this.fileSystem.create(symlinkFile));
        for (Path path : paths) {
            writer.write(path.toString());
            writer.write("\n");
        }
        writer.close();
    }
}

