/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.udf.generic;

import org.apache.hadoop.hive.common.type.HiveDecimal;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.session.SessionState;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDF;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFOPPlus;
import org.apache.hadoop.hive.ql.udf.generic.TestGenericUDFOPNumeric;
import org.apache.hadoop.hive.serde2.io.ByteWritable;
import org.apache.hadoop.hive.serde2.io.DoubleWritable;
import org.apache.hadoop.hive.serde2.io.HiveDecimalWritable;
import org.apache.hadoop.hive.serde2.io.HiveVarcharWritable;
import org.apache.hadoop.hive.serde2.io.ShortWritable;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.PrimitiveObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.PrimitiveObjectInspectorFactory;
import org.apache.hadoop.hive.serde2.typeinfo.PrimitiveTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfoFactory;
import org.apache.hadoop.io.FloatWritable;
import org.apache.hadoop.io.IntWritable;
import org.apache.hadoop.io.LongWritable;
import org.junit.Assert;
import org.junit.Test;

public class TestGenericUDFOPPlus
extends TestGenericUDFOPNumeric {
    @Test
    public void testBytePlusShort() throws HiveException {
        GenericUDFOPPlus udf = new GenericUDFOPPlus();
        ByteWritable left = new ByteWritable(4);
        ShortWritable right = new ShortWritable(6);
        ObjectInspector[] inputOIs = new ObjectInspector[]{PrimitiveObjectInspectorFactory.writableByteObjectInspector, PrimitiveObjectInspectorFactory.writableShortObjectInspector};
        GenericUDF.DeferredObject[] args = new GenericUDF.DeferredObject[]{new GenericUDF.DeferredJavaObject((Object)left), new GenericUDF.DeferredJavaObject((Object)right)};
        PrimitiveObjectInspector oi = (PrimitiveObjectInspector)udf.initialize(inputOIs);
        Assert.assertEquals((Object)oi.getTypeInfo(), (Object)TypeInfoFactory.shortTypeInfo);
        ShortWritable res = (ShortWritable)udf.evaluate(args);
        Assert.assertEquals((long)10L, (long)res.get());
    }

    @Test
    public void testVarcharPlusInt() throws HiveException {
        GenericUDFOPPlus udf = new GenericUDFOPPlus();
        HiveVarcharWritable left = new HiveVarcharWritable();
        left.set("123");
        IntWritable right = new IntWritable(456);
        ObjectInspector[] inputOIs = new ObjectInspector[]{PrimitiveObjectInspectorFactory.writableHiveVarcharObjectInspector, PrimitiveObjectInspectorFactory.writableIntObjectInspector};
        GenericUDF.DeferredObject[] args = new GenericUDF.DeferredObject[]{new GenericUDF.DeferredJavaObject((Object)left), new GenericUDF.DeferredJavaObject((Object)right)};
        PrimitiveObjectInspector oi = (PrimitiveObjectInspector)udf.initialize(inputOIs);
        Assert.assertEquals((Object)oi.getTypeInfo(), (Object)TypeInfoFactory.doubleTypeInfo);
        DoubleWritable res = (DoubleWritable)udf.evaluate(args);
        Assert.assertEquals((Object)new Double(579.0), (Object)new Double(res.get()));
    }

    @Test
    public void testDoublePlusLong() throws HiveException {
        GenericUDFOPPlus udf = new GenericUDFOPPlus();
        DoubleWritable left = new DoubleWritable(4.5);
        LongWritable right = new LongWritable(10L);
        ObjectInspector[] inputOIs = new ObjectInspector[]{PrimitiveObjectInspectorFactory.writableDoubleObjectInspector, PrimitiveObjectInspectorFactory.writableLongObjectInspector};
        GenericUDF.DeferredObject[] args = new GenericUDF.DeferredObject[]{new GenericUDF.DeferredJavaObject((Object)left), new GenericUDF.DeferredJavaObject((Object)right)};
        PrimitiveObjectInspector oi = (PrimitiveObjectInspector)udf.initialize(inputOIs);
        Assert.assertEquals((Object)TypeInfoFactory.doubleTypeInfo, (Object)oi.getTypeInfo());
        DoubleWritable res = (DoubleWritable)udf.evaluate(args);
        Assert.assertEquals((Object)new Double(14.5), (Object)new Double(res.get()));
    }

    @Test
    public void testLongPlusDecimal() throws HiveException {
        GenericUDFOPPlus udf = new GenericUDFOPPlus();
        LongWritable left = new LongWritable(104L);
        HiveDecimalWritable right = new HiveDecimalWritable(HiveDecimal.create((String)"234.97"));
        ObjectInspector[] inputOIs = new ObjectInspector[]{PrimitiveObjectInspectorFactory.writableLongObjectInspector, PrimitiveObjectInspectorFactory.getPrimitiveWritableObjectInspector((PrimitiveTypeInfo)TypeInfoFactory.getDecimalTypeInfo((int)9, (int)4))};
        GenericUDF.DeferredObject[] args = new GenericUDF.DeferredObject[]{new GenericUDF.DeferredJavaObject((Object)left), new GenericUDF.DeferredJavaObject((Object)right)};
        PrimitiveObjectInspector oi = (PrimitiveObjectInspector)udf.initialize(inputOIs);
        Assert.assertEquals((Object)TypeInfoFactory.getDecimalTypeInfo((int)24, (int)4), (Object)oi.getTypeInfo());
        HiveDecimalWritable res = (HiveDecimalWritable)udf.evaluate(args);
        Assert.assertEquals((Object)HiveDecimal.create((String)"338.97"), (Object)res.getHiveDecimal());
    }

    @Test
    public void testFloatPlusFloat() throws HiveException {
        GenericUDFOPPlus udf = new GenericUDFOPPlus();
        FloatWritable f1 = new FloatWritable(4.5f);
        FloatWritable f2 = new FloatWritable(0.0f);
        ObjectInspector[] inputOIs = new ObjectInspector[]{PrimitiveObjectInspectorFactory.writableFloatObjectInspector, PrimitiveObjectInspectorFactory.writableFloatObjectInspector};
        GenericUDF.DeferredObject[] args = new GenericUDF.DeferredObject[]{new GenericUDF.DeferredJavaObject((Object)f1), new GenericUDF.DeferredJavaObject((Object)f2)};
        PrimitiveObjectInspector oi = (PrimitiveObjectInspector)udf.initialize(inputOIs);
        Assert.assertEquals((Object)oi.getTypeInfo(), (Object)TypeInfoFactory.floatTypeInfo);
        FloatWritable res = (FloatWritable)udf.evaluate(args);
        Assert.assertEquals((Object)new Float(4.5), (Object)new Float(res.get()));
    }

    @Test
    public void testDoulePlusDecimal() throws HiveException {
        GenericUDFOPPlus udf = new GenericUDFOPPlus();
        DoubleWritable left = new DoubleWritable(74.52);
        HiveDecimalWritable right = new HiveDecimalWritable(HiveDecimal.create((String)"234.97"));
        ObjectInspector[] inputOIs = new ObjectInspector[]{PrimitiveObjectInspectorFactory.writableDoubleObjectInspector, PrimitiveObjectInspectorFactory.getPrimitiveWritableObjectInspector((PrimitiveTypeInfo)TypeInfoFactory.getDecimalTypeInfo((int)5, (int)2))};
        GenericUDF.DeferredObject[] args = new GenericUDF.DeferredObject[]{new GenericUDF.DeferredJavaObject((Object)left), new GenericUDF.DeferredJavaObject((Object)right)};
        PrimitiveObjectInspector oi = (PrimitiveObjectInspector)udf.initialize(inputOIs);
        Assert.assertEquals((Object)TypeInfoFactory.doubleTypeInfo, (Object)oi.getTypeInfo());
        DoubleWritable res = (DoubleWritable)udf.evaluate(args);
        Assert.assertEquals((Object)new Double(309.49), (Object)new Double(res.get()));
    }

    @Test
    public void testDecimalPlusDecimal() throws HiveException {
        GenericUDFOPPlus udf = new GenericUDFOPPlus();
        HiveDecimalWritable left = new HiveDecimalWritable(HiveDecimal.create((String)"14.5"));
        HiveDecimalWritable right = new HiveDecimalWritable(HiveDecimal.create((String)"234.97"));
        ObjectInspector[] inputOIs = new ObjectInspector[]{PrimitiveObjectInspectorFactory.getPrimitiveWritableObjectInspector((PrimitiveTypeInfo)TypeInfoFactory.getDecimalTypeInfo((int)3, (int)1)), PrimitiveObjectInspectorFactory.getPrimitiveWritableObjectInspector((PrimitiveTypeInfo)TypeInfoFactory.getDecimalTypeInfo((int)5, (int)2))};
        GenericUDF.DeferredObject[] args = new GenericUDF.DeferredObject[]{new GenericUDF.DeferredJavaObject((Object)left), new GenericUDF.DeferredJavaObject((Object)right)};
        PrimitiveObjectInspector oi = (PrimitiveObjectInspector)udf.initialize(inputOIs);
        Assert.assertEquals((Object)TypeInfoFactory.getDecimalTypeInfo((int)6, (int)2), (Object)oi.getTypeInfo());
        HiveDecimalWritable res = (HiveDecimalWritable)udf.evaluate(args);
        Assert.assertEquals((Object)HiveDecimal.create((String)"249.47"), (Object)res.getHiveDecimal());
    }

    @Test
    public void testDecimalPlusDecimalSameParams() throws HiveException {
        GenericUDFOPPlus udf = new GenericUDFOPPlus();
        ObjectInspector[] inputOIs = new ObjectInspector[]{PrimitiveObjectInspectorFactory.getPrimitiveWritableObjectInspector((PrimitiveTypeInfo)TypeInfoFactory.getDecimalTypeInfo((int)5, (int)2)), PrimitiveObjectInspectorFactory.getPrimitiveWritableObjectInspector((PrimitiveTypeInfo)TypeInfoFactory.getDecimalTypeInfo((int)5, (int)2))};
        PrimitiveObjectInspector oi = (PrimitiveObjectInspector)udf.initialize(inputOIs);
        Assert.assertEquals((Object)TypeInfoFactory.getDecimalTypeInfo((int)6, (int)2), (Object)oi.getTypeInfo());
    }

    @Test
    public void testReturnTypeBackwardCompat() throws Exception {
        SessionState.get().getConf().setVar(HiveConf.ConfVars.HIVE_COMPAT, "0.12");
        this.verifyReturnType((GenericUDF)new GenericUDFOPPlus(), "int", "int", "int");
        this.verifyReturnType((GenericUDF)new GenericUDFOPPlus(), "int", "float", "float");
        this.verifyReturnType((GenericUDF)new GenericUDFOPPlus(), "int", "double", "double");
        this.verifyReturnType((GenericUDF)new GenericUDFOPPlus(), "int", "decimal(10,2)", "decimal(13,2)");
        this.verifyReturnType((GenericUDF)new GenericUDFOPPlus(), "float", "float", "float");
        this.verifyReturnType((GenericUDF)new GenericUDFOPPlus(), "float", "double", "double");
        this.verifyReturnType((GenericUDF)new GenericUDFOPPlus(), "float", "decimal(10,2)", "double");
        this.verifyReturnType((GenericUDF)new GenericUDFOPPlus(), "double", "double", "double");
        this.verifyReturnType((GenericUDF)new GenericUDFOPPlus(), "double", "decimal(10,2)", "double");
        this.verifyReturnType((GenericUDF)new GenericUDFOPPlus(), "decimal(10,2)", "decimal(10,2)", "decimal(11,2)");
        SessionState.get().getConf().setVar(HiveConf.ConfVars.HIVE_COMPAT, "latest");
    }

    @Test
    public void testReturnTypeAnsiSql() throws Exception {
        SessionState.get().getConf().setVar(HiveConf.ConfVars.HIVE_COMPAT, "latest");
        this.verifyReturnType((GenericUDF)new GenericUDFOPPlus(), "int", "int", "int");
        this.verifyReturnType((GenericUDF)new GenericUDFOPPlus(), "int", "float", "float");
        this.verifyReturnType((GenericUDF)new GenericUDFOPPlus(), "int", "double", "double");
        this.verifyReturnType((GenericUDF)new GenericUDFOPPlus(), "int", "decimal(10,2)", "decimal(13,2)");
        this.verifyReturnType((GenericUDF)new GenericUDFOPPlus(), "float", "float", "float");
        this.verifyReturnType((GenericUDF)new GenericUDFOPPlus(), "float", "double", "double");
        this.verifyReturnType((GenericUDF)new GenericUDFOPPlus(), "float", "decimal(10,2)", "double");
        this.verifyReturnType((GenericUDF)new GenericUDFOPPlus(), "double", "double", "double");
        this.verifyReturnType((GenericUDF)new GenericUDFOPPlus(), "double", "decimal(10,2)", "double");
        this.verifyReturnType((GenericUDF)new GenericUDFOPPlus(), "decimal(10,2)", "decimal(10,2)", "decimal(11,2)");
    }
}

