/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.persistence;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Random;
import org.apache.hadoop.hive.ql.exec.persistence.BytesBytesMultiHashMap;
import org.apache.hadoop.hive.serde2.ByteStream;
import org.apache.hadoop.hive.serde2.SerDeException;
import org.apache.hadoop.hive.serde2.WriteBuffers;
import org.apache.hadoop.hive.serde2.lazybinary.LazyBinaryUtils;
import org.junit.Assert;
import org.junit.Test;

public class TestBytesBytesMultiHashMap {
    private static final float LOAD_FACTOR = 0.75f;
    private static final int CAPACITY = 8;
    private static final int WB_SIZE = 128;

    @Test
    public void testCapacityValidation() {
        BytesBytesMultiHashMap map = new BytesBytesMultiHashMap(8, 0.75f, 128);
        Assert.assertEquals((long)8L, (long)map.getCapacity());
        map = new BytesBytesMultiHashMap(9, 0.75f, 128);
        Assert.assertEquals((long)16L, (long)map.getCapacity());
    }

    @Test
    public void testPutGetOne() throws Exception {
        BytesBytesMultiHashMap map = new BytesBytesMultiHashMap(8, 0.75f, 128);
        RandomKvSource kv = new RandomKvSource(0, 0);
        map.put((BytesBytesMultiHashMap.KvSource)kv);
        this.verifyResults(map, kv.getLastKey(), new byte[][]{kv.getLastValue()});
        kv = new RandomKvSource(10, 100);
        map.put((BytesBytesMultiHashMap.KvSource)kv);
        this.verifyResults(map, kv.getLastKey(), new byte[][]{kv.getLastValue()});
    }

    @Test
    public void testPutGetMultiple() throws Exception {
        BytesBytesMultiHashMap map = new BytesBytesMultiHashMap(8, 0.75f, 128);
        RandomKvSource kv = new RandomKvSource(0, 100);
        map.put((BytesBytesMultiHashMap.KvSource)kv);
        this.verifyResults(map, kv.getLastKey(), new byte[][]{kv.getLastValue()});
        FixedKeyKvSource kv2 = new FixedKeyKvSource(kv.getLastKey(), 0, 100);
        kv2.values.add(kv.getLastValue());
        for (int i = 0; i < 3; ++i) {
            map.put((BytesBytesMultiHashMap.KvSource)kv2);
            this.verifyResults(map, kv2.key, (byte[][])kv2.values.toArray((T[])new byte[kv2.values.size()][]));
        }
    }

    @Test
    public void testGetNonExistent() throws Exception {
        BytesBytesMultiHashMap map = new BytesBytesMultiHashMap(8, 0.75f, 128);
        RandomKvSource kv = new RandomKvSource(1, 100);
        map.put((BytesBytesMultiHashMap.KvSource)kv);
        byte[] key = kv.getLastKey();
        key[0] = (byte)(key[0] + 1);
        FixedKeyKvSource kv2 = new FixedKeyKvSource(kv.getLastKey(), 0, 100);
        map.put((BytesBytesMultiHashMap.KvSource)kv2);
        key[0] = (byte)(key[0] + 1);
        ArrayList results = new ArrayList(0);
        map.getValueRefs(key, key.length, results);
        Assert.assertTrue((boolean)results.isEmpty());
        map.getValueRefs(key, 0, results);
        Assert.assertTrue((boolean)results.isEmpty());
    }

    @Test
    public void testPutWithFullMap() throws Exception {
        int i;
        BytesBytesMultiHashMap map = new BytesBytesMultiHashMap(8, 1.0f, 128);
        UniqueKeysKvSource kv = new UniqueKeysKvSource();
        for (i = 0; i < 8; ++i) {
            map.put((BytesBytesMultiHashMap.KvSource)kv);
        }
        for (i = 0; i < kv.keys.size(); ++i) {
            this.verifyResults(map, (byte[])kv.keys.get(i), new byte[][]{(byte[])kv.values.get(i)});
        }
        Assert.assertEquals((long)8L, (long)map.getCapacity());
        ArrayList results = new ArrayList(0);
        map.getValueRefs(new byte[0], 0, results);
        Assert.assertTrue((boolean)results.isEmpty());
    }

    @Test
    public void testExpand() throws Exception {
        BytesBytesMultiHashMap map = new BytesBytesMultiHashMap(1, 1.0E-7f, 128);
        UniqueKeysKvSource kv = new UniqueKeysKvSource();
        for (int i = 0; i < 18; ++i) {
            map.put((BytesBytesMultiHashMap.KvSource)kv);
            for (int j = 0; j <= i; ++j) {
                this.verifyResults(map, (byte[])kv.keys.get(j), new byte[][]{(byte[])kv.values.get(j)});
            }
        }
        Assert.assertEquals((long)262144L, (long)map.getCapacity());
    }

    private void verifyResults(BytesBytesMultiHashMap map, byte[] key, byte[] ... values) {
        int i;
        ArrayList results = new ArrayList(0);
        byte state = map.getValueRefs(key, key.length, results);
        Assert.assertEquals((long)state, (long)results.size());
        Assert.assertEquals((long)values.length, (long)results.size());
        HashSet<ByteBuffer> hs = new HashSet<ByteBuffer>();
        for (i = 0; i < results.size(); ++i) {
            WriteBuffers.ByteSegmentRef result = (WriteBuffers.ByteSegmentRef)results.get(i);
            map.populateValue(result);
            hs.add(result.copy());
        }
        for (i = 0; i < values.length; ++i) {
            Assert.assertTrue((boolean)hs.contains(ByteBuffer.wrap(values[i])));
        }
    }

    private static class RandomKvSource
    implements BytesBytesMultiHashMap.KvSource {
        private int minLength;
        private int maxLength;
        private final Random rdm = new Random(43L);
        public List<byte[]> keys = new ArrayList<byte[]>();
        public List<byte[]> values = new ArrayList<byte[]>();

        public RandomKvSource(int minLength, int maxLength) {
            this.minLength = minLength;
            this.maxLength = maxLength;
        }

        public byte[] getLastValue() {
            return this.values.get(this.values.size() - 1);
        }

        public byte[] getLastKey() {
            return this.keys.get(this.keys.size() - 1);
        }

        public void writeKey(ByteStream.RandomAccessOutput dest) throws SerDeException {
            this.keys.add(this.write(dest));
        }

        public void writeValue(ByteStream.RandomAccessOutput dest) throws SerDeException {
            this.values.add(this.write(dest));
        }

        protected byte[] write(ByteStream.RandomAccessOutput dest) {
            byte[] bytes = new byte[this.minLength + this.rdm.nextInt(this.maxLength - this.minLength + 1)];
            this.rdm.nextBytes(bytes);
            try {
                dest.write(bytes);
            }
            catch (IOException e) {
                e.printStackTrace();
                Assert.fail((String)("Thrown " + e.getMessage()));
            }
            return bytes;
        }

        public byte updateStateByte(Byte previousValue) {
            return (byte)(previousValue == null ? 1 : previousValue + 1);
        }
    }

    private static class UniqueKeysKvSource
    extends RandomKvSource {
        private long lastKey = -1L;
        private byte[] buffer = new byte[9];
        private byte[] lastBuffer;

        public UniqueKeysKvSource() {
            super(0, 0);
        }

        @Override
        public void writeKey(ByteStream.RandomAccessOutput dest) throws SerDeException {
            this.lastKey += 465623573L;
            int len = LazyBinaryUtils.writeVLongToByteArray((byte[])this.buffer, (long)this.lastKey);
            this.lastBuffer = Arrays.copyOf(this.buffer, len);
            this.keys.add(this.lastBuffer);
            this.writeLastBuffer(dest);
        }

        private void writeLastBuffer(ByteStream.RandomAccessOutput dest) {
            try {
                dest.write(this.lastBuffer);
            }
            catch (IOException e) {
                e.printStackTrace();
                Assert.fail((String)("Thrown " + e.getMessage()));
            }
        }

        @Override
        public void writeValue(ByteStream.RandomAccessOutput dest) throws SerDeException {
            this.values.add(this.lastBuffer);
            this.writeLastBuffer(dest);
        }
    }

    private static class FixedKeyKvSource
    extends RandomKvSource {
        private byte[] key;

        public FixedKeyKvSource(byte[] key, int minLength, int maxLength) {
            super(minLength, maxLength);
            this.key = key;
        }

        @Override
        public void writeKey(ByteStream.RandomAccessOutput dest) throws SerDeException {
            try {
                dest.write(this.key);
            }
            catch (IOException e) {
                e.printStackTrace();
                Assert.fail((String)("Thrown " + e.getMessage()));
            }
        }
    }
}

