/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.tez;

import java.util.ArrayList;
import java.util.Random;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.exec.tez.TestTezSessionState;
import org.apache.hadoop.hive.ql.exec.tez.TezSessionPoolManager;
import org.apache.hadoop.hive.ql.exec.tez.TezSessionState;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;

public class TestTezSessionPool {
    HiveConf conf;
    Random random;
    private TezSessionPoolManager poolManager;

    @Before
    public void setUp() {
        this.conf = new HiveConf();
    }

    @Test
    public void testGetNonDefaultSession() {
        this.poolManager = new TestTezSessionPoolManager();
        try {
            TezSessionState sessionState = this.poolManager.getSession(null, this.conf, true);
            TezSessionState sessionState1 = this.poolManager.getSession(sessionState, this.conf, true);
            if (sessionState1 != sessionState) {
                Assert.fail();
            }
            this.conf.set("tez.queue.name", "nondefault");
            TezSessionState sessionState2 = this.poolManager.getSession(sessionState, this.conf, true);
            if (sessionState2 == sessionState) {
                Assert.fail();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail();
        }
    }

    @Test
    public void testSessionPoolGetInOrder() {
        try {
            this.conf.setBoolVar(HiveConf.ConfVars.HIVE_SERVER2_ENABLE_DOAS, false);
            this.conf.setVar(HiveConf.ConfVars.HIVE_SERVER2_TEZ_DEFAULT_QUEUES, "a,b,c");
            this.conf.setIntVar(HiveConf.ConfVars.HIVE_SERVER2_TEZ_SESSIONS_PER_DEFAULT_QUEUE, 2);
            this.poolManager = new TestTezSessionPoolManager();
            this.poolManager.setupPool(this.conf);
            this.poolManager.startPool();
            TezSessionState sessionState = this.poolManager.getSession(null, this.conf, true);
            if (sessionState.getQueueName().compareTo("a") != 0) {
                Assert.fail();
            }
            this.poolManager.returnSession(sessionState);
            sessionState = this.poolManager.getSession(null, this.conf, true);
            if (sessionState.getQueueName().compareTo("b") != 0) {
                Assert.fail();
            }
            this.poolManager.returnSession(sessionState);
            sessionState = this.poolManager.getSession(null, this.conf, true);
            if (sessionState.getQueueName().compareTo("c") != 0) {
                Assert.fail();
            }
            this.poolManager.returnSession(sessionState);
            sessionState = this.poolManager.getSession(null, this.conf, true);
            if (sessionState.getQueueName().compareTo("a") != 0) {
                Assert.fail();
            }
            this.poolManager.returnSession(sessionState);
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail();
        }
    }

    @Test
    public void testReturn() {
        this.conf.set("tez.queue.name", "");
        this.random = new Random(1000L);
        this.conf.setBoolVar(HiveConf.ConfVars.HIVE_SERVER2_ENABLE_DOAS, false);
        this.conf.setVar(HiveConf.ConfVars.HIVE_SERVER2_TEZ_DEFAULT_QUEUES, "a,b,c");
        this.conf.setIntVar(HiveConf.ConfVars.HIVE_SERVER2_TEZ_SESSIONS_PER_DEFAULT_QUEUE, 2);
        try {
            this.poolManager = new TestTezSessionPoolManager();
            this.poolManager.setupPool(this.conf);
            this.poolManager.startPool();
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail();
        }
        ArrayList threadList = new ArrayList();
        for (int i = 0; i < 15; ++i) {
            Thread t = new Thread(new SessionThread());
            t.start();
        }
        for (Thread t : threadList) {
            try {
                t.join();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
                Assert.fail();
            }
        }
    }

    @Test
    public void testCloseAndOpenDefault() throws Exception {
        this.poolManager = new TestTezSessionPoolManager();
        TezSessionState session = (TezSessionState)Mockito.mock(TezSessionState.class);
        Mockito.when((Object)session.isDefault()).thenReturn((Object)false);
        this.poolManager.closeAndOpen(session, this.conf, false);
        ((TezSessionState)Mockito.verify((Object)session)).close(false);
        ((TezSessionState)Mockito.verify((Object)session)).open(this.conf, null);
    }

    @Test
    public void testCloseAndOpenWithResources() throws Exception {
        this.poolManager = new TestTezSessionPoolManager();
        TezSessionState session = (TezSessionState)Mockito.mock(TezSessionState.class);
        Mockito.when((Object)session.isDefault()).thenReturn((Object)false);
        String[] extraResources = new String[]{"file:///tmp/foo.jar"};
        this.poolManager.closeAndOpen(session, this.conf, extraResources, false);
        ((TezSessionState)Mockito.verify((Object)session)).close(false);
        ((TezSessionState)Mockito.verify((Object)session)).open(this.conf, extraResources);
    }

    public class SessionThread
    implements Runnable {
        @Override
        public void run() {
            try {
                HiveConf tmpConf = new HiveConf(TestTezSessionPool.this.conf);
                if (TestTezSessionPool.this.random.nextDouble() > 0.5) {
                    tmpConf.set("tez.queue.name", "default");
                } else {
                    tmpConf.set("tez.queue.name", "");
                }
                TezSessionState session = TestTezSessionPool.this.poolManager.getSession(null, tmpConf, true);
                Thread.sleep(TestTezSessionPool.this.random.nextInt(9) % 10 * 1000);
                TestTezSessionPool.this.poolManager.returnSession(session);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private class TestTezSessionPoolManager
    extends TezSessionPoolManager {
        public TezSessionState createSession(String sessionId) {
            return new TestTezSessionState(sessionId);
        }
    }
}

