/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec;

import java.util.Arrays;
import junit.framework.TestCase;
import org.apache.hadoop.hive.ql.exec.PartitionKeySampler;

public class TestPartitionKeySampler
extends TestCase {
    private static final byte[] _100 = "100".getBytes();
    private static final byte[] _200 = "200".getBytes();
    private static final byte[] _300 = "300".getBytes();
    private static final byte[] _400 = "400".getBytes();

    public void test() throws Throwable {
        byte[][] sampled = new byte[][]{_100, _100, _100, _100, _100, _100, _100, _100, _100, _100};
        this.assertKeys(sampled, new byte[][]{_100});
        sampled = new byte[][]{_100, _100, _100, _100, _100, _100, _100, _100, _200, _200};
        this.assertKeys(sampled, _100, _200);
        sampled = new byte[][]{_100, _100, _100, _100, _200, _200, _200, _300, _300, _300};
        this.assertKeys(sampled, _100, _200, _300);
        sampled = new byte[][]{_100, _200, _200, _200, _200, _200, _200, _300, _300, _400};
        this.assertKeys(sampled, _200, _300, _400);
        sampled = new byte[][]{_100, _200, _300, _400, _400, _400, _400, _400, _400, _400};
        this.assertKeys(sampled, new byte[][]{_400});
    }

    private void assertKeys(byte[][] sampled, byte[] ... expected) {
        byte[][] keys = PartitionKeySampler.toPartitionKeys((byte[][])sampled, (int)4);
        TestPartitionKeySampler.assertEquals((int)expected.length, (int)keys.length);
        for (int i = 0; i < expected.length; ++i) {
            TestPartitionKeySampler.assertTrue((boolean)Arrays.equals(expected[i], keys[i]));
        }
    }
}

