/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.serde2.objectinspector.primitive;

import org.apache.hadoop.hive.serde2.lazy.ByteArrayRef;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.AbstractPrimitiveJavaObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.PrimitiveObjectInspectorUtils;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.SettableBinaryObjectInspector;
import org.apache.hadoop.io.BytesWritable;

public class JavaBinaryObjectInspector
extends AbstractPrimitiveJavaObjectInspector
implements SettableBinaryObjectInspector {
    JavaBinaryObjectInspector() {
        super(PrimitiveObjectInspectorUtils.binaryTypeEntry);
    }

    @Override
    public ByteArrayRef copyObject(Object o) {
        if (null == o) {
            return null;
        }
        ByteArrayRef ba = new ByteArrayRef();
        byte[] incoming = ((ByteArrayRef)o).getData();
        byte[] outgoing = new byte[incoming.length];
        System.arraycopy(incoming, 0, outgoing, 0, incoming.length);
        ba.setData(outgoing);
        return ba;
    }

    @Override
    public BytesWritable getPrimitiveWritableObject(Object o) {
        return o == null ? null : new BytesWritable(((ByteArrayRef)o).getData());
    }

    @Override
    public ByteArrayRef getPrimitiveJavaObject(Object o) {
        return (ByteArrayRef)o;
    }

    @Override
    public ByteArrayRef set(Object o, ByteArrayRef bb) {
        ByteArrayRef ba = (ByteArrayRef)o;
        ba.setData(bb.getData());
        return ba;
    }

    @Override
    public ByteArrayRef set(Object o, BytesWritable bw) {
        if (null == bw) {
            return null;
        }
        ByteArrayRef ba = (ByteArrayRef)o;
        ba.setData(bw.getBytes());
        return ba;
    }

    @Override
    public ByteArrayRef create(ByteArrayRef bb) {
        ByteArrayRef ba = new ByteArrayRef();
        ba.setData(bb.getData());
        return ba;
    }

    @Override
    public ByteArrayRef create(BytesWritable bw) {
        if (null == bw) {
            return null;
        }
        ByteArrayRef ba = new ByteArrayRef();
        ba.setData(bw.getBytes());
        return ba;
    }
}

