/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.parse;

import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import org.antlr.runtime.tree.CommonTree;
import org.antlr.runtime.tree.Tree;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.api.FieldSchema;
import org.apache.hadoop.hive.metastore.api.Order;
import org.apache.hadoop.hive.ql.Context;
import org.apache.hadoop.hive.ql.QueryProperties;
import org.apache.hadoop.hive.ql.exec.FetchTask;
import org.apache.hadoop.hive.ql.exec.Task;
import org.apache.hadoop.hive.ql.exec.Utilities;
import org.apache.hadoop.hive.ql.hooks.LineageInfo;
import org.apache.hadoop.hive.ql.hooks.ReadEntity;
import org.apache.hadoop.hive.ql.hooks.WriteEntity;
import org.apache.hadoop.hive.ql.io.IgnoreKeyTextOutputFormat;
import org.apache.hadoop.hive.ql.io.RCFileInputFormat;
import org.apache.hadoop.hive.ql.io.RCFileOutputFormat;
import org.apache.hadoop.hive.ql.metadata.Hive;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.metadata.InvalidTableException;
import org.apache.hadoop.hive.ql.metadata.Partition;
import org.apache.hadoop.hive.ql.metadata.Table;
import org.apache.hadoop.hive.ql.parse.ASTNode;
import org.apache.hadoop.hive.ql.parse.DDLSemanticAnalyzer;
import org.apache.hadoop.hive.ql.parse.ErrorMsg;
import org.apache.hadoop.hive.ql.parse.SemanticAnalyzer;
import org.apache.hadoop.hive.ql.parse.SemanticException;
import org.apache.hadoop.hive.ql.plan.PlanUtils;
import org.apache.hadoop.hive.ql.session.SessionState;
import org.apache.hadoop.hive.serde2.columnar.ColumnarSerDe;
import org.apache.hadoop.mapred.SequenceFileInputFormat;
import org.apache.hadoop.mapred.SequenceFileOutputFormat;
import org.apache.hadoop.mapred.TextInputFormat;

public abstract class BaseSemanticAnalyzer {
    protected final Hive db;
    protected final HiveConf conf;
    protected List<Task<? extends Serializable>> rootTasks;
    protected FetchTask fetchTask;
    protected final Log LOG;
    protected final SessionState.LogHelper console;
    protected Context ctx;
    protected HashMap<String, String> idToTableNameMap;
    protected QueryProperties queryProperties;
    public static int HIVE_COLUMN_ORDER_ASC = 1;
    public static int HIVE_COLUMN_ORDER_DESC = 0;
    protected HashSet<ReadEntity> inputs;
    protected HashSet<WriteEntity> outputs;
    protected LineageInfo linfo;
    protected static final String TEXTFILE_INPUT = TextInputFormat.class.getName();
    protected static final String TEXTFILE_OUTPUT = IgnoreKeyTextOutputFormat.class.getName();
    protected static final String SEQUENCEFILE_INPUT = SequenceFileInputFormat.class.getName();
    protected static final String SEQUENCEFILE_OUTPUT = SequenceFileOutputFormat.class.getName();
    protected static final String RCFILE_INPUT = RCFileInputFormat.class.getName();
    protected static final String RCFILE_OUTPUT = RCFileOutputFormat.class.getName();
    protected static final String COLUMNAR_SERDE = ColumnarSerDe.class.getName();

    public BaseSemanticAnalyzer(HiveConf conf) throws SemanticException {
        try {
            this.conf = conf;
            this.db = Hive.get(conf);
            this.rootTasks = new ArrayList<Task<? extends Serializable>>();
            this.LOG = LogFactory.getLog((String)this.getClass().getName());
            this.console = new SessionState.LogHelper(this.LOG);
            this.idToTableNameMap = new HashMap();
            this.inputs = new LinkedHashSet<ReadEntity>();
            this.outputs = new LinkedHashSet<WriteEntity>();
        }
        catch (Exception e) {
            throw new SemanticException(e);
        }
    }

    public HashMap<String, String> getIdToTableNameMap() {
        return this.idToTableNameMap;
    }

    public abstract void analyzeInternal(ASTNode var1) throws SemanticException;

    public void analyze(ASTNode ast, Context ctx) throws SemanticException {
        this.ctx = ctx;
        this.analyzeInternal(ast);
    }

    public void validate() throws SemanticException {
    }

    public List<Task<? extends Serializable>> getRootTasks() {
        return this.rootTasks;
    }

    public FetchTask getFetchTask() {
        return this.fetchTask;
    }

    public void setFetchTask(FetchTask fetchTask) {
        this.fetchTask = fetchTask;
    }

    protected void reset() {
        this.rootTasks = new ArrayList<Task<? extends Serializable>>();
    }

    public static String stripQuotes(String val) {
        return PlanUtils.stripQuotes(val);
    }

    public static String charSetString(String charSetName, String charSetString) throws SemanticException {
        try {
            charSetName = charSetName.substring(1);
            if (charSetString.charAt(0) == '\'') {
                return new String(BaseSemanticAnalyzer.unescapeSQLString(charSetString).getBytes(), charSetName);
            }
            assert (charSetString.charAt(0) == '0');
            assert (charSetString.charAt(1) == 'x');
            charSetString = charSetString.substring(2);
            byte[] bArray = new byte[charSetString.length() / 2];
            int j = 0;
            for (int i = 0; i < charSetString.length(); i += 2) {
                int val = Character.digit(charSetString.charAt(i), 16) * 16 + Character.digit(charSetString.charAt(i + 1), 16);
                if (val > 127) {
                    val -= 256;
                }
                bArray[j++] = (byte)val;
            }
            String res = new String(bArray, charSetName);
            return res;
        }
        catch (UnsupportedEncodingException e) {
            throw new SemanticException(e);
        }
    }

    public static String getUnescapedName(ASTNode tableNameNode) {
        if (tableNameNode.getToken().getType() == 231) {
            if (tableNameNode.getChildCount() == 2) {
                String dbName = BaseSemanticAnalyzer.unescapeIdentifier(tableNameNode.getChild(0).getText());
                String tableName = BaseSemanticAnalyzer.unescapeIdentifier(tableNameNode.getChild(1).getText());
                return dbName + "." + tableName;
            }
            return BaseSemanticAnalyzer.unescapeIdentifier(tableNameNode.getChild(0).getText());
        }
        return BaseSemanticAnalyzer.unescapeIdentifier(tableNameNode.getText());
    }

    public static String unescapeIdentifier(String val) {
        if (val == null) {
            return null;
        }
        if (val.charAt(0) == '`' && val.charAt(val.length() - 1) == '`') {
            val = val.substring(1, val.length() - 1);
        }
        return val;
    }

    public static void readProps(ASTNode prop, Map<String, String> mapProp) {
        for (int propChild = 0; propChild < prop.getChildCount(); ++propChild) {
            String key = BaseSemanticAnalyzer.unescapeSQLString(prop.getChild(propChild).getChild(0).getText());
            String value = BaseSemanticAnalyzer.unescapeSQLString(prop.getChild(propChild).getChild(1).getText());
            mapProp.put(key, value);
        }
    }

    public static String unescapeSQLString(String b) {
        Character enclosure = null;
        StringBuilder sb = new StringBuilder(b.length());
        for (int i = 0; i < b.length(); ++i) {
            char currentChar = b.charAt(i);
            if (enclosure == null) {
                if (currentChar != '\'' && b.charAt(i) != '\"') continue;
                enclosure = Character.valueOf(currentChar);
                continue;
            }
            if (enclosure.equals(Character.valueOf(currentChar))) {
                enclosure = null;
                continue;
            }
            if (currentChar == '\\' && i + 4 < b.length()) {
                char i1 = b.charAt(i + 1);
                char i2 = b.charAt(i + 2);
                char i3 = b.charAt(i + 3);
                if (i1 >= '0' && i1 <= '1' && i2 >= '0' && i2 <= '7' && i3 >= '0' && i3 <= '7') {
                    byte bVal = (byte)(i3 - 48 + (i2 - 48) * 8 + (i1 - 48) * 8 * 8);
                    byte[] bValArr = new byte[]{bVal};
                    String tmp = new String(bValArr);
                    sb.append(tmp);
                    i += 3;
                    continue;
                }
            }
            if (currentChar == '\\' && i + 2 < b.length()) {
                char n = b.charAt(i + 1);
                switch (n) {
                    case '0': {
                        sb.append("\u0000");
                        break;
                    }
                    case '\'': {
                        sb.append("'");
                        break;
                    }
                    case '\"': {
                        sb.append("\"");
                        break;
                    }
                    case 'b': {
                        sb.append("\b");
                        break;
                    }
                    case 'n': {
                        sb.append("\n");
                        break;
                    }
                    case 'r': {
                        sb.append("\r");
                        break;
                    }
                    case 't': {
                        sb.append("\t");
                        break;
                    }
                    case 'Z': {
                        sb.append("\u001a");
                        break;
                    }
                    case '\\': {
                        sb.append("\\");
                        break;
                    }
                    case '%': {
                        sb.append("\\%");
                        break;
                    }
                    case '_': {
                        sb.append("\\_");
                        break;
                    }
                    default: {
                        sb.append(n);
                    }
                }
                ++i;
                continue;
            }
            sb.append(currentChar);
        }
        return sb.toString();
    }

    public HashSet<ReadEntity> getInputs() {
        return this.inputs;
    }

    public HashSet<WriteEntity> getOutputs() {
        return this.outputs;
    }

    public List<FieldSchema> getResultSchema() {
        return null;
    }

    protected List<FieldSchema> getColumns(ASTNode ast) throws SemanticException {
        return BaseSemanticAnalyzer.getColumns(ast, true);
    }

    protected void handleGenericFileFormat(ASTNode node) throws SemanticException {
        ASTNode child = (ASTNode)node.getChild(0);
        throw new SemanticException("Unrecognized file format in STORED AS clause: " + (child == null ? "" : child.getText()));
    }

    public static List<FieldSchema> getColumns(ASTNode ast, boolean lowerCase) throws SemanticException {
        ArrayList<FieldSchema> colList = new ArrayList<FieldSchema>();
        int numCh = ast.getChildCount();
        for (int i = 0; i < numCh; ++i) {
            FieldSchema col = new FieldSchema();
            ASTNode child = (ASTNode)ast.getChild(i);
            String name = child.getChild(0).getText();
            if (lowerCase) {
                name = name.toLowerCase();
            }
            col.setName(BaseSemanticAnalyzer.unescapeIdentifier(name));
            ASTNode typeChild = (ASTNode)child.getChild(1);
            col.setType(BaseSemanticAnalyzer.getTypeStringFromAST(typeChild));
            if (child.getChildCount() == 3) {
                col.setComment(BaseSemanticAnalyzer.unescapeSQLString(child.getChild(2).getText()));
            }
            colList.add(col);
        }
        return colList;
    }

    protected List<String> getColumnNames(ASTNode ast) {
        ArrayList<String> colList = new ArrayList<String>();
        int numCh = ast.getChildCount();
        for (int i = 0; i < numCh; ++i) {
            ASTNode child = (ASTNode)ast.getChild(i);
            colList.add(BaseSemanticAnalyzer.unescapeIdentifier(child.getText()).toLowerCase());
        }
        return colList;
    }

    protected List<Order> getColumnNamesOrder(ASTNode ast) {
        ArrayList<Order> colList = new ArrayList<Order>();
        int numCh = ast.getChildCount();
        for (int i = 0; i < numCh; ++i) {
            ASTNode child = (ASTNode)ast.getChild(i);
            if (child.getToken().getType() == 158) {
                colList.add(new Order(BaseSemanticAnalyzer.unescapeIdentifier(child.getChild(0).getText()).toLowerCase(), HIVE_COLUMN_ORDER_ASC));
                continue;
            }
            colList.add(new Order(BaseSemanticAnalyzer.unescapeIdentifier(child.getChild(0).getText()).toLowerCase(), HIVE_COLUMN_ORDER_DESC));
        }
        return colList;
    }

    protected static String getTypeStringFromAST(ASTNode typeNode) throws SemanticException {
        switch (typeNode.getType()) {
            case 82: {
                return "array<" + BaseSemanticAnalyzer.getTypeStringFromAST((ASTNode)typeNode.getChild(0)) + ">";
            }
            case 84: {
                return "map<" + BaseSemanticAnalyzer.getTypeStringFromAST((ASTNode)typeNode.getChild(0)) + "," + BaseSemanticAnalyzer.getTypeStringFromAST((ASTNode)typeNode.getChild(1)) + ">";
            }
            case 83: {
                return BaseSemanticAnalyzer.getStructTypeStringFromAST(typeNode);
            }
            case 85: {
                return BaseSemanticAnalyzer.getUnionTypeStringFromAST(typeNode);
            }
        }
        return DDLSemanticAnalyzer.getTypeName(typeNode.getType());
    }

    private static String getStructTypeStringFromAST(ASTNode typeNode) throws SemanticException {
        String typeStr = "struct<";
        int children = (typeNode = (ASTNode)typeNode.getChild(0)).getChildCount();
        if (children <= 0) {
            throw new SemanticException("empty struct not allowed.");
        }
        StringBuilder buffer = new StringBuilder(typeStr);
        for (int i = 0; i < children; ++i) {
            ASTNode child = (ASTNode)typeNode.getChild(i);
            buffer.append(BaseSemanticAnalyzer.unescapeIdentifier(child.getChild(0).getText())).append(":");
            buffer.append(BaseSemanticAnalyzer.getTypeStringFromAST((ASTNode)child.getChild(1)));
            if (i >= children - 1) continue;
            buffer.append(",");
        }
        buffer.append(">");
        return buffer.toString();
    }

    private static String getUnionTypeStringFromAST(ASTNode typeNode) throws SemanticException {
        String typeStr = "uniontype<";
        int children = (typeNode = (ASTNode)typeNode.getChild(0)).getChildCount();
        if (children <= 0) {
            throw new SemanticException("empty union not allowed.");
        }
        StringBuilder buffer = new StringBuilder(typeStr);
        for (int i = 0; i < children; ++i) {
            buffer.append(BaseSemanticAnalyzer.getTypeStringFromAST((ASTNode)typeNode.getChild(i)));
            if (i >= children - 1) continue;
            buffer.append(",");
        }
        buffer.append(">");
        typeStr = buffer.toString();
        return typeStr;
    }

    public LineageInfo getLineageInfo() {
        return this.linfo;
    }

    public void setLineageInfo(LineageInfo linfo) {
        this.linfo = linfo;
    }

    protected HashMap<String, String> extractPartitionSpecs(Tree partspec) throws SemanticException {
        LinkedHashMap<String, String> partSpec = new LinkedHashMap<String, String>();
        for (int i = 0; i < partspec.getChildCount(); ++i) {
            CommonTree partspec_val = (CommonTree)partspec.getChild(i);
            String val = BaseSemanticAnalyzer.stripQuotes(partspec_val.getChild(1).getText());
            partSpec.put(partspec_val.getChild(0).getText().toLowerCase(), val);
        }
        return partSpec;
    }

    public final boolean isValidPrefixSpec(Table tTable, Map<String, String> spec) throws HiveException {
        List<FieldSchema> partCols = tTable.getPartitionKeys();
        if (partCols == null || partCols.size() == 0) {
            if (spec != null) {
                throw new HiveException("table is not partitioned but partition spec exists: " + spec);
            }
            return true;
        }
        if (spec == null) {
            throw new HiveException("partition spec is not specified");
        }
        Iterator<String> itrPsKeys = spec.keySet().iterator();
        for (FieldSchema fs : partCols) {
            if (!itrPsKeys.hasNext()) break;
            if (itrPsKeys.next().toLowerCase().equals(fs.getName().toLowerCase())) continue;
            BaseSemanticAnalyzer.ErrorPartSpec(spec, partCols);
        }
        if (itrPsKeys.hasNext()) {
            BaseSemanticAnalyzer.ErrorPartSpec(spec, partCols);
        }
        return true;
    }

    private static void ErrorPartSpec(Map<String, String> partSpec, List<FieldSchema> parts) throws SemanticException {
        StringBuilder sb = new StringBuilder("Partition columns in the table schema are: (");
        for (FieldSchema fs : parts) {
            sb.append(fs.getName()).append(", ");
        }
        sb.setLength(sb.length() - 2);
        sb.append("), while the partitions specified in the query are: (");
        Iterator<String> itrPsKeys = partSpec.keySet().iterator();
        while (itrPsKeys.hasNext()) {
            sb.append(itrPsKeys.next()).append(", ");
        }
        sb.setLength(sb.length() - 2);
        sb.append(").");
        throw new SemanticException(ErrorMsg.PARTSPEC_DIFFER_FROM_SCHEMA.getMsg(sb.toString()));
    }

    public Hive getDb() {
        return this.db;
    }

    public QueryProperties getQueryProperties() {
        return this.queryProperties;
    }

    public static class tableSpec {
        public String tableName;
        public Table tableHandle;
        public Map<String, String> partSpec;
        public Partition partHandle;
        public int numDynParts;
        public List<Partition> partitions;
        public SpecType specType;

        public tableSpec(Hive db, HiveConf conf, ASTNode ast) throws SemanticException {
            this(db, conf, ast, true, false);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public tableSpec(Hive db, HiveConf conf, ASTNode ast, boolean allowDynamicPartitionsSpec, boolean allowPartialPartitionsSpec) throws SemanticException {
            assert (ast.getToken().getType() == 10 || ast.getToken().getType() == 110 || ast.getToken().getType() == 177 || ast.getToken().getType() == 88);
            int childIndex = 0;
            this.numDynParts = 0;
            try {
                this.tableName = BaseSemanticAnalyzer.getUnescapedName((ASTNode)ast.getChild(0));
                boolean testMode = conf.getBoolVar(HiveConf.ConfVars.HIVETESTMODE);
                if (testMode) {
                    this.tableName = conf.getVar(HiveConf.ConfVars.HIVETESTMODEPREFIX) + this.tableName;
                }
                if (ast.getToken().getType() != 88) {
                    this.tableHandle = db.getTable(this.tableName);
                }
            }
            catch (InvalidTableException ite) {
                throw new SemanticException(ErrorMsg.INVALID_TABLE.getMsg(ast.getChild(0)), ite);
            }
            catch (HiveException e) {
                throw new SemanticException(ErrorMsg.GENERIC_ERROR.getMsg(ast.getChild(childIndex), e.getMessage()), e);
            }
            if (ast.getChildCount() == 2 && ast.getToken().getType() != 88) {
                childIndex = 1;
                ASTNode partspec = (ASTNode)ast.getChild(1);
                this.partitions = new ArrayList<Partition>();
                this.partSpec = new LinkedHashMap<String, String>(partspec.getChildCount());
                for (int i = 0; i < partspec.getChildCount(); ++i) {
                    ASTNode partspec_val = (ASTNode)partspec.getChild(i);
                    String val = null;
                    String colName = BaseSemanticAnalyzer.unescapeIdentifier(partspec_val.getChild(0).getText().toLowerCase());
                    if (partspec_val.getChildCount() < 2) {
                        if (!allowDynamicPartitionsSpec) throw new SemanticException(ErrorMsg.INVALID_PARTITION.getMsg(" - Dynamic partitions not allowed"));
                        ++this.numDynParts;
                    } else {
                        val = BaseSemanticAnalyzer.stripQuotes(partspec_val.getChild(1).getText());
                    }
                    this.partSpec.put(colName, val);
                }
                Utilities.validatePartSpec(this.tableHandle, this.partSpec);
                if (this.numDynParts > 0) {
                    List<FieldSchema> parts = this.tableHandle.getPartitionKeys();
                    int numStaPart = parts.size() - this.numDynParts;
                    if (numStaPart == 0 && conf.getVar(HiveConf.ConfVars.DYNAMICPARTITIONINGMODE).equalsIgnoreCase("strict")) {
                        throw new SemanticException(ErrorMsg.DYNAMIC_PARTITION_STRICT_MODE.getMsg());
                    }
                    if (this.partSpec.keySet().size() != parts.size()) {
                        BaseSemanticAnalyzer.ErrorPartSpec(this.partSpec, parts);
                    }
                    Iterator<String> itrPsKeys = this.partSpec.keySet().iterator();
                    for (FieldSchema fs : parts) {
                        if (itrPsKeys.next().toLowerCase().equals(fs.getName().toLowerCase())) continue;
                        BaseSemanticAnalyzer.ErrorPartSpec(this.partSpec, parts);
                    }
                    for (FieldSchema fs : parts) {
                        if (this.partSpec.get(fs.getName().toLowerCase()) == null) {
                            if (numStaPart <= 0) break;
                            throw new SemanticException(ErrorMsg.PARTITION_DYN_STA_ORDER.getMsg(ast.getChild(childIndex)));
                        }
                        --numStaPart;
                    }
                    this.partHandle = null;
                    this.specType = SpecType.DYNAMIC_PARTITION;
                    return;
                }
                try {
                    if (allowPartialPartitionsSpec) {
                        this.partitions = db.getPartitions(this.tableHandle, this.partSpec);
                    } else {
                        this.partHandle = db.getPartition(this.tableHandle, this.partSpec, false);
                        if (this.partHandle == null) {
                            this.partHandle = new Partition(this.tableHandle, this.partSpec, null);
                        } else {
                            this.partitions.add(this.partHandle);
                        }
                    }
                }
                catch (HiveException e) {
                    throw new SemanticException(ErrorMsg.INVALID_PARTITION.getMsg(ast.getChild(childIndex)), e);
                }
                this.specType = SpecType.STATIC_PARTITION;
                return;
            }
            this.specType = SpecType.TABLE_ONLY;
        }

        public Map<String, String> getPartSpec() {
            return this.partSpec;
        }

        public void setPartSpec(Map<String, String> partSpec) {
            this.partSpec = partSpec;
        }

        public String toString() {
            if (this.partHandle != null) {
                return this.partHandle.toString();
            }
            return this.tableHandle.toString();
        }

        public static enum SpecType {
            TABLE_ONLY,
            STATIC_PARTITION,
            DYNAMIC_PARTITION;

        }
    }

    class StorageFormat {
        String inputFormat = null;
        String outputFormat = null;
        String storageHandler = null;

        StorageFormat() {
        }

        protected boolean fillStorageFormat(ASTNode child, AnalyzeCreateCommonVars shared) {
            boolean storageFormat = false;
            switch (child.getToken().getType()) {
                case 140: {
                    this.inputFormat = SEQUENCEFILE_INPUT;
                    this.outputFormat = SEQUENCEFILE_OUTPUT;
                    storageFormat = true;
                    break;
                }
                case 141: {
                    this.inputFormat = TEXTFILE_INPUT;
                    this.outputFormat = TEXTFILE_OUTPUT;
                    storageFormat = true;
                    break;
                }
                case 142: {
                    this.inputFormat = RCFILE_INPUT;
                    this.outputFormat = RCFILE_OUTPUT;
                    if (shared.serde == null) {
                        shared.serde = COLUMNAR_SERDE;
                    }
                    storageFormat = true;
                    break;
                }
                case 143: {
                    this.inputFormat = BaseSemanticAnalyzer.unescapeSQLString(child.getChild(0).getText());
                    this.outputFormat = BaseSemanticAnalyzer.unescapeSQLString(child.getChild(1).getText());
                    storageFormat = true;
                    break;
                }
                case 150: {
                    this.storageHandler = BaseSemanticAnalyzer.unescapeSQLString(child.getChild(0).getText());
                    if (child.getChildCount() == 2) {
                        BaseSemanticAnalyzer.readProps((ASTNode)child.getChild(1).getChild(0), shared.serdeProps);
                    }
                    storageFormat = true;
                }
            }
            return storageFormat;
        }

        protected void fillDefaultStorageFormat(AnalyzeCreateCommonVars shared) {
            if (this.inputFormat == null && this.storageHandler == null) {
                if ("SequenceFile".equalsIgnoreCase(BaseSemanticAnalyzer.this.conf.getVar(HiveConf.ConfVars.HIVEDEFAULTFILEFORMAT))) {
                    this.inputFormat = SEQUENCEFILE_INPUT;
                    this.outputFormat = SEQUENCEFILE_OUTPUT;
                } else if ("RCFile".equalsIgnoreCase(BaseSemanticAnalyzer.this.conf.getVar(HiveConf.ConfVars.HIVEDEFAULTFILEFORMAT))) {
                    this.inputFormat = RCFILE_INPUT;
                    this.outputFormat = RCFILE_OUTPUT;
                    shared.serde = COLUMNAR_SERDE;
                } else {
                    this.inputFormat = TEXTFILE_INPUT;
                    this.outputFormat = TEXTFILE_OUTPUT;
                }
            }
        }
    }

    class AnalyzeCreateCommonVars {
        String serde = null;
        Map<String, String> serdeProps = new HashMap<String, String>();

        AnalyzeCreateCommonVars() {
        }
    }

    class RowFormatParams {
        String fieldDelim = null;
        String fieldEscape = null;
        String collItemDelim = null;
        String mapKeyDelim = null;
        String lineDelim = null;

        RowFormatParams() {
        }

        protected void analyzeRowFormat(AnalyzeCreateCommonVars shared, ASTNode child) throws SemanticException {
            child = (ASTNode)child.getChild(0);
            int numChildRowFormat = child.getChildCount();
            block6: for (int numC = 0; numC < numChildRowFormat; ++numC) {
                ASTNode rowChild = (ASTNode)child.getChild(numC);
                switch (rowChild.getToken().getType()) {
                    case 136: {
                        this.fieldDelim = BaseSemanticAnalyzer.unescapeSQLString(rowChild.getChild(0).getText());
                        if (rowChild.getChildCount() < 2) continue block6;
                        this.fieldEscape = BaseSemanticAnalyzer.unescapeSQLString(rowChild.getChild(1).getText());
                        continue block6;
                    }
                    case 137: {
                        this.collItemDelim = BaseSemanticAnalyzer.unescapeSQLString(rowChild.getChild(0).getText());
                        continue block6;
                    }
                    case 138: {
                        this.mapKeyDelim = BaseSemanticAnalyzer.unescapeSQLString(rowChild.getChild(0).getText());
                        continue block6;
                    }
                    case 139: {
                        this.lineDelim = BaseSemanticAnalyzer.unescapeSQLString(rowChild.getChild(0).getText());
                        if (this.lineDelim.equals("\n") || this.lineDelim.equals("10")) continue block6;
                        throw new SemanticException(SemanticAnalyzer.generateErrorMessage(rowChild, ErrorMsg.LINES_TERMINATED_BY_NON_NEWLINE.getMsg()));
                    }
                    default: {
                        assert (false);
                        continue block6;
                    }
                }
            }
        }
    }
}

