/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.persistence;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.FileUtil;
import org.apache.hadoop.fs.LocalFileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.exec.FileSinkOperator;
import org.apache.hadoop.hive.ql.exec.Utilities;
import org.apache.hadoop.hive.ql.exec.persistence.AbstractRowContainer;
import org.apache.hadoop.hive.ql.io.HiveFileFormatUtils;
import org.apache.hadoop.hive.ql.io.HiveOutputFormat;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.plan.TableDesc;
import org.apache.hadoop.hive.serde2.SerDe;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspectorUtils;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.io.WritableComparable;
import org.apache.hadoop.mapred.InputFormat;
import org.apache.hadoop.mapred.InputSplit;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.RecordReader;
import org.apache.hadoop.mapred.Reporter;
import org.apache.hadoop.net.DNS;
import org.apache.hadoop.util.ReflectionUtils;
import org.apache.hadoop.util.StringUtils;

public class RowContainer<Row extends List<Object>>
extends AbstractRowContainer<Row> {
    protected static Log LOG = LogFactory.getLog(RowContainer.class);
    private static final int BLOCKSIZE = 25000;
    private Row[] currentWriteBlock;
    private Row[] currentReadBlock;
    private Row[] firstReadBlockPointer;
    private int blockSize;
    private int numFlushedBlocks;
    private long size;
    private File tmpFile;
    Path tempOutPath = null;
    private File parentFile;
    private int itrCursor;
    private int readBlockSize;
    private int addCursor;
    private SerDe serde;
    private ObjectInspector standardOI;
    private List<Object> keyObject;
    private TableDesc tblDesc;
    boolean firstCalled = false;
    int acutalSplitNum = 0;
    int currentSplitPointer = 0;
    RecordReader rr = null;
    FileSinkOperator.RecordWriter rw = null;
    InputFormat<WritableComparable, Writable> inputFormat = null;
    InputSplit[] inputSplits = null;
    private Row dummyRow = null;
    Writable val = null;
    Configuration jc;
    JobConf jobCloneUsingLocalFs = null;
    private LocalFileSystem localFs;
    private JobConf jobCloneUsingDfs = null;
    private FileSystem dfs = null;
    private String tmpParentDfs = null;
    private String tmpFileDfs = null;
    private String tmpDirDfs = null;
    private boolean fTmpFileOnDfs = false;
    private final ArrayList<Object> row = new ArrayList(2);

    public RowContainer(Configuration jc) throws HiveException {
        this(25000, jc);
    }

    public RowContainer(int bs, Configuration jc) throws HiveException {
        this.blockSize = bs <= 0 ? 25000 : bs;
        this.size = 0L;
        this.itrCursor = 0;
        this.addCursor = 0;
        this.numFlushedBlocks = 0;
        this.tmpFile = null;
        this.currentWriteBlock = new ArrayList[this.blockSize];
        this.currentReadBlock = this.currentWriteBlock;
        this.firstReadBlockPointer = this.currentReadBlock;
        this.serde = null;
        this.standardOI = null;
        this.jc = jc;
        this.fTmpFileOnDfs = HiveConf.getBoolVar(jc, HiveConf.ConfVars.TMP_MAPRFS_VOLUME);
        if (this.fTmpFileOnDfs) {
            try {
                this.tmpDirDfs = this.getDfsTmpDir();
                this.getDFS().mkdirs(new Path(this.tmpDirDfs));
            }
            catch (Exception ex) {
                LOG.info((Object)"Failed to create temporary directory on MapRFS local volume. Continuing with creating temporary files on local filesystem.");
                LOG.debug((Object)"Error: ", (Throwable)ex);
            }
            if (this.tmpDirDfs == null) {
                this.fTmpFileOnDfs = false;
            }
        }
    }

    private JobConf getLocalFSJobConfClone(Configuration jc) {
        if (this.jobCloneUsingLocalFs == null) {
            this.jobCloneUsingLocalFs = new JobConf(jc);
            HiveConf.setVar((Configuration)this.jobCloneUsingLocalFs, HiveConf.ConfVars.HADOOPFS, Utilities.HADOOP_LOCAL_FS);
        }
        return this.jobCloneUsingLocalFs;
    }

    private JobConf getDFSJobConfClone(Configuration jc) {
        if (this.jobCloneUsingDfs == null) {
            this.jobCloneUsingDfs = new JobConf(jc);
        }
        return this.jobCloneUsingDfs;
    }

    private FileSystem getDFS() {
        if (this.dfs == null) {
            try {
                this.dfs = FileSystem.get((Configuration)this.getDFSJobConfClone(this.jc));
            }
            catch (IOException e) {
                LOG.error((Object)e);
            }
        }
        return this.dfs;
    }

    public void setSerDe(SerDe sd, ObjectInspector oi) {
        this.serde = sd;
        this.standardOI = oi;
    }

    @Override
    public void add(Row t) throws HiveException {
        if (this.tblDesc != null) {
            if (this.addCursor >= this.blockSize) {
                this.spillBlock((List[])this.currentWriteBlock, this.addCursor);
                this.addCursor = 0;
                if (this.numFlushedBlocks == 1) {
                    this.currentWriteBlock = new ArrayList[this.blockSize];
                }
            }
            this.currentWriteBlock[this.addCursor++] = t;
        } else if (t != null) {
            this.dummyRow = t;
        }
        ++this.size;
    }

    @Override
    public Row first() throws HiveException {
        if (this.size == 0L) {
            return null;
        }
        try {
            this.firstCalled = true;
            this.itrCursor = 0;
            this.closeWriter();
            this.closeReader();
            if (this.tblDesc == null) {
                ++this.itrCursor;
                return this.dummyRow;
            }
            this.currentReadBlock = this.firstReadBlockPointer;
            if (this.numFlushedBlocks == 0) {
                this.readBlockSize = this.addCursor;
                this.currentReadBlock = this.currentWriteBlock;
            } else {
                JobConf jobConf = null;
                String tmpFilePathEscaped = null;
                if (this.fTmpFileOnDfs) {
                    jobConf = this.getDFSJobConfClone(this.jc);
                    tmpFilePathEscaped = StringUtils.escapeString((String)this.tmpParentDfs);
                } else {
                    jobConf = this.getLocalFSJobConfClone(this.jc);
                    tmpFilePathEscaped = StringUtils.escapeString((String)this.parentFile.getAbsolutePath());
                }
                if (this.inputSplits == null) {
                    if (this.inputFormat == null) {
                        this.inputFormat = (InputFormat)ReflectionUtils.newInstance(this.tblDesc.getInputFileFormatClass(), (Configuration)jobConf);
                    }
                    HiveConf.setVar((Configuration)jobConf, HiveConf.ConfVars.HADOOPMAPREDINPUTDIR, tmpFilePathEscaped);
                    this.inputSplits = this.inputFormat.getSplits(jobConf, 1);
                    this.acutalSplitNum = this.inputSplits.length;
                }
                this.currentSplitPointer = 0;
                this.rr = this.inputFormat.getRecordReader(this.inputSplits[this.currentSplitPointer], jobConf, Reporter.NULL);
                ++this.currentSplitPointer;
                this.nextBlock();
            }
            Row ret = this.currentReadBlock[this.itrCursor++];
            this.removeKeys(ret);
            return ret;
        }
        catch (Exception e) {
            throw new HiveException(e);
        }
    }

    @Override
    public Row next() throws HiveException {
        if (!this.firstCalled) {
            throw new RuntimeException("Call first() then call next().");
        }
        if (this.size == 0L) {
            return null;
        }
        if (this.tblDesc == null) {
            if ((long)this.itrCursor < this.size) {
                ++this.itrCursor;
                return this.dummyRow;
            }
            return null;
        }
        if (this.itrCursor < this.readBlockSize) {
            Row ret = this.currentReadBlock[this.itrCursor++];
            this.removeKeys(ret);
            return ret;
        }
        this.nextBlock();
        if (this.readBlockSize == 0) {
            if (this.currentWriteBlock != null && this.currentReadBlock != this.currentWriteBlock) {
                this.itrCursor = 0;
                this.readBlockSize = this.addCursor;
                this.firstReadBlockPointer = this.currentReadBlock;
                this.currentReadBlock = this.currentWriteBlock;
            } else {
                return null;
            }
        }
        return (Row)this.next();
    }

    private void removeKeys(Row ret) {
        if (this.keyObject != null && this.currentReadBlock != this.currentWriteBlock) {
            int len = this.keyObject.size();
            int rowSize = ((ArrayList)ret).size();
            for (int i = 0; i < len; ++i) {
                ((ArrayList)ret).remove(rowSize - i - 1);
            }
        }
    }

    public String getDfsTmpDir() {
        if (this.tmpDirDfs != null) {
            return this.tmpDirDfs;
        }
        this.tmpDirDfs = this.jc.get("mapr.localvolumes.path", "/var/mapr/local");
        this.tmpDirDfs = this.tmpDirDfs + "/";
        this.tmpDirDfs = this.tmpDirDfs + this.getMapRHostname();
        this.tmpDirDfs = this.tmpDirDfs + "/mapred/taskTracker/";
        this.tmpDirDfs = this.tmpDirDfs + this.jc.get("mapr.localspill.dir", "spill");
        if (!this.jc.getBoolean("mapreduce.maprfs.use.compression", true)) {
            this.tmpDirDfs = this.tmpDirDfs + ".U";
        }
        String[] workDirSplits = null;
        String workDir = null;
        try {
            workDir = new File(".").getCanonicalPath();
            workDirSplits = workDir.split("/");
        }
        catch (IOException e) {
            LOG.error((Object)e);
        }
        this.tmpDirDfs = this.tmpDirDfs + "/" + workDirSplits[workDirSplits.length - 3];
        this.tmpDirDfs = this.tmpDirDfs + "/" + workDirSplits[workDirSplits.length - 2];
        LOG.debug((Object)("tmpDirDfs: " + this.tmpDirDfs));
        return this.tmpDirDfs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getMapRHostname() {
        String hostName = this.jc.get("slave.host.name");
        if (hostName != null) {
            return hostName;
        }
        String maprHome = System.getProperty("mapr.home.dir");
        if (maprHome == null && (maprHome = System.getenv("MAPR_HOME")) == null) {
            maprHome = "/opt/mapr/";
        }
        String hostNameFile = maprHome + "/hostname";
        BufferedReader breader = null;
        FileReader freader = null;
        try {
            freader = new FileReader(hostNameFile);
            breader = new BufferedReader(freader);
            String string = breader.readLine();
            return string;
        }
        catch (Exception e) {
            if (LOG.isWarnEnabled()) {
                LOG.warn((Object)("Error while reading " + hostNameFile), (Throwable)e);
            }
        }
        finally {
            block28: {
                block27: {
                    try {
                        if (breader != null) {
                            breader.close();
                        }
                    }
                    catch (Throwable t) {
                        if (!LOG.isErrorEnabled()) break block27;
                        LOG.error((Object)"Failed to close breader", t);
                    }
                }
                try {
                    if (freader != null) {
                        freader.close();
                    }
                }
                catch (Throwable t) {
                    if (!LOG.isErrorEnabled()) break block28;
                    LOG.error((Object)("Failed to close " + hostNameFile), t);
                }
            }
        }
        if (hostName == null) {
            try {
                hostName = DNS.getDefaultHost((String)this.jc.get("mapred.tasktracker.dns.interface", "default"), (String)this.jc.get("mapred.tasktracker.dns.nameserver", "default"));
            }
            catch (IOException ioe) {
                if (LOG.isErrorEnabled()) {
                    LOG.error((Object)"Failed to retrieve local host name", (Throwable)ioe);
                }
                throw new RuntimeException(ioe);
            }
        }
        return hostName;
    }

    private void spillBlock(Row[] block, int length) throws HiveException {
        try {
            Writable outVal;
            Row currentValRow;
            if ((this.fTmpFileOnDfs ? this.tmpFileDfs : this.tmpFile) == null) {
                HiveOutputFormat hiveOutputFormat;
                String suffix = ".tmp";
                if (this.keyObject != null) {
                    suffix = "." + this.keyObject.toString() + suffix;
                }
                if (this.fTmpFileOnDfs) {
                    Path tmpParentDfsPath;
                    this.getDFS().mkdirs(new Path(this.getDfsTmpDir()));
                    while (true) {
                        this.tmpParentDfs = this.tmpDirDfs + "/hive-rowcontainer" + new Random().nextInt();
                        tmpParentDfsPath = new Path(this.tmpParentDfs);
                        if (!this.getDFS().exists(tmpParentDfsPath)) break;
                        LOG.debug((Object)"retry creating tmp row-container directory...");
                    }
                    this.getDFS().mkdirs(tmpParentDfsPath);
                    this.tmpFileDfs = this.tmpParentDfs + "/RowContainer" + suffix;
                    LOG.info((Object)("RowContainer created temp file " + this.tmpFileDfs));
                    hiveOutputFormat = this.tblDesc.getOutputFileFormatClass().newInstance();
                    this.tempOutPath = new Path(this.tmpFileDfs.toString());
                    this.rw = HiveFileFormatUtils.getRecordWriter(this.getDFSJobConfClone(this.jc), hiveOutputFormat, this.serde.getSerializedClass(), false, this.tblDesc.getProperties(), this.tempOutPath);
                } else {
                    while (true) {
                        boolean success;
                        this.parentFile = File.createTempFile("hive-rowcontainer", "");
                        boolean bl = success = this.parentFile.delete() && this.parentFile.mkdir();
                        if (success) break;
                        LOG.debug((Object)"retry creating tmp row-container directory...");
                    }
                    this.tmpFile = File.createTempFile("RowContainer", suffix, this.parentFile);
                    LOG.info((Object)("RowContainer created temp file " + this.tmpFile.getAbsolutePath()));
                    this.parentFile.deleteOnExit();
                    this.tmpFile.deleteOnExit();
                    hiveOutputFormat = this.tblDesc.getOutputFileFormatClass().newInstance();
                    this.tempOutPath = new Path(this.tmpFile.toString());
                    JobConf localJc = this.getLocalFSJobConfClone(this.jc);
                    this.rw = HiveFileFormatUtils.getRecordWriter(this.jobCloneUsingLocalFs, hiveOutputFormat, this.serde.getSerializedClass(), false, this.tblDesc.getProperties(), this.tempOutPath);
                }
            } else if (this.rw == null) {
                throw new HiveException("RowContainer has already been closed for writing.");
            }
            this.row.clear();
            this.row.add(null);
            this.row.add(null);
            if (this.keyObject != null) {
                this.row.set(1, this.keyObject);
                for (int i = 0; i < length; ++i) {
                    currentValRow = block[i];
                    this.row.set(0, currentValRow);
                    outVal = this.serde.serialize(this.row, this.standardOI);
                    this.rw.write(outVal);
                }
            } else {
                for (int i = 0; i < length; ++i) {
                    currentValRow = block[i];
                    outVal = this.serde.serialize(currentValRow, this.standardOI);
                    this.rw.write(outVal);
                }
            }
            if (block == this.currentWriteBlock) {
                this.addCursor = 0;
            }
            ++this.numFlushedBlocks;
        }
        catch (Exception e) {
            this.clear();
            LOG.error((Object)e.toString(), (Throwable)e);
            throw new HiveException(e);
        }
    }

    @Override
    public long size() {
        return this.size;
    }

    private boolean nextBlock() throws HiveException {
        this.itrCursor = 0;
        this.readBlockSize = 0;
        if (this.numFlushedBlocks == 0) {
            return false;
        }
        try {
            if (this.val == null) {
                this.val = this.serde.getSerializedClass().newInstance();
            }
            boolean nextSplit = true;
            int i = 0;
            if (this.rr != null) {
                Object key = this.rr.createKey();
                while (i < this.currentReadBlock.length && this.rr.next(key, (Object)this.val)) {
                    nextSplit = false;
                    this.currentReadBlock[i++] = (List)ObjectInspectorUtils.copyToStandardObject(this.serde.deserialize(this.val), this.serde.getObjectInspector(), ObjectInspectorUtils.ObjectInspectorCopyOption.WRITABLE);
                }
            }
            if (nextSplit && this.currentSplitPointer < this.acutalSplitNum) {
                if (this.rr != null) {
                    this.rr.close();
                }
                this.rr = this.inputFormat.getRecordReader(this.inputSplits[this.currentSplitPointer], this.fTmpFileOnDfs ? this.getDFSJobConfClone(this.jc) : this.getLocalFSJobConfClone(this.jc), Reporter.NULL);
                ++this.currentSplitPointer;
                return this.nextBlock();
            }
            this.readBlockSize = i;
            return this.readBlockSize > 0;
        }
        catch (Exception e) {
            LOG.error((Object)e.getMessage(), (Throwable)e);
            try {
                this.clear();
            }
            catch (HiveException e1) {
                LOG.error((Object)e.getMessage(), (Throwable)e);
            }
            throw new HiveException(e);
        }
    }

    public void copyToDFSDirecory(FileSystem destFs, Path destPath) throws IOException, HiveException {
        if (this.addCursor > 0) {
            this.spillBlock((List[])this.currentWriteBlock, this.addCursor);
        }
        if (this.tempOutPath == null || this.tempOutPath.toString().trim().equals("")) {
            return;
        }
        this.closeWriter();
        LOG.info((Object)("RowContainer copied temp file " + (this.fTmpFileOnDfs ? this.tmpFileDfs : this.tmpFile.getAbsolutePath()) + " to dfs directory " + destPath.toString()));
        if (this.fTmpFileOnDfs) {
            FileUtil.copy((FileSystem)this.getDFS(), (Path)this.tempOutPath, (FileSystem)destFs, (Path)new Path(destPath, new Path(this.tempOutPath.getName())), (boolean)false, (Configuration)this.getDFSJobConfClone(this.jc));
        } else {
            destFs.copyFromLocalFile(true, this.tempOutPath, new Path(destPath, new Path(this.tempOutPath.getName())));
        }
        this.clear();
    }

    @Override
    public void clear() throws HiveException {
        this.itrCursor = 0;
        this.addCursor = 0;
        this.numFlushedBlocks = 0;
        this.readBlockSize = 0;
        this.acutalSplitNum = 0;
        this.currentSplitPointer = -1;
        this.firstCalled = false;
        this.inputSplits = null;
        this.tempOutPath = null;
        this.addCursor = 0;
        this.size = 0L;
        try {
            if (this.rw != null) {
                this.rw.close(false);
            }
            if (this.rr != null) {
                this.rr.close();
            }
        }
        catch (Exception e) {
            LOG.error((Object)e.toString());
            throw new HiveException(e);
        }
        finally {
            this.rw = null;
            this.rr = null;
            if (this.fTmpFileOnDfs) {
                try {
                    if (this.tmpParentDfs != null) {
                        this.getDFS().delete(new Path(this.tmpParentDfs), true);
                    }
                }
                catch (IOException e) {
                    LOG.error((Object)e);
                }
                this.tmpParentDfs = null;
                this.tmpFileDfs = null;
                this.tmpDirDfs = null;
            } else {
                this.tmpFile = null;
                this.deleteLocalFile(this.parentFile, true);
                this.parentFile = null;
            }
        }
    }

    private void deleteLocalFile(File file, boolean recursive) {
        try {
            if (file != null) {
                boolean deleteSuccess;
                if (!file.exists()) {
                    return;
                }
                if (file.isDirectory() && recursive) {
                    File[] files;
                    for (File file2 : files = file.listFiles()) {
                        this.deleteLocalFile(file2, true);
                    }
                }
                if (!(deleteSuccess = file.delete())) {
                    LOG.error((Object)("Error deleting tmp file:" + file.getAbsolutePath()));
                }
            }
        }
        catch (Exception e) {
            LOG.error((Object)("Error deleting tmp file:" + file.getAbsolutePath()), (Throwable)e);
        }
    }

    private void closeWriter() throws IOException {
        if (this.rw != null) {
            this.rw.close(false);
            this.rw = null;
        }
    }

    private void closeReader() throws IOException {
        if (this.rr != null) {
            this.rr.close();
            this.rr = null;
        }
    }

    public void setKeyObject(List<Object> dummyKey) {
        this.keyObject = dummyKey;
    }

    public void setTableDesc(TableDesc tblDesc) {
        this.tblDesc = tblDesc;
    }
}

