/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.optimizer;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Stack;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.Context;
import org.apache.hadoop.hive.ql.exec.AbstractMapJoinOperator;
import org.apache.hadoop.hive.ql.exec.Operator;
import org.apache.hadoop.hive.ql.exec.OperatorFactory;
import org.apache.hadoop.hive.ql.exec.Task;
import org.apache.hadoop.hive.ql.exec.TaskFactory;
import org.apache.hadoop.hive.ql.exec.UnionOperator;
import org.apache.hadoop.hive.ql.lib.Node;
import org.apache.hadoop.hive.ql.lib.NodeProcessor;
import org.apache.hadoop.hive.ql.lib.NodeProcessorCtx;
import org.apache.hadoop.hive.ql.optimizer.GenMRProcContext;
import org.apache.hadoop.hive.ql.optimizer.GenMapRedUtils;
import org.apache.hadoop.hive.ql.optimizer.unionproc.UnionProcContext;
import org.apache.hadoop.hive.ql.optimizer.unionproc.UnionProcFactory;
import org.apache.hadoop.hive.ql.parse.ParseContext;
import org.apache.hadoop.hive.ql.parse.SemanticException;
import org.apache.hadoop.hive.ql.plan.FileSinkDesc;
import org.apache.hadoop.hive.ql.plan.MapJoinDesc;
import org.apache.hadoop.hive.ql.plan.MapredWork;
import org.apache.hadoop.hive.ql.plan.PartitionDesc;
import org.apache.hadoop.hive.ql.plan.PlanUtils;
import org.apache.hadoop.hive.ql.plan.TableDesc;
import org.apache.hadoop.hive.ql.plan.TableScanDesc;

public class GenMRUnion1
implements NodeProcessor {
    private Object processMapOnlyUnion(UnionOperator union, Stack<Node> stack, GenMRProcContext ctx, UnionProcContext uCtx) throws SemanticException {
        Task<? extends Serializable> uTask;
        UnionProcContext.UnionParseContext uPrsCtx;
        Task<? extends Serializable> uTask2;
        GenMRProcContext.GenMRUnionCtx uCtxTask = ctx.getUnionTask(union);
        if (uCtxTask != null && (uTask2 = ctx.getUnionTask(union).getUTask()) != null) {
            if (ctx.getCurrTask() != null && ctx.getCurrTask() != uTask2) {
                ctx.getRootTasks().remove(ctx.getCurrTask());
            }
            ctx.setCurrTask(uTask2);
        }
        if ((uPrsCtx = uCtx.getUnionParseContext(union)) != null && uPrsCtx.getMapJoinQuery()) {
            GenMapRedUtils.mergeMapJoinUnion(union, ctx, UnionProcFactory.getPositionParent(union, stack));
        } else {
            ctx.getMapCurrCtx().put(union, new GenMRProcContext.GenMapRedCtx(ctx.getCurrTask(), ctx.getCurrTopOp(), ctx.getCurrAliasId()));
        }
        uCtxTask = ctx.getUnionTask(union);
        if (uCtxTask == null) {
            uCtxTask = new GenMRProcContext.GenMRUnionCtx();
            uCtxTask.setUTask(ctx.getCurrTask());
            ctx.setUnionTask(union, uCtxTask);
        }
        if (((uTask = ctx.getCurrTask()).getParentTasks() == null || uTask.getParentTasks().isEmpty()) && !ctx.getRootTasks().contains(uTask)) {
            ctx.getRootTasks().add(uTask);
        }
        return null;
    }

    private void processSubQueryUnionCreateIntermediate(Operator<? extends Serializable> parent, Operator<? extends Serializable> child, Task<? extends Serializable> uTask, GenMRProcContext ctx, GenMRProcContext.GenMRUnionCtx uCtxTask) {
        ParseContext parseCtx = ctx.getParseCtx();
        TableDesc tt_desc = PlanUtils.getIntermediateFileTableDesc(PlanUtils.getFieldSchemasFromRowSchema(parent.getSchema(), "temporarycol"));
        Context baseCtx = parseCtx.getContext();
        String taskTmpDir = baseCtx.getMRTmpFileURI();
        Operator<FileSinkDesc> fs_op = OperatorFactory.get(new FileSinkDesc(taskTmpDir, tt_desc, parseCtx.getConf().getBoolVar(HiveConf.ConfVars.COMPRESSINTERMEDIATE)), parent.getSchema(), new Operator[0]);
        assert (parent.getChildOperators().size() == 1);
        parent.getChildOperators().set(0, fs_op);
        ArrayList<Operator<? extends Serializable>> parentOpList = new ArrayList<Operator<? extends Serializable>>();
        parentOpList.add(parent);
        fs_op.setParentOperators(parentOpList);
        Operator<TableScanDesc> ts_op = OperatorFactory.get(new TableScanDesc(), parent.getSchema(), new Operator[0]);
        ArrayList<Operator<? extends Serializable>> childOpList = new ArrayList<Operator<? extends Serializable>>();
        childOpList.add(child);
        ts_op.setChildOperators(childOpList);
        child.replaceParent(parent, ts_op);
        uCtxTask.addTaskTmpDir(taskTmpDir);
        uCtxTask.addTTDesc(tt_desc);
        uCtxTask.addListTopOperators(ts_op);
        Task<? extends Serializable> currTask = ctx.getCurrTask();
        currTask.addDependentTask(uTask);
        if (ctx.getRootTasks().contains(uTask)) {
            ctx.getRootTasks().remove(uTask);
            if (!ctx.getRootTasks().contains(currTask)) {
                ctx.getRootTasks().add(currTask);
            }
        }
    }

    private void processSubQueryUnionMerge(GenMRProcContext ctx, GenMRProcContext.GenMRUnionCtx uCtxTask, UnionOperator union, Stack<Node> stack) throws SemanticException {
        Task<? extends Serializable> uTask = uCtxTask.getUTask();
        MapredWork plan = (MapredWork)uTask.getWork();
        ctx.setCurrTask(uTask);
        List<Operator<? extends Serializable>> seenOps = ctx.getSeenOps();
        Operator<? extends Serializable> topOp = ctx.getCurrTopOp();
        if (!seenOps.contains(topOp) && topOp != null) {
            seenOps.add(topOp);
            GenMapRedUtils.setTaskPlan(ctx.getCurrAliasId(), ctx.getCurrTopOp(), plan, false, ctx);
        }
    }

    private void processSubQueryUnionMapJoin(GenMRProcContext ctx) {
        AbstractMapJoinOperator<? extends MapJoinDesc> mjOp = ctx.getCurrMapJoinOp();
        assert (mjOp != null);
        GenMRProcContext.GenMRMapJoinCtx mjCtx = ctx.getMapJoinCtx(mjOp);
        assert (mjCtx != null);
        MapredWork plan = (MapredWork)ctx.getCurrTask().getWork();
        String taskTmpDir = mjCtx.getTaskTmpDir();
        TableDesc tt_desc = mjCtx.getTTDesc();
        assert (plan.getPathToAliases().get(taskTmpDir) == null);
        plan.getPathToAliases().put(taskTmpDir, new ArrayList());
        plan.getPathToAliases().get(taskTmpDir).add(taskTmpDir);
        plan.getPathToPartitionInfo().put(taskTmpDir, new PartitionDesc(tt_desc, null));
        plan.getAliasToWork().put(taskTmpDir, mjCtx.getRootMapJoinOp());
    }

    @Override
    public Object process(Node nd, Stack<Node> stack, NodeProcessorCtx opProcCtx, Object ... nodeOutputs) throws SemanticException {
        UnionOperator union = (UnionOperator)nd;
        GenMRProcContext ctx = (GenMRProcContext)opProcCtx;
        ParseContext parseCtx = ctx.getParseCtx();
        UnionProcContext uCtx = parseCtx.getUCtx();
        LinkedHashMap<Operator<? extends Serializable>, GenMRProcContext.GenMapRedCtx> mapCurrCtx = ctx.getMapCurrCtx();
        UnionProcContext.UnionParseContext uPrsCtx = uCtx.getUnionParseContext(union);
        ctx.setCurrUnionOp(union);
        if (uPrsCtx.allMapOnlySubQ()) {
            return this.processMapOnlyUnion(union, stack, ctx, uCtx);
        }
        assert (uPrsCtx != null);
        Task<? extends Serializable> currTask = ctx.getCurrTask();
        int pos = UnionProcFactory.getPositionParent(union, stack);
        Task<? extends Serializable> uTask = null;
        MapredWork uPlan = null;
        GenMRProcContext.GenMRUnionCtx uCtxTask = ctx.getUnionTask(union);
        if (uCtxTask == null) {
            uCtxTask = new GenMRProcContext.GenMRUnionCtx();
            uPlan = GenMapRedUtils.getMapRedWork(parseCtx);
            uTask = TaskFactory.get(uPlan, parseCtx.getConf(), new Task[0]);
            uCtxTask.setUTask(uTask);
            ctx.setUnionTask(union, uCtxTask);
        } else {
            uTask = uCtxTask.getUTask();
        }
        if (uPrsCtx.getMapOnlySubq(pos) && !uPrsCtx.getMapJoinSubq(pos) && uPrsCtx.getRootTask(pos)) {
            this.processSubQueryUnionMerge(ctx, uCtxTask, union, stack);
        } else {
            if (this.shouldBeRootTask(currTask, parseCtx) && !ctx.getRootTasks().contains(currTask)) {
                ctx.getRootTasks().add(currTask);
            }
            if (uPrsCtx.getMapJoinSubq(pos)) {
                this.processSubQueryUnionMapJoin(ctx);
            }
            this.processSubQueryUnionCreateIntermediate(union.getParentOperators().get(pos), union, uTask, ctx, uCtxTask);
            ctx.setCurrAliasId(null);
            ctx.setCurrTopOp(null);
            ctx.getOpTaskMap().put(null, uTask);
        }
        ctx.setCurrTask(uTask);
        mapCurrCtx.put((Operator)nd, new GenMRProcContext.GenMapRedCtx(ctx.getCurrTask(), null, null));
        return null;
    }

    private boolean shouldBeRootTask(Task<? extends Serializable> currTask, ParseContext parseContext) {
        return currTask.getParentTasks() == null || currTask.getParentTasks().size() == 0;
    }
}

