/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.io;

import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.exec.FileSinkOperator;
import org.apache.hadoop.hive.ql.exec.Operator;
import org.apache.hadoop.hive.ql.exec.Utilities;
import org.apache.hadoop.hive.ql.io.HiveIgnoreKeyTextOutputFormat;
import org.apache.hadoop.hive.ql.io.HiveOutputFormat;
import org.apache.hadoop.hive.ql.io.HiveSequenceFileOutputFormat;
import org.apache.hadoop.hive.ql.io.IgnoreKeyTextOutputFormat;
import org.apache.hadoop.hive.ql.io.InputFormatChecker;
import org.apache.hadoop.hive.ql.io.RCFileInputFormat;
import org.apache.hadoop.hive.ql.io.SequenceFileInputFormatChecker;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.plan.FileSinkDesc;
import org.apache.hadoop.hive.ql.plan.PartitionDesc;
import org.apache.hadoop.hive.ql.plan.TableDesc;
import org.apache.hadoop.io.SequenceFile;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.mapred.FileOutputFormat;
import org.apache.hadoop.mapred.InputFormat;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.OutputFormat;
import org.apache.hadoop.mapred.SequenceFileInputFormat;
import org.apache.hadoop.mapred.SequenceFileOutputFormat;
import org.apache.hadoop.mapred.TextInputFormat;

public final class HiveFileFormatUtils {
    private static Map<Class<? extends OutputFormat>, Class<? extends HiveOutputFormat>> outputFormatSubstituteMap = new HashMap<Class<? extends OutputFormat>, Class<? extends HiveOutputFormat>>();
    private static Map<Class<? extends InputFormat>, Class<? extends InputFormatChecker>> inputFormatCheckerMap;
    private static Map<Class<? extends InputFormatChecker>, InputFormatChecker> inputFormatCheckerInstanceCache;

    public static synchronized void registerOutputFormatSubstitute(Class<? extends OutputFormat> origin, Class<? extends HiveOutputFormat> substitute) {
        outputFormatSubstituteMap.put(origin, substitute);
    }

    public static synchronized Class<? extends HiveOutputFormat> getOutputFormatSubstitute(Class<?> origin) {
        if (HiveOutputFormat.class.isAssignableFrom(origin)) {
            return origin;
        }
        Class<? extends HiveOutputFormat> result = outputFormatSubstituteMap.get(origin);
        return result;
    }

    @Deprecated
    public static Path getOutputFormatFinalPath(Path parent, String taskId, JobConf jc, HiveOutputFormat<?, ?> hiveOutputFormat, boolean isCompressed, Path defaultFinalPath) throws IOException {
        if (hiveOutputFormat instanceof HiveIgnoreKeyTextOutputFormat) {
            return new Path(parent, taskId + Utilities.getFileExtension(jc, isCompressed));
        }
        return defaultFinalPath;
    }

    public static synchronized void registerInputFormatChecker(Class<? extends InputFormat> format, Class<? extends InputFormatChecker> checker) {
        inputFormatCheckerMap.put(format, checker);
    }

    public static synchronized Class<? extends InputFormatChecker> getInputFormatChecker(Class<?> inputFormat) {
        Class<? extends InputFormatChecker> result = inputFormatCheckerMap.get(inputFormat);
        return result;
    }

    public static boolean checkInputFormat(FileSystem fs, HiveConf conf, Class<? extends InputFormat> inputFormatCls, ArrayList<FileStatus> files) throws HiveException {
        if (files.size() > 0) {
            Class<? extends InputFormatChecker> checkerCls = HiveFileFormatUtils.getInputFormatChecker(inputFormatCls);
            if (checkerCls == null && inputFormatCls.isAssignableFrom(TextInputFormat.class)) {
                return HiveFileFormatUtils.checkTextInputFormat(fs, conf, files);
            }
            if (checkerCls != null) {
                InputFormatChecker checkerInstance = inputFormatCheckerInstanceCache.get(checkerCls);
                try {
                    if (checkerInstance == null) {
                        checkerInstance = checkerCls.newInstance();
                        inputFormatCheckerInstanceCache.put(checkerCls, checkerInstance);
                    }
                    return checkerInstance.validateInput(fs, conf, files);
                }
                catch (Exception e) {
                    throw new HiveException(e);
                }
            }
            return true;
        }
        return false;
    }

    private static boolean checkTextInputFormat(FileSystem fs, HiveConf conf, ArrayList<FileStatus> files) throws HiveException {
        Set<Class<? extends InputFormat>> inputFormatter = inputFormatCheckerMap.keySet();
        for (Class<? extends InputFormat> reg : inputFormatter) {
            boolean result = HiveFileFormatUtils.checkInputFormat(fs, conf, reg, files);
            if (!result) continue;
            return false;
        }
        return true;
    }

    public static FileSinkOperator.RecordWriter getHiveRecordWriter(JobConf jc, TableDesc tableInfo, Class<? extends Writable> outputClass, FileSinkDesc conf, Path outPath) throws HiveException {
        try {
            HiveOutputFormat hiveOutputFormat = tableInfo.getOutputFileFormatClass().newInstance();
            boolean isCompressed = conf.getCompressed();
            JobConf jc_output = jc;
            if (isCompressed) {
                String type;
                jc_output = new JobConf((Configuration)jc);
                String codecStr = conf.getCompressCodec();
                if (codecStr != null && !codecStr.trim().equals("")) {
                    Class<?> codec = Class.forName(codecStr);
                    FileOutputFormat.setOutputCompressorClass((JobConf)jc_output, codec);
                }
                if ((type = conf.getCompressType()) != null && !type.trim().equals("")) {
                    SequenceFile.CompressionType style = SequenceFile.CompressionType.valueOf((String)type);
                    SequenceFileOutputFormat.setOutputCompressionType((JobConf)jc, (SequenceFile.CompressionType)style);
                }
            }
            return HiveFileFormatUtils.getRecordWriter(jc_output, hiveOutputFormat, outputClass, isCompressed, tableInfo.getProperties(), outPath);
        }
        catch (Exception e) {
            throw new HiveException(e);
        }
    }

    public static FileSinkOperator.RecordWriter getRecordWriter(JobConf jc, HiveOutputFormat<?, ?> hiveOutputFormat, Class<? extends Writable> valueClass, boolean isCompressed, Properties tableProp, Path outPath) throws IOException, HiveException {
        if (hiveOutputFormat != null) {
            return hiveOutputFormat.getHiveRecordWriter(jc, outPath, valueClass, isCompressed, tableProp, null);
        }
        return null;
    }

    public static PartitionDesc getPartitionDescFromPathRecursively(Map<String, PartitionDesc> pathToPartitionInfo, Path dir, Map<Map<String, PartitionDesc>, Map<String, PartitionDesc>> cacheMap) throws IOException {
        return HiveFileFormatUtils.getPartitionDescFromPathRecursively(pathToPartitionInfo, dir, cacheMap, false);
    }

    public static PartitionDesc getPartitionDescFromPathRecursively(Map<String, PartitionDesc> pathToPartitionInfo, Path dir, Map<Map<String, PartitionDesc>, Map<String, PartitionDesc>> cacheMap, boolean ignoreSchema) throws IOException {
        PartitionDesc part = HiveFileFormatUtils.doGetPartitionDescFromPath(pathToPartitionInfo, dir);
        if (part == null && (ignoreSchema || dir.toUri().getScheme() == null || dir.toUri().getScheme().trim().equals(""))) {
            Map<String, PartitionDesc> newPathToPartitionInfo = null;
            if (cacheMap != null) {
                newPathToPartitionInfo = cacheMap.get(pathToPartitionInfo);
            }
            if (newPathToPartitionInfo == null) {
                newPathToPartitionInfo = new HashMap<String, PartitionDesc>();
                HiveFileFormatUtils.populateNewPartitionDesc(pathToPartitionInfo, newPathToPartitionInfo);
                if (cacheMap != null) {
                    cacheMap.put(pathToPartitionInfo, newPathToPartitionInfo);
                }
            }
            part = HiveFileFormatUtils.doGetPartitionDescFromPath(newPathToPartitionInfo, dir);
        }
        if (part != null) {
            return part;
        }
        throw new IOException("cannot find dir = " + dir.toString() + " in pathToPartitionInfo: " + pathToPartitionInfo.keySet());
    }

    private static void populateNewPartitionDesc(Map<String, PartitionDesc> pathToPartitionInfo, Map<String, PartitionDesc> newPathToPartitionInfo) {
        for (Map.Entry<String, PartitionDesc> entry : pathToPartitionInfo.entrySet()) {
            String entryKey = entry.getKey();
            PartitionDesc partDesc = entry.getValue();
            Path newP = new Path(entryKey);
            String pathOnly = newP.toUri().getPath();
            newPathToPartitionInfo.put(pathOnly, partDesc);
        }
    }

    private static PartitionDesc doGetPartitionDescFromPath(Map<String, PartitionDesc> pathToPartitionInfo, Path dir) {
        String dirPath = dir.toUri().getPath();
        PartitionDesc part = pathToPartitionInfo.get(dir.toString());
        if (part == null) {
            part = pathToPartitionInfo.get(dirPath);
        }
        if (part == null) {
            String dirStr = dir.toString();
            int dirPathIndex = dirPath.lastIndexOf("/");
            int dirStrIndex = dirStr.lastIndexOf("/");
            while (dirPathIndex >= 0 && dirStrIndex >= 0) {
                dirStr = dirStr.substring(0, dirStrIndex);
                dirPath = dirPath.substring(0, dirPathIndex);
                part = pathToPartitionInfo.get(dirStr);
                if (part == null) {
                    part = pathToPartitionInfo.get(dirPath);
                }
                if (part != null) break;
                dirPathIndex = dirPath.lastIndexOf("/");
                dirStrIndex = dirStr.lastIndexOf("/");
            }
        }
        return part;
    }

    private static boolean foundAlias(Map<String, ArrayList<String>> pathToAliases, String path) {
        List aliases = pathToAliases.get(path);
        return aliases != null && !aliases.isEmpty();
    }

    private static String getMatchingPath(Map<String, ArrayList<String>> pathToAliases, Path dir) {
        String path = dir.toString();
        if (HiveFileFormatUtils.foundAlias(pathToAliases, path)) {
            return path;
        }
        String dirPath = dir.toUri().getPath();
        if (HiveFileFormatUtils.foundAlias(pathToAliases, dirPath)) {
            return dirPath;
        }
        path = dirPath;
        String dirStr = dir.toString();
        int dirPathIndex = dirPath.lastIndexOf("/");
        int dirStrIndex = dirStr.lastIndexOf("/");
        while (dirPathIndex >= 0 && dirStrIndex >= 0) {
            dirStr = dirStr.substring(0, dirStrIndex);
            dirPath = dirPath.substring(0, dirPathIndex);
            if (HiveFileFormatUtils.foundAlias(pathToAliases, dirStr)) {
                return dirStr;
            }
            if (HiveFileFormatUtils.foundAlias(pathToAliases, dirPath)) {
                return dirPath;
            }
            dirPathIndex = dirPath.lastIndexOf("/");
            dirStrIndex = dirStr.lastIndexOf("/");
        }
        return null;
    }

    public static List<Operator<? extends Serializable>> doGetWorksFromPath(Map<String, ArrayList<String>> pathToAliases, Map<String, Operator<? extends Serializable>> aliasToWork, Path dir) {
        ArrayList<Operator<? extends Serializable>> opList = new ArrayList<Operator<? extends Serializable>>();
        List<String> aliases = HiveFileFormatUtils.doGetAliasesFromPath(pathToAliases, dir);
        for (String alias : aliases) {
            opList.add(aliasToWork.get(alias));
        }
        return opList;
    }

    public static List<String> doGetAliasesFromPath(Map<String, ArrayList<String>> pathToAliases, Path dir) {
        if (pathToAliases == null) {
            return new ArrayList<String>();
        }
        String path = HiveFileFormatUtils.getMatchingPath(pathToAliases, dir);
        return pathToAliases.get(path);
    }

    private HiveFileFormatUtils() {
    }

    static {
        HiveFileFormatUtils.registerOutputFormatSubstitute(IgnoreKeyTextOutputFormat.class, HiveIgnoreKeyTextOutputFormat.class);
        HiveFileFormatUtils.registerOutputFormatSubstitute(SequenceFileOutputFormat.class, HiveSequenceFileOutputFormat.class);
        inputFormatCheckerMap = new HashMap<Class<? extends InputFormat>, Class<? extends InputFormatChecker>>();
        HiveFileFormatUtils.registerInputFormatChecker(SequenceFileInputFormat.class, SequenceFileInputFormatChecker.class);
        HiveFileFormatUtils.registerInputFormatChecker(RCFileInputFormat.class, RCFileInputFormat.class);
        inputFormatCheckerInstanceCache = new HashMap<Class<? extends InputFormatChecker>, InputFormatChecker>();
    }
}

