/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec;

import java.io.IOException;
import java.io.Serializable;
import java.net.HttpURLConnection;
import java.net.URL;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.common.JavaUtils;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.MapRedStats;
import org.apache.hadoop.hive.ql.exec.HadoopJobExecHook;
import org.apache.hadoop.hive.ql.exec.JobDebugger;
import org.apache.hadoop.hive.ql.exec.JobTrackerURLResolver;
import org.apache.hadoop.hive.ql.exec.Operator;
import org.apache.hadoop.hive.ql.exec.Task;
import org.apache.hadoop.hive.ql.exec.TaskHandle;
import org.apache.hadoop.hive.ql.exec.Utilities;
import org.apache.hadoop.hive.ql.exec.errors.ErrorAndSolution;
import org.apache.hadoop.hive.ql.exec.errors.TaskLogProcessor;
import org.apache.hadoop.hive.ql.history.HiveHistory;
import org.apache.hadoop.hive.ql.session.SessionState;
import org.apache.hadoop.hive.ql.stats.ClientStatsPublisher;
import org.apache.hadoop.hive.shims.ShimLoader;
import org.apache.hadoop.mapred.Counters;
import org.apache.hadoop.mapred.JobClient;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.RunningJob;
import org.apache.hadoop.mapred.TaskCompletionEvent;
import org.apache.hadoop.mapred.TaskReport;
import org.apache.log4j.Appender;
import org.apache.log4j.FileAppender;
import org.apache.log4j.LogManager;

public class HadoopJobExecHelper {
    private static final Log LOG = LogFactory.getLog((String)HadoopJobExecHelper.class.getName());
    protected transient JobConf job;
    protected Task<? extends Serializable> task;
    protected transient int mapProgress = 0;
    protected transient int reduceProgress = 0;
    public transient String jobId;
    private SessionState.LogHelper console;
    private HadoopJobExecHook callBackObj;
    public static Map<String, String> runningJobKillURIs = Collections.synchronizedMap(new HashMap());

    private void updateCounters(Counters ctrs, RunningJob rj) throws IOException {
        this.mapProgress = Math.round(rj.mapProgress() * 100.0f);
        this.reduceProgress = Math.round(rj.reduceProgress() * 100.0f);
        this.task.taskCounters.put("CNTR_NAME_" + this.task.getId() + "_MAP_PROGRESS", Long.valueOf(this.mapProgress));
        this.task.taskCounters.put("CNTR_NAME_" + this.task.getId() + "_REDUCE_PROGRESS", Long.valueOf(this.reduceProgress));
        if (ctrs == null) {
            return;
        }
        if (this.callBackObj != null) {
            this.callBackObj.updateCounters(ctrs, rj);
        }
    }

    private static String getJobStartMsg(String jobId) {
        return "Starting Job = " + jobId;
    }

    public static String getJobEndMsg(String jobId) {
        return "Ended Job = " + jobId;
    }

    private String getTaskAttemptLogUrl(String taskTrackerHttpAddress, String taskAttemptId) {
        return taskTrackerHttpAddress + "/tasklog?taskid=" + taskAttemptId + "&all=true";
    }

    public boolean mapStarted() {
        return this.mapProgress > 0;
    }

    public boolean reduceStarted() {
        return this.reduceProgress > 0;
    }

    public boolean mapDone() {
        return this.mapProgress == 100;
    }

    public boolean reduceDone() {
        return this.reduceProgress == 100;
    }

    public String getJobId() {
        return this.jobId;
    }

    public void setJobId(String jobId) {
        this.jobId = jobId;
    }

    public HadoopJobExecHelper() {
    }

    public HadoopJobExecHelper(JobConf job, SessionState.LogHelper console, Task<? extends Serializable> task, HadoopJobExecHook hookCallBack) {
        this.job = job;
        this.console = console;
        this.task = task;
        this.callBackObj = hookCallBack;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void killRunningJobs() {
        Map<String, String> map = runningJobKillURIs;
        synchronized (map) {
            for (String uri : runningJobKillURIs.values()) {
                try {
                    System.err.println("killing job with: " + uri);
                    HttpURLConnection conn = (HttpURLConnection)new URL(uri).openConnection();
                    conn.setRequestMethod("POST");
                    int retCode = conn.getResponseCode();
                    if (retCode == 200) continue;
                    System.err.println("Got an error trying to kill job with URI: " + uri + " = " + retCode);
                }
                catch (Exception e) {
                    System.err.println("trying to kill job, caught: " + e);
                }
            }
        }
    }

    public boolean checkFatalErrors(Counters ctrs, StringBuilder errMsg) {
        long upperLimit;
        if (ctrs == null) {
            return false;
        }
        long numFiles = ctrs.getCounter((Enum)Operator.ProgressCounter.CREATED_FILES);
        if (numFiles > (upperLimit = HiveConf.getLongVar((Configuration)this.job, HiveConf.ConfVars.MAXCREATEDFILES))) {
            errMsg.append("total number of created files now is " + numFiles + ", which exceeds ").append(upperLimit);
            return true;
        }
        return this.callBackObj.checkFatalErrors(ctrs, errMsg);
    }

    private MapRedStats progress(ExecDriverTaskHandle th) throws IOException {
        long newCpuMSec;
        Counters.Counter counterCpuMsec;
        boolean success;
        Counters ctrs;
        JobClient jc = th.getJobClient();
        RunningJob rj = th.getRunningJob();
        String lastReport = "";
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss,SSS");
        long reportTime = System.currentTimeMillis();
        long maxReportInterval = 60000L;
        boolean fatal = false;
        StringBuilder errMsg = new StringBuilder();
        long pullInterval = HiveConf.getLongVar((Configuration)this.job, HiveConf.ConfVars.HIVECOUNTERSPULLINTERVAL);
        boolean initializing = true;
        boolean initOutputPrinted = false;
        long cpuMsec = -1L;
        int numMap = -1;
        int numReduce = -1;
        List<ClientStatsPublisher> clientStatPublishers = this.getClientStatPublishers();
        while (!rj.isComplete()) {
            long newCpuMSec2;
            Counters.Counter counterCpuMsec2;
            String report;
            RunningJob newRj;
            try {
                Thread.sleep(pullInterval);
            }
            catch (InterruptedException e) {
                // empty catch block
            }
            if (initializing && ShimLoader.getHadoopShims().isJobPreparing(rj)) continue;
            initializing = false;
            if (!initOutputPrinted) {
                String logReducer;
                String logMapper;
                SessionState ss = SessionState.get();
                TaskReport[] mappers = jc.getMapTaskReports(rj.getJobID());
                if (mappers == null) {
                    logMapper = "no information for number of mappers; ";
                } else {
                    numMap = mappers.length;
                    if (ss != null) {
                        ss.getHiveHistory().setTaskProperty(SessionState.get().getQueryId(), this.getId(), HiveHistory.Keys.TASK_NUM_MAPPERS, Integer.toString(numMap));
                    }
                    logMapper = "number of mappers: " + numMap + "; ";
                }
                TaskReport[] reducers = jc.getReduceTaskReports(rj.getJobID());
                if (reducers == null) {
                    logReducer = "no information for number of reducers. ";
                } else {
                    numReduce = reducers.length;
                    if (ss != null) {
                        ss.getHiveHistory().setTaskProperty(SessionState.get().getQueryId(), this.getId(), HiveHistory.Keys.TASK_NUM_REDUCERS, Integer.toString(numReduce));
                    }
                    logReducer = "number of reducers: " + numReduce;
                }
                this.console.printInfo("Hadoop job information for " + this.getId() + ": " + logMapper + logReducer);
                initOutputPrinted = true;
            }
            if ((newRj = jc.getJob(rj.getJobID())) == null) {
                throw new IOException("Could not find status of job:" + rj.getJobID());
            }
            th.setRunningJob(newRj);
            rj = newRj;
            if (fatal) continue;
            ctrs = th.getCounters();
            fatal = this.checkFatalErrors(ctrs, errMsg);
            if (fatal) {
                this.console.printError("[Fatal Error] " + errMsg.toString() + ". Killing the job.");
                rj.killJob();
                continue;
            }
            errMsg.setLength(0);
            this.updateCounters(ctrs, rj);
            if (clientStatPublishers.size() > 0 && ctrs != null) {
                Map<String, Double> exctractedCounters = this.extractAllCounterValues(ctrs);
                for (ClientStatsPublisher clientStatPublisher : clientStatPublishers) {
                    try {
                        clientStatPublisher.run(exctractedCounters, rj.getID().toString());
                    }
                    catch (RuntimeException runtimeException) {
                        LOG.error((Object)("Exception " + runtimeException.getClass().getCanonicalName() + " thrown when running clientStatsPublishers. The stack trace is: "), (Throwable)runtimeException);
                    }
                }
            }
            if ((report = " " + this.getId() + " map = " + this.mapProgress + "%,  reduce = " + this.reduceProgress + "%").equals(lastReport) && System.currentTimeMillis() < reportTime + maxReportInterval) continue;
            if (ctrs != null && (counterCpuMsec2 = ctrs.findCounter("org.apache.hadoop.mapred.Task$Counter", "CPU_MILLISECONDS")) != null && (newCpuMSec2 = counterCpuMsec2.getValue()) > 0L) {
                cpuMsec = newCpuMSec2;
                report = report + ", Cumulative CPU " + (double)cpuMsec / 1000.0 + " sec";
            }
            String output = dateFormat.format(Calendar.getInstance().getTime()) + report;
            SessionState ss = SessionState.get();
            if (ss != null) {
                ss.getHiveHistory().setTaskCounters(SessionState.get().getQueryId(), this.getId(), ctrs);
                ss.getHiveHistory().setTaskProperty(SessionState.get().getQueryId(), this.getId(), HiveHistory.Keys.TASK_HADOOP_PROGRESS, output);
                ss.getHiveHistory().progressTask(SessionState.get().getQueryId(), this.task);
                this.callBackObj.logPlanProgress(ss);
            }
            this.console.printInfo(output);
            lastReport = report;
            reportTime = System.currentTimeMillis();
        }
        if (cpuMsec > 0L) {
            this.console.printInfo("MapReduce Total cumulative CPU time: " + Utilities.formatMsecToStr(cpuMsec));
        }
        ctrs = th.getCounters();
        if (fatal) {
            success = false;
        } else if (this.checkFatalErrors(ctrs, errMsg)) {
            this.console.printError("[Fatal Error] " + errMsg.toString());
            success = false;
        } else {
            SessionState ss = SessionState.get();
            if (ss != null) {
                ss.getHiveHistory().setTaskCounters(SessionState.get().getQueryId(), this.getId(), ctrs);
            }
            success = rj.isSuccessful();
        }
        if (ctrs != null && (counterCpuMsec = ctrs.findCounter("org.apache.hadoop.mapred.Task$Counter", "CPU_MILLISECONDS")) != null && (newCpuMSec = counterCpuMsec.getValue()) > cpuMsec) {
            cpuMsec = newCpuMSec;
        }
        MapRedStats mapRedStats = new MapRedStats(numMap, numReduce, cpuMsec, success, rj.getID().toString());
        mapRedStats.setCounters(ctrs);
        this.task.setDone();
        this.updateCounters(ctrs, rj);
        SessionState ss = SessionState.get();
        if (ss != null) {
            this.callBackObj.logPlanProgress(ss);
        }
        return mapRedStats;
    }

    private String getId() {
        return this.task.getId();
    }

    public void jobInfo(RunningJob rj) {
        if (this.job.get("mapred.job.tracker", "local").equals("local")) {
            this.console.printInfo("Job running in-process (local Hadoop)");
        } else {
            String hp = this.job.get("mapred.job.tracker");
            if (SessionState.get() != null) {
                SessionState.get().getHiveHistory().setTaskProperty(SessionState.get().getQueryId(), this.getId(), HiveHistory.Keys.TASK_HADOOP_ID, rj.getJobID());
            }
            this.console.printInfo(HadoopJobExecHelper.getJobStartMsg(rj.getJobID()) + ", Tracking URL = " + rj.getTrackingURL());
            this.console.printInfo("Kill Command = " + HiveConf.getVar((Configuration)this.job, HiveConf.ConfVars.HADOOPBIN) + " job  -Dmapred.job.tracker=" + hp + " -kill " + rj.getJobID());
        }
    }

    private void showJobFailDebugInfo(JobConf conf, RunningJob rj) throws IOException {
        TaskCompletionEvent[] taskCompletions;
        HashMap<String, Integer> failures = new HashMap<String, Integer>();
        HashSet<String> successes = new HashSet<String>();
        HashMap<String, TaskInfo> taskIdToInfo = new HashMap<String, TaskInfo>();
        int startIndex = 0;
        this.console.printError("Error during job, obtaining debugging information...");
        while ((taskCompletions = rj.getTaskCompletionEvents(startIndex)) != null && taskCompletions.length != 0) {
            boolean more = true;
            boolean firstError = true;
            for (TaskCompletionEvent t : taskCompletions) {
                TaskInfo ti;
                String[] taskJobIds = ShimLoader.getHadoopShims().getTaskJobIDs(t);
                if (taskJobIds == null) {
                    this.console.printError("Task attempt info is unavailable in this Hadoop version");
                    more = false;
                    break;
                }
                String taskId = taskJobIds[0];
                String jobId = taskJobIds[1];
                if (firstError) {
                    this.console.printError("Examining task ID: " + taskId + " (and more) from job " + jobId);
                    firstError = false;
                }
                if ((ti = (TaskInfo)taskIdToInfo.get(taskId)) == null) {
                    ti = new TaskInfo(jobId);
                    taskIdToInfo.put(taskId, ti);
                }
                assert (ti.getJobId() != null && ti.getJobId().equals(jobId));
                ti.getLogUrls().add(this.getTaskAttemptLogUrl(t.getTaskTrackerHttp(), t.getTaskId()));
                if (t.getTaskStatus() != TaskCompletionEvent.Status.SUCCEEDED) {
                    Integer failAttempts = (Integer)failures.get(taskId);
                    if (failAttempts == null) {
                        failAttempts = 0;
                    }
                    failAttempts = failAttempts + 1;
                    failures.put(taskId, failAttempts);
                    continue;
                }
                successes.add(taskId);
            }
            if (!more) break;
            startIndex += taskCompletions.length;
        }
        for (String task : successes) {
            failures.remove(task);
        }
        if (failures.keySet().size() == 0) {
            return;
        }
        int maxFailures = 0;
        for (Integer failCount : failures.values()) {
            if (maxFailures >= failCount) continue;
            maxFailures = failCount;
        }
        String jtUrl = JobTrackerURLResolver.getURL(conf);
        for (String task : failures.keySet()) {
            if ((Integer)failures.get(task) != maxFailures) continue;
            TaskInfo ti = (TaskInfo)taskIdToInfo.get(task);
            String jobId = ti.getJobId();
            String taskUrl = jtUrl + "/taskdetails.jsp?jobid=" + jobId + "&tipid=" + task.toString();
            TaskLogProcessor tlp = new TaskLogProcessor(conf);
            for (String logUrl : ti.getLogUrls()) {
                tlp.addTaskAttemptLogUrl(logUrl);
            }
            List<ErrorAndSolution> errors = tlp.getErrors();
            StringBuilder sb = new StringBuilder();
            sb.append("\n");
            sb.append("Task with the most failures(" + maxFailures + "): \n");
            sb.append("-----\n");
            sb.append("Task ID:\n  " + task + "\n\n");
            sb.append("URL:\n  " + taskUrl + "\n");
            for (ErrorAndSolution e : errors) {
                sb.append("\n");
                sb.append("Possible error:\n  " + e.getError() + "\n\n");
                sb.append("Solution:\n  " + e.getSolution() + "\n");
            }
            sb.append("-----\n");
            this.console.printError(sb.toString());
            break;
        }
    }

    public void localJobDebugger(int exitVal, String taskId) {
        StringBuilder sb = new StringBuilder();
        sb.append("\n");
        sb.append("Task failed!\n");
        sb.append("Task ID:\n  " + taskId + "\n\n");
        sb.append("Logs:\n");
        this.console.printError(sb.toString());
        for (Appender a : Collections.list(LogManager.getRootLogger().getAllAppenders())) {
            if (!(a instanceof FileAppender)) continue;
            this.console.printError(((FileAppender)a).getFile());
        }
    }

    public int progressLocal(Process runningJob, String taskId) {
        int exitVal = -101;
        try {
            exitVal = runningJob.waitFor();
        }
        catch (InterruptedException e) {
            // empty catch block
        }
        if (exitVal != 0) {
            this.console.printError("Execution failed with exit status: " + exitVal);
            this.console.printError("Obtaining error information");
            if (HiveConf.getBoolVar((Configuration)this.job, HiveConf.ConfVars.SHOW_JOB_FAIL_DEBUG_INFO)) {
                this.localJobDebugger(exitVal, taskId);
            }
        } else {
            this.console.printInfo("Execution completed successfully");
            this.console.printInfo("Mapred Local Task Succeeded . Convert the Join into MapJoin");
        }
        return exitVal;
    }

    public int progress(RunningJob rj, JobClient jc) throws IOException {
        this.jobId = rj.getJobID();
        int returnVal = 0;
        String pwd = HiveConf.getVar((Configuration)this.job, HiveConf.ConfVars.METASTOREPWD);
        if (pwd != null) {
            HiveConf.setVar((Configuration)this.job, HiveConf.ConfVars.METASTOREPWD, "HIVE");
        }
        if (pwd != null) {
            HiveConf.setVar((Configuration)this.job, HiveConf.ConfVars.METASTOREPWD, pwd);
        }
        runningJobKillURIs.put(rj.getJobID(), rj.getTrackingURL() + "&action=kill");
        ExecDriverTaskHandle th = new ExecDriverTaskHandle(jc, rj);
        this.jobInfo(rj);
        MapRedStats mapRedStats = this.progress(th);
        if (SessionState.get() != null) {
            SessionState.get().getLastMapRedStatsList().add(mapRedStats);
        }
        boolean success = mapRedStats.isSuccess();
        String statusMesg = HadoopJobExecHelper.getJobEndMsg(rj.getJobID());
        if (!success) {
            statusMesg = statusMesg + " with errors";
            returnVal = 2;
            this.console.printError(statusMesg);
            if (HiveConf.getBoolVar((Configuration)this.job, HiveConf.ConfVars.SHOW_JOB_FAIL_DEBUG_INFO) || HiveConf.getBoolVar((Configuration)this.job, HiveConf.ConfVars.JOB_DEBUG_CAPTURE_STACKTRACES)) {
                try {
                    JobDebugger jd = SessionState.get() != null ? new JobDebugger(this.job, rj, this.console, SessionState.get().getStackTraces()) : new JobDebugger(this.job, rj, this.console);
                    Thread t = new Thread(jd);
                    t.start();
                    t.join(HiveConf.getIntVar((Configuration)this.job, HiveConf.ConfVars.JOB_DEBUG_TIMEOUT));
                }
                catch (InterruptedException e) {
                    this.console.printError("Timed out trying to grab more detailed job failure information, please check jobtracker for more info");
                }
            }
        } else {
            this.console.printInfo(statusMesg);
        }
        return returnVal;
    }

    private Map<String, Double> extractAllCounterValues(Counters counters) {
        HashMap<String, Double> exctractedCounters = new HashMap<String, Double>();
        for (Counters.Group cg : counters) {
            for (Counters.Counter c : cg) {
                exctractedCounters.put(cg.getName() + "::" + c.getName(), new Double(c.getCounter()));
            }
        }
        return exctractedCounters;
    }

    private List<ClientStatsPublisher> getClientStatPublishers() {
        String[] clientStatsPublisherClasses;
        ArrayList<ClientStatsPublisher> clientStatsPublishers = new ArrayList<ClientStatsPublisher>();
        String confString = HiveConf.getVar((Configuration)this.job, HiveConf.ConfVars.CLIENTSTATSPUBLISHERS);
        if ((confString = confString.trim()).equals("")) {
            return clientStatsPublishers;
        }
        for (String clientStatsPublisherClass : clientStatsPublisherClasses = confString.split(",")) {
            try {
                clientStatsPublishers.add((ClientStatsPublisher)Class.forName(clientStatsPublisherClass.trim(), true, JavaUtils.getClassLoader()).newInstance());
            }
            catch (Exception e) {
                LOG.warn((Object)(e.getClass().getName() + " occured when trying to create class: " + clientStatsPublisherClass.trim() + " implementing ClientStatsPublisher interface"));
                LOG.warn((Object)("The exception message is: " + e.getMessage()));
                LOG.warn((Object)"Program will continue, but without this ClientStatsPublisher working");
            }
        }
        return clientStatsPublishers;
    }

    static {
        if (new Configuration().getBoolean("webinterface.private.actions", false)) {
            Runtime.getRuntime().addShutdownHook(new Thread(){

                @Override
                public void run() {
                    HadoopJobExecHelper.killRunningJobs();
                }
            });
        }
    }

    private static class TaskInfo {
        String jobId;
        HashSet<String> logUrls;

        public TaskInfo(String jobId) {
            this.jobId = jobId;
            this.logUrls = new HashSet();
        }

        public void addLogUrl(String logUrl) {
            this.logUrls.add(logUrl);
        }

        public HashSet<String> getLogUrls() {
            return this.logUrls;
        }

        public String getJobId() {
            return this.jobId;
        }
    }

    private static class ExecDriverTaskHandle
    extends TaskHandle {
        JobClient jc;
        RunningJob rj;

        JobClient getJobClient() {
            return this.jc;
        }

        RunningJob getRunningJob() {
            return this.rj;
        }

        public ExecDriverTaskHandle(JobClient jc, RunningJob rj) {
            this.jc = jc;
            this.rj = rj;
        }

        public void setRunningJob(RunningJob job) {
            this.rj = job;
        }

        @Override
        public Counters getCounters() throws IOException {
            return this.rj.getCounters();
        }
    }
}

