/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.txn.compactor;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import junit.framework.Assert;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.api.CompactionRequest;
import org.apache.hadoop.hive.metastore.api.CompactionType;
import org.apache.hadoop.hive.metastore.api.Order;
import org.apache.hadoop.hive.metastore.api.Partition;
import org.apache.hadoop.hive.metastore.api.ShowCompactRequest;
import org.apache.hadoop.hive.metastore.api.ShowCompactResponse;
import org.apache.hadoop.hive.metastore.api.ShowCompactResponseElement;
import org.apache.hadoop.hive.metastore.api.Table;
import org.apache.hadoop.hive.metastore.txn.TxnDbUtil;
import org.apache.hadoop.hive.ql.txn.compactor.CompactorMR;
import org.apache.hadoop.hive.ql.txn.compactor.CompactorTest;
import org.junit.Before;
import org.junit.Test;

public class TestWorker
extends CompactorTest {
    private static final String CLASS_NAME = TestWorker.class.getName();
    private static final Log LOG = LogFactory.getLog((String)CLASS_NAME);

    @Test
    public void nothing() throws Exception {
        this.startWorker(new HiveConf());
    }

    @Test
    public void stringableMap() throws Exception {
        CompactorMR.StringableMap m = new CompactorMR.StringableMap(new HashMap());
        String s = m.toString();
        Assert.assertEquals((String)"0:", (String)s);
        m = new CompactorMR.StringableMap(s);
        Assert.assertEquals((int)0, (int)m.size());
        HashMap<String, String> base = new HashMap<String, String>();
        base.put("mary", "poppins");
        base.put("bert", null);
        base.put(null, "banks");
        m = new CompactorMR.StringableMap(base);
        s = m.toString();
        m = new CompactorMR.StringableMap(s);
        Assert.assertEquals((int)3, (int)m.size());
        HashMap<String, Boolean> saw = new HashMap<String, Boolean>(3);
        saw.put("mary", false);
        saw.put("bert", false);
        saw.put(null, false);
        for (Map.Entry e : m.entrySet()) {
            saw.put((String)e.getKey(), true);
            if ("mary".equals(e.getKey())) {
                Assert.assertEquals((String)"poppins", (String)((String)e.getValue()));
                continue;
            }
            if ("bert".equals(e.getKey())) {
                Assert.assertNull(e.getValue());
                continue;
            }
            if (null == e.getKey()) {
                Assert.assertEquals((String)"banks", (String)((String)e.getValue()));
                continue;
            }
            Assert.fail((String)("Unexpected value " + (String)e.getKey()));
        }
        Assert.assertEquals((int)3, (int)saw.size());
        Assert.assertTrue((boolean)((Boolean)saw.get("mary")));
        Assert.assertTrue((boolean)((Boolean)saw.get("bert")));
        Assert.assertTrue((boolean)((Boolean)saw.get(null)));
    }

    @Test
    public void stringableList() throws Exception {
        CompactorMR.StringableList ls = new CompactorMR.StringableList();
        String s = ls.toString();
        Assert.assertEquals((String)"0:", (String)s);
        ls = new CompactorMR.StringableList(s);
        Assert.assertEquals((int)0, (int)ls.size());
        ls = new CompactorMR.StringableList();
        ls.add((Object)new Path("/tmp"));
        ls.add((Object)new Path("/usr"));
        s = ls.toString();
        Assert.assertTrue((String)("Expected 2:4:/tmp4:/usr or 2:4:/usr4:/tmp, got " + s), ("2:4:/tmp4:/usr".equals(s) || "2:4:/usr4:/tmp".equals(s) ? 1 : 0) != 0);
        ls = new CompactorMR.StringableList(s);
        Assert.assertEquals((int)2, (int)ls.size());
        boolean sawTmp = false;
        boolean sawUsr = false;
        for (Path p : ls) {
            if ("/tmp".equals(p.toString())) {
                sawTmp = true;
                continue;
            }
            if ("/usr".equals(p.toString())) {
                sawUsr = true;
                continue;
            }
            Assert.fail((String)("Unexpected path " + p.toString()));
        }
        Assert.assertTrue((boolean)sawTmp);
        Assert.assertTrue((boolean)sawUsr);
    }

    @Test
    public void inputSplit() throws Exception {
        String basename = "/warehouse/foo/base_1";
        String delta1 = "/warehouse/foo/delta_2_3";
        String delta2 = "/warehouse/foo/delta_4_7";
        HiveConf conf = new HiveConf();
        Path file = new Path(System.getProperty("java.io.tmpdir") + System.getProperty("file.separator") + "newWriteInputSplitTest");
        FileSystem fs = FileSystem.get((Configuration)conf);
        FSDataOutputStream os = fs.create(file);
        for (int i = 0; i < 10; ++i) {
            os.writeBytes("mary had a little lamb its fleece was white as snow\n");
        }
        os.close();
        ArrayList<Path> files = new ArrayList<Path>(1);
        files.add(file);
        Path[] deltas = new Path[]{new Path(delta1), new Path(delta2)};
        CompactorMR.CompactorInputSplit split = new CompactorMR.CompactorInputSplit((Configuration)conf, 3, files, new Path(basename), deltas);
        Assert.assertEquals((long)520L, (long)split.getLength());
        String[] locations = split.getLocations();
        Assert.assertEquals((int)1, (int)locations.length);
        Assert.assertEquals((String)"localhost", (String)locations[0]);
        ByteArrayOutputStream buf = new ByteArrayOutputStream();
        DataOutputStream out = new DataOutputStream(buf);
        split.write((DataOutput)out);
        split = new CompactorMR.CompactorInputSplit();
        DataInputStream in = new DataInputStream(new ByteArrayInputStream(buf.toByteArray()));
        split.readFields((DataInput)in);
        Assert.assertEquals((int)3, (int)split.getBucket());
        Assert.assertEquals((String)basename, (String)split.getBaseDir().toString());
        deltas = split.getDeltaDirs();
        Assert.assertEquals((int)2, (int)deltas.length);
        Assert.assertEquals((String)delta1, (String)deltas[0].toString());
        Assert.assertEquals((String)delta2, (String)deltas[1].toString());
    }

    @Test
    public void inputSplitNullBase() throws Exception {
        String delta1 = "/warehouse/foo/delta_2_3";
        String delta2 = "/warehouse/foo/delta_4_7";
        HiveConf conf = new HiveConf();
        Path file = new Path(System.getProperty("java.io.tmpdir") + System.getProperty("file.separator") + "newWriteInputSplitTest");
        FileSystem fs = FileSystem.get((Configuration)conf);
        FSDataOutputStream os = fs.create(file);
        for (int i = 0; i < 10; ++i) {
            os.writeBytes("mary had a little lamb its fleece was white as snow\n");
        }
        os.close();
        ArrayList<Path> files = new ArrayList<Path>(1);
        files.add(file);
        Path[] deltas = new Path[]{new Path(delta1), new Path(delta2)};
        CompactorMR.CompactorInputSplit split = new CompactorMR.CompactorInputSplit((Configuration)conf, 3, files, null, deltas);
        ByteArrayOutputStream buf = new ByteArrayOutputStream();
        DataOutputStream out = new DataOutputStream(buf);
        split.write((DataOutput)out);
        split = new CompactorMR.CompactorInputSplit();
        DataInputStream in = new DataInputStream(new ByteArrayInputStream(buf.toByteArray()));
        split.readFields((DataInput)in);
        Assert.assertEquals((int)3, (int)split.getBucket());
        Assert.assertNull((Object)split.getBaseDir());
        deltas = split.getDeltaDirs();
        Assert.assertEquals((int)2, (int)deltas.length);
        Assert.assertEquals((String)delta1, (String)deltas[0].toString());
        Assert.assertEquals((String)delta2, (String)deltas[1].toString());
    }

    @Test
    public void sortedTable() throws Exception {
        ArrayList<Order> sortCols = new ArrayList<Order>(1);
        sortCols.add(new Order("b", 1));
        Table t = this.newTable("default", "st", false, new HashMap<String, String>(), sortCols);
        HiveConf conf = new HiveConf();
        this.addBaseFile(conf, t, null, 20L, 20);
        this.addDeltaFile(conf, t, null, 21L, 22L, 2);
        this.addDeltaFile(conf, t, null, 23L, 24L, 2);
        this.addDeltaFile(conf, t, null, 21L, 24L, 4);
        this.burnThroughTransactions(25);
        CompactionRequest rqst = new CompactionRequest("default", "st", CompactionType.MINOR);
        this.txnHandler.compact(rqst);
        this.startWorker(new HiveConf());
        FileSystem fs = FileSystem.get((Configuration)conf);
        FileStatus[] stat = fs.listStatus(new Path(t.getSd().getLocation()));
        Assert.assertEquals((int)4, (int)stat.length);
    }

    @Test
    public void sortedPartition() throws Exception {
        ArrayList<Order> sortCols = new ArrayList<Order>(1);
        sortCols.add(new Order("b", 1));
        Table t = this.newTable("default", "sp", true, new HashMap<String, String>(), sortCols);
        Partition p = this.newPartition(t, "today", sortCols);
        HiveConf conf = new HiveConf();
        this.addBaseFile(conf, t, p, 20L, 20);
        this.addDeltaFile(conf, t, p, 21L, 22L, 2);
        this.addDeltaFile(conf, t, p, 23L, 24L, 2);
        this.addDeltaFile(conf, t, p, 21L, 24L, 4);
        this.burnThroughTransactions(25);
        CompactionRequest rqst = new CompactionRequest("default", "sp", CompactionType.MINOR);
        rqst.setPartitionname("ds=today");
        this.txnHandler.compact(rqst);
        this.startWorker(new HiveConf());
        FileSystem fs = FileSystem.get((Configuration)conf);
        FileStatus[] stat = fs.listStatus(new Path(p.getSd().getLocation()));
        Assert.assertEquals((int)4, (int)stat.length);
    }

    @Test
    public void minorTableWithBase() throws Exception {
        LOG.debug((Object)"Starting minorTableWithBase");
        Table t = this.newTable("default", "mtwb", false);
        HiveConf conf = new HiveConf();
        this.addBaseFile(conf, t, null, 20L, 20);
        this.addDeltaFile(conf, t, null, 21L, 22L, 2);
        this.addDeltaFile(conf, t, null, 23L, 24L, 2);
        this.burnThroughTransactions(25);
        CompactionRequest rqst = new CompactionRequest("default", "mtwb", CompactionType.MINOR);
        this.txnHandler.compact(rqst);
        this.startWorker(conf);
        ShowCompactResponse rsp = this.txnHandler.showCompact(new ShowCompactRequest());
        List compacts = rsp.getCompacts();
        Assert.assertEquals((int)1, (int)compacts.size());
        Assert.assertEquals((String)"ready for cleaning", (String)((ShowCompactResponseElement)compacts.get(0)).getState());
        FileSystem fs = FileSystem.get((Configuration)conf);
        FileStatus[] stat = fs.listStatus(new Path(t.getSd().getLocation()));
        for (int i = 0; i < stat.length; ++i) {
            System.out.println("HERE: " + stat[i].getPath().toString());
        }
        Assert.assertEquals((int)4, (int)stat.length);
        boolean sawNewDelta = false;
        for (int i = 0; i < stat.length; ++i) {
            if (stat[i].getPath().getName().equals("delta_0000021_0000024")) {
                sawNewDelta = true;
                FileStatus[] buckets = fs.listStatus(stat[i].getPath());
                Assert.assertEquals((int)2, (int)buckets.length);
                Assert.assertTrue((boolean)buckets[0].getPath().getName().matches("bucket_0000[01]"));
                Assert.assertTrue((boolean)buckets[1].getPath().getName().matches("bucket_0000[01]"));
                Assert.assertEquals((long)208L, (long)buckets[0].getLen());
                Assert.assertEquals((long)208L, (long)buckets[1].getLen());
                continue;
            }
            LOG.debug((Object)("This is not the delta file you are looking for " + stat[i].getPath().getName()));
        }
        Assert.assertTrue((boolean)sawNewDelta);
    }

    @Test
    public void minorPartitionWithBase() throws Exception {
        Table t = this.newTable("default", "mpwb", true);
        Partition p = this.newPartition(t, "today");
        HiveConf conf = new HiveConf();
        this.addBaseFile(conf, t, p, 20L, 20);
        this.addDeltaFile(conf, t, p, 21L, 22L, 2);
        this.addDeltaFile(conf, t, p, 23L, 24L, 2);
        this.burnThroughTransactions(25);
        CompactionRequest rqst = new CompactionRequest("default", "mpwb", CompactionType.MINOR);
        rqst.setPartitionname("ds=today");
        this.txnHandler.compact(rqst);
        this.startWorker(new HiveConf());
        ShowCompactResponse rsp = this.txnHandler.showCompact(new ShowCompactRequest());
        List compacts = rsp.getCompacts();
        Assert.assertEquals((int)1, (int)compacts.size());
        Assert.assertEquals((String)"ready for cleaning", (String)((ShowCompactResponseElement)compacts.get(0)).getState());
        FileSystem fs = FileSystem.get((Configuration)conf);
        FileStatus[] stat = fs.listStatus(new Path(p.getSd().getLocation()));
        Assert.assertEquals((int)4, (int)stat.length);
        boolean sawNewDelta = false;
        for (int i = 0; i < stat.length; ++i) {
            if (stat[i].getPath().getName().equals("delta_0000021_0000024")) {
                sawNewDelta = true;
                FileStatus[] buckets = fs.listStatus(stat[i].getPath());
                Assert.assertEquals((int)2, (int)buckets.length);
                Assert.assertTrue((boolean)buckets[0].getPath().getName().matches("bucket_0000[01]"));
                Assert.assertTrue((boolean)buckets[1].getPath().getName().matches("bucket_0000[01]"));
                Assert.assertEquals((long)208L, (long)buckets[0].getLen());
                Assert.assertEquals((long)208L, (long)buckets[1].getLen());
                continue;
            }
            LOG.debug((Object)("This is not the delta file you are looking for " + stat[i].getPath().getName()));
        }
        Assert.assertTrue((boolean)sawNewDelta);
    }

    @Test
    public void minorTableNoBase() throws Exception {
        LOG.debug((Object)"Starting minorTableWithBase");
        Table t = this.newTable("default", "mtnb", false);
        HiveConf conf = new HiveConf();
        this.addDeltaFile(conf, t, null, 1L, 2L, 2);
        this.addDeltaFile(conf, t, null, 3L, 4L, 2);
        this.burnThroughTransactions(5);
        CompactionRequest rqst = new CompactionRequest("default", "mtnb", CompactionType.MINOR);
        this.txnHandler.compact(rqst);
        this.startWorker(new HiveConf());
        ShowCompactResponse rsp = this.txnHandler.showCompact(new ShowCompactRequest());
        List compacts = rsp.getCompacts();
        Assert.assertEquals((int)1, (int)compacts.size());
        Assert.assertEquals((String)"ready for cleaning", (String)((ShowCompactResponseElement)compacts.get(0)).getState());
        FileSystem fs = FileSystem.get((Configuration)conf);
        FileStatus[] stat = fs.listStatus(new Path(t.getSd().getLocation()));
        Assert.assertEquals((int)3, (int)stat.length);
        boolean sawNewDelta = false;
        for (int i = 0; i < stat.length; ++i) {
            if (stat[i].getPath().getName().equals("delta_0000001_0000004")) {
                sawNewDelta = true;
                FileStatus[] buckets = fs.listStatus(stat[i].getPath());
                Assert.assertEquals((int)2, (int)buckets.length);
                Assert.assertTrue((boolean)buckets[0].getPath().getName().matches("bucket_0000[01]"));
                Assert.assertTrue((boolean)buckets[1].getPath().getName().matches("bucket_0000[01]"));
                Assert.assertEquals((long)208L, (long)buckets[0].getLen());
                Assert.assertEquals((long)208L, (long)buckets[1].getLen());
                continue;
            }
            LOG.debug((Object)("This is not the delta file you are looking for " + stat[i].getPath().getName()));
        }
        Assert.assertTrue((boolean)sawNewDelta);
    }

    @Test
    public void majorTableWithBase() throws Exception {
        LOG.debug((Object)"Starting majorTableWithBase");
        Table t = this.newTable("default", "matwb", false);
        HiveConf conf = new HiveConf();
        this.addBaseFile(conf, t, null, 20L, 20);
        this.addDeltaFile(conf, t, null, 21L, 22L, 2);
        this.addDeltaFile(conf, t, null, 23L, 24L, 2);
        this.burnThroughTransactions(25);
        CompactionRequest rqst = new CompactionRequest("default", "matwb", CompactionType.MAJOR);
        this.txnHandler.compact(rqst);
        this.startWorker(new HiveConf());
        ShowCompactResponse rsp = this.txnHandler.showCompact(new ShowCompactRequest());
        List compacts = rsp.getCompacts();
        Assert.assertEquals((int)1, (int)compacts.size());
        Assert.assertEquals((String)"ready for cleaning", (String)((ShowCompactResponseElement)compacts.get(0)).getState());
        FileSystem fs = FileSystem.get((Configuration)conf);
        FileStatus[] stat = fs.listStatus(new Path(t.getSd().getLocation()));
        Assert.assertEquals((int)4, (int)stat.length);
        boolean sawNewBase = false;
        for (int i = 0; i < stat.length; ++i) {
            if (stat[i].getPath().getName().equals("base_0000024")) {
                sawNewBase = true;
                FileStatus[] buckets = fs.listStatus(stat[i].getPath());
                Assert.assertEquals((int)2, (int)buckets.length);
                Assert.assertTrue((boolean)buckets[0].getPath().getName().matches("bucket_0000[01]"));
                Assert.assertTrue((boolean)buckets[1].getPath().getName().matches("bucket_0000[01]"));
                Assert.assertEquals((long)1248L, (long)buckets[0].getLen());
                Assert.assertEquals((long)1248L, (long)buckets[1].getLen());
                continue;
            }
            LOG.debug((Object)("This is not the file you are looking for " + stat[i].getPath().getName()));
        }
        Assert.assertTrue((boolean)sawNewBase);
    }

    @Test
    public void majorPartitionWithBase() throws Exception {
        LOG.debug((Object)"Starting majorPartitionWithBase");
        Table t = this.newTable("default", "mapwb", true);
        Partition p = this.newPartition(t, "today");
        HiveConf conf = new HiveConf();
        this.addBaseFile(conf, t, p, 20L, 20);
        this.addDeltaFile(conf, t, p, 21L, 22L, 2);
        this.addDeltaFile(conf, t, p, 23L, 24L, 2);
        this.burnThroughTransactions(25);
        CompactionRequest rqst = new CompactionRequest("default", "mapwb", CompactionType.MAJOR);
        rqst.setPartitionname("ds=today");
        this.txnHandler.compact(rqst);
        this.startWorker(new HiveConf());
        ShowCompactResponse rsp = this.txnHandler.showCompact(new ShowCompactRequest());
        List compacts = rsp.getCompacts();
        Assert.assertEquals((int)1, (int)compacts.size());
        Assert.assertEquals((String)"ready for cleaning", (String)((ShowCompactResponseElement)compacts.get(0)).getState());
        FileSystem fs = FileSystem.get((Configuration)conf);
        FileStatus[] stat = fs.listStatus(new Path(p.getSd().getLocation()));
        Assert.assertEquals((int)4, (int)stat.length);
        boolean sawNewBase = false;
        for (int i = 0; i < stat.length; ++i) {
            if (stat[i].getPath().getName().equals("base_0000024")) {
                sawNewBase = true;
                FileStatus[] buckets = fs.listStatus(stat[i].getPath());
                Assert.assertEquals((int)2, (int)buckets.length);
                Assert.assertTrue((boolean)buckets[0].getPath().getName().matches("bucket_0000[01]"));
                Assert.assertTrue((boolean)buckets[1].getPath().getName().matches("bucket_0000[01]"));
                Assert.assertEquals((long)1248L, (long)buckets[0].getLen());
                Assert.assertEquals((long)1248L, (long)buckets[1].getLen());
                continue;
            }
            LOG.debug((Object)("This is not the file you are looking for " + stat[i].getPath().getName()));
        }
        Assert.assertTrue((boolean)sawNewBase);
    }

    @Test
    public void majorTableNoBase() throws Exception {
        LOG.debug((Object)"Starting majorTableNoBase");
        Table t = this.newTable("default", "matnb", false);
        HiveConf conf = new HiveConf();
        this.addDeltaFile(conf, t, null, 1L, 2L, 2);
        this.addDeltaFile(conf, t, null, 3L, 4L, 2);
        this.burnThroughTransactions(5);
        CompactionRequest rqst = new CompactionRequest("default", "matnb", CompactionType.MAJOR);
        this.txnHandler.compact(rqst);
        this.startWorker(new HiveConf());
        ShowCompactResponse rsp = this.txnHandler.showCompact(new ShowCompactRequest());
        List compacts = rsp.getCompacts();
        Assert.assertEquals((int)1, (int)compacts.size());
        Assert.assertEquals((String)"ready for cleaning", (String)((ShowCompactResponseElement)compacts.get(0)).getState());
        FileSystem fs = FileSystem.get((Configuration)conf);
        FileStatus[] stat = fs.listStatus(new Path(t.getSd().getLocation()));
        Assert.assertEquals((int)3, (int)stat.length);
        boolean sawNewBase = false;
        for (int i = 0; i < stat.length; ++i) {
            if (stat[i].getPath().getName().equals("base_0000004")) {
                sawNewBase = true;
                FileStatus[] buckets = fs.listStatus(stat[i].getPath());
                Assert.assertEquals((int)2, (int)buckets.length);
                Assert.assertTrue((boolean)buckets[0].getPath().getName().matches("bucket_0000[01]"));
                Assert.assertTrue((boolean)buckets[1].getPath().getName().matches("bucket_0000[01]"));
                Assert.assertEquals((long)208L, (long)buckets[0].getLen());
                Assert.assertEquals((long)208L, (long)buckets[1].getLen());
                continue;
            }
            LOG.debug((Object)("This is not the file you are looking for " + stat[i].getPath().getName()));
        }
        Assert.assertTrue((boolean)sawNewBase);
    }

    @Test
    public void majorTableLegacy() throws Exception {
        LOG.debug((Object)"Starting majorTableLegacy");
        Table t = this.newTable("default", "matl", false);
        HiveConf conf = new HiveConf();
        this.addLegacyFile(conf, t, null, 20);
        this.addDeltaFile(conf, t, null, 21L, 22L, 2);
        this.addDeltaFile(conf, t, null, 23L, 24L, 2);
        this.burnThroughTransactions(25);
        CompactionRequest rqst = new CompactionRequest("default", "matl", CompactionType.MAJOR);
        this.txnHandler.compact(rqst);
        this.startWorker(new HiveConf());
        ShowCompactResponse rsp = this.txnHandler.showCompact(new ShowCompactRequest());
        List compacts = rsp.getCompacts();
        Assert.assertEquals((int)1, (int)compacts.size());
        Assert.assertEquals((String)"ready for cleaning", (String)((ShowCompactResponseElement)compacts.get(0)).getState());
        FileSystem fs = FileSystem.get((Configuration)conf);
        FileStatus[] stat = fs.listStatus(new Path(t.getSd().getLocation()));
        boolean sawNewBase = false;
        for (int i = 0; i < stat.length; ++i) {
            if (stat[i].getPath().getName().equals("base_0000024")) {
                sawNewBase = true;
                FileStatus[] buckets = fs.listStatus(stat[i].getPath());
                Assert.assertEquals((int)2, (int)buckets.length);
                Assert.assertTrue((boolean)buckets[0].getPath().getName().matches("bucket_0000[01]"));
                Assert.assertTrue((boolean)buckets[1].getPath().getName().matches("bucket_0000[01]"));
                Assert.assertEquals((long)1248L, (long)buckets[0].getLen());
                Assert.assertEquals((long)1248L, (long)buckets[1].getLen());
                continue;
            }
            LOG.debug((Object)("This is not the file you are looking for " + stat[i].getPath().getName()));
        }
        Assert.assertTrue((boolean)sawNewBase);
    }

    @Test
    public void minorTableLegacy() throws Exception {
        LOG.debug((Object)"Starting minorTableLegacy");
        Table t = this.newTable("default", "mtl", false);
        HiveConf conf = new HiveConf();
        this.addLegacyFile(conf, t, null, 20);
        this.addDeltaFile(conf, t, null, 21L, 22L, 2);
        this.addDeltaFile(conf, t, null, 23L, 24L, 2);
        this.burnThroughTransactions(25);
        CompactionRequest rqst = new CompactionRequest("default", "mtl", CompactionType.MINOR);
        this.txnHandler.compact(rqst);
        this.startWorker(new HiveConf());
        ShowCompactResponse rsp = this.txnHandler.showCompact(new ShowCompactRequest());
        List compacts = rsp.getCompacts();
        Assert.assertEquals((int)1, (int)compacts.size());
        Assert.assertEquals((String)"ready for cleaning", (String)((ShowCompactResponseElement)compacts.get(0)).getState());
        FileSystem fs = FileSystem.get((Configuration)conf);
        FileStatus[] stat = fs.listStatus(new Path(t.getSd().getLocation()));
        boolean sawNewDelta = false;
        for (int i = 0; i < stat.length; ++i) {
            if (stat[i].getPath().getName().equals("delta_0000021_0000024")) {
                sawNewDelta = true;
                FileStatus[] buckets = fs.listStatus(stat[i].getPath());
                Assert.assertEquals((int)2, (int)buckets.length);
                Assert.assertTrue((boolean)buckets[0].getPath().getName().matches("bucket_0000[01]"));
                Assert.assertTrue((boolean)buckets[1].getPath().getName().matches("bucket_0000[01]"));
                continue;
            }
            LOG.debug((Object)("This is not the file you are looking for " + stat[i].getPath().getName()));
        }
        Assert.assertTrue((boolean)sawNewDelta);
    }

    @Test
    public void majorPartitionWithBaseMissingBuckets() throws Exception {
        Table t = this.newTable("default", "mapwbmb", true);
        Partition p = this.newPartition(t, "today");
        HiveConf conf = new HiveConf();
        this.addBaseFile(conf, t, p, 20L, 20, 2, false);
        this.addDeltaFile(conf, t, p, 21L, 22L, 2, 2, false);
        this.addDeltaFile(conf, t, p, 23L, 24L, 2);
        this.burnThroughTransactions(25);
        CompactionRequest rqst = new CompactionRequest("default", "mapwbmb", CompactionType.MAJOR);
        rqst.setPartitionname("ds=today");
        this.txnHandler.compact(rqst);
        this.startWorker(new HiveConf());
        ShowCompactResponse rsp = this.txnHandler.showCompact(new ShowCompactRequest());
        List compacts = rsp.getCompacts();
        Assert.assertEquals((int)1, (int)compacts.size());
        Assert.assertEquals((String)"ready for cleaning", (String)((ShowCompactResponseElement)compacts.get(0)).getState());
        FileSystem fs = FileSystem.get((Configuration)conf);
        FileStatus[] stat = fs.listStatus(new Path(p.getSd().getLocation()));
        Assert.assertEquals((int)4, (int)stat.length);
        boolean sawNewBase = false;
        for (int i = 0; i < stat.length; ++i) {
            if (stat[i].getPath().getName().equals("base_0000024")) {
                sawNewBase = true;
                FileStatus[] buckets = fs.listStatus(stat[i].getPath());
                Assert.assertEquals((int)2, (int)buckets.length);
                Assert.assertTrue((boolean)buckets[0].getPath().getName().matches("bucket_0000[01]"));
                Assert.assertTrue((boolean)buckets[1].getPath().getName().matches("bucket_0000[01]"));
                Assert.assertTrue(("bucket_00000".equals(buckets[0].getPath().getName()) && 104L == buckets[0].getLen() && "bucket_00001".equals(buckets[1].getPath().getName()) && 1248L == buckets[1].getLen() || "bucket_00000".equals(buckets[1].getPath().getName()) && 104L == buckets[1].getLen() && "bucket_00001".equals(buckets[0].getPath().getName()) && 1248L == buckets[0].getLen() ? 1 : 0) != 0);
                continue;
            }
            LOG.debug((Object)("This is not the file you are looking for " + stat[i].getPath().getName()));
        }
        Assert.assertTrue((boolean)sawNewBase);
    }

    @Before
    public void setUpTxnDb() throws Exception {
        TxnDbUtil.setConfValues((HiveConf)new HiveConf());
    }
}

