/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.txn.compactor;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import junit.framework.Assert;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.api.AbortTxnRequest;
import org.apache.hadoop.hive.metastore.api.CommitTxnRequest;
import org.apache.hadoop.hive.metastore.api.CompactionRequest;
import org.apache.hadoop.hive.metastore.api.CompactionType;
import org.apache.hadoop.hive.metastore.api.GetOpenTxnsResponse;
import org.apache.hadoop.hive.metastore.api.LockComponent;
import org.apache.hadoop.hive.metastore.api.LockLevel;
import org.apache.hadoop.hive.metastore.api.LockRequest;
import org.apache.hadoop.hive.metastore.api.LockResponse;
import org.apache.hadoop.hive.metastore.api.LockType;
import org.apache.hadoop.hive.metastore.api.Partition;
import org.apache.hadoop.hive.metastore.api.ShowCompactRequest;
import org.apache.hadoop.hive.metastore.api.ShowCompactResponse;
import org.apache.hadoop.hive.metastore.api.ShowCompactResponseElement;
import org.apache.hadoop.hive.metastore.api.Table;
import org.apache.hadoop.hive.metastore.txn.TxnDbUtil;
import org.apache.hadoop.hive.ql.txn.compactor.CompactorTest;
import org.apache.hadoop.hive.ql.txn.compactor.Worker;
import org.junit.Before;
import org.junit.Test;

public class TestInitiator
extends CompactorTest {
    private static final String CLASS_NAME = TestInitiator.class.getName();
    private static final Log LOG = LogFactory.getLog((String)CLASS_NAME);

    @Test
    public void nothing() throws Exception {
        this.startInitiator(new HiveConf());
    }

    @Test
    public void recoverFailedLocalWorkers() throws Exception {
        Table t = this.newTable("default", "rflw1", false);
        CompactionRequest rqst = new CompactionRequest("default", "rflw1", CompactionType.MINOR);
        this.txnHandler.compact(rqst);
        t = this.newTable("default", "rflw2", false);
        rqst = new CompactionRequest("default", "rflw2", CompactionType.MINOR);
        this.txnHandler.compact(rqst);
        this.txnHandler.findNextToCompact(Worker.hostname() + "-193892");
        this.txnHandler.findNextToCompact("nosuchhost-193892");
        this.startInitiator(new HiveConf());
        ShowCompactResponse rsp = this.txnHandler.showCompact(new ShowCompactRequest());
        List compacts = rsp.getCompacts();
        Assert.assertEquals((int)2, (int)compacts.size());
        boolean sawInitiated = false;
        for (ShowCompactResponseElement c : compacts) {
            if (c.getState().equals("working")) {
                Assert.assertEquals((String)"nosuchhost-193892", (String)c.getWorkerid());
                continue;
            }
            if (c.getState().equals("initiated")) {
                sawInitiated = true;
                continue;
            }
            Assert.fail((String)"Unexpected state");
        }
        Assert.assertTrue((boolean)sawInitiated);
    }

    @Test
    public void recoverFailedRemoteWorkers() throws Exception {
        Table t = this.newTable("default", "rfrw1", false);
        CompactionRequest rqst = new CompactionRequest("default", "rfrw1", CompactionType.MINOR);
        this.txnHandler.compact(rqst);
        this.txnHandler.findNextToCompact("nosuchhost-193892");
        HiveConf conf = new HiveConf();
        HiveConf.setLongVar((Configuration)conf, (HiveConf.ConfVars)HiveConf.ConfVars.HIVE_COMPACTOR_WORKER_TIMEOUT, (long)1L);
        this.startInitiator(conf);
        ShowCompactResponse rsp = this.txnHandler.showCompact(new ShowCompactRequest());
        List compacts = rsp.getCompacts();
        Assert.assertEquals((int)1, (int)compacts.size());
        Assert.assertEquals((String)"initiated", (String)((ShowCompactResponseElement)compacts.get(0)).getState());
    }

    @Test
    public void majorCompactOnTableTooManyAborts() throws Exception {
        Table t = this.newTable("default", "mcottma", false);
        HiveConf conf = new HiveConf();
        HiveConf.setIntVar((Configuration)conf, (HiveConf.ConfVars)HiveConf.ConfVars.HIVE_COMPACTOR_ABORTEDTXN_THRESHOLD, (int)10);
        for (int i = 0; i < 11; ++i) {
            long txnid = this.openTxn();
            LockComponent comp = new LockComponent(LockType.SHARED_WRITE, LockLevel.TABLE, "default");
            comp.setTablename("mcottma");
            ArrayList<LockComponent> components = new ArrayList<LockComponent>(1);
            components.add(comp);
            LockRequest req = new LockRequest(components, "me", "localhost");
            req.setTxnid(txnid);
            LockResponse res = this.txnHandler.lock(req);
            this.txnHandler.abortTxn(new AbortTxnRequest(txnid));
        }
        this.startInitiator(conf);
        ShowCompactResponse rsp = this.txnHandler.showCompact(new ShowCompactRequest());
        List compacts = rsp.getCompacts();
        Assert.assertEquals((int)1, (int)compacts.size());
        Assert.assertEquals((String)"initiated", (String)((ShowCompactResponseElement)compacts.get(0)).getState());
        Assert.assertEquals((String)"mcottma", (String)((ShowCompactResponseElement)compacts.get(0)).getTablename());
        Assert.assertEquals((Object)CompactionType.MAJOR, (Object)((ShowCompactResponseElement)compacts.get(0)).getType());
    }

    @Test
    public void majorCompactOnPartitionTooManyAborts() throws Exception {
        Table t = this.newTable("default", "mcoptma", true);
        Partition p = this.newPartition(t, "today");
        HiveConf conf = new HiveConf();
        HiveConf.setIntVar((Configuration)conf, (HiveConf.ConfVars)HiveConf.ConfVars.HIVE_COMPACTOR_ABORTEDTXN_THRESHOLD, (int)10);
        for (int i = 0; i < 11; ++i) {
            long txnid = this.openTxn();
            LockComponent comp = new LockComponent(LockType.SHARED_WRITE, LockLevel.TABLE, "default");
            comp.setTablename("mcoptma");
            comp.setPartitionname("ds=today");
            ArrayList<LockComponent> components = new ArrayList<LockComponent>(1);
            components.add(comp);
            LockRequest req = new LockRequest(components, "me", "localhost");
            req.setTxnid(txnid);
            LockResponse res = this.txnHandler.lock(req);
            this.txnHandler.abortTxn(new AbortTxnRequest(txnid));
        }
        this.startInitiator(conf);
        ShowCompactResponse rsp = this.txnHandler.showCompact(new ShowCompactRequest());
        List compacts = rsp.getCompacts();
        Assert.assertEquals((int)1, (int)compacts.size());
        Assert.assertEquals((String)"initiated", (String)((ShowCompactResponseElement)compacts.get(0)).getState());
        Assert.assertEquals((String)"mcoptma", (String)((ShowCompactResponseElement)compacts.get(0)).getTablename());
        Assert.assertEquals((String)"ds=today", (String)((ShowCompactResponseElement)compacts.get(0)).getPartitionname());
        Assert.assertEquals((Object)CompactionType.MAJOR, (Object)((ShowCompactResponseElement)compacts.get(0)).getType());
    }

    @Test
    public void noCompactOnManyDifferentPartitionAborts() throws Exception {
        Table t = this.newTable("default", "ncomdpa", true);
        for (int i = 0; i < 11; ++i) {
            Partition p = this.newPartition(t, "day-" + i);
        }
        HiveConf conf = new HiveConf();
        HiveConf.setIntVar((Configuration)conf, (HiveConf.ConfVars)HiveConf.ConfVars.HIVE_COMPACTOR_ABORTEDTXN_THRESHOLD, (int)10);
        for (int i = 0; i < 11; ++i) {
            long txnid = this.openTxn();
            LockComponent comp = new LockComponent(LockType.SHARED_WRITE, LockLevel.TABLE, "default");
            comp.setTablename("ncomdpa");
            comp.setPartitionname("ds=day-" + i);
            ArrayList<LockComponent> components = new ArrayList<LockComponent>(1);
            components.add(comp);
            LockRequest req = new LockRequest(components, "me", "localhost");
            req.setTxnid(txnid);
            LockResponse res = this.txnHandler.lock(req);
            this.txnHandler.abortTxn(new AbortTxnRequest(txnid));
        }
        this.startInitiator(conf);
        ShowCompactResponse rsp = this.txnHandler.showCompact(new ShowCompactRequest());
        Assert.assertNull((Object)rsp.getCompacts());
    }

    @Test
    public void cleanEmptyAbortedTxns() throws Exception {
        Table t = this.newTable("default", "ceat", false);
        HiveConf conf = new HiveConf();
        long txnid = this.openTxn();
        LockComponent comp = new LockComponent(LockType.SHARED_WRITE, LockLevel.TABLE, "default");
        comp.setTablename("ceat");
        ArrayList<LockComponent> components = new ArrayList<LockComponent>(1);
        components.add(comp);
        LockRequest req = new LockRequest(components, "me", "localhost");
        req.setTxnid(txnid);
        LockResponse res = this.txnHandler.lock(req);
        this.txnHandler.abortTxn(new AbortTxnRequest(txnid));
        for (int i = 0; i < 100; ++i) {
            txnid = this.openTxn();
            this.txnHandler.abortTxn(new AbortTxnRequest(txnid));
        }
        GetOpenTxnsResponse openTxns = this.txnHandler.getOpenTxns();
        Assert.assertEquals((int)101, (int)openTxns.getOpen_txnsSize());
        this.startInitiator(conf);
        openTxns = this.txnHandler.getOpenTxns();
        Assert.assertEquals((int)1, (int)openTxns.getOpen_txnsSize());
    }

    @Test
    public void noCompactWhenNoCompactSet() throws Exception {
        HashMap<String, String> parameters = new HashMap<String, String>(1);
        parameters.put("NO_AUTO_COMPACTION", "true");
        Table t = this.newTable("default", "ncwncs", false, parameters);
        HiveConf conf = new HiveConf();
        HiveConf.setIntVar((Configuration)conf, (HiveConf.ConfVars)HiveConf.ConfVars.HIVE_COMPACTOR_ABORTEDTXN_THRESHOLD, (int)10);
        for (int i = 0; i < 11; ++i) {
            long txnid = this.openTxn();
            LockComponent comp = new LockComponent(LockType.SHARED_WRITE, LockLevel.TABLE, "default");
            comp.setTablename("ncwncs");
            ArrayList<LockComponent> components = new ArrayList<LockComponent>(1);
            components.add(comp);
            LockRequest req = new LockRequest(components, "me", "localhost");
            req.setTxnid(txnid);
            LockResponse res = this.txnHandler.lock(req);
            this.txnHandler.abortTxn(new AbortTxnRequest(txnid));
        }
        this.startInitiator(conf);
        ShowCompactResponse rsp = this.txnHandler.showCompact(new ShowCompactRequest());
        Assert.assertNull((Object)rsp.getCompacts());
    }

    @Test
    public void noCompactWhenCompactAlreadyScheduled() throws Exception {
        Table t = this.newTable("default", "ncwcas", false);
        HiveConf conf = new HiveConf();
        HiveConf.setIntVar((Configuration)conf, (HiveConf.ConfVars)HiveConf.ConfVars.HIVE_COMPACTOR_ABORTEDTXN_THRESHOLD, (int)10);
        for (int i = 0; i < 11; ++i) {
            long txnid = this.openTxn();
            LockComponent comp = new LockComponent(LockType.SHARED_WRITE, LockLevel.TABLE, "default");
            comp.setTablename("ncwcas");
            ArrayList<LockComponent> components = new ArrayList<LockComponent>(1);
            components.add(comp);
            LockRequest req = new LockRequest(components, "me", "localhost");
            req.setTxnid(txnid);
            LockResponse res = this.txnHandler.lock(req);
            this.txnHandler.abortTxn(new AbortTxnRequest(txnid));
        }
        CompactionRequest rqst = new CompactionRequest("default", "ncwcas", CompactionType.MAJOR);
        this.txnHandler.compact(rqst);
        ShowCompactResponse rsp = this.txnHandler.showCompact(new ShowCompactRequest());
        List compacts = rsp.getCompacts();
        Assert.assertEquals((int)1, (int)compacts.size());
        Assert.assertEquals((String)"initiated", (String)((ShowCompactResponseElement)compacts.get(0)).getState());
        Assert.assertEquals((String)"ncwcas", (String)((ShowCompactResponseElement)compacts.get(0)).getTablename());
        this.startInitiator(conf);
        rsp = this.txnHandler.showCompact(new ShowCompactRequest());
        compacts = rsp.getCompacts();
        Assert.assertEquals((int)1, (int)compacts.size());
        Assert.assertEquals((String)"initiated", (String)((ShowCompactResponseElement)compacts.get(0)).getState());
        Assert.assertEquals((String)"ncwcas", (String)((ShowCompactResponseElement)compacts.get(0)).getTablename());
        Assert.assertEquals((Object)CompactionType.MAJOR, (Object)((ShowCompactResponseElement)compacts.get(0)).getType());
    }

    @Test
    public void compactTableHighDeltaPct() throws Exception {
        Table t = this.newTable("default", "cthdp", false);
        HiveConf conf = new HiveConf();
        this.addBaseFile(conf, t, null, 20L, 20);
        this.addDeltaFile(conf, t, null, 21L, 22L, 2);
        this.addDeltaFile(conf, t, null, 23L, 24L, 2);
        this.burnThroughTransactions(23);
        long txnid = this.openTxn();
        LockComponent comp = new LockComponent(LockType.SHARED_WRITE, LockLevel.TABLE, "default");
        comp.setTablename("cthdp");
        ArrayList<LockComponent> components = new ArrayList<LockComponent>(1);
        components.add(comp);
        LockRequest req = new LockRequest(components, "me", "localhost");
        req.setTxnid(txnid);
        LockResponse res = this.txnHandler.lock(req);
        this.txnHandler.commitTxn(new CommitTxnRequest(txnid));
        this.startInitiator(conf);
        ShowCompactResponse rsp = this.txnHandler.showCompact(new ShowCompactRequest());
        List compacts = rsp.getCompacts();
        Assert.assertEquals((int)1, (int)compacts.size());
        Assert.assertEquals((String)"initiated", (String)((ShowCompactResponseElement)compacts.get(0)).getState());
        Assert.assertEquals((String)"cthdp", (String)((ShowCompactResponseElement)compacts.get(0)).getTablename());
        Assert.assertEquals((Object)CompactionType.MAJOR, (Object)((ShowCompactResponseElement)compacts.get(0)).getType());
    }

    @Test
    public void compactPartitionHighDeltaPct() throws Exception {
        Table t = this.newTable("default", "cphdp", true);
        Partition p = this.newPartition(t, "today");
        HiveConf conf = new HiveConf();
        this.addBaseFile(conf, t, p, 20L, 20);
        this.addDeltaFile(conf, t, p, 21L, 22L, 2);
        this.addDeltaFile(conf, t, p, 23L, 24L, 2);
        this.burnThroughTransactions(23);
        long txnid = this.openTxn();
        LockComponent comp = new LockComponent(LockType.SHARED_WRITE, LockLevel.PARTITION, "default");
        comp.setTablename("cphdp");
        comp.setPartitionname("ds=today");
        ArrayList<LockComponent> components = new ArrayList<LockComponent>(1);
        components.add(comp);
        LockRequest req = new LockRequest(components, "me", "localhost");
        req.setTxnid(txnid);
        LockResponse res = this.txnHandler.lock(req);
        this.txnHandler.commitTxn(new CommitTxnRequest(txnid));
        this.startInitiator(conf);
        ShowCompactResponse rsp = this.txnHandler.showCompact(new ShowCompactRequest());
        List compacts = rsp.getCompacts();
        Assert.assertEquals((int)1, (int)compacts.size());
        Assert.assertEquals((String)"initiated", (String)((ShowCompactResponseElement)compacts.get(0)).getState());
        Assert.assertEquals((String)"cphdp", (String)((ShowCompactResponseElement)compacts.get(0)).getTablename());
        Assert.assertEquals((String)"ds=today", (String)((ShowCompactResponseElement)compacts.get(0)).getPartitionname());
        Assert.assertEquals((Object)CompactionType.MAJOR, (Object)((ShowCompactResponseElement)compacts.get(0)).getType());
    }

    @Test
    public void noCompactTableDeltaPctNotHighEnough() throws Exception {
        Table t = this.newTable("default", "nctdpnhe", false);
        HiveConf conf = new HiveConf();
        this.addBaseFile(conf, t, null, 50L, 50);
        this.addDeltaFile(conf, t, null, 21L, 22L, 2);
        this.addDeltaFile(conf, t, null, 23L, 24L, 2);
        this.burnThroughTransactions(53);
        long txnid = this.openTxn();
        LockComponent comp = new LockComponent(LockType.SHARED_WRITE, LockLevel.TABLE, "default");
        comp.setTablename("nctdpnhe");
        ArrayList<LockComponent> components = new ArrayList<LockComponent>(1);
        components.add(comp);
        LockRequest req = new LockRequest(components, "me", "localhost");
        req.setTxnid(txnid);
        LockResponse res = this.txnHandler.lock(req);
        this.txnHandler.commitTxn(new CommitTxnRequest(txnid));
        this.startInitiator(conf);
        ShowCompactResponse rsp = this.txnHandler.showCompact(new ShowCompactRequest());
        Assert.assertNull((Object)rsp.getCompacts());
    }

    @Test
    public void compactTableTooManyDeltas() throws Exception {
        Table t = this.newTable("default", "cttmd", false);
        HiveConf conf = new HiveConf();
        this.addBaseFile(conf, t, null, 200L, 200);
        this.addDeltaFile(conf, t, null, 201L, 201L, 1);
        this.addDeltaFile(conf, t, null, 202L, 202L, 1);
        this.addDeltaFile(conf, t, null, 203L, 203L, 1);
        this.addDeltaFile(conf, t, null, 204L, 204L, 1);
        this.addDeltaFile(conf, t, null, 205L, 205L, 1);
        this.addDeltaFile(conf, t, null, 206L, 206L, 1);
        this.addDeltaFile(conf, t, null, 207L, 207L, 1);
        this.addDeltaFile(conf, t, null, 208L, 208L, 1);
        this.addDeltaFile(conf, t, null, 209L, 209L, 1);
        this.addDeltaFile(conf, t, null, 210L, 210L, 1);
        this.addDeltaFile(conf, t, null, 211L, 211L, 1);
        this.burnThroughTransactions(210);
        long txnid = this.openTxn();
        LockComponent comp = new LockComponent(LockType.SHARED_WRITE, LockLevel.TABLE, "default");
        comp.setTablename("cttmd");
        ArrayList<LockComponent> components = new ArrayList<LockComponent>(1);
        components.add(comp);
        LockRequest req = new LockRequest(components, "me", "localhost");
        req.setTxnid(txnid);
        LockResponse res = this.txnHandler.lock(req);
        this.txnHandler.commitTxn(new CommitTxnRequest(txnid));
        this.startInitiator(conf);
        ShowCompactResponse rsp = this.txnHandler.showCompact(new ShowCompactRequest());
        List compacts = rsp.getCompacts();
        Assert.assertEquals((int)1, (int)compacts.size());
        Assert.assertEquals((String)"initiated", (String)((ShowCompactResponseElement)compacts.get(0)).getState());
        Assert.assertEquals((String)"cttmd", (String)((ShowCompactResponseElement)compacts.get(0)).getTablename());
        Assert.assertEquals((Object)CompactionType.MINOR, (Object)((ShowCompactResponseElement)compacts.get(0)).getType());
    }

    @Test
    public void compactPartitionTooManyDeltas() throws Exception {
        Table t = this.newTable("default", "cptmd", true);
        Partition p = this.newPartition(t, "today");
        HiveConf conf = new HiveConf();
        this.addBaseFile(conf, t, p, 200L, 200);
        this.addDeltaFile(conf, t, p, 201L, 201L, 1);
        this.addDeltaFile(conf, t, p, 202L, 202L, 1);
        this.addDeltaFile(conf, t, p, 203L, 203L, 1);
        this.addDeltaFile(conf, t, p, 204L, 204L, 1);
        this.addDeltaFile(conf, t, p, 205L, 205L, 1);
        this.addDeltaFile(conf, t, p, 206L, 206L, 1);
        this.addDeltaFile(conf, t, p, 207L, 207L, 1);
        this.addDeltaFile(conf, t, p, 208L, 208L, 1);
        this.addDeltaFile(conf, t, p, 209L, 209L, 1);
        this.addDeltaFile(conf, t, p, 210L, 210L, 1);
        this.addDeltaFile(conf, t, p, 211L, 211L, 1);
        this.burnThroughTransactions(210);
        long txnid = this.openTxn();
        LockComponent comp = new LockComponent(LockType.SHARED_WRITE, LockLevel.PARTITION, "default");
        comp.setTablename("cptmd");
        comp.setPartitionname("ds=today");
        ArrayList<LockComponent> components = new ArrayList<LockComponent>(1);
        components.add(comp);
        LockRequest req = new LockRequest(components, "me", "localhost");
        req.setTxnid(txnid);
        LockResponse res = this.txnHandler.lock(req);
        this.txnHandler.commitTxn(new CommitTxnRequest(txnid));
        this.startInitiator(conf);
        ShowCompactResponse rsp = this.txnHandler.showCompact(new ShowCompactRequest());
        List compacts = rsp.getCompacts();
        Assert.assertEquals((int)1, (int)compacts.size());
        Assert.assertEquals((String)"initiated", (String)((ShowCompactResponseElement)compacts.get(0)).getState());
        Assert.assertEquals((String)"cptmd", (String)((ShowCompactResponseElement)compacts.get(0)).getTablename());
        Assert.assertEquals((String)"ds=today", (String)((ShowCompactResponseElement)compacts.get(0)).getPartitionname());
        Assert.assertEquals((Object)CompactionType.MINOR, (Object)((ShowCompactResponseElement)compacts.get(0)).getType());
    }

    @Test
    public void noCompactTableNotEnoughDeltas() throws Exception {
        Table t = this.newTable("default", "nctned", false);
        HiveConf conf = new HiveConf();
        this.addBaseFile(conf, t, null, 200L, 200);
        this.addDeltaFile(conf, t, null, 201L, 205L, 5);
        this.addDeltaFile(conf, t, null, 206L, 211L, 6);
        this.burnThroughTransactions(210);
        long txnid = this.openTxn();
        LockComponent comp = new LockComponent(LockType.SHARED_WRITE, LockLevel.TABLE, "default");
        comp.setTablename("nctned");
        ArrayList<LockComponent> components = new ArrayList<LockComponent>(1);
        components.add(comp);
        LockRequest req = new LockRequest(components, "me", "localhost");
        req.setTxnid(txnid);
        LockResponse res = this.txnHandler.lock(req);
        this.txnHandler.commitTxn(new CommitTxnRequest(txnid));
        this.startInitiator(conf);
        ShowCompactResponse rsp = this.txnHandler.showCompact(new ShowCompactRequest());
        Assert.assertNull((Object)rsp.getCompacts());
    }

    @Test
    public void chooseMajorOverMinorWhenBothValid() throws Exception {
        Table t = this.newTable("default", "cmomwbv", false);
        HiveConf conf = new HiveConf();
        this.addBaseFile(conf, t, null, 200L, 200);
        this.addDeltaFile(conf, t, null, 201L, 211L, 11);
        this.addDeltaFile(conf, t, null, 212L, 222L, 11);
        this.addDeltaFile(conf, t, null, 223L, 233L, 11);
        this.addDeltaFile(conf, t, null, 234L, 244L, 11);
        this.addDeltaFile(conf, t, null, 245L, 255L, 11);
        this.addDeltaFile(conf, t, null, 256L, 266L, 11);
        this.addDeltaFile(conf, t, null, 267L, 277L, 11);
        this.addDeltaFile(conf, t, null, 278L, 288L, 11);
        this.addDeltaFile(conf, t, null, 289L, 299L, 11);
        this.addDeltaFile(conf, t, null, 300L, 310L, 11);
        this.addDeltaFile(conf, t, null, 311L, 321L, 11);
        this.burnThroughTransactions(320);
        long txnid = this.openTxn();
        LockComponent comp = new LockComponent(LockType.SHARED_WRITE, LockLevel.TABLE, "default");
        comp.setTablename("cmomwbv");
        ArrayList<LockComponent> components = new ArrayList<LockComponent>(1);
        components.add(comp);
        LockRequest req = new LockRequest(components, "me", "localhost");
        req.setTxnid(txnid);
        LockResponse res = this.txnHandler.lock(req);
        this.txnHandler.commitTxn(new CommitTxnRequest(txnid));
        this.startInitiator(conf);
        ShowCompactResponse rsp = this.txnHandler.showCompact(new ShowCompactRequest());
        List compacts = rsp.getCompacts();
        Assert.assertEquals((int)1, (int)compacts.size());
        Assert.assertEquals((String)"initiated", (String)((ShowCompactResponseElement)compacts.get(0)).getState());
        Assert.assertEquals((String)"cmomwbv", (String)((ShowCompactResponseElement)compacts.get(0)).getTablename());
        Assert.assertEquals((Object)CompactionType.MAJOR, (Object)((ShowCompactResponseElement)compacts.get(0)).getType());
    }

    @Test
    public void enoughDeltasNoBase() throws Exception {
        Table t = this.newTable("default", "ednb", true);
        Partition p = this.newPartition(t, "today");
        HiveConf conf = new HiveConf();
        this.addDeltaFile(conf, t, p, 1L, 201L, 200);
        this.addDeltaFile(conf, t, p, 202L, 202L, 1);
        this.addDeltaFile(conf, t, p, 203L, 203L, 1);
        this.addDeltaFile(conf, t, p, 204L, 204L, 1);
        this.addDeltaFile(conf, t, p, 205L, 205L, 1);
        this.addDeltaFile(conf, t, p, 206L, 206L, 1);
        this.addDeltaFile(conf, t, p, 207L, 207L, 1);
        this.addDeltaFile(conf, t, p, 208L, 208L, 1);
        this.addDeltaFile(conf, t, p, 209L, 209L, 1);
        this.addDeltaFile(conf, t, p, 210L, 210L, 1);
        this.addDeltaFile(conf, t, p, 211L, 211L, 1);
        this.burnThroughTransactions(210);
        long txnid = this.openTxn();
        LockComponent comp = new LockComponent(LockType.SHARED_WRITE, LockLevel.PARTITION, "default");
        comp.setTablename("ednb");
        comp.setPartitionname("ds=today");
        ArrayList<LockComponent> components = new ArrayList<LockComponent>(1);
        components.add(comp);
        LockRequest req = new LockRequest(components, "me", "localhost");
        req.setTxnid(txnid);
        LockResponse res = this.txnHandler.lock(req);
        this.txnHandler.commitTxn(new CommitTxnRequest(txnid));
        this.startInitiator(conf);
        ShowCompactResponse rsp = this.txnHandler.showCompact(new ShowCompactRequest());
        List compacts = rsp.getCompacts();
        Assert.assertEquals((int)1, (int)compacts.size());
        Assert.assertEquals((String)"initiated", (String)((ShowCompactResponseElement)compacts.get(0)).getState());
        Assert.assertEquals((String)"ednb", (String)((ShowCompactResponseElement)compacts.get(0)).getTablename());
        Assert.assertEquals((String)"ds=today", (String)((ShowCompactResponseElement)compacts.get(0)).getPartitionname());
        Assert.assertEquals((Object)CompactionType.MAJOR, (Object)((ShowCompactResponseElement)compacts.get(0)).getType());
    }

    @Test
    public void twoTxnsOnSamePartitionGenerateOneCompactionRequest() throws Exception {
        Table t = this.newTable("default", "ttospgocr", true);
        Partition p = this.newPartition(t, "today");
        HiveConf conf = new HiveConf();
        this.addBaseFile(conf, t, p, 20L, 20);
        this.addDeltaFile(conf, t, p, 21L, 22L, 2);
        this.addDeltaFile(conf, t, p, 23L, 24L, 2);
        this.burnThroughTransactions(23);
        long txnid = this.openTxn();
        LockComponent comp = new LockComponent(LockType.SHARED_WRITE, LockLevel.PARTITION, "default");
        comp.setTablename("ttospgocr");
        comp.setPartitionname("ds=today");
        ArrayList<LockComponent> components = new ArrayList<LockComponent>(1);
        components.add(comp);
        LockRequest req = new LockRequest(components, "me", "localhost");
        req.setTxnid(txnid);
        LockResponse res = this.txnHandler.lock(req);
        this.txnHandler.commitTxn(new CommitTxnRequest(txnid));
        txnid = this.openTxn();
        comp = new LockComponent(LockType.SHARED_WRITE, LockLevel.PARTITION, "default");
        comp.setTablename("ttospgocr");
        comp.setPartitionname("ds=today");
        components = new ArrayList(1);
        components.add(comp);
        req = new LockRequest(components, "me", "localhost");
        req.setTxnid(txnid);
        res = this.txnHandler.lock(req);
        this.txnHandler.commitTxn(new CommitTxnRequest(txnid));
        this.startInitiator(conf);
        ShowCompactResponse rsp = this.txnHandler.showCompact(new ShowCompactRequest());
        List compacts = rsp.getCompacts();
        Assert.assertEquals((int)1, (int)compacts.size());
        Assert.assertEquals((String)"initiated", (String)((ShowCompactResponseElement)compacts.get(0)).getState());
        Assert.assertEquals((String)"ttospgocr", (String)((ShowCompactResponseElement)compacts.get(0)).getTablename());
        Assert.assertEquals((String)"ds=today", (String)((ShowCompactResponseElement)compacts.get(0)).getPartitionname());
        Assert.assertEquals((Object)CompactionType.MAJOR, (Object)((ShowCompactResponseElement)compacts.get(0)).getType());
    }

    @Before
    public void setUpTxnDb() throws Exception {
        TxnDbUtil.setConfValues((HiveConf)new HiveConf());
    }
}

