/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.security.authorization.plugin.sqlstd;

import com.google.common.base.Joiner;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.security.HadoopDefaultAuthenticator;
import org.apache.hadoop.hive.ql.security.HiveAuthenticationProvider;
import org.apache.hadoop.hive.ql.security.authorization.plugin.DisallowTransformHook;
import org.apache.hadoop.hive.ql.security.authorization.plugin.HiveAuthzPluginException;
import org.apache.hadoop.hive.ql.security.authorization.plugin.sqlstd.SQLStdHiveAccessController;
import org.junit.Assert;
import org.junit.Test;

public class TestSQLStdHiveAccessController {
    @Test
    public void checkConfigProcessing() throws HiveAuthzPluginException {
        HiveConf processedConf = new HiveConf();
        SQLStdHiveAccessController accessController = new SQLStdHiveAccessController(null, processedConf, (HiveAuthenticationProvider)new HadoopDefaultAuthenticator());
        accessController.applyAuthorizationConfigPolicy(processedConf);
        Assert.assertEquals((String)"only set command should be allowed", (Object)processedConf.getVar(HiveConf.ConfVars.HIVE_SECURITY_COMMAND_WHITELIST), (Object)"set");
        Assert.assertTrue((String)"Check for transform query disabling hook", (boolean)processedConf.getVar(HiveConf.ConfVars.PREEXECHOOKS).contains(DisallowTransformHook.class.getName()));
        this.verifyParamSettability(SQLStdHiveAccessController.defaultModWhiteListSqlStdAuth, processedConf);
    }

    private void verifyParamSettability(String[] settableParams, HiveConf processedConf) {
        for (String string : settableParams) {
            try {
                processedConf.verifyAndSet(string, "dummy");
            }
            catch (IllegalArgumentException e) {
                Assert.fail((String)("Unable to set value for parameter in whitelist " + string + " " + e));
            }
        }
        this.assertConfModificationException(processedConf, "dummy.param");
        for (String string : HiveConf.metaVars) {
            this.assertConfModificationException(processedConf, ((HiveConf.ConfVars)string).varname);
        }
    }

    @Test
    public void checkConfigProcessingCustomSetWhitelist() throws HiveAuthzPluginException {
        HiveConf processedConf = new HiveConf();
        Object[] settableParams = new String[]{SQLStdHiveAccessController.defaultModWhiteListSqlStdAuth[0], "abcs.dummy.test.param"};
        processedConf.setVar(HiveConf.ConfVars.HIVE_AUTHORIZATION_SQL_STD_AUTH_CONFIG_WHITELIST, Joiner.on((String)",").join(settableParams));
        SQLStdHiveAccessController accessController = new SQLStdHiveAccessController(null, processedConf, (HiveAuthenticationProvider)new HadoopDefaultAuthenticator());
        accessController.applyAuthorizationConfigPolicy(processedConf);
        this.verifyParamSettability((String[])settableParams, processedConf);
    }

    private void assertConfModificationException(HiveConf processedConf, String param) {
        boolean caughtEx = false;
        try {
            processedConf.verifyAndSet(param, "dummy");
        }
        catch (IllegalArgumentException e) {
            caughtEx = true;
        }
        Assert.assertTrue((String)("Exception should be thrown while modifying the param " + param), (boolean)caughtEx);
    }
}

