/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.parse;

import java.util.ArrayList;
import java.util.List;
import junit.framework.Assert;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.parse.ASTNode;
import org.apache.hadoop.hive.ql.parse.ParseDriver;
import org.apache.hadoop.hive.ql.parse.ParseException;
import org.apache.hadoop.hive.ql.parse.SemanticAnalyzer;
import org.apache.hadoop.hive.ql.parse.SemanticException;
import org.apache.hadoop.hive.ql.parse.SubQueryUtils;
import org.apache.hadoop.hive.ql.session.SessionState;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;

public class TestQBSubQuery {
    static HiveConf conf;
    private static String IN_QUERY;
    private static String IN_QUERY2;
    private static String QUERY3;
    ParseDriver pd;
    SemanticAnalyzer sA;

    @BeforeClass
    public static void initialize() {
        conf = new HiveConf(SemanticAnalyzer.class);
        SessionState.start((HiveConf)conf);
    }

    @Before
    public void setup() throws SemanticException {
        this.pd = new ParseDriver();
        this.sA = new SemanticAnalyzer(conf);
    }

    ASTNode parse(String query) throws ParseException {
        ASTNode nd = this.pd.parse(query);
        return (ASTNode)nd.getChild(0);
    }

    @Test
    public void testExtractSubQueries() throws Exception {
        ASTNode ast = this.parse(IN_QUERY);
        ASTNode where = this.where(ast);
        List sqs = SubQueryUtils.findSubQueries((ASTNode)((ASTNode)where.getChild(0)));
        Assert.assertEquals((int)sqs.size(), (int)1);
        ASTNode sq = (ASTNode)sqs.get(0);
        Assert.assertEquals((String)sq.toStringTree(), (String)"(TOK_SUBQUERY_EXPR (TOK_SUBQUERY_OP in) (TOK_QUERY (TOK_FROM (TOK_TABREF (TOK_TABNAME src) s1)) (TOK_INSERT (TOK_DESTINATION (TOK_DIR TOK_TMP_FILE)) (TOK_SELECT (TOK_SELEXPR (TOK_TABLE_OR_COL key))) (TOK_WHERE (and (> (. (TOK_TABLE_OR_COL s1) key) '9') (> (. (TOK_TABLE_OR_COL s1) value) '9'))))) (. (TOK_TABLE_OR_COL src) key))");
    }

    @Test
    public void testExtractConjuncts() throws Exception {
        ASTNode ast = this.parse(IN_QUERY);
        ASTNode where = this.where(ast);
        List sqs = SubQueryUtils.findSubQueries((ASTNode)((ASTNode)where.getChild(0)));
        ASTNode sq = (ASTNode)sqs.get(0);
        ASTNode sqWhere = this.where((ASTNode)sq.getChild(1));
        ArrayList conjuncts = new ArrayList();
        SubQueryUtils.extractConjuncts((ASTNode)((ASTNode)sqWhere.getChild(0)), conjuncts);
        Assert.assertEquals((int)conjuncts.size(), (int)2);
        Assert.assertEquals((String)((ASTNode)conjuncts.get(0)).toStringTree(), (String)"(> (. (TOK_TABLE_OR_COL s1) key) '9')");
        Assert.assertEquals((String)((ASTNode)conjuncts.get(1)).toStringTree(), (String)"(> (. (TOK_TABLE_OR_COL s1) value) '9')");
    }

    @Test
    public void testRewriteOuterQueryWhere() throws Exception {
        ASTNode ast = this.parse(IN_QUERY);
        ASTNode where = this.where(ast);
        List sqs = SubQueryUtils.findSubQueries((ASTNode)((ASTNode)where.getChild(0)));
        ASTNode sq = (ASTNode)sqs.get(0);
        ASTNode newWhere = SubQueryUtils.rewriteParentQueryWhere((ASTNode)((ASTNode)where.getChild(0)), (ASTNode)sq);
        Assert.assertEquals((String)newWhere.toStringTree(), (String)"(= 1 1)");
    }

    @Test
    public void testRewriteOuterQueryWhere2() throws Exception {
        ASTNode ast = this.parse(IN_QUERY2);
        ASTNode where = this.where(ast);
        List sqs = SubQueryUtils.findSubQueries((ASTNode)((ASTNode)where.getChild(0)));
        ASTNode sq = (ASTNode)sqs.get(0);
        ASTNode newWhere = SubQueryUtils.rewriteParentQueryWhere((ASTNode)((ASTNode)where.getChild(0)), (ASTNode)sq);
        Assert.assertEquals((String)newWhere.toStringTree(), (String)"(> (TOK_TABLE_OR_COL value) '9')");
    }

    @Test
    public void testCheckAggOrWindowing() throws Exception {
        ASTNode ast = this.parse(QUERY3);
        ASTNode select = this.select(ast);
        Assert.assertEquals((int)SubQueryUtils.checkAggOrWindowing((ASTNode)((ASTNode)select.getChild(0))), (int)0);
        Assert.assertEquals((int)SubQueryUtils.checkAggOrWindowing((ASTNode)((ASTNode)select.getChild(1))), (int)1);
        Assert.assertEquals((int)SubQueryUtils.checkAggOrWindowing((ASTNode)((ASTNode)select.getChild(2))), (int)2);
    }

    private ASTNode where(ASTNode qry) {
        return (ASTNode)qry.getChild(1).getChild(2);
    }

    private ASTNode select(ASTNode qry) {
        return (ASTNode)qry.getChild(1).getChild(1);
    }

    static {
        IN_QUERY = " select * from src where src.key in (select key from src s1 where s1.key > '9' and s1.value > '9') ";
        IN_QUERY2 = " select * from src where src.key in (select key from src s1 where s1.key > '9' and s1.value > '9') and value > '9'";
        QUERY3 = "select p_mfgr, min(p_size), rank() over(partition by p_mfgr) as r from part group by p_mfgr";
    }
}

